/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir.impl;

import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.Unsigned;
import org.llvm.adt.FoldingSetImpl;
import org.llvm.adt.FoldingSetNodeID;
import org.llvm.adt.StringRef;
import org.llvm.ir.Attribute;
import org.llvm.ir.impl.EnumAttributeImpl;
import org.llvm.ir.impl.IntAttributeImpl;
import org.llvm.ir.impl.StringAttributeImpl;
import org.llvm.llvmc.LLVMOpaqueAttributeRef;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;

public class AttributeImpl
extends FoldingSetImpl.NodeImpl
implements FoldingSetImpl.Node,
Destructors.ClassWithDestructor,
LLVMOpaqueAttributeRef {
    private byte KindID;

    protected void $assign(AttributeImpl $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    protected AttributeImpl(AttributeImpl $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    protected AttributeImpl(AttrEntryKind KindID) {
        this.$Node();
        this.KindID = (byte)KindID.getValue();
    }

    public void $destroy() {
        super.$destroy$Node();
    }

    public boolean isEnumAttribute() {
        return Unsigned.$uchar2int((byte)this.KindID) == AttrEntryKind.EnumAttrEntry.getValue();
    }

    public boolean isIntAttribute() {
        return Unsigned.$uchar2int((byte)this.KindID) == AttrEntryKind.IntAttrEntry.getValue();
    }

    public boolean isStringAttribute() {
        return Unsigned.$uchar2int((byte)this.KindID) == AttrEntryKind.StringAttrEntry.getValue();
    }

    public boolean hasAttribute(Attribute.AttrKind A2) {
        if (this.isStringAttribute()) {
            return false;
        }
        return this.getKindAsEnum() == A2;
    }

    public boolean hasAttribute(StringRef Kind2) {
        if (!this.isStringAttribute()) {
            return false;
        }
        return llvm.$eq_StringRef((StringRef)this.getKindAsString(), (StringRef)Kind2);
    }

    public Attribute.AttrKind getKindAsEnum() {
        assert (this.isEnumAttribute() || this.isIntAttribute());
        return ((EnumAttributeImpl)this).getEnumKind();
    }

    public long getValueAsInt() {
        assert (this.isIntAttribute());
        return ((IntAttributeImpl)this).getValue();
    }

    public StringRef getKindAsString() {
        assert (this.isStringAttribute());
        return ((StringAttributeImpl)this).getStringKind();
    }

    public StringRef getValueAsString() {
        assert (this.isStringAttribute());
        return ((StringAttributeImpl)this).getStringValue();
    }

    public boolean $less(AttributeImpl AI) {
        if (this.isEnumAttribute()) {
            if (AI.isEnumAttribute()) {
                return this.getKindAsEnum().getValue() < AI.getKindAsEnum().getValue();
            }
            if (AI.isIntAttribute()) {
                return true;
            }
            if (AI.isStringAttribute()) {
                return true;
            }
        }
        if (this.isIntAttribute()) {
            if (AI.isEnumAttribute()) {
                return false;
            }
            if (AI.isIntAttribute()) {
                if (this.getKindAsEnum() == AI.getKindAsEnum()) {
                    return Unsigned.$less_ulong((long)this.getValueAsInt(), (long)AI.getValueAsInt());
                }
                return this.getKindAsEnum().getValue() < AI.getKindAsEnum().getValue();
            }
            if (AI.isStringAttribute()) {
                return true;
            }
        }
        if (AI.isEnumAttribute()) {
            return false;
        }
        if (AI.isIntAttribute()) {
            return false;
        }
        if (llvm.$eq_StringRef((StringRef)this.getKindAsString(), (StringRef)AI.getKindAsString())) {
            return llvm.$less_StringRef((StringRef)this.getValueAsString(), (StringRef)AI.getValueAsString());
        }
        return llvm.$less_StringRef((StringRef)this.getKindAsString(), (StringRef)AI.getKindAsString());
    }

    public void Profile(FoldingSetNodeID ID2) {
        if (this.isEnumAttribute()) {
            AttributeImpl.Profile(ID2, this.getKindAsEnum(), Unsigned.$int2ulong((int)0));
        } else if (this.isIntAttribute()) {
            AttributeImpl.Profile(ID2, this.getKindAsEnum(), this.getValueAsInt());
        } else {
            AttributeImpl.Profile(ID2, this.getKindAsString(), this.getValueAsString());
        }
    }

    public static void Profile(FoldingSetNodeID ID2, Attribute.AttrKind Kind2, long Val) {
        ID2.AddInteger_int(Kind2.getValue());
        if (Val != 0L) {
            ID2.AddInteger_ullong(Val);
        }
    }

    public static void Profile(FoldingSetNodeID ID2, StringRef Kind2, StringRef Values2) {
        ID2.AddString(new StringRef(Kind2));
        if (!Values2.empty()) {
            ID2.AddString(new StringRef(Values2));
        }
    }

    public static long getAttrMask(Attribute.AttrKind Val) {
        switch (Val) {
            case EndAttrKinds: {
                throw new llvm_unreachable("Synthetic enumerators which should never get here");
            }
            case None: {
                return Unsigned.$int2ulong((int)0);
            }
            case ZExt: {
                return Unsigned.$int2ulong((int)1);
            }
            case SExt: {
                return Unsigned.$int2ulong((int)2);
            }
            case NoReturn: {
                return Unsigned.$int2ulong((int)4);
            }
            case InReg: {
                return Unsigned.$int2ulong((int)8);
            }
            case StructRet: {
                return Unsigned.$int2ulong((int)16);
            }
            case NoUnwind: {
                return Unsigned.$int2ulong((int)32);
            }
            case NoAlias: {
                return Unsigned.$int2ulong((int)64);
            }
            case ByVal: {
                return Unsigned.$int2ulong((int)128);
            }
            case Nest: {
                return Unsigned.$int2ulong((int)256);
            }
            case ReadNone: {
                return Unsigned.$int2ulong((int)512);
            }
            case ReadOnly: {
                return Unsigned.$int2ulong((int)1024);
            }
            case NoInline: {
                return Unsigned.$int2ulong((int)2048);
            }
            case AlwaysInline: {
                return Unsigned.$int2ulong((int)4096);
            }
            case OptimizeForSize: {
                return Unsigned.$int2ulong((int)8192);
            }
            case StackProtect: {
                return Unsigned.$int2ulong((int)16384);
            }
            case StackProtectReq: {
                return Unsigned.$int2ulong((int)32768);
            }
            case Alignment: {
                return Unsigned.$int2ulong((int)0x1F0000);
            }
            case NoCapture: {
                return Unsigned.$int2ulong((int)0x200000);
            }
            case NoRedZone: {
                return Unsigned.$int2ulong((int)0x400000);
            }
            case NoImplicitFloat: {
                return Unsigned.$int2ulong((int)0x800000);
            }
            case Naked: {
                return Unsigned.$int2ulong((int)0x1000000);
            }
            case InlineHint: {
                return Unsigned.$int2ulong((int)0x2000000);
            }
            case StackAlignment: {
                return Unsigned.$int2ulong((int)0x1C000000);
            }
            case ReturnsTwice: {
                return Unsigned.$int2ulong((int)0x20000000);
            }
            case UWTable: {
                return Unsigned.$int2ulong((int)0x40000000);
            }
            case NonLazyBind: {
                return Unsigned.$uint2ulong((int)Integer.MIN_VALUE);
            }
            case SanitizeAddress: {
                return 0x100000000L;
            }
            case MinSize: {
                return 0x200000000L;
            }
            case NoDuplicate: {
                return 0x400000000L;
            }
            case StackProtectStrong: {
                return 0x800000000L;
            }
            case SanitizeThread: {
                return 0x1000000000L;
            }
            case SanitizeMemory: {
                return 0x2000000000L;
            }
            case NoBuiltin: {
                return 0x4000000000L;
            }
            case Returned: {
                return 0x8000000000L;
            }
            case Cold: {
                return 0x10000000000L;
            }
            case Builtin: {
                return 0x20000000000L;
            }
            case OptimizeNone: {
                return 0x40000000000L;
            }
            case InAlloca: {
                return 0x80000000000L;
            }
            case NonNull: {
                return 0x100000000000L;
            }
            case JumpTable: {
                return 0x200000000000L;
            }
            case Convergent: {
                return 0x400000000000L;
            }
            case SafeStack: {
                return 0x800000000000L;
            }
            case NoRecurse: {
                return 0x1000000000000L;
            }
            case InaccessibleMemOnly: {
                return 0x2000000000000L;
            }
            case InaccessibleMemOrArgMemOnly: {
                return 0x4000000000000L;
            }
            case SwiftSelf: {
                return 0x8000000000000L;
            }
            case SwiftError: {
                return 0x10000000000000L;
            }
            case WriteOnly: {
                return 0x20000000000000L;
            }
            case Dereferenceable: {
                throw new llvm_unreachable("dereferenceable attribute not supported in raw format");
            }
            case DereferenceableOrNull: {
                throw new llvm_unreachable("dereferenceable_or_null attribute not supported in raw format");
            }
            case ArgMemOnly: {
                throw new llvm_unreachable("argmemonly attribute not supported in raw format");
            }
            case AllocSize: {
                throw new llvm_unreachable("allocsize not supported in raw format");
            }
        }
        throw new llvm_unreachable("Unsupported attribute type");
    }

    public String toString() {
        return "KindID=" + Unsigned.$uchar2uint((byte)this.KindID) + super.toString();
    }

    protected static final class AttrEntryKind
    extends Enum<AttrEntryKind>
    implements Native.NativeUIntEnum {
        public static final /* enum */ AttrEntryKind EnumAttrEntry = new AttrEntryKind(0);
        public static final /* enum */ AttrEntryKind IntAttrEntry = new AttrEntryKind(EnumAttrEntry.getValue() + 1);
        public static final /* enum */ AttrEntryKind StringAttrEntry = new AttrEntryKind(IntAttrEntry.getValue() + 1);
        private final int value;
        private static final /* synthetic */ AttrEntryKind[] $VALUES;

        public static AttrEntryKind[] values() {
            return (AttrEntryKind[])$VALUES.clone();
        }

        public static AttrEntryKind valueOf(String name) {
            return Enum.valueOf(AttrEntryKind.class, name);
        }

        public static AttrEntryKind valueOf(int val) {
            AttrEntryKind out;
            AttrEntryKind attrEntryKind = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private AttrEntryKind(int val) {
            this.value = val;
        }

        public final int getValue() {
            return this.value;
        }

        static {
            $VALUES = new AttrEntryKind[]{EnumAttrEntry, IntAttrEntry, StringAttrEntry};
        }

        private static final class Values {
            private static final AttrEntryKind[] VALUES;
            private static final AttrEntryKind[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (AttrEntryKind kind : AttrEntryKind.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new AttrEntryKind[min < 0 ? 1 - min : 0];
                VALUES = new AttrEntryKind[max >= 0 ? 1 + max : 0];
                for (AttrEntryKind kind : AttrEntryKind.values()) {
                    if (kind.value < 0) {
                        if (_VALUES[-kind.value] != null) continue;
                        Values._VALUES[-((AttrEntryKind)kind).value] = kind;
                        continue;
                    }
                    if (VALUES[kind.value] != null) continue;
                    Values.VALUES[((AttrEntryKind)kind).value] = kind;
                }
            }
        }
    }
}

