/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir.impl;

import java.util.Iterator;
import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.java.std_ptr;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.NativeType;
import org.clank.support.Unsigned;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.clank.support.void;
import org.llvm.adt.APFloat;
import org.llvm.adt.APInt;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.ArrayRefUInt;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.ir.Argument;
import org.llvm.ir.AtomicRMWInst;
import org.llvm.ir.BasicBlock;
import org.llvm.ir.BlockAddress;
import org.llvm.ir.CallInst;
import org.llvm.ir.CmpInst;
import org.llvm.ir.Comdat;
import org.llvm.ir.Constant;
import org.llvm.ir.ConstantAggregate;
import org.llvm.ir.ConstantArray;
import org.llvm.ir.ConstantDataArray;
import org.llvm.ir.ConstantDataSequential;
import org.llvm.ir.ConstantExpr;
import org.llvm.ir.ConstantFP;
import org.llvm.ir.ConstantInt;
import org.llvm.ir.ConstantStruct;
import org.llvm.ir.DIBasicType;
import org.llvm.ir.DICompileUnit;
import org.llvm.ir.DICompositeType;
import org.llvm.ir.DIDerivedType;
import org.llvm.ir.DIEnumerator;
import org.llvm.ir.DIExpression;
import org.llvm.ir.DIFile;
import org.llvm.ir.DIGlobalVariable;
import org.llvm.ir.DIImportedEntity;
import org.llvm.ir.DILexicalBlock;
import org.llvm.ir.DILexicalBlockFile;
import org.llvm.ir.DILocalVariable;
import org.llvm.ir.DILocation;
import org.llvm.ir.DIMacro;
import org.llvm.ir.DIMacroFile;
import org.llvm.ir.DIModule;
import org.llvm.ir.DINamespace;
import org.llvm.ir.DIObjCProperty;
import org.llvm.ir.DISubprogram;
import org.llvm.ir.DISubrange;
import org.llvm.ir.DISubroutineType;
import org.llvm.ir.DITemplateTypeParameter;
import org.llvm.ir.DITemplateValueParameter;
import org.llvm.ir.FPMathOperator;
import org.llvm.ir.Function;
import org.llvm.ir.GEPOperator;
import org.llvm.ir.GenericDINode;
import org.llvm.ir.GlobalAlias;
import org.llvm.ir.GlobalIFunc;
import org.llvm.ir.GlobalObject;
import org.llvm.ir.GlobalValue;
import org.llvm.ir.GlobalVariable;
import org.llvm.ir.InlineAsm;
import org.llvm.ir.Instruction;
import org.llvm.ir.MDNode;
import org.llvm.ir.MDOperand;
import org.llvm.ir.MDString;
import org.llvm.ir.MDTuple;
import org.llvm.ir.Metadata;
import org.llvm.ir.MetadataAsValue;
import org.llvm.ir.Module$IR;
import org.llvm.ir.ModuleSlotTracker;
import org.llvm.ir.OverflowingBinaryOperator;
import org.llvm.ir.PossiblyExactOperator;
import org.llvm.ir.Type;
import org.llvm.ir.Use;
import org.llvm.ir.UseListOrder;
import org.llvm.ir.User;
import org.llvm.ir.Value;
import org.llvm.ir.ValueAsMetadata;
import org.llvm.ir.impl.FieldSeparator;
import org.llvm.ir.impl.MDFieldPrinter;
import org.llvm.ir.impl.OrderMap;
import org.llvm.ir.impl.PrefixType;
import org.llvm.ir.impl.SlotTracker;
import org.llvm.ir.impl.TypePrinting;
import org.llvm.ir.java.IrRTTI;
import org.llvm.pass.IrLlvmGlobals;
import org.llvm.support.AdtsupportLlvmGlobals;
import org.llvm.support.dwarf.DwarfGlobals;
import org.llvm.support.formatted_raw_ostream;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;
import org.llvm.support.raw_ostream;
import org.llvm.support.raw_svector_ostream;

public final class AsmWriterStatics {
    public static void orderValue(Value V, OrderMap OM) {
        if (OM.lookup((Value)V).first != 0) {
            return;
        }
        Constant C2 = IrRTTI.dyn_cast_Constant(V);
        if (C2 != null && C2.getNumOperands() != 0 && !IrRTTI.isa_GlobalValue(C2)) {
            for (Use U : C2.operands$Const()) {
                Value Op = U.get();
                if (IrRTTI.isa_BasicBlock(Op) || IrRTTI.isa_GlobalValue(Op)) continue;
                AsmWriterStatics.orderValue(Op, OM);
            }
        }
        OM.index(V);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OrderMap orderModule(Module$IR M) {
        OrderMap OM = null;
        try {
            OM = new OrderMap();
            for (GlobalVariable G : M.globals$Const()) {
                if (G.hasInitializer() && !IrRTTI.isa_GlobalValue(G.getInitializer$Const())) {
                    AsmWriterStatics.orderValue(G.getInitializer$Const(), OM);
                }
                AsmWriterStatics.orderValue((Value)Native.$AddrOf((Object)G), OM);
            }
            for (GlobalAlias A2 : M.aliases$Const()) {
                if (!IrRTTI.isa_GlobalValue(A2.getAliasee$Const())) {
                    AsmWriterStatics.orderValue(A2.getAliasee$Const(), OM);
                }
                AsmWriterStatics.orderValue((Value)Native.$AddrOf((Object)A2), OM);
            }
            for (GlobalIFunc I : M.ifuncs$Const()) {
                if (!IrRTTI.isa_GlobalValue(I.getResolver$Const())) {
                    AsmWriterStatics.orderValue(I.getResolver$Const(), OM);
                }
                AsmWriterStatics.orderValue((Value)Native.$AddrOf((Object)I), OM);
            }
            for (Function F : (Module$IR)Native.$Deref((Object)M)) {
                for (Use U : F.operands$Const()) {
                    if (IrRTTI.isa_GlobalValue(U.get())) continue;
                    AsmWriterStatics.orderValue(U.get(), OM);
                }
                AsmWriterStatics.orderValue((Value)Native.$AddrOf((Object)F), OM);
                if (F.isDeclaration()) continue;
                for (Argument A3 : F.args$Const()) {
                    AsmWriterStatics.orderValue((Value)Native.$AddrOf((Object)A3), OM);
                }
                for (BasicBlock BB : F) {
                    AsmWriterStatics.orderValue((Value)Native.$AddrOf((Object)BB), OM);
                    for (Instruction I : BB) {
                        for (Use U : I.operands$Const()) {
                            Value Op = U.get();
                            if ((!IrRTTI.isa_Constant((Value)Native.$Deref((Object)Op)) || IrRTTI.isa_GlobalValue((Value)Native.$Deref((Object)Op))) && !IrRTTI.isa_InlineAsm((Value)Native.$Deref((Object)Op))) continue;
                            AsmWriterStatics.orderValue(Op, OM);
                        }
                        AsmWriterStatics.orderValue((Value)Native.$AddrOf((Object)I), OM);
                    }
                }
            }
            OrderMap orderMap = new OrderMap(JavaDifferentiators.JD.Move.INSTANCE, OM);
            return orderMap;
        }
        finally {
            if (OM != null) {
                OM.$destroy();
            }
        }
    }

    public static void predictValueUseListOrderImpl(Value V, Function F, int ID2, OrderMap OM, std.vector<UseListOrder> Stack) {
        SmallVector List2 = new SmallVector(64, (Object)new std_pair.pairPtrUInt());
        for (Use U : V.uses$Const()) {
            if (OM.lookup((Value)U.getUser()).first == 0) continue;
            List2.push_back((Object)std.make_pair_Ptr_uint((Object)((Use)Native.$AddrOf((Object)U)), (int)List2.size()));
        }
        if (Unsigned.$less_uint((int)List2.size(), (int)2)) {
            return;
        }
        boolean GetsReversed = !IrRTTI.isa_GlobalVariable(V) && !IrRTTI.isa_Function(V) && !IrRTTI.isa_BasicBlock(V);
        BlockAddress BA = IrRTTI.dyn_cast_BlockAddress(V);
        if (BA != null) {
            ID2 = OM.lookup((Value)BA.getBasicBlock()).first;
        }
        int ID_final = ID2;
        std.sort((type.iterator)List2.begin(), (type.iterator)List2.end(), (L, R) -> {
            Use LU = (Use)L.first;
            Use RU = (Use)R.first;
            if (Native.$eq_ptr((Object)LU, (Object)RU)) {
                return false;
            }
            int LID = OM.lookup((Value)LU.getUser()).first;
            int RID = OM.lookup((Value)RU.getUser()).first;
            if (Unsigned.$less_uint((int)LID, (int)RID)) {
                return GetsReversed && Unsigned.$lesseq_uint((int)RID, (int)ID_final);
            }
            if (Unsigned.$less_uint((int)RID, (int)LID)) {
                return !GetsReversed || !Unsigned.$lesseq_uint((int)LID, (int)ID_final);
            }
            if (GetsReversed && Unsigned.$lesseq_uint((int)LID, (int)ID_final)) {
                return Unsigned.$less_uint((int)LU.getOperandNo(), (int)RU.getOperandNo());
            }
            return Unsigned.$greater_uint((int)LU.getOperandNo(), (int)RU.getOperandNo());
        });
        if (std.is_sorted((type.iterator)List2.begin(), (type.iterator)List2.end(), (L, R) -> Unsigned.$less_uint((int)L.second, (int)R.second))) {
            return;
        }
        Stack.emplace_back((Object)new UseListOrder(V, F, List2.size()));
        assert (List2.size() == ((UseListOrder)Stack.back()).Shuffle.size()) : "Wrong size";
        int E = List2.size();
        for (int I = 0; I != E; ++I) {
            ((UseListOrder)Stack.back()).Shuffle.$set(I, ((std_pair.pairPtrUInt)List2.$at((int)I)).second);
        }
    }

    public static void predictValueUseListOrder(Value V, Function F, OrderMap OM, std.vector<UseListOrder> Stack) {
        Constant C2;
        std_pair.pairUIntBool IDPair = OM.$at(V);
        assert (IDPair.first != 0) : "Unmapped value";
        if (IDPair.second) {
            return;
        }
        IDPair.second = true;
        if (!V.use_empty() && ((Value.use_iterator_impl)std.next(V.use_begin$Const())).$noteq(V.use_end$Const())) {
            AsmWriterStatics.predictValueUseListOrderImpl(V, F, IDPair.first, OM, Stack);
        }
        if ((C2 = IrRTTI.dyn_cast_Constant(V)) != null && C2.getNumOperands() != 0) {
            for (Use U : C2.operands$Const()) {
                Value Op = U.get();
                if (!IrRTTI.isa_Constant(Op)) continue;
                AsmWriterStatics.predictValueUseListOrder(Op, F, OM, Stack);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static std.vector<UseListOrder> predictUseListOrder(Module$IR M) {
        OrderMap OM = null;
        std.vector Stack = null;
        try {
            OM = AsmWriterStatics.orderModule(M);
            Stack = new std.vector((Object)new UseListOrder());
            for (Function F : llvm.make_range(M.rbegin$Const(), M.rend$Const())) {
                if (F.isDeclaration()) continue;
                for (BasicBlock BB : F) {
                    AsmWriterStatics.predictValueUseListOrder((Value)Native.$AddrOf((Object)BB), (Function)Native.$AddrOf((Object)F), OM, (std.vector<UseListOrder>)Stack);
                }
                for (Argument A2 : F.args$Const()) {
                    AsmWriterStatics.predictValueUseListOrder((Value)Native.$AddrOf((Object)A2), (Function)Native.$AddrOf((Object)F), OM, (std.vector<UseListOrder>)Stack);
                }
                for (BasicBlock BB : F) {
                    for (Instruction I : BB) {
                        for (Use U : I.operands$Const()) {
                            Value Op = U.get();
                            if (!IrRTTI.isa_Constant((Value)Native.$Deref((Object)Op)) && !IrRTTI.isa_InlineAsm((Value)Native.$Deref((Object)Op))) continue;
                            AsmWriterStatics.predictValueUseListOrder(Op, (Function)Native.$AddrOf((Object)F), OM, (std.vector<UseListOrder>)Stack);
                        }
                    }
                }
                for (BasicBlock BB : F) {
                    for (Instruction I : BB) {
                        AsmWriterStatics.predictValueUseListOrder((Value)Native.$AddrOf((Object)I), (Function)Native.$AddrOf((Object)F), OM, (std.vector<UseListOrder>)Stack);
                    }
                }
            }
            for (GlobalVariable G : M.globals$Const()) {
                AsmWriterStatics.predictValueUseListOrder((Value)Native.$AddrOf((Object)G), null, OM, (std.vector<UseListOrder>)Stack);
            }
            for (Function F : (Module$IR)Native.$Deref((Object)M)) {
                AsmWriterStatics.predictValueUseListOrder((Value)Native.$AddrOf((Object)F), null, OM, (std.vector<UseListOrder>)Stack);
            }
            for (GlobalAlias A3 : M.aliases$Const()) {
                AsmWriterStatics.predictValueUseListOrder((Value)Native.$AddrOf((Object)A3), null, OM, (std.vector<UseListOrder>)Stack);
            }
            for (GlobalIFunc I : M.ifuncs$Const()) {
                AsmWriterStatics.predictValueUseListOrder((Value)Native.$AddrOf((Object)I), null, OM, (std.vector<UseListOrder>)Stack);
            }
            for (GlobalVariable G : M.globals$Const()) {
                if (!G.hasInitializer()) continue;
                AsmWriterStatics.predictValueUseListOrder(G.getInitializer$Const(), null, OM, (std.vector<UseListOrder>)Stack);
            }
            for (GlobalAlias A3 : M.aliases$Const()) {
                AsmWriterStatics.predictValueUseListOrder(A3.getAliasee$Const(), null, OM, (std.vector<UseListOrder>)Stack);
            }
            for (GlobalIFunc I : M.ifuncs$Const()) {
                AsmWriterStatics.predictValueUseListOrder(I.getResolver$Const(), null, OM, (std.vector<UseListOrder>)Stack);
            }
            for (Function F : (Module$IR)Native.$Deref((Object)M)) {
                for (Use U : F.operands$Const()) {
                    AsmWriterStatics.predictValueUseListOrder(U.get(), null, OM, (std.vector<UseListOrder>)Stack);
                }
            }
            std.vector vector2 = new std.vector(JavaDifferentiators.JD.Move.INSTANCE, Stack);
            return vector2;
        }
        finally {
            if (Stack != null) {
                Stack.$destroy();
            }
            if (OM != null) {
                OM.$destroy();
            }
        }
    }

    public static Module$IR getModuleFromVal(Value V) {
        Argument MA = IrRTTI.dyn_cast_Argument(V);
        if (MA != null) {
            return MA.getParent$Const() != null ? MA.getParent$Const().getParent$Const() : null;
        }
        BasicBlock BB = IrRTTI.dyn_cast_BasicBlock(V);
        if (BB != null) {
            return BB.getParent$Const() != null ? BB.getParent$Const().getParent$Const() : null;
        }
        Instruction I = IrRTTI.dyn_cast_Instruction(V);
        if (I != null) {
            Function M = I.getParent$Const() != null ? I.getParent$Const().getParent$Const() : null;
            return M != null ? M.getParent$Const() : null;
        }
        GlobalValue GV = IrRTTI.dyn_cast_GlobalValue(V);
        if (GV != null) {
            return GV.getParent$Const();
        }
        MetadataAsValue MAV = IrRTTI.dyn_cast_MetadataAsValue(V);
        if (MAV != null) {
            for (User U : MAV.users$Const()) {
                Module$IR M;
                if (!IrRTTI.isa_Instruction(U) || (M = AsmWriterStatics.getModuleFromVal(U)) == null) continue;
                return M;
            }
            return null;
        }
        return null;
    }

    public static void PrintCallingConv(int cc, raw_ostream Out) {
        switch (cc) {
            default: {
                Out.$out("cc").$out_uint(cc);
                break;
            }
            case 8: {
                Out.$out("fastcc");
                break;
            }
            case 9: {
                Out.$out("coldcc");
                break;
            }
            case 12: {
                Out.$out("webkit_jscc");
                break;
            }
            case 13: {
                Out.$out("anyregcc");
                break;
            }
            case 14: {
                Out.$out("preserve_mostcc");
                break;
            }
            case 15: {
                Out.$out("preserve_allcc");
                break;
            }
            case 17: {
                Out.$out("cxx_fast_tlscc");
                break;
            }
            case 10: {
                Out.$out("ghccc");
                break;
            }
            case 64: {
                Out.$out("x86_stdcallcc");
                break;
            }
            case 65: {
                Out.$out("x86_fastcallcc");
                break;
            }
            case 70: {
                Out.$out("x86_thiscallcc");
                break;
            }
            case 80: {
                Out.$out("x86_vectorcallcc");
                break;
            }
            case 77: {
                Out.$out("intel_ocl_bicc");
                break;
            }
            case 66: {
                Out.$out("arm_apcscc");
                break;
            }
            case 67: {
                Out.$out("arm_aapcscc");
                break;
            }
            case 68: {
                Out.$out("arm_aapcs_vfpcc");
                break;
            }
            case 69: {
                Out.$out("msp430_intrcc");
                break;
            }
            case 84: {
                Out.$out("avr_intrcc ");
                break;
            }
            case 85: {
                Out.$out("avr_signalcc ");
                break;
            }
            case 71: {
                Out.$out("ptx_kernel");
                break;
            }
            case 72: {
                Out.$out("ptx_device");
                break;
            }
            case 78: {
                Out.$out("x86_64_sysvcc");
                break;
            }
            case 79: {
                Out.$out("x86_64_win64cc");
                break;
            }
            case 75: {
                Out.$out("spir_func");
                break;
            }
            case 76: {
                Out.$out("spir_kernel");
                break;
            }
            case 16: {
                Out.$out("swiftcc");
                break;
            }
            case 83: {
                Out.$out("x86_intrcc");
                break;
            }
            case 81: {
                Out.$out("hhvmcc");
                break;
            }
            case 82: {
                Out.$out("hhvm_ccc");
                break;
            }
            case 87: {
                Out.$out("amdgpu_vs");
                break;
            }
            case 88: {
                Out.$out("amdgpu_gs");
                break;
            }
            case 89: {
                Out.$out("amdgpu_ps");
                break;
            }
            case 90: {
                Out.$out("amdgpu_cs");
                break;
            }
            case 91: {
                Out.$out("amdgpu_kernel");
            }
        }
    }

    public static void PrintEscapedString(StringRef Name, raw_ostream Out) {
        int e = Name.size();
        for (int i = 0; i != e; ++i) {
            byte C2 = Name.$at(i);
            if (std.isprint((int)Unsigned.$uchar2int((byte)C2)) != 0 && Unsigned.$uchar2int((byte)C2) != 92 && Unsigned.$uchar2int((byte)C2) != 34) {
                Out.$out_uchar(C2);
                continue;
            }
            Out.$out_char((byte)92).$out_char(llvm.hexdigit((int)(Unsigned.$uchar2int((byte)C2) >> 4))).$out_char(llvm.hexdigit((int)(Unsigned.$uchar2int((byte)C2) & 0xF)));
        }
    }

    public static void PrintLLVMName(raw_ostream OS, StringRef Name, PrefixType Prefix) {
        switch (Prefix) {
            case NoPrefix: {
                break;
            }
            case GlobalPrefix: {
                OS.$out_char((byte)64);
                break;
            }
            case ComdatPrefix: {
                OS.$out_char((byte)36);
                break;
            }
            case LabelPrefix: {
                break;
            }
            case LocalPrefix: {
                OS.$out_char((byte)37);
            }
        }
        IrLlvmGlobals.printLLVMNameWithoutPrefix(OS, new StringRef(Name));
    }

    public static void PrintLLVMName(raw_ostream OS, Value V) {
        AsmWriterStatics.PrintLLVMName(OS, V.getName(), IrRTTI.isa_GlobalValue(V) ? PrefixType.GlobalPrefix : PrefixType.LocalPrefix);
    }

    public static SlotTracker createSlotTracker(Value V) {
        Argument FA = IrRTTI.dyn_cast_Argument(V);
        if (FA != null) {
            return new SlotTracker(FA.getParent$Const());
        }
        Instruction I = IrRTTI.dyn_cast_Instruction(V);
        if (I != null && I.getParent$Const() != null) {
            return new SlotTracker(I.getParent$Const().getParent$Const());
        }
        BasicBlock BB = IrRTTI.dyn_cast_BasicBlock(V);
        if (BB != null) {
            return new SlotTracker(BB.getParent$Const());
        }
        GlobalVariable GV = IrRTTI.dyn_cast_GlobalVariable(V);
        if (GV != null) {
            return new SlotTracker(GV.getParent$Const());
        }
        GlobalAlias GA = IrRTTI.dyn_cast_GlobalAlias(V);
        if (GA != null) {
            return new SlotTracker(GA.getParent$Const());
        }
        GlobalIFunc GIF = IrRTTI.dyn_cast_GlobalIFunc(V);
        if (GIF != null) {
            return new SlotTracker(GIF.getParent$Const());
        }
        Function Func = IrRTTI.dyn_cast_Function(V);
        if (Func != null) {
            return new SlotTracker(Func);
        }
        return null;
    }

    public static void WriteAsOperandInternal(raw_ostream Out, Value V, TypePrinting TypePrinter, SlotTracker Machine, Module$IR Context) {
        int Slot;
        if (V.hasName()) {
            AsmWriterStatics.PrintLLVMName(Out, V);
            return;
        }
        Constant CV = IrRTTI.dyn_cast_Constant(V);
        if (CV != null && !IrRTTI.isa_GlobalValue(CV)) {
            assert (TypePrinter != null) : "Constants require TypePrinting!";
            AsmWriterStatics.WriteConstantInternal(Out, CV, (TypePrinting)Native.$Deref((Object)TypePrinter), Machine, Context);
            return;
        }
        InlineAsm IA = IrRTTI.dyn_cast_InlineAsm(V);
        if (IA != null) {
            Out.$out("asm ");
            if (IA.hasSideEffects()) {
                Out.$out("sideeffect ");
            }
            if (IA.isAlignStack()) {
                Out.$out("alignstack ");
            }
            if (IA.getDialect() == InlineAsm.AsmDialect.AD_Intel) {
                Out.$out("inteldialect ");
            }
            Out.$out_char((byte)34);
            AsmWriterStatics.PrintEscapedString(new StringRef(IA.getAsmString()), Out);
            Out.$out("\", \"");
            AsmWriterStatics.PrintEscapedString(new StringRef(IA.getConstraintString()), Out);
            Out.$out_char((byte)34);
            return;
        }
        MetadataAsValue MD = IrRTTI.dyn_cast_MetadataAsValue(V);
        if (MD != null) {
            AsmWriterStatics.WriteAsOperandInternal(Out, MD.getMetadata(), TypePrinter, Machine, Context, true);
            return;
        }
        int Prefix = 37;
        if (Machine != null) {
            GlobalValue GV = IrRTTI.dyn_cast_GlobalValue(V);
            if (GV != null) {
                Slot = Machine.getGlobalSlot(GV);
                Prefix = 64;
            } else {
                Slot = Machine.getLocalSlot(V);
                if (Slot == -1 && (Machine = AsmWriterStatics.createSlotTracker(V)) != null) {
                    Slot = Machine.getLocalSlot(V);
                    Destructors.$destroy((Destructors.ClassWithDestructor)Machine);
                }
            }
        } else {
            Machine = AsmWriterStatics.createSlotTracker(V);
            if (Machine != null) {
                GlobalValue GV = IrRTTI.dyn_cast_GlobalValue(V);
                if (GV != null) {
                    Slot = Machine.getGlobalSlot(GV);
                    Prefix = 64;
                } else {
                    Slot = Machine.getLocalSlot(V);
                }
                Destructors.$destroy((Destructors.ClassWithDestructor)Machine);
                Machine = null;
            } else {
                Slot = -1;
            }
        }
        if (Slot != -1) {
            Out.$out_char((byte)Prefix).$out_int(Slot);
        } else {
            Out.$out("<badref>");
        }
    }

    public static void WriteAsOperandInternal(raw_ostream Out, Metadata MD, TypePrinting TypePrinter, SlotTracker Machine, Module$IR Context) {
        AsmWriterStatics.WriteAsOperandInternal(Out, MD, TypePrinter, Machine, Context, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void WriteAsOperandInternal(raw_ostream Out, Metadata MD, TypePrinting TypePrinter, SlotTracker Machine, Module$IR Context, boolean FromValue) {
        MDNode N = IrRTTI.dyn_cast_MDNode(MD);
        if (N != null) {
            std_ptr.unique_ptr MachineStorage = null;
            try {
                int Slot;
                MachineStorage = new std_ptr.unique_ptr();
                if (Machine == null) {
                    JavaCleaner $c$ = Native.$createJavaCleaner();
                    try {
                        $c$.clean((Object)MachineStorage.$assignMove($c$.track(llvm.make_unique((Object)new SlotTracker(Context)))));
                        Machine = (SlotTracker)MachineStorage.get();
                    }
                    finally {
                        $c$.$destroy();
                    }
                }
                if ((Slot = Machine.getMetadataSlot(N)) == -1) {
                    Out.$out(NativePointer.$LT).$out((Object)N).$out(NativePointer.$GT);
                } else {
                    Out.$out_char((byte)33).$out_int(Slot);
                }
                return;
            }
            finally {
                if (MachineStorage != null) {
                    MachineStorage.$destroy();
                }
            }
        }
        MDString MDS = IrRTTI.dyn_cast_MDString(MD);
        if (MDS != null) {
            Out.$out("!\"");
            AsmWriterStatics.PrintEscapedString(MDS.getString(), Out);
            Out.$out_char((byte)34);
            return;
        }
        ValueAsMetadata V = IrRTTI.cast_ValueAsMetadata(MD);
        assert (TypePrinter != null) : "TypePrinter required for metadata values";
        assert (FromValue || !IrRTTI.isa_LocalAsMetadata(V)) : "Unexpected function-local metadata outside of value argument";
        TypePrinter.print(V.getValue().getType(), Out);
        Out.$out_char((byte)32);
        AsmWriterStatics.WriteAsOperandInternal(Out, V.getValue(), TypePrinter, Machine, Context);
    }

    public static char.ptr getPredicateText(int predicate) {
        char.ptr pred = NativePointer.$unknown;
        switch (CmpInst.Predicate.valueOf(predicate)) {
            case FCMP_FALSE: {
                pred = NativePointer.$false;
                break;
            }
            case FCMP_OEQ: {
                pred = NativePointer.$((String)"oeq");
                break;
            }
            case FCMP_OGT: {
                pred = NativePointer.$((String)"ogt");
                break;
            }
            case FCMP_OGE: {
                pred = NativePointer.$((String)"oge");
                break;
            }
            case FCMP_OLT: {
                pred = NativePointer.$((String)"olt");
                break;
            }
            case FCMP_OLE: {
                pred = NativePointer.$((String)"ole");
                break;
            }
            case FCMP_ONE: {
                pred = NativePointer.$((String)"one");
                break;
            }
            case FCMP_ORD: {
                pred = NativePointer.$((String)"ord");
                break;
            }
            case FCMP_UNO: {
                pred = NativePointer.$((String)"uno");
                break;
            }
            case FCMP_UEQ: {
                pred = NativePointer.$((String)"ueq");
                break;
            }
            case FCMP_UGT: {
                pred = NativePointer.$((String)"ugt");
                break;
            }
            case FCMP_UGE: {
                pred = NativePointer.$((String)"uge");
                break;
            }
            case FCMP_ULT: {
                pred = NativePointer.$((String)"ult");
                break;
            }
            case FCMP_ULE: {
                pred = NativePointer.$((String)"ule");
                break;
            }
            case FCMP_UNE: {
                pred = NativePointer.$((String)"une");
                break;
            }
            case FCMP_TRUE: {
                pred = NativePointer.$true;
                break;
            }
            case ICMP_EQ: {
                pred = NativePointer.$((String)"eq");
                break;
            }
            case ICMP_NE: {
                pred = NativePointer.$((String)"ne");
                break;
            }
            case ICMP_SGT: {
                pred = NativePointer.$((String)"sgt");
                break;
            }
            case ICMP_SGE: {
                pred = NativePointer.$((String)"sge");
                break;
            }
            case ICMP_SLT: {
                pred = NativePointer.$((String)"slt");
                break;
            }
            case ICMP_SLE: {
                pred = NativePointer.$((String)"sle");
                break;
            }
            case ICMP_UGT: {
                pred = NativePointer.$((String)"ugt");
                break;
            }
            case ICMP_UGE: {
                pred = NativePointer.$((String)"uge");
                break;
            }
            case ICMP_ULT: {
                pred = NativePointer.$((String)"ult");
                break;
            }
            case ICMP_ULE: {
                pred = NativePointer.$((String)"ule");
            }
        }
        return pred;
    }

    public static void writeAtomicRMWOperation(raw_ostream Out, AtomicRMWInst.BinOp Op) {
        switch (Op) {
            default: {
                Out.$out(" <unknown operation ").$out_int(Op.getValue()).$out(NativePointer.$GT);
                break;
            }
            case Xchg: {
                Out.$out(" xchg");
                break;
            }
            case Add: {
                Out.$out(" add");
                break;
            }
            case Sub: {
                Out.$out(" sub");
                break;
            }
            case And: {
                Out.$out(" and");
                break;
            }
            case Nand: {
                Out.$out(" nand");
                break;
            }
            case Or: {
                Out.$out(" or");
                break;
            }
            case Xor: {
                Out.$out(" xor");
                break;
            }
            case Max: {
                Out.$out(" max");
                break;
            }
            case Min: {
                Out.$out(" min");
                break;
            }
            case UMax: {
                Out.$out(" umax");
                break;
            }
            case UMin: {
                Out.$out(" umin");
            }
        }
    }

    public static void WriteOptimizationInfo(raw_ostream Out, User U) {
        OverflowingBinaryOperator OBO;
        FPMathOperator FPO = IrRTTI.dyn_cast_FPMathOperator(U);
        if (FPO != null) {
            if (FPO.hasUnsafeAlgebra()) {
                Out.$out(" fast");
            } else {
                if (FPO.hasNoNaNs()) {
                    Out.$out(" nnan");
                }
                if (FPO.hasNoInfs()) {
                    Out.$out(" ninf");
                }
                if (FPO.hasNoSignedZeros()) {
                    Out.$out(" nsz");
                }
                if (FPO.hasAllowReciprocal()) {
                    Out.$out(" arcp");
                }
            }
        }
        if ((OBO = IrRTTI.dyn_cast_OverflowingBinaryOperator(U)) != null) {
            if (OBO.hasNoUnsignedWrap()) {
                Out.$out(" nuw");
            }
            if (OBO.hasNoSignedWrap()) {
                Out.$out(" nsw");
            }
        } else {
            PossiblyExactOperator Div = IrRTTI.dyn_cast_PossiblyExactOperator(U);
            if (Div != null) {
                if (Div.isExact()) {
                    Out.$out(" exact");
                }
            } else {
                GEPOperator GEP = IrRTTI.dyn_cast_GEPOperator(U);
                if (GEP != null && GEP.isInBounds()) {
                    Out.$out(" inbounds");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void WriteConstantInternal(raw_ostream Out, Constant CV, TypePrinting TypePrinter, SlotTracker Machine, Module$IR Context) {
        ConstantInt CI = IrRTTI.dyn_cast_ConstantInt(CV);
        if (CI != null) {
            if (CI.getType().isIntegerTy(1)) {
                Out.$out(CI.getZExtValue() != 0L ? NativePointer.$true : NativePointer.$false);
                return;
            }
            AdtsupportLlvmGlobals.$out_raw_ostream_APInt$C((raw_ostream)Out, (APInt)CI.getValue());
            return;
        }
        ConstantFP CFP = IrRTTI.dyn_cast_ConstantFP(CV);
        if (CFP != null) {
            if (Native.$AddrOf((Object)CFP.getValueAPF().getSemantics()) == Native.$AddrOf((Object)APFloat.IEEEsingle) || Native.$AddrOf((Object)CFP.getValueAPF().getSemantics()) == Native.$AddrOf((Object)APFloat.IEEEdouble)) {
                bool.ptr ignored = NativePointer.create_bool$ptr();
                boolean isDouble = Native.$AddrOf((Object)CFP.getValueAPF().getSemantics()) == Native.$AddrOf((Object)APFloat.IEEEdouble);
                boolean isInf = CFP.getValueAPF().isInfinity();
                boolean isNaN = CFP.getValueAPF().isNaN();
                if (!isInf && !isNaN) {
                    JavaCleaner $c$ = Native.$createJavaCleaner();
                    try {
                        double Val = isDouble ? CFP.getValueAPF().convertToDouble() : (double)CFP.getValueAPF().convertToFloat();
                        SmallString StrVal = new SmallString(128);
                        $c$.clean((Object)((raw_svector_ostream)$c$.track((Object)new raw_svector_ostream(StrVal))).$out_double(Val));
                        if ((StrVal.$at(0) >= 48 && StrVal.$at(0) <= 57 || (StrVal.$at(0) == 45 || StrVal.$at(0) == 43) && StrVal.$at(1) >= 48 && StrVal.$at(1) <= 57) && new APFloat(APFloat.IEEEdouble, StrVal.$StringRef()).convertToDouble() == Val) {
                            Out.$out(StrVal);
                            return;
                        }
                    }
                    finally {
                        $c$.$destroy();
                    }
                }
                std.static_assert((NativeType.$sizeof_Double() == NativeType.$sizeof_ULong() ? 1 : 0) != 0, (char.ptr)NativePointer.$((String)"assuming that double is 64 bits!"));
                APFloat apf = new APFloat(CFP.getValueAPF());
                if (!isDouble) {
                    apf.convert(APFloat.IEEEdouble, APFloat.roundingMode.rmNearestTiesToEven, (bool.ptr)Native.$AddrOf((Object)ignored));
                }
                Out.$out(AdtsupportLlvmGlobals.format_hex((long)apf.bitcastToAPInt().getZExtValue(), (int)0, (boolean)true));
                return;
            }
            Out.$out("0x");
            APInt API = CFP.getValueAPF().bitcastToAPInt();
            if (Native.$AddrOf((Object)CFP.getValueAPF().getSemantics()) == Native.$AddrOf((Object)APFloat.x87DoubleExtended)) {
                Out.$out_char((byte)75);
                Out.$out(AdtsupportLlvmGlobals.format_hex_no_prefix((long)API.getHiBits(16).getZExtValue(), (int)4, (boolean)true));
                Out.$out(AdtsupportLlvmGlobals.format_hex_no_prefix((long)API.getLoBits(64).getZExtValue(), (int)16, (boolean)true));
                return;
            }
            if (Native.$AddrOf((Object)CFP.getValueAPF().getSemantics()) == Native.$AddrOf((Object)APFloat.IEEEquad)) {
                Out.$out_char((byte)76);
                Out.$out(AdtsupportLlvmGlobals.format_hex_no_prefix((long)API.getLoBits(64).getZExtValue(), (int)16, (boolean)true));
                Out.$out(AdtsupportLlvmGlobals.format_hex_no_prefix((long)API.getHiBits(64).getZExtValue(), (int)16, (boolean)true));
            } else if (Native.$AddrOf((Object)CFP.getValueAPF().getSemantics()) == Native.$AddrOf((Object)APFloat.PPCDoubleDouble)) {
                Out.$out_char((byte)77);
                Out.$out(AdtsupportLlvmGlobals.format_hex_no_prefix((long)API.getLoBits(64).getZExtValue(), (int)16, (boolean)true));
                Out.$out(AdtsupportLlvmGlobals.format_hex_no_prefix((long)API.getHiBits(64).getZExtValue(), (int)16, (boolean)true));
            } else if (Native.$AddrOf((Object)CFP.getValueAPF().getSemantics()) == Native.$AddrOf((Object)APFloat.IEEEhalf)) {
                Out.$out_char((byte)72);
                Out.$out(AdtsupportLlvmGlobals.format_hex_no_prefix((long)API.getZExtValue(), (int)4, (boolean)true));
            } else {
                throw new llvm_unreachable("Unsupported floating point type");
            }
            return;
        }
        if (IrRTTI.isa_ConstantAggregateZero(CV)) {
            Out.$out("zeroinitializer");
            return;
        }
        BlockAddress BA = IrRTTI.dyn_cast_BlockAddress(CV);
        if (BA != null) {
            Out.$out("blockaddress(");
            AsmWriterStatics.WriteAsOperandInternal(Out, BA.getFunction(), (TypePrinting)Native.$AddrOf((Object)TypePrinter), Machine, Context);
            Out.$out(NativePointer.$COMMA_SPACE);
            AsmWriterStatics.WriteAsOperandInternal(Out, BA.getBasicBlock(), (TypePrinting)Native.$AddrOf((Object)TypePrinter), Machine, Context);
            Out.$out(NativePointer.$RPAREN);
            return;
        }
        Constant CA = IrRTTI.dyn_cast_ConstantArray(CV);
        if (CA != null) {
            Type ETy = ((ConstantArray)CA).getType().getElementType();
            Out.$out_char((byte)91);
            TypePrinter.print(ETy, Out);
            Out.$out_char((byte)32);
            AsmWriterStatics.WriteAsOperandInternal(Out, ((ConstantAggregate)CA).getOperand(0), (TypePrinting)Native.$AddrOf((Object)TypePrinter), Machine, Context);
            int e = ((ConstantAggregate)CA).getNumOperands();
            for (int i = 1; i != e; ++i) {
                Out.$out(NativePointer.$COMMA_SPACE);
                TypePrinter.print(ETy, Out);
                Out.$out_char((byte)32);
                AsmWriterStatics.WriteAsOperandInternal(Out, ((ConstantAggregate)CA).getOperand(i), (TypePrinting)Native.$AddrOf((Object)TypePrinter), Machine, Context);
            }
            Out.$out_char((byte)93);
            return;
        }
        CA = IrRTTI.dyn_cast_ConstantDataArray(CV);
        if (CA != null) {
            if (((ConstantDataSequential)CA).isString()) {
                Out.$out("c\"");
                AsmWriterStatics.PrintEscapedString(((ConstantDataSequential)CA).getAsString(), Out);
                Out.$out_char((byte)34);
                return;
            }
            Type ETy = ((ConstantDataArray)CA).getType().getElementType();
            Out.$out_char((byte)91);
            TypePrinter.print(ETy, Out);
            Out.$out_char((byte)32);
            AsmWriterStatics.WriteAsOperandInternal(Out, ((ConstantDataSequential)CA).getElementAsConstant(0), (TypePrinting)Native.$AddrOf((Object)TypePrinter), Machine, Context);
            int e = ((ConstantDataSequential)CA).getNumElements();
            for (int i = 1; i != e; ++i) {
                Out.$out(NativePointer.$COMMA_SPACE);
                TypePrinter.print(ETy, Out);
                Out.$out_char((byte)32);
                AsmWriterStatics.WriteAsOperandInternal(Out, ((ConstantDataSequential)CA).getElementAsConstant(i), (TypePrinting)Native.$AddrOf((Object)TypePrinter), Machine, Context);
            }
            Out.$out_char((byte)93);
            return;
        }
        ConstantStruct CS = IrRTTI.dyn_cast_ConstantStruct(CV);
        if (CS != null) {
            if (CS.getType().isPacked()) {
                Out.$out_char((byte)60);
            }
            Out.$out_char((byte)123);
            int N = CS.getNumOperands();
            if (N != 0) {
                Out.$out_char((byte)32);
                TypePrinter.print(CS.getOperand(0).getType(), Out);
                Out.$out_char((byte)32);
                AsmWriterStatics.WriteAsOperandInternal(Out, CS.getOperand(0), (TypePrinting)Native.$AddrOf((Object)TypePrinter), Machine, Context);
                int i = 1;
                while (Unsigned.$less_uint((int)i, (int)N)) {
                    Out.$out(NativePointer.$COMMA_SPACE);
                    TypePrinter.print(CS.getOperand(i).getType(), Out);
                    Out.$out_char((byte)32);
                    AsmWriterStatics.WriteAsOperandInternal(Out, CS.getOperand(i), (TypePrinting)Native.$AddrOf((Object)TypePrinter), Machine, Context);
                    ++i;
                }
                Out.$out_char((byte)32);
            }
            Out.$out_char((byte)125);
            if (CS.getType().isPacked()) {
                Out.$out_char((byte)62);
            }
            return;
        }
        if (IrRTTI.isa_ConstantVector(CV) || IrRTTI.isa_ConstantDataVector(CV)) {
            Type ETy = CV.getType().getVectorElementType();
            Out.$out_char((byte)60);
            TypePrinter.print(ETy, Out);
            Out.$out_char((byte)32);
            AsmWriterStatics.WriteAsOperandInternal(Out, CV.getAggregateElement(0), (TypePrinting)Native.$AddrOf((Object)TypePrinter), Machine, Context);
            int e = CV.getType().getVectorNumElements();
            for (int i = 1; i != e; ++i) {
                Out.$out(NativePointer.$COMMA_SPACE);
                TypePrinter.print(ETy, Out);
                Out.$out_char((byte)32);
                AsmWriterStatics.WriteAsOperandInternal(Out, CV.getAggregateElement(i), (TypePrinting)Native.$AddrOf((Object)TypePrinter), Machine, Context);
            }
            Out.$out_char((byte)62);
            return;
        }
        if (IrRTTI.isa_ConstantPointerNull(CV)) {
            Out.$out("null");
            return;
        }
        if (IrRTTI.isa_ConstantTokenNone(CV)) {
            Out.$out("none");
            return;
        }
        if (IrRTTI.isa_UndefValue(CV)) {
            Out.$out(NativePointer.$undef);
            return;
        }
        ConstantExpr CE = IrRTTI.dyn_cast_ConstantExpr(CV);
        if (CE != null) {
            Out.$out(CE.getOpcodeName());
            AsmWriterStatics.WriteOptimizationInfo(Out, CE);
            if (CE.isCompare()) {
                Out.$out_char((byte)32).$out(AsmWriterStatics.getPredicateText(CE.getPredicate()));
            }
            Out.$out(" (");
            GEPOperator GEP = IrRTTI.dyn_cast_GEPOperator(CE);
            if (GEP != null) {
                TypePrinter.print(GEP.getSourceElementType(), Out);
                Out.$out(NativePointer.$COMMA_SPACE);
            }
            type.ptr OI = (type.ptr)Native.$tryClone(CE.op_begin$Const());
            while (Native.$noteq_ptr((void.ptr)OI, CE.op_end$Const())) {
                TypePrinter.print(((Use)OI.$star()).$arrow$Const().getType(), Out);
                Out.$out_char((byte)32);
                AsmWriterStatics.WriteAsOperandInternal(Out, ((Use)OI.$star()).$Value$P(), (TypePrinting)Native.$AddrOf((Object)TypePrinter), Machine, Context);
                if (Native.$noteq_ptr((void.ptr)((void.ptr)OI.$add(1)), CE.op_end$Const())) {
                    Out.$out(NativePointer.$COMMA_SPACE);
                }
                OI.$preInc();
            }
            if (CE.hasIndices()) {
                ArrayRefUInt Indices = CE.getIndices();
                int e = Indices.size();
                for (int i = 0; i != e; ++i) {
                    Out.$out(NativePointer.$COMMA_SPACE).$out_uint(Indices.$at(i));
                }
            }
            if (CE.isCast()) {
                Out.$out(" to ");
                TypePrinter.print(CE.getType(), Out);
            }
            Out.$out_char((byte)41);
            return;
        }
        Out.$out("<placeholder or erroneous Constant>");
    }

    public static void writeMDTuple(raw_ostream Out, MDTuple Node2, TypePrinting TypePrinter, SlotTracker Machine, Module$IR Context) {
        Out.$out("!{");
        int me = Node2.getNumOperands();
        for (int mi = 0; mi != me; ++mi) {
            Metadata MD = Node2.getOperand(mi).$Metadata$P();
            if (MD == null) {
                Out.$out("null");
            } else {
                ValueAsMetadata MDV = IrRTTI.dyn_cast_ValueAsMetadata(MD);
                if (MDV != null) {
                    Value V = MDV.getValue();
                    TypePrinter.print(V.getType(), Out);
                    Out.$out_char((byte)32);
                    AsmWriterStatics.WriteAsOperandInternal(Out, V, TypePrinter, Machine, Context);
                } else {
                    AsmWriterStatics.WriteAsOperandInternal(Out, MD, TypePrinter, Machine, Context);
                }
            }
            if (mi + 1 == me) continue;
            Out.$out(NativePointer.$COMMA_SPACE);
        }
        Out.$out(NativePointer.$RCURLY);
    }

    public static raw_ostream $out_raw_ostream_FieldSeparator(raw_ostream OS, FieldSeparator FS) {
        if (FS.Skip) {
            FS.Skip = false;
            return OS;
        }
        return OS.$out(FS.Sep);
    }

    public static void writeMetadataAsOperand(raw_ostream Out, Metadata MD, TypePrinting TypePrinter, SlotTracker Machine, Module$IR Context) {
        if (MD == null) {
            Out.$out("null");
            return;
        }
        AsmWriterStatics.WriteAsOperandInternal(Out, MD, TypePrinter, Machine, Context);
    }

    public static void writeGenericDINode(raw_ostream Out, GenericDINode N, TypePrinting TypePrinter, SlotTracker Machine, Module$IR Context) {
        Out.$out("!GenericDINode(");
        MDFieldPrinter Printer = new MDFieldPrinter(Out, TypePrinter, Machine, Context);
        Printer.printTag(N);
        Printer.printString(new StringRef("header"), N.getHeader());
        if (N.getNumDwarfOperands() != 0) {
            AsmWriterStatics.$out_raw_ostream_FieldSeparator(Out, Printer.FS).$out("operands: {");
            FieldSeparator IFS = new FieldSeparator();
            for (MDOperand I : N.dwarf_operands()) {
                AsmWriterStatics.$out_raw_ostream_FieldSeparator(Out, IFS);
                AsmWriterStatics.writeMetadataAsOperand(Out, I.$Metadata$P(), TypePrinter, Machine, Context);
            }
            Out.$out(NativePointer.$RCURLY);
        }
        Out.$out(NativePointer.$RPAREN);
    }

    public static void writeDILocation(raw_ostream Out, DILocation DL, TypePrinting TypePrinter, SlotTracker Machine, Module$IR Context) {
        Out.$out("!DILocation(");
        MDFieldPrinter Printer = new MDFieldPrinter(Out, TypePrinter, Machine, Context);
        Printer.printInt$UInt(new StringRef(NativePointer.$line), DL.getLine(), false);
        Printer.printInt$UInt(new StringRef("column"), DL.getColumn());
        Printer.printMetadata(new StringRef("scope"), DL.getRawScope(), false);
        Printer.printMetadata(new StringRef("inlinedAt"), DL.getRawInlinedAt());
        Out.$out(NativePointer.$RPAREN);
    }

    public static void writeDISubrange(raw_ostream Out, DISubrange N, TypePrinting $Prm2, SlotTracker $Prm3, Module$IR $Prm4) {
        Out.$out("!DISubrange(");
        MDFieldPrinter Printer = new MDFieldPrinter(Out);
        Printer.printInt$LLong(new StringRef("count"), N.getCount(), false);
        Printer.printInt$LLong(new StringRef("lowerBound"), N.getLowerBound());
        Out.$out(NativePointer.$RPAREN);
    }

    public static void writeDIEnumerator(raw_ostream Out, DIEnumerator N, TypePrinting $Prm2, SlotTracker $Prm3, Module$IR $Prm4) {
        Out.$out("!DIEnumerator(");
        MDFieldPrinter Printer = new MDFieldPrinter(Out);
        Printer.printString(new StringRef("name"), N.getName(), false);
        Printer.printInt$LLong(new StringRef("value"), N.getValue(), false);
        Out.$out(NativePointer.$RPAREN);
    }

    public static void writeDIBasicType(raw_ostream Out, DIBasicType N, TypePrinting $Prm2, SlotTracker $Prm3, Module$IR $Prm4) {
        Out.$out("!DIBasicType(");
        MDFieldPrinter Printer = new MDFieldPrinter(Out);
        if (N.getTag() != Unsigned.$ushort2uint((char)'$')) {
            Printer.printTag(N);
        }
        Printer.printString(new StringRef("name"), N.getName());
        Printer.printInt$LLong(new StringRef("size"), N.getSizeInBits());
        Printer.printInt$LLong(new StringRef("align"), N.getAlignInBits());
        Printer.printDwarfEnum$UInt(new StringRef("encoding"), N.getEncoding(), DwarfGlobals::AttributeEncodingString);
        Out.$out(NativePointer.$RPAREN);
    }

    public static void writeDIDerivedType(raw_ostream Out, DIDerivedType N, TypePrinting TypePrinter, SlotTracker Machine, Module$IR Context) {
        Out.$out("!DIDerivedType(");
        MDFieldPrinter Printer = new MDFieldPrinter(Out, TypePrinter, Machine, Context);
        Printer.printTag(N);
        Printer.printString(new StringRef("name"), N.getName());
        Printer.printMetadata(new StringRef("scope"), N.getRawScope());
        Printer.printMetadata(new StringRef("file"), N.getRawFile());
        Printer.printInt$UInt(new StringRef(NativePointer.$line), N.getLine());
        Printer.printMetadata(new StringRef("baseType"), N.getRawBaseType(), false);
        Printer.printInt$ULLong(new StringRef("size"), N.getSizeInBits());
        Printer.printInt$ULLong(new StringRef("align"), N.getAlignInBits());
        Printer.printInt$ULLong(new StringRef("offset"), N.getOffsetInBits());
        Printer.printDIFlags(new StringRef("flags"), N.getFlags());
        Printer.printMetadata(new StringRef("extraData"), N.getRawExtraData());
        Out.$out(NativePointer.$RPAREN);
    }

    public static void writeDICompositeType(raw_ostream Out, DICompositeType N, TypePrinting TypePrinter, SlotTracker Machine, Module$IR Context) {
        Out.$out("!DICompositeType(");
        MDFieldPrinter Printer = new MDFieldPrinter(Out, TypePrinter, Machine, Context);
        Printer.printTag(N);
        Printer.printString(new StringRef("name"), N.getName());
        Printer.printMetadata(new StringRef("scope"), N.getRawScope());
        Printer.printMetadata(new StringRef("file"), N.getRawFile());
        Printer.printInt$UInt(new StringRef(NativePointer.$line), N.getLine());
        Printer.printMetadata(new StringRef("baseType"), N.getRawBaseType());
        Printer.printInt$ULLong(new StringRef("size"), N.getSizeInBits());
        Printer.printInt$ULLong(new StringRef("align"), N.getAlignInBits());
        Printer.printInt$ULLong(new StringRef("offset"), N.getOffsetInBits());
        Printer.printDIFlags(new StringRef("flags"), N.getFlags());
        Printer.printMetadata(new StringRef("elements"), N.getRawElements());
        Printer.printDwarfEnum$UInt(new StringRef("runtimeLang"), N.getRuntimeLang(), DwarfGlobals::LanguageString);
        Printer.printMetadata(new StringRef("vtableHolder"), N.getRawVTableHolder());
        Printer.printMetadata(new StringRef("templateParams"), N.getRawTemplateParams());
        Printer.printString(new StringRef(NativePointer.$identifier), N.getIdentifier());
        Out.$out(NativePointer.$RPAREN);
    }

    public static void writeDISubroutineType(raw_ostream Out, DISubroutineType N, TypePrinting TypePrinter, SlotTracker Machine, Module$IR Context) {
        Out.$out("!DISubroutineType(");
        MDFieldPrinter Printer = new MDFieldPrinter(Out, TypePrinter, Machine, Context);
        Printer.printDIFlags(new StringRef("flags"), N.getFlags());
        Printer.printDwarfEnum$UChar(new StringRef("cc"), N.getCC(), DwarfGlobals::ConventionString);
        Printer.printMetadata(new StringRef("types"), N.getRawTypeArray(), false);
        Out.$out(NativePointer.$RPAREN);
    }

    public static void writeDIFile(raw_ostream Out, DIFile N, TypePrinting $Prm2, SlotTracker $Prm3, Module$IR $Prm4) {
        Out.$out("!DIFile(");
        MDFieldPrinter Printer = new MDFieldPrinter(Out);
        Printer.printString(new StringRef("filename"), N.getFilename(), false);
        Printer.printString(new StringRef("directory"), N.getDirectory(), false);
        Out.$out(NativePointer.$RPAREN);
    }

    public static void writeDICompileUnit(raw_ostream Out, DICompileUnit N, TypePrinting TypePrinter, SlotTracker Machine, Module$IR Context) {
        Out.$out("!DICompileUnit(");
        MDFieldPrinter Printer = new MDFieldPrinter(Out, TypePrinter, Machine, Context);
        Printer.printDwarfEnum$UInt(new StringRef("language"), N.getSourceLanguage(), DwarfGlobals::LanguageString, false);
        Printer.printMetadata(new StringRef("file"), N.getRawFile(), false);
        Printer.printString(new StringRef("producer"), N.getProducer());
        Printer.printBool(new StringRef("isOptimized"), N.isOptimized());
        Printer.printString(new StringRef("flags"), N.getFlags());
        Printer.printInt$UInt(new StringRef("runtimeVersion"), N.getRuntimeVersion(), false);
        Printer.printString(new StringRef("splitDebugFilename"), N.getSplitDebugFilename());
        Printer.printEmissionKind(new StringRef("emissionKind"), N.getEmissionKind());
        Printer.printMetadata(new StringRef("enums"), N.getRawEnumTypes());
        Printer.printMetadata(new StringRef("retainedTypes"), N.getRawRetainedTypes());
        Printer.printMetadata(new StringRef("globals"), N.getRawGlobalVariables());
        Printer.printMetadata(new StringRef("imports"), N.getRawImportedEntities());
        Printer.printMetadata(new StringRef("macros"), N.getRawMacros());
        Printer.printInt$ULLong(new StringRef("dwoId"), N.getDWOId());
        Out.$out(NativePointer.$RPAREN);
    }

    public static void writeDISubprogram(raw_ostream Out, DISubprogram N, TypePrinting TypePrinter, SlotTracker Machine, Module$IR Context) {
        Out.$out("!DISubprogram(");
        MDFieldPrinter Printer = new MDFieldPrinter(Out, TypePrinter, Machine, Context);
        Printer.printString(new StringRef("name"), N.getName());
        Printer.printString(new StringRef("linkageName"), N.getLinkageName());
        Printer.printMetadata(new StringRef("scope"), N.getRawScope(), false);
        Printer.printMetadata(new StringRef("file"), N.getRawFile());
        Printer.printInt$UInt(new StringRef(NativePointer.$line), N.getLine());
        Printer.printMetadata(new StringRef("type"), N.getRawType());
        Printer.printBool(new StringRef("isLocal"), N.isLocalToUnit());
        Printer.printBool(new StringRef("isDefinition"), N.isDefinition());
        Printer.printInt$UInt(new StringRef("scopeLine"), N.getScopeLine());
        Printer.printMetadata(new StringRef("containingType"), N.getRawContainingType());
        Printer.printDwarfEnum$UInt(new StringRef("virtuality"), N.getVirtuality(), DwarfGlobals::VirtualityString);
        if (N.getVirtuality() != 0 || N.getVirtualIndex() != 0) {
            Printer.printInt$UInt(new StringRef("virtualIndex"), N.getVirtualIndex(), false);
        }
        Printer.printInt$Int(new StringRef("thisAdjustment"), N.getThisAdjustment());
        Printer.printDIFlags(new StringRef("flags"), N.getFlags());
        Printer.printBool(new StringRef("isOptimized"), N.isOptimized());
        Printer.printMetadata(new StringRef("unit"), N.getRawUnit());
        Printer.printMetadata(new StringRef("templateParams"), N.getRawTemplateParams());
        Printer.printMetadata(new StringRef("declaration"), N.getRawDeclaration());
        Printer.printMetadata(new StringRef("variables"), N.getRawVariables());
        Out.$out(NativePointer.$RPAREN);
    }

    public static void writeDILexicalBlock(raw_ostream Out, DILexicalBlock N, TypePrinting TypePrinter, SlotTracker Machine, Module$IR Context) {
        Out.$out("!DILexicalBlock(");
        MDFieldPrinter Printer = new MDFieldPrinter(Out, TypePrinter, Machine, Context);
        Printer.printMetadata(new StringRef("scope"), N.getRawScope(), false);
        Printer.printMetadata(new StringRef("file"), N.getRawFile());
        Printer.printInt$UInt(new StringRef(NativePointer.$line), N.getLine());
        Printer.printInt$UInt(new StringRef("column"), N.getColumn());
        Out.$out(NativePointer.$RPAREN);
    }

    public static void writeDILexicalBlockFile(raw_ostream Out, DILexicalBlockFile N, TypePrinting TypePrinter, SlotTracker Machine, Module$IR Context) {
        Out.$out("!DILexicalBlockFile(");
        MDFieldPrinter Printer = new MDFieldPrinter(Out, TypePrinter, Machine, Context);
        Printer.printMetadata(new StringRef("scope"), N.getRawScope(), false);
        Printer.printMetadata(new StringRef("file"), N.getRawFile());
        Printer.printInt$UInt(new StringRef("discriminator"), N.getDiscriminator(), false);
        Out.$out(NativePointer.$RPAREN);
    }

    public static void writeDINamespace(raw_ostream Out, DINamespace N, TypePrinting TypePrinter, SlotTracker Machine, Module$IR Context) {
        Out.$out("!DINamespace(");
        MDFieldPrinter Printer = new MDFieldPrinter(Out, TypePrinter, Machine, Context);
        Printer.printString(new StringRef("name"), N.getName());
        Printer.printMetadata(new StringRef("scope"), N.getRawScope(), false);
        Printer.printMetadata(new StringRef("file"), N.getRawFile());
        Printer.printInt$UInt(new StringRef(NativePointer.$line), N.getLine());
        Out.$out(NativePointer.$RPAREN);
    }

    public static void writeDIMacro(raw_ostream Out, DIMacro N, TypePrinting TypePrinter, SlotTracker Machine, Module$IR Context) {
        Out.$out("!DIMacro(");
        MDFieldPrinter Printer = new MDFieldPrinter(Out, TypePrinter, Machine, Context);
        Printer.printMacinfoType(N);
        Printer.printInt$UInt(new StringRef(NativePointer.$line), N.getLine());
        Printer.printString(new StringRef("name"), N.getName());
        Printer.printString(new StringRef("value"), N.getValue());
        Out.$out(NativePointer.$RPAREN);
    }

    public static void writeDIMacroFile(raw_ostream Out, DIMacroFile N, TypePrinting TypePrinter, SlotTracker Machine, Module$IR Context) {
        Out.$out("!DIMacroFile(");
        MDFieldPrinter Printer = new MDFieldPrinter(Out, TypePrinter, Machine, Context);
        Printer.printInt$UInt(new StringRef(NativePointer.$line), N.getLine());
        Printer.printMetadata(new StringRef("file"), N.getRawFile(), false);
        Printer.printMetadata(new StringRef("nodes"), N.getRawElements());
        Out.$out(NativePointer.$RPAREN);
    }

    public static void writeDIModule(raw_ostream Out, DIModule N, TypePrinting TypePrinter, SlotTracker Machine, Module$IR Context) {
        Out.$out("!DIModule(");
        MDFieldPrinter Printer = new MDFieldPrinter(Out, TypePrinter, Machine, Context);
        Printer.printMetadata(new StringRef("scope"), N.getRawScope(), false);
        Printer.printString(new StringRef("name"), N.getName());
        Printer.printString(new StringRef("configMacros"), N.getConfigurationMacros());
        Printer.printString(new StringRef("includePath"), N.getIncludePath());
        Printer.printString(new StringRef("isysroot"), N.getISysRoot());
        Out.$out(NativePointer.$RPAREN);
    }

    public static void writeDITemplateTypeParameter(raw_ostream Out, DITemplateTypeParameter N, TypePrinting TypePrinter, SlotTracker Machine, Module$IR Context) {
        Out.$out("!DITemplateTypeParameter(");
        MDFieldPrinter Printer = new MDFieldPrinter(Out, TypePrinter, Machine, Context);
        Printer.printString(new StringRef("name"), N.getName());
        Printer.printMetadata(new StringRef("type"), N.getRawType(), false);
        Out.$out(NativePointer.$RPAREN);
    }

    public static void writeDITemplateValueParameter(raw_ostream Out, DITemplateValueParameter N, TypePrinting TypePrinter, SlotTracker Machine, Module$IR Context) {
        Out.$out("!DITemplateValueParameter(");
        MDFieldPrinter Printer = new MDFieldPrinter(Out, TypePrinter, Machine, Context);
        if (N.getTag() != Unsigned.$ushort2uint((char)'0')) {
            Printer.printTag(N);
        }
        Printer.printString(new StringRef("name"), N.getName());
        Printer.printMetadata(new StringRef("type"), N.getRawType());
        Printer.printMetadata(new StringRef("value"), N.getValue(), false);
        Out.$out(NativePointer.$RPAREN);
    }

    public static void writeDIGlobalVariable(raw_ostream Out, DIGlobalVariable N, TypePrinting TypePrinter, SlotTracker Machine, Module$IR Context) {
        Out.$out("!DIGlobalVariable(");
        MDFieldPrinter Printer = new MDFieldPrinter(Out, TypePrinter, Machine, Context);
        Printer.printString(new StringRef("name"), N.getName());
        Printer.printString(new StringRef("linkageName"), N.getLinkageName());
        Printer.printMetadata(new StringRef("scope"), N.getRawScope(), false);
        Printer.printMetadata(new StringRef("file"), N.getRawFile());
        Printer.printInt$UInt(new StringRef(NativePointer.$line), N.getLine());
        Printer.printMetadata(new StringRef("type"), N.getRawType());
        Printer.printBool(new StringRef("isLocal"), N.isLocalToUnit());
        Printer.printBool(new StringRef("isDefinition"), N.isDefinition());
        Printer.printMetadata(new StringRef("variable"), N.getRawVariable());
        Printer.printMetadata(new StringRef("declaration"), N.getRawStaticDataMemberDeclaration());
        Out.$out(NativePointer.$RPAREN);
    }

    public static void writeDILocalVariable(raw_ostream Out, DILocalVariable N, TypePrinting TypePrinter, SlotTracker Machine, Module$IR Context) {
        Out.$out("!DILocalVariable(");
        MDFieldPrinter Printer = new MDFieldPrinter(Out, TypePrinter, Machine, Context);
        Printer.printString(new StringRef("name"), N.getName());
        Printer.printInt$UInt(new StringRef("arg"), N.getArg());
        Printer.printMetadata(new StringRef("scope"), N.getRawScope(), false);
        Printer.printMetadata(new StringRef("file"), N.getRawFile());
        Printer.printInt$UInt(new StringRef(NativePointer.$line), N.getLine());
        Printer.printMetadata(new StringRef("type"), N.getRawType());
        Printer.printDIFlags(new StringRef("flags"), N.getFlags());
        Out.$out(NativePointer.$RPAREN);
    }

    public static void writeDIExpression(raw_ostream Out, DIExpression N, TypePrinting TypePrinter, SlotTracker Machine, Module$IR Context) {
        Out.$out("!DIExpression(");
        FieldSeparator FS = new FieldSeparator();
        if (N.isValid()) {
            DIExpression.expr_op_iterator I = N.expr_op_begin();
            DIExpression.expr_op_iterator E = N.expr_op_end();
            while (I.$noteq(E)) {
                char.ptr OpStr = Native.$tryClone((char.ptr)DwarfGlobals.OperationEncodingString((int)Unsigned.$ulong2uint((long)I.$arrow().getOp())));
                assert (Native.$bool((Native.Native$Bool)OpStr)) : "Expected valid opcode";
                AsmWriterStatics.$out_raw_ostream_FieldSeparator(Out, FS).$out(OpStr);
                int AE = I.$arrow().getNumArgs();
                for (int A2 = 0; A2 != AE; ++A2) {
                    AsmWriterStatics.$out_raw_ostream_FieldSeparator(Out, FS).$out_ullong(I.$arrow().getArg(A2));
                }
                I.$preInc();
            }
        } else {
            Iterator iterator2 = N.getElements().iterator();
            while (iterator2.hasNext()) {
                long I = (Long)iterator2.next();
                AsmWriterStatics.$out_raw_ostream_FieldSeparator(Out, FS).$out_ullong(I);
            }
        }
        Out.$out(NativePointer.$RPAREN);
    }

    public static void writeDIObjCProperty(raw_ostream Out, DIObjCProperty N, TypePrinting TypePrinter, SlotTracker Machine, Module$IR Context) {
        Out.$out("!DIObjCProperty(");
        MDFieldPrinter Printer = new MDFieldPrinter(Out, TypePrinter, Machine, Context);
        Printer.printString(new StringRef("name"), N.getName());
        Printer.printMetadata(new StringRef("file"), N.getRawFile());
        Printer.printInt$UInt(new StringRef(NativePointer.$line), N.getLine());
        Printer.printString(new StringRef("setter"), N.getSetterName());
        Printer.printString(new StringRef("getter"), N.getGetterName());
        Printer.printInt$UInt(new StringRef("attributes"), N.getAttributes());
        Printer.printMetadata(new StringRef("type"), N.getRawType());
        Out.$out(NativePointer.$RPAREN);
    }

    public static void writeDIImportedEntity(raw_ostream Out, DIImportedEntity N, TypePrinting TypePrinter, SlotTracker Machine, Module$IR Context) {
        Out.$out("!DIImportedEntity(");
        MDFieldPrinter Printer = new MDFieldPrinter(Out, TypePrinter, Machine, Context);
        Printer.printTag(N);
        Printer.printString(new StringRef("name"), N.getName());
        Printer.printMetadata(new StringRef("scope"), N.getRawScope(), false);
        Printer.printMetadata(new StringRef("entity"), N.getRawEntity());
        Printer.printInt$UInt(new StringRef(NativePointer.$line), N.getLine());
        Out.$out(NativePointer.$RPAREN);
    }

    public static void WriteMDNodeBodyInternal(raw_ostream Out, MDNode Node2, TypePrinting TypePrinter, SlotTracker Machine, Module$IR Context) {
        if (Node2.isDistinct()) {
            Out.$out("distinct ");
        } else if (Node2.isTemporary()) {
            Out.$out("<temporary!> ");
        }
        switch (Metadata.MetadataKind.valueOf(Node2.getMetadataID())) {
            default: {
                throw new llvm_unreachable("Expected uniquable MDNode");
            }
            case MDTupleKind: {
                AsmWriterStatics.writeMDTuple(Out, IrRTTI.cast_MDTuple(Node2), TypePrinter, Machine, Context);
                break;
            }
            case DILocationKind: {
                AsmWriterStatics.writeDILocation(Out, IrRTTI.cast_DILocation(Node2), TypePrinter, Machine, Context);
                break;
            }
            case DIExpressionKind: {
                AsmWriterStatics.writeDIExpression(Out, IrRTTI.cast_DIExpression(Node2), TypePrinter, Machine, Context);
                break;
            }
            case GenericDINodeKind: {
                AsmWriterStatics.writeGenericDINode(Out, IrRTTI.cast_GenericDINode(Node2), TypePrinter, Machine, Context);
                break;
            }
            case DISubrangeKind: {
                AsmWriterStatics.writeDISubrange(Out, IrRTTI.cast_DISubrange(Node2), TypePrinter, Machine, Context);
                break;
            }
            case DIEnumeratorKind: {
                AsmWriterStatics.writeDIEnumerator(Out, IrRTTI.cast_DIEnumerator(Node2), TypePrinter, Machine, Context);
                break;
            }
            case DIBasicTypeKind: {
                AsmWriterStatics.writeDIBasicType(Out, IrRTTI.cast_DIBasicType(Node2), TypePrinter, Machine, Context);
                break;
            }
            case DIDerivedTypeKind: {
                AsmWriterStatics.writeDIDerivedType(Out, IrRTTI.cast_DIDerivedType(Node2), TypePrinter, Machine, Context);
                break;
            }
            case DICompositeTypeKind: {
                AsmWriterStatics.writeDICompositeType(Out, IrRTTI.cast_DICompositeType(Node2), TypePrinter, Machine, Context);
                break;
            }
            case DISubroutineTypeKind: {
                AsmWriterStatics.writeDISubroutineType(Out, IrRTTI.cast_DISubroutineType(Node2), TypePrinter, Machine, Context);
                break;
            }
            case DIFileKind: {
                AsmWriterStatics.writeDIFile(Out, IrRTTI.cast_DIFile(Node2), TypePrinter, Machine, Context);
                break;
            }
            case DICompileUnitKind: {
                AsmWriterStatics.writeDICompileUnit(Out, IrRTTI.cast_DICompileUnit(Node2), TypePrinter, Machine, Context);
                break;
            }
            case DISubprogramKind: {
                AsmWriterStatics.writeDISubprogram(Out, IrRTTI.cast_DISubprogram(Node2), TypePrinter, Machine, Context);
                break;
            }
            case DILexicalBlockKind: {
                AsmWriterStatics.writeDILexicalBlock(Out, IrRTTI.cast_DILexicalBlock(Node2), TypePrinter, Machine, Context);
                break;
            }
            case DILexicalBlockFileKind: {
                AsmWriterStatics.writeDILexicalBlockFile(Out, IrRTTI.cast_DILexicalBlockFile(Node2), TypePrinter, Machine, Context);
                break;
            }
            case DINamespaceKind: {
                AsmWriterStatics.writeDINamespace(Out, IrRTTI.cast_DINamespace(Node2), TypePrinter, Machine, Context);
                break;
            }
            case DIModuleKind: {
                AsmWriterStatics.writeDIModule(Out, IrRTTI.cast_DIModule(Node2), TypePrinter, Machine, Context);
                break;
            }
            case DITemplateTypeParameterKind: {
                AsmWriterStatics.writeDITemplateTypeParameter(Out, IrRTTI.cast_DITemplateTypeParameter(Node2), TypePrinter, Machine, Context);
                break;
            }
            case DITemplateValueParameterKind: {
                AsmWriterStatics.writeDITemplateValueParameter(Out, IrRTTI.cast_DITemplateValueParameter(Node2), TypePrinter, Machine, Context);
                break;
            }
            case DIGlobalVariableKind: {
                AsmWriterStatics.writeDIGlobalVariable(Out, IrRTTI.cast_DIGlobalVariable(Node2), TypePrinter, Machine, Context);
                break;
            }
            case DILocalVariableKind: {
                AsmWriterStatics.writeDILocalVariable(Out, IrRTTI.cast_DILocalVariable(Node2), TypePrinter, Machine, Context);
                break;
            }
            case DIObjCPropertyKind: {
                AsmWriterStatics.writeDIObjCProperty(Out, IrRTTI.cast_DIObjCProperty(Node2), TypePrinter, Machine, Context);
                break;
            }
            case DIImportedEntityKind: {
                AsmWriterStatics.writeDIImportedEntity(Out, IrRTTI.cast_DIImportedEntity(Node2), TypePrinter, Machine, Context);
                break;
            }
            case DIMacroKind: {
                AsmWriterStatics.writeDIMacro(Out, IrRTTI.cast_DIMacro(Node2), TypePrinter, Machine, Context);
                break;
            }
            case DIMacroFileKind: {
                AsmWriterStatics.writeDIMacroFile(Out, IrRTTI.cast_DIMacroFile(Node2), TypePrinter, Machine, Context);
            }
        }
    }

    public static void printMetadataIdentifier(StringRef Name, formatted_raw_ostream Out) {
        if (Name.empty()) {
            Out.$out("<empty name> ");
        } else {
            if (std.isalpha((int)Unsigned.$uchar2int((byte)Name.$at(0))) != 0 || Name.$at(0) == 45 || Name.$at(0) == 36 || Name.$at(0) == 46 || Name.$at(0) == 95) {
                Out.$out_char(Name.$at(0));
            } else {
                Out.$out_char((byte)92).$out_char(llvm.hexdigit((int)(Name.$at(0) >> 4))).$out_char(llvm.hexdigit((int)(Name.$at(0) & 0xF)));
            }
            int e = Name.size();
            for (int i = 1; i != e; ++i) {
                byte C2 = Name.$at(i);
                if (std.isalnum((int)Unsigned.$uchar2int((byte)C2)) != 0 || Unsigned.$uchar2int((byte)C2) == 45 || Unsigned.$uchar2int((byte)C2) == 36 || Unsigned.$uchar2int((byte)C2) == 46 || Unsigned.$uchar2int((byte)C2) == 95) {
                    Out.$out_uchar(C2);
                    continue;
                }
                Out.$out_char((byte)92).$out_char(llvm.hexdigit((int)(Unsigned.$uchar2int((byte)C2) >> 4))).$out_char(llvm.hexdigit((int)(Unsigned.$uchar2int((byte)C2) & 0xF)));
            }
        }
    }

    public static char.ptr getLinkagePrintName(GlobalValue.LinkageTypes LT) {
        switch (LT) {
            case ExternalLinkage: {
                return NativePointer.$EMPTY;
            }
            case PrivateLinkage: {
                return NativePointer.$((String)"private ");
            }
            case InternalLinkage: {
                return NativePointer.$((String)"internal ");
            }
            case LinkOnceAnyLinkage: {
                return NativePointer.$((String)"linkonce ");
            }
            case LinkOnceODRLinkage: {
                return NativePointer.$((String)"linkonce_odr ");
            }
            case WeakAnyLinkage: {
                return NativePointer.$((String)"weak ");
            }
            case WeakODRLinkage: {
                return NativePointer.$((String)"weak_odr ");
            }
            case CommonLinkage: {
                return NativePointer.$((String)"common ");
            }
            case AppendingLinkage: {
                return NativePointer.$((String)"appending ");
            }
            case ExternalWeakLinkage: {
                return NativePointer.$((String)"extern_weak ");
            }
            case AvailableExternallyLinkage: {
                return NativePointer.$((String)"available_externally ");
            }
        }
        throw new llvm_unreachable("invalid linkage");
    }

    public static void PrintVisibility(GlobalValue.VisibilityTypes Vis, formatted_raw_ostream Out) {
        switch (Vis) {
            case DefaultVisibility: {
                break;
            }
            case HiddenVisibility: {
                Out.$out("hidden ");
                break;
            }
            case ProtectedVisibility: {
                Out.$out("protected ");
            }
        }
    }

    public static void PrintDLLStorageClass(GlobalValue.DLLStorageClassTypes SCT, formatted_raw_ostream Out) {
        switch (SCT) {
            case DefaultStorageClass: {
                break;
            }
            case DLLImportStorageClass: {
                Out.$out("dllimport ");
                break;
            }
            case DLLExportStorageClass: {
                Out.$out("dllexport ");
            }
        }
    }

    public static void PrintThreadLocalModel(GlobalValue.ThreadLocalMode TLM, formatted_raw_ostream Out) {
        switch (TLM) {
            case NotThreadLocal: {
                break;
            }
            case GeneralDynamicTLSModel: {
                Out.$out("thread_local ");
                break;
            }
            case LocalDynamicTLSModel: {
                Out.$out("thread_local(localdynamic) ");
                break;
            }
            case InitialExecTLSModel: {
                Out.$out("thread_local(initialexec) ");
                break;
            }
            case LocalExecTLSModel: {
                Out.$out("thread_local(localexec) ");
            }
        }
    }

    public static StringRef getUnnamedAddrEncoding(GlobalValue.UnnamedAddr UA) {
        switch (UA) {
            case None: {
                return new StringRef(NativePointer.$EMPTY);
            }
            case Local: {
                return new StringRef("local_unnamed_addr");
            }
            case Global: {
                return new StringRef("unnamed_addr");
            }
        }
        throw new llvm_unreachable("Unknown UnnamedAddr");
    }

    public static void maybePrintComdat(formatted_raw_ostream Out, GlobalObject GO) {
        Comdat C2 = GO.getComdat$Const();
        if (C2 == null) {
            return;
        }
        if (IrRTTI.isa_GlobalVariable(GO)) {
            Out.$out_char((byte)44);
        }
        Out.$out(" comdat");
        if (llvm.$eq_StringRef((StringRef)GO.getName(), (StringRef)C2.getName())) {
            return;
        }
        Out.$out_char((byte)40);
        AsmWriterStatics.PrintLLVMName((raw_ostream)Out, C2.getName(), PrefixType.ComdatPrefix);
        Out.$out_char((byte)41);
    }

    public static boolean isReferencingMDNode(Instruction I) {
        Function F;
        CallInst CI = IrRTTI.dyn_cast_CallInst((Instruction)Native.$AddrOf((Object)I));
        if (CI != null && (F = CI.getCalledFunction()) != null && F.isIntrinsic()) {
            for (Use Op : I.operands$Const()) {
                MetadataAsValue V = IrRTTI.dyn_cast_or_null_MetadataAsValue(Op);
                if (V == null || !IrRTTI.isa_MDNode(V.getMetadata())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean printWithoutType(Value V, raw_ostream O, SlotTracker Machine, Module$IR M) {
        if (V.hasName() || IrRTTI.isa_GlobalValue(V) || !IrRTTI.isa_Constant(V) && !IrRTTI.isa_MetadataAsValue(V)) {
            AsmWriterStatics.WriteAsOperandInternal(O, (Value)Native.$AddrOf((Object)V), (TypePrinting)null, Machine, M);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printAsOperandImpl(Value V, raw_ostream O, boolean PrintType, ModuleSlotTracker MST) {
        TypePrinting TypePrinter = null;
        try {
            TypePrinter = new TypePrinting();
            Module$IR M = MST.getModule();
            if (M != null) {
                TypePrinter.incorporateTypes((Module$IR)Native.$Deref((Object)M));
            }
            if (PrintType) {
                TypePrinter.print(V.getType(), O);
                O.$out_char((byte)32);
            }
            AsmWriterStatics.WriteAsOperandInternal(O, (Value)Native.$AddrOf((Object)V), (TypePrinting)Native.$AddrOf((Object)TypePrinter), MST.getMachine(), MST.getModule());
        }
        finally {
            if (TypePrinter != null) {
                TypePrinter.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printMetadataImpl(raw_ostream ROS, Metadata MD, ModuleSlotTracker MST, Module$IR M, boolean OnlyAsOperand) {
        formatted_raw_ostream OS = null;
        TypePrinting TypePrinter = null;
        try {
            OS = new formatted_raw_ostream(ROS);
            TypePrinter = new TypePrinting();
            if (M != null) {
                TypePrinter.incorporateTypes((Module$IR)Native.$Deref((Object)M));
            }
            AsmWriterStatics.WriteAsOperandInternal((raw_ostream)OS, (Metadata)Native.$AddrOf((Object)MD), (TypePrinting)Native.$AddrOf((Object)TypePrinter), MST.getMachine(), M, true);
            MDNode N = IrRTTI.dyn_cast_MDNode((Metadata)Native.$AddrOf((Object)MD));
            if (OnlyAsOperand || N == null) {
                return;
            }
            OS.$out(" = ");
            AsmWriterStatics.WriteMDNodeBodyInternal((raw_ostream)OS, N, (TypePrinting)Native.$AddrOf((Object)TypePrinter), MST.getMachine(), M);
        }
        finally {
            if (TypePrinter != null) {
                TypePrinter.$destroy();
            }
            if (OS != null) {
                OS.$destroy();
            }
        }
    }
}

