/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.clank.support.JavaDifferentiators;
import org.clank.support.NativePointer;
import org.clank.support.aliases.char;
import org.llvm.ir.AnalysisManager;
import org.llvm.ir.DiagnosticInfoIgnoringInvalidDebugMetadata;
import org.llvm.ir.Function;
import org.llvm.ir.Module$IR;
import org.llvm.ir.PassInfoMixin;
import org.llvm.ir.PreservedAnalyses;
import org.llvm.ir.VerifierAnalysis;
import org.llvm.ir.java.IPassFunction;
import org.llvm.ir.java.IPassModule;
import org.llvm.pass.IrLlvmGlobals;
import org.llvm.support.llvm;

public class VerifierPass
implements PassInfoMixin<VerifierPass>,
IPassModule<PreservedAnalyses>,
IPassFunction<PreservedAnalyses> {
    private boolean FatalErrors;

    public VerifierPass() {
        this(true);
    }

    public VerifierPass(boolean FatalErrors) {
        this.$PassInfoMixin();
        this.FatalErrors = FatalErrors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreservedAnalyses run(Module$IR M, AnalysisManager<Module$IR> AM) {
        VerifierAnalysis.Result Res = new VerifierAnalysis.Result((VerifierAnalysis.Result)AM.getResult(VerifierAnalysis.class, M));
        if (this.FatalErrors) {
            if (Res.IRBroken) {
                llvm.report_fatal_error((char.ptr)NativePointer.$((String)"Broken module found, compilation aborted!"));
            }
            assert (!Res.DebugInfoBroken) : "Module contains invalid debug info";
        }
        if (Res.DebugInfoBroken) {
            DiagnosticInfoIgnoringInvalidDebugMetadata DiagInvalid = null;
            try {
                DiagInvalid = new DiagnosticInfoIgnoringInvalidDebugMetadata(M);
                M.getContext().diagnose(DiagInvalid);
                if (!IrLlvmGlobals.StripDebugInfo(M)) {
                    llvm.report_fatal_error((char.ptr)NativePointer.$((String)"Failed to strip malformed debug info"));
                }
            }
            finally {
                if (DiagInvalid != null) {
                    DiagInvalid.$destroy();
                }
            }
        }
        return PreservedAnalyses.all();
    }

    @Override
    public PreservedAnalyses run(Function F, AnalysisManager<Function> AM) {
        VerifierAnalysis.Result res = new VerifierAnalysis.Result((VerifierAnalysis.Result)AM.getResult(VerifierAnalysis.class, F));
        if (res.IRBroken && this.FatalErrors) {
            llvm.report_fatal_error((char.ptr)NativePointer.$((String)"Broken function found, compilation aborted!"));
        }
        return PreservedAnalyses.all();
    }

    public VerifierPass(JavaDifferentiators.JD.Move _dparam, VerifierPass $Prm0) {
        this.$PassInfoMixin(JavaDifferentiators.JD.Move.INSTANCE, $Prm0);
        this.FatalErrors = $Prm0.FatalErrors;
    }

    public String toString() {
        return "FatalErrors=" + this.FatalErrors + super.toString();
    }
}

