/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.clank.support.Destructors;
import org.clank.support.aliases.type;
import org.llvm.adt.aliases.DenseMap;
import org.llvm.adt.aliases.DenseMapIterator;
import org.llvm.ir.Constant;
import org.llvm.ir.ConstantAsMetadata;
import org.llvm.ir.LLVMContext;
import org.llvm.ir.LocalAsMetadata;
import org.llvm.ir.Metadata;
import org.llvm.ir.ReplaceableMetadataImpl;
import org.llvm.ir.Type;
import org.llvm.ir.Value;
import org.llvm.ir.impl.MetadataStatics;
import org.llvm.ir.java.IrRTTI;

public class ValueAsMetadata
extends Metadata
implements ReplaceableMetadataImpl,
Destructors.ClassWithDestructor {
    private Value V;
    private final ReplaceableMetadataImpl.ReplaceableMetadataImpl.Fields ReplaceableMetadataImpl$Flds;

    public void dropUsers() {
        ReplaceableMetadataImpl.super.resolveAllUses(false);
    }

    protected ValueAsMetadata(int ID2, Value V) {
        super(ID2, Metadata.StorageType.Uniqued);
        this.ReplaceableMetadataImpl$Flds = this.$ReplaceableMetadataImpl(V.getContext());
        this.V = V;
        assert (V != null) : "Expected valid value";
    }

    @Override
    public void $destroy() {
        super.$destroy();
        ReplaceableMetadataImpl.super.$destroy$ReplaceableMetadataImpl();
    }

    public static ValueAsMetadata get(Value V) {
        assert (V != null) : "Unexpected null Value";
        LLVMContext Context = V.getContext();
        type.ref Entry2 = Context.pImpl.ValuesAsMetadata.ref$at((Object)V);
        if (Entry2.$deref() == null) {
            assert (IrRTTI.isa_Constant(V) || IrRTTI.isa_Argument(V) || IrRTTI.isa_Instruction(V)) : "Expected constant or function-local value";
            assert (!V.IsUsedByMD) : "Expected this to be the only metadata use";
            V.IsUsedByMD = true;
            Constant C2 = IrRTTI.dyn_cast_Constant(V);
            if (C2 != null) {
                Entry2.$set((Object)new ConstantAsMetadata(C2));
            } else {
                Entry2.$set((Object)new LocalAsMetadata(V));
            }
        }
        return (ValueAsMetadata)Entry2.$deref();
    }

    public static ConstantAsMetadata getConstant(Value C2) {
        return IrRTTI.cast_ConstantAsMetadata(ValueAsMetadata.get(C2));
    }

    public static LocalAsMetadata getLocal(Value Local) {
        return IrRTTI.cast_LocalAsMetadata(ValueAsMetadata.get(Local));
    }

    public static ValueAsMetadata getIfExists(Value V) {
        assert (V != null) : "Unexpected null Value";
        return (ValueAsMetadata)V.getContext().pImpl.ValuesAsMetadata.lookup((Object)V);
    }

    public static ConstantAsMetadata getConstantIfExists(Value C2) {
        return IrRTTI.cast_or_null_ConstantAsMetadata(ValueAsMetadata.getIfExists(C2));
    }

    public static LocalAsMetadata getLocalIfExists(Value Local) {
        return IrRTTI.cast_or_null_LocalAsMetadata(ValueAsMetadata.getIfExists(Local));
    }

    public Value getValue() {
        return this.V;
    }

    public Type getType() {
        return this.V.getType();
    }

    @Override
    public LLVMContext getContext() {
        return this.V.getContext();
    }

    public static void handleDeletion(Value V) {
        assert (V != null) : "Expected valid value";
        DenseMap<Value, ValueAsMetadata> Store = V.getType().getContext().pImpl.ValuesAsMetadata;
        DenseMapIterator I = Store.find((Object)V);
        if (I.$eq(Store.end())) {
            return;
        }
        ValueAsMetadata MD = (ValueAsMetadata)I.$arrow().second;
        assert (MD != null) : "Expected valid metadata";
        assert (MD.getValue() == V) : "Expected valid mapping";
        Store.erase(new DenseMapIterator(I));
        MD.replaceAllUsesWith(null);
        Destructors.$destroy((Destructors.ClassWithDestructor)MD);
    }

    public static void handleRAUW(Value From, Value To) {
        type.ref Entry2;
        assert (From != null) : "Expected valid value";
        assert (To != null) : "Expected valid value";
        assert (From != To) : "Expected changed value";
        assert (From.getType() == To.getType()) : "Unexpected type change";
        LLVMContext Context = From.getType().getContext();
        DenseMap<Value, ValueAsMetadata> Store = Context.pImpl.ValuesAsMetadata;
        DenseMapIterator I = Store.find((Object)From);
        if (I.$eq(Store.end())) {
            assert (!From.IsUsedByMD) : "Expected From not to be used by metadata";
            return;
        }
        assert (From.IsUsedByMD) : "Expected From to be used by metadata";
        From.IsUsedByMD = false;
        ValueAsMetadata MD = (ValueAsMetadata)I.$arrow().second;
        assert (MD != null) : "Expected valid metadata";
        assert (MD.getValue() == From) : "Expected valid mapping";
        Store.erase(new DenseMapIterator(I));
        if (IrRTTI.isa_LocalAsMetadata(MD)) {
            Constant C2 = IrRTTI.dyn_cast_Constant(To);
            if (C2 != null) {
                MD.replaceAllUsesWith(ConstantAsMetadata.get(C2));
                Destructors.$destroy((Destructors.ClassWithDestructor)MD);
                return;
            }
            if (MetadataStatics.getLocalFunction(From) != null && MetadataStatics.getLocalFunction(To) != null && MetadataStatics.getLocalFunction(From) != MetadataStatics.getLocalFunction(To)) {
                MD.replaceAllUsesWith(null);
                Destructors.$destroy((Destructors.ClassWithDestructor)MD);
                return;
            }
        } else if (!IrRTTI.isa_Constant(To)) {
            MD.replaceAllUsesWith(null);
            Destructors.$destroy((Destructors.ClassWithDestructor)MD);
            return;
        }
        if ((Entry2 = Store.ref$at((Object)To)).$deref() != null) {
            MD.replaceAllUsesWith((Metadata)Entry2.$deref());
            Destructors.$destroy((Destructors.ClassWithDestructor)MD);
            return;
        }
        assert (!To.IsUsedByMD) : "Expected this to be the only metadata use";
        To.IsUsedByMD = true;
        MD.V = To;
        Entry2.$set((Object)MD);
    }

    @Override
    public void replaceAllUsesWith(Metadata MD) {
        ReplaceableMetadataImpl.super.replaceAllUsesWith(MD);
    }

    public static boolean classof(Metadata MD) {
        return MD.getMetadataID() == Metadata.MetadataKind.LocalAsMetadataKind.getValue() || MD.getMetadataID() == Metadata.MetadataKind.ConstantAsMetadataKind.getValue();
    }

    @Override
    public final ReplaceableMetadataImpl.ReplaceableMetadataImpl.Fields $ReplaceableMetadataImpl$Fields() {
        return this.ReplaceableMetadataImpl$Flds;
    }

    @Override
    public String toString() {
        return "V=" + this.V + super.toString();
    }
}

