/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativeCallback;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.NativeTrace;
import org.clank.support.NativeType;
import org.clank.support.Unsigned;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.clank.support.void;
import org.llvm.adt.APInt;
import org.llvm.adt.DenseMapInfo;
import org.llvm.adt.SmallPtrSet;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.DenseMapInfo;
import org.llvm.adt.aliases.DenseMapIterator;
import org.llvm.adt.aliases.StringMapEntry;
import org.llvm.adt.ilist_iterator;
import org.llvm.adt.iterator_range;
import org.llvm.ir.AllocaInst;
import org.llvm.ir.Argument;
import org.llvm.ir.AttributeSet;
import org.llvm.ir.BasicBlock;
import org.llvm.ir.CallSite;
import org.llvm.ir.Constant;
import org.llvm.ir.ConstantInt;
import org.llvm.ir.DataLayout;
import org.llvm.ir.Function;
import org.llvm.ir.GEPOperator;
import org.llvm.ir.GlobalAlias;
import org.llvm.ir.GlobalObject;
import org.llvm.ir.GlobalValue;
import org.llvm.ir.GlobalVariable;
import org.llvm.ir.ImmutableCallSite;
import org.llvm.ir.Instruction;
import org.llvm.ir.LLVMContext;
import org.llvm.ir.LoadInst;
import org.llvm.ir.MDNode;
import org.llvm.ir.MetadataAsValue;
import org.llvm.ir.Module$IR;
import org.llvm.ir.ModuleSlotTracker;
import org.llvm.ir.Operator;
import org.llvm.ir.PHINode;
import org.llvm.ir.Type;
import org.llvm.ir.Use;
import org.llvm.ir.User;
import org.llvm.ir.ValueAsMetadata;
import org.llvm.ir.ValueHandleBase;
import org.llvm.ir.ValueSymbolTable;
import org.llvm.ir.impl.AsmWriterStatics;
import org.llvm.ir.impl.AssemblyWriter;
import org.llvm.ir.impl.PointerStripKind;
import org.llvm.ir.impl.SlotTracker;
import org.llvm.ir.impl.TypePrinting;
import org.llvm.ir.impl.ValueStatics;
import org.llvm.ir.java.IrRTTI;
import org.llvm.ir.mdconst.MdconstGlobals;
import org.llvm.llvmc.LLVMOpaqueValue;
import org.llvm.pass.IrLlvmGlobals;
import org.llvm.support.formatted_raw_ostream;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;
import org.llvm.support.raw_ostream;

public class Value
implements LLVMOpaqueValue,
Destructors.ClassWithDestructor {
    private Type VTy;
    private final type.ref<Use> UseList;
    private byte SubclassID;
    boolean HasValueHandle;
    protected byte SubclassOptionalData;
    private char SubclassData;
    public static final int NumUserOperandsBits = 28;
    protected int NumUserOperands;
    protected boolean IsUsedByMD;
    protected boolean HasName;
    protected boolean HasHungOffUses;
    protected boolean HasDescriptor;
    public static int MaxAlignmentExponent = 29;
    public static int MaximumAlignment = 1 << MaxAlignmentExponent;

    protected void $assign(Value $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    protected Value(Value $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    protected Value(Type ty, int scid) {
        this.VTy = ValueStatics.checkType(ty);
        this.UseList = NativePointer.create_type$null$ref();
        this.SubclassID = Unsigned.$uint2uchar((int)scid);
        this.HasValueHandle = false;
        this.SubclassOptionalData = Unsigned.$uchar2uchar_7bits((byte)Unsigned.$int2uchar((int)0));
        this.SubclassData = Unsigned.$int2ushort((int)0);
        this.NumUserOperands = 0;
        this.IsUsedByMD = false;
        this.HasName = false;
        if (Unsigned.$uchar2int((byte)this.SubclassID) == 54 || Unsigned.$uchar2int((byte)this.SubclassID) == 5) {
            assert (this.VTy.isFirstClassType() || this.VTy.isVoidTy() || this.VTy.isStructTy()) : "invalid CallInst type!";
        } else if (Unsigned.$uchar2int((byte)this.SubclassID) != ValueTy.BasicBlockVal.getValue() && (Unsigned.$uchar2int((byte)this.SubclassID) < ValueTy.ConstantFirstVal.getValue() || Unsigned.$uchar2int((byte)this.SubclassID) > ValueTy.ConstantLastVal.getValue())) assert (this.VTy.isFirstClassType() || this.VTy.isVoidTy()) : "Cannot create non-first-class values except for constants!";
        std.static_assert((this.$sizeof_Value() == 3 * NativeType.$sizeof_ptr() + 2 * NativeType.$sizeof_UInt() ? 1 : 0) != 0, (char.ptr)NativePointer.$((String)"Value too big"));
    }

    public void $destroy() {
        if (this.HasValueHandle) {
            ValueHandleBase.ValueIsDeleted(this);
        }
        if (this.isUsedByMetadata()) {
            ValueAsMetadata.handleDeletion(this);
        }
        if (!NativeTrace.NDEBUG() && !this.use_empty()) {
            IrLlvmGlobals.$out_raw_ostream_Type(llvm.dbgs().$out("While deleting: "), (Type)Native.$Deref((Object)this.VTy)).$out(" %").$out(this.getName()).$out(NativePointer.$LF);
            for (User U : this.users()) {
                IrLlvmGlobals.$out_raw_ostream_Value$C(llvm.dbgs().$out("Use still stuck around after Def is destroyed:"), (Value)Native.$Deref((Object)U)).$out(NativePointer.$LF);
            }
        }
        assert (this.use_empty()) : "Uses remain when a value is destroyed!";
        this.destroyValueName();
    }

    public void dump() {
        this.print(llvm.dbgs(), true);
        llvm.dbgs().$out_char((byte)10);
    }

    public void print(raw_ostream ROS) {
        this.print(ROS, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(raw_ostream ROS, boolean IsForDebug) {
        ModuleSlotTracker MST = null;
        try {
            boolean ShouldInitializeAllMetadata = false;
            Instruction I = IrRTTI.dyn_cast_Instruction(this);
            if (I != null) {
                ShouldInitializeAllMetadata = AsmWriterStatics.isReferencingMDNode((Instruction)Native.$Deref((Object)I));
            } else if (IrRTTI.isa_Function(this) || IrRTTI.isa_MetadataAsValue(this)) {
                ShouldInitializeAllMetadata = true;
            }
            MST = new ModuleSlotTracker(AsmWriterStatics.getModuleFromVal(this), ShouldInitializeAllMetadata);
            this.print(ROS, MST, IsForDebug);
        }
        finally {
            if (MST != null) {
                MST.$destroy();
            }
        }
    }

    public void print(raw_ostream ROS, ModuleSlotTracker MST) {
        this.print(ROS, MST, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(raw_ostream ROS, ModuleSlotTracker MST, boolean IsForDebug) {
        block31: {
            formatted_raw_ostream OS = null;
            SlotTracker EmptySlotTable = null;
            try {
                OS = new formatted_raw_ostream(ROS);
                EmptySlotTable = new SlotTracker((Module$IR)null);
                SlotTracker SlotTable = MST.getMachine() != null ? (SlotTracker)Native.$Deref((Object)MST.getMachine()) : EmptySlotTable;
                NativeCallback.T2Void incorporateFunction = F -> {
                    if (F != null) {
                        MST.incorporateFunction((Function)Native.$Deref((Object)F));
                    }
                };
                Instruction I = IrRTTI.dyn_cast_Instruction(this);
                if (I != null) {
                    AssemblyWriter W = null;
                    try {
                        incorporateFunction.$call((Object)(I.getParent$Const() != null ? I.getParent$Const().getParent$Const() : (Function)null));
                        W = new AssemblyWriter(OS, SlotTable, AsmWriterStatics.getModuleFromVal(I), null, IsForDebug);
                        W.printInstruction((Instruction)Native.$Deref((Object)I));
                        break block31;
                    }
                    finally {
                        if (W != null) {
                            W.$destroy();
                        }
                    }
                }
                BasicBlock BB = IrRTTI.dyn_cast_BasicBlock(this);
                if (BB != null) {
                    AssemblyWriter W = null;
                    try {
                        incorporateFunction.$call((Object)BB.getParent$Const());
                        W = new AssemblyWriter(OS, SlotTable, AsmWriterStatics.getModuleFromVal(BB), null, IsForDebug);
                        W.printBasicBlock(BB);
                        break block31;
                    }
                    finally {
                        if (W != null) {
                            W.$destroy();
                        }
                    }
                }
                GlobalValue GV = IrRTTI.dyn_cast_GlobalValue(this);
                if (GV != null) {
                    AssemblyWriter W = null;
                    try {
                        W = new AssemblyWriter(OS, SlotTable, GV.getParent$Const(), null, IsForDebug);
                        GlobalVariable V = IrRTTI.dyn_cast_GlobalVariable(GV);
                        if (V != null) {
                            W.printGlobal(V);
                        } else {
                            Function F2 = IrRTTI.dyn_cast_Function(GV);
                            if (F2 != null) {
                                W.printFunction(F2);
                            } else {
                                W.printIndirectSymbol(IrRTTI.cast_GlobalIndirectSymbol(GV));
                            }
                        }
                        break block31;
                    }
                    finally {
                        if (W != null) {
                            W.$destroy();
                        }
                    }
                }
                MetadataAsValue V = IrRTTI.dyn_cast_MetadataAsValue(this);
                if (V != null) {
                    V.getMetadata().print(ROS, MST, AsmWriterStatics.getModuleFromVal(V));
                    break block31;
                }
                Constant C2 = IrRTTI.dyn_cast_Constant(this);
                if (C2 != null) {
                    TypePrinting TypePrinter = null;
                    try {
                        TypePrinter = new TypePrinting();
                        TypePrinter.print(C2.getType(), (raw_ostream)OS);
                        OS.$out_char((byte)32);
                        AsmWriterStatics.WriteConstantInternal((raw_ostream)OS, C2, TypePrinter, MST.getMachine(), null);
                        break block31;
                    }
                    finally {
                        if (TypePrinter != null) {
                            TypePrinter.$destroy();
                        }
                    }
                }
                if (IrRTTI.isa_InlineAsm(this) || IrRTTI.isa_Argument(this)) {
                    this.printAsOperand((raw_ostream)OS, true, MST);
                    break block31;
                }
                throw new llvm_unreachable("Unknown value to print out!");
            }
            finally {
                if (EmptySlotTable != null) {
                    EmptySlotTable.$destroy();
                }
                if (OS != null) {
                    OS.$destroy();
                }
            }
        }
    }

    public void printAsOperand(raw_ostream O) {
        this.printAsOperand(O, true, (Module$IR)null);
    }

    public void printAsOperand(raw_ostream O, boolean PrintType) {
        this.printAsOperand(O, PrintType, (Module$IR)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printAsOperand(raw_ostream O, boolean PrintType, Module$IR M) {
        SlotTracker Machine = null;
        ModuleSlotTracker MST = null;
        try {
            if (M == null) {
                M = AsmWriterStatics.getModuleFromVal(this);
            }
            if (!PrintType && AsmWriterStatics.printWithoutType(this, O, null, M)) {
                return;
            }
            Machine = new SlotTracker(M, IrRTTI.isa_MetadataAsValue(this));
            MST = new ModuleSlotTracker(Machine, M);
            AsmWriterStatics.printAsOperandImpl(this, O, PrintType, MST);
        }
        finally {
            if (MST != null) {
                MST.$destroy();
            }
            if (Machine != null) {
                Machine.$destroy();
            }
        }
    }

    public void printAsOperand(raw_ostream O, boolean PrintType, ModuleSlotTracker MST) {
        if (!PrintType && AsmWriterStatics.printWithoutType(this, O, MST.getMachine(), MST.getModule())) {
            return;
        }
        AsmWriterStatics.printAsOperandImpl(this, O, PrintType, MST);
    }

    public Type getType() {
        return this.VTy;
    }

    public LLVMContext getContext() {
        return this.VTy.getContext();
    }

    public boolean hasName() {
        return this.HasName;
    }

    public StringMapEntry<Value> getValueName() {
        if (!this.HasName) {
            return null;
        }
        LLVMContext Ctx = this.getContext();
        DenseMapIterator I = Ctx.pImpl.ValueNames.find((Object)this);
        assert (I.$noteq(Ctx.pImpl.ValueNames.end())) : "No name entry found!";
        return (StringMapEntry)I.$arrow().second;
    }

    public void setValueName(StringMapEntry<Value> VN) {
        LLVMContext Ctx = this.getContext();
        assert ((this.HasName ? 1 : 0) == Ctx.pImpl.ValueNames.count((Object)this)) : "HasName bit out of sync!";
        if (VN == null) {
            if (this.HasName) {
                Ctx.pImpl.ValueNames.erase((Object)this);
            }
            this.HasName = false;
            return;
        }
        this.HasName = true;
        Ctx.pImpl.ValueNames.$set((Object)this, VN);
    }

    private void destroyValueName() {
        StringMapEntry<Value> Name = this.getValueName();
        if (Name != null) {
            Name.Destroy();
        }
        this.setValueName((StringMapEntry<Value>)((StringMapEntry)null));
    }

    private void setNameImpl(Twine NewName) {
        if (this.getContext().shouldDiscardValueNames() && !IrRTTI.isa_GlobalValue(this)) {
            return;
        }
        if (NewName.isTriviallyEmpty() && !this.hasName()) {
            return;
        }
        SmallString NameData = new SmallString(256);
        StringRef NameRef = NewName.toStringRef(NameData);
        assert (NameRef.find_first_of((byte)0) == StringRef.npos) : "Null bytes are not allowed in names";
        if (llvm.$eq_StringRef((StringRef)this.getName(), (StringRef)NameRef)) {
            return;
        }
        assert (!this.getType().isVoidTy()) : "Cannot assign a name to void values!";
        type.ref ST = NativePointer.create_type$ref();
        if (ValueStatics.getSymTab(this, (type.ref<ValueSymbolTable>)ST)) {
            return;
        }
        if (ST.$deref() == null) {
            if (NameRef.empty()) {
                this.destroyValueName();
                return;
            }
            this.destroyValueName();
            this.setValueName((StringMapEntry<Value>)StringMapEntry.Create((StringRef)NameRef, (Object)null));
            this.getValueName().setValue((Object)this);
            return;
        }
        if (this.hasName()) {
            ((ValueSymbolTable)ST.$deref()).removeValueName(this.getValueName());
            this.destroyValueName();
            if (NameRef.empty()) {
                return;
            }
        }
        this.setValueName(((ValueSymbolTable)ST.$deref()).createValueName(new StringRef(NameRef), this));
    }

    public StringRef getName() {
        if (!this.hasName()) {
            return new StringRef(NativePointer.$EMPTY, 0);
        }
        return this.getValueName().getKey();
    }

    public void setName(Twine NewName) {
        this.setNameImpl(NewName);
        Function F = IrRTTI.dyn_cast_Function(this);
        if (F != null) {
            F.recalculateIntrinsicID();
        }
    }

    public void takeName(Value V) {
        type.ref ST = NativePointer.create_type$null$ref(null);
        if (this.hasName()) {
            if (ValueStatics.getSymTab(this, (type.ref<ValueSymbolTable>)ST)) {
                if (V.hasName()) {
                    V.setName(new Twine(NativePointer.$EMPTY));
                }
                return;
            }
            if (ST.$deref() != null) {
                ((ValueSymbolTable)ST.$deref()).removeValueName(this.getValueName());
            }
            this.destroyValueName();
        }
        if (!V.hasName()) {
            return;
        }
        if (ST.$deref() == null && ValueStatics.getSymTab(this, (type.ref<ValueSymbolTable>)ST)) {
            V.setName(new Twine(NativePointer.$EMPTY));
            return;
        }
        type.ref VST = NativePointer.create_type$ref();
        boolean Failure = ValueStatics.getSymTab(V, (type.ref<ValueSymbolTable>)VST);
        assert (!Failure) : "V has a name, so it should have a ST!";
        if (ST.$deref() == VST.$deref()) {
            this.setValueName(V.getValueName());
            V.setValueName((StringMapEntry<Value>)((StringMapEntry)null));
            this.getValueName().setValue((Object)this);
            return;
        }
        if (VST.$deref() != null) {
            ((ValueSymbolTable)VST.$deref()).removeValueName(V.getValueName());
        }
        this.setValueName(V.getValueName());
        V.setValueName((StringMapEntry<Value>)((StringMapEntry)null));
        this.getValueName().setValue((Object)this);
        if (ST.$deref() != null) {
            ((ValueSymbolTable)ST.$deref()).reinsertValue(this);
        }
    }

    public void replaceAllUsesWith(Value New2) {
        assert (New2 != null) : "Value::replaceAllUsesWith(<null>) is invalid!";
        assert (!ValueStatics.contains(New2, this)) : "this->replaceAllUsesWith(expr(this)) is NOT valid!";
        assert (New2.getType() == this.getType()) : "replaceAllUses of value with new value of different type!";
        if (this.HasValueHandle) {
            ValueHandleBase.ValueIsRAUWd(this, New2);
        }
        if (this.isUsedByMetadata()) {
            ValueAsMetadata.handleRAUW(this, New2);
        }
        while (!this.use_empty()) {
            Use U = (Use)this.UseList.$deref();
            Constant C2 = IrRTTI.dyn_cast_Constant(U.getUser());
            if (C2 != null && !IrRTTI.isa_GlobalValue(C2)) {
                C2.handleOperandChange(this, New2);
                continue;
            }
            U.set(New2);
        }
        BasicBlock BB = IrRTTI.dyn_cast_BasicBlock(this);
        if (BB != null) {
            BB.replaceSuccessorsPhiUsesWith(IrRTTI.cast_BasicBlock(New2));
        }
    }

    public void replaceUsesOutsideBlock(Value New2, BasicBlock BB) {
        assert (New2 != null) : "Value::replaceUsesOutsideBlock(<null>, BB) is invalid!";
        assert (!ValueStatics.contains(New2, this)) : "this->replaceUsesOutsideBlock(expr(this), BB) is NOT valid!";
        assert (New2.getType() == this.getType()) : "replaceUses of value with new value of different type!";
        assert (BB != null) : "Basic block that may contain a use of 'New' must be defined\n";
        use_iterator_impl<Use> UI = this.use_begin();
        use_iterator_impl<Use> E = this.use_end();
        while (UI.$noteq(E)) {
            Object U = UI.$star();
            UI.$preInc();
            Instruction Usr = IrRTTI.dyn_cast_Instruction(((Use)U).getUser());
            if (Usr != null && Usr.getParent() == BB) continue;
            ((Use)U).set(New2);
        }
    }

    public void assertModuleIsMaterialized() {
        if (!NativeTrace.NDEBUG()) {
            GlobalValue GV = IrRTTI.dyn_cast_GlobalValue(this);
            if (GV == null) {
                return;
            }
            Module$IR M = GV.getParent$Const();
            if (M == null) {
                return;
            }
            assert (M.isMaterialized());
        }
    }

    public boolean use_empty() {
        this.assertModuleIsMaterialized();
        return this.UseList.$deref() == null;
    }

    public use_iterator_impl<Use> materialized_use_begin() {
        return new use_iterator_impl<Use>((Use)this.UseList.$deref(), null);
    }

    public use_iterator_impl<Use> materialized_use_begin$Const() {
        return new use_iterator_impl<Use>((Use)this.UseList.$deref(), null);
    }

    public use_iterator_impl<Use> use_begin() {
        this.assertModuleIsMaterialized();
        return this.materialized_use_begin();
    }

    public use_iterator_impl<Use> use_begin$Const() {
        this.assertModuleIsMaterialized();
        return this.materialized_use_begin$Const();
    }

    public use_iterator_impl<Use> use_end() {
        return new use_iterator_impl<Use>();
    }

    public use_iterator_impl<Use> use_end$Const() {
        return new use_iterator_impl<Use>();
    }

    public iterator_range<Use> materialized_uses() {
        return llvm.make_range(this.materialized_use_begin(), this.use_end());
    }

    public iterator_range<Use> materialized_uses$Const() {
        return llvm.make_range(this.materialized_use_begin$Const(), this.use_end$Const());
    }

    public iterator_range<Use> uses() {
        this.assertModuleIsMaterialized();
        return this.materialized_uses();
    }

    public iterator_range<Use> uses$Const() {
        this.assertModuleIsMaterialized();
        return this.materialized_uses$Const();
    }

    public boolean user_empty() {
        this.assertModuleIsMaterialized();
        return Native.$eq_ptr(this.UseList, null);
    }

    public user_iterator_impl<User> materialized_user_begin() {
        return new user_iterator_impl<User>((Use)this.UseList.$deref());
    }

    public user_iterator_impl<User> materialized_user_begin$Const() {
        return new user_iterator_impl<User>((Use)this.UseList.$deref());
    }

    public user_iterator_impl<User> user_begin() {
        this.assertModuleIsMaterialized();
        return this.materialized_user_begin();
    }

    public user_iterator_impl<User> user_begin$Const() {
        this.assertModuleIsMaterialized();
        return this.materialized_user_begin$Const();
    }

    public user_iterator_impl<User> user_end() {
        return new user_iterator_impl<User>();
    }

    public user_iterator_impl<User> user_end$Const() {
        return new user_iterator_impl<User>();
    }

    public final User user_back$Value() {
        this.assertModuleIsMaterialized();
        return this.materialized_user_begin().$star();
    }

    public final User user_back$Value$Const() {
        this.assertModuleIsMaterialized();
        return this.materialized_user_begin$Const().$star();
    }

    public iterator_range<User> materialized_users() {
        return llvm.make_range(this.materialized_user_begin(), this.user_end());
    }

    public iterator_range<User> materialized_users$Const() {
        return llvm.make_range(this.materialized_user_begin$Const(), this.user_end$Const());
    }

    public iterator_range<User> users() {
        this.assertModuleIsMaterialized();
        return this.materialized_users();
    }

    public iterator_range<User> users$Const() {
        this.assertModuleIsMaterialized();
        return this.materialized_users$Const();
    }

    public boolean hasOneUse() {
        use_iterator_impl<Use> E;
        use_iterator_impl<Use> I = this.use_begin$Const();
        if (I.$eq(E = this.use_end$Const())) {
            return false;
        }
        return I.$preInc().$eq(E);
    }

    public boolean hasNUses(int N) {
        use_iterator_impl<Use> UI = this.use_begin$Const();
        use_iterator_impl<Use> E = this.use_end$Const();
        while (N != 0) {
            if (UI.$eq(E)) {
                return false;
            }
            --N;
            UI.$preInc();
        }
        return UI.$eq(E);
    }

    public boolean hasNUsesOrMore(int N) {
        use_iterator_impl<Use> UI = this.use_begin$Const();
        use_iterator_impl<Use> E = this.use_end$Const();
        while (N != 0) {
            if (UI.$eq(E)) {
                return false;
            }
            --N;
            UI.$preInc();
        }
        return true;
    }

    public boolean isUsedInBasicBlock(BasicBlock BB) {
        ilist_iterator<Instruction> BI = BB.begin$Const();
        ilist_iterator<Instruction> BE = BB.end$Const();
        user_iterator_impl<User> UI = this.user_begin$Const();
        user_iterator_impl<User> UE = this.user_end$Const();
        while (BI.$noteq(BE) && UI.$noteq(UE)) {
            if (Native.$noteq_ptr((void.ptr)((void.ptr)std.find(((Instruction)BI.$arrow()).op_begin$Const(), ((Instruction)BI.$arrow()).op_end$Const(), (Object)this)), ((Instruction)BI.$arrow()).op_end$Const())) {
                return true;
            }
            Instruction User2 = IrRTTI.dyn_cast_Instruction((Value)UI.$star());
            if (User2 != null && User2.getParent$Const() == BB) {
                return true;
            }
            BI.$preInc();
            UI.$preInc();
        }
        return false;
    }

    public int getNumUses() {
        return std.distance(this.use_begin$Const(), this.use_end$Const());
    }

    public void addUse(Use U) {
        U.addToList(this.UseList);
    }

    public int getValueID() {
        return Unsigned.$uchar2uint((byte)this.SubclassID);
    }

    public int getRawSubclassOptionalData() {
        return Unsigned.$uchar2uint((byte)Unsigned.$7bits_uchar2uchar((byte)this.SubclassOptionalData));
    }

    public void clearSubclassOptionalData() {
        this.SubclassOptionalData = Unsigned.$uchar2uchar_7bits((byte)Unsigned.$int2uchar((int)0));
    }

    public boolean hasSameSubclassOptionalData(Value V) {
        return Unsigned.$uchar2int((byte)Unsigned.$7bits_uchar2uchar((byte)this.SubclassOptionalData)) == Unsigned.$uchar2int((byte)Unsigned.$7bits_uchar2uchar((byte)V.SubclassOptionalData));
    }

    public void intersectOptionalDataWith(Value V) {
        this.SubclassOptionalData = (byte)(this.SubclassOptionalData & Unsigned.$int2uchar_7bits((int)Unsigned.$uchar2int((byte)Unsigned.$7bits_uchar2uchar((byte)V.SubclassOptionalData))));
    }

    public boolean hasValueHandle() {
        return this.HasValueHandle;
    }

    public boolean isUsedByMetadata() {
        return this.IsUsedByMD;
    }

    public Value stripPointerCasts() {
        return ValueStatics.stripPointerCastsAndOffsets(PointerStripKind.PSK_ZeroIndicesAndAliases, this);
    }

    public Value stripPointerCasts$Const() {
        return this.stripPointerCasts();
    }

    public Value stripPointerCastsNoFollowAliases() {
        return ValueStatics.stripPointerCastsAndOffsets(PointerStripKind.PSK_ZeroIndices, this);
    }

    public Value stripPointerCastsNoFollowAliases$Const() {
        return this.stripPointerCastsNoFollowAliases();
    }

    public Value stripInBoundsConstantOffsets() {
        return ValueStatics.stripPointerCastsAndOffsets(PointerStripKind.PSK_InBoundsConstantIndices, this);
    }

    public Value stripInBoundsConstantOffsets$Const() {
        return this.stripInBoundsConstantOffsets();
    }

    public Value stripAndAccumulateInBoundsConstantOffsets(DataLayout DL, APInt Offset) {
        if (!this.getType().isPointerTy()) {
            return this;
        }
        assert (Offset.getBitWidth() == DL.getPointerSizeInBits(IrRTTI.cast_PointerType(this.getType()).getAddressSpace())) : "The offset must have exactly as many bits as our pointer.";
        SmallPtrSet Visited = new SmallPtrSet((DenseMapInfo)DenseMapInfo.LikePtr.$Info(), 4);
        Visited.insert((Object)this);
        Value V = this;
        do {
            GEPOperator GEP;
            if ((GEP = IrRTTI.dyn_cast_GEPOperator(V)) != null) {
                if (!GEP.isInBounds()) {
                    return V;
                }
                APInt GEPOffset = new APInt(Offset);
                if (!GEP.accumulateConstantOffset(DL, GEPOffset)) {
                    return V;
                }
                Offset.$assign(GEPOffset);
                V = GEP.getPointerOperand();
            } else if (Operator.getOpcode(V) == 47) {
                V = IrRTTI.cast_User(V).getOperand(0);
            } else {
                GlobalAlias GA = IrRTTI.dyn_cast_GlobalAlias(V);
                if (GA != null) {
                    V = GA.getAliasee();
                } else {
                    Object RV;
                    CallSite CS = new CallSite(V);
                    if (CS.$bool() && (RV = CS.getReturnedArgOperand()) != null) {
                        V = RV;
                        continue;
                    }
                    return V;
                }
            }
            assert (V.getType().isPointerTy()) : "Unexpected operand type!";
        } while (Visited.insert((Object)V).second);
        return V;
    }

    public Value stripAndAccumulateInBoundsConstantOffsets$Const(DataLayout DL, APInt Offset) {
        return this.stripAndAccumulateInBoundsConstantOffsets(DL, Offset);
    }

    public Value stripInBoundsOffsets() {
        return ValueStatics.stripPointerCastsAndOffsets(PointerStripKind.PSK_InBounds, this);
    }

    public Value stripInBoundsOffsets$Const() {
        return this.stripInBoundsOffsets();
    }

    public int getPointerDereferenceableBytes(DataLayout DL, bool.ref CanBeNull) {
        assert (this.getType().isPointerTy()) : "must be pointer";
        int DerefBytes = 0;
        CanBeNull.$set(false);
        Argument A2 = IrRTTI.dyn_cast_Argument(this);
        if (A2 != null) {
            DerefBytes = Unsigned.$ulong2uint((long)A2.getDereferenceableBytes());
            if (DerefBytes == 0 && A2.hasByValAttr() && A2.getType().isSized()) {
                DerefBytes = Unsigned.$ulong2uint((long)DL.getTypeStoreSize(A2.getType()));
                CanBeNull.$set(false);
            }
            if (DerefBytes == 0) {
                DerefBytes = Unsigned.$ulong2uint((long)A2.getDereferenceableOrNullBytes());
                CanBeNull.$set(true);
            }
        } else {
            ImmutableCallSite CS = new ImmutableCallSite(this);
            if (CS.$bool()) {
                DerefBytes = Unsigned.$ulong2uint((long)CS.getDereferenceableBytes(Unsigned.$int2ushort((int)0)));
                if (DerefBytes == 0) {
                    DerefBytes = Unsigned.$ulong2uint((long)CS.getDereferenceableOrNullBytes(Unsigned.$int2ushort((int)0)));
                    CanBeNull.$set(true);
                }
            } else {
                LoadInst LI = IrRTTI.dyn_cast_LoadInst(this);
                if (LI != null) {
                    ConstantInt CI;
                    MDNode MD = LI.getMetadata(LLVMContext.Unnamed_enum.MD_dereferenceable.getValue());
                    if (MD != null) {
                        CI = MdconstGlobals.extract$ValidPointer(ConstantInt.class, MD.getOperand(0));
                        DerefBytes = Unsigned.$ulong2uint((long)CI.getLimitedValue());
                    }
                    if (DerefBytes == 0) {
                        MD = LI.getMetadata(LLVMContext.Unnamed_enum.MD_dereferenceable_or_null.getValue());
                        if (MD != null) {
                            CI = MdconstGlobals.extract$ValidPointer(ConstantInt.class, MD.getOperand(0));
                            DerefBytes = Unsigned.$ulong2uint((long)CI.getLimitedValue());
                        }
                        CanBeNull.$set(true);
                    }
                } else {
                    AllocaInst AI = IrRTTI.dyn_cast_AllocaInst(this);
                    if (AI != null) {
                        if (AI.getAllocatedType().isSized()) {
                            DerefBytes = Unsigned.$ulong2uint((long)DL.getTypeStoreSize(AI.getAllocatedType()));
                            CanBeNull.$set(false);
                        }
                    } else {
                        GlobalVariable GV = IrRTTI.dyn_cast_GlobalVariable(this);
                        if (GV != null && GV.getValueType().isSized() && !GV.hasExternalWeakLinkage()) {
                            DerefBytes = Unsigned.$ulong2uint((long)DL.getTypeStoreSize(GV.getValueType()));
                            CanBeNull.$set(false);
                        }
                    }
                }
            }
        }
        return DerefBytes;
    }

    public int getPointerAlignment(DataLayout DL) {
        assert (this.getType().isPointerTy()) : "must be pointer";
        int Align = 0;
        GlobalObject GO = IrRTTI.dyn_cast_GlobalObject(this);
        if (GO != null) {
            Type ObjectType;
            GlobalVariable GVar;
            Align = GO.getAlignment();
            if (Align == 0 && (GVar = IrRTTI.dyn_cast_GlobalVariable(GO)) != null && (ObjectType = GVar.getValueType()).isSized()) {
                Align = GVar.isStrongDefinitionForLinker() ? DL.getPreferredAlignment(GVar) : DL.getABITypeAlignment(ObjectType);
            }
        } else {
            Argument A2 = IrRTTI.dyn_cast_Argument(this);
            if (A2 != null) {
                Type EltTy;
                Align = A2.getParamAlignment();
                if (Align == 0 && A2.hasStructRetAttr() && (EltTy = IrRTTI.cast_PointerType(A2.getType()).getElementType()).isSized()) {
                    Align = DL.getABITypeAlignment(EltTy);
                }
            } else {
                AllocaInst AI = IrRTTI.dyn_cast_AllocaInst(this);
                if (AI != null) {
                    Type AllocatedType;
                    Align = AI.getAlignment();
                    if (Align == 0 && (AllocatedType = AI.getAllocatedType()).isSized()) {
                        Align = DL.getPrefTypeAlignment(AllocatedType);
                    }
                } else {
                    ImmutableCallSite CS = new ImmutableCallSite(this);
                    if (CS.$bool()) {
                        Align = CS.getAttributes().getParamAlignment(AttributeSet.AttrIndex.ReturnIndex.getValue());
                    } else {
                        MDNode MD;
                        LoadInst LI = IrRTTI.dyn_cast_LoadInst(this);
                        if (LI != null && (MD = LI.getMetadata(LLVMContext.Unnamed_enum.MD_align.getValue())) != null) {
                            ConstantInt CI = MdconstGlobals.extract$ValidPointer(ConstantInt.class, MD.getOperand(0));
                            Align = Unsigned.$ulong2uint((long)CI.getLimitedValue());
                        }
                    }
                }
            }
        }
        return Align;
    }

    public Value DoPHITranslation(BasicBlock CurBB, BasicBlock PredBB) {
        PHINode PN = IrRTTI.dyn_cast_PHINode(this);
        if (PN != null && PN.getParent() == CurBB) {
            return PN.getIncomingValueForBlock(PredBB);
        }
        return this;
    }

    public Value DoPHITranslation$Const(BasicBlock CurBB, BasicBlock PredBB) {
        return this.DoPHITranslation(CurBB, PredBB);
    }

    public void mutateType(Type Ty) {
        this.VTy = Ty;
    }

    public <Compare> void sortUseList(Compare Cmp) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public void reverseUseList() {
        throw new UnsupportedOperationException("EmptyBody");
    }

    private static <Compare> type.ptr<Use> mergeUseLists(type.ptr<Use> L, type.ptr<Use> R, Compare Cmp) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    private static <Compare> void mergeUseListsImpl(type.ptr<Use> L, type.ptr<Use> R, type.ptr<Use> Next, Compare Cmp) {
        throw new UnsupportedOperationException("<<<DeclJavaPrinter::VisitFunctionDecl NULL BODY IN USED Translation Unit>>>");
    }

    protected char getSubclassDataFromValue() {
        return this.SubclassData;
    }

    protected void setValueSubclassData(char D2) {
        this.SubclassData = D2;
    }

    protected Value() {
        this.UseList = null;
    }

    private int $sizeof_Value() {
        return 3 * NativeType.$sizeof_ptr() + 2 * NativeType.$sizeof_UInt();
    }

    public boolean $isSentinel() {
        return this.UseList == null;
    }

    public String toString() {
        if (this.$isSentinel()) {
            return "Sentinel " + this.getClass().getSimpleName();
        }
        return " Name=[" + (this.HasName ? this.getName().toJavaString() : "<no name>") + "], VTy=[" + this.VTy + "], EmptyUseList=" + (this.UseList == null || this.UseList.$deref() == null) + ", SubclassID=" + Unsigned.$uchar2uint((byte)this.SubclassID) + ", HasValueHandle=" + this.HasValueHandle + ", SubclassOptionalData=" + Unsigned.$uchar2uint((byte)this.SubclassOptionalData) + ", SubclassData=" + Unsigned.$ushort2uint((char)this.SubclassData) + ", NumUserOperands=" + this.NumUserOperands + ", IsUsedByMD=" + this.IsUsedByMD + ", HasHungOffUses=" + this.HasHungOffUses + ", HasDescriptor=" + this.HasDescriptor;
    }

    public static final class ValueTy
    extends Enum<ValueTy>
    implements Native.NativeUIntEnum {
        public static final /* enum */ ValueTy ArgumentVal = new ValueTy(0);
        public static final /* enum */ ValueTy BasicBlockVal = new ValueTy(ArgumentVal.getValue() + 1);
        public static final /* enum */ ValueTy MemoryUseVal = new ValueTy(BasicBlockVal.getValue() + 1);
        public static final /* enum */ ValueTy MemoryDefVal = new ValueTy(MemoryUseVal.getValue() + 1);
        public static final /* enum */ ValueTy MemoryPhiVal = new ValueTy(MemoryDefVal.getValue() + 1);
        public static final /* enum */ ValueTy FunctionVal = new ValueTy(MemoryPhiVal.getValue() + 1);
        public static final /* enum */ ValueTy GlobalAliasVal = new ValueTy(FunctionVal.getValue() + 1);
        public static final /* enum */ ValueTy GlobalIFuncVal = new ValueTy(GlobalAliasVal.getValue() + 1);
        public static final /* enum */ ValueTy GlobalVariableVal = new ValueTy(GlobalIFuncVal.getValue() + 1);
        public static final /* enum */ ValueTy BlockAddressVal = new ValueTy(GlobalVariableVal.getValue() + 1);
        public static final /* enum */ ValueTy ConstantExprVal = new ValueTy(BlockAddressVal.getValue() + 1);
        public static final /* enum */ ValueTy ConstantArrayVal = new ValueTy(ConstantExprVal.getValue() + 1);
        public static final /* enum */ ValueTy ConstantStructVal = new ValueTy(ConstantArrayVal.getValue() + 1);
        public static final /* enum */ ValueTy ConstantVectorVal = new ValueTy(ConstantStructVal.getValue() + 1);
        public static final /* enum */ ValueTy UndefValueVal = new ValueTy(ConstantVectorVal.getValue() + 1);
        public static final /* enum */ ValueTy ConstantAggregateZeroVal = new ValueTy(UndefValueVal.getValue() + 1);
        public static final /* enum */ ValueTy ConstantDataArrayVal = new ValueTy(ConstantAggregateZeroVal.getValue() + 1);
        public static final /* enum */ ValueTy ConstantDataVectorVal = new ValueTy(ConstantDataArrayVal.getValue() + 1);
        public static final /* enum */ ValueTy ConstantIntVal = new ValueTy(ConstantDataVectorVal.getValue() + 1);
        public static final /* enum */ ValueTy ConstantFPVal = new ValueTy(ConstantIntVal.getValue() + 1);
        public static final /* enum */ ValueTy ConstantPointerNullVal = new ValueTy(ConstantFPVal.getValue() + 1);
        public static final /* enum */ ValueTy ConstantTokenNoneVal = new ValueTy(ConstantPointerNullVal.getValue() + 1);
        public static final /* enum */ ValueTy MetadataAsValueVal = new ValueTy(ConstantTokenNoneVal.getValue() + 1);
        public static final /* enum */ ValueTy InlineAsmVal = new ValueTy(MetadataAsValueVal.getValue() + 1);
        public static final /* enum */ ValueTy InstructionVal = new ValueTy(InlineAsmVal.getValue() + 1);
        public static final /* enum */ ValueTy ConstantFirstVal = new ValueTy(FunctionVal.getValue());
        public static final /* enum */ ValueTy ConstantLastVal = new ValueTy(ConstantTokenNoneVal.getValue());
        public static final /* enum */ ValueTy ConstantDataFirstVal = new ValueTy(UndefValueVal.getValue());
        public static final /* enum */ ValueTy ConstantDataLastVal = new ValueTy(ConstantTokenNoneVal.getValue());
        public static final /* enum */ ValueTy ConstantAggregateFirstVal = new ValueTy(ConstantArrayVal.getValue());
        public static final /* enum */ ValueTy ConstantAggregateLastVal = new ValueTy(ConstantVectorVal.getValue());
        private final int value;
        private static final /* synthetic */ ValueTy[] $VALUES;

        public static ValueTy[] values() {
            return (ValueTy[])$VALUES.clone();
        }

        public static ValueTy valueOf(String name) {
            return Enum.valueOf(ValueTy.class, name);
        }

        public static ValueTy valueOf(int val) {
            ValueTy out;
            ValueTy valueTy = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private ValueTy(int val) {
            this.value = val;
        }

        public final int getValue() {
            return this.value;
        }

        static {
            $VALUES = new ValueTy[]{ArgumentVal, BasicBlockVal, MemoryUseVal, MemoryDefVal, MemoryPhiVal, FunctionVal, GlobalAliasVal, GlobalIFuncVal, GlobalVariableVal, BlockAddressVal, ConstantExprVal, ConstantArrayVal, ConstantStructVal, ConstantVectorVal, UndefValueVal, ConstantAggregateZeroVal, ConstantDataArrayVal, ConstantDataVectorVal, ConstantIntVal, ConstantFPVal, ConstantPointerNullVal, ConstantTokenNoneVal, MetadataAsValueVal, InlineAsmVal, InstructionVal, ConstantFirstVal, ConstantLastVal, ConstantDataFirstVal, ConstantDataLastVal, ConstantAggregateFirstVal, ConstantAggregateLastVal};
        }

        private static final class Values {
            private static final ValueTy[] VALUES;
            private static final ValueTy[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (ValueTy kind : ValueTy.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new ValueTy[min < 0 ? 1 - min : 0];
                VALUES = new ValueTy[max >= 0 ? 1 + max : 0];
                for (ValueTy kind : ValueTy.values()) {
                    if (kind.value < 0) {
                        if (_VALUES[-kind.value] != null) continue;
                        Values._VALUES[-((ValueTy)kind).value] = kind;
                        continue;
                    }
                    if (VALUES[kind.value] != null) continue;
                    Values.VALUES[((ValueTy)kind).value] = kind;
                }
            }
        }
    }

    public static class user_iterator_impl<UserTy extends User>
    implements std.iterator<std.forward_iterator_tag, UserTy>,
    type.iterator<user_iterator_impl<UserTy>, UserTy> {
        private use_iterator_impl<Use> UI;

        private user_iterator_impl(Use U) {
            this.UI = new use_iterator_impl(U, null);
        }

        public user_iterator_impl() {
            this.UI = new use_iterator_impl();
        }

        public boolean $eq(user_iterator_impl<UserTy> x) {
            return this.UI.$eq(x.UI);
        }

        public boolean $noteq(user_iterator_impl<UserTy> x) {
            return Native.$not((boolean)this.$eq(x));
        }

        public boolean atEnd() {
            return Native.$eq_ptr((Object)this, new user_iterator_impl<UserTy>());
        }

        public user_iterator_impl<UserTy> $preInc() {
            this.UI.$preInc();
            return this;
        }

        public user_iterator_impl<UserTy> $postInc(int $Prm0) {
            user_iterator_impl tmp = (user_iterator_impl)Native.$Clone((NativeCloneable)this);
            this.$preInc();
            return tmp;
        }

        public UserTy $star() {
            return (UserTy)((Use)this.UI.$arrow()).getUser();
        }

        public UserTy $arrow() {
            return (UserTy)this.$star();
        }

        public user_iterator_impl<UserTy> $user_iterator_impl$UserTy$C() {
            return new user_iterator_impl<UserTy>(((use_iterator_impl)this.UI).U);
        }

        public Use getUse() {
            return (Use)Native.$Deref(this.UI);
        }

        public type.ptr<Use> getUsePtr() {
            return this.UI.getPtr();
        }

        public user_iterator_impl(user_iterator_impl<UserTy> $Prm0) {
            this.UI = (use_iterator_impl)Native.$Clone($Prm0.UI);
        }

        public user_iterator_impl<UserTy> clone() {
            return new user_iterator_impl<UserTy>(this);
        }

        public boolean $eq(Object other) {
            return this.$eq((user_iterator_impl)other);
        }

        void $assign(user_iterator_impl<UserTy> other) {
            this.UI = (use_iterator_impl)Native.$Clone(other.UI);
        }

        void $assignMove(user_iterator_impl<UserTy> other) {
            this.UI = other.UI;
            other.UI = null;
        }

        public String toString() {
            return "UI=" + this.UI + super.toString();
        }
    }

    public static class use_iterator_impl<UseT extends Use>
    implements std.iterator<std.forward_iterator_tag, UseT>,
    type.iterator<use_iterator_impl<UseT>, UseT> {
        private UseT U;

        private use_iterator_impl(UseT u) {
            this.U = u;
        }

        public use_iterator_impl() {
            this.U = null;
        }

        public boolean $eq(use_iterator_impl<UseT> x) {
            return this.U == x.U;
        }

        public boolean $noteq(use_iterator_impl<UseT> x) {
            return Native.$not((boolean)this.$eq(x));
        }

        public use_iterator_impl<UseT> $preInc() {
            assert (Native.$bool(this.U)) : "Cannot increment end iterator!";
            this.U = ((Use)this.U).getNext();
            return this;
        }

        public use_iterator_impl<UseT> $postInc(int $Prm0) {
            use_iterator_impl tmp = (use_iterator_impl)Native.$Clone((NativeCloneable)this);
            this.$preInc();
            return tmp;
        }

        public UseT $star() {
            assert (Native.$bool(this.U)) : "Cannot dereference end iterator!";
            return (UseT)((Use)Native.$Deref(this.U));
        }

        public UseT $arrow() {
            return (UseT)((Use)Native.$AddrOf((Object)this.$star()));
        }

        public use_iterator_impl<UseT> $use_iterator_impl$UseT$C() {
            return new use_iterator_impl<UseT>(this.U);
        }

        public type.ptr<UseT> getPtr() {
            return ((Use)this.U).$This$Ptr();
        }

        public use_iterator_impl<UseT> clone() {
            return new use_iterator_impl<UseT>(this.U);
        }

        int $sub(type.ptr<UseT> other) {
            return this.getPtr().$sub(other);
        }

        public boolean $eq(Object other) {
            return this.$eq((use_iterator_impl)other);
        }

        public String toString() {
            return "U=" + this.U + super.toString();
        }

        /* synthetic */ use_iterator_impl(Use x0, 1 x1) {
            this(x0);
        }
    }
}

