/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import java.util.LinkedList;
import org.clank.java.std;
import org.clank.support.Casts;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCallback;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.NativeTrace;
import org.clank.support.NativeType;
import org.clank.support.ThreadLocalThisSupplier;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.clank.support.void;
import org.llvm.adt.MutableArrayRefUChar;
import org.llvm.adt.PointerIntPair;
import org.llvm.adt.aliases.ArrayRefByte;
import org.llvm.adt.iterator_adaptor_base;
import org.llvm.adt.iterator_range;
import org.llvm.ir.OperandTraits;
import org.llvm.ir.Type;
import org.llvm.ir.Use;
import org.llvm.ir.Value;
import org.llvm.ir.impl.DescriptorInfo;
import org.llvm.ir.java.IUser;
import org.llvm.ir.java.IrRTTI;
import org.llvm.ir.java.OperandTraitsRegistry;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;

public class User
extends Value
implements IUser,
Destructors.ClassWithDestructor {
    private static final ThreadLocal<LinkedList<UserCreationData>> creationData = ThreadLocal.withInitial(() -> new LinkedList());
    private static final ThreadLocalThisSupplier<User> MemorySupplier = ThreadLocalThisSupplier.Create(User::assertThisConsumedByCtor, (String)User.class.getName(), (boolean)false);
    private final type.ptr<?> $This = Native.$toConst((type.ptr)MemorySupplier.consumeAssignedMemory((Object)this));

    protected User(User $Prm0) {
        super($Prm0);
        throw new UnsupportedOperationException("Deleted");
    }

    protected void anchor() {
    }

    private static <T extends User> T allocateFixedOperandUser(int Us, int DescBytes, NativeCallback.New.ConstructorCallback<T> $Ctor) {
        assert (Unsigned.$less_uint((int)Us, (int)0x10000000)) : "Too many operands";
        boolean hasDescription = DescBytes > 0;
        int $ExtraJavaObjectsToAlloc = Us + (hasDescription ? 1 : 0);
        Object[] data = new Object[1 + $ExtraJavaObjectsToAlloc];
        type.ptr Storage = NativePointer.create_type$ptr((Object[])data);
        type.ptr Start = (type.ptr)Storage.$add(hasDescription ? 1 : 0);
        type.ptr End = (type.ptr)Native.$tryClone((NativeCloneable)((type.ptr)Start.$add(Us)));
        type.ptr Result2 = (type.ptr)End.clone();
        UserCreationData Obj = new UserCreationData();
        Obj.NumUserOperands = Us;
        Obj.HasHungOffUses = false;
        Obj.HasDescriptor = DescBytes != 0;
        Obj.$this = Result2;
        LinkedList<UserCreationData> stack = creationData.get();
        assert (stack != null) : "creationData list should be prepared!";
        stack.addLast(Obj);
        Use.initTags((type.ptr<Use>)Start, (type.ptr<Use>)End);
        if (DescBytes != 0) {
            DescriptorInfo DescInfo = new DescriptorInfo(DescBytes);
            Storage.$assign((Object)DescInfo);
        }
        T out = User.callConstructorImpl(Result2, $Ctor);
        assert (out == Obj.$this.$star()) : "created object " + NativeTrace.getIdentityStr(out) + " must be the same as assigned into $this " + NativeTrace.getIdentityStr((Object)UserCreationData.access$100(Obj).$star());
        return out;
    }

    protected User(Type ty, int vty, type.ptr<Use> $Prm2, int NumOps) {
        super(ty, vty);
        this.$init();
        assert (Unsigned.$less_uint((int)NumOps, (int)0x10000000)) : "Too many operands";
        this.NumUserOperands = NumOps;
        assert (!this.HasHungOffUses || !Native.$bool(this.getOperandList())) : "Error in initializing hung off uses for User";
    }

    protected void allocHungoffUses(int N) {
        this.allocHungoffUses(N, false);
    }

    protected void allocHungoffUses(int N, boolean IsPhi) {
        assert (this.HasHungOffUses) : "alloc must have hung off uses";
        std.static_assert((boolean)Unsigned.$greatereq_uint((int)1, (int)1), (char.ptr)NativePointer.$((String)"Alignment is insufficient for 'hung-off-uses' pieces"));
        std.static_assert((boolean)Unsigned.$greatereq_uint((int)1, (int)1), (char.ptr)NativePointer.$((String)"Alignment is insufficient for 'hung-off-uses' pieces"));
        int size = N * User.$sizeof_Use() + User.$sizeof_PointerUIntPair$User$P();
        if (IsPhi) {
            size += N * NativeType.$sizeof_ptr();
        }
        Object[] $data = new Use[size];
        type.ptr Begin = NativePointer.create_type$ptr((Object[])$data);
        type.ptr End = (type.ptr)Native.$tryClone((NativeCloneable)((type.ptr)Begin.$add(N)));
        End.$set(Native.$new_uint_voidPtr((Object)End, New$Mem -> new PointerIntPair((Object)this, 1)));
        this.setOperandList(Use.initTags((type.ptr<Use>)NativePointer.create_type$ptr((Object[])$data), (type.ptr<Use>)NativePointer.create_type$ptr((Object[])$data, (int)size)));
    }

    protected void growHungoffUses(int NewNumUses) {
        this.growHungoffUses(NewNumUses, false);
    }

    protected void growHungoffUses(int NewNumUses, boolean IsPhi) {
        assert (this.HasHungOffUses) : "realloc must have hung off uses";
        int OldNumUses = this.getNumOperands();
        assert (Unsigned.$greater_uint((int)NewNumUses, (int)OldNumUses)) : "realloc must grow num uses";
        type.ptr OldOps = (type.ptr)Native.$tryClone(this.getOperandList());
        this.allocHungoffUses(NewNumUses, IsPhi);
        type.ptr NewOps = (type.ptr)Native.$tryClone(this.getOperandList());
        std.copy((type.iterator)OldOps, (type.iterator)((type.iterator)OldOps.$add(OldNumUses)), (type.iterator)NewOps);
        if (IsPhi) {
            char.ptr OldPtr = Native.$tryClone((char.ptr)((char.ptr)((char.ptr)Casts.reinterpret_cast(char.ptr.class, (void.ptr)((void.ptr)OldOps.$add(OldNumUses)))).$add(User.$sizeof_PointerUIntPair$User$P())));
            char.ptr NewPtr = Native.$tryClone((char.ptr)((char.ptr)((char.ptr)Casts.reinterpret_cast(char.ptr.class, (void.ptr)((void.ptr)NewOps.$add(NewNumUses)))).$add(User.$sizeof_PointerUIntPair$User$P())));
            std.copy((char.iterator)OldPtr, (char.iterator)((char.iterator)OldPtr.$add(OldNumUses * NativeType.$sizeof_ptr())), (char.iterator)NewPtr);
        }
        Use.zap((type.ptr<Use>)OldOps, (type.ptr<Use>)((type.ptr)OldOps.$add(OldNumUses)), true);
    }

    @Override
    public void $destroy() {
        super.$destroy();
    }

    public static void $delete(User Usr) {
        User Obj = Usr;
        if (Obj.HasHungOffUses) {
            assert (!Obj.HasDescriptor) : "not supported!";
            type.ptr HungOffOperandList = (type.ptr)Native.$tryClone((NativeCloneable)((type.ptr)Usr.$This.$sub(1)));
            Use.zap((type.ptr<Use>)HungOffOperandList, (type.ptr<Use>)((type.ptr)HungOffOperandList.$add(Obj.NumUserOperands)), true);
        } else if (Obj.HasDescriptor) {
            type.ptr UseBegin = (type.ptr)Native.$tryClone((NativeCloneable)((type.ptr)Usr.$This.$sub(Obj.NumUserOperands)));
            Use.zap((type.ptr<Use>)UseBegin, (type.ptr<Use>)((type.ptr)UseBegin.$add(Obj.NumUserOperands)), false);
            type.ptr DI = (type.ptr)UseBegin.$sub(1);
            type.ptr ptr2 = (type.ptr)Native.$tryClone((NativeCloneable)((type.ptr)DI.$sub(((DescriptorInfo)DI.$arrow()).SizeInBytes)));
        } else {
            type.ptr Storage = (type.ptr)Native.$tryClone((NativeCloneable)((type.ptr)Usr.$This.$sub(Obj.NumUserOperands)));
            Use.zap((type.ptr<Use>)Storage, (type.ptr<Use>)((type.ptr)Storage.$add(Obj.NumUserOperands)), false);
        }
    }

    public static void $delete(Object $Prm0, int $Prm1) {
        throw new llvm_unreachable("Constructor throws?");
    }

    public static void $delete(Object $Prm0, int $Prm1, boolean $Prm2) {
        throw new llvm_unreachable("Constructor throws?");
    }

    protected <U extends User> Use OpFrom(int Idx, U that) {
        return Idx < 0 ? (Use)that.$OperandTraits().op_end$$(that).$at(Idx) : (Use)that.$OperandTraits().op_begin$$(that).$at(Idx);
    }

    protected <U extends User> type.ptr<Use> OpFrom$Addr(int Idx, U that) {
        return Idx < 0 ? (type.ptr)that.$OperandTraits().op_end$$(that).$add(Idx) : (type.ptr)that.$OperandTraits().op_begin$$(that).$add(Idx);
    }

    protected static <U extends IUser> type.ptr<Use> OpFrom$Addr(int Idx, IUser that, OperandTraits<U> $traits) {
        return Idx < 0 ? (type.ptr)$traits.op_end$$(that).$add(Idx) : (type.ptr)$traits.op_begin$$(that).$add(Idx);
    }

    protected static <U extends User> type.ptr<Use> OpFrom$Addr(int Idx, IUser that, Class<U> clazz) {
        OperandTraits<User> $traits = OperandTraitsRegistry.get(clazz);
        return Idx < 0 ? (type.ptr)$traits.op_end$$(that).$add(Idx) : (type.ptr)$traits.op_begin$$(that).$add(Idx);
    }

    protected Use Op(int Idx) {
        return this.OpFrom(Idx, this);
    }

    protected type.ptr<Use> Op$Addr(int Idx_nocapture) {
        return this.OpFrom$Addr(Idx_nocapture, this);
    }

    protected Use Op$Const(int Idx) {
        return this.OpFrom(Idx, this);
    }

    @Override
    public type.ptr<Use> getHungOffOperands() {
        type.ptr p = (type.ptr)this.$This$Ptr().$sub(1);
        if (p.$star() == null) {
            type.ptr res = NativePointer.create_type$ptr();
            p.$assign((Object)res);
            return res;
        }
        return (type.ptr)p.$star();
    }

    @Override
    public type.ptr<Use> getIntrusiveOperands() {
        return (type.ptr)((type.ptr)Casts.reinterpret_cast(type.ptr.class, this.$This)).$sub(this.NumUserOperands);
    }

    private void setOperandList(type.ptr<Use> NewList) {
        assert (this.HasHungOffUses) : "Setting operand list only required for hung off uses";
        this.getHungOffOperands().$assign(NewList);
    }

    @Override
    public type.ptr<Use> getOperandList() {
        return this.HasHungOffUses ? this.getHungOffOperands() : this.getIntrusiveOperands();
    }

    public type.ptr<Use> getOperandList$Const() {
        return this.getOperandList();
    }

    public Value getOperand(int i) {
        assert (Unsigned.$less_uint((int)i, (int)this.NumUserOperands)) : "getOperand() out of range!";
        return ((Use)this.getOperandList$Const().$at(i)).$Value$P();
    }

    public void setOperand(int i, Value Val) {
        assert (Unsigned.$less_uint((int)i, (int)this.NumUserOperands)) : "setOperand() out of range!";
        assert (!IrRTTI.isa_Constant(this) || IrRTTI.isa_GlobalValue(this)) : "Cannot mutate a constant with setOperand!";
        ((Use)this.getOperandList().$at(i)).$assign(Val);
    }

    public Use getOperandUse$Const(int i) {
        assert (Unsigned.$less_uint((int)i, (int)this.NumUserOperands)) : "getOperandUse() out of range!";
        return (Use)this.getOperandList$Const().$at(i);
    }

    public Use getOperandUse(int i) {
        assert (Unsigned.$less_uint((int)i, (int)this.NumUserOperands)) : "getOperandUse() out of range!";
        return (Use)this.getOperandList().$at(i);
    }

    @Override
    public int getNumOperands() {
        return this.NumUserOperands;
    }

    public ArrayRefByte.C getDescriptor$Const() {
        MutableArrayRefUChar MutableARef = this.getDescriptor();
        return new ArrayRefByte.C(MutableARef.begin(), MutableARef.end());
    }

    public MutableArrayRefUChar getDescriptor() {
        assert (this.HasDescriptor) : "Don't call otherwise!";
        assert (!this.HasHungOffUses) : "Invariant!";
        type.ptr DI = (type.ptr)Casts.reinterpret_cast(type.ptr.class, (void.ptr)((void.ptr)this.getIntrusiveOperands().$sub(1)));
        assert (DI.$star() != null) : "Null descriptor!";
        assert (((DescriptorInfo)DI.$star()).SizeInBytes != 0) : "Should not have had a descriptor otherwise!";
        return new MutableArrayRefUChar(((DescriptorInfo)DI.$star()).data);
    }

    public void setGlobalVariableNumOperands(int NumOps) {
        assert (Unsigned.$lesseq_uint((int)NumOps, (int)1)) : "GlobalVariable can only have 0 or 1 operands";
        this.NumUserOperands = NumOps;
    }

    public void setNumHungOffUseOperands(int NumOps) {
        assert (this.HasHungOffUses) : "Must have hung off uses to use this method";
        assert (Unsigned.$less_uint((int)NumOps, (int)0x10000000)) : "Too many operands";
        this.NumUserOperands = NumOps;
    }

    public type.ptr<Use> op_begin() {
        return this.getOperandList();
    }

    public type.ptr<Use> op_begin$Const() {
        return this.getOperandList$Const();
    }

    public type.ptr<Use> op_end() {
        return (type.ptr)this.getOperandList().$add(this.NumUserOperands);
    }

    public type.ptr<Use> op_end$Const() {
        return (type.ptr)this.getOperandList$Const().$add(this.NumUserOperands);
    }

    public iterator_range<Use> operands() {
        return new iterator_range(this.op_begin(), this.op_end());
    }

    public iterator_range<Use> operands$Const() {
        return new iterator_range(this.op_begin$Const(), this.op_end$Const());
    }

    public value_op_iterator value_op_begin() {
        return new value_op_iterator(this.op_begin());
    }

    public value_op_iterator value_op_end() {
        return new value_op_iterator(this.op_end());
    }

    public iterator_range<Value> operand_values() {
        return llvm.make_range((type.iterator)this.value_op_begin(), (type.iterator)this.value_op_end());
    }

    public void dropAllReferences() {
        for (Use U : this.operands()) {
            U.set(null);
        }
    }

    public void replaceUsesOfWith(Value From, Value To) {
        if (From == To) {
            return;
        }
        assert (!IrRTTI.isa_Constant(this) || IrRTTI.isa_GlobalValue(this)) : "Cannot call User::replaceUsesOfWith on a constant!";
        int E = this.getNumOperands();
        for (int i = 0; i != E; ++i) {
            if (this.getOperand(i) != From) continue;
            this.setOperand(i, To);
        }
    }

    public static boolean classof(Value V) {
        return IrRTTI.isa_Instruction(V) || IrRTTI.isa_Constant(V);
    }

    public static <T extends User> T $new_HangOffUses(NativeCallback.New.ConstructorCallback<T> $Ctor) {
        int $UsePtr = 1;
        Object[] data = new Object[1 + $UsePtr];
        type.ptr Start = NativePointer.create_type$ptr((Object[])data);
        type.ptr Result2 = (type.ptr)Start.$add($UsePtr);
        UserCreationData Obj = new UserCreationData();
        Obj.NumUserOperands = 0;
        Obj.HasHungOffUses = true;
        Obj.HasDescriptor = false;
        Obj.$this = Result2;
        LinkedList<UserCreationData> stack = creationData.get();
        assert (stack != null) : "creationData list should be prepared!";
        stack.addLast(Obj);
        T out = User.callConstructorImpl(Result2, $Ctor);
        assert (out == Obj.$this.$star()) : "created object " + NativeTrace.getIdentityStr(out) + " must be the same as assigned into $this " + NativeTrace.getIdentityStr((Object)UserCreationData.access$100(Obj).$star());
        return out;
    }

    public static <T extends User> T $new_FixedUses(int Us, NativeCallback.New.ConstructorCallback<T> $Ctor) {
        return User.allocateFixedOperandUser(Us, 0, $Ctor);
    }

    protected static <T extends User> T $new_FixedUsesAndDesc(int Us, int DescBytes, NativeCallback.New.ConstructorCallback<T> $Ctor) {
        return User.allocateFixedOperandUser(Us, DescBytes, $Ctor);
    }

    private void $init() {
        LinkedList<UserCreationData> stack = creationData.get();
        assert (stack != null) : "creationData list should be prepared!";
        assert (!stack.isEmpty()) : "creationData memory should be prepared!";
        UserCreationData d = stack.removeLast();
        assert (d != null) : "creationData should not be null!";
        this.NumUserOperands = d.NumUserOperands;
        this.HasHungOffUses = d.HasHungOffUses;
        this.HasDescriptor = d.HasDescriptor;
    }

    public static type.ptr<Use> getOperandList$beingCreated() {
        return User.peek$UserCreationData().getOperandList();
    }

    private static UserCreationData peek$UserCreationData() {
        LinkedList<UserCreationData> stack = creationData.get();
        assert (stack != null) : "creationData list should be prepared!";
        assert (!stack.isEmpty()) : "forgot to wrap constructor call in one of UserDerivedClass.$new_UserDerivedClass new operator calls?";
        UserCreationData d = stack.getLast();
        assert (d != null) : "creationData should not be null!";
        return d;
    }

    private static <T extends User> T callConstructorImpl(type.ptr<?> MemoryLocation, NativeCallback.New.ConstructorCallback<T> $Ctor) {
        User createdInstance = (User)$Ctor.$call(MemorySupplier.assignMemory(MemoryLocation));
        assert (MemorySupplier.assertConsumed((Object)createdInstance, MemoryLocation));
        return (T)createdInstance;
    }

    private static boolean assertThisConsumedByCtor(User createdInstance, type.ptr Mem) {
        assert (createdInstance.$This.$eq((Object)Mem)) : "expected " + Mem + " vs. " + createdInstance.$This;
        assert (Mem.$star() == createdInstance) : "createdInstance should be in Mem, but got: " + Mem.$star();
        return true;
    }

    @Override
    public type.ptr<?> $This$Ptr() {
        return this.$This;
    }

    protected static IUser $BEING_CREATED() {
        UserCreationData out = User.peek$UserCreationData();
        return out;
    }

    protected User() {
        this.$init();
    }

    protected static int $sizeof_PointerUIntPair$User$P() {
        return 1;
    }

    protected static int $sizeof_Use() {
        return 1;
    }

    protected static int $sizeof_DescriptorInfo() {
        return 1;
    }

    protected final OperandTraits<User> $OperandTraits() {
        OperandTraits<User> traits = OperandTraitsRegistry.get(this.getClass());
        assert (traits != null) : "OperandTraits for " + this.getClass().getName() + " not registered";
        return traits;
    }

    @Override
    public int getNumOperands$User() {
        return this.NumUserOperands;
    }

    public void $delete() {
        User.$delete(this);
    }

    @Override
    public String toString() {
        return "" + super.toString();
    }

    private static class UserCreationData
    implements IUser {
        public int NumUserOperands;
        public boolean HasHungOffUses;
        public boolean HasDescriptor;
        private type.ptr<?> $this;

        private UserCreationData() {
        }

        @Override
        public type.ptr<Use> getOperandList() {
            return this.HasHungOffUses ? this.getHungOffOperands() : this.getIntrusiveOperands();
        }

        @Override
        public type.ptr<Use> getHungOffOperands() {
            UserCreationData d = User.peek$UserCreationData();
            return (type.ptr)d.$this.$sub(1);
        }

        @Override
        public type.ptr<Use> getIntrusiveOperands() {
            UserCreationData d = User.peek$UserCreationData();
            return (type.ptr)d.$this.$sub(this.NumUserOperands);
        }

        @Override
        public type.ptr<?> $This$Ptr() {
            return this.$this;
        }

        @Override
        public int getNumOperands() {
            return this.NumUserOperands;
        }

        @Override
        public int getNumOperands$User() {
            return this.NumUserOperands;
        }
    }

    public static class value_op_iterator
    extends iterator_adaptor_base<value_op_iterator, type.ptr<Use>, std.random_access_iterator_tag, Value, Value> {
        public value_op_iterator() {
            this((type.ptr<Use>)((type.ptr)null));
        }

        public value_op_iterator(type.ptr<Use> U) {
            super(U);
        }

        public Value $star() {
            return ((Use)((type.ptr)this.I).$star()).$Value$P();
        }

        public Value $arrow() {
            return this.$star();
        }

        public value_op_iterator(value_op_iterator $Prm0) {
            super((iterator_adaptor_base)$Prm0);
        }

        public value_op_iterator(JavaDifferentiators.JD.Move _dparam, value_op_iterator $Prm0) {
            super(JavaDifferentiators.JD.Move.INSTANCE, (iterator_adaptor_base)$Prm0);
        }

        public value_op_iterator clone() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String toString() {
            return "" + super.toString();
        }
    }
}

