/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.aliases.type;
import org.llvm.adt.iterator_range;
import org.llvm.ir.BasicBlock;
import org.llvm.ir.Instruction;
import org.llvm.ir.Type;
import org.llvm.ir.Use;
import org.llvm.ir.Value;
import org.llvm.ir.java.IrRTTI;

public abstract class TerminatorInst
extends Instruction
implements Destructors.ClassWithDestructor {
    protected TerminatorInst(Type Ty, int iType, type.ptr<Use> Ops, int NumOps) {
        this(Ty, iType, Ops, NumOps, (Instruction)null);
    }

    protected TerminatorInst(Type Ty, int iType, type.ptr<Use> Ops, int NumOps, Instruction InsertBefore) {
        super(Ty, iType, Ops, NumOps, InsertBefore);
    }

    protected TerminatorInst(Type Ty, int iType, type.ptr<Use> Ops, int NumOps, BasicBlock InsertAtEnd) {
        super(Ty, iType, Ops, NumOps, InsertAtEnd);
    }

    @Override
    public void $destroy() {
        super.$destroy();
    }

    protected abstract BasicBlock getSuccessorV(int var1);

    protected abstract int getNumSuccessorsV();

    protected abstract void setSuccessorV(int var1, BasicBlock var2);

    public int getNumSuccessors() {
        return this.getNumSuccessorsV();
    }

    public BasicBlock getSuccessor(int idx) {
        return this.getSuccessorV(idx);
    }

    public void setSuccessor(int idx, BasicBlock B2) {
        this.setSuccessorV(idx, B2);
    }

    public static boolean classof(Instruction I) {
        return I.isTerminator();
    }

    public static boolean classof(Value V) {
        return IrRTTI.isa_Instruction(V) && TerminatorInst.classof(IrRTTI.cast_Instruction(V));
    }

    public boolean isExceptional() {
        switch (this.getOpcode()) {
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    private SuccIterator<TerminatorInst, BasicBlock> succ_begin() {
        return new SuccIterator<TerminatorInst, BasicBlock>(this);
    }

    private SuccIterator<TerminatorInst, BasicBlock> succ_begin$Const() {
        return new SuccIterator<TerminatorInst, BasicBlock>(this);
    }

    private SuccIterator<TerminatorInst, BasicBlock> succ_end() {
        return new SuccIterator<TerminatorInst, BasicBlock>(this, true);
    }

    private SuccIterator<TerminatorInst, BasicBlock> succ_end$Const() {
        return new SuccIterator<TerminatorInst, BasicBlock>(this, true);
    }

    public iterator_range<BasicBlock> successors() {
        return new iterator_range(this.succ_begin(), this.succ_end());
    }

    public iterator_range<BasicBlock> successors$Const() {
        return new iterator_range(this.succ_begin$Const(), this.succ_end$Const());
    }

    @Override
    public String toString() {
        return "" + super.toString();
    }

    public static class SuccIterator<Term extends TerminatorInst, BB extends BasicBlock>
    implements std.iterator<std.random_access_iterator_tag, BB>,
    type.iterator<SuccIterator, BB>,
    Native.NativeComparable {
        private Term TermInst;
        private int idx;

        private boolean index_is_valid(int idx) {
            return Native.$less((int)idx, (int)((TerminatorInst)this.TermInst).getNumSuccessors());
        }

        public SuccIterator(Term T2) {
            this.TermInst = (TerminatorInst)Native.$tryClone(T2);
            this.idx = 0;
        }

        public SuccIterator(Term T2, boolean $Prm1) {
            this.TermInst = (TerminatorInst)Native.$tryClone(T2);
            this.idx = Native.$bool(this.TermInst) ? ((TerminatorInst)this.TermInst).getNumSuccessors() : 0;
        }

        public int getSuccessorIndex() {
            return this.idx;
        }

        public boolean $eq(Object x) {
            return Native.$eq((int)this.idx, (int)((SuccIterator)x).idx);
        }

        public boolean $noteq(Object x) {
            return Native.$not((boolean)this.$eq(x));
        }

        public BB $star() {
            return (BB)((TerminatorInst)this.TermInst).getSuccessor(this.idx);
        }

        public BB $arrow() {
            return (BB)this.$star();
        }

        public SuccIterator<Term, BB> $preInc() {
            ++this.idx;
            return this;
        }

        public SuccIterator<Term, BB> $postInc(int $Prm0) {
            SuccIterator tmp = this;
            this.$preInc();
            return tmp;
        }

        public SuccIterator<Term, BB> $preDec() {
            --this.idx;
            return this;
        }

        public SuccIterator<Term, BB> $postDec(int $Prm0) {
            SuccIterator tmp = this;
            this.$preDec();
            return tmp;
        }

        public boolean $less(SuccIterator<Term, BB> x) {
            assert (Native.$bool((boolean)Native.$eq(this.TermInst, x.TermInst))) : "Cannot compare iterators of different blocks!";
            return Native.$less((int)this.idx, (int)x.idx);
        }

        public boolean $lesseq(SuccIterator<Term, BB> x) {
            assert (Native.$bool((boolean)Native.$eq(this.TermInst, x.TermInst))) : "Cannot compare iterators of different blocks!";
            return Native.$lesseq((int)this.idx, (int)x.idx);
        }

        public boolean $greatereq(SuccIterator<Term, BB> x) {
            assert (Native.$bool((boolean)Native.$eq(this.TermInst, x.TermInst))) : "Cannot compare iterators of different blocks!";
            return Native.$greatereq((int)this.idx, (int)x.idx);
        }

        public boolean $greater(SuccIterator<Term, BB> x) {
            assert (Native.$bool((boolean)Native.$eq(this.TermInst, x.TermInst))) : "Cannot compare iterators of different blocks!";
            return Native.$greater((int)this.idx, (int)x.idx);
        }

        public SuccIterator<Term, BB> $addassign(int Right) {
            int new_idx = Native.$add((int)this.idx, (int)Right);
            assert (Native.$bool((boolean)this.index_is_valid(new_idx))) : "Iterator index out of bound";
            this.idx = new_idx;
            return this;
        }

        public SuccIterator<Term, BB> $add(int Right) {
            SuccIterator tmp = this;
            tmp.$addassign(Right);
            return tmp;
        }

        public SuccIterator<Term, BB> $minusassign(int Right) {
            return this.$addassign(-Right);
        }

        public SuccIterator<Term, BB> $sub(int Right) {
            return this.$add(-Right);
        }

        public int $sub(SuccIterator<Term, BB> x) {
            assert (Native.$bool((boolean)Native.$eq(this.TermInst, x.TermInst))) : "Cannot work on iterators of different blocks!";
            int distance = this.idx - x.idx;
            return distance;
        }

        public SuccessorProxy $at(int offset) {
            SuccIterator tmp = this;
            tmp.$addassign(offset);
            return new SuccessorProxy(tmp);
        }

        public BB getSource() {
            assert (Native.$bool(this.TermInst)) : "Source not available, if basic block was malformed";
            return (BB)((Instruction)this.TermInst).getParent();
        }

        public SuccIterator(SuccIterator<Term, BB> other) {
            this.TermInst = other.TermInst;
            this.idx = other.idx;
        }

        public SuccIterator clone() {
            return new SuccIterator<Term, BB>(this);
        }

        public String toString() {
            return "TermInst=" + this.TermInst + ", idx=" + this.idx + super.toString();
        }

        private class SuccessorProxy {
            private SuccIterator<Term, BB> it;

            public SuccessorProxy(SuccIterator<Term, BB> it) {
                this.it = new SuccIterator(it);
            }

            public SuccessorProxy(SuccessorProxy $Prm0) {
            }

            public SuccessorProxy $assign(SuccessorProxy r) {
                this.$assign(new BasicBlock((BasicBlock)r.$BB()));
                return this;
            }

            public SuccessorProxy $assign(BB r) {
                this.it.TermInst.setSuccessor(this.it.idx, (BasicBlock)r);
                return this;
            }

            public BB $BB() {
                return this.it.$star();
            }

            public String toString() {
                return "it=" + this.it;
            }
        }
    }
}

