/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.clank.support.Casts;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCallback;
import org.clank.support.Unsigned;
import org.clank.support.aliases.type;
import org.llvm.adt.iterator_range;
import org.llvm.ir.BasicBlock;
import org.llvm.ir.ConstantInt;
import org.llvm.ir.Instruction;
import org.llvm.ir.OperandTraitsSwitchInst;
import org.llvm.ir.TerminatorInst;
import org.llvm.ir.Type;
import org.llvm.ir.Use;
import org.llvm.ir.User;
import org.llvm.ir.Value;
import org.llvm.ir.java.IrRTTI;
import org.llvm.support.llvm;

public class SwitchInst
extends TerminatorInst
implements Destructors.ClassWithDestructor {
    private int ReservedSpace;
    public static int DefaultPseudoIndex = -2;

    protected static Object $new_SwitchInst(int $Prm0, int $Prm1) {
        throw new UnsupportedOperationException("Deleted");
    }

    private SwitchInst(SwitchInst SI) {
        super(SI.getType(), 3, (type.ptr<Use>)((type.ptr)null), 0);
        this.init(SI.getCondition(), SI.getDefaultDest(), SI.getNumOperands());
        this.setNumHungOffUseOperands(SI.getNumOperands());
        type.ptr OL = (type.ptr)Native.$tryClone(this.getOperandList());
        type.ptr InOL = (type.ptr)Native.$tryClone(SI.getOperandList$Const());
        int E = SI.getNumOperands();
        for (int i = 2; i != E; i += 2) {
            ((Use)OL.$at(i)).$assign((Use)InOL.$at(i));
            ((Use)OL.$at(i + 1)).$assign((Use)InOL.$at(i + 1));
        }
        this.SubclassOptionalData = Unsigned.$uchar2uchar_7bits((byte)Unsigned.$7bits_uchar2uchar((byte)SI.SubclassOptionalData));
    }

    private void init(Value $Value, BasicBlock Default, int NumReserved) {
        assert ($Value != null && Default != null && NumReserved != 0);
        this.ReservedSpace = NumReserved;
        this.setNumHungOffUseOperands(2);
        this.allocHungoffUses(this.ReservedSpace);
        this.Op(0).$assign($Value);
        this.Op(1).$assign(Default);
    }

    private void growOperands() {
        int NumOps;
        int e = this.getNumOperands();
        this.ReservedSpace = NumOps = e * 3;
        this.growHungoffUses(this.ReservedSpace);
    }

    private static SwitchInst $new_SwitchInst(NativeCallback.New.ConstructorCallback<SwitchInst> s) {
        return User.$new_HangOffUses(s);
    }

    private SwitchInst(Value $Value, BasicBlock Default, int NumCases, Instruction InsertBefore) {
        super(Type.getVoidTy($Value.getContext()), 3, (type.ptr<Use>)((type.ptr)null), 0, InsertBefore);
        this.init($Value, Default, 2 + NumCases * 2);
    }

    private SwitchInst(Value $Value, BasicBlock Default, int NumCases, BasicBlock InsertAtEnd) {
        super(Type.getVoidTy($Value.getContext()), 3, (type.ptr<Use>)((type.ptr)null), 0, InsertAtEnd);
        this.init($Value, Default, 2 + NumCases * 2);
    }

    protected SwitchInst cloneImpl() {
        return SwitchInst.$new_SwitchInst((NativeCallback.New.ConstructorCallback<SwitchInst>)((NativeCallback.New.ConstructorCallback)New$Mem -> new SwitchInst(this)));
    }

    public static SwitchInst Create(Value $Value, BasicBlock Default, int NumCases) {
        return SwitchInst.Create($Value, Default, NumCases, (Instruction)null);
    }

    public static SwitchInst Create(Value $Value, BasicBlock Default, int NumCases, Instruction InsertBefore) {
        return SwitchInst.$new_SwitchInst((NativeCallback.New.ConstructorCallback<SwitchInst>)((NativeCallback.New.ConstructorCallback)New$Mem -> new SwitchInst($Value, Default, NumCases, InsertBefore)));
    }

    public static SwitchInst Create(Value $Value, BasicBlock Default, int NumCases, BasicBlock InsertAtEnd) {
        return SwitchInst.$new_SwitchInst((NativeCallback.New.ConstructorCallback<SwitchInst>)((NativeCallback.New.ConstructorCallback)New$Mem -> new SwitchInst($Value, Default, NumCases, InsertAtEnd)));
    }

    @Override
    public Value getOperand(int i_nocapture) {
        assert (Unsigned.$less_uint((int)i_nocapture, (int)OperandTraitsSwitchInst.operands(this))) : "getOperand() out of range!";
        return IrRTTI.cast_or_null_Value(((Use)OperandTraitsSwitchInst.op_begin(this).$at(i_nocapture)).get());
    }

    @Override
    public void setOperand(int i_nocapture, Value Val_nocapture) {
        assert (Unsigned.$less_uint((int)i_nocapture, (int)OperandTraitsSwitchInst.operands(this))) : "setOperand() out of range!";
        ((Use)OperandTraitsSwitchInst.op_begin(this).$at(i_nocapture)).$assign(Val_nocapture);
    }

    @Override
    public type.ptr<Use> op_begin() {
        return OperandTraitsSwitchInst.op_begin(this);
    }

    @Override
    public type.ptr<Use> op_begin$Const() {
        return OperandTraitsSwitchInst.op_begin(this);
    }

    @Override
    public type.ptr<Use> op_end() {
        return OperandTraitsSwitchInst.op_end(this);
    }

    @Override
    public type.ptr<Use> op_end$Const() {
        return OperandTraitsSwitchInst.op_end(this);
    }

    @Override
    protected Use Op(int Idx_nocapture) {
        return this.OpFrom(Idx_nocapture, this);
    }

    @Override
    protected Use Op$Const(int Idx_nocapture) {
        return this.OpFrom(Idx_nocapture, this);
    }

    @Override
    public int getNumOperands() {
        return OperandTraitsSwitchInst.operands(this);
    }

    public Value getCondition() {
        return this.getOperand(0);
    }

    public void setCondition(Value V) {
        this.setOperand(0, V);
    }

    public BasicBlock getDefaultDest() {
        return IrRTTI.cast_BasicBlock(this.getOperand(1));
    }

    public void setDefaultDest(BasicBlock DefaultCase) {
        this.setOperand(1, (Value)Casts.reinterpret_cast(Value.class, (Object)DefaultCase));
    }

    public int getNumCases() {
        return Unsigned.$div_uint((int)this.getNumOperands(), (int)2) - 1;
    }

    public CaseIt case_begin() {
        return new CaseIt(this, 0);
    }

    public CaseIteratorT<SwitchInst, ConstantInt, BasicBlock> case_begin$Const() {
        return new CaseIteratorT<SwitchInst, ConstantInt, BasicBlock>(this, 0);
    }

    public CaseIt case_end() {
        return new CaseIt(this, this.getNumCases());
    }

    public CaseIteratorT<SwitchInst, ConstantInt, BasicBlock> case_end$Const() {
        return new CaseIteratorT<SwitchInst, ConstantInt, BasicBlock>(this, this.getNumCases());
    }

    public iterator_range<CaseIteratorT> cases() {
        return llvm.make_range((type.iterator)this.case_begin(), (type.iterator)this.case_end());
    }

    public iterator_range<CaseIteratorT> cases$Const() {
        return llvm.make_range(this.case_begin$Const(), this.case_end$Const());
    }

    public CaseIt case_default() {
        return new CaseIt(this, DefaultPseudoIndex);
    }

    public CaseIteratorT<SwitchInst, ConstantInt, BasicBlock> case_default$Const() {
        return new CaseIteratorT<SwitchInst, ConstantInt, BasicBlock>(this, DefaultPseudoIndex);
    }

    public CaseIt findCaseValue(ConstantInt C2) {
        CaseIt i = this.case_begin();
        CaseIt e = this.case_end();
        while (i.$noteq(e)) {
            if (i.getCaseValue() == C2) {
                return i;
            }
            i.$preInc();
        }
        return this.case_default();
    }

    public CaseIteratorT<SwitchInst, ConstantInt, BasicBlock> findCaseValue$Const(ConstantInt C2) {
        CaseIteratorT<SwitchInst, ConstantInt, BasicBlock> i = this.case_begin$Const();
        CaseIteratorT<SwitchInst, ConstantInt, BasicBlock> e = this.case_end$Const();
        while (i.$noteq(e)) {
            if (i.getCaseValue() == C2) {
                return i;
            }
            i.$preInc();
        }
        return this.case_default$Const();
    }

    public ConstantInt findCaseDest(BasicBlock BB) {
        if (BB == this.getDefaultDest()) {
            return null;
        }
        ConstantInt CI = null;
        CaseIt i = this.case_begin();
        CaseIt e = this.case_end();
        while (i.$noteq(e)) {
            if (i.getCaseSuccessor() == BB) {
                if (CI != null) {
                    return null;
                }
                CI = (ConstantInt)i.getCaseValue();
            }
            i.$preInc();
        }
        return CI;
    }

    public void addCase(ConstantInt OnVal, BasicBlock Dest) {
        int NewCaseIdx = this.getNumCases();
        int OpNo = this.getNumOperands();
        if (Unsigned.$greater_uint((int)(OpNo + 2), (int)this.ReservedSpace)) {
            this.growOperands();
        }
        assert (Unsigned.$less_uint((int)(OpNo + 1), (int)this.ReservedSpace)) : "Growing didn't work!";
        this.setNumHungOffUseOperands(OpNo + 2);
        CaseIt Case = new CaseIt(this, NewCaseIdx);
        Case.setValue(OnVal);
        Case.setSuccessor(Dest);
    }

    public void removeCase(CaseIt i) {
        int idx = i.getCaseIndex();
        assert (Unsigned.$less_uint((int)(2 + idx * 2), (int)this.getNumOperands())) : "Case index out of range!!!";
        int NumOps = this.getNumOperands();
        type.ptr OL = (type.ptr)Native.$tryClone(this.getOperandList());
        if (2 + (idx + 1) * 2 != NumOps) {
            ((Use)OL.$at(2 + idx * 2)).$assign((Use)OL.$at(NumOps - 2));
            ((Use)OL.$at(2 + idx * 2 + 1)).$assign((Use)OL.$at(NumOps - 1));
        }
        ((Use)OL.$at(NumOps - 2)).set(null);
        ((Use)OL.$at(NumOps - 2 + 1)).set(null);
        this.setNumHungOffUseOperands(NumOps - 2);
    }

    @Override
    public int getNumSuccessors() {
        return Unsigned.$div_uint((int)this.getNumOperands(), (int)2);
    }

    @Override
    public BasicBlock getSuccessor(int idx) {
        assert (Unsigned.$less_uint((int)idx, (int)this.getNumSuccessors())) : "Successor idx out of range for switch!";
        return IrRTTI.cast_BasicBlock(this.getOperand(idx * 2 + 1));
    }

    @Override
    public void setSuccessor(int idx, BasicBlock NewSucc) {
        assert (Unsigned.$less_uint((int)idx, (int)this.getNumSuccessors())) : "Successor # out of range for switch!";
        this.setOperand(idx * 2 + 1, NewSucc);
    }

    public static boolean classof(Instruction I) {
        return I.getOpcode() == 3;
    }

    public static boolean classof(Value V) {
        return IrRTTI.isa_Instruction(V) && SwitchInst.classof(IrRTTI.cast_Instruction(V));
    }

    @Override
    protected BasicBlock getSuccessorV(int idx) {
        return this.getSuccessor(idx);
    }

    @Override
    protected int getNumSuccessorsV() {
        return this.getNumSuccessors();
    }

    @Override
    protected void setSuccessorV(int idx, BasicBlock B2) {
        this.setSuccessor(idx, B2);
    }

    @Override
    public void $destroy() {
        super.$destroy();
    }

    @Override
    public String toString() {
        return "ReservedSpace=" + this.ReservedSpace + super.toString();
    }

    public static class CaseIt
    extends CaseIteratorT<SwitchInst, ConstantInt, BasicBlock> {
        public CaseIt(CaseIteratorT<SwitchInst, ConstantInt, BasicBlock> Src) {
            super(Src);
        }

        public CaseIt(SwitchInst SI, int CaseNum) {
            super(SI, CaseNum);
        }

        public void setValue(ConstantInt V) {
            assert (Unsigned.$less_uint((int)this.Index, (int)this.SI.getNumCases())) : "Index out the number of cases.";
            this.SI.setOperand(2 + this.Index * 2, (Value)Casts.reinterpret_cast(Value.class, (Object)V));
        }

        public void setSuccessor(BasicBlock S) {
            this.SI.setSuccessor(this.getSuccessorIndex(), S);
        }

        public CaseIt(CaseIt $Prm0) {
            super($Prm0);
        }

        public CaseIt(JavaDifferentiators.JD.Move _dparam, CaseIt $Prm0) {
            super(JavaDifferentiators.JD.Move.INSTANCE, $Prm0);
        }

        @Override
        public String toString() {
            return "" + super.toString();
        }
    }

    public static class CaseIteratorT<SwitchInstTy extends SwitchInst, ConstantIntTy extends Value, BasicBlockTy extends BasicBlock>
    implements type.iterator<CaseIteratorT, CaseIteratorT>,
    Native.NativeComparable {
        protected SwitchInstTy SI;
        protected int Index;

        public CaseIteratorT(SwitchInstTy SI, int CaseNum) {
            this.SI = SI;
            this.Index = CaseNum;
        }

        public static <SwitchInstTy extends SwitchInst, ConstantIntTy extends Value, BasicBlockTy extends BasicBlock> CaseIteratorT<SwitchInstTy, ConstantIntTy, BasicBlockTy> fromSuccessorIndex(SwitchInstTy SI, int SuccessorIndex) {
            assert (Native.$bool((boolean)Native.$less((int)SuccessorIndex, (int)SI.getNumSuccessors()))) : "Successor index # out of range!";
            return SuccessorIndex != 0 ? new CaseIteratorT<SwitchInstTy, ConstantIntTy, BasicBlockTy>(SI, SuccessorIndex - 1) : new CaseIteratorT<SwitchInstTy, ConstantIntTy, BasicBlockTy>(SI, DefaultPseudoIndex);
        }

        public ConstantIntTy getCaseValue() {
            assert (Native.$bool((boolean)Native.$less((int)this.Index, (int)((SwitchInst)this.SI).getNumCases()))) : "Index out the number of cases.";
            return (ConstantIntTy)((SwitchInst)this.SI).getOperand(Native.$add((int)2, (int)(this.Index * 2)));
        }

        public BasicBlockTy getCaseSuccessor() {
            assert (Native.$bool((Native.$bool((boolean)Native.$less((int)this.Index, (int)((SwitchInst)this.SI).getNumCases())) || Native.$bool((boolean)Native.$eq((int)this.Index, (int)DefaultPseudoIndex)) ? 1 : 0) != 0)) : "Index out the number of cases.";
            return (BasicBlockTy)((SwitchInst)this.SI).getSuccessor(this.getSuccessorIndex());
        }

        public int getCaseIndex() {
            return this.Index;
        }

        public int getSuccessorIndex() {
            assert (Native.$bool((Native.$bool((boolean)Native.$eq((int)this.Index, (int)DefaultPseudoIndex)) || Native.$bool((boolean)Native.$less((int)this.Index, (int)((SwitchInst)this.SI).getNumCases())) ? 1 : 0) != 0)) : "Index out the number of cases.";
            return Native.$noteq((int)this.Index, (int)DefaultPseudoIndex) ? Native.$add((int)this.Index, (int)1) : 0;
        }

        public CaseIteratorT<SwitchInstTy, ConstantIntTy, BasicBlockTy> $preInc() {
            assert (Native.$bool((boolean)Native.$lesseq((int)Native.$add((int)this.Index, (int)1), (int)((SwitchInst)this.SI).getNumCases()))) : "Index out the number of cases.";
            ++this.Index;
            return this;
        }

        public CaseIteratorT<SwitchInstTy, ConstantIntTy, BasicBlockTy> $postInc(int $Prm0) {
            CaseIteratorT<SwitchInstTy, ConstantIntTy, BasicBlockTy> tmp = new CaseIteratorT<SwitchInstTy, ConstantIntTy, BasicBlockTy>(this.SI, this.Index);
            ++this.Index;
            return tmp;
        }

        public CaseIteratorT<SwitchInstTy, ConstantIntTy, BasicBlockTy> $preDec() {
            assert (Native.$bool((Native.$bool((boolean)Native.$eq((int)this.Index, (int)0)) || Native.$bool((boolean)Native.$lesseq((int)(this.Index - 1), (int)((SwitchInst)this.SI).getNumCases())) ? 1 : 0) != 0)) : "Index out the number of cases.";
            --this.Index;
            return this;
        }

        public CaseIteratorT<SwitchInstTy, ConstantIntTy, BasicBlockTy> $postDec(int $Prm0) {
            CaseIteratorT<SwitchInstTy, ConstantIntTy, BasicBlockTy> tmp = new CaseIteratorT<SwitchInstTy, ConstantIntTy, BasicBlockTy>(this.SI, this.Index);
            --this.Index;
            return tmp;
        }

        public boolean $eq(CaseIteratorT<SwitchInstTy, ConstantIntTy, BasicBlockTy> RHS) {
            assert (Native.$bool((boolean)Native.$eq(RHS.SI, this.SI))) : "Incompatible operators.";
            return Native.$eq((int)RHS.Index, (int)this.Index);
        }

        public boolean $noteq(CaseIteratorT<SwitchInstTy, ConstantIntTy, BasicBlockTy> RHS) {
            assert (Native.$bool((boolean)Native.$eq(RHS.SI, this.SI))) : "Incompatible operators.";
            return Native.$noteq((int)RHS.Index, (int)this.Index);
        }

        public CaseIteratorT<SwitchInstTy, ConstantIntTy, BasicBlockTy> $star() {
            return this;
        }

        protected CaseIteratorT(CaseIteratorT<SwitchInstTy, ConstantIntTy, BasicBlockTy> $Prm0) {
            this.SI = $Prm0.SI;
            this.Index = $Prm0.Index;
        }

        protected CaseIteratorT(JavaDifferentiators.JD.Move _dparam, CaseIteratorT<SwitchInstTy, ConstantIntTy, BasicBlockTy> $Prm0) {
            this.SI = $Prm0.SI;
            this.Index = $Prm0.Index;
        }

        public CaseIteratorT clone() {
            return new CaseIteratorT<SwitchInstTy, ConstantIntTy, BasicBlockTy>(this);
        }

        public String toString() {
            return "SI=" + this.SI + ", Index=" + this.Index;
        }
    }
}

