/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import java.util.Iterator;
import org.clank.java.std;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.Unsigned;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.type;
import org.llvm.adt.iterator_range;
import org.llvm.ir.Attribute;
import org.llvm.ir.CallSite;
import org.llvm.ir.CallSiteBase;
import org.llvm.ir.Function;
import org.llvm.ir.FunctionType;
import org.llvm.ir.GCRelocateInst;
import org.llvm.ir.GCResultInst;
import org.llvm.ir.ImmutableCallSite;
import org.llvm.ir.Instruction;
import org.llvm.ir.LandingPadInst;
import org.llvm.ir.Type;
import org.llvm.ir.Use;
import org.llvm.ir.User;
import org.llvm.ir.Value;
import org.llvm.ir.java.IrRTTI;
import org.llvm.pass.IrLlvmGlobals;
import org.llvm.support.llvm;

public class StatepointBase<FunTy, InstructionTy extends Instruction, ValueTy, CallSiteTy extends CallSiteBase>
implements Native.Native$Bool {
    private CallSiteTy StatepointCS;

    protected static <FunTy, InstructionTy, ValueTy, CallSiteTy> Object $new(int $Prm0, int $Prm1) {
        throw new UnsupportedOperationException("Deleted");
    }

    protected static <FunTy, InstructionTy, ValueTy, CallSiteTy> Object $new(int s) {
        throw new UnsupportedOperationException("Deleted");
    }

    protected StatepointBase(Class<CallSiteTy> cls, JavaDifferentiators.JD$T1$P _dparam, InstructionTy I) {
        if (IrLlvmGlobals.isStatepoint_Value$C(I)) {
            if (cls == ImmutableCallSite.class) {
                this.StatepointCS = new ImmutableCallSite((Instruction)I);
            } else if (cls == CallSite.class) {
                this.StatepointCS = new CallSite((Instruction)I);
            } else {
                throw new UnsupportedOperationException("Unknown class " + cls.getName());
            }
            assert (Native.$bool(this.StatepointCS)) : "isStatepoint implies CallSite";
        }
    }

    protected StatepointBase(JavaDifferentiators.JD$T3 _dparam, CallSiteTy CS) {
        if (IrLlvmGlobals.isStatepoint((ImmutableCallSite)CS)) {
            this.StatepointCS = CS;
        }
    }

    public boolean $bool() {
        return ((CallSiteBase)this.StatepointCS).$bool();
    }

    public CallSiteTy getCallSite() {
        assert (Native.$bool((Native.Native$Bool)this)) : "check validity first!";
        return this.StatepointCS;
    }

    public long getFlags() {
        return IrRTTI.cast_ConstantInt(((CallSiteBase)this.getCallSite()).getArgument(Unnamed_enum.FlagsPos.getValue())).getZExtValue();
    }

    public long getID() {
        Object IDVal = ((CallSiteBase)this.getCallSite()).getArgument(Unnamed_enum.IDPos.getValue());
        return IrRTTI.cast_ConstantInt(IDVal).getZExtValue();
    }

    public int getNumPatchBytes() {
        Object NumPatchBytesVal = ((CallSiteBase)this.getCallSite()).getArgument(Unnamed_enum.NumPatchBytesPos.getValue());
        long NumPatchBytes = IrRTTI.cast_ConstantInt(NumPatchBytesVal).getZExtValue();
        assert (llvm.isInt((long)NumPatchBytes, (int)32)) : "should fit in 32 bits!";
        return Unsigned.$ulong2uint((long)NumPatchBytes);
    }

    public ValueTy getCalledValue() {
        return (ValueTy)((CallSiteBase)this.getCallSite()).getArgument(Unnamed_enum.CalledFunctionPos.getValue());
    }

    public InstructionTy getInstruction() {
        return (InstructionTy)((CallSiteBase)this.getCallSite()).getInstruction();
    }

    public FunTy getCalledFunction() {
        return (FunTy)IrRTTI.dyn_cast_Function((Value)this.getCalledValue());
    }

    public FunTy getCaller() {
        return ((CallSiteBase)this.getCallSite()).getCaller();
    }

    public boolean doesNotThrow() {
        Function F = (Function)this.getCalledFunction();
        return Native.$bool((boolean)((CallSiteBase)this.getCallSite()).doesNotThrow()) || F != null && F.doesNotThrow();
    }

    public Type getActualReturnType() {
        FunctionType FTy = IrRTTI.cast_FunctionType(IrRTTI.cast_PointerType(((Value)this.getCalledValue()).getType()).getElementType());
        return FTy.getReturnType();
    }

    public int getNumCallArgs() {
        Object NumCallArgsVal = ((CallSiteBase)this.getCallSite()).getArgument(Unnamed_enum.NumCallArgsPos.getValue());
        return Unsigned.$ulong2int((long)IrRTTI.cast_ConstantInt(NumCallArgsVal).getZExtValue());
    }

    public int arg_size() {
        return this.getNumCallArgs();
    }

    public type.ptr<Use> arg_begin() {
        assert (Native.$bool((boolean)Native.$lesseq((int)Unnamed_enum.CallArgsBeginPos.getValue(), (int)((CallSiteBase)this.getCallSite()).arg_size())));
        return (type.ptr)((CallSiteBase)this.getCallSite()).arg_begin().$add(Unnamed_enum.CallArgsBeginPos.getValue());
    }

    public type.ptr<Use> arg_end() {
        type.ptr I = (type.ptr)this.arg_begin().$add(this.arg_size());
        assert (Native.$bool((boolean)Native.$greatereq((int)((CallSiteBase)this.getCallSite()).arg_end().$sub((abstract_iterator)I), (int)0)));
        return I;
    }

    public ValueTy getArgument(int Index) {
        assert (Native.$bool((boolean)Native.$less((int)Index, (int)this.arg_size()))) : "out of bounds!";
        return (ValueTy)Native.$Deref((type.iterator)((type.iterator)this.arg_begin().$add(Index)));
    }

    public iterator_range<Use> call_args() {
        return llvm.make_range(this.arg_begin(), this.arg_end());
    }

    public boolean paramHasAttr(int i, Attribute.AttrKind A2) {
        Function F = (Function)this.getCalledFunction();
        return Native.$bool((boolean)((CallSiteBase)this.getCallSite()).paramHasAttr(i + Unnamed_enum.CallArgsBeginPos.getValue(), A2)) || F != null && F.getAttributes().hasAttribute(i, A2);
    }

    public int getNumTotalGCTransitionArgs() {
        Value NumGCTransitionArgs = ((Use)Native.$Deref(this.arg_end())).get();
        return Unsigned.$ulong2int((long)IrRTTI.cast_ConstantInt(NumGCTransitionArgs).getZExtValue());
    }

    public type.ptr<Use> gc_transition_args_begin() {
        type.ptr I = (type.ptr)this.arg_end().$add(1);
        assert (Native.$bool((boolean)Native.$greatereq((int)((CallSiteBase)this.getCallSite()).arg_end().$sub((abstract_iterator)I), (int)0)));
        return I;
    }

    public type.ptr<Use> gc_transition_args_end() {
        type.ptr I = (type.ptr)this.gc_transition_args_begin().$add(this.getNumTotalGCTransitionArgs());
        assert (Native.$bool((boolean)Native.$greatereq((int)((CallSiteBase)this.getCallSite()).arg_end().$sub((abstract_iterator)I), (int)0)));
        return I;
    }

    public iterator_range<Use> gc_transition_args() {
        return llvm.make_range(this.gc_transition_args_begin(), this.gc_transition_args_end());
    }

    public int getNumTotalVMSArgs() {
        Value NumVMSArgs = ((Use)Native.$Deref(this.gc_transition_args_end())).get();
        return Unsigned.$ulong2int((long)IrRTTI.cast_ConstantInt(NumVMSArgs).getZExtValue());
    }

    public type.ptr<Use> vm_state_begin() {
        type.ptr I = (type.ptr)this.gc_transition_args_end().$add(1);
        assert (Native.$bool((boolean)Native.$greatereq((int)((CallSiteBase)this.getCallSite()).arg_end().$sub((abstract_iterator)I), (int)0)));
        return I;
    }

    public type.ptr<Use> vm_state_end() {
        type.ptr I = (type.ptr)this.vm_state_begin().$add(this.getNumTotalVMSArgs());
        assert (Native.$bool((boolean)Native.$greatereq((int)((CallSiteBase)this.getCallSite()).arg_end().$sub((abstract_iterator)I), (int)0)));
        return I;
    }

    public iterator_range<Use> vm_state_args() {
        return llvm.make_range(this.vm_state_begin(), this.vm_state_end());
    }

    public type.ptr<Use> gc_args_begin() {
        return this.vm_state_end();
    }

    public type.ptr<Use> gc_args_end() {
        return (type.ptr)((CallSiteBase)this.getCallSite()).arg_end();
    }

    public int gcArgsStartIdx() {
        return std.distance(this.gc_args_begin(), ((User)this.getInstruction()).op_begin());
    }

    public iterator_range<Use> gc_args() {
        return llvm.make_range(this.gc_args_begin(), this.gc_args_end());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public std.vector<GCRelocateInst> getRelocates() {
        std.vector Result2 = null;
        try {
            Result2 = new std.vector((Object)null);
            CallSiteTy StatepointCS = this.getCallSite();
            for (User U : ((Value)this.getInstruction()).users()) {
                GCRelocateInst Relocate = IrRTTI.dyn_cast_GCRelocateInst(U);
                if (Relocate == null) continue;
                Result2.push_back_T$C$R((Object)Relocate);
            }
            if (Native.$not((boolean)((CallSiteBase)StatepointCS).isInvoke())) {
                Iterator iterator2 = new std.vector(JavaDifferentiators.JD.Move.INSTANCE, Result2);
                return iterator2;
            }
            LandingPadInst LandingPad = IrRTTI.cast_InvokeInst(this.getInstruction()).getLandingPadInst();
            for (User LandingPadUser : LandingPad.users()) {
                GCRelocateInst Relocate = IrRTTI.dyn_cast_GCRelocateInst(LandingPadUser);
                if (Relocate == null) continue;
                Result2.push_back_T$C$R((Object)Relocate);
            }
            Iterator iterator3 = new std.vector(JavaDifferentiators.JD.Move.INSTANCE, Result2);
            return iterator3;
        }
        finally {
            if (Result2 != null) {
                Result2.$destroy();
            }
        }
    }

    public GCResultInst getGCResult() {
        for (User U : ((Value)this.getInstruction()).users()) {
            GCResultInst GRI = IrRTTI.dyn_cast_GCResultInst(U);
            if (GRI == null) continue;
            return GRI;
        }
        return null;
    }

    public void verify() {
        assert (Native.$bool((boolean)Native.$greatereq((int)this.getNumCallArgs(), (int)0))) : "number of arguments to actually callee can't be negative";
        this.arg_begin();
        this.arg_end();
        this.gc_transition_args_begin();
        this.gc_transition_args_end();
        this.vm_state_begin();
        this.vm_state_end();
        this.gc_args_begin();
        this.gc_args_end();
    }

    public StatepointBase(JavaDifferentiators.JD.Move _dparam, StatepointBase<FunTy, InstructionTy, ValueTy, CallSiteTy> other) {
        this.StatepointCS = other.StatepointCS;
    }

    public String toString() {
        return "StatepointCS=" + this.StatepointCS;
    }

    public static final class Unnamed_enum
    extends Enum<Unnamed_enum>
    implements Native.NativeIntEnum {
        public static final /* enum */ Unnamed_enum IDPos = new Unnamed_enum(0);
        public static final /* enum */ Unnamed_enum NumPatchBytesPos = new Unnamed_enum(1);
        public static final /* enum */ Unnamed_enum CalledFunctionPos = new Unnamed_enum(2);
        public static final /* enum */ Unnamed_enum NumCallArgsPos = new Unnamed_enum(3);
        public static final /* enum */ Unnamed_enum FlagsPos = new Unnamed_enum(4);
        public static final /* enum */ Unnamed_enum CallArgsBeginPos = new Unnamed_enum(5);
        private final int value;
        private static final /* synthetic */ Unnamed_enum[] $VALUES;

        public static Unnamed_enum[] values() {
            return (Unnamed_enum[])$VALUES.clone();
        }

        public static Unnamed_enum valueOf(String name) {
            return Enum.valueOf(Unnamed_enum.class, name);
        }

        public static Unnamed_enum valueOf(int val) {
            Unnamed_enum out;
            Unnamed_enum unnamed_enum = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private Unnamed_enum(int val) {
            this.value = val;
        }

        public final int getValue() {
            return this.value;
        }

        static {
            $VALUES = new Unnamed_enum[]{IDPos, NumPatchBytesPos, CalledFunctionPos, NumCallArgsPos, FlagsPos, CallArgsBeginPos};
        }

        private static final class Values {
            private static final Unnamed_enum[] VALUES;
            private static final Unnamed_enum[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (Unnamed_enum kind : Unnamed_enum.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new Unnamed_enum[min < 0 ? 1 - min : 0];
                VALUES = new Unnamed_enum[max >= 0 ? 1 + max : 0];
                for (Unnamed_enum kind : Unnamed_enum.values()) {
                    if (kind.value < 0) {
                        if (_VALUES[-kind.value] != null) continue;
                        Values._VALUES[-((Unnamed_enum)kind).value] = kind;
                        continue;
                    }
                    if (VALUES[kind.value] != null) continue;
                    Values.VALUES[((Unnamed_enum)kind).value] = kind;
                }
            }
        }
    }
}

