/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.llvm.adt.Twine;
import org.llvm.ir.BasicBlock;
import org.llvm.ir.Instruction;
import org.llvm.ir.OperandTraitsSelectInst;
import org.llvm.ir.Type;
import org.llvm.ir.Use;
import org.llvm.ir.User;
import org.llvm.ir.Value;
import org.llvm.ir.VectorType;
import org.llvm.ir.java.IrRTTI;

public class SelectInst
extends Instruction
implements Destructors.ClassWithDestructor {
    private void init(Value C2, Value S1, Value S2) {
        assert (!Native.$bool((Native.Native$Bool)SelectInst.areInvalidOperands(C2, S1, S2))) : "Invalid operands for select";
        this.Op(0).$assign(C2);
        this.Op(1).$assign(S1);
        this.Op(2).$assign(S2);
    }

    private SelectInst(Value C2, Value S1, Value S2, Twine NameStr, Instruction InsertBefore) {
        super(S1.getType(), 55, SelectInst.OpFrom$Addr(0, User.$BEING_CREATED(), SelectInst.class), 3, InsertBefore);
        this.init(C2, S1, S2);
        this.setName(NameStr);
    }

    private SelectInst(Value C2, Value S1, Value S2, Twine NameStr, BasicBlock InsertAtEnd) {
        super(S1.getType(), 55, SelectInst.OpFrom$Addr(0, User.$BEING_CREATED(), SelectInst.class), 3, InsertAtEnd);
        this.init(C2, S1, S2);
        this.setName(NameStr);
    }

    protected SelectInst cloneImpl() {
        return SelectInst.Create(this.getOperand(0), this.getOperand(1), this.getOperand(2));
    }

    public static SelectInst Create(Value C2, Value S1, Value S2) {
        return SelectInst.Create(C2, S1, S2, new Twine(NativePointer.$EMPTY), (Instruction)null);
    }

    public static SelectInst Create(Value C2, Value S1, Value S2, Twine NameStr) {
        return SelectInst.Create(C2, S1, S2, NameStr, (Instruction)null);
    }

    public static SelectInst Create(Value C2, Value S1, Value S2, Twine NameStr, Instruction InsertBefore) {
        return (SelectInst)User.$new_FixedUses(3, New$Mem -> new SelectInst(C2, S1, S2, NameStr, InsertBefore));
    }

    public static SelectInst Create(Value C2, Value S1, Value S2, Twine NameStr, BasicBlock InsertAtEnd) {
        return (SelectInst)User.$new_FixedUses(3, New$Mem -> new SelectInst(C2, S1, S2, NameStr, InsertAtEnd));
    }

    public Value getCondition$Const() {
        return this.Op$Const(0).$Value$P();
    }

    public Value getTrueValue$Const() {
        return this.Op$Const(1).$Value$P();
    }

    public Value getFalseValue$Const() {
        return this.Op$Const(2).$Value$P();
    }

    public Value getCondition() {
        return this.Op(0).$Value$P();
    }

    public Value getTrueValue() {
        return this.Op(1).$Value$P();
    }

    public Value getFalseValue() {
        return this.Op(2).$Value$P();
    }

    public void setCondition(Value V) {
        this.Op(0).$assign(V);
    }

    public void setTrueValue(Value V) {
        this.Op(1).$assign(V);
    }

    public void setFalseValue(Value V) {
        this.Op(2).$assign(V);
    }

    public static char.ptr areInvalidOperands(Value Op0, Value Op1, Value Op2) {
        if (Op1.getType() != Op2.getType()) {
            return NativePointer.$((String)"both values to select must have same type");
        }
        if (Op1.getType().isTokenTy()) {
            return NativePointer.$((String)"select values cannot have token type");
        }
        VectorType VT = IrRTTI.dyn_cast_VectorType(Op0.getType());
        if (VT != null) {
            if (VT.getElementType() != Type.getInt1Ty(Op0.getContext())) {
                return NativePointer.$((String)"vector select condition element type must be i1");
            }
            VectorType ET = IrRTTI.dyn_cast_VectorType(Op1.getType());
            if (ET == null) {
                return NativePointer.$((String)"selected values for vector select must be vectors");
            }
            if (ET.getNumElements() != VT.getNumElements()) {
                return NativePointer.$((String)"vector select requires selected vectors to have the same vector length as select condition");
            }
        } else if (Op0.getType() != Type.getInt1Ty(Op0.getContext())) {
            return NativePointer.$((String)"select condition must be i1 or <n x i1>");
        }
        return null;
    }

    @Override
    public Value getOperand(int i_nocapture) {
        assert (Unsigned.$less_uint((int)i_nocapture, (int)OperandTraitsSelectInst.operands$FixedNumOperandTraits(this))) : "getOperand() out of range!";
        return IrRTTI.cast_or_null_Value(((Use)OperandTraitsSelectInst.op_begin(this).$at(i_nocapture)).get());
    }

    @Override
    public void setOperand(int i_nocapture, Value Val_nocapture) {
        assert (Unsigned.$less_uint((int)i_nocapture, (int)OperandTraitsSelectInst.operands$FixedNumOperandTraits(this))) : "setOperand() out of range!";
        ((Use)OperandTraitsSelectInst.op_begin(this).$at(i_nocapture)).$assign(Val_nocapture);
    }

    @Override
    public type.ptr<Use> op_begin() {
        return OperandTraitsSelectInst.op_begin(this);
    }

    @Override
    public type.ptr<Use> op_begin$Const() {
        return OperandTraitsSelectInst.op_begin(this);
    }

    @Override
    public type.ptr<Use> op_end() {
        return OperandTraitsSelectInst.op_end(this);
    }

    @Override
    public type.ptr<Use> op_end$Const() {
        return OperandTraitsSelectInst.op_end(this);
    }

    @Override
    protected Use Op(int Idx_nocapture) {
        return this.OpFrom(Idx_nocapture, this);
    }

    @Override
    protected Use Op$Const(int Idx_nocapture) {
        return this.OpFrom(Idx_nocapture, this);
    }

    @Override
    public int getNumOperands() {
        return OperandTraitsSelectInst.operands$FixedNumOperandTraits(this);
    }

    public int getOpcode$SelectInst() {
        return super.getOpcode();
    }

    public static boolean classof(Instruction I) {
        return I.getOpcode() == 55;
    }

    public static boolean classof(Value V) {
        return IrRTTI.isa_Instruction(V) && SelectInst.classof(IrRTTI.cast_Instruction(V));
    }

    @Override
    public void $destroy() {
        super.$destroy();
    }

    @Override
    public String toString() {
        return "" + super.toString();
    }
}

