/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativeMoveable;
import org.clank.support.Unsigned;
import org.clank.support.aliases.type;
import org.llvm.adt.PointerUnion;
import org.llvm.adt.aliases.DenseMapIterator;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.ir.LLVMContext;
import org.llvm.ir.MDNode;
import org.llvm.ir.Metadata;
import org.llvm.ir.MetadataAsValue;
import org.llvm.ir.MetadataTracking;
import org.llvm.ir.ReplaceableMetadataImpl;
import org.llvm.ir.java.IrRTTI;
import org.llvm.support.llvm_unreachable;

public interface ReplaceableMetadataImpl
extends Destructors.ClassWithDestructor {
    default public ReplaceableMetadataImpl.Fields $ReplaceableMetadataImpl$Fields() {
        throw new UnsupportedOperationException("Why not implemented in derived? " + this.getClass() + ": Keep what was returned from $ReplaceableMetadataImpl in your final field and just return it here.");
    }

    default public ReplaceableMetadataImpl.Fields $ReplaceableMetadataImpl(LLVMContext Context) {
        return new ReplaceableMetadataImpl.Fields(Context);
    }

    default public void $destroy$ReplaceableMetadataImpl() {
        if (!1.$assertionsDisabled && !this.$ReplaceableMetadataImpl$Fields().UseMap.empty()) {
            throw new AssertionError((Object)"Cannot destroy in-use replaceable metadata");
        }
        this.$ReplaceableMetadataImpl$Fields().UseMap.$destroy();
    }

    default public LLVMContext getContext() {
        return this.$ReplaceableMetadataImpl$Fields().Context;
    }

    default public void replaceAllUsesWith(Metadata MD) {
        if (this.$ReplaceableMetadataImpl$Fields().UseMap.empty()) {
            return;
        }
        SmallVector Uses = new SmallVector(JavaDifferentiators.JD$T.INSTANCE, 8, (type.iterator)this.$ReplaceableMetadataImpl$Fields().UseMap.begin(), (type.iterator)this.$ReplaceableMetadataImpl$Fields().UseMap.end(), (Object)new std_pair.pairPtrType());
        std.sort((type.iterator)Uses.begin(), (type.iterator)Uses.end(), (L, R) -> Unsigned.$less_ullong((long)((std_pair.pairTypeULong)L.second).second, (long)((std_pair.pairTypeULong)R.second).second));
        block31: for (std_pair.pair Pair : Uses) {
            if (this.$ReplaceableMetadataImpl$Fields().UseMap.count((Object)((type.ptr)Pair.first)) == 0) continue;
            PointerUnion Owner = new PointerUnion((PointerUnion)((std_pair.pairTypeULong)Pair.second).first);
            if (!Owner.$bool()) {
                type.ptr Ref = (type.ptr)Pair.first;
                Ref.$set((Object)MD);
                if (MD != null) {
                    MetadataTracking.track((type.ptr<Metadata>)Ref);
                }
                this.$ReplaceableMetadataImpl$Fields().UseMap.erase((Object)((type.ptr)Pair.first));
                continue;
            }
            if (Owner.is(MetadataAsValue.class) != 0) {
                ((MetadataAsValue)Owner.get(MetadataAsValue.class)).handleChangedMetadata(MD);
                continue;
            }
            Metadata OwnerMD = (Metadata)Owner.get(Metadata.class);
            switch (Metadata.MetadataKind.valueOf(OwnerMD.getMetadataID())) {
                case MDStringKind: {
                    IrRTTI.cast_MDString(OwnerMD).handleChangedOperand(Pair.first, MD);
                    continue block31;
                }
                case ConstantAsMetadataKind: {
                    IrRTTI.cast_ConstantAsMetadata(OwnerMD).handleChangedOperand(Pair.first, MD);
                    continue block31;
                }
                case LocalAsMetadataKind: {
                    IrRTTI.cast_LocalAsMetadata(OwnerMD).handleChangedOperand(Pair.first, MD);
                    continue block31;
                }
                case DistinctMDOperandPlaceholderKind: {
                    IrRTTI.cast_DistinctMDOperandPlaceholder(OwnerMD).handleChangedOperand(Pair.first, MD);
                    continue block31;
                }
                case MDTupleKind: {
                    IrRTTI.cast_MDTuple(OwnerMD).handleChangedOperand((type.ptr)Pair.first, MD);
                    continue block31;
                }
                case DILocationKind: {
                    IrRTTI.cast_DILocation(OwnerMD).handleChangedOperand((type.ptr)Pair.first, MD);
                    continue block31;
                }
                case DIExpressionKind: {
                    IrRTTI.cast_DIExpression(OwnerMD).handleChangedOperand((type.ptr)Pair.first, MD);
                    continue block31;
                }
                case GenericDINodeKind: {
                    IrRTTI.cast_GenericDINode(OwnerMD).handleChangedOperand((type.ptr)Pair.first, MD);
                    continue block31;
                }
                case DISubrangeKind: {
                    IrRTTI.cast_DISubrange(OwnerMD).handleChangedOperand((type.ptr)Pair.first, MD);
                    continue block31;
                }
                case DIEnumeratorKind: {
                    IrRTTI.cast_DIEnumerator(OwnerMD).handleChangedOperand((type.ptr)Pair.first, MD);
                    continue block31;
                }
                case DIBasicTypeKind: {
                    IrRTTI.cast_DIBasicType(OwnerMD).handleChangedOperand((type.ptr)Pair.first, MD);
                    continue block31;
                }
                case DIDerivedTypeKind: {
                    IrRTTI.cast_DIDerivedType(OwnerMD).handleChangedOperand((type.ptr)Pair.first, MD);
                    continue block31;
                }
                case DICompositeTypeKind: {
                    IrRTTI.cast_DICompositeType(OwnerMD).handleChangedOperand((type.ptr)Pair.first, MD);
                    continue block31;
                }
                case DISubroutineTypeKind: {
                    IrRTTI.cast_DISubroutineType(OwnerMD).handleChangedOperand((type.ptr)Pair.first, MD);
                    continue block31;
                }
                case DIFileKind: {
                    IrRTTI.cast_DIFile(OwnerMD).handleChangedOperand((type.ptr)Pair.first, MD);
                    continue block31;
                }
                case DICompileUnitKind: {
                    IrRTTI.cast_DICompileUnit(OwnerMD).handleChangedOperand((type.ptr)Pair.first, MD);
                    continue block31;
                }
                case DISubprogramKind: {
                    IrRTTI.cast_DISubprogram(OwnerMD).handleChangedOperand((type.ptr)Pair.first, MD);
                    continue block31;
                }
                case DILexicalBlockKind: {
                    IrRTTI.cast_DILexicalBlock(OwnerMD).handleChangedOperand((type.ptr)Pair.first, MD);
                    continue block31;
                }
                case DILexicalBlockFileKind: {
                    IrRTTI.cast_DILexicalBlockFile(OwnerMD).handleChangedOperand((type.ptr)Pair.first, MD);
                    continue block31;
                }
                case DINamespaceKind: {
                    IrRTTI.cast_DINamespace(OwnerMD).handleChangedOperand((type.ptr)Pair.first, MD);
                    continue block31;
                }
                case DIModuleKind: {
                    IrRTTI.cast_DIModule(OwnerMD).handleChangedOperand((type.ptr)Pair.first, MD);
                    continue block31;
                }
                case DITemplateTypeParameterKind: {
                    IrRTTI.cast_DITemplateTypeParameter(OwnerMD).handleChangedOperand((type.ptr)Pair.first, MD);
                    continue block31;
                }
                case DITemplateValueParameterKind: {
                    IrRTTI.cast_DITemplateValueParameter(OwnerMD).handleChangedOperand((type.ptr)Pair.first, MD);
                    continue block31;
                }
                case DIGlobalVariableKind: {
                    IrRTTI.cast_DIGlobalVariable(OwnerMD).handleChangedOperand((type.ptr)Pair.first, MD);
                    continue block31;
                }
                case DILocalVariableKind: {
                    IrRTTI.cast_DILocalVariable(OwnerMD).handleChangedOperand((type.ptr)Pair.first, MD);
                    continue block31;
                }
                case DIObjCPropertyKind: {
                    IrRTTI.cast_DIObjCProperty(OwnerMD).handleChangedOperand((type.ptr)Pair.first, MD);
                    continue block31;
                }
                case DIImportedEntityKind: {
                    IrRTTI.cast_DIImportedEntity(OwnerMD).handleChangedOperand((type.ptr)Pair.first, MD);
                    continue block31;
                }
                case DIMacroKind: {
                    IrRTTI.cast_DIMacro(OwnerMD).handleChangedOperand((type.ptr)Pair.first, MD);
                    continue block31;
                }
                case DIMacroFileKind: {
                    IrRTTI.cast_DIMacroFile(OwnerMD).handleChangedOperand((type.ptr)Pair.first, MD);
                    continue block31;
                }
            }
            throw new llvm_unreachable("Invalid metadata subclass");
        }
        if (!1.$assertionsDisabled && !this.$ReplaceableMetadataImpl$Fields().UseMap.empty()) {
            throw new AssertionError((Object)"Expected all uses to be replaced");
        }
    }

    default public void resolveAllUses() {
        this.resolveAllUses(true);
    }

    default public void resolveAllUses(boolean ResolveUsers) {
        if (this.$ReplaceableMetadataImpl$Fields().UseMap.empty()) {
            return;
        }
        if (!ResolveUsers) {
            this.$ReplaceableMetadataImpl$Fields().UseMap.clear();
            return;
        }
        SmallVector Uses = new SmallVector(JavaDifferentiators.JD$T.INSTANCE, 8, (type.iterator)this.$ReplaceableMetadataImpl$Fields().UseMap.begin(), (type.iterator)this.$ReplaceableMetadataImpl$Fields().UseMap.end(), (Object)new std_pair.pairPtrType());
        std.sort((type.iterator)Uses.begin(), (type.iterator)Uses.end(), (L, R) -> Unsigned.$less_ullong((long)((std_pair.pairTypeULong)L.second).second, (long)((std_pair.pairTypeULong)R.second).second));
        this.$ReplaceableMetadataImpl$Fields().UseMap.clear();
        for (std_pair.pair Pair : Uses) {
            MDNode OwnerMD;
            PointerUnion Owner = new PointerUnion((PointerUnion)((std_pair.pairTypeULong)Pair.second).first);
            if (!Owner.$bool() || Owner.is(MetadataAsValue.class) != 0 || (OwnerMD = IrRTTI.dyn_cast_MDNode((Metadata)Owner.get(Metadata.class))) == null || OwnerMD.isResolved()) continue;
            OwnerMD.decrementUnresolvedOperandCount();
        }
    }

    default public void addRef(type.ptr<Metadata> Ref, PointerUnion<MetadataAsValue, Metadata> Owner) {
        boolean WasInserted = this.$ReplaceableMetadataImpl$Fields().UseMap.insert_pair$KeyT$ValueT((std_pair.pair)std.make_pair_T_T(Ref, (Object)((std_pair.pairTypeULong)Native.$Move((NativeMoveable)std.make_pair_T_ulong((Object)((PointerUnion)Native.$Clone(Owner)), (long)this.$ReplaceableMetadataImpl$Fields().NextIndex))))).second;
        if (!1.$assertionsDisabled && !WasInserted) {
            throw new AssertionError((Object)"Expected to add a reference");
        }
        ++this.$ReplaceableMetadataImpl$Fields().NextIndex;
        if (!1.$assertionsDisabled && this.$ReplaceableMetadataImpl$Fields().NextIndex == Unsigned.$int2ullong((int)0)) {
            throw new AssertionError((Object)"Unexpected overflow");
        }
    }

    default public void dropRef(type.ptr<Metadata> Ref) {
        boolean WasErased = this.$ReplaceableMetadataImpl$Fields().UseMap.erase(Ref);
        if (!1.$assertionsDisabled && !WasErased) {
            throw new AssertionError((Object)"Expected to drop a reference");
        }
    }

    default public void moveRef(type.ptr<Metadata> Ref, type.ptr<Metadata> New2, Metadata MD) {
        DenseMapIterator I = this.$ReplaceableMetadataImpl$Fields().UseMap.find(Ref);
        if (!1.$assertionsDisabled && !I.$noteq(this.$ReplaceableMetadataImpl$Fields().UseMap.end())) {
            throw new AssertionError((Object)"Expected to move a reference");
        }
        std_pair.pairTypeULong OwnerAndIndex = new std_pair.pairTypeULong((std_pair.pairTypeULong)I.$arrow().second);
        this.$ReplaceableMetadataImpl$Fields().UseMap.erase(new DenseMapIterator(I));
        boolean WasInserted = this.$ReplaceableMetadataImpl$Fields().UseMap.insert_pair$KeyT$ValueT((std_pair.pair)std.make_pair_T_T(New2, (Object)((std_pair.pairTypeULong)Native.$Clone((NativeCloneable)OwnerAndIndex)))).second;
        if (!1.$assertionsDisabled && !WasInserted) {
            throw new AssertionError((Object)"Expected to add a reference");
        }
        if (!1.$assertionsDisabled && !((PointerUnion)OwnerAndIndex.first).$bool() && Ref.$star() != Native.$AddrOf((Object)MD)) {
            throw new AssertionError((Object)"Reference without owner must be direct");
        }
        if (!1.$assertionsDisabled && !((PointerUnion)OwnerAndIndex.first).$bool() && New2.$star() != Native.$AddrOf((Object)MD)) {
            throw new AssertionError((Object)"Reference without owner must be direct");
        }
    }

    public static ReplaceableMetadataImpl getOrCreate(Metadata MD) {
        MDNode N = IrRTTI.dyn_cast_MDNode((Metadata)Native.$AddrOf((Object)MD));
        if (N != null) {
            return N.isResolved() ? null : N.Context.getOrCreateReplaceableUses();
        }
        return IrRTTI.dyn_cast_ValueAsMetadata((Metadata)Native.$AddrOf((Object)MD));
    }

    public static ReplaceableMetadataImpl getIfExists(Metadata MD) {
        MDNode N = IrRTTI.dyn_cast_MDNode((Metadata)Native.$AddrOf((Object)MD));
        if (N != null) {
            return N.isResolved() ? null : N.Context.getReplaceableUses();
        }
        return IrRTTI.dyn_cast_ValueAsMetadata((Metadata)Native.$AddrOf((Object)MD));
    }

    public static boolean isReplaceable(Metadata MD) {
        MDNode N = IrRTTI.dyn_cast_MDNode((Metadata)Native.$AddrOf((Object)MD));
        if (N != null) {
            return !N.isResolved();
        }
        return IrRTTI.dyn_cast_ValueAsMetadata((Metadata)Native.$AddrOf((Object)MD)) != null;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

