/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.clank.java.std;
import org.clank.java.std_ptr;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.NativePointer;
import org.llvm.ir.AnalysisManager;
import org.llvm.ir.PassConcept;
import org.llvm.ir.PassInfoMixin;
import org.llvm.ir.PassModel;
import org.llvm.ir.PreservedAnalyses;
import org.llvm.ir.java.IPass;
import org.llvm.ir.java.IrDummies;
import org.llvm.support.llvm;

public class PassManager<IRUnitT>
implements PassInfoMixin<PassManager<IRUnitT>>,
Destructors.ClassWithDestructor {
    private std.vector<std_ptr.unique_ptr<PassConcept<IRUnitT>>> Passes;
    private boolean DebugLogging;

    public PassManager() {
        this(false);
    }

    public PassManager(boolean DebugLogging) {
        this.Passes = new std.vector((Object)new std_ptr.unique_ptr());
        this.DebugLogging = DebugLogging;
    }

    public PassManager(JavaDifferentiators.JD.Move _dparam, PassManager<IRUnitT> Arg) {
        this.Passes = new std.vector((std.vector)std.move(Arg.Passes));
        this.DebugLogging = Arg.DebugLogging;
    }

    public PassManager<IRUnitT> $assignMove(PassManager<IRUnitT> RHS) {
        this.Passes = (std.vector)std.move(RHS.Passes);
        this.DebugLogging = std.move((boolean)RHS.DebugLogging);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreservedAnalyses run(IRUnitT IR2, AnalysisManager<IRUnitT> AM) {
        PreservedAnalyses PA = null;
        try {
            PA = PreservedAnalyses.all();
            if (this.DebugLogging) {
                llvm.dbgs().$out("Starting ").$out(IrDummies.getTypeName(AM.getClass())).$out(" pass manager run.\n");
            }
            int Size = this.Passes.size();
            for (int Idx = 0; Idx != Size; ++Idx) {
                if (this.DebugLogging) {
                    llvm.dbgs().$out("Running pass: ").$out(((PassConcept)((std_ptr.unique_ptr)this.Passes.$at(Idx)).$arrow()).name()).$out(" on ").$out(IR2.toString()).$out(NativePointer.$LF);
                }
                PreservedAnalyses PassPA = ((PassConcept)((std_ptr.unique_ptr)this.Passes.$at(Idx)).$arrow()).run(IR2, AM);
                PassPA = AM.invalidate(IR2, (PreservedAnalyses)std.move((Object)PassPA));
                PA.intersect_PreservedAnalyses((PreservedAnalyses)std.move((Object)PassPA));
            }
            if (this.DebugLogging) {
                llvm.dbgs().$out("Finished ").$out(IrDummies.getTypeName(AM.getClass())).$out(" pass manager run.\n");
            }
            PreservedAnalyses preservedAnalyses = new PreservedAnalyses(JavaDifferentiators.JD.Move.INSTANCE, PA);
            return preservedAnalyses;
        }
        finally {
            if (PA != null) {
                PA.$destroy();
            }
        }
    }

    public <PassT extends IPass<PreservedAnalyses, IRUnitT>> void addPass(PassT Pass2) {
        this.Passes.emplace_back((Object)new std_ptr.unique_ptr(new PassModel((IPass)std.move(Pass2))));
    }

    protected PassManager(PassManager<IRUnitT> $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    protected PassManager<IRUnitT> $assign(PassManager<IRUnitT> $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    public void $destroy() {
        this.Passes.$destroy();
    }

    public String toString() {
        return "Passes=" + this.Passes + ", DebugLogging=" + this.DebugLogging + super.toString();
    }
}

