/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.clank.java.std;
import org.clank.support.Casts;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.type;
import org.clank.support.void;
import org.llvm.adt.ADTAliases;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.DenseMap;
import org.llvm.adt.aliases.DenseMapIterator;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.adt.java.ADTJavaDifferentiators;
import org.llvm.adt.java.SmallVectorImplCommon;
import org.llvm.ir.Function;
import org.llvm.ir.PMDataManager;
import org.llvm.ir.PMStack;
import org.llvm.ir.PMTopLevelManager;
import org.llvm.ir.PassDebuggingString;
import org.llvm.ir.PassManagerPrettyStackEntry;
import org.llvm.ir.impl.LegacyPassManagerStatics;
import org.llvm.ir.impl.PassDebugLevel;
import org.llvm.pass.AnalysisResolver;
import org.llvm.pass.AnalysisUsage;
import org.llvm.pass.IrLlvmGlobals;
import org.llvm.pass.Pass;
import org.llvm.pass.PassInfo;
import org.llvm.pass.PassManagerType;
import org.llvm.support.TimeRegion;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;
import org.llvm.support.sys.TimeValue;

public interface PMDataManager
extends Destructors.ClassWithDestructor {
    default public PMDataManager.Fields $PMDataManager() {
        PMDataManager.Fields $Fields = new PMDataManager.Fields();
        this.initializeAnalysisInfo($Fields);
        return $Fields;
    }

    default public void $destroy$PMDataManager() {
        type.ptr I = (type.ptr)Native.$tryClone((NativeCloneable)this.$PMDataManager$Fields().PassVector.begin());
        type.ptr E = (type.ptr)Native.$tryClone((NativeCloneable)this.$PMDataManager$Fields().PassVector.end());
        while (Native.$noteq_ptr((void.ptr)I, (void.ptr)E)) {
            Destructors.$destroy((Destructors.ClassWithDestructor)((Destructors.ClassWithDestructor)I.$star()));
            I.$preInc();
        }
        this.$PMDataManager$Fields().HigherLevelAnalysis.$destroy();
        this.$PMDataManager$Fields().AvailableAnalysis.$destroy();
        this.$PMDataManager$Fields().PassVector.$destroy();
    }

    public Pass getAsPass();

    default public void recordAvailableAnalysis(Pass P2) {
        Object PI = P2.getPassID();
        this.$PMDataManager$Fields().AvailableAnalysis.$set(PI, (Object)P2);
        if (!1.$assertionsDisabled && this.$PMDataManager$Fields().AvailableAnalysis.empty()) {
            throw new AssertionError();
        }
        PassInfo PInf = this.$PMDataManager$Fields().TPM.findAnalysisPassInfo(PI);
        if (PInf == null) {
            return;
        }
        std.vector<PassInfo> II = PInf.getInterfacesImplemented();
        int e = II.size();
        for (int i = 0; i != e; ++i) {
            this.$PMDataManager$Fields().AvailableAnalysis.$set(((PassInfo)II.$at$Const(i)).getTypeInfo(), (Object)P2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void verifyPreservedAnalysis(Pass P2) {
        AnalysisUsage AnUsage = this.$PMDataManager$Fields().TPM.findAnalysisUsage(P2);
        SmallVectorImpl<Object> PreservedSet = AnUsage.getPreservedSet();
        type.ptr I = (type.ptr)Native.$tryClone((NativeCloneable)PreservedSet.begin$Const());
        type.ptr E = (type.ptr)Native.$tryClone((NativeCloneable)PreservedSet.end$Const());
        while (Native.$noteq_ptr((void.ptr)I, (void.ptr)E)) {
            Object AID = I.$star();
            Pass AP = this.findAnalysisPass(AID, true);
            if (AP != null) {
                TimeRegion PassTimer = null;
                try {
                    PassTimer = new TimeRegion(ADTJavaDifferentiators.JD$Timer$P.INSTANCE, IrLlvmGlobals.getPassTimer(AP));
                    AP.verifyAnalysis();
                }
                finally {
                    if (PassTimer != null) {
                        PassTimer.$destroy();
                    }
                }
            }
            I.$preInc();
        }
    }

    default public void removeNotPreservedAnalysis(Pass P2) {
        AnalysisUsage AnUsage = this.$PMDataManager$Fields().TPM.findAnalysisUsage(P2);
        if (AnUsage.getPreservesAll()) {
            return;
        }
        SmallVectorImpl<Object> PreservedSet = AnUsage.getPreservedSet();
        DenseMapIterator I = this.$PMDataManager$Fields().AvailableAnalysis.begin();
        DenseMapIterator E = this.$PMDataManager$Fields().AvailableAnalysis.end();
        while (I.$noteq(E)) {
            DenseMapIterator Info = I.$postInc(0);
            if (((Pass)Info.$arrow().second).getAsImmutablePass() != null || !Native.$eq_ptr((void.ptr)((type.ptr)std.find((type.iterator)PreservedSet.begin$Const(), (type.iterator)PreservedSet.end$Const(), (Object)Info.$arrow().first)), (void.ptr)PreservedSet.end$Const())) continue;
            if (((PassDebugLevel)((Object)LegacyPassManagerStatics.PassDebugging.$T())).getValue() >= PassDebugLevel.Details.getValue()) {
                Pass S = (Pass)Info.$arrow().second;
                llvm.dbgs().$out(" -- '").$out(P2.getPassName()).$out("' is not preserving '");
                llvm.dbgs().$out(S.getPassName()).$out("'\n");
            }
            this.$PMDataManager$Fields().AvailableAnalysis.erase(new DenseMapIterator(Info));
        }
        int Index = 0;
        while (Unsigned.$less_uint((int)Index, (int)PassManagerType.PMT_Last.getValue())) {
            if (this.$PMDataManager$Fields().InheritedAnalysis[Index] != null) {
                DenseMapIterator I2 = this.$PMDataManager$Fields().InheritedAnalysis[Index].begin();
                DenseMapIterator E2 = this.$PMDataManager$Fields().InheritedAnalysis[Index].end();
                while (I2.$noteq(E2)) {
                    DenseMapIterator Info = I2.$postInc(0);
                    if (((Pass)Info.$arrow().second).getAsImmutablePass() != null || !Native.$eq_ptr((void.ptr)((type.ptr)std.find((type.iterator)PreservedSet.begin$Const(), (type.iterator)PreservedSet.end$Const(), (Object)Info.$arrow().first)), (void.ptr)PreservedSet.end$Const())) continue;
                    if (((PassDebugLevel)((Object)LegacyPassManagerStatics.PassDebugging.$T())).getValue() >= PassDebugLevel.Details.getValue()) {
                        Pass S = (Pass)Info.$arrow().second;
                        llvm.dbgs().$out(" -- '").$out(P2.getPassName()).$out("' is not preserving '");
                        llvm.dbgs().$out(S.getPassName()).$out("'\n");
                    }
                    this.$PMDataManager$Fields().InheritedAnalysis[Index].erase(new DenseMapIterator(Info));
                }
            }
            ++Index;
        }
    }

    default public void removeDeadPasses(Pass P2, StringRef Msg, PassDebuggingString DBG_STR) {
        SmallVector DeadPasses = new SmallVector(12, (Object)null);
        if (this.$PMDataManager$Fields().TPM == null) {
            return;
        }
        this.$PMDataManager$Fields().TPM.collectLastUses((SmallVectorImpl<Pass>)DeadPasses, P2);
        if (((PassDebugLevel)((Object)LegacyPassManagerStatics.PassDebugging.$T())).getValue() >= PassDebugLevel.Details.getValue() && !DeadPasses.empty()) {
            llvm.dbgs().$out(" -*- '").$out(P2.getPassName());
            llvm.dbgs().$out("' is the last user of following pass instances.");
            llvm.dbgs().$out(" Free these instances\n");
        }
        type.ptr I = (type.ptr)Native.$tryClone((NativeCloneable)DeadPasses.begin());
        type.ptr E = (type.ptr)Native.$tryClone((NativeCloneable)DeadPasses.end());
        while (Native.$noteq_ptr((void.ptr)I, (void.ptr)E)) {
            this.freePass((Pass)I.$star(), new StringRef(Msg), DBG_STR);
            I.$preInc();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void freePass(Pass P2, StringRef Msg, PassDebuggingString DBG_STR) {
        this.dumpPassInfo(P2, PassDebuggingString.FREEING_MSG, DBG_STR, new StringRef(Msg));
        PassManagerPrettyStackEntry X = null;
        TimeRegion PassTimer = null;
        try {
            X = new PassManagerPrettyStackEntry(P2);
            PassTimer = new TimeRegion(ADTJavaDifferentiators.JD$Timer$P.INSTANCE, IrLlvmGlobals.getPassTimer(P2));
            P2.releaseMemory();
        }
        finally {
            if (PassTimer != null) {
                PassTimer.$destroy();
            }
            if (X != null) {
                X.$destroy();
            }
        }
        Object PI = P2.getPassID();
        PassInfo PInf = this.$PMDataManager$Fields().TPM.findAnalysisPassInfo(PI);
        if (PInf != null) {
            this.$PMDataManager$Fields().AvailableAnalysis.erase(PI);
            std.vector<PassInfo> II = PInf.getInterfacesImplemented();
            int e = II.size();
            for (int i = 0; i != e; ++i) {
                DenseMapIterator Pos = this.$PMDataManager$Fields().AvailableAnalysis.find(((PassInfo)II.$at$Const(i)).getTypeInfo());
                if (!Pos.$noteq(this.$PMDataManager$Fields().AvailableAnalysis.end()) || Pos.$arrow().second != P2) continue;
                this.$PMDataManager$Fields().AvailableAnalysis.erase(new DenseMapIterator(Pos));
            }
        }
    }

    default public void add(Pass P2) {
        this.add(P2, true);
    }

    default public void add(Pass P2, boolean ProcessAnalysis) {
        AnalysisResolver AR = new AnalysisResolver(this);
        P2.setResolver(AR);
        SmallVector TransferLastUses = new SmallVector(12, (Object)null);
        if (!ProcessAnalysis) {
            this.$PMDataManager$Fields().PassVector.push_back((Object)P2);
            return;
        }
        SmallVector LastUses = new SmallVector(12, (Object)null);
        SmallVector UsedPasses = new SmallVector(8, (Object)null);
        SmallVector ReqAnalysisNotAvailable = new SmallVector(8, null);
        int PDepth = this.getDepth();
        this.collectRequiredAndUsedAnalyses((SmallVectorImpl<Pass>)UsedPasses, (SmallVectorImpl<Object>)ReqAnalysisNotAvailable, P2);
        for (Pass PUsed : UsedPasses) {
            int RDepth = 0;
            if (!1.$assertionsDisabled && PUsed.getResolver() == null) {
                throw new AssertionError((Object)"Analysis Resolver is not set");
            }
            PMDataManager DM = PUsed.getResolver().getPMDataManager();
            RDepth = DM.getDepth();
            if (PDepth == RDepth) {
                LastUses.push_back((Object)PUsed);
                continue;
            }
            if (Unsigned.$greater_uint((int)PDepth, (int)RDepth)) {
                TransferLastUses.push_back((Object)PUsed);
                this.$PMDataManager$Fields().HigherLevelAnalysis.push_back((Object)PUsed);
                continue;
            }
            throw new llvm_unreachable("Unable to accommodate Used Pass");
        }
        if (P2.getAsPMDataManager() == null) {
            LastUses.push_back((Object)P2);
        }
        this.$PMDataManager$Fields().TPM.setLastUser((ArrayRef<Pass>)new ArrayRef((SmallVectorImplCommon)LastUses, true), P2);
        if (!TransferLastUses.empty()) {
            Pass My_PM = this.getAsPass();
            this.$PMDataManager$Fields().TPM.setLastUser((ArrayRef<Pass>)new ArrayRef((SmallVectorImplCommon)TransferLastUses, true), My_PM);
            TransferLastUses.clear();
        }
        for (Object ID2 : ReqAnalysisNotAvailable) {
            PassInfo PI = this.$PMDataManager$Fields().TPM.findAnalysisPassInfo(ID2);
            Pass AnalysisPass = PI.createPass();
            this.addLowerLevelRequiredPass(P2, AnalysisPass);
        }
        this.removeNotPreservedAnalysis(P2);
        this.recordAvailableAnalysis(P2);
        this.$PMDataManager$Fields().PassVector.push_back((Object)P2);
    }

    default public void addLowerLevelRequiredPass(Pass P2, Pass RequiredPass) {
        if (this.$PMDataManager$Fields().TPM != null) {
            this.$PMDataManager$Fields().TPM.dumpArguments();
            this.$PMDataManager$Fields().TPM.dumpPasses();
        }
        llvm.dbgs().$out("Unable to schedule '").$out(RequiredPass.getPassName());
        llvm.dbgs().$out("' required by '").$out(P2.getPassName()).$out("'\n");
        throw new llvm_unreachable("Unable to schedule pass");
    }

    default public Pass getOnTheFlyPass(Pass P2, Object PI, Function F) {
        throw new llvm_unreachable("Unable to find on the fly pass");
    }

    default public void initializeAnalysisInfo() {
        this.initializeAnalysisInfo(this.$PMDataManager$Fields());
    }

    default public void initializeAnalysisInfo(PMDataManager.Fields $Fields) {
        $Fields.AvailableAnalysis.clear();
        int i = 0;
        while (Unsigned.$less_uint((int)i, (int)PassManagerType.PMT_Last.getValue())) {
            $Fields.InheritedAnalysis[i] = null;
            ++i;
        }
    }

    default public boolean preserveHigherLevelAnalysis(Pass P2) {
        AnalysisUsage AnUsage = this.$PMDataManager$Fields().TPM.findAnalysisUsage(P2);
        if (AnUsage.getPreservesAll()) {
            return true;
        }
        SmallVectorImpl<Object> PreservedSet = AnUsage.getPreservedSet();
        type.ptr I = (type.ptr)Native.$tryClone((NativeCloneable)this.$PMDataManager$Fields().HigherLevelAnalysis.begin());
        type.ptr E = (type.ptr)Native.$tryClone((NativeCloneable)this.$PMDataManager$Fields().HigherLevelAnalysis.end());
        while (Native.$noteq_ptr((void.ptr)I, (void.ptr)E)) {
            Pass P1 = (Pass)I.$star();
            if (P1.getAsImmutablePass() == null && Native.$eq_ptr((void.ptr)((type.ptr)std.find((type.iterator)PreservedSet.begin$Const(), (type.iterator)PreservedSet.end$Const(), (Object)P1.getPassID())), (void.ptr)PreservedSet.end$Const())) {
                return false;
            }
            I.$preInc();
        }
        return true;
    }

    default public void collectRequiredAndUsedAnalyses(SmallVectorImpl<Pass> UP, SmallVectorImpl<Object> RP_NotAvail, Pass P2) {
        Pass AnalysisPass;
        AnalysisUsage AnUsage = this.$PMDataManager$Fields().TPM.findAnalysisUsage(P2);
        for (Object UsedID : AnUsage.getUsedSet()) {
            AnalysisPass = this.findAnalysisPass(UsedID, true);
            if (AnalysisPass == null) continue;
            UP.push_back((Object)AnalysisPass);
        }
        for (Object RequiredID : AnUsage.getRequiredSet()) {
            AnalysisPass = this.findAnalysisPass(RequiredID, true);
            if (AnalysisPass != null) {
                UP.push_back((Object)AnalysisPass);
                continue;
            }
            RP_NotAvail.push_back(RequiredID);
        }
        for (Object RequiredID : AnUsage.getRequiredTransitiveSet()) {
            AnalysisPass = this.findAnalysisPass(RequiredID, true);
            if (AnalysisPass != null) {
                UP.push_back((Object)AnalysisPass);
                continue;
            }
            RP_NotAvail.push_back(RequiredID);
        }
    }

    default public void initializeAnalysisImpl(Pass P2) {
        AnalysisUsage AnUsage = this.$PMDataManager$Fields().TPM.findAnalysisUsage(P2);
        type.ptr I = (type.ptr)Native.$tryClone((NativeCloneable)AnUsage.getRequiredSet().begin$Const());
        type.ptr E = (type.ptr)Native.$tryClone((NativeCloneable)AnUsage.getRequiredSet().end$Const());
        while (Native.$noteq_ptr((void.ptr)I, (void.ptr)E)) {
            Pass Impl = this.findAnalysisPass(I.$star(), true);
            if (Impl != null) {
                AnalysisResolver AR = P2.getResolver();
                if (!1.$assertionsDisabled && AR == null) {
                    throw new AssertionError((Object)"Analysis Resolver is not set");
                }
                AR.addAnalysisImplsPair(I.$star(), Impl);
            }
            I.$preInc();
        }
    }

    default public Pass findAnalysisPass(Object AID, boolean SearchParent) {
        DenseMapIterator I = new DenseMapIterator(this.$PMDataManager$Fields().AvailableAnalysis.find(AID));
        if (I.$noteq(this.$PMDataManager$Fields().AvailableAnalysis.end())) {
            return (Pass)I.$arrow().second;
        }
        if (SearchParent) {
            return this.$PMDataManager$Fields().TPM.findAnalysisPass(AID);
        }
        return null;
    }

    default public PMTopLevelManager getTopLevelManager() {
        return this.$PMDataManager$Fields().TPM;
    }

    default public void setTopLevelManager(PMTopLevelManager T2) {
        this.$PMDataManager$Fields().TPM = T2;
    }

    default public int getDepth() {
        return this.$PMDataManager$Fields().Depth;
    }

    default public void setDepth(int newDepth) {
        this.$PMDataManager$Fields().Depth = newDepth;
    }

    default public void dumpLastUses(Pass P2, int Offset) {
        SmallVector LUses = new SmallVector(12, (Object)null);
        if (this.$PMDataManager$Fields().TPM == null) {
            return;
        }
        this.$PMDataManager$Fields().TPM.collectLastUses((SmallVectorImpl<Pass>)LUses, P2);
        type.ptr I = (type.ptr)Native.$tryClone((NativeCloneable)LUses.begin());
        type.ptr E = (type.ptr)Native.$tryClone((NativeCloneable)LUses.end());
        while (Native.$noteq_ptr((void.ptr)I, (void.ptr)E)) {
            llvm.dbgs().$out(NativePointer.$MINUS_MINUS).$out(new std.string(Offset * 2, 32));
            ((Pass)I.$star()).dumpPassStructure(0);
            I.$preInc();
        }
    }

    default public void dumpPassArguments() {
        type.ptr I = (type.ptr)Native.$tryClone((NativeCloneable)this.$PMDataManager$Fields().PassVector.begin$Const());
        type.ptr E = (type.ptr)Native.$tryClone((NativeCloneable)this.$PMDataManager$Fields().PassVector.end$Const());
        while (Native.$noteq_ptr((void.ptr)I, (void.ptr)E)) {
            PMDataManager PMD = ((Pass)I.$star()).getAsPMDataManager();
            if (PMD != null) {
                PMD.dumpPassArguments();
            } else {
                PassInfo PI = this.$PMDataManager$Fields().TPM.findAnalysisPassInfo(((Pass)I.$star()).getPassID());
                if (PI != null && !PI.isAnalysisGroup()) {
                    llvm.dbgs().$out(" -").$out(PI.getPassArgument());
                }
            }
            I.$preInc();
        }
    }

    default public void dumpPassInfo(Pass P2, PassDebuggingString S1, PassDebuggingString S2, StringRef Msg) {
        if (((PassDebugLevel)((Object)LegacyPassManagerStatics.PassDebugging.$T())).getValue() < PassDebugLevel.Executions.getValue()) {
            return;
        }
        llvm.dbgs().$out(NativePointer.$LSQUARE).$out(TimeValue.now().str()).$out("] ").$out(Casts.reinterpret_cast(Object.class, (Object)this)).$out(new std.string(this.getDepth() * 2 + 1, 32));
        switch (S1) {
            case EXECUTION_MSG: {
                llvm.dbgs().$out("Executing Pass '").$out(P2.getPassName());
                break;
            }
            case MODIFICATION_MSG: {
                llvm.dbgs().$out("Made Modification '").$out(P2.getPassName());
                break;
            }
            case FREEING_MSG: {
                llvm.dbgs().$out(" Freeing Pass '").$out(P2.getPassName());
                break;
            }
        }
        switch (S2) {
            case ON_BASICBLOCK_MSG: {
                llvm.dbgs().$out("' on BasicBlock '").$out(Msg).$out("'...\n");
                break;
            }
            case ON_FUNCTION_MSG: {
                llvm.dbgs().$out("' on Function '").$out(Msg).$out("'...\n");
                break;
            }
            case ON_MODULE_MSG: {
                llvm.dbgs().$out("' on Module '").$out(Msg).$out("'...\n");
                break;
            }
            case ON_REGION_MSG: {
                llvm.dbgs().$out("' on Region '").$out(Msg).$out("'...\n");
                break;
            }
            case ON_LOOP_MSG: {
                llvm.dbgs().$out("' on Loop '").$out(Msg).$out("'...\n");
                break;
            }
            case ON_CG_MSG: {
                llvm.dbgs().$out("' on Call Graph Nodes '").$out(Msg).$out("'...\n");
                break;
            }
        }
    }

    default public void dumpRequiredSet(Pass P2) {
        AnalysisUsage analysisUsage = null;
        try {
            if (((PassDebugLevel)((Object)LegacyPassManagerStatics.PassDebugging.$T())).getValue() < PassDebugLevel.Details.getValue()) {
                return;
            }
            analysisUsage = new AnalysisUsage();
            P2.getAnalysisUsage(analysisUsage);
            this.dumpAnalysisUsage(new StringRef("Required"), P2, analysisUsage.getRequiredSet());
        }
        finally {
            if (analysisUsage != null) {
                analysisUsage.$destroy();
            }
        }
    }

    default public void dumpPreservedSet(Pass P2) {
        AnalysisUsage analysisUsage = null;
        try {
            if (((PassDebugLevel)((Object)LegacyPassManagerStatics.PassDebugging.$T())).getValue() < PassDebugLevel.Details.getValue()) {
                return;
            }
            analysisUsage = new AnalysisUsage();
            P2.getAnalysisUsage(analysisUsage);
            this.dumpAnalysisUsage(new StringRef("Preserved"), P2, analysisUsage.getPreservedSet());
        }
        finally {
            if (analysisUsage != null) {
                analysisUsage.$destroy();
            }
        }
    }

    default public void dumpUsedSet(Pass P2) {
        AnalysisUsage analysisUsage = null;
        try {
            if (((PassDebugLevel)((Object)LegacyPassManagerStatics.PassDebugging.$T())).getValue() < PassDebugLevel.Details.getValue()) {
                return;
            }
            analysisUsage = new AnalysisUsage();
            P2.getAnalysisUsage(analysisUsage);
            this.dumpAnalysisUsage(new StringRef("Used"), P2, analysisUsage.getUsedSet());
        }
        finally {
            if (analysisUsage != null) {
                analysisUsage.$destroy();
            }
        }
    }

    default public int getNumContainedPasses() {
        return this.$PMDataManager$Fields().PassVector.size();
    }

    default public PassManagerType getPassManagerType() {
        if (!1.$assertionsDisabled) {
            throw new AssertionError((Object)"Invalid use of getPassManagerType");
        }
        return PassManagerType.PMT_Unknown;
    }

    default public DenseMap<Object, Pass> getAvailableAnalysis() {
        return (DenseMap)Native.$AddrOf(this.$PMDataManager$Fields().AvailableAnalysis);
    }

    default public void populateInheritedAnalysis(PMStack PMS) {
        int Index = 0;
        std.reverse_iterator<PMDataManager> I = PMS.begin();
        std.reverse_iterator<PMDataManager> E = PMS.end();
        while (ADTAliases.$noteq_reverse_iterator$C(I, E)) {
            this.$PMDataManager$Fields().InheritedAnalysis[Index++] = ((PMDataManager)I.$star()).getAvailableAnalysis();
            I.$preInc();
        }
    }

    default public boolean isPassDebuggingExecutionsOrMore() {
        return ((PassDebugLevel)((Object)LegacyPassManagerStatics.PassDebugging.$T())).getValue() >= PassDebugLevel.Executions.getValue();
    }

    default public void dumpAnalysisUsage(StringRef Msg, Pass P2, SmallVectorImpl<Object> Set2) {
        if (!1.$assertionsDisabled && ((PassDebugLevel)((Object)LegacyPassManagerStatics.PassDebugging.$T())).getValue() < PassDebugLevel.Details.getValue()) {
            throw new AssertionError();
        }
        if (Set2.empty()) {
            return;
        }
        llvm.dbgs().$out(Casts.reinterpret_cast(Object.class, (Object)P2)).$out(new std.string(this.getDepth() * 2 + 3, 32)).$out(Msg).$out(" Analyses:");
        for (int i = 0; i != Set2.size(); ++i) {
            PassInfo PInf;
            if (i != 0) {
                llvm.dbgs().$out_char((byte)44);
            }
            if ((PInf = this.$PMDataManager$Fields().TPM.findAnalysisPassInfo(Set2.$at$Const(i))) == null) {
                llvm.dbgs().$out(" Uninitialized Pass");
                continue;
            }
            llvm.dbgs().$out_char((byte)32).$out(PInf.getPassName());
        }
        llvm.dbgs().$out_char((byte)10);
    }

    default public PMDataManager.Fields $PMDataManager$Fields() {
        throw new UnsupportedOperationException("Why not implemented in derived?");
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

