/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.clank.java.std;
import org.clank.support.Casts;
import org.clank.support.Destructors;
import org.clank.support.NativeCallback;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.type;
import org.clank.support.void;
import org.llvm.adt.Twine;
import org.llvm.adt.iterator_range;
import org.llvm.ir.BasicBlock;
import org.llvm.ir.Instruction;
import org.llvm.ir.OperandTraitsPHINode;
import org.llvm.ir.Type;
import org.llvm.ir.UndefValue;
import org.llvm.ir.Use;
import org.llvm.ir.User;
import org.llvm.ir.Value;
import org.llvm.ir.java.IrRTTI;
import org.llvm.support.llvm;

public class PHINode
extends Instruction
implements Destructors.ClassWithDestructor {
    private int ReservedSpace;

    @Override
    protected void anchor() {
    }

    protected static Object $new_PHINode(int $Prm0, int $Prm1) {
        throw new UnsupportedOperationException("Deleted");
    }

    private PHINode(PHINode PN) {
        super(PN.getType(), 53, (type.ptr<Use>)((type.ptr)null), PN.getNumOperands());
        this.ReservedSpace = PN.getNumOperands();
        this.allocHungoffUses(PN.getNumOperands());
        std.copy(PN.op_begin$Const(), PN.op_end$Const(), this.op_begin());
        std.copy(PN.block_begin$Const(), PN.block_end$Const(), this.block_begin());
        this.SubclassOptionalData = Unsigned.$uchar2uchar_7bits((byte)Unsigned.$7bits_uchar2uchar((byte)PN.SubclassOptionalData));
    }

    private static <T extends PHINode> T $new_PHINode(NativeCallback.New.ConstructorCallback<T> $Ctor) {
        return (T)((PHINode)User.$new_HangOffUses($Ctor));
    }

    private PHINode(Type Ty, int NumReservedValues) {
        this(Ty, NumReservedValues, new Twine(NativePointer.$EMPTY), (Instruction)null);
    }

    private PHINode(Type Ty, int NumReservedValues, Twine NameStr) {
        this(Ty, NumReservedValues, NameStr, (Instruction)null);
    }

    private PHINode(Type Ty, int NumReservedValues, Twine NameStr, Instruction InsertBefore) {
        super(Ty, 53, (type.ptr<Use>)((type.ptr)null), 0, InsertBefore);
        this.ReservedSpace = NumReservedValues;
        this.setName(NameStr);
        this.allocHungoffUses(this.ReservedSpace);
    }

    private PHINode(Type Ty, int NumReservedValues, Twine NameStr, BasicBlock InsertAtEnd) {
        super(Ty, 53, (type.ptr<Use>)((type.ptr)null), 0, InsertAtEnd);
        this.ReservedSpace = NumReservedValues;
        this.setName(NameStr);
        this.allocHungoffUses(this.ReservedSpace);
    }

    @Override
    protected void allocHungoffUses(int N) {
        super.allocHungoffUses(N, true);
    }

    protected PHINode cloneImpl() {
        return PHINode.$new_PHINode(New$Mem -> new PHINode(this));
    }

    public static PHINode Create(Type Ty, int NumReservedValues) {
        return PHINode.Create(Ty, NumReservedValues, new Twine(NativePointer.$EMPTY), (Instruction)null);
    }

    public static PHINode Create(Type Ty, int NumReservedValues, Twine NameStr) {
        return PHINode.Create(Ty, NumReservedValues, NameStr, (Instruction)null);
    }

    public static PHINode Create(Type Ty, int NumReservedValues, Twine NameStr, Instruction InsertBefore) {
        return PHINode.$new_PHINode(New$Mem -> new PHINode(Ty, NumReservedValues, NameStr, InsertBefore));
    }

    public static PHINode Create(Type Ty, int NumReservedValues, Twine NameStr, BasicBlock InsertAtEnd) {
        return PHINode.$new_PHINode(New$Mem -> new PHINode(Ty, NumReservedValues, NameStr, InsertAtEnd));
    }

    @Override
    public Value getOperand(int i_nocapture) {
        assert (Unsigned.$less_uint((int)i_nocapture, (int)OperandTraitsPHINode.operands(this))) : "getOperand() out of range!";
        return IrRTTI.cast_or_null_Value(((Use)OperandTraitsPHINode.op_begin(this).$at(i_nocapture)).get());
    }

    @Override
    public void setOperand(int i_nocapture, Value Val_nocapture) {
        assert (Unsigned.$less_uint((int)i_nocapture, (int)OperandTraitsPHINode.operands(this))) : "setOperand() out of range!";
        ((Use)OperandTraitsPHINode.op_begin(this).$at(i_nocapture)).$assign(Val_nocapture);
    }

    @Override
    public type.ptr<Use> op_begin() {
        return OperandTraitsPHINode.op_begin(this);
    }

    @Override
    public type.ptr<Use> op_begin$Const() {
        return OperandTraitsPHINode.op_begin(this);
    }

    @Override
    public type.ptr<Use> op_end() {
        return OperandTraitsPHINode.op_end(this);
    }

    @Override
    public type.ptr<Use> op_end$Const() {
        return OperandTraitsPHINode.op_end(this);
    }

    @Override
    protected Use Op(int Idx_nocapture) {
        return this.OpFrom(Idx_nocapture, this);
    }

    @Override
    protected Use Op$Const(int Idx_nocapture) {
        return this.OpFrom(Idx_nocapture, this);
    }

    @Override
    public int getNumOperands() {
        return OperandTraitsPHINode.operands(this);
    }

    public type.ptr<BasicBlock> block_begin() {
        type.ptr ref2 = (type.ptr)this.op_begin().$add(this.ReservedSpace);
        return (type.ptr)Casts.reinterpret_cast(type.ptr.class, (void.ptr)((void.ptr)ref2.$add(1)));
    }

    public type.ptr<BasicBlock> block_begin$Const() {
        type.ptr ref2 = (type.ptr)this.op_begin$Const().$add(this.ReservedSpace);
        return (type.ptr)Casts.reinterpret_cast(type.ptr.class, (void.ptr)((void.ptr)ref2.$add(1)));
    }

    public type.ptr<BasicBlock> block_end() {
        return (type.ptr)this.block_begin().$add(this.getNumOperands());
    }

    public type.ptr<BasicBlock> block_end$Const() {
        return (type.ptr)this.block_begin$Const().$add(this.getNumOperands());
    }

    public iterator_range<BasicBlock> blocks() {
        return llvm.make_range(this.block_begin(), this.block_end());
    }

    public iterator_range<BasicBlock> blocks$Const() {
        return llvm.make_range(this.block_begin$Const(), this.block_end$Const());
    }

    public iterator_range<Use> incoming_values() {
        return this.operands();
    }

    public iterator_range<Use> incoming_values$Const() {
        return this.operands$Const();
    }

    public int getNumIncomingValues() {
        return this.getNumOperands();
    }

    public Value getIncomingValue(int i) {
        return this.getOperand(i);
    }

    public void setIncomingValue(int i, Value V) {
        assert (V != null) : "PHI node got a null value!";
        assert (this.getType() == V.getType()) : "All operands to PHI node must be the same type as the PHI node!";
        this.setOperand(i, V);
    }

    public static int getOperandNumForIncomingValue(int i) {
        return i;
    }

    public static int getIncomingValueNumForOperand(int i) {
        return i;
    }

    public BasicBlock getIncomingBlock(int i) {
        return (BasicBlock)this.block_begin$Const().$at(i);
    }

    public BasicBlock getIncomingBlock(Use U) {
        assert (this == U.getUser()) : "Iterator doesn't point to PHI's Uses?";
        return this.getIncomingBlock(U.$This$Ptr().$sub(this.op_begin$Const()));
    }

    public BasicBlock getIncomingBlock(Value.user_iterator_impl<User> I) {
        return this.getIncomingBlock(I.getUse());
    }

    public void setIncomingBlock(int i, BasicBlock BB) {
        assert (BB != null) : "PHI node got a null basic block!";
        this.block_begin().$set(i, (Object)BB);
    }

    public void addIncoming(Value V, BasicBlock BB) {
        if (this.getNumOperands() == this.ReservedSpace) {
            this.growOperands();
        }
        this.setNumHungOffUseOperands(this.getNumOperands() + 1);
        this.setIncomingValue(this.getNumOperands() - 1, V);
        this.setIncomingBlock(this.getNumOperands() - 1, BB);
    }

    public Value removeIncomingValue(int Idx) {
        return this.removeIncomingValue(Idx, true);
    }

    public Value removeIncomingValue(int Idx, boolean DeletePHIIfEmpty) {
        Value Removed = this.getIncomingValue(Idx);
        std.copy((type.iterator)((type.iterator)((type.ptr)this.op_begin().$add(Idx)).$add(1)), this.op_end(), (type.iterator)((type.ptr)this.op_begin().$add(Idx)));
        std.copy((type.iterator)((type.iterator)((type.ptr)this.block_begin().$add(Idx)).$add(1)), this.block_end(), (type.iterator)((type.ptr)this.block_begin().$add(Idx)));
        this.Op(-1).set(null);
        this.setNumHungOffUseOperands(this.getNumOperands() - 1);
        if (this.getNumOperands() == 0 && DeletePHIIfEmpty) {
            this.replaceAllUsesWith(UndefValue.get(this.getType()));
            this.eraseFromParent();
        }
        return Removed;
    }

    public Value removeIncomingValue(BasicBlock BB) {
        return this.removeIncomingValue(BB, true);
    }

    public Value removeIncomingValue(BasicBlock BB, boolean DeletePHIIfEmpty) {
        int Idx = this.getBasicBlockIndex(BB);
        assert (Idx >= 0) : "Invalid basic block argument to remove!";
        return this.removeIncomingValue(Idx, DeletePHIIfEmpty);
    }

    public int getBasicBlockIndex(BasicBlock BB) {
        int e = this.getNumOperands();
        for (int i = 0; i != e; ++i) {
            if (this.block_begin$Const().$at(i) != BB) continue;
            return i;
        }
        return -1;
    }

    public Value getIncomingValueForBlock(BasicBlock BB) {
        int Idx = this.getBasicBlockIndex(BB);
        assert (Idx >= 0) : "Invalid basic block argument!";
        return this.getIncomingValue(Idx);
    }

    public Value hasConstantValue() {
        Value ConstantValue = this.getIncomingValue(0);
        int e = this.getNumIncomingValues();
        for (int i = 1; i != e; ++i) {
            if (this.getIncomingValue(i) == ConstantValue || this.getIncomingValue(i) == this) continue;
            if (ConstantValue != this) {
                return null;
            }
            ConstantValue = this.getIncomingValue(i);
        }
        if (ConstantValue == this) {
            return UndefValue.get(this.getType());
        }
        return ConstantValue;
    }

    public boolean hasConstantOrUndefValue() {
        Value ConstantValue = null;
        int e = this.getNumIncomingValues();
        for (int i = 0; i != e; ++i) {
            Value Incoming = this.getIncomingValue(i);
            if (Incoming == this || IrRTTI.isa_UndefValue(Incoming)) continue;
            if (ConstantValue != null && ConstantValue != Incoming) {
                return false;
            }
            ConstantValue = Incoming;
        }
        return true;
    }

    public static boolean classof(Instruction I) {
        return I.getOpcode() == 53;
    }

    public static boolean classof(Value V) {
        return IrRTTI.isa_Instruction(V) && PHINode.classof(IrRTTI.cast_Instruction(V));
    }

    private void growOperands() {
        int e = this.getNumOperands();
        int NumOps = e + Unsigned.$div_uint((int)e, (int)2);
        if (Unsigned.$less_uint((int)NumOps, (int)2)) {
            NumOps = 2;
        }
        this.ReservedSpace = NumOps;
        this.growHungoffUses(this.ReservedSpace, true);
    }

    @Override
    public void $destroy() {
        super.$destroy();
    }

    @Override
    public String toString() {
        return "ReservedSpace=" + this.ReservedSpace + super.toString();
    }
}

