/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.clank.java.std;
import org.clank.support.Casts;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.Unsigned;
import org.clank.support.aliases.type;
import org.clank.support.aliases.uchar;
import org.clank.support.aliases.uint;
import org.clank.support.void;
import org.llvm.adt.Optional;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.ArrayRefUInt;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.adt.aliases.StringMapEntryUInt;
import org.llvm.adt.iterator_range;
import org.llvm.ir.Attribute;
import org.llvm.ir.Instruction;
import org.llvm.ir.LLVMContext;
import org.llvm.ir.OperandBundleDefT;
import org.llvm.ir.OperandBundleUse;
import org.llvm.ir.Use;
import org.llvm.ir.Value;
import org.llvm.ir.java.CallOrInvokeInst;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;

public interface OperandBundleUser<InstrTy extends Instruction, OpIteratorTy extends type.ptr<Use>> {
    default public int getNumOperandBundles() {
        return std.distance(this.bundle_op_info_begin(), this.bundle_op_info_end());
    }

    default public boolean hasOperandBundles() {
        return Native.$noteq((int)this.getNumOperandBundles(), (int)0);
    }

    default public int getBundleOperandsStartIndex() {
        if (!1.$assertionsDisabled && !Native.$bool((boolean)this.hasOperandBundles())) {
            throw new AssertionError((Object)"Don't call otherwise!");
        }
        return ((BundleOpInfo)this.bundle_op_info_begin().$star()).Begin;
    }

    default public int getBundleOperandsEndIndex() {
        if (!1.$assertionsDisabled && !Native.$bool((boolean)this.hasOperandBundles())) {
            throw new AssertionError((Object)"Don't call otherwise!");
        }
        return ((BundleOpInfo)this.bundle_op_info_end().$at((int)-1)).End;
    }

    default public int getNumTotalBundleOperands() {
        if (Native.$not((boolean)this.hasOperandBundles())) {
            return 0;
        }
        int Begin = this.getBundleOperandsStartIndex();
        int End = this.getBundleOperandsEndIndex();
        if (!1.$assertionsDisabled && !Unsigned.$lesseq_uint((int)Begin, (int)End)) {
            throw new AssertionError((Object)"Should be!");
        }
        return End - Begin;
    }

    default public OperandBundleUse getOperandBundleAt(int Index) {
        if (!1.$assertionsDisabled && !Native.$bool((boolean)Native.$less((int)Index, (int)this.getNumOperandBundles()))) {
            throw new AssertionError((Object)"Index out of bounds!");
        }
        return this.operandBundleFromBundleOpInfo((BundleOpInfo)Native.$Deref((type.iterator)Native.$add(this.bundle_op_info_begin(), (int)Index)));
    }

    default public int countOperandBundlesOfType(StringRef Name) {
        int Count = 0;
        int e = this.getNumOperandBundles();
        for (int i = 0; i != e; ++i) {
            if (!Native.$eq((Object)this.getOperandBundleAt(i).getTagName(), (Object)Name)) continue;
            ++Count;
        }
        return Count;
    }

    default public int countOperandBundlesOfType(int ID2) {
        int Count = 0;
        int e = this.getNumOperandBundles();
        for (int i = 0; i != e; ++i) {
            if (!Native.$eq((int)this.getOperandBundleAt(i).getTagID(), (int)ID2)) continue;
            ++Count;
        }
        return Count;
    }

    default public Optional<OperandBundleUse> getOperandBundle(StringRef Name) {
        if (!1.$assertionsDisabled && !Native.$bool((boolean)Native.$less((int)this.countOperandBundlesOfType(Name), (int)2))) {
            throw new AssertionError((Object)"Precondition violated!");
        }
        int e = this.getNumOperandBundles();
        for (int i = 0; i != e; ++i) {
            OperandBundleUse U = this.getOperandBundleAt(i);
            if (!llvm.$eq_StringRef((StringRef)U.getTagName(), (StringRef)Name)) continue;
            return new Optional(JavaDifferentiators.JD$T$RR.INSTANCE, (Object)U);
        }
        return new Optional(llvm.None);
    }

    default public Optional<OperandBundleUse> getOperandBundle(int ID2) {
        if (!1.$assertionsDisabled && !Native.$bool((boolean)Native.$less((int)this.countOperandBundlesOfType(ID2), (int)2))) {
            throw new AssertionError((Object)"Precondition violated!");
        }
        int e = this.getNumOperandBundles();
        for (int i = 0; i != e; ++i) {
            OperandBundleUse U = this.getOperandBundleAt(i);
            if (U.getTagID() != ID2) continue;
            return new Optional(JavaDifferentiators.JD$T$RR.INSTANCE, (Object)U);
        }
        return new Optional(llvm.None);
    }

    default public void getOperandBundlesAsDefs(SmallVectorImpl<OperandBundleDefT<Value>> Defs) {
        int e = this.getNumOperandBundles();
        for (int i = 0; i != e; ++i) {
            Defs.emplace_back(new OperandBundleDefT(this.getOperandBundleAt(i), U -> U.$Value$P()));
        }
    }

    default public OperandBundleUse getOperandBundleForOperand(int OpIdx) {
        return this.operandBundleFromBundleOpInfo(this.getBundleOpInfoForOperand(OpIdx));
    }

    default public boolean hasReadingOperandBundles() {
        return this.hasOperandBundles();
    }

    default public boolean hasClobberingOperandBundles() {
        for (BundleOpInfo BOI : this.bundle_op_infos()) {
            if (Native.$bool((boolean)Native.$eq((Object)BOI.Tag.second, (Object)((Object)LLVMContext.Unnamed_enum1.OB_deopt))) || Native.$bool((boolean)Native.$eq((Object)BOI.Tag.second, (Object)((Object)LLVMContext.Unnamed_enum1.OB_funclet)))) continue;
            return true;
        }
        return false;
    }

    default public boolean bundleOperandHasAttr(int OpIdx, Attribute.AttrKind A2) {
        BundleOpInfo BOI = this.getBundleOpInfoForOperand(OpIdx);
        OperandBundleUse OBU = this.operandBundleFromBundleOpInfo(BOI);
        return OBU.operandHasAttr(OpIdx - BOI.Begin, A2);
    }

    default public boolean hasIdenticalOperandBundleSchema(OperandBundleUser<InstrTy, OpIteratorTy> Other) {
        if (Native.$noteq((int)this.getNumOperandBundles(), (int)Other.getNumOperandBundles())) {
            return false;
        }
        return std.equal(this.bundle_op_info_begin(), this.bundle_op_info_end(), Other.bundle_op_info_begin());
    }

    default public boolean hasOperandBundlesOtherThan(ArrayRefUInt IDs) {
        int e = this.getNumOperandBundles();
        for (int i = 0; i != e; ++i) {
            int ID2 = this.getOperandBundleAt(i).getTagID();
            if (!Native.$eq_ptr((void.ptr)std.find((uint.ptr)IDs.begin(), (uint.ptr)IDs.end(), (int)ID2), (void.ptr)IDs.end())) continue;
            return true;
        }
        return false;
    }

    default public boolean isFnAttrDisallowedByOpBundle(StringRef S) {
        return false;
    }

    default public boolean isFnAttrDisallowedByOpBundle(Attribute.AttrKind A2) {
        switch (A2) {
            default: {
                return false;
            }
            case ArgMemOnly: {
                return this.hasReadingOperandBundles();
            }
            case ReadNone: {
                return this.hasReadingOperandBundles();
            }
            case ReadOnly: 
        }
        return this.hasClobberingOperandBundles();
    }

    default public OperandBundleUse operandBundleFromBundleOpInfo(BundleOpInfo BOI) {
        type.ptr<Use> op_begin = ((Instruction)((Object)this)).op_begin();
        ArrayRef Inputs = new ArrayRef(Native.$add(op_begin, (int)BOI.Begin), Native.$add(op_begin, (int)BOI.End), false);
        return new OperandBundleUse(BOI.Tag, (ArrayRef<Use>)Inputs);
    }

    default public type.ptr<BundleOpInfo> bundle_op_info_begin() {
        if (Native.$not((boolean)((CallOrInvokeInst)((Object)((Instruction)((Object)this)))).hasDescriptor())) {
            return null;
        }
        uchar.ptr BytesBegin = ((Instruction)((Object)this)).getDescriptor().begin();
        return (type.ptr)Casts.reinterpret_cast(type.ptr.class, (Object)BytesBegin);
    }

    default public type.ptr<BundleOpInfo> bundle_op_info_begin$Const() {
        OperandBundleUser NonConstThis = this;
        return NonConstThis.bundle_op_info_begin();
    }

    default public type.ptr<BundleOpInfo> bundle_op_info_end() {
        if (Native.$not((boolean)((CallOrInvokeInst)((Object)((Instruction)((Object)this)))).hasDescriptor())) {
            return null;
        }
        uchar.ptr BytesEnd = ((Instruction)((Object)this)).getDescriptor().end();
        return (type.ptr)Casts.reinterpret_cast(type.ptr.class, (Object)BytesEnd);
    }

    default public type.ptr<BundleOpInfo> bundle_op_info_end$Const() {
        OperandBundleUser NonConstThis = this;
        return NonConstThis.bundle_op_info_end();
    }

    default public iterator_range<BundleOpInfo> bundle_op_infos() {
        return llvm.make_range(this.bundle_op_info_begin(), this.bundle_op_info_end());
    }

    default public iterator_range<BundleOpInfo> bundle_op_infos$Const() {
        return llvm.make_range(this.bundle_op_info_begin(), this.bundle_op_info_end());
    }

    default public OpIteratorTy populateBundleOperandInfos(ArrayRef<OperandBundleDefT<Value>> Bundles, int BeginIndex) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    default public BundleOpInfo getBundleOpInfoForOperand(int OpIdx) {
        for (BundleOpInfo BOI : this.bundle_op_infos()) {
            if (!Native.$bool((boolean)Native.$lesseq((int)BOI.Begin, (int)OpIdx)) || !Native.$bool((boolean)Native.$less((int)OpIdx, (int)BOI.End))) continue;
            return BOI;
        }
        throw new llvm_unreachable("Did not find operand bundle for operand!");
    }

    public static <InstrTy, OpIteratorTy> int CountBundleInputs(ArrayRef<OperandBundleDefT<Value>> Bundles) {
        int Total = 0;
        for (OperandBundleDefT B2 : Bundles) {
            Total += B2.input_size();
        }
        return Total;
    }

    default public void $OperandBundleUser() {
    }

    default public void $destroy$OperandBundleUser() {
    }

    private static /* synthetic */ void lambda$populateBundleOperandInfos$1(type.iterator source, type.iterator dest) {
        ((Use)dest.$star()).$assign((Value)source.$star());
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public static class BundleOpInfo
    implements Native.NativeComparable<BundleOpInfo> {
        public StringMapEntryUInt Tag;
        public int Begin;
        public int End;

        public boolean $eq(BundleOpInfo Other) {
            return Native.$bool((Native.$bool((boolean)Native.$eq((Object)this.Tag, (Object)Other.Tag)) && Native.$bool((boolean)Native.$eq((int)this.Begin, (int)Other.Begin)) ? 1 : 0) != 0) && Native.$bool((boolean)Native.$eq((int)this.End, (int)Other.End));
        }

        public String toString() {
            return "Tag=" + this.Tag + ", Begin=" + this.Begin + ", End=" + this.End;
        }
    }
}

