/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.ArrayRefUInt;
import org.llvm.ir.BinaryOperator;
import org.llvm.ir.CastInst;
import org.llvm.ir.CmpInst;
import org.llvm.ir.Constant;
import org.llvm.ir.ConstantExpr;
import org.llvm.ir.ExtractElementInst;
import org.llvm.ir.ExtractValueInst;
import org.llvm.ir.FCmpInst;
import org.llvm.ir.GetElementPtrInst;
import org.llvm.ir.ICmpInst;
import org.llvm.ir.InsertElementInst;
import org.llvm.ir.InsertValueInst;
import org.llvm.ir.Instruction;
import org.llvm.ir.SelectInst;
import org.llvm.ir.ShuffleVectorInst;
import org.llvm.ir.Type;
import org.llvm.ir.Value;
import org.llvm.ir.java.IFolder;

public class NoFolder
implements IFolder<Constant, Instruction> {
    public NoFolder() {
    }

    @Override
    public Instruction CreateAdd(Constant LHS, Constant RHS) {
        return this.CreateAdd(LHS, RHS, false, false);
    }

    @Override
    public Instruction CreateAdd(Constant LHS, Constant RHS, boolean HasNUW) {
        return this.CreateAdd(LHS, RHS, HasNUW, false);
    }

    @Override
    public Instruction CreateAdd(Constant LHS, Constant RHS, boolean HasNUW, boolean HasNSW) {
        BinaryOperator BO = BinaryOperator.CreateAdd(LHS, RHS);
        if (HasNUW) {
            BO.setHasNoUnsignedWrap();
        }
        if (HasNSW) {
            BO.setHasNoSignedWrap();
        }
        return BO;
    }

    public Instruction CreateNSWAdd(Constant LHS, Constant RHS) {
        return BinaryOperator.CreateNSWAdd(LHS, RHS);
    }

    public Instruction CreateNUWAdd(Constant LHS, Constant RHS) {
        return BinaryOperator.CreateNUWAdd(LHS, RHS);
    }

    public Instruction CreateFAdd(Constant LHS, Constant RHS) {
        return BinaryOperator.CreateFAdd(LHS, RHS);
    }

    @Override
    public Instruction CreateSub(Constant LHS, Constant RHS) {
        return this.CreateSub(LHS, RHS, false, false);
    }

    @Override
    public Instruction CreateSub(Constant LHS, Constant RHS, boolean HasNUW) {
        return this.CreateSub(LHS, RHS, HasNUW, false);
    }

    @Override
    public Instruction CreateSub(Constant LHS, Constant RHS, boolean HasNUW, boolean HasNSW) {
        BinaryOperator BO = BinaryOperator.CreateSub(LHS, RHS);
        if (HasNUW) {
            BO.setHasNoUnsignedWrap();
        }
        if (HasNSW) {
            BO.setHasNoSignedWrap();
        }
        return BO;
    }

    public Instruction CreateNSWSub(Constant LHS, Constant RHS) {
        return BinaryOperator.CreateNSWSub(LHS, RHS);
    }

    public Instruction CreateNUWSub(Constant LHS, Constant RHS) {
        return BinaryOperator.CreateNUWSub(LHS, RHS);
    }

    @Override
    public Instruction CreateFSub(Constant LHS, Constant RHS) {
        return BinaryOperator.CreateFSub(LHS, RHS);
    }

    @Override
    public Instruction CreateMul(Constant LHS, Constant RHS) {
        return this.CreateMul(LHS, RHS, false, false);
    }

    @Override
    public Instruction CreateMul(Constant LHS, Constant RHS, boolean HasNUW) {
        return this.CreateMul(LHS, RHS, HasNUW, false);
    }

    @Override
    public Instruction CreateMul(Constant LHS, Constant RHS, boolean HasNUW, boolean HasNSW) {
        BinaryOperator BO = BinaryOperator.CreateMul(LHS, RHS);
        if (HasNUW) {
            BO.setHasNoUnsignedWrap();
        }
        if (HasNSW) {
            BO.setHasNoSignedWrap();
        }
        return BO;
    }

    public Instruction CreateNSWMul(Constant LHS, Constant RHS) {
        return BinaryOperator.CreateNSWMul(LHS, RHS);
    }

    public Instruction CreateNUWMul(Constant LHS, Constant RHS) {
        return BinaryOperator.CreateNUWMul(LHS, RHS);
    }

    @Override
    public Instruction CreateFMul(Constant LHS, Constant RHS) {
        return BinaryOperator.CreateFMul(LHS, RHS);
    }

    @Override
    public Instruction CreateUDiv(Constant LHS, Constant RHS) {
        return this.CreateUDiv(LHS, RHS, false);
    }

    @Override
    public Instruction CreateUDiv(Constant LHS, Constant RHS, boolean isExact) {
        if (!isExact) {
            return BinaryOperator.CreateUDiv(LHS, RHS);
        }
        return BinaryOperator.CreateExactUDiv(LHS, RHS);
    }

    public Instruction CreateExactUDiv(Constant LHS, Constant RHS) {
        return BinaryOperator.CreateExactUDiv(LHS, RHS);
    }

    @Override
    public Instruction CreateSDiv(Constant LHS, Constant RHS) {
        return this.CreateSDiv(LHS, RHS, false);
    }

    @Override
    public Instruction CreateSDiv(Constant LHS, Constant RHS, boolean isExact) {
        if (!isExact) {
            return BinaryOperator.CreateSDiv(LHS, RHS);
        }
        return BinaryOperator.CreateExactSDiv(LHS, RHS);
    }

    public Instruction CreateExactSDiv(Constant LHS, Constant RHS) {
        return BinaryOperator.CreateExactSDiv(LHS, RHS);
    }

    @Override
    public Instruction CreateFDiv(Constant LHS, Constant RHS) {
        return BinaryOperator.CreateFDiv(LHS, RHS);
    }

    @Override
    public Instruction CreateURem(Constant LHS, Constant RHS) {
        return BinaryOperator.CreateURem(LHS, RHS);
    }

    @Override
    public Instruction CreateSRem(Constant LHS, Constant RHS) {
        return BinaryOperator.CreateSRem(LHS, RHS);
    }

    @Override
    public Instruction CreateFRem(Constant LHS, Constant RHS) {
        return BinaryOperator.CreateFRem(LHS, RHS);
    }

    @Override
    public Instruction CreateShl(Constant LHS, Constant RHS) {
        return this.CreateShl(LHS, RHS, false, false);
    }

    @Override
    public Instruction CreateShl(Constant LHS, Constant RHS, boolean HasNUW) {
        return this.CreateShl(LHS, RHS, HasNUW, false);
    }

    @Override
    public Instruction CreateShl(Constant LHS, Constant RHS, boolean HasNUW, boolean HasNSW) {
        BinaryOperator BO = BinaryOperator.CreateShl(LHS, RHS);
        if (HasNUW) {
            BO.setHasNoUnsignedWrap();
        }
        if (HasNSW) {
            BO.setHasNoSignedWrap();
        }
        return BO;
    }

    @Override
    public Instruction CreateLShr(Constant LHS, Constant RHS) {
        return this.CreateLShr(LHS, RHS, false);
    }

    @Override
    public Instruction CreateLShr(Constant LHS, Constant RHS, boolean isExact) {
        if (!isExact) {
            return BinaryOperator.CreateLShr(LHS, RHS);
        }
        return BinaryOperator.CreateExactLShr(LHS, RHS);
    }

    @Override
    public Instruction CreateAShr(Constant LHS, Constant RHS) {
        return this.CreateAShr(LHS, RHS, false);
    }

    @Override
    public Instruction CreateAShr(Constant LHS, Constant RHS, boolean isExact) {
        if (!isExact) {
            return BinaryOperator.CreateAShr(LHS, RHS);
        }
        return BinaryOperator.CreateExactAShr(LHS, RHS);
    }

    @Override
    public Instruction CreateAnd(Constant LHS, Constant RHS) {
        return BinaryOperator.CreateAnd(LHS, RHS);
    }

    @Override
    public Instruction CreateOr(Constant LHS, Constant RHS) {
        return BinaryOperator.CreateOr(LHS, RHS);
    }

    @Override
    public Instruction CreateXor(Constant LHS, Constant RHS) {
        return BinaryOperator.CreateXor(LHS, RHS);
    }

    @Override
    public Instruction CreateBinOp(int Opc, Constant LHS, Constant RHS) {
        return BinaryOperator.Create(Opc, LHS, RHS);
    }

    @Override
    public Instruction CreateNeg(Constant C2) {
        return this.CreateNeg(C2, false, false);
    }

    @Override
    public Instruction CreateNeg(Constant C2, boolean HasNUW) {
        return this.CreateNeg(C2, HasNUW, false);
    }

    @Override
    public Instruction CreateNeg(Constant C2, boolean HasNUW, boolean HasNSW) {
        BinaryOperator BO = BinaryOperator.CreateNeg(C2);
        if (HasNUW) {
            BO.setHasNoUnsignedWrap();
        }
        if (HasNSW) {
            BO.setHasNoSignedWrap();
        }
        return BO;
    }

    public Instruction CreateNSWNeg(Constant C2) {
        return BinaryOperator.CreateNSWNeg(C2);
    }

    public Instruction CreateNUWNeg(Constant C2) {
        return BinaryOperator.CreateNUWNeg(C2);
    }

    @Override
    public Instruction CreateFNeg(Constant C2) {
        return BinaryOperator.CreateFNeg(C2);
    }

    @Override
    public Instruction CreateNot(Constant C2) {
        return BinaryOperator.CreateNot(C2);
    }

    public Constant CreateGetElementPtr_Type$P_Constant$P_ArrayRef$Constant$P(Type Ty, Constant C2, ArrayRef<Constant> IdxList) {
        return ConstantExpr.getGetElementPtr_Type$P_Constant$P_ArrayRef$Constant$P_bool_Type$P(Ty, C2, (ArrayRef<Constant>)new ArrayRef(IdxList));
    }

    @Override
    public Constant CreateGetElementPtr(Type Ty, Constant C2, Constant Idx) {
        return ConstantExpr.getGetElementPtr(Ty, C2, Idx);
    }

    @Override
    public Instruction CreateGetElementPtr_Type$P_Constant$P_ArrayRef$Value$P(Type Ty, Constant C2, ArrayRef<Value> IdxList) {
        return GetElementPtrInst.Create1(Ty, C2, (ArrayRef<Value>)new ArrayRef(IdxList));
    }

    public Constant CreateInBoundsGetElementPtr_Type$P_Constant$P_ArrayRef$Constant$P(Type Ty, Constant C2, ArrayRef<Constant> IdxList) {
        return ConstantExpr.getInBoundsGetElementPtr_Type$P_Constant$P_ArrayRef$Constant$P(Ty, C2, (ArrayRef<Constant>)new ArrayRef(IdxList));
    }

    @Override
    public Constant CreateInBoundsGetElementPtr(Type Ty, Constant C2, Constant Idx) {
        return ConstantExpr.getInBoundsGetElementPtr(Ty, C2, Idx);
    }

    public Instruction CreateInBoundsGetElementPtr_Type$P_Constant$P_ArrayRef$Value$P(Type Ty, Constant C2, ArrayRef<Value> IdxList) {
        return GetElementPtrInst.CreateInBounds2(Ty, C2, (ArrayRef<Value>)new ArrayRef(IdxList));
    }

    @Override
    public Instruction CreateCast(int Op, Constant C2, Type DestTy) {
        return CastInst.Create(Op, C2, DestTy);
    }

    @Override
    public Instruction CreatePointerCast(Constant C2, Type DestTy) {
        return CastInst.CreatePointerCast(C2, DestTy);
    }

    @Override
    public Instruction CreateIntCast(Constant C2, Type DestTy, boolean isSigned) {
        return CastInst.CreateIntegerCast(C2, DestTy, isSigned);
    }

    @Override
    public Instruction CreateFPCast(Constant C2, Type DestTy) {
        return CastInst.CreateFPCast(C2, DestTy);
    }

    public Instruction CreateBitCast(Constant C2, Type DestTy) {
        return this.CreateCast(47, C2, DestTy);
    }

    public Instruction CreateIntToPtr(Constant C2, Type DestTy) {
        return this.CreateCast(46, C2, DestTy);
    }

    public Instruction CreatePtrToInt(Constant C2, Type DestTy) {
        return this.CreateCast(45, C2, DestTy);
    }

    @Override
    public Instruction CreateZExtOrBitCast(Constant C2, Type DestTy) {
        return CastInst.CreateZExtOrBitCast(C2, DestTy);
    }

    @Override
    public Instruction CreateSExtOrBitCast(Constant C2, Type DestTy) {
        return CastInst.CreateSExtOrBitCast(C2, DestTy);
    }

    @Override
    public Instruction CreateTruncOrBitCast(Constant C2, Type DestTy) {
        return CastInst.CreateTruncOrBitCast(C2, DestTy);
    }

    @Override
    public Instruction CreateICmp(CmpInst.Predicate P2, Constant LHS, Constant RHS) {
        return CmpInst.$new_CmpInst(New$Mem -> new ICmpInst(P2, LHS, RHS));
    }

    @Override
    public Instruction CreateFCmp(CmpInst.Predicate P2, Constant LHS, Constant RHS) {
        return CmpInst.$new_CmpInst(New$Mem -> new FCmpInst(P2, LHS, RHS));
    }

    @Override
    public Instruction CreateSelect(Constant C2, Constant True, Constant False) {
        return SelectInst.Create(C2, True, False);
    }

    @Override
    public Instruction CreateExtractElement(Constant Vec, Constant Idx) {
        return ExtractElementInst.Create(Vec, Idx);
    }

    @Override
    public Instruction CreateInsertElement(Constant Vec, Constant NewElt, Constant Idx) {
        return InsertElementInst.Create(Vec, NewElt, Idx);
    }

    @Override
    public Instruction CreateShuffleVector(Constant V1, Constant V2, Constant Mask) {
        return ShuffleVectorInst.$new_ShuffleVectorInst(New$Mem -> new ShuffleVectorInst(V1, V2, Mask));
    }

    @Override
    public Instruction CreateExtractValue(Constant Agg, ArrayRefUInt IdxList) {
        return ExtractValueInst.Create_Value1(Agg, new ArrayRefUInt(IdxList));
    }

    @Override
    public Instruction CreateInsertValue(Constant Agg, Constant Val, ArrayRefUInt IdxList) {
        return InsertValueInst.Create_Value$P_ArrayRefUInt_Twine$C_Instruction$P(Agg, Val, new ArrayRefUInt(IdxList));
    }

    public NoFolder(NoFolder other) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    @Override
    public NoFolder clone() {
        return new NoFolder(this);
    }

    @Override
    public Instruction CreatePointerBitCastOrAddrSpaceCast(Constant C2, Type DestTy) {
        throw new UnsupportedOperationException("NoFolder does not support CreatePointerBitCastOrAddrSpaceCast");
    }

    public String toString() {
        return "";
    }
}

