/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.clank.java.std_ptr;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.Native;
import org.llvm.ir.Function;
import org.llvm.ir.Module$IR;
import org.llvm.ir.Value;
import org.llvm.ir.impl.SlotTracker;
import org.llvm.support.llvm;

public class ModuleSlotTracker
implements Destructors.ClassWithDestructor {
    private std_ptr.unique_ptr<SlotTracker> MachineStorage = new std_ptr.unique_ptr();
    private boolean ShouldCreateStorage;
    private boolean ShouldInitializeAllMetadata;
    private Module$IR M;
    private Function F;
    private SlotTracker Machine;

    public ModuleSlotTracker(SlotTracker Machine, Module$IR M) {
        this(Machine, M, null);
    }

    public ModuleSlotTracker(SlotTracker Machine, Module$IR M, Function F) {
        this.ShouldCreateStorage = false;
        this.ShouldInitializeAllMetadata = false;
        this.M = M;
        this.F = F;
        this.Machine = (SlotTracker)Native.$AddrOf((Object)Machine);
    }

    public ModuleSlotTracker(Module$IR M) {
        this(M, true);
    }

    public ModuleSlotTracker(Module$IR M, boolean ShouldInitializeAllMetadata) {
        this.ShouldCreateStorage = M != null;
        this.ShouldInitializeAllMetadata = ShouldInitializeAllMetadata;
        this.M = M;
        this.F = null;
        this.Machine = null;
    }

    public void $destroy() {
        this.MachineStorage.$destroy();
    }

    public SlotTracker getMachine() {
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            if (!this.ShouldCreateStorage) {
                SlotTracker slotTracker = this.Machine;
                return slotTracker;
            }
            this.ShouldCreateStorage = false;
            $c$.clean((Object)this.MachineStorage.$assignMove($c$.track(llvm.make_unique((Object)new SlotTracker(this.M, this.ShouldInitializeAllMetadata)))));
            SlotTracker slotTracker = this.Machine = (SlotTracker)this.MachineStorage.get();
            return slotTracker;
        }
        finally {
            $c$.$destroy();
        }
    }

    public Module$IR getModule() {
        return this.M;
    }

    public Function getCurrentFunction() {
        return this.F;
    }

    public void incorporateFunction(Function F) {
        if (this.getMachine() == null) {
            return;
        }
        if (this.F == Native.$AddrOf((Object)F)) {
            return;
        }
        if (this.F != null) {
            this.Machine.purgeFunction();
        }
        this.Machine.incorporateFunction((Function)Native.$AddrOf((Object)F));
        this.F = (Function)Native.$AddrOf((Object)F);
    }

    public int getLocalSlot(Value V) {
        assert (this.F != null) : "No function incorporated";
        return this.Machine.getLocalSlot(V);
    }

    public String toString() {
        return "MachineStorage=" + this.MachineStorage + ", ShouldCreateStorage=" + this.ShouldCreateStorage + ", ShouldInitializeAllMetadata=" + this.ShouldInitializeAllMetadata + ", M=" + this.M + ", F=" + this.F + ", Machine=" + this.Machine;
    }
}

