/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import java.util.Iterator;
import org.clank.java.std;
import org.clank.java.std_errors;
import org.clank.java.std_pair;
import org.clank.java.std_ptr;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativeMoveable;
import org.clank.support.NativePointer;
import org.clank.support.NativeTrace;
import org.clank.support.Unsigned;
import org.clank.support.aliases.JavaIterator;
import org.clank.support.aliases.type;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.adt.aliases.StringMap;
import org.llvm.adt.aliases.StringMapEntry;
import org.llvm.adt.aliases.StringMapIterator;
import org.llvm.adt.ilist;
import org.llvm.adt.ilist_iterator;
import org.llvm.adt.ilist_node;
import org.llvm.adt.ilist_traits;
import org.llvm.adt.iterator_range;
import org.llvm.ir.AssemblyAnnotationWriter;
import org.llvm.ir.AttributeSet;
import org.llvm.ir.Comdat;
import org.llvm.ir.Constant;
import org.llvm.ir.ConstantAsMetadata;
import org.llvm.ir.ConstantExpr;
import org.llvm.ir.ConstantInt;
import org.llvm.ir.DICompileUnit;
import org.llvm.ir.DataLayout;
import org.llvm.ir.Function;
import org.llvm.ir.FunctionType;
import org.llvm.ir.GVMaterializer;
import org.llvm.ir.GlobalAlias;
import org.llvm.ir.GlobalIFunc;
import org.llvm.ir.GlobalObject;
import org.llvm.ir.GlobalValue;
import org.llvm.ir.GlobalVariable;
import org.llvm.ir.IntegerType;
import org.llvm.ir.LLVMContext;
import org.llvm.ir.MDNode;
import org.llvm.ir.MDString;
import org.llvm.ir.Metadata;
import org.llvm.ir.NamedMDNode;
import org.llvm.ir.PointerType;
import org.llvm.ir.StructType;
import org.llvm.ir.SymbolTableList;
import org.llvm.ir.Type;
import org.llvm.ir.TypeFinder;
import org.llvm.ir.ValueSymbolTable;
import org.llvm.ir.ilist_traitsNamedMDNode;
import org.llvm.ir.impl.AssemblyWriter;
import org.llvm.ir.impl.SlotTracker;
import org.llvm.ir.impl.SymbolTableListTraits;
import org.llvm.ir.java.IRMemberPointers;
import org.llvm.ir.java.IValueSymbolTableProvider;
import org.llvm.ir.java.IrRTTI;
import org.llvm.ir.mdconst.MdconstGlobals;
import org.llvm.pass.Pass;
import org.llvm.support.PICLevel;
import org.llvm.support.PIELevel;
import org.llvm.support.RandomNumberGenerator;
import org.llvm.support.formatted_raw_ostream;
import org.llvm.support.llvm;
import org.llvm.support.raw_ostream;
import org.llvm.support.sys.path;

public class Module$IR
implements Iterable<Function>,
IValueSymbolTableProvider,
Destructors.ClassWithDestructor {
    private final LLVMContext Context;
    private final SymbolTableList<GlobalVariable, Module$IR> GlobalList;
    private final SymbolTableList<Function, Module$IR> FunctionList;
    private final SymbolTableList<GlobalAlias, Module$IR> AliasList;
    private final SymbolTableList<GlobalIFunc, Module$IR> IFuncList;
    private ilist<NamedMDNode> NamedMDList;
    private std.string GlobalScopeAsm;
    private ValueSymbolTable ValSymTab;
    private StringMap<Comdat> ComdatSymTab;
    private std_ptr.unique_ptr<GVMaterializer> Materializer;
    private std.string ModuleID;
    private std.string SourceFileName;
    private std.string TargetTriple;
    private Object NamedMDSymTab;
    private DataLayout DL;

    public static boolean isValidModFlagBehavior(Metadata MD, type.ref<ModFlagBehavior> MFB) {
        long Val;
        ConstantInt Behavior = MdconstGlobals.dyn_extract_or_null$ValidReference(ConstantInt.class, MD);
        if (Behavior != null && Unsigned.$greatereq_ulong_uint((long)(Val = Behavior.getLimitedValue()), (int)ModFlagBehavior.ModFlagBehaviorFirstVal.getValue()) && Unsigned.$lesseq_ulong_uint((long)Val, (int)ModFlagBehavior.ModFlagBehaviorLastVal.getValue())) {
            MFB.$set((Object)ModFlagBehavior.valueOf(Unsigned.$ulong2uint((long)Val)));
            return true;
        }
        return false;
    }

    public Module$IR(StringRef MID, LLVMContext C2) {
        this.Context = C2;
        this.GlobalList = new SymbolTableListTraits.GlobalVariable.SymbolTableList.GlobalVariable(this);
        this.FunctionList = new SymbolTableListTraits.Function.SymbolTableList.Function(this);
        this.AliasList = new SymbolTableListTraits.GlobalAlias.SymbolTableList.GlobalAlias(this);
        this.IFuncList = new SymbolTableListTraits.GlobalIFunc.SymbolTableList.GlobalIFunc(this);
        this.NamedMDList = new ilist<NamedMDNode>(){

            protected ilist_traits<NamedMDNode> $createTraits() {
                return new ilist_traitsNamedMDNode();
            }
        };
        this.GlobalScopeAsm = new std.string();
        this.ComdatSymTab = new StringMap((Object)new Comdat());
        this.Materializer = new std_ptr.unique_ptr();
        this.ModuleID = MID.$string();
        this.SourceFileName = MID.$string();
        this.TargetTriple = new std.string();
        this.DL = new DataLayout(new StringRef(NativePointer.$EMPTY));
        this.ValSymTab = new ValueSymbolTable();
        this.NamedMDSymTab = new StringMap((Object)null);
        this.Context.addModule(this);
    }

    public void $destroy() {
        this.Context.removeModule(this);
        this.dropAllReferences();
        this.GlobalList.clear();
        this.FunctionList.clear();
        this.AliasList.clear();
        this.IFuncList.clear();
        this.NamedMDList.clear();
        Destructors.$destroy((Destructors.ClassWithDestructor)this.ValSymTab);
        Destructors.$destroy((Destructors.ClassWithDestructor)((StringMap)this.NamedMDSymTab));
        this.DL.$destroy();
        this.TargetTriple.$destroy();
        this.SourceFileName.$destroy();
        this.ModuleID.$destroy();
        this.Materializer.$destroy();
        this.ComdatSymTab.$destroy();
        this.GlobalScopeAsm.$destroy();
        this.NamedMDList.$destroy();
        this.IFuncList.$destroy();
        this.AliasList.$destroy();
        this.FunctionList.$destroy();
        this.GlobalList.$destroy();
    }

    public std.string getModuleIdentifier() {
        return this.ModuleID;
    }

    public std.string getSourceFileName() {
        return this.SourceFileName;
    }

    public StringRef getName() {
        return new StringRef(this.ModuleID);
    }

    public std.string getDataLayoutStr() {
        return this.DL.getStringRepresentation();
    }

    public DataLayout getDataLayout() {
        return this.DL;
    }

    public std.string getTargetTriple() {
        return this.TargetTriple;
    }

    public LLVMContext getContext() {
        return this.Context;
    }

    public std.string getModuleInlineAsm() {
        return this.GlobalScopeAsm;
    }

    public RandomNumberGenerator createRNG(Pass P2) {
        SmallString Salt = new SmallString(32, new StringRef(P2.getPassName()));
        Salt.$addassign(path.filename((StringRef)new StringRef(this.getModuleIdentifier())));
        return new RandomNumberGenerator(Salt.$StringRef());
    }

    public void setModuleIdentifier(StringRef ID2) {
        this.ModuleID.$assignMove(ID2.$string());
    }

    public void setSourceFileName(StringRef Name) {
        this.SourceFileName.$assignMove(Name.$string());
    }

    public void setDataLayout(StringRef Desc) {
        this.DL.reset(new StringRef(Desc));
    }

    public void setDataLayout(DataLayout Other) {
        this.DL.$assign(Other);
    }

    public void setTargetTriple(StringRef T2) {
        this.TargetTriple.$assignMove(T2.$string());
    }

    public void setModuleInlineAsm(StringRef Asm) {
        this.GlobalScopeAsm.$assignMove(Asm.$string());
        if (!this.GlobalScopeAsm.empty() && this.GlobalScopeAsm.back() != 10) {
            this.GlobalScopeAsm.$addassign_T((byte)10);
        }
    }

    public void appendModuleInlineAsm(StringRef Asm) {
        llvm.$addassign_string_StringRef((std.string)this.GlobalScopeAsm, (StringRef)Asm);
        if (!this.GlobalScopeAsm.empty() && this.GlobalScopeAsm.back() != 10) {
            this.GlobalScopeAsm.$addassign_T((byte)10);
        }
    }

    public GlobalValue getNamedValue(StringRef Name) {
        return IrRTTI.cast_or_null_GlobalValue(this.getValueSymbolTable$Const().lookup(new StringRef(Name)));
    }

    public int getMDKindID(StringRef Name) {
        return this.Context.getMDKindID(new StringRef(Name));
    }

    public void getMDKindNames(SmallVectorImpl<StringRef> Result2) {
        this.Context.getMDKindNames(Result2);
    }

    public void getOperandBundleTags(SmallVectorImpl<StringRef> Result2) {
        this.Context.getOperandBundleTags(Result2);
    }

    public StructType getTypeByName(StringRef Name) {
        return (StructType)this.getContext().pImpl.NamedStructTypes.lookup(new StringRef(Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public std.vector<StructType> getIdentifiedStructTypes() {
        std.vector Ret = null;
        TypeFinder SrcStructTypes = null;
        try {
            if (this.Materializer.$bool()) {
                std.vector<StructType> vector2 = ((GVMaterializer)this.Materializer.$arrow()).getIdentifiedStructTypes();
                return vector2;
            }
            Ret = new std.vector((Object)null);
            SrcStructTypes = new TypeFinder();
            SrcStructTypes.run(this, true);
            Ret.assign$T(SrcStructTypes.begin(), SrcStructTypes.end());
            std.vector vector3 = new std.vector(JavaDifferentiators.JD.Move.INSTANCE, Ret);
            return vector3;
        }
        finally {
            if (SrcStructTypes != null) {
                SrcStructTypes.$destroy();
            }
            if (Ret != null) {
                Ret.$destroy();
            }
        }
    }

    public Constant getOrInsertFunction(StringRef Name, FunctionType Ty, AttributeSet AttributeList) {
        GlobalValue F = this.getNamedValue(new StringRef(Name));
        if (F == null) {
            Function New2 = Function.Create(Ty, GlobalValue.LinkageTypes.ExternalLinkage, new Twine(Name));
            if (!New2.isIntrinsic()) {
                New2.setAttributes(new AttributeSet(AttributeList));
            }
            this.FunctionList.push_back(New2);
            return New2;
        }
        if (F.getType() != PointerType.getUnqual(Ty)) {
            return ConstantExpr.getBitCast(F, PointerType.getUnqual(Ty));
        }
        return F;
    }

    public Constant getOrInsertFunction(StringRef Name, FunctionType Ty) {
        return this.getOrInsertFunction(new StringRef(Name), Ty, new AttributeSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Constant getOrInsertFunction(StringRef Name, AttributeSet AttributeList, Type RetTy, Type ... $VarArg) {
        std.vector ArgTys = null;
        try {
            ArgTys = new std.vector((Object)null);
            if ($VarArg != null) {
                for (Type ArgTy : $VarArg) {
                    if (ArgTy == null) continue;
                    ArgTys.push_back_T$C$R((Object)ArgTy);
                }
            }
            Constant constant = this.getOrInsertFunction(new StringRef(Name), FunctionType.get(RetTy, (ArrayRef<Type>)new ArrayRef(ArgTys, true), false), new AttributeSet(AttributeList));
            return constant;
        }
        finally {
            if (ArgTys != null) {
                ArgTys.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Constant getOrInsertFunction(StringRef Name, Type RetTy, Type ... $VarArg) {
        std.vector ArgTys = null;
        try {
            ArgTys = new std.vector((Object)null);
            if ($VarArg != null) {
                for (Type ArgTy : $VarArg) {
                    if (ArgTy == null) continue;
                    ArgTys.push_back_T$C$R((Object)ArgTy);
                }
            }
            Constant constant = this.getOrInsertFunction(new StringRef(Name), FunctionType.get(RetTy, (ArrayRef<Type>)new ArrayRef(ArgTys, true), false), new AttributeSet());
            return constant;
        }
        finally {
            if (ArgTys != null) {
                ArgTys.$destroy();
            }
        }
    }

    public Function getFunction(StringRef Name) {
        return IrRTTI.dyn_cast_or_null_Function(this.getNamedValue(new StringRef(Name)));
    }

    public GlobalVariable getGlobalVariable$Const(StringRef Name) {
        return this.getGlobalVariable$Const(new StringRef(Name), false);
    }

    public GlobalVariable getGlobalVariable$Const(StringRef Name, boolean AllowInternal) {
        return this.getGlobalVariable(new StringRef(Name), AllowInternal);
    }

    public GlobalVariable getGlobalVariable(StringRef Name) {
        return this.getGlobalVariable(Name, false);
    }

    public GlobalVariable getGlobalVariable(StringRef Name, boolean AllowLocal) {
        GlobalVariable Result2 = IrRTTI.dyn_cast_or_null_GlobalVariable(this.getNamedValue(new StringRef(Name)));
        if (Result2 != null && (AllowLocal || !Result2.hasLocalLinkage())) {
            return Result2;
        }
        return null;
    }

    public GlobalVariable getNamedGlobal(StringRef Name) {
        return this.getGlobalVariable(new StringRef(Name), true);
    }

    public GlobalVariable getNamedGlobal$Const(StringRef Name) {
        return this.getNamedGlobal(new StringRef(Name));
    }

    public Constant getOrInsertGlobal(StringRef Name, Type Ty) {
        PointerType PTy;
        GlobalVariable GV = IrRTTI.dyn_cast_or_null_GlobalVariable(this.getNamedValue(new StringRef(Name)));
        if (GV == null) {
            Object New2 = GlobalVariable.$new_GlobalVariable(New$Mem -> new GlobalVariable(this, Ty, false, GlobalValue.LinkageTypes.ExternalLinkage, (Constant)null, new Twine(Name)));
            return New2;
        }
        PointerType GVTy = GV.getType();
        if (GVTy != (PTy = PointerType.get(Ty, GVTy.getPointerAddressSpace()))) {
            return ConstantExpr.getBitCast(GV, PTy);
        }
        return GV;
    }

    public GlobalAlias getNamedAlias(StringRef Name) {
        return IrRTTI.dyn_cast_or_null_GlobalAlias(this.getNamedValue(new StringRef(Name)));
    }

    public GlobalIFunc getNamedIFunc(StringRef Name) {
        return IrRTTI.dyn_cast_or_null_GlobalIFunc(this.getNamedValue(new StringRef(Name)));
    }

    public NamedMDNode getNamedMetadata(Twine Name) {
        SmallString NameData = new SmallString(256);
        StringRef NameRef = Name.toStringRef(NameData);
        return (NamedMDNode)((StringMap)this.NamedMDSymTab).lookup(new StringRef(NameRef));
    }

    public NamedMDNode getOrInsertNamedMetadata(StringRef Name) {
        type.ref NMD = ((StringMap)this.NamedMDSymTab).ref$at(Name);
        if (NMD.$deref() == null) {
            NMD.$set((Object)new NamedMDNode(new Twine(Name)));
            ((NamedMDNode)NMD.$deref()).setParent(this);
            this.NamedMDList.push_back$P((ilist_node)((NamedMDNode)NMD.$deref()));
        }
        return (NamedMDNode)NMD.$deref();
    }

    public void eraseNamedMetadata(NamedMDNode NMD) {
        ((StringMap)this.NamedMDSymTab).erase(NMD.getName());
        this.NamedMDList.erase(NMD.getIterator());
    }

    public Comdat getOrInsertComdat(StringRef Name) {
        StringMapEntry Entry2;
        ((Comdat)Entry2.second).Name = Entry2 = ((StringMapIterator)this.ComdatSymTab.insert((std_pair.pair)std.make_pair((Object)((StringRef)Native.$Clone((NativeCloneable)Name)), (Object)((Comdat)Native.$Move((NativeMoveable)new Comdat())))).first).$star();
        return (Comdat)Entry2.second;
    }

    public void getModuleFlagsMetadata(SmallVectorImpl<ModuleFlagEntry> Flags) {
        NamedMDNode ModFlags = this.getModuleFlagsMetadata();
        if (ModFlags == null) {
            return;
        }
        for (MDNode Flag : ModFlags.operands$Const()) {
            type.ref MFB = NativePointer.create_type$ref();
            if (!Unsigned.$greatereq_uint((int)Flag.getNumOperands(), (int)3) || !Module$IR.isValidModFlagBehavior(Flag.getOperand(0).$Metadata$P(), (type.ref<ModFlagBehavior>)MFB) || IrRTTI.dyn_cast_or_null_MDString(Flag.getOperand(1)) == null) continue;
            MDString Key = IrRTTI.cast_MDString(Flag.getOperand(1));
            Metadata Val = Flag.getOperand(2).$Metadata$P();
            Flags.push_back((Object)new ModuleFlagEntry((ModFlagBehavior)((Object)MFB.$deref()), Key, Val));
        }
    }

    public Metadata getModuleFlag(StringRef Key) {
        SmallVector ModuleFlags = new SmallVector(8, (Object)new ModuleFlagEntry());
        this.getModuleFlagsMetadata((SmallVectorImpl<ModuleFlagEntry>)ModuleFlags);
        for (ModuleFlagEntry MFE : ModuleFlags) {
            if (!llvm.$eq_StringRef((StringRef)Key, (StringRef)MFE.Key.getString())) continue;
            return MFE.Val;
        }
        return null;
    }

    public NamedMDNode getModuleFlagsMetadata() {
        return this.getNamedMetadata(new Twine("llvm.module.flags"));
    }

    public NamedMDNode getOrInsertModuleFlagsMetadata() {
        return this.getOrInsertNamedMetadata(new StringRef("llvm.module.flags"));
    }

    public void addModuleFlag(ModFlagBehavior Behavior, StringRef Key, Metadata Val) {
        IntegerType Int32Ty = Type.getInt32Ty(this.Context);
        Object[] Ops = new Metadata[]{ConstantAsMetadata.get(ConstantInt.get((Type)Int32Ty, (long)Behavior.getValue())), MDString.get(this.Context, new StringRef(Key)), Val};
        this.getOrInsertModuleFlagsMetadata().addOperand(MDNode.get(this.Context, (ArrayRef<Metadata>)new ArrayRef(Ops, true)));
    }

    public void addModuleFlag(ModFlagBehavior Behavior, StringRef Key, Constant Val) {
        this.addModuleFlag(Behavior, new StringRef(Key), ConstantAsMetadata.get(Val));
    }

    public void addModuleFlag(ModFlagBehavior Behavior, StringRef Key, int Val) {
        IntegerType Int32Ty = Type.getInt32Ty(this.Context);
        this.addModuleFlag(Behavior, new StringRef(Key), ConstantInt.get((Type)Int32Ty, Unsigned.$uint2ulong((int)Val)));
    }

    public void addModuleFlag(MDNode Node2) {
        assert (Node2.getNumOperands() == 3) : "Invalid number of operands for module flag!";
        assert (MdconstGlobals.hasa$ValidPointer(ConstantInt.class, Node2.getOperand(0)) && IrRTTI.isa_MDString(Node2.getOperand(1))) : "Invalid operand types for module flag!";
        this.getOrInsertModuleFlagsMetadata().addOperand(Node2);
    }

    public void setMaterializer(GVMaterializer GVM) {
        assert (!this.Materializer.$bool()) : "Module already has a GVMaterializer.  Call materializeAll to clear it out before setting another one.";
        this.Materializer.reset((Object)GVM);
    }

    public GVMaterializer getMaterializer() {
        return (GVMaterializer)this.Materializer.get();
    }

    public boolean isMaterialized() {
        return this.getMaterializer() == null;
    }

    public std_errors.error_code materialize(GlobalValue GV) {
        if (!this.Materializer.$bool()) {
            return new std_errors.error_code();
        }
        return ((GVMaterializer)this.Materializer.$arrow()).materialize(GV);
    }

    public std_errors.error_code materializeAll() {
        if (!this.Materializer.$bool()) {
            return new std_errors.error_code();
        }
        std_ptr.unique_ptr M = new std_ptr.unique_ptr(JavaDifferentiators.JD.Move.INSTANCE, (std_ptr.unique_ptr)std.move(this.Materializer));
        return ((GVMaterializer)M.$arrow()).materializeModule();
    }

    public std_errors.error_code materializeMetadata() {
        if (!this.Materializer.$bool()) {
            return new std_errors.error_code();
        }
        return ((GVMaterializer)this.Materializer.$arrow()).materializeMetadata();
    }

    public SymbolTableList<GlobalVariable, Module$IR> getGlobalList$Const() {
        return this.GlobalList;
    }

    public SymbolTableList<GlobalVariable, Module$IR> getGlobalList() {
        return this.GlobalList;
    }

    public static IRMemberPointers.Void2SymbolTableList<GlobalVariable, Module$IR> getSublistAccess(GlobalVariable $Prm0) {
        return new IRMemberPointers.Void2SymbolTableList<GlobalVariable, Module$IR>(){

            @Override
            public SymbolTableList<GlobalVariable, Module$IR> $call(Module$IR $this) {
                return $this.GlobalList;
            }
        };
    }

    public SymbolTableList<Function, Module$IR> getFunctionList$Const() {
        return this.FunctionList;
    }

    public SymbolTableList<Function, Module$IR> getFunctionList() {
        return this.FunctionList;
    }

    public static IRMemberPointers.Void2SymbolTableList<Function, Module$IR> getSublistAccess(Function $Prm0) {
        return new IRMemberPointers.Void2SymbolTableList<Function, Module$IR>(){

            @Override
            public SymbolTableList<Function, Module$IR> $call(Module$IR $this) {
                return $this.FunctionList;
            }
        };
    }

    public SymbolTableList<GlobalAlias, Module$IR> getAliasList$Const() {
        return this.AliasList;
    }

    public SymbolTableList<GlobalAlias, Module$IR> getAliasList() {
        return this.AliasList;
    }

    public static IRMemberPointers.Void2SymbolTableList<GlobalAlias, Module$IR> getSublistAccess(GlobalAlias $Prm0) {
        return new IRMemberPointers.Void2SymbolTableList<GlobalAlias, Module$IR>(){

            @Override
            public SymbolTableList<GlobalAlias, Module$IR> $call(Module$IR $this) {
                return $this.AliasList;
            }
        };
    }

    public SymbolTableList<GlobalIFunc, Module$IR> getIFuncList$Const() {
        return this.IFuncList;
    }

    public SymbolTableList<GlobalIFunc, Module$IR> getIFuncList() {
        return this.IFuncList;
    }

    public static IRMemberPointers.Void2SymbolTableList<GlobalIFunc, Module$IR> getSublistAccess(GlobalIFunc $Prm0) {
        return new IRMemberPointers.Void2SymbolTableList<GlobalIFunc, Module$IR>(){

            @Override
            public SymbolTableList<GlobalIFunc, Module$IR> $call(Module$IR $this) {
                return $this.IFuncList;
            }
        };
    }

    public ilist<NamedMDNode> getNamedMDList$Const() {
        return this.NamedMDList;
    }

    public ilist<NamedMDNode> getNamedMDList() {
        return this.NamedMDList;
    }

    public static IRMemberPointers.Void2NamedMDListType getSublistAccess(NamedMDNode $Prm0) {
        return new IRMemberPointers.Void2NamedMDListType(){

            @Override
            public ilist<NamedMDNode> $call(Module$IR $this) {
                return $this.NamedMDList;
            }
        };
    }

    public ValueSymbolTable getValueSymbolTable$Const() {
        return this.ValSymTab;
    }

    @Override
    public ValueSymbolTable getValueSymbolTable() {
        return this.ValSymTab;
    }

    public StringMap<Comdat> getComdatSymbolTable$Const() {
        return this.ComdatSymTab;
    }

    public StringMap<Comdat> getComdatSymbolTable() {
        return this.ComdatSymTab;
    }

    public ilist_iterator<GlobalVariable> global_begin() {
        return this.GlobalList.begin();
    }

    public ilist_iterator<GlobalVariable> global_begin$Const() {
        return this.GlobalList.begin$Const();
    }

    public ilist_iterator<GlobalVariable> global_end() {
        return this.GlobalList.end();
    }

    public ilist_iterator<GlobalVariable> global_end$Const() {
        return this.GlobalList.end$Const();
    }

    public boolean global_empty() {
        return this.GlobalList.empty();
    }

    public iterator_range<GlobalVariable> globals() {
        return llvm.make_range(this.global_begin(), this.global_end());
    }

    public iterator_range<GlobalVariable> globals$Const() {
        return llvm.make_range(this.global_begin$Const(), this.global_end$Const());
    }

    public ilist_iterator<Function> begin() {
        return this.FunctionList.begin();
    }

    public ilist_iterator<Function> begin$Const() {
        return this.FunctionList.begin$Const();
    }

    public ilist_iterator<Function> end() {
        return this.FunctionList.end();
    }

    public ilist_iterator<Function> end$Const() {
        return this.FunctionList.end$Const();
    }

    public std.reverse_iterator<Function> rbegin() {
        return this.FunctionList.rbegin();
    }

    public std.reverse_iterator<Function> rbegin$Const() {
        return this.FunctionList.rbegin$Const();
    }

    public std.reverse_iterator<Function> rend() {
        return this.FunctionList.rend();
    }

    public std.reverse_iterator<Function> rend$Const() {
        return this.FunctionList.rend$Const();
    }

    public int size() {
        return this.FunctionList.size();
    }

    public boolean empty() {
        return this.FunctionList.empty();
    }

    public iterator_range<Function> functions() {
        return llvm.make_range(this.begin(), this.end());
    }

    public iterator_range<Function> functions$Const() {
        return llvm.make_range(this.begin$Const(), this.end$Const());
    }

    public ilist_iterator<GlobalAlias> alias_begin() {
        return this.AliasList.begin();
    }

    public ilist_iterator<GlobalAlias> alias_begin$Const() {
        return this.AliasList.begin$Const();
    }

    public ilist_iterator<GlobalAlias> alias_end() {
        return this.AliasList.end();
    }

    public ilist_iterator<GlobalAlias> alias_end$Const() {
        return this.AliasList.end$Const();
    }

    public int alias_size() {
        return this.AliasList.size();
    }

    public boolean alias_empty() {
        return this.AliasList.empty();
    }

    public iterator_range<GlobalAlias> aliases() {
        return llvm.make_range(this.alias_begin(), this.alias_end());
    }

    public iterator_range<GlobalAlias> aliases$Const() {
        return llvm.make_range(this.alias_begin$Const(), this.alias_end$Const());
    }

    public ilist_iterator<GlobalIFunc> ifunc_begin() {
        return this.IFuncList.begin();
    }

    public ilist_iterator<GlobalIFunc> ifunc_begin$Const() {
        return this.IFuncList.begin$Const();
    }

    public ilist_iterator<GlobalIFunc> ifunc_end() {
        return this.IFuncList.end();
    }

    public ilist_iterator<GlobalIFunc> ifunc_end$Const() {
        return this.IFuncList.end$Const();
    }

    public int ifunc_size() {
        return this.IFuncList.size();
    }

    public boolean ifunc_empty() {
        return this.IFuncList.empty();
    }

    public iterator_range<GlobalIFunc> ifuncs() {
        return llvm.make_range(this.ifunc_begin(), this.ifunc_end());
    }

    public iterator_range<GlobalIFunc> ifuncs$Const() {
        return llvm.make_range(this.ifunc_begin$Const(), this.ifunc_end$Const());
    }

    public global_object_iterator_t global_object_begin() {
        return new global_object_iterator_t(this);
    }

    public global_object_iterator_t global_object_end() {
        return new global_object_iterator_t(this, 0);
    }

    public global_object_iterator_t global_object_begin$Const() {
        return new global_object_iterator_t(this);
    }

    public global_object_iterator_t global_object_end$Const() {
        return new global_object_iterator_t(this, 0);
    }

    public iterator_range<GlobalObject> global_objects() {
        return llvm.make_range((type.iterator)this.global_object_begin(), (type.iterator)this.global_object_end());
    }

    public iterator_range<GlobalObject> global_objects$Const() {
        return llvm.make_range((type.iterator)this.global_object_begin$Const(), (type.iterator)this.global_object_end$Const());
    }

    public ilist_iterator<NamedMDNode> named_metadata_begin() {
        return this.NamedMDList.begin();
    }

    public ilist_iterator<NamedMDNode> named_metadata_begin$Const() {
        return this.NamedMDList.begin$Const();
    }

    public ilist_iterator<NamedMDNode> named_metadata_end() {
        return this.NamedMDList.end();
    }

    public ilist_iterator<NamedMDNode> named_metadata_end$Const() {
        return this.NamedMDList.end$Const();
    }

    public int named_metadata_size() {
        return this.NamedMDList.size();
    }

    public boolean named_metadata_empty() {
        return this.NamedMDList.empty();
    }

    public iterator_range<NamedMDNode> named_metadata() {
        return llvm.make_range(this.named_metadata_begin(), this.named_metadata_end());
    }

    public iterator_range<NamedMDNode> named_metadata$Const() {
        return llvm.make_range(this.named_metadata_begin$Const(), this.named_metadata_end$Const());
    }

    public debug_compile_units_iterator debug_compile_units_begin() {
        NamedMDNode CUs = this.getNamedMetadata(new Twine("llvm.dbg.cu"));
        return new debug_compile_units_iterator(CUs, 0);
    }

    public debug_compile_units_iterator debug_compile_units_end() {
        NamedMDNode CUs;
        return new debug_compile_units_iterator(CUs, (CUs = this.getNamedMetadata(new Twine("llvm.dbg.cu"))) != null ? CUs.getNumOperands() : 0);
    }

    public iterator_range<DICompileUnit> debug_compile_units() {
        NamedMDNode CUs = this.getNamedMetadata(new Twine("llvm.dbg.cu"));
        return llvm.make_range((type.iterator)new debug_compile_units_iterator(CUs, 0), (type.iterator)new debug_compile_units_iterator(CUs, CUs != null ? CUs.getNumOperands() : 0));
    }

    public void dropTriviallyDeadConstantArrays() {
        this.Context.pImpl.dropTriviallyDeadConstantArrays();
    }

    public void print(raw_ostream ROS, AssemblyAnnotationWriter AAW) {
        this.print(ROS, AAW, false, false);
    }

    public void print(raw_ostream ROS, AssemblyAnnotationWriter AAW, boolean ShouldPreserveUseListOrder) {
        this.print(ROS, AAW, ShouldPreserveUseListOrder, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(raw_ostream ROS, AssemblyAnnotationWriter AAW, boolean ShouldPreserveUseListOrder, boolean IsForDebug) {
        SlotTracker SlotTable = null;
        formatted_raw_ostream OS = null;
        AssemblyWriter W = null;
        try {
            SlotTable = new SlotTracker(this);
            OS = new formatted_raw_ostream(ROS);
            W = new AssemblyWriter(OS, SlotTable, this, AAW, IsForDebug, ShouldPreserveUseListOrder);
            W.printModule(this);
        }
        finally {
            if (W != null) {
                W.$destroy();
            }
            if (OS != null) {
                OS.$destroy();
            }
            if (SlotTable != null) {
                SlotTable.$destroy();
            }
        }
    }

    public void dump() {
        this.print(llvm.dbgs(), null, false, true);
    }

    public void dropAllReferences() {
        for (Function F : this) {
            F.dropAllReferences();
        }
        for (GlobalVariable GV : this.globals()) {
            GV.dropAllReferences();
        }
        for (GlobalAlias GA : this.aliases()) {
            GA.dropAllReferences();
        }
        for (GlobalIFunc GIF : this.ifuncs()) {
            GIF.dropAllReferences();
        }
    }

    public int getDwarfVersion() {
        ConstantAsMetadata Val = IrRTTI.cast_or_null_ConstantAsMetadata(this.getModuleFlag(new StringRef("Dwarf Version")));
        if (Val == null) {
            return 0;
        }
        return Unsigned.$ulong2uint((long)IrRTTI.cast_ConstantInt(Val.getValue()).getZExtValue());
    }

    public int getCodeViewFlag() {
        ConstantAsMetadata Val = IrRTTI.cast_or_null_ConstantAsMetadata(this.getModuleFlag(new StringRef("CodeView")));
        if (Val == null) {
            return 0;
        }
        return Unsigned.$ulong2uint((long)IrRTTI.cast_ConstantInt(Val.getValue()).getZExtValue());
    }

    public PICLevel.Level getPICLevel() {
        ConstantAsMetadata Val = IrRTTI.cast_or_null_ConstantAsMetadata(this.getModuleFlag(new StringRef("PIC Level")));
        if (Val == null) {
            return PICLevel.Level.NotPIC;
        }
        return PICLevel.Level.valueOf((int)Unsigned.$ulong2uint((long)IrRTTI.cast_ConstantInt(Val.getValue()).getZExtValue()));
    }

    public void setPICLevel(PICLevel.Level PL) {
        this.addModuleFlag(ModFlagBehavior.Error, new StringRef("PIC Level"), PL.getValue());
    }

    public PIELevel.Level getPIELevel() {
        ConstantAsMetadata Val = IrRTTI.cast_or_null_ConstantAsMetadata(this.getModuleFlag(new StringRef("PIE Level")));
        if (Val == null) {
            return PIELevel.Level.Default;
        }
        return PIELevel.Level.valueOf((int)Unsigned.$ulong2uint((long)IrRTTI.cast_ConstantInt(Val.getValue()).getZExtValue()));
    }

    public void setPIELevel(PIELevel.Level PL) {
        this.addModuleFlag(ModFlagBehavior.Error, new StringRef("PIE Level"), PL.getValue());
    }

    public void setProfileSummary(Metadata M) {
        this.addModuleFlag(ModFlagBehavior.Error, new StringRef("ProfileSummary"), M);
    }

    public Metadata getProfileSummary() {
        return this.getModuleFlag(new StringRef("ProfileSummary"));
    }

    @Override
    public Iterator<Function> iterator() {
        return new JavaIterator(this.begin(), this.end());
    }

    public String toString() {
        return "Context=[LLVMContext], GlobalList=" + NativeTrace.getIdentityStr(this.GlobalList) + ", FunctionList=" + NativeTrace.getIdentityStr(this.FunctionList) + ", AliasList=" + NativeTrace.getIdentityStr(this.AliasList) + ", IFuncList=" + NativeTrace.getIdentityStr(this.IFuncList) + ", NamedMDList=" + NativeTrace.getIdentityStr(this.NamedMDList) + ", GlobalScopeAsm=" + this.GlobalScopeAsm + ", ValSymTab=" + NativeTrace.getIdentityStr((Object)this.ValSymTab) + ", ComdatSymTab=" + NativeTrace.getIdentityStr(this.ComdatSymTab) + ", Materializer=" + this.Materializer + ", ModuleID=" + this.ModuleID + ", SourceFileName=" + this.SourceFileName + ", TargetTriple=" + this.TargetTriple + ", NamedMDSymTab=" + NativeTrace.getIdentityStr((Object)this.NamedMDSymTab) + ", DL=" + this.DL;
    }

    public static class debug_compile_units_iterator
    implements type.iterator<debug_compile_units_iterator, DICompileUnit> {
        private NamedMDNode CUs;
        private int Idx;

        private void SkipNoDebugCUs() {
            while (this.CUs != null && Unsigned.$less_uint((int)this.Idx, (int)this.CUs.getNumOperands()) && this.$arrow().getEmissionKind() == DICompileUnit.DebugEmissionKind.NoDebug) {
                ++this.Idx;
            }
        }

        public debug_compile_units_iterator(NamedMDNode CUs, int Idx) {
            this.CUs = CUs;
            this.Idx = Idx;
            this.SkipNoDebugCUs();
        }

        public debug_compile_units_iterator $preInc() {
            ++this.Idx;
            this.SkipNoDebugCUs();
            return this;
        }

        public debug_compile_units_iterator $postInc(int $Prm0) {
            debug_compile_units_iterator T2 = new debug_compile_units_iterator(this);
            ++this.Idx;
            return T2;
        }

        public boolean $eq(debug_compile_units_iterator I) {
            return this.Idx == I.Idx;
        }

        public boolean $noteq(debug_compile_units_iterator I) {
            return this.Idx != I.Idx;
        }

        public DICompileUnit $star() {
            return IrRTTI.cast_DICompileUnit(this.CUs.getOperand(this.Idx));
        }

        public DICompileUnit $arrow() {
            return IrRTTI.cast_DICompileUnit(this.CUs.getOperand(this.Idx));
        }

        public debug_compile_units_iterator(debug_compile_units_iterator $Prm0) {
            this.CUs = $Prm0.CUs;
            this.Idx = $Prm0.Idx;
        }

        public debug_compile_units_iterator(JavaDifferentiators.JD.Move _dparam, debug_compile_units_iterator $Prm0) {
            this.CUs = $Prm0.CUs;
            this.Idx = $Prm0.Idx;
        }

        public debug_compile_units_iterator clone() {
            return new debug_compile_units_iterator(this);
        }

        public String toString() {
            return "CUs=" + this.CUs + ", Idx=" + this.Idx + super.toString();
        }
    }

    public static class global_object_iterator_t
    implements type.iterator<global_object_iterator_t, GlobalObject> {
        private ilist_iterator<Function> function_i;
        private ilist_iterator<Function> function_e;
        private ilist_iterator<GlobalVariable> global_i;
        private boolean IsConst;

        private global_object_iterator_t(Module$IR M) {
            this.function_i = new ilist_iterator(M.begin());
            this.function_e = new ilist_iterator(M.end());
            this.global_i = new ilist_iterator(M.global_begin());
        }

        private global_object_iterator_t(Module$IR M, int $Prm1) {
            this.function_i = new ilist_iterator(M.end());
            this.function_e = new ilist_iterator(M.end());
            this.global_i = new ilist_iterator(M.global_end());
        }

        public global_object_iterator_t $preInc() {
            if (Native.$noteq_iter(this.function_i, this.function_e)) {
                this.function_i.$preInc();
            } else {
                this.global_i.$preInc();
            }
            return this;
        }

        public GlobalObject $star() {
            if (Native.$noteq_iter(this.function_i, this.function_e)) {
                return (GlobalObject)this.function_i.$star();
            }
            return (GlobalObject)this.global_i.$star();
        }

        public boolean $noteq(global_object_iterator_t other) {
            return Native.$bool((boolean)Native.$noteq_iter(this.function_i, other.function_i)) || Native.$bool((boolean)Native.$noteq_iter(this.global_i, other.global_i));
        }

        public global_object_iterator_t(global_object_iterator_t $Prm0) {
            this.IsConst = Native.$tryClone((boolean)$Prm0.IsConst);
            this.function_i = (ilist_iterator)Native.$tryClone($Prm0.function_i);
            this.function_e = (ilist_iterator)Native.$tryClone($Prm0.function_e);
            this.global_i = (ilist_iterator)Native.$tryClone($Prm0.global_i);
        }

        public global_object_iterator_t clone() {
            return new global_object_iterator_t(this);
        }

        public boolean $eq(Object other) {
            return !this.$noteq((global_object_iterator_t)other);
        }

        public String toString() {
            return "function_i=" + this.function_i + ", function_e=" + this.function_e + ", global_i=" + this.global_i;
        }
    }

    public static class ModuleFlagEntry
    implements NativeCloneable<ModuleFlagEntry> {
        public ModFlagBehavior Behavior;
        public MDString Key;
        public Metadata Val;

        public ModuleFlagEntry(ModFlagBehavior B2, MDString K, Metadata V) {
            this.Behavior = B2;
            this.Key = K;
            this.Val = V;
        }

        public ModuleFlagEntry() {
            this.Behavior = ModFlagBehavior.Error;
            this.Key = null;
            this.Val = null;
        }

        public ModuleFlagEntry clone() {
            return new ModuleFlagEntry(this.Behavior, this.Key, this.Val);
        }

        public String toString() {
            return "Behavior=" + (Object)((Object)this.Behavior) + ", Key=" + this.Key + ", Val=" + this.Val;
        }
    }

    public static final class ModFlagBehavior
    extends Enum<ModFlagBehavior>
    implements Native.NativeUIntEnum {
        public static final /* enum */ ModFlagBehavior Error = new ModFlagBehavior(1);
        public static final /* enum */ ModFlagBehavior Warning = new ModFlagBehavior(2);
        public static final /* enum */ ModFlagBehavior Require = new ModFlagBehavior(3);
        public static final /* enum */ ModFlagBehavior Override = new ModFlagBehavior(4);
        public static final /* enum */ ModFlagBehavior Append = new ModFlagBehavior(5);
        public static final /* enum */ ModFlagBehavior AppendUnique = new ModFlagBehavior(6);
        public static final /* enum */ ModFlagBehavior ModFlagBehaviorFirstVal = new ModFlagBehavior(Error.getValue());
        public static final /* enum */ ModFlagBehavior ModFlagBehaviorLastVal = new ModFlagBehavior(AppendUnique.getValue());
        private final int value;
        private static final /* synthetic */ ModFlagBehavior[] $VALUES;

        public static ModFlagBehavior[] values() {
            return (ModFlagBehavior[])$VALUES.clone();
        }

        public static ModFlagBehavior valueOf(String name) {
            return Enum.valueOf(ModFlagBehavior.class, name);
        }

        public static ModFlagBehavior valueOf(int val) {
            ModFlagBehavior out;
            ModFlagBehavior modFlagBehavior = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private ModFlagBehavior(int val) {
            this.value = val;
        }

        public final int getValue() {
            return this.value;
        }

        static {
            $VALUES = new ModFlagBehavior[]{Error, Warning, Require, Override, Append, AppendUnique, ModFlagBehaviorFirstVal, ModFlagBehaviorLastVal};
        }

        private static final class Values {
            private static final ModFlagBehavior[] VALUES;
            private static final ModFlagBehavior[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (ModFlagBehavior kind : ModFlagBehavior.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new ModFlagBehavior[min < 0 ? 1 - min : 0];
                VALUES = new ModFlagBehavior[max >= 0 ? 1 + max : 0];
                for (ModFlagBehavior kind : ModFlagBehavior.values()) {
                    if (kind.value < 0) {
                        if (_VALUES[-kind.value] != null) continue;
                        Values._VALUES[-((ModFlagBehavior)kind).value] = kind;
                        continue;
                    }
                    if (VALUES[kind.value] != null) continue;
                    Values.VALUES[((ModFlagBehavior)kind).value] = kind;
                }
            }
        }
    }
}

