/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import java.util.Iterator;
import org.clank.java.std;
import org.clank.java.std_ptr;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCallback;
import org.clank.support.NativePointer;
import org.clank.support.ThreadLocalThisSupplier;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.clank.support.void;
import org.llvm.adt.APFloat;
import org.llvm.adt.APInt;
import org.llvm.adt.SmallSetVector;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.DenseSet;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.adt.iterator_range;
import org.llvm.adt.java.SmallVectorImplCommon;
import org.llvm.ir.ConstantAsMetadata;
import org.llvm.ir.ConstantFP;
import org.llvm.ir.ConstantInt;
import org.llvm.ir.ConstantRange;
import org.llvm.ir.ContextAndReplaceableUses;
import org.llvm.ir.DIBasicType;
import org.llvm.ir.DICompositeType;
import org.llvm.ir.DIDerivedType;
import org.llvm.ir.DIEnumerator;
import org.llvm.ir.DIExpression;
import org.llvm.ir.DIFile;
import org.llvm.ir.DIGlobalVariable;
import org.llvm.ir.DIImportedEntity;
import org.llvm.ir.DILexicalBlock;
import org.llvm.ir.DILexicalBlockFile;
import org.llvm.ir.DILocalVariable;
import org.llvm.ir.DILocation;
import org.llvm.ir.DIMacro;
import org.llvm.ir.DIMacroFile;
import org.llvm.ir.DIModule;
import org.llvm.ir.DINamespace;
import org.llvm.ir.DIObjCProperty;
import org.llvm.ir.DISubprogram;
import org.llvm.ir.DISubrange;
import org.llvm.ir.DISubroutineType;
import org.llvm.ir.DITemplateTypeParameter;
import org.llvm.ir.DITemplateValueParameter;
import org.llvm.ir.GenericDINode;
import org.llvm.ir.IntegerType;
import org.llvm.ir.LLVMContext;
import org.llvm.ir.MDOperand;
import org.llvm.ir.MDString;
import org.llvm.ir.MDTuple;
import org.llvm.ir.Metadata;
import org.llvm.ir.ReplaceableMetadataImpl;
import org.llvm.ir.Type;
import org.llvm.ir.TypeBasedAliasAnalysisStatics;
import org.llvm.ir.impl.MetadataStatics;
import org.llvm.ir.java.IrRTTI;
import org.llvm.ir.java.MDTuple_or_GenericDINode;
import org.llvm.ir.mdconst.MdconstGlobals;
import org.llvm.support.AdtsupportLlvmGlobals;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;

public class MDNode
extends Metadata
implements Destructors.ClassWithDestructor {
    private int NumOperands;
    private int NumUnresolved;
    ContextAndReplaceableUses Context;
    private static final ThreadLocalThisSupplier<MDNode> MemorySupplier = ThreadLocalThisSupplier.Create(MDNode::assertThisConsumedByCtor, (String)MDNode.class.getName(), (boolean)false);
    private final type.ptr<?> $This = MemorySupplier.consumeAssignedMemory((Object)this);

    protected MDNode(MDNode $Prm0) {
        super($Prm0);
        throw new UnsupportedOperationException("Deleted");
    }

    protected void $assign(MDNode $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    protected static Object $new(int $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    protected static <T extends MDNode> T $new(int UnusedSizeof, int NumOps, NativeCallback.New.ConstructorCallback<T> $Ctor) {
        Object[] data = new Object[1 + NumOps];
        type.ptr Start = NativePointer.create_type$ptr((Object[])data);
        type.ptr Result2 = (type.ptr)Start.$add(NumOps);
        for (int i = 0; i < data.length - 1; ++i) {
            data[i] = new MDOperand();
        }
        return MDNode.callConstructorImpl(Result2, $Ctor);
    }

    protected static void $delete(MDNode Mem) {
        MDNode N = Mem;
        type.ptr<?> O = N.$This$Ptr();
        type.ptr E = (type.ptr)O.$sub(N.NumOperands);
        while (O.$noteq((Object)E)) {
            ((MDOperand)((type.ptr)O.$sub(1)).$arrow()).$destroy();
            O.$preDec();
        }
    }

    protected static void $delete(Object $Prm0, int $Prm1) {
        throw new llvm_unreachable("Constructor throws?");
    }

    protected static void $delete(Object $Prm0, int $Prm1, boolean $Prm2) {
        throw new llvm_unreachable("Constructor throws?");
    }

    protected MDNode(LLVMContext Context, int ID2, Metadata.StorageType Storage, ArrayRef<Metadata> Ops1) {
        this(Context, ID2, Storage, Ops1, (ArrayRef<Metadata>)new ArrayRef(llvm.None, true));
    }

    protected MDNode(LLVMContext Context, int ID2, Metadata.StorageType Storage, ArrayRef<Metadata> Ops1, ArrayRef<Metadata> Ops2) {
        super(ID2, Storage);
        this.NumOperands = Ops1.size() + Ops2.size();
        this.NumUnresolved = 0;
        this.Context = new ContextAndReplaceableUses(Context);
        int Op = 0;
        for (Metadata MD : Ops1) {
            this.setOperand(Op++, MD);
        }
        for (Metadata MD : Ops2) {
            this.setOperand(Op++, MD);
        }
        if (!this.isUniqued()) {
            return;
        }
        this.countUnresolvedOperands();
    }

    @Override
    public void $destroy() {
        this.Context.$destroy();
        super.$destroy();
    }

    public void dropAllReferences() {
        int E = this.NumOperands;
        for (int I = 0; I != E; ++I) {
            this.setOperand(I, null);
        }
        if (this.Context.hasReplaceableUses()) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                this.Context.getReplaceableUses().resolveAllUses(false);
                $c$.track(this.Context.takeReplaceableUses());
                $c$.clean();
            }
            finally {
                $c$.$destroy();
            }
        }
    }

    protected type.ptr<MDOperand> mutable_begin() {
        return (type.ptr)this.mutable_end().$sub(this.NumOperands);
    }

    protected type.ptr<MDOperand> mutable_end() {
        return this.$This$Ptr();
    }

    protected iterator_range<MDOperand> mutable_operands() {
        return new iterator_range(this.mutable_begin(), this.mutable_end());
    }

    public static MDTuple get(LLVMContext Context, ArrayRef<Metadata> MDs) {
        return MDTuple.get(Context, (ArrayRef<Metadata>)new ArrayRef(MDs));
    }

    public static MDTuple getIfExists(LLVMContext Context, ArrayRef<Metadata> MDs) {
        return MDTuple.getIfExists(Context, (ArrayRef<Metadata>)new ArrayRef(MDs));
    }

    public static MDTuple getDistinct(LLVMContext Context, ArrayRef<Metadata> MDs) {
        return MDTuple.getDistinct(Context, (ArrayRef<Metadata>)new ArrayRef(MDs));
    }

    public static std_ptr.unique_ptr_with_deleter<MDTuple> getTemporary(LLVMContext Context, ArrayRef<Metadata> MDs) {
        return MDTuple.getTemporary(Context, (ArrayRef<Metadata>)new ArrayRef(MDs));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public std_ptr.unique_ptr_with_deleter<? extends MDNode> clone() {
        switch (Metadata.MetadataKind.valueOf(this.getMetadataID())) {
            default: {
                throw new llvm_unreachable("Invalid MDNode subclass");
            }
            case MDTupleKind: {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    std_ptr.unique_ptr_with_deleter unique_ptr_with_deleter2 = (std_ptr.unique_ptr_with_deleter)$c$.clean((Object)new std_ptr.unique_ptr_with_deleter(JavaDifferentiators.JD$Unique_ptr$_Up$_Ep.INSTANCE, (Object)$c$.track(IrRTTI.cast_MDTuple(this).cloneImpl())));
                    return unique_ptr_with_deleter2;
                }
                finally {
                    $c$.$destroy();
                }
            }
            case DILocationKind: {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    std_ptr.unique_ptr_with_deleter unique_ptr_with_deleter3 = (std_ptr.unique_ptr_with_deleter)$c$.clean((Object)new std_ptr.unique_ptr_with_deleter(JavaDifferentiators.JD$Unique_ptr$_Up$_Ep.INSTANCE, (Object)$c$.track(IrRTTI.cast_DILocation(this).cloneImpl())));
                    return unique_ptr_with_deleter3;
                }
                finally {
                    $c$.$destroy();
                }
            }
            case DIExpressionKind: {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    std_ptr.unique_ptr_with_deleter unique_ptr_with_deleter4 = (std_ptr.unique_ptr_with_deleter)$c$.clean((Object)new std_ptr.unique_ptr_with_deleter(JavaDifferentiators.JD$Unique_ptr$_Up$_Ep.INSTANCE, (Object)$c$.track(IrRTTI.cast_DIExpression(this).cloneImpl())));
                    return unique_ptr_with_deleter4;
                }
                finally {
                    $c$.$destroy();
                }
            }
            case GenericDINodeKind: {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    std_ptr.unique_ptr_with_deleter unique_ptr_with_deleter5 = (std_ptr.unique_ptr_with_deleter)$c$.clean((Object)new std_ptr.unique_ptr_with_deleter(JavaDifferentiators.JD$Unique_ptr$_Up$_Ep.INSTANCE, (Object)$c$.track(IrRTTI.cast_GenericDINode(this).cloneImpl())));
                    return unique_ptr_with_deleter5;
                }
                finally {
                    $c$.$destroy();
                }
            }
            case DISubrangeKind: {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    std_ptr.unique_ptr_with_deleter unique_ptr_with_deleter6 = (std_ptr.unique_ptr_with_deleter)$c$.clean((Object)new std_ptr.unique_ptr_with_deleter(JavaDifferentiators.JD$Unique_ptr$_Up$_Ep.INSTANCE, (Object)$c$.track(IrRTTI.cast_DISubrange(this).cloneImpl())));
                    return unique_ptr_with_deleter6;
                }
                finally {
                    $c$.$destroy();
                }
            }
            case DIEnumeratorKind: {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    std_ptr.unique_ptr_with_deleter unique_ptr_with_deleter7 = (std_ptr.unique_ptr_with_deleter)$c$.clean((Object)new std_ptr.unique_ptr_with_deleter(JavaDifferentiators.JD$Unique_ptr$_Up$_Ep.INSTANCE, (Object)$c$.track(IrRTTI.cast_DIEnumerator(this).cloneImpl())));
                    return unique_ptr_with_deleter7;
                }
                finally {
                    $c$.$destroy();
                }
            }
            case DIBasicTypeKind: {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    std_ptr.unique_ptr_with_deleter unique_ptr_with_deleter8 = (std_ptr.unique_ptr_with_deleter)$c$.clean((Object)new std_ptr.unique_ptr_with_deleter(JavaDifferentiators.JD$Unique_ptr$_Up$_Ep.INSTANCE, (Object)$c$.track(IrRTTI.cast_DIBasicType(this).cloneImpl())));
                    return unique_ptr_with_deleter8;
                }
                finally {
                    $c$.$destroy();
                }
            }
            case DIDerivedTypeKind: {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    std_ptr.unique_ptr_with_deleter unique_ptr_with_deleter9 = (std_ptr.unique_ptr_with_deleter)$c$.clean((Object)new std_ptr.unique_ptr_with_deleter(JavaDifferentiators.JD$Unique_ptr$_Up$_Ep.INSTANCE, (Object)$c$.track(IrRTTI.cast_DIDerivedType(this).cloneImpl())));
                    return unique_ptr_with_deleter9;
                }
                finally {
                    $c$.$destroy();
                }
            }
            case DICompositeTypeKind: {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    std_ptr.unique_ptr_with_deleter unique_ptr_with_deleter10 = (std_ptr.unique_ptr_with_deleter)$c$.clean((Object)new std_ptr.unique_ptr_with_deleter(JavaDifferentiators.JD$Unique_ptr$_Up$_Ep.INSTANCE, (Object)$c$.track(IrRTTI.cast_DICompositeType(this).cloneImpl())));
                    return unique_ptr_with_deleter10;
                }
                finally {
                    $c$.$destroy();
                }
            }
            case DISubroutineTypeKind: {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    std_ptr.unique_ptr_with_deleter unique_ptr_with_deleter11 = (std_ptr.unique_ptr_with_deleter)$c$.clean((Object)new std_ptr.unique_ptr_with_deleter(JavaDifferentiators.JD$Unique_ptr$_Up$_Ep.INSTANCE, (Object)$c$.track(IrRTTI.cast_DISubroutineType(this).cloneImpl())));
                    return unique_ptr_with_deleter11;
                }
                finally {
                    $c$.$destroy();
                }
            }
            case DIFileKind: {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    std_ptr.unique_ptr_with_deleter unique_ptr_with_deleter12 = (std_ptr.unique_ptr_with_deleter)$c$.clean((Object)new std_ptr.unique_ptr_with_deleter(JavaDifferentiators.JD$Unique_ptr$_Up$_Ep.INSTANCE, (Object)$c$.track(IrRTTI.cast_DIFile(this).cloneImpl())));
                    return unique_ptr_with_deleter12;
                }
                finally {
                    $c$.$destroy();
                }
            }
            case DICompileUnitKind: {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    std_ptr.unique_ptr_with_deleter unique_ptr_with_deleter13 = (std_ptr.unique_ptr_with_deleter)$c$.clean((Object)new std_ptr.unique_ptr_with_deleter(JavaDifferentiators.JD$Unique_ptr$_Up$_Ep.INSTANCE, (Object)$c$.track(IrRTTI.cast_DICompileUnit(this).cloneImpl())));
                    return unique_ptr_with_deleter13;
                }
                finally {
                    $c$.$destroy();
                }
            }
            case DISubprogramKind: {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    std_ptr.unique_ptr_with_deleter unique_ptr_with_deleter14 = (std_ptr.unique_ptr_with_deleter)$c$.clean((Object)new std_ptr.unique_ptr_with_deleter(JavaDifferentiators.JD$Unique_ptr$_Up$_Ep.INSTANCE, (Object)$c$.track(IrRTTI.cast_DISubprogram(this).cloneImpl())));
                    return unique_ptr_with_deleter14;
                }
                finally {
                    $c$.$destroy();
                }
            }
            case DILexicalBlockKind: {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    std_ptr.unique_ptr_with_deleter unique_ptr_with_deleter15 = (std_ptr.unique_ptr_with_deleter)$c$.clean((Object)new std_ptr.unique_ptr_with_deleter(JavaDifferentiators.JD$Unique_ptr$_Up$_Ep.INSTANCE, (Object)$c$.track(IrRTTI.cast_DILexicalBlock(this).cloneImpl())));
                    return unique_ptr_with_deleter15;
                }
                finally {
                    $c$.$destroy();
                }
            }
            case DILexicalBlockFileKind: {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    std_ptr.unique_ptr_with_deleter unique_ptr_with_deleter16 = (std_ptr.unique_ptr_with_deleter)$c$.clean((Object)new std_ptr.unique_ptr_with_deleter(JavaDifferentiators.JD$Unique_ptr$_Up$_Ep.INSTANCE, (Object)$c$.track(IrRTTI.cast_DILexicalBlockFile(this).cloneImpl())));
                    return unique_ptr_with_deleter16;
                }
                finally {
                    $c$.$destroy();
                }
            }
            case DINamespaceKind: {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    std_ptr.unique_ptr_with_deleter unique_ptr_with_deleter17 = (std_ptr.unique_ptr_with_deleter)$c$.clean((Object)new std_ptr.unique_ptr_with_deleter(JavaDifferentiators.JD$Unique_ptr$_Up$_Ep.INSTANCE, (Object)$c$.track(IrRTTI.cast_DINamespace(this).cloneImpl())));
                    return unique_ptr_with_deleter17;
                }
                finally {
                    $c$.$destroy();
                }
            }
            case DIModuleKind: {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    std_ptr.unique_ptr_with_deleter unique_ptr_with_deleter18 = (std_ptr.unique_ptr_with_deleter)$c$.clean((Object)new std_ptr.unique_ptr_with_deleter(JavaDifferentiators.JD$Unique_ptr$_Up$_Ep.INSTANCE, (Object)$c$.track(IrRTTI.cast_DIModule(this).cloneImpl())));
                    return unique_ptr_with_deleter18;
                }
                finally {
                    $c$.$destroy();
                }
            }
            case DITemplateTypeParameterKind: {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    std_ptr.unique_ptr_with_deleter unique_ptr_with_deleter19 = (std_ptr.unique_ptr_with_deleter)$c$.clean((Object)new std_ptr.unique_ptr_with_deleter(JavaDifferentiators.JD$Unique_ptr$_Up$_Ep.INSTANCE, (Object)$c$.track(IrRTTI.cast_DITemplateTypeParameter(this).cloneImpl())));
                    return unique_ptr_with_deleter19;
                }
                finally {
                    $c$.$destroy();
                }
            }
            case DITemplateValueParameterKind: {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    std_ptr.unique_ptr_with_deleter unique_ptr_with_deleter20 = (std_ptr.unique_ptr_with_deleter)$c$.clean((Object)new std_ptr.unique_ptr_with_deleter(JavaDifferentiators.JD$Unique_ptr$_Up$_Ep.INSTANCE, (Object)$c$.track(IrRTTI.cast_DITemplateValueParameter(this).cloneImpl())));
                    return unique_ptr_with_deleter20;
                }
                finally {
                    $c$.$destroy();
                }
            }
            case DIGlobalVariableKind: {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    std_ptr.unique_ptr_with_deleter unique_ptr_with_deleter21 = (std_ptr.unique_ptr_with_deleter)$c$.clean((Object)new std_ptr.unique_ptr_with_deleter(JavaDifferentiators.JD$Unique_ptr$_Up$_Ep.INSTANCE, (Object)$c$.track(IrRTTI.cast_DIGlobalVariable(this).cloneImpl())));
                    return unique_ptr_with_deleter21;
                }
                finally {
                    $c$.$destroy();
                }
            }
            case DILocalVariableKind: {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    std_ptr.unique_ptr_with_deleter unique_ptr_with_deleter22 = (std_ptr.unique_ptr_with_deleter)$c$.clean((Object)new std_ptr.unique_ptr_with_deleter(JavaDifferentiators.JD$Unique_ptr$_Up$_Ep.INSTANCE, (Object)$c$.track(IrRTTI.cast_DILocalVariable(this).cloneImpl())));
                    return unique_ptr_with_deleter22;
                }
                finally {
                    $c$.$destroy();
                }
            }
            case DIObjCPropertyKind: {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    std_ptr.unique_ptr_with_deleter unique_ptr_with_deleter23 = (std_ptr.unique_ptr_with_deleter)$c$.clean((Object)new std_ptr.unique_ptr_with_deleter(JavaDifferentiators.JD$Unique_ptr$_Up$_Ep.INSTANCE, (Object)$c$.track(IrRTTI.cast_DIObjCProperty(this).cloneImpl())));
                    return unique_ptr_with_deleter23;
                }
                finally {
                    $c$.$destroy();
                }
            }
            case DIImportedEntityKind: {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    std_ptr.unique_ptr_with_deleter unique_ptr_with_deleter24 = (std_ptr.unique_ptr_with_deleter)$c$.clean((Object)new std_ptr.unique_ptr_with_deleter(JavaDifferentiators.JD$Unique_ptr$_Up$_Ep.INSTANCE, (Object)$c$.track(IrRTTI.cast_DIImportedEntity(this).cloneImpl())));
                    return unique_ptr_with_deleter24;
                }
                finally {
                    $c$.$destroy();
                }
            }
            case DIMacroKind: {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    std_ptr.unique_ptr_with_deleter unique_ptr_with_deleter25 = (std_ptr.unique_ptr_with_deleter)$c$.clean((Object)new std_ptr.unique_ptr_with_deleter(JavaDifferentiators.JD$Unique_ptr$_Up$_Ep.INSTANCE, (Object)$c$.track(IrRTTI.cast_DIMacro(this).cloneImpl())));
                    return unique_ptr_with_deleter25;
                }
                finally {
                    $c$.$destroy();
                }
            }
            case DIMacroFileKind: 
        }
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            std_ptr.unique_ptr_with_deleter unique_ptr_with_deleter26 = (std_ptr.unique_ptr_with_deleter)$c$.clean((Object)new std_ptr.unique_ptr_with_deleter(JavaDifferentiators.JD$Unique_ptr$_Up$_Ep.INSTANCE, (Object)$c$.track(IrRTTI.cast_DIMacroFile(this).cloneImpl())));
            return unique_ptr_with_deleter26;
        }
        finally {
            $c$.$destroy();
        }
    }

    public static void deleteTemporary(MDNode N) {
        assert (N.isTemporary()) : "Expected temporary node";
        N.replaceAllUsesWith(null);
        N.deleteAsSubclass();
    }

    public LLVMContext getContext() {
        return this.Context.getContext();
    }

    public void replaceOperandWith(int I, Metadata New2) {
        if (this.getOperand(I).$Metadata$P() == New2) {
            return;
        }
        if (!this.isUniqued()) {
            this.setOperand(I, New2);
            return;
        }
        this.handleChangedOperand((type.ptr)this.mutable_begin().$add(I), New2);
    }

    public boolean isResolved() {
        return !this.isTemporary() && this.NumUnresolved == 0;
    }

    public boolean isUniqued() {
        return Unsigned.$uchar2int((byte)this.Storage) == Metadata.StorageType.Uniqued.getValue();
    }

    public boolean isDistinct() {
        return Unsigned.$uchar2int((byte)this.Storage) == Metadata.StorageType.Distinct.getValue();
    }

    public boolean isTemporary() {
        return Unsigned.$uchar2int((byte)this.Storage) == Metadata.StorageType.Temporary.getValue();
    }

    public void replaceAllUsesWith(Metadata MD) {
        assert (this.isTemporary()) : "Expected temporary node";
        if (this.Context.hasReplaceableUses()) {
            this.Context.getReplaceableUses().replaceAllUsesWith(MD);
        }
    }

    public void resolveCycles() {
        if (this.isResolved()) {
            return;
        }
        this.resolve();
        for (MDOperand Op : this.operands()) {
            MDNode N = IrRTTI.dyn_cast_or_null_MDNode(Op);
            if (N == null) continue;
            assert (!N.isTemporary()) : "Expected all forward declarations to be resolved";
            if (N.isResolved()) continue;
            N.resolveCycles();
        }
    }

    public static <T extends MDNode> T replaceWithPermanent$BaseOfMDNode(std_ptr.unique_ptr_with_deleter<T> N) {
        ((MDNode)N.release()).replaceWithPermanentImpl();
        return (T)((MDNode)N.release()).replaceWithPermanentImpl();
    }

    public static <T extends MDNode> T replaceWithUniqued$BaseOfMDNode(std_ptr.unique_ptr_with_deleter<T> N) {
        return (T)((MDNode)N.release()).replaceWithUniquedImpl();
    }

    public static <T extends MDNode> T replaceWithDistinct$BaseOfMDNode(std_ptr.unique_ptr_with_deleter<T> N) {
        return (T)((MDNode)N.release()).replaceWithDistinctImpl();
    }

    MDNode replaceWithPermanentImpl() {
        switch (Metadata.MetadataKind.valueOf(this.getMetadataID())) {
            default: {
                return this.replaceWithDistinctImpl();
            }
            case MDTupleKind: {
                break;
            }
            case DILocationKind: {
                break;
            }
            case DIExpressionKind: {
                break;
            }
            case GenericDINodeKind: {
                break;
            }
            case DISubrangeKind: {
                break;
            }
            case DIEnumeratorKind: {
                break;
            }
            case DIBasicTypeKind: {
                break;
            }
            case DIDerivedTypeKind: {
                break;
            }
            case DICompositeTypeKind: {
                break;
            }
            case DISubroutineTypeKind: {
                break;
            }
            case DIFileKind: {
                break;
            }
            case DISubprogramKind: {
                break;
            }
            case DILexicalBlockKind: {
                break;
            }
            case DILexicalBlockFileKind: {
                break;
            }
            case DINamespaceKind: {
                break;
            }
            case DIModuleKind: {
                break;
            }
            case DITemplateTypeParameterKind: {
                break;
            }
            case DITemplateValueParameterKind: {
                break;
            }
            case DIGlobalVariableKind: {
                break;
            }
            case DILocalVariableKind: {
                break;
            }
            case DIObjCPropertyKind: {
                break;
            }
            case DIImportedEntityKind: {
                break;
            }
            case DIMacroKind: {
            }
            case DIMacroFileKind: 
        }
        if (MetadataStatics.hasSelfReference(this)) {
            return this.replaceWithDistinctImpl();
        }
        return this.replaceWithUniquedImpl();
    }

    MDNode replaceWithUniquedImpl() {
        MDNode UniquedNode = this.uniquify();
        if (UniquedNode == this) {
            this.makeUniqued();
            return this;
        }
        this.replaceAllUsesWith(UniquedNode);
        this.deleteAsSubclass();
        return UniquedNode;
    }

    MDNode replaceWithDistinctImpl() {
        this.makeDistinct();
        return this;
    }

    protected void setOperand(int I, Metadata New2) {
        assert (Unsigned.$less_uint((int)I, (int)this.NumOperands));
        ((MDOperand)this.mutable_begin().$at(I)).reset(New2, this.isUniqued() ? this : (MDNode)null);
    }

    protected void storeDistinctInContext() {
        assert (!this.Context.hasReplaceableUses()) : "Unexpected replaceable uses";
        assert (this.NumUnresolved == 0) : "Unexpected unresolved nodes";
        this.Storage = (byte)Metadata.StorageType.Distinct.getValue();
        assert (this.isResolved()) : "Expected this to be resolved";
        switch (Metadata.MetadataKind.valueOf(this.getMetadataID())) {
            default: {
                throw new llvm_unreachable("Invalid subclass of MDNode");
            }
            case MDTupleKind: {
                std.integral_constant_bool ShouldResetHash = new std.integral_constant_bool(false);
                MDNode.dispatchResetHash_T$P_integral_constant_bool_true(IrRTTI.cast_MDTuple(this), new std.integral_constant_bool_true());
                break;
            }
            case DILocationKind: {
                std.integral_constant_bool ShouldResetHash = new std.integral_constant_bool(false);
                MDNode.dispatchResetHash_T$P_integral_constant_bool_false(IrRTTI.cast_DILocation(this), new std.integral_constant_bool_false());
                break;
            }
            case DIExpressionKind: {
                std.integral_constant_bool ShouldResetHash = new std.integral_constant_bool(false);
                MDNode.dispatchResetHash_T$P_integral_constant_bool_false(IrRTTI.cast_DIExpression(this), new std.integral_constant_bool_false());
                break;
            }
            case GenericDINodeKind: {
                std.integral_constant_bool ShouldResetHash = new std.integral_constant_bool(false);
                MDNode.dispatchResetHash_T$P_integral_constant_bool_true(IrRTTI.cast_GenericDINode(this), new std.integral_constant_bool_true());
                break;
            }
            case DISubrangeKind: {
                std.integral_constant_bool ShouldResetHash = new std.integral_constant_bool(false);
                MDNode.dispatchResetHash_T$P_integral_constant_bool_false(IrRTTI.cast_DISubrange(this), new std.integral_constant_bool_false());
                break;
            }
            case DIEnumeratorKind: {
                std.integral_constant_bool ShouldResetHash = new std.integral_constant_bool(false);
                MDNode.dispatchResetHash_T$P_integral_constant_bool_false(IrRTTI.cast_DIEnumerator(this), new std.integral_constant_bool_false());
                break;
            }
            case DIBasicTypeKind: {
                std.integral_constant_bool ShouldResetHash = new std.integral_constant_bool(false);
                MDNode.dispatchResetHash_T$P_integral_constant_bool_false(IrRTTI.cast_DIBasicType(this), new std.integral_constant_bool_false());
                break;
            }
            case DIDerivedTypeKind: {
                std.integral_constant_bool ShouldResetHash = new std.integral_constant_bool(false);
                MDNode.dispatchResetHash_T$P_integral_constant_bool_false(IrRTTI.cast_DIDerivedType(this), new std.integral_constant_bool_false());
                break;
            }
            case DICompositeTypeKind: {
                std.integral_constant_bool ShouldResetHash = new std.integral_constant_bool(false);
                MDNode.dispatchResetHash_T$P_integral_constant_bool_false(IrRTTI.cast_DICompositeType(this), new std.integral_constant_bool_false());
                break;
            }
            case DISubroutineTypeKind: {
                std.integral_constant_bool ShouldResetHash = new std.integral_constant_bool(false);
                MDNode.dispatchResetHash_T$P_integral_constant_bool_false(IrRTTI.cast_DISubroutineType(this), new std.integral_constant_bool_false());
                break;
            }
            case DIFileKind: {
                std.integral_constant_bool ShouldResetHash = new std.integral_constant_bool(false);
                MDNode.dispatchResetHash_T$P_integral_constant_bool_false(IrRTTI.cast_DIFile(this), new std.integral_constant_bool_false());
                break;
            }
            case DICompileUnitKind: {
                std.integral_constant_bool ShouldResetHash = new std.integral_constant_bool(false);
                MDNode.dispatchResetHash_T$P_integral_constant_bool_false(IrRTTI.cast_DICompileUnit(this), new std.integral_constant_bool_false());
                break;
            }
            case DISubprogramKind: {
                std.integral_constant_bool ShouldResetHash = new std.integral_constant_bool(false);
                MDNode.dispatchResetHash_T$P_integral_constant_bool_false(IrRTTI.cast_DISubprogram(this), new std.integral_constant_bool_false());
                break;
            }
            case DILexicalBlockKind: {
                std.integral_constant_bool ShouldResetHash = new std.integral_constant_bool(false);
                MDNode.dispatchResetHash_T$P_integral_constant_bool_false(IrRTTI.cast_DILexicalBlock(this), new std.integral_constant_bool_false());
                break;
            }
            case DILexicalBlockFileKind: {
                std.integral_constant_bool ShouldResetHash = new std.integral_constant_bool(false);
                MDNode.dispatchResetHash_T$P_integral_constant_bool_false(IrRTTI.cast_DILexicalBlockFile(this), new std.integral_constant_bool_false());
                break;
            }
            case DINamespaceKind: {
                std.integral_constant_bool ShouldResetHash = new std.integral_constant_bool(false);
                MDNode.dispatchResetHash_T$P_integral_constant_bool_false(IrRTTI.cast_DINamespace(this), new std.integral_constant_bool_false());
                break;
            }
            case DIModuleKind: {
                std.integral_constant_bool ShouldResetHash = new std.integral_constant_bool(false);
                MDNode.dispatchResetHash_T$P_integral_constant_bool_false(IrRTTI.cast_DIModule(this), new std.integral_constant_bool_false());
                break;
            }
            case DITemplateTypeParameterKind: {
                std.integral_constant_bool ShouldResetHash = new std.integral_constant_bool(false);
                MDNode.dispatchResetHash_T$P_integral_constant_bool_false(IrRTTI.cast_DITemplateTypeParameter(this), new std.integral_constant_bool_false());
                break;
            }
            case DITemplateValueParameterKind: {
                std.integral_constant_bool ShouldResetHash = new std.integral_constant_bool(false);
                MDNode.dispatchResetHash_T$P_integral_constant_bool_false(IrRTTI.cast_DITemplateValueParameter(this), new std.integral_constant_bool_false());
                break;
            }
            case DIGlobalVariableKind: {
                std.integral_constant_bool ShouldResetHash = new std.integral_constant_bool(false);
                MDNode.dispatchResetHash_T$P_integral_constant_bool_false(IrRTTI.cast_DIGlobalVariable(this), new std.integral_constant_bool_false());
                break;
            }
            case DILocalVariableKind: {
                std.integral_constant_bool ShouldResetHash = new std.integral_constant_bool(false);
                MDNode.dispatchResetHash_T$P_integral_constant_bool_false(IrRTTI.cast_DILocalVariable(this), new std.integral_constant_bool_false());
                break;
            }
            case DIObjCPropertyKind: {
                std.integral_constant_bool ShouldResetHash = new std.integral_constant_bool(false);
                MDNode.dispatchResetHash_T$P_integral_constant_bool_false(IrRTTI.cast_DIObjCProperty(this), new std.integral_constant_bool_false());
                break;
            }
            case DIImportedEntityKind: {
                std.integral_constant_bool ShouldResetHash = new std.integral_constant_bool(false);
                MDNode.dispatchResetHash_T$P_integral_constant_bool_false(IrRTTI.cast_DIImportedEntity(this), new std.integral_constant_bool_false());
                break;
            }
            case DIMacroKind: {
                std.integral_constant_bool ShouldResetHash = new std.integral_constant_bool(false);
                MDNode.dispatchResetHash_T$P_integral_constant_bool_false(IrRTTI.cast_DIMacro(this), new std.integral_constant_bool_false());
                break;
            }
            case DIMacroFileKind: {
                std.integral_constant_bool ShouldResetHash = new std.integral_constant_bool(false);
                MDNode.dispatchResetHash_T$P_integral_constant_bool_false(IrRTTI.cast_DIMacroFile(this), new std.integral_constant_bool_false());
                break;
            }
        }
        this.getContext().pImpl.DistinctMDNodes.push_back_T$RR((Object)this);
    }

    protected static <T extends MDNode, StoreT extends DenseSet<? super T>> T storeImpl(T N, Metadata.StorageType Storage, StoreT Store) {
        switch (Storage) {
            case Uniqued: {
                Store.insert(N);
                break;
            }
            case Distinct: {
                N.storeDistinctInContext();
                break;
            }
        }
        return N;
    }

    protected static <T extends MDNode> T storeImpl(T N, Metadata.StorageType Storage) {
        switch (Storage) {
            case Uniqued: {
                throw new llvm_unreachable("Cannot unique without a uniquing-store");
            }
            case Distinct: {
                N.storeDistinctInContext();
                break;
            }
        }
        return N;
    }

    protected void handleChangedOperand(type.ptr<?> Ref, Metadata New2) {
        int Op = Ref.$sub(this.op_begin());
        assert (Unsigned.$less_uint((int)Op, (int)this.getNumOperands())) : "Expected valid operand";
        if (!this.isUniqued()) {
            this.setOperand(Op, New2);
            return;
        }
        this.eraseFromStore();
        Metadata Old = this.getOperand(Op).$Metadata$P();
        this.setOperand(Op, New2);
        if (New2 == this || New2 == null && Old != null && IrRTTI.isa_ConstantAsMetadata(Old)) {
            if (!this.isResolved()) {
                this.resolve();
            }
            this.storeDistinctInContext();
            return;
        }
        MDNode Uniqued = this.uniquify();
        if (Uniqued == this) {
            if (!this.isResolved()) {
                this.resolveAfterOperandChange(Old, New2);
            }
            return;
        }
        if (!this.isResolved()) {
            int E = this.getNumOperands();
            for (int O = 0; O != E; ++O) {
                this.setOperand(O, null);
            }
            if (this.Context.hasReplaceableUses()) {
                this.Context.getReplaceableUses().replaceAllUsesWith(Uniqued);
            }
            this.deleteAsSubclass();
            return;
        }
        this.storeDistinctInContext();
    }

    private void resolve() {
        assert (this.isUniqued()) : "Expected this to be uniqued";
        assert (!this.isResolved()) : "Expected this to be unresolved";
        this.NumUnresolved = 0;
        this.dropReplaceableUses();
        assert (this.isResolved()) : "Expected this to be resolved";
    }

    private void dropReplaceableUses() {
        assert (this.NumUnresolved == 0) : "Unexpected unresolved operand";
        if (this.Context.hasReplaceableUses()) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                ((ReplaceableMetadataImpl)$c$.track(this.Context.takeReplaceableUses()).$arrow()).resolveAllUses();
                $c$.clean();
            }
            finally {
                $c$.$destroy();
            }
        }
    }

    private void resolveAfterOperandChange(Metadata Old, Metadata New2) {
        assert (this.isUniqued()) : "Expected this to be uniqued";
        assert (this.NumUnresolved != 0) : "Expected unresolved operands";
        if (!MetadataStatics.isOperandUnresolved(Old)) {
            if (MetadataStatics.isOperandUnresolved(New2)) {
                ++this.NumUnresolved;
            }
        } else if (!MetadataStatics.isOperandUnresolved(New2)) {
            this.decrementUnresolvedOperandCount();
        }
    }

    public void decrementUnresolvedOperandCount() {
        assert (!this.isResolved()) : "Expected this to be unresolved";
        if (this.isTemporary()) {
            return;
        }
        assert (this.isUniqued()) : "Expected this to be uniqued";
        if (--this.NumUnresolved != 0) {
            return;
        }
        this.dropReplaceableUses();
        assert (this.isResolved()) : "Expected this to become resolved";
    }

    private void countUnresolvedOperands() {
        assert (this.NumUnresolved == 0) : "Expected unresolved ops to be uncounted";
        assert (this.isUniqued()) : "Expected this to be uniqued";
        this.NumUnresolved = AdtsupportLlvmGlobals.count_if(this.operands(), Op -> MetadataStatics.isOperandUnresolved(Op.$Metadata$P()));
    }

    private void makeUniqued() {
        assert (this.isTemporary()) : "Expected this to be temporary";
        assert (!this.isResolved()) : "Expected this to be unresolved";
        for (MDOperand Op : this.mutable_operands()) {
            Op.reset(Op.get(), this);
        }
        this.Storage = (byte)Metadata.StorageType.Uniqued.getValue();
        this.countUnresolvedOperands();
        if (this.NumUnresolved == 0) {
            this.dropReplaceableUses();
            assert (this.isResolved()) : "Expected this to be resolved";
        }
        assert (this.isUniqued()) : "Expected this to be uniqued";
    }

    private void makeDistinct() {
        assert (this.isTemporary()) : "Expected this to be temporary";
        assert (!this.isResolved()) : "Expected this to be unresolved";
        this.dropReplaceableUses();
        this.storeDistinctInContext();
        assert (this.isDistinct()) : "Expected this to be distinct";
        assert (this.isResolved()) : "Expected this to be resolved";
    }

    public void deleteAsSubclass() {
        switch (Metadata.MetadataKind.valueOf(this.getMetadataID())) {
            default: {
                throw new llvm_unreachable("Invalid subclass of MDNode");
            }
            case MDTupleKind: {
                Destructors.$destroy((Destructors.ClassWithDestructor)IrRTTI.cast_MDTuple(this));
                break;
            }
            case DILocationKind: {
                Destructors.$destroy((Destructors.ClassWithDestructor)IrRTTI.cast_DILocation(this));
                break;
            }
            case DIExpressionKind: {
                Destructors.$destroy((Destructors.ClassWithDestructor)IrRTTI.cast_DIExpression(this));
                break;
            }
            case GenericDINodeKind: {
                Destructors.$destroy((Destructors.ClassWithDestructor)IrRTTI.cast_GenericDINode(this));
                break;
            }
            case DISubrangeKind: {
                Destructors.$destroy((Destructors.ClassWithDestructor)IrRTTI.cast_DISubrange(this));
                break;
            }
            case DIEnumeratorKind: {
                Destructors.$destroy((Destructors.ClassWithDestructor)IrRTTI.cast_DIEnumerator(this));
                break;
            }
            case DIBasicTypeKind: {
                Destructors.$destroy((Destructors.ClassWithDestructor)IrRTTI.cast_DIBasicType(this));
                break;
            }
            case DIDerivedTypeKind: {
                Destructors.$destroy((Destructors.ClassWithDestructor)IrRTTI.cast_DIDerivedType(this));
                break;
            }
            case DICompositeTypeKind: {
                Destructors.$destroy((Destructors.ClassWithDestructor)IrRTTI.cast_DICompositeType(this));
                break;
            }
            case DISubroutineTypeKind: {
                Destructors.$destroy((Destructors.ClassWithDestructor)IrRTTI.cast_DISubroutineType(this));
                break;
            }
            case DIFileKind: {
                Destructors.$destroy((Destructors.ClassWithDestructor)IrRTTI.cast_DIFile(this));
                break;
            }
            case DICompileUnitKind: {
                Destructors.$destroy((Destructors.ClassWithDestructor)IrRTTI.cast_DICompileUnit(this));
                break;
            }
            case DISubprogramKind: {
                Destructors.$destroy((Destructors.ClassWithDestructor)IrRTTI.cast_DISubprogram(this));
                break;
            }
            case DILexicalBlockKind: {
                Destructors.$destroy((Destructors.ClassWithDestructor)IrRTTI.cast_DILexicalBlock(this));
                break;
            }
            case DILexicalBlockFileKind: {
                Destructors.$destroy((Destructors.ClassWithDestructor)IrRTTI.cast_DILexicalBlockFile(this));
                break;
            }
            case DINamespaceKind: {
                Destructors.$destroy((Destructors.ClassWithDestructor)IrRTTI.cast_DINamespace(this));
                break;
            }
            case DIModuleKind: {
                Destructors.$destroy((Destructors.ClassWithDestructor)IrRTTI.cast_DIModule(this));
                break;
            }
            case DITemplateTypeParameterKind: {
                Destructors.$destroy((Destructors.ClassWithDestructor)IrRTTI.cast_DITemplateTypeParameter(this));
                break;
            }
            case DITemplateValueParameterKind: {
                Destructors.$destroy((Destructors.ClassWithDestructor)IrRTTI.cast_DITemplateValueParameter(this));
                break;
            }
            case DIGlobalVariableKind: {
                Destructors.$destroy((Destructors.ClassWithDestructor)IrRTTI.cast_DIGlobalVariable(this));
                break;
            }
            case DILocalVariableKind: {
                Destructors.$destroy((Destructors.ClassWithDestructor)IrRTTI.cast_DILocalVariable(this));
                break;
            }
            case DIObjCPropertyKind: {
                Destructors.$destroy((Destructors.ClassWithDestructor)IrRTTI.cast_DIObjCProperty(this));
                break;
            }
            case DIImportedEntityKind: {
                Destructors.$destroy((Destructors.ClassWithDestructor)IrRTTI.cast_DIImportedEntity(this));
                break;
            }
            case DIMacroKind: {
                Destructors.$destroy((Destructors.ClassWithDestructor)IrRTTI.cast_DIMacro(this));
                break;
            }
            case DIMacroFileKind: {
                Destructors.$destroy((Destructors.ClassWithDestructor)IrRTTI.cast_DIMacroFile(this));
            }
        }
    }

    private MDNode uniquify() {
        assert (!MetadataStatics.hasSelfReference(this)) : "Cannot uniquify a self-referencing node";
        switch (Metadata.MetadataKind.valueOf(this.getMetadataID())) {
            default: {
                throw new llvm_unreachable("Invalid or non-uniquable subclass of MDNode");
            }
            case MDTupleKind: {
                MDTuple SubclassThis = IrRTTI.cast_MDTuple(this);
                std.integral_constant_bool ShouldRecalculateHash = new std.integral_constant_bool(false);
                MDNode.dispatchRecalculateHash_T$P_integral_constant_bool_true(SubclassThis, new std.integral_constant_bool_true());
                return MetadataStatics.uniquifyImpl(SubclassThis, this.getContext().pImpl.MDTuples);
            }
            case DILocationKind: {
                DILocation SubclassThis = IrRTTI.cast_DILocation(this);
                std.integral_constant_bool ShouldRecalculateHash = new std.integral_constant_bool(false);
                MDNode.dispatchRecalculateHash_T$P_integral_constant_bool_false(SubclassThis, new std.integral_constant_bool_false());
                return MetadataStatics.uniquifyImpl(SubclassThis, this.getContext().pImpl.DILocations);
            }
            case DIExpressionKind: {
                DIExpression SubclassThis = IrRTTI.cast_DIExpression(this);
                std.integral_constant_bool ShouldRecalculateHash = new std.integral_constant_bool(false);
                MDNode.dispatchRecalculateHash_T$P_integral_constant_bool_false(SubclassThis, new std.integral_constant_bool_false());
                return MetadataStatics.uniquifyImpl(SubclassThis, this.getContext().pImpl.DIExpressions);
            }
            case GenericDINodeKind: {
                GenericDINode SubclassThis = IrRTTI.cast_GenericDINode(this);
                std.integral_constant_bool ShouldRecalculateHash = new std.integral_constant_bool(false);
                MDNode.dispatchRecalculateHash_T$P_integral_constant_bool_true(SubclassThis, new std.integral_constant_bool_true());
                return MetadataStatics.uniquifyImpl(SubclassThis, this.getContext().pImpl.GenericDINodes);
            }
            case DISubrangeKind: {
                DISubrange SubclassThis = IrRTTI.cast_DISubrange(this);
                std.integral_constant_bool ShouldRecalculateHash = new std.integral_constant_bool(false);
                MDNode.dispatchRecalculateHash_T$P_integral_constant_bool_false(SubclassThis, new std.integral_constant_bool_false());
                return MetadataStatics.uniquifyImpl(SubclassThis, this.getContext().pImpl.DISubranges);
            }
            case DIEnumeratorKind: {
                DIEnumerator SubclassThis = IrRTTI.cast_DIEnumerator(this);
                std.integral_constant_bool ShouldRecalculateHash = new std.integral_constant_bool(false);
                MDNode.dispatchRecalculateHash_T$P_integral_constant_bool_false(SubclassThis, new std.integral_constant_bool_false());
                return MetadataStatics.uniquifyImpl(SubclassThis, this.getContext().pImpl.DIEnumerators);
            }
            case DIBasicTypeKind: {
                DIBasicType SubclassThis = IrRTTI.cast_DIBasicType(this);
                std.integral_constant_bool ShouldRecalculateHash = new std.integral_constant_bool(false);
                MDNode.dispatchRecalculateHash_T$P_integral_constant_bool_false(SubclassThis, new std.integral_constant_bool_false());
                return MetadataStatics.uniquifyImpl(SubclassThis, this.getContext().pImpl.DIBasicTypes);
            }
            case DIDerivedTypeKind: {
                DIDerivedType SubclassThis = IrRTTI.cast_DIDerivedType(this);
                std.integral_constant_bool ShouldRecalculateHash = new std.integral_constant_bool(false);
                MDNode.dispatchRecalculateHash_T$P_integral_constant_bool_false(SubclassThis, new std.integral_constant_bool_false());
                return MetadataStatics.uniquifyImpl(SubclassThis, this.getContext().pImpl.DIDerivedTypes);
            }
            case DICompositeTypeKind: {
                DICompositeType SubclassThis = IrRTTI.cast_DICompositeType(this);
                std.integral_constant_bool ShouldRecalculateHash = new std.integral_constant_bool(false);
                MDNode.dispatchRecalculateHash_T$P_integral_constant_bool_false(SubclassThis, new std.integral_constant_bool_false());
                return MetadataStatics.uniquifyImpl(SubclassThis, this.getContext().pImpl.DICompositeTypes);
            }
            case DISubroutineTypeKind: {
                DISubroutineType SubclassThis = IrRTTI.cast_DISubroutineType(this);
                std.integral_constant_bool ShouldRecalculateHash = new std.integral_constant_bool(false);
                MDNode.dispatchRecalculateHash_T$P_integral_constant_bool_false(SubclassThis, new std.integral_constant_bool_false());
                return MetadataStatics.uniquifyImpl(SubclassThis, this.getContext().pImpl.DISubroutineTypes);
            }
            case DIFileKind: {
                DIFile SubclassThis = IrRTTI.cast_DIFile(this);
                std.integral_constant_bool ShouldRecalculateHash = new std.integral_constant_bool(false);
                MDNode.dispatchRecalculateHash_T$P_integral_constant_bool_false(SubclassThis, new std.integral_constant_bool_false());
                return MetadataStatics.uniquifyImpl(SubclassThis, this.getContext().pImpl.DIFiles);
            }
            case DISubprogramKind: {
                DISubprogram SubclassThis = IrRTTI.cast_DISubprogram(this);
                std.integral_constant_bool ShouldRecalculateHash = new std.integral_constant_bool(false);
                MDNode.dispatchRecalculateHash_T$P_integral_constant_bool_false(SubclassThis, new std.integral_constant_bool_false());
                return MetadataStatics.uniquifyImpl(SubclassThis, this.getContext().pImpl.DISubprograms);
            }
            case DILexicalBlockKind: {
                DILexicalBlock SubclassThis = IrRTTI.cast_DILexicalBlock(this);
                std.integral_constant_bool ShouldRecalculateHash = new std.integral_constant_bool(false);
                MDNode.dispatchRecalculateHash_T$P_integral_constant_bool_false(SubclassThis, new std.integral_constant_bool_false());
                return MetadataStatics.uniquifyImpl(SubclassThis, this.getContext().pImpl.DILexicalBlocks);
            }
            case DILexicalBlockFileKind: {
                DILexicalBlockFile SubclassThis = IrRTTI.cast_DILexicalBlockFile(this);
                std.integral_constant_bool ShouldRecalculateHash = new std.integral_constant_bool(false);
                MDNode.dispatchRecalculateHash_T$P_integral_constant_bool_false(SubclassThis, new std.integral_constant_bool_false());
                return MetadataStatics.uniquifyImpl(SubclassThis, this.getContext().pImpl.DILexicalBlockFiles);
            }
            case DINamespaceKind: {
                DINamespace SubclassThis = IrRTTI.cast_DINamespace(this);
                std.integral_constant_bool ShouldRecalculateHash = new std.integral_constant_bool(false);
                MDNode.dispatchRecalculateHash_T$P_integral_constant_bool_false(SubclassThis, new std.integral_constant_bool_false());
                return MetadataStatics.uniquifyImpl(SubclassThis, this.getContext().pImpl.DINamespaces);
            }
            case DIModuleKind: {
                DIModule SubclassThis = IrRTTI.cast_DIModule(this);
                std.integral_constant_bool ShouldRecalculateHash = new std.integral_constant_bool(false);
                MDNode.dispatchRecalculateHash_T$P_integral_constant_bool_false(SubclassThis, new std.integral_constant_bool_false());
                return MetadataStatics.uniquifyImpl(SubclassThis, this.getContext().pImpl.DIModules);
            }
            case DITemplateTypeParameterKind: {
                DITemplateTypeParameter SubclassThis = IrRTTI.cast_DITemplateTypeParameter(this);
                std.integral_constant_bool ShouldRecalculateHash = new std.integral_constant_bool(false);
                MDNode.dispatchRecalculateHash_T$P_integral_constant_bool_false(SubclassThis, new std.integral_constant_bool_false());
                return MetadataStatics.uniquifyImpl(SubclassThis, this.getContext().pImpl.DITemplateTypeParameters);
            }
            case DITemplateValueParameterKind: {
                DITemplateValueParameter SubclassThis = IrRTTI.cast_DITemplateValueParameter(this);
                std.integral_constant_bool ShouldRecalculateHash = new std.integral_constant_bool(false);
                MDNode.dispatchRecalculateHash_T$P_integral_constant_bool_false(SubclassThis, new std.integral_constant_bool_false());
                return MetadataStatics.uniquifyImpl(SubclassThis, this.getContext().pImpl.DITemplateValueParameters);
            }
            case DIGlobalVariableKind: {
                DIGlobalVariable SubclassThis = IrRTTI.cast_DIGlobalVariable(this);
                std.integral_constant_bool ShouldRecalculateHash = new std.integral_constant_bool(false);
                MDNode.dispatchRecalculateHash_T$P_integral_constant_bool_false(SubclassThis, new std.integral_constant_bool_false());
                return MetadataStatics.uniquifyImpl(SubclassThis, this.getContext().pImpl.DIGlobalVariables);
            }
            case DILocalVariableKind: {
                DILocalVariable SubclassThis = IrRTTI.cast_DILocalVariable(this);
                std.integral_constant_bool ShouldRecalculateHash = new std.integral_constant_bool(false);
                MDNode.dispatchRecalculateHash_T$P_integral_constant_bool_false(SubclassThis, new std.integral_constant_bool_false());
                return MetadataStatics.uniquifyImpl(SubclassThis, this.getContext().pImpl.DILocalVariables);
            }
            case DIObjCPropertyKind: {
                DIObjCProperty SubclassThis = IrRTTI.cast_DIObjCProperty(this);
                std.integral_constant_bool ShouldRecalculateHash = new std.integral_constant_bool(false);
                MDNode.dispatchRecalculateHash_T$P_integral_constant_bool_false(SubclassThis, new std.integral_constant_bool_false());
                return MetadataStatics.uniquifyImpl(SubclassThis, this.getContext().pImpl.DIObjCPropertys);
            }
            case DIImportedEntityKind: {
                DIImportedEntity SubclassThis = IrRTTI.cast_DIImportedEntity(this);
                std.integral_constant_bool ShouldRecalculateHash = new std.integral_constant_bool(false);
                MDNode.dispatchRecalculateHash_T$P_integral_constant_bool_false(SubclassThis, new std.integral_constant_bool_false());
                return MetadataStatics.uniquifyImpl(SubclassThis, this.getContext().pImpl.DIImportedEntitys);
            }
            case DIMacroKind: {
                DIMacro SubclassThis = IrRTTI.cast_DIMacro(this);
                std.integral_constant_bool ShouldRecalculateHash = new std.integral_constant_bool(false);
                MDNode.dispatchRecalculateHash_T$P_integral_constant_bool_false(SubclassThis, new std.integral_constant_bool_false());
                return MetadataStatics.uniquifyImpl(SubclassThis, this.getContext().pImpl.DIMacros);
            }
            case DIMacroFileKind: 
        }
        DIMacroFile SubclassThis = IrRTTI.cast_DIMacroFile(this);
        std.integral_constant_bool ShouldRecalculateHash = new std.integral_constant_bool(false);
        MDNode.dispatchRecalculateHash_T$P_integral_constant_bool_false(SubclassThis, new std.integral_constant_bool_false());
        return MetadataStatics.uniquifyImpl(SubclassThis, this.getContext().pImpl.DIMacroFiles);
    }

    private void eraseFromStore() {
        switch (Metadata.MetadataKind.valueOf(this.getMetadataID())) {
            default: {
                throw new llvm_unreachable("Invalid or non-uniquable subclass of MDNode");
            }
            case MDTupleKind: {
                this.getContext().pImpl.MDTuples.erase((Object)IrRTTI.cast_MDTuple(this));
                break;
            }
            case DILocationKind: {
                this.getContext().pImpl.DILocations.erase((Object)IrRTTI.cast_DILocation(this));
                break;
            }
            case DIExpressionKind: {
                this.getContext().pImpl.DIExpressions.erase((Object)IrRTTI.cast_DIExpression(this));
                break;
            }
            case GenericDINodeKind: {
                this.getContext().pImpl.GenericDINodes.erase((Object)IrRTTI.cast_GenericDINode(this));
                break;
            }
            case DISubrangeKind: {
                this.getContext().pImpl.DISubranges.erase((Object)IrRTTI.cast_DISubrange(this));
                break;
            }
            case DIEnumeratorKind: {
                this.getContext().pImpl.DIEnumerators.erase((Object)IrRTTI.cast_DIEnumerator(this));
                break;
            }
            case DIBasicTypeKind: {
                this.getContext().pImpl.DIBasicTypes.erase((Object)IrRTTI.cast_DIBasicType(this));
                break;
            }
            case DIDerivedTypeKind: {
                this.getContext().pImpl.DIDerivedTypes.erase((Object)IrRTTI.cast_DIDerivedType(this));
                break;
            }
            case DICompositeTypeKind: {
                this.getContext().pImpl.DICompositeTypes.erase((Object)IrRTTI.cast_DICompositeType(this));
                break;
            }
            case DISubroutineTypeKind: {
                this.getContext().pImpl.DISubroutineTypes.erase((Object)IrRTTI.cast_DISubroutineType(this));
                break;
            }
            case DIFileKind: {
                this.getContext().pImpl.DIFiles.erase((Object)IrRTTI.cast_DIFile(this));
                break;
            }
            case DISubprogramKind: {
                this.getContext().pImpl.DISubprograms.erase((Object)IrRTTI.cast_DISubprogram(this));
                break;
            }
            case DILexicalBlockKind: {
                this.getContext().pImpl.DILexicalBlocks.erase((Object)IrRTTI.cast_DILexicalBlock(this));
                break;
            }
            case DILexicalBlockFileKind: {
                this.getContext().pImpl.DILexicalBlockFiles.erase((Object)IrRTTI.cast_DILexicalBlockFile(this));
                break;
            }
            case DINamespaceKind: {
                this.getContext().pImpl.DINamespaces.erase((Object)IrRTTI.cast_DINamespace(this));
                break;
            }
            case DIModuleKind: {
                this.getContext().pImpl.DIModules.erase((Object)IrRTTI.cast_DIModule(this));
                break;
            }
            case DITemplateTypeParameterKind: {
                this.getContext().pImpl.DITemplateTypeParameters.erase((Object)IrRTTI.cast_DITemplateTypeParameter(this));
                break;
            }
            case DITemplateValueParameterKind: {
                this.getContext().pImpl.DITemplateValueParameters.erase((Object)IrRTTI.cast_DITemplateValueParameter(this));
                break;
            }
            case DIGlobalVariableKind: {
                this.getContext().pImpl.DIGlobalVariables.erase((Object)IrRTTI.cast_DIGlobalVariable(this));
                break;
            }
            case DILocalVariableKind: {
                this.getContext().pImpl.DILocalVariables.erase((Object)IrRTTI.cast_DILocalVariable(this));
                break;
            }
            case DIObjCPropertyKind: {
                this.getContext().pImpl.DIObjCPropertys.erase((Object)IrRTTI.cast_DIObjCProperty(this));
                break;
            }
            case DIImportedEntityKind: {
                this.getContext().pImpl.DIImportedEntitys.erase((Object)IrRTTI.cast_DIImportedEntity(this));
                break;
            }
            case DIMacroKind: {
                this.getContext().pImpl.DIMacros.erase((Object)IrRTTI.cast_DIMacro(this));
                break;
            }
            case DIMacroFileKind: {
                this.getContext().pImpl.DIMacroFiles.erase((Object)IrRTTI.cast_DIMacroFile(this));
            }
        }
    }

    private static <NodeTy extends MDTuple_or_GenericDINode> void dispatchRecalculateHash_T$P_integral_constant_bool_true(NodeTy N, std.integral_constant_bool_true $Prm1) {
        N.recalculateHash();
    }

    private static <NodeTy> void dispatchRecalculateHash_T$P_integral_constant_bool_false(NodeTy $Prm0, std.integral_constant_bool_false $Prm1) {
    }

    private static <NodeTy extends MDTuple_or_GenericDINode> void dispatchResetHash_T$P_integral_constant_bool_true(NodeTy N, std.integral_constant_bool_true $Prm1) {
        N.setHash(0);
    }

    private static <NodeTy> void dispatchResetHash_T$P_integral_constant_bool_false(NodeTy $Prm0, std.integral_constant_bool_false $Prm1) {
    }

    public type.ptr<MDOperand> op_begin() {
        return this.mutable_begin();
    }

    public type.ptr<MDOperand> op_end() {
        return this.mutable_end();
    }

    public iterator_range<MDOperand> operands() {
        return new iterator_range(this.op_begin(), this.op_end());
    }

    public MDOperand getOperand(int I) {
        assert (Unsigned.$less_uint((int)I, (int)this.NumOperands)) : "Out of range";
        return (MDOperand)this.op_begin().$at(I);
    }

    public int getNumOperands() {
        return this.NumOperands;
    }

    public static boolean classof(Metadata MD) {
        switch (Metadata.MetadataKind.valueOf(MD.getMetadataID())) {
            default: {
                return false;
            }
            case MDTupleKind: {
                return true;
            }
            case DILocationKind: {
                return true;
            }
            case DIExpressionKind: {
                return true;
            }
            case GenericDINodeKind: {
                return true;
            }
            case DISubrangeKind: {
                return true;
            }
            case DIEnumeratorKind: {
                return true;
            }
            case DIBasicTypeKind: {
                return true;
            }
            case DIDerivedTypeKind: {
                return true;
            }
            case DICompositeTypeKind: {
                return true;
            }
            case DISubroutineTypeKind: {
                return true;
            }
            case DIFileKind: {
                return true;
            }
            case DICompileUnitKind: {
                return true;
            }
            case DISubprogramKind: {
                return true;
            }
            case DILexicalBlockKind: {
                return true;
            }
            case DILexicalBlockFileKind: {
                return true;
            }
            case DINamespaceKind: {
                return true;
            }
            case DIModuleKind: {
                return true;
            }
            case DITemplateTypeParameterKind: {
                return true;
            }
            case DITemplateValueParameterKind: {
                return true;
            }
            case DIGlobalVariableKind: {
                return true;
            }
            case DILocalVariableKind: {
                return true;
            }
            case DIObjCPropertyKind: {
                return true;
            }
            case DIImportedEntityKind: {
                return true;
            }
            case DIMacroKind: {
                return true;
            }
            case DIMacroFileKind: 
        }
        return true;
    }

    public boolean isTBAAVtableAccess() {
        if (!TypeBasedAliasAnalysisStatics.isStructPathTBAA(this)) {
            if (Unsigned.$less_uint((int)this.getNumOperands(), (int)1)) {
                return false;
            }
            MDString Tag1 = IrRTTI.dyn_cast_MDString(this.getOperand(0));
            return Tag1 != null && llvm.$eq_StringRef((StringRef)Tag1.getString(), (String)"vtable pointer");
        }
        if (Unsigned.$less_uint((int)this.getNumOperands(), (int)2)) {
            return false;
        }
        MDNode Tag = IrRTTI.cast_or_null_MDNode(this.getOperand(1));
        if (Tag == null) {
            return false;
        }
        MDString Tag1 = IrRTTI.dyn_cast_MDString(Tag.getOperand(0));
        return Tag1 != null && llvm.$eq_StringRef((StringRef)Tag1.getString(), (String)"vtable pointer");
    }

    public static MDNode concatenate(MDNode A2, MDNode B2) {
        if (A2 == null) {
            return B2;
        }
        if (B2 == null) {
            return A2;
        }
        SmallVector MDs = new SmallVector(4, (Object)null);
        MDs.reserve(A2.getNumOperands() + B2.getNumOperands());
        MDs.append_T(A2.op_begin(), A2.op_end(), Op -> Op.$Metadata$P());
        MDs.append_T(B2.op_begin(), B2.op_end(), Op -> Op.$Metadata$P());
        return MetadataStatics.getOrSelfReference(A2.getContext(), (ArrayRef<Metadata>)new ArrayRef((SmallVectorImplCommon)MDs, true));
    }

    public static MDNode intersect(MDNode A2, MDNode B2) {
        if (A2 == null || B2 == null) {
            return null;
        }
        SmallVector MDs = new SmallVector(4, (Object)null);
        for (MDOperand $Op : A2.operands()) {
            Metadata MD = $Op.$Metadata$P();
            if (!Native.$noteq_ptr((void.ptr)((void.ptr)std.find(B2.op_begin(), B2.op_end(), (Object)MD)), B2.op_end())) continue;
            MDs.push_back((Object)MD);
        }
        return MetadataStatics.getOrSelfReference(A2.getContext(), (ArrayRef<Metadata>)new ArrayRef((SmallVectorImplCommon)MDs, true));
    }

    public static MDNode getMostGenericTBAA(MDNode A2, MDNode B2) {
        boolean StructPath;
        if (A2 == null || B2 == null) {
            return null;
        }
        if (A2 == B2) {
            return A2;
        }
        boolean bl = StructPath = TypeBasedAliasAnalysisStatics.isStructPathTBAA(A2) && TypeBasedAliasAnalysisStatics.isStructPathTBAA(B2);
        if (StructPath) {
            if ((A2 = IrRTTI.cast_or_null_MDNode(A2.getOperand(1))) == null) {
                return null;
            }
            if ((B2 = IrRTTI.cast_or_null_MDNode(B2.getOperand(1))) == null) {
                return null;
            }
        }
        SmallSetVector PathA = new SmallSetVector(4, (Object)null);
        MDNode T2 = A2;
        while (T2 != null) {
            if (PathA.count((Object)T2) != 0) {
                llvm.report_fatal_error((char.ptr)NativePointer.$((String)"Cycle found in TBAA metadata."));
            }
            PathA.insert((Object)T2);
            T2 = Unsigned.$greatereq_uint((int)T2.getNumOperands(), (int)2) ? IrRTTI.cast_or_null_MDNode(T2.getOperand(1)) : null;
        }
        SmallSetVector PathB = new SmallSetVector(4, (Object)null);
        T2 = B2;
        while (T2 != null) {
            if (PathB.count((Object)T2) != 0) {
                llvm.report_fatal_error((char.ptr)NativePointer.$((String)"Cycle found in TBAA metadata."));
            }
            PathB.insert((Object)T2);
            T2 = Unsigned.$greatereq_uint((int)T2.getNumOperands(), (int)2) ? IrRTTI.cast_or_null_MDNode(T2.getOperand(1)) : null;
        }
        int IA = PathA.size() - 1;
        MDNode Ret = null;
        for (int IB = PathB.size() - 1; IA >= 0 && IB >= 0 && PathA.$at(IA) == PathB.$at(IB); --IA, --IB) {
            Ret = (MDNode)PathA.$at(IA);
        }
        if (!StructPath) {
            return Ret;
        }
        if (Ret == null) {
            return null;
        }
        IntegerType Int64 = IntegerType.get(A2.getContext(), 64);
        Object[] Ops = new Metadata[]{Ret, Ret, ConstantAsMetadata.get(ConstantInt.get((Type)Int64, Unsigned.$int2ulong((int)0)))};
        return MDNode.get(A2.getContext(), (ArrayRef<Metadata>)new ArrayRef(Ops, true));
    }

    public static MDNode getMostGenericFPMath(MDNode A2, MDNode B2) {
        APFloat BVal;
        if (A2 == null || B2 == null) {
            return null;
        }
        APFloat AVal = new APFloat(MdconstGlobals.extract$ValidPointer(ConstantFP.class, A2.getOperand(0)).getValueAPF());
        if (AVal.compare(BVal = new APFloat(MdconstGlobals.extract$ValidPointer(ConstantFP.class, B2.getOperand(0)).getValueAPF())) == APFloat.cmpResult.cmpLessThan) {
            return A2;
        }
        return B2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MDNode getMostGenericRange(MDNode A2, MDNode B2) {
        ConstantInt FE;
        ConstantInt FB;
        if (A2 == null || B2 == null) {
            return null;
        }
        if (A2 == B2) {
            return A2;
        }
        SmallVector EndPoints = new SmallVector(4, (Object)null);
        int AI = 0;
        int BI = 0;
        int AN = Unsigned.$div_uint((int)A2.getNumOperands(), (int)2);
        int BN = Unsigned.$div_uint((int)B2.getNumOperands(), (int)2);
        while (AI < AN && BI < BN) {
            ConstantInt ALow = MdconstGlobals.extract$ValidPointer(ConstantInt.class, A2.getOperand(2 * AI));
            ConstantInt BLow = MdconstGlobals.extract$ValidPointer(ConstantInt.class, B2.getOperand(2 * BI));
            if (ALow.getValue().slt(BLow.getValue())) {
                MetadataStatics.addRange((SmallVectorImpl<ConstantInt>)EndPoints, ALow, MdconstGlobals.extract$ValidPointer(ConstantInt.class, A2.getOperand(2 * AI + 1)));
                ++AI;
                continue;
            }
            MetadataStatics.addRange((SmallVectorImpl<ConstantInt>)EndPoints, BLow, MdconstGlobals.extract$ValidPointer(ConstantInt.class, B2.getOperand(2 * BI + 1)));
            ++BI;
        }
        while (AI < AN) {
            MetadataStatics.addRange((SmallVectorImpl<ConstantInt>)EndPoints, MdconstGlobals.extract$ValidPointer(ConstantInt.class, A2.getOperand(2 * AI)), MdconstGlobals.extract$ValidPointer(ConstantInt.class, A2.getOperand(2 * AI + 1)));
            ++AI;
        }
        while (BI < BN) {
            MetadataStatics.addRange((SmallVectorImpl<ConstantInt>)EndPoints, MdconstGlobals.extract$ValidPointer(ConstantInt.class, B2.getOperand(2 * BI)), MdconstGlobals.extract$ValidPointer(ConstantInt.class, B2.getOperand(2 * BI + 1)));
            ++BI;
        }
        int Size = EndPoints.size();
        if (Unsigned.$greater_uint((int)Size, (int)4) && MetadataStatics.tryMergeRange((SmallVectorImpl<ConstantInt>)EndPoints, FB = (ConstantInt)EndPoints.$at(0), FE = (ConstantInt)EndPoints.$at(1))) {
            int i = 0;
            while (Unsigned.$less_uint((int)i, (int)(Size - 2))) {
                EndPoints.$set(i, (Object)((ConstantInt)EndPoints.$at(i + 2)));
                ++i;
            }
            EndPoints.resize(Size - 2);
        }
        if (EndPoints.size() == 2) {
            ConstantRange Range = null;
            try {
                Range = new ConstantRange(new APInt(((ConstantInt)EndPoints.$at(0)).getValue()), new APInt(((ConstantInt)EndPoints.$at(1)).getValue()));
                if (Range.isFullSet()) {
                    Iterator iterator2 = null;
                    return iterator2;
                }
            }
            finally {
                if (Range != null) {
                    Range.$destroy();
                }
            }
        }
        SmallVector MDs = new SmallVector(4, (Object)null);
        MDs.reserve(EndPoints.size());
        for (ConstantInt I : EndPoints) {
            MDs.push_back((Object)ConstantAsMetadata.get(I));
        }
        return MDNode.get(A2.getContext(), (ArrayRef<Metadata>)new ArrayRef((SmallVectorImplCommon)MDs, true));
    }

    public static MDNode getMostGenericAliasScope(MDNode A2, MDNode B2) {
        if (A2 == null || B2 == null) {
            return null;
        }
        SmallVector MDs = new SmallVector(JavaDifferentiators.JD$T.INSTANCE, 4, B2.op_begin(), B2.op_end(), (Object)null, O -> O.$Metadata$P());
        for (MDOperand O2 : A2.operands()) {
            Metadata MD = O2.$Metadata$P();
            if (!Native.$eq_ptr((void.ptr)((type.ptr)std.find(B2.op_begin(), B2.op_end(), (Object)MD)), B2.op_end())) continue;
            MDs.push_back((Object)MD);
        }
        return MetadataStatics.getOrSelfReference(A2.getContext(), (ArrayRef<Metadata>)new ArrayRef((SmallVectorImplCommon)MDs, true));
    }

    public static MDNode getMostGenericAlignmentOrDereferenceable(MDNode A2, MDNode B2) {
        if (A2 == null || B2 == null) {
            return null;
        }
        ConstantInt AVal = MdconstGlobals.extract$ValidPointer(ConstantInt.class, A2.getOperand(0));
        ConstantInt BVal = MdconstGlobals.extract$ValidPointer(ConstantInt.class, B2.getOperand(0));
        if (Unsigned.$less_ulong((long)AVal.getZExtValue(), (long)BVal.getZExtValue())) {
            return A2;
        }
        return B2;
    }

    type.ptr<?> $This$Ptr() {
        return this.$This;
    }

    private static boolean assertThisConsumedByCtor(MDNode createdInstance, type.ptr Mem) {
        assert (createdInstance.$This.$eq((Object)Mem)) : "expected " + Mem + " vs. " + createdInstance.$This;
        assert (Mem.$star() == createdInstance) : "createdInstance should be in Mem, but got: " + Mem.$star();
        return true;
    }

    private static <T extends MDNode> T callConstructorImpl(type.ptr<?> MemoryLocation, NativeCallback.New.ConstructorCallback<T> $Ctor) {
        MDNode createdInstance = (MDNode)$Ctor.$call(MemorySupplier.assignMemory(MemoryLocation));
        assert (MemorySupplier.assertConsumed((Object)createdInstance, MemoryLocation));
        return (T)createdInstance;
    }

    protected static <T extends MDNode> T $new(int NumOps, NativeCallback.New.ConstructorCallback<T> $Ctor) {
        return MDNode.$new(Integer.MIN_VALUE, NumOps, $Ctor);
    }

    public void $delete() {
        MDNode.$delete(this);
    }

    @Override
    public String toString() {
        return "NumOperands=" + this.NumOperands + ", NumUnresolved=" + this.NumUnresolved + ", Context=" + this.Context + super.toString();
    }
}

