/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.clank.java.std_pair;
import org.clank.java.std_ptr;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Unsigned;
import org.llvm.adt.APInt;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.ArrayRefUInt;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.java.SmallVectorImplCommon;
import org.llvm.ir.Constant;
import org.llvm.ir.ConstantAsMetadata;
import org.llvm.ir.ConstantFP;
import org.llvm.ir.ConstantInt;
import org.llvm.ir.IntegerType;
import org.llvm.ir.LLVMContext;
import org.llvm.ir.MDNode;
import org.llvm.ir.MDString;
import org.llvm.ir.MDTuple;
import org.llvm.ir.Metadata;
import org.llvm.ir.Type;
import org.llvm.support.llvm;

public class MDBuilder {
    private final LLVMContext Context;

    public MDBuilder(LLVMContext context) {
        this.Context = context;
    }

    public MDString createString(StringRef Str) {
        return MDString.get(this.Context, new StringRef(Str));
    }

    public ConstantAsMetadata createConstant(Constant C2) {
        return ConstantAsMetadata.get(C2);
    }

    public MDNode createFPMath(float Accuracy) {
        if ((double)Accuracy == 0.0) {
            return null;
        }
        assert ((double)Accuracy > 0.0) : "Invalid fpmath accuracy!";
        ConstantAsMetadata Op = this.createConstant(ConstantFP.get(Type.getFloatTy(this.Context), Accuracy));
        return MDNode.get(this.Context, (ArrayRef<Metadata>)new ArrayRef((Object)Op, true));
    }

    public MDNode createBranchWeights(int TrueWeight, int FalseWeight) {
        return this.createBranchWeights(new ArrayRefUInt(new int[]{TrueWeight, FalseWeight}));
    }

    public MDNode createBranchWeights(ArrayRefUInt Weights) {
        assert (Unsigned.$greatereq_uint((int)Weights.size(), (int)1)) : "Need at least one branch weights!";
        SmallVector Vals = new SmallVector(JavaDifferentiators.JD$UInt_T$C$R.INSTANCE, 4, Weights.size() + 1, (Object)null);
        Vals.$set(0, (Object)this.createString(new StringRef("branch_weights")));
        IntegerType Int32Ty = Type.getInt32Ty(this.Context);
        int e = Weights.size();
        for (int i = 0; i != e; ++i) {
            Vals.$set(i + 1, (Object)this.createConstant(ConstantInt.get((Type)Int32Ty, Unsigned.$uint2ulong((int)Weights.$at(i)))));
        }
        return MDNode.get(this.Context, (ArrayRef<Metadata>)new ArrayRef((SmallVectorImplCommon)Vals, true));
    }

    public MDNode createUnpredictable() {
        return MDNode.get(this.Context, (ArrayRef<Metadata>)new ArrayRef(llvm.None, true));
    }

    public MDNode createFunctionEntryCount(long Count) {
        IntegerType Int64Ty = Type.getInt64Ty(this.Context);
        return MDNode.get(this.Context, (ArrayRef<Metadata>)new ArrayRef((Object[])new Metadata[]{this.createString(new StringRef("function_entry_count")), this.createConstant(ConstantInt.get((Type)Int64Ty, Count))}, true));
    }

    public MDNode createRange(APInt Lo, APInt Hi) {
        assert (Lo.getBitWidth() == Hi.getBitWidth()) : "Mismatched bitwidths!";
        IntegerType Ty = IntegerType.get(this.Context, Lo.getBitWidth());
        return this.createRange(ConstantInt.get((Type)Ty, Lo), ConstantInt.get((Type)Ty, Hi));
    }

    public MDNode createRange(Constant Lo, Constant Hi) {
        if (Hi == Lo) {
            return null;
        }
        return MDNode.get(this.Context, (ArrayRef<Metadata>)new ArrayRef((Object[])new Metadata[]{this.createConstant(Lo), this.createConstant(Hi)}, true));
    }

    protected MDNode createAnonymousAARoot() {
        return this.createAnonymousAARoot(new StringRef(), null);
    }

    protected MDNode createAnonymousAARoot(StringRef Name) {
        return this.createAnonymousAARoot(Name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MDNode createAnonymousAARoot(StringRef Name, MDNode Extra) {
        std_ptr.unique_ptr_with_deleter<MDTuple> Dummy = null;
        try {
            Dummy = MDNode.getTemporary(this.Context, (ArrayRef<Metadata>)new ArrayRef(llvm.None, true));
            SmallVector Args = new SmallVector(JavaDifferentiators.JD$UInt_T$C$R.INSTANCE, 3, 1, (Object)((Metadata)Dummy.get()), (Object)null);
            if (Extra != null) {
                Args.push_back((Object)Extra);
            }
            if (!Name.empty()) {
                Args.push_back((Object)this.createString(new StringRef(Name)));
            }
            MDTuple Root = MDNode.get(this.Context, (ArrayRef<Metadata>)new ArrayRef((SmallVectorImplCommon)Args, true));
            Root.replaceOperandWith(0, Root);
            MDTuple mDTuple = Root;
            return mDTuple;
        }
        finally {
            if (Dummy != null) {
                Dummy.$destroy();
            }
        }
    }

    public MDNode createAnonymousTBAARoot() {
        return this.createAnonymousAARoot();
    }

    public MDNode createAnonymousAliasScopeDomain() {
        return this.createAnonymousAliasScopeDomain(new StringRef());
    }

    public MDNode createAnonymousAliasScopeDomain(StringRef Name) {
        return this.createAnonymousAARoot(new StringRef(Name));
    }

    public MDNode createAnonymousAliasScope(MDNode Domain) {
        return this.createAnonymousAliasScope(Domain, new StringRef());
    }

    public MDNode createAnonymousAliasScope(MDNode Domain, StringRef Name) {
        return this.createAnonymousAARoot(new StringRef(Name), Domain);
    }

    public MDNode createTBAARoot(StringRef Name) {
        return MDNode.get(this.Context, (ArrayRef<Metadata>)new ArrayRef((Object)this.createString(new StringRef(Name)), true));
    }

    public MDNode createAliasScopeDomain(StringRef Name) {
        return MDNode.get(this.Context, (ArrayRef<Metadata>)new ArrayRef((Object)this.createString(new StringRef(Name)), true));
    }

    public MDNode createAliasScope(StringRef Name, MDNode Domain) {
        return MDNode.get(this.Context, (ArrayRef<Metadata>)new ArrayRef((Object[])new Metadata[]{this.createString(new StringRef(Name)), Domain}, true));
    }

    public MDNode createTBAANode(StringRef Name, MDNode Parent) {
        return this.createTBAANode(Name, Parent, false);
    }

    public MDNode createTBAANode(StringRef Name, MDNode Parent, boolean isConstant) {
        if (isConstant) {
            ConstantInt Flags = ConstantInt.get(Type.getInt64Ty(this.Context), Unsigned.$int2ulong((int)1));
            return MDNode.get(this.Context, (ArrayRef<Metadata>)new ArrayRef((Object[])new Metadata[]{this.createString(new StringRef(Name)), Parent, this.createConstant(Flags)}, true));
        }
        return MDNode.get(this.Context, (ArrayRef<Metadata>)new ArrayRef((Object[])new Metadata[]{this.createString(new StringRef(Name)), Parent}, true));
    }

    public MDNode createTBAAStructNode(ArrayRef<TBAAStructField> Fields2) {
        SmallVector Vals = new SmallVector(JavaDifferentiators.JD$UInt_T$C$R.INSTANCE, 4, Fields2.size() * 3, (Object)null);
        IntegerType Int64 = Type.getInt64Ty(this.Context);
        int e = Fields2.size();
        for (int i = 0; i != e; ++i) {
            Vals.$set(i * 3 + 0, (Object)this.createConstant(ConstantInt.get((Type)Int64, ((TBAAStructField)Fields2.$at((int)i)).Offset)));
            Vals.$set(i * 3 + 1, (Object)this.createConstant(ConstantInt.get((Type)Int64, ((TBAAStructField)Fields2.$at((int)i)).Size)));
            Vals.$set(i * 3 + 2, (Object)((TBAAStructField)Fields2.$at((int)i)).TBAA);
        }
        return MDNode.get(this.Context, (ArrayRef<Metadata>)new ArrayRef((SmallVectorImplCommon)Vals, true));
    }

    public MDNode createTBAAStructTypeNode(StringRef Name, ArrayRef<std_pair.pairPtrULong<MDNode>> Fields2) {
        SmallVector Ops = new SmallVector(JavaDifferentiators.JD$UInt_T$C$R.INSTANCE, 4, Fields2.size() * 2 + 1, (Object)null);
        IntegerType Int64 = Type.getInt64Ty(this.Context);
        Ops.$set(0, (Object)this.createString(new StringRef(Name)));
        int e = Fields2.size();
        for (int i = 0; i != e; ++i) {
            Ops.$set(i * 2 + 1, (Object)((Metadata)((std_pair.pairPtrULong)Fields2.$at((int)i)).first));
            Ops.$set(i * 2 + 2, (Object)this.createConstant(ConstantInt.get((Type)Int64, ((std_pair.pairPtrULong)Fields2.$at((int)i)).second)));
        }
        return MDNode.get(this.Context, (ArrayRef<Metadata>)new ArrayRef((SmallVectorImplCommon)Ops, true));
    }

    public MDNode createTBAAScalarTypeNode(StringRef Name, MDNode Parent) {
        return this.createTBAAScalarTypeNode(Name, Parent, Unsigned.$int2ulong((int)0));
    }

    public MDNode createTBAAScalarTypeNode(StringRef Name, MDNode Parent, long Offset) {
        ConstantInt Off = ConstantInt.get(Type.getInt64Ty(this.Context), Offset);
        return MDNode.get(this.Context, (ArrayRef<Metadata>)new ArrayRef((Object[])new Metadata[]{this.createString(new StringRef(Name)), Parent, this.createConstant(Off)}, true));
    }

    public MDNode createTBAAStructTagNode(MDNode BaseType, MDNode AccessType, long Offset) {
        return this.createTBAAStructTagNode(BaseType, AccessType, Offset, false);
    }

    public MDNode createTBAAStructTagNode(MDNode BaseType, MDNode AccessType, long Offset, boolean IsConstant) {
        IntegerType Int64 = Type.getInt64Ty(this.Context);
        ConstantInt Off = ConstantInt.get(Int64, Offset);
        if (IsConstant) {
            return MDNode.get(this.Context, (ArrayRef<Metadata>)new ArrayRef((Object[])new Metadata[]{BaseType, AccessType, this.createConstant(Off), this.createConstant(ConstantInt.get(Int64, Unsigned.$int2ulong((int)1)))}, true));
        }
        return MDNode.get(this.Context, (ArrayRef<Metadata>)new ArrayRef((Object[])new Metadata[]{BaseType, AccessType, this.createConstant(Off)}, true));
    }

    public String toString() {
        return "Context=[LLVMContext]";
    }

    public static class TBAAStructField {
        public long Offset;
        public long Size;
        public MDNode TBAA;

        public TBAAStructField(long Offset, long Size, MDNode TBAA) {
            this.Offset = Offset;
            this.Size = Size;
            this.TBAA = TBAA;
        }

        public TBAAStructField() {
        }

        public String toString() {
            return "Offset=" + this.Offset + ", Size=" + this.Size + ", TBAA=" + this.TBAA;
        }
    }
}

