/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativeMoveable;
import org.clank.support.NativePointer;
import org.clank.support.aliases.char;
import org.llvm.adt.ADTFunctionPointers;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.DenseMap;
import org.llvm.adt.aliases.DenseMapIterator;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.adt.aliases.StringMapConstIteratorUInt;
import org.llvm.adt.aliases.StringMapEntryUInt;
import org.llvm.adt.aliases.StringMapIteratorUInt;
import org.llvm.ir.DiagnosticInfo;
import org.llvm.ir.DiagnosticInfoInlineAsm;
import org.llvm.ir.DiagnosticInfoOptimizationBase;
import org.llvm.ir.DiagnosticPrinterRawOStream;
import org.llvm.ir.DiagnosticSeverity;
import org.llvm.ir.Function;
import org.llvm.ir.Instruction;
import org.llvm.ir.Module$IR;
import org.llvm.ir.OptBisect;
import org.llvm.ir.impl.LLVMContextImpl;
import org.llvm.ir.impl.LLVMContextStatics;
import org.llvm.ir.java.IRFunctionPointers;
import org.llvm.llvmc.LLVMOpaqueContext;
import org.llvm.support.OptionRegistry;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;

public class LLVMContext
implements LLVMOpaqueContext,
Destructors.ClassWithDestructor {
    public LLVMContextImpl pImpl;

    public LLVMContext() {
        this.pImpl = new LLVMContextImpl(this);
        int DbgID = this.getMDKindID(new StringRef("dbg"));
        assert (DbgID == Unnamed_enum.MD_dbg.getValue()) : "dbg kind id drifted";
        int TBAAID = this.getMDKindID(new StringRef("tbaa"));
        assert (TBAAID == Unnamed_enum.MD_tbaa.getValue()) : "tbaa kind id drifted";
        int ProfID = this.getMDKindID(new StringRef("prof"));
        assert (ProfID == Unnamed_enum.MD_prof.getValue()) : "prof kind id drifted";
        int FPAccuracyID = this.getMDKindID(new StringRef("fpmath"));
        assert (FPAccuracyID == Unnamed_enum.MD_fpmath.getValue()) : "fpmath kind id drifted";
        int RangeID = this.getMDKindID(new StringRef("range"));
        assert (RangeID == Unnamed_enum.MD_range.getValue()) : "range kind id drifted";
        int TBAAStructID = this.getMDKindID(new StringRef("tbaa.struct"));
        assert (TBAAStructID == Unnamed_enum.MD_tbaa_struct.getValue()) : "tbaa.struct kind id drifted";
        int InvariantLdId = this.getMDKindID(new StringRef("invariant.load"));
        assert (InvariantLdId == Unnamed_enum.MD_invariant_load.getValue()) : "invariant.load kind id drifted";
        int AliasScopeID = this.getMDKindID(new StringRef("alias.scope"));
        assert (AliasScopeID == Unnamed_enum.MD_alias_scope.getValue()) : "alias.scope kind id drifted";
        int NoAliasID = this.getMDKindID(new StringRef("noalias"));
        assert (NoAliasID == Unnamed_enum.MD_noalias.getValue()) : "noalias kind id drifted";
        int NonTemporalID = this.getMDKindID(new StringRef("nontemporal"));
        assert (NonTemporalID == Unnamed_enum.MD_nontemporal.getValue()) : "nontemporal kind id drifted";
        int MemParallelLoopAccessID = this.getMDKindID(new StringRef("llvm.mem.parallel_loop_access"));
        assert (MemParallelLoopAccessID == Unnamed_enum.MD_mem_parallel_loop_access.getValue()) : "mem_parallel_loop_access kind id drifted";
        int NonNullID = this.getMDKindID(new StringRef(NativePointer.$nonnull));
        assert (NonNullID == Unnamed_enum.MD_nonnull.getValue()) : "nonnull kind id drifted";
        int DereferenceableID = this.getMDKindID(new StringRef("dereferenceable"));
        assert (DereferenceableID == Unnamed_enum.MD_dereferenceable.getValue()) : "dereferenceable kind id drifted";
        int DereferenceableOrNullID = this.getMDKindID(new StringRef("dereferenceable_or_null"));
        assert (DereferenceableOrNullID == Unnamed_enum.MD_dereferenceable_or_null.getValue()) : "dereferenceable_or_null kind id drifted";
        int MakeImplicitID = this.getMDKindID(new StringRef("make.implicit"));
        assert (MakeImplicitID == Unnamed_enum.MD_make_implicit.getValue()) : "make.implicit kind id drifted";
        int UnpredictableID = this.getMDKindID(new StringRef("unpredictable"));
        assert (UnpredictableID == Unnamed_enum.MD_unpredictable.getValue()) : "unpredictable kind id drifted";
        int InvariantGroupId = this.getMDKindID(new StringRef("invariant.group"));
        assert (InvariantGroupId == Unnamed_enum.MD_invariant_group.getValue()) : "invariant.group kind id drifted";
        int AlignID = this.getMDKindID(new StringRef("align"));
        assert (AlignID == Unnamed_enum.MD_align.getValue()) : "align kind id drifted";
        int LoopID = this.getMDKindID(new StringRef("llvm.loop"));
        assert (LoopID == Unnamed_enum.MD_loop.getValue()) : "llvm.loop kind id drifted";
        int TypeID2 = this.getMDKindID(new StringRef("type"));
        assert (TypeID2 == Unnamed_enum.MD_type.getValue()) : "type kind id drifted";
        StringMapEntryUInt DeoptEntry = this.pImpl.getOrInsertBundleTag(new StringRef("deopt"));
        assert (DeoptEntry.second == Unnamed_enum1.OB_deopt.getValue()) : "deopt operand bundle id drifted!";
        StringMapEntryUInt FuncletEntry = this.pImpl.getOrInsertBundleTag(new StringRef("funclet"));
        assert (FuncletEntry.second == Unnamed_enum1.OB_funclet.getValue()) : "funclet operand bundle id drifted!";
        StringMapEntryUInt GCTransitionEntry = this.pImpl.getOrInsertBundleTag(new StringRef("gc-transition"));
        assert (GCTransitionEntry.second == Unnamed_enum1.OB_gc_transition.getValue()) : "gc-transition operand bundle id drifted!";
    }

    public void $destroy() {
        Destructors.$destroy((Destructors.ClassWithDestructor)this.pImpl);
    }

    public int getMDKindID(StringRef Name) {
        return ((StringMapIteratorUInt)this.pImpl.CustomMDKindNames.insert((std_pair.pairTypeUInt)std.make_pair_T_uint((Object)((StringRef)Native.$Clone((NativeCloneable)Name)), (int)this.pImpl.CustomMDKindNames.size())).first).$arrow().second;
    }

    public void getMDKindNames(SmallVectorImpl<StringRef> Names) {
        Names.resize(this.pImpl.CustomMDKindNames.size());
        StringMapIteratorUInt I = new StringMapIteratorUInt(JavaDifferentiators.JD.Move.INSTANCE, this.pImpl.CustomMDKindNames.begin());
        StringMapIteratorUInt E = new StringMapIteratorUInt(JavaDifferentiators.JD.Move.INSTANCE, this.pImpl.CustomMDKindNames.end());
        while (I.$noteq((StringMapConstIteratorUInt)E)) {
            ((StringRef)Names.$at(I.$arrow().second)).$assignMove(I.$arrow().first());
            I.$preInc();
        }
    }

    public void getOperandBundleTags(SmallVectorImpl<StringRef> Tags) {
        this.pImpl.getOperandBundleTags(Tags);
    }

    public int getOperandBundleTagID(StringRef Tag) {
        return this.pImpl.getOperandBundleTagID(new StringRef(Tag));
    }

    public void setGC(Function Fn, std.string GCName) {
        DenseMapIterator It = this.pImpl.GCNames.find((Object)((Function)Native.$AddrOf((Object)Fn)));
        if (It.$eq(this.pImpl.GCNames.end())) {
            this.pImpl.GCNames.insert_pair$KeyT$ValueT((std_pair.pair)std.make_pair_Ptr_T((Object)((Function)Native.$AddrOf((Object)Fn)), (Object)((std.string)Native.$Move((NativeMoveable)((std.string)std.move((Object)GCName))))));
            return;
        }
        ((std.string)It.$arrow().second).$assignMove((std.string)std.move((Object)GCName));
    }

    public std.string getGC(Function Fn) {
        return (std.string)this.pImpl.GCNames.$at_T1$RR((Object)((Function)Native.$AddrOf((Object)Fn)));
    }

    public void deleteGC(Function Fn) {
        this.pImpl.GCNames.erase((Object)((Function)Native.$AddrOf((Object)Fn)));
    }

    public boolean shouldDiscardValueNames() {
        return this.pImpl.DiscardValueNames;
    }

    public void setDiscardValueNames(boolean Discard) {
        this.pImpl.DiscardValueNames = Discard;
    }

    public boolean isODRUniquingDebugTypes() {
        return this.pImpl.DITypeMap.$bool();
    }

    public void enableDebugTypeODRUniquing() {
        if (this.pImpl.DITypeMap.$bool()) {
            return;
        }
        this.pImpl.DITypeMap.emplace((Object[])new DenseMap[0]);
    }

    public void disableDebugTypeODRUniquing() {
        this.pImpl.DITypeMap.reset();
    }

    public void setInlineAsmDiagnosticHandler(ADTFunctionPointers.SMDiagnosticHandler DiagHandler) {
        this.setInlineAsmDiagnosticHandler(DiagHandler, null);
    }

    public void setInlineAsmDiagnosticHandler(ADTFunctionPointers.SMDiagnosticHandler DiagHandler, Object DiagContext) {
        this.pImpl.InlineAsmDiagHandler = (ADTFunctionPointers.SMDiagnosticHandler)Native.$tryClone((Object)DiagHandler);
        this.pImpl.InlineAsmDiagContext = DiagContext;
    }

    public ADTFunctionPointers.SMDiagnosticHandler getInlineAsmDiagnosticHandler() {
        return this.pImpl.InlineAsmDiagHandler;
    }

    public Object getInlineAsmDiagnosticContext() {
        return this.pImpl.InlineAsmDiagContext;
    }

    public void setDiagnosticHandler(IRFunctionPointers.DiagnosticInfoHandler DiagnosticHandler) {
        this.setDiagnosticHandler(DiagnosticHandler, null, false);
    }

    public void setDiagnosticHandler(IRFunctionPointers.DiagnosticInfoHandler DiagnosticHandler, Object DiagnosticContext) {
        this.setDiagnosticHandler(DiagnosticHandler, DiagnosticContext, false);
    }

    public void setDiagnosticHandler(IRFunctionPointers.DiagnosticInfoHandler DiagnosticHandler, Object DiagnosticContext, boolean RespectFilters) {
        this.pImpl.DiagnosticHandler = (IRFunctionPointers.DiagnosticInfoHandler)Native.$tryClone((Object)DiagnosticHandler);
        this.pImpl.DiagnosticContext = DiagnosticContext;
        this.pImpl.RespectDiagnosticFilters = RespectFilters;
    }

    public IRFunctionPointers.DiagnosticInfoHandler getDiagnosticHandler() {
        return this.pImpl.DiagnosticHandler;
    }

    public Object getDiagnosticContext() {
        return this.pImpl.DiagnosticContext;
    }

    public boolean getDiagnosticHotnessRequested() {
        return this.pImpl.DiagnosticHotnessRequested;
    }

    public void setDiagnosticHotnessRequested(boolean Requested) {
        this.pImpl.DiagnosticHotnessRequested = Requested;
    }

    public static char.ptr getDiagnosticMessagePrefix(DiagnosticSeverity Severity) {
        switch (Severity) {
            case DS_Error: {
                return NativePointer.$error;
            }
            case DS_Warning: {
                return NativePointer.$warning;
            }
            case DS_Remark: {
                return NativePointer.$((String)"remark");
            }
            case DS_Note: {
                return NativePointer.$((String)"note");
            }
        }
        throw new llvm_unreachable("Unknown DiagnosticSeverity");
    }

    public void diagnose(DiagnosticInfo DI) {
        DiagnosticPrinterRawOStream DP = null;
        try {
            if (this.pImpl.DiagnosticHandler != null) {
                if (!this.pImpl.RespectDiagnosticFilters || LLVMContextStatics.isDiagnosticEnabled(DI)) {
                    this.pImpl.DiagnosticHandler.$call(DI, this.pImpl.DiagnosticContext);
                }
                return;
            }
            if (!LLVMContextStatics.isDiagnosticEnabled(DI)) {
                return;
            }
            DP = new DiagnosticPrinterRawOStream(llvm.errs());
            llvm.errs().$out(LLVMContext.getDiagnosticMessagePrefix(DI.getSeverity())).$out(": ");
            DI.print(DP);
            llvm.errs().$out(NativePointer.$LF);
            if (DI.getSeverity() == DiagnosticSeverity.DS_Error) {
                std.exit((int)1);
            }
        }
        finally {
            if (DP != null) {
                DP.$destroy();
            }
        }
    }

    public void setYieldCallback(IRFunctionPointers.YieldCallbackTy Callback, Object OpaqueHandle) {
        this.pImpl.YieldCallback = (IRFunctionPointers.YieldCallbackTy)Native.$tryClone((Object)Callback);
        this.pImpl.YieldOpaqueHandle = OpaqueHandle;
    }

    public void yield() {
        if (this.pImpl.YieldCallback != null) {
            this.pImpl.YieldCallback.$call(this, this.pImpl.YieldOpaqueHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void emitError(int LocCookie, Twine ErrorStr) {
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            this.diagnose((DiagnosticInfo)$c$.track((Object)new DiagnosticInfoInlineAsm(LocCookie, ErrorStr)));
            $c$.clean();
        }
        finally {
            $c$.$destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void emitError(Instruction I, Twine ErrorStr) {
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            assert (I != null) : "Invalid instruction";
            this.diagnose((DiagnosticInfo)$c$.track((Object)new DiagnosticInfoInlineAsm((Instruction)Native.$Deref((Object)I), ErrorStr)));
            $c$.clean();
        }
        finally {
            $c$.$destroy();
        }
    }

    public void emitError(Twine ErrorStr) {
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            this.diagnose((DiagnosticInfo)$c$.track((Object)new DiagnosticInfoInlineAsm(ErrorStr)));
            $c$.clean();
        }
        finally {
            $c$.$destroy();
        }
    }

    public <ValT, Base> ValT getOption(byte Mem) {
        return (ValT)OptionRegistry.instance().get(Mem);
    }

    public OptBisect getOptBisect() {
        return this.pImpl.getOptBisect();
    }

    protected LLVMContext(LLVMContext $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    protected void $assign(LLVMContext $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    void addModule(Module$IR M) {
        this.pImpl.OwnedModules.insert((Object)M);
    }

    void removeModule(Module$IR M) {
        this.pImpl.OwnedModules.erase((Object)M);
    }

    private static boolean isDiagnosticEnabled(DiagnosticInfo DI) {
        if (DI instanceof DiagnosticInfoOptimizationBase) {
            return ((DiagnosticInfoOptimizationBase)DI).isEnabled();
        }
        return true;
    }

    public String toString() {
        return "pImpl=" + this.pImpl;
    }

    public static final class Unnamed_enum1
    extends Enum<Unnamed_enum1>
    implements Native.NativeUIntEnum {
        public static final /* enum */ Unnamed_enum1 OB_deopt = new Unnamed_enum1(0);
        public static final /* enum */ Unnamed_enum1 OB_funclet = new Unnamed_enum1(1);
        public static final /* enum */ Unnamed_enum1 OB_gc_transition = new Unnamed_enum1(2);
        private final int value;
        private static final /* synthetic */ Unnamed_enum1[] $VALUES;

        public static Unnamed_enum1[] values() {
            return (Unnamed_enum1[])$VALUES.clone();
        }

        public static Unnamed_enum1 valueOf(String name) {
            return Enum.valueOf(Unnamed_enum1.class, name);
        }

        public static Unnamed_enum1 valueOf(int val) {
            Unnamed_enum1 out;
            Unnamed_enum1 unnamed_enum1 = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private Unnamed_enum1(int val) {
            this.value = val;
        }

        public final int getValue() {
            return this.value;
        }

        static {
            $VALUES = new Unnamed_enum1[]{OB_deopt, OB_funclet, OB_gc_transition};
        }

        private static final class Values {
            private static final Unnamed_enum1[] VALUES;
            private static final Unnamed_enum1[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (Unnamed_enum1 kind : Unnamed_enum1.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new Unnamed_enum1[min < 0 ? 1 - min : 0];
                VALUES = new Unnamed_enum1[max >= 0 ? 1 + max : 0];
                for (Unnamed_enum1 kind : Unnamed_enum1.values()) {
                    if (kind.value < 0) {
                        if (_VALUES[-kind.value] != null) continue;
                        Values._VALUES[-((Unnamed_enum1)kind).value] = kind;
                        continue;
                    }
                    if (VALUES[kind.value] != null) continue;
                    Values.VALUES[((Unnamed_enum1)kind).value] = kind;
                }
            }
        }
    }

    public static final class Unnamed_enum
    extends Enum<Unnamed_enum>
    implements Native.NativeUIntEnum {
        public static final /* enum */ Unnamed_enum MD_dbg = new Unnamed_enum(0);
        public static final /* enum */ Unnamed_enum MD_tbaa = new Unnamed_enum(1);
        public static final /* enum */ Unnamed_enum MD_prof = new Unnamed_enum(2);
        public static final /* enum */ Unnamed_enum MD_fpmath = new Unnamed_enum(3);
        public static final /* enum */ Unnamed_enum MD_range = new Unnamed_enum(4);
        public static final /* enum */ Unnamed_enum MD_tbaa_struct = new Unnamed_enum(5);
        public static final /* enum */ Unnamed_enum MD_invariant_load = new Unnamed_enum(6);
        public static final /* enum */ Unnamed_enum MD_alias_scope = new Unnamed_enum(7);
        public static final /* enum */ Unnamed_enum MD_noalias = new Unnamed_enum(8);
        public static final /* enum */ Unnamed_enum MD_nontemporal = new Unnamed_enum(9);
        public static final /* enum */ Unnamed_enum MD_mem_parallel_loop_access = new Unnamed_enum(10);
        public static final /* enum */ Unnamed_enum MD_nonnull = new Unnamed_enum(11);
        public static final /* enum */ Unnamed_enum MD_dereferenceable = new Unnamed_enum(12);
        public static final /* enum */ Unnamed_enum MD_dereferenceable_or_null = new Unnamed_enum(13);
        public static final /* enum */ Unnamed_enum MD_make_implicit = new Unnamed_enum(14);
        public static final /* enum */ Unnamed_enum MD_unpredictable = new Unnamed_enum(15);
        public static final /* enum */ Unnamed_enum MD_invariant_group = new Unnamed_enum(16);
        public static final /* enum */ Unnamed_enum MD_align = new Unnamed_enum(17);
        public static final /* enum */ Unnamed_enum MD_loop = new Unnamed_enum(18);
        public static final /* enum */ Unnamed_enum MD_type = new Unnamed_enum(19);
        private final int value;
        private static final /* synthetic */ Unnamed_enum[] $VALUES;

        public static Unnamed_enum[] values() {
            return (Unnamed_enum[])$VALUES.clone();
        }

        public static Unnamed_enum valueOf(String name) {
            return Enum.valueOf(Unnamed_enum.class, name);
        }

        public static Unnamed_enum valueOf(int val) {
            Unnamed_enum out;
            Unnamed_enum unnamed_enum = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private Unnamed_enum(int val) {
            this.value = val;
        }

        public final int getValue() {
            return this.value;
        }

        static {
            $VALUES = new Unnamed_enum[]{MD_dbg, MD_tbaa, MD_prof, MD_fpmath, MD_range, MD_tbaa_struct, MD_invariant_load, MD_alias_scope, MD_noalias, MD_nontemporal, MD_mem_parallel_loop_access, MD_nonnull, MD_dereferenceable, MD_dereferenceable_or_null, MD_make_implicit, MD_unpredictable, MD_invariant_group, MD_align, MD_loop, MD_type};
        }

        private static final class Values {
            private static final Unnamed_enum[] VALUES;
            private static final Unnamed_enum[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (Unnamed_enum kind : Unnamed_enum.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new Unnamed_enum[min < 0 ? 1 - min : 0];
                VALUES = new Unnamed_enum[max >= 0 ? 1 + max : 0];
                for (Unnamed_enum kind : Unnamed_enum.values()) {
                    if (kind.value < 0) {
                        if (_VALUES[-kind.value] != null) continue;
                        Values._VALUES[-((Unnamed_enum)kind).value] = kind;
                        continue;
                    }
                    if (VALUES[kind.value] != null) continue;
                    Values.VALUES[((Unnamed_enum)kind).value] = kind;
                }
            }
        }
    }
}

