/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.clank.java.std;
import org.clank.support.Casts;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.Native;
import org.clank.support.NativeCallback;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.type;
import org.clank.support.aliases.uint;
import org.clank.support.void;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.ArrayRefUInt;
import org.llvm.adt.iterator_range;
import org.llvm.ir.AttrBuilder;
import org.llvm.ir.Attribute;
import org.llvm.ir.AttributeSet;
import org.llvm.ir.BasicBlock;
import org.llvm.ir.DebugLoc;
import org.llvm.ir.Function;
import org.llvm.ir.FunctionType;
import org.llvm.ir.Instruction;
import org.llvm.ir.LandingPadInst;
import org.llvm.ir.OperandBundleDefT;
import org.llvm.ir.OperandBundleUser;
import org.llvm.ir.OperandTraitsInvokeInst;
import org.llvm.ir.TerminatorInst;
import org.llvm.ir.Use;
import org.llvm.ir.User;
import org.llvm.ir.Value;
import org.llvm.ir.java.CallOrInvokeInst;
import org.llvm.ir.java.IRJavaDifferentiators;
import org.llvm.ir.java.IrRTTI;
import org.llvm.ir.java.IrSizeofAndAlignment;
import org.llvm.support.llvm;

public class InvokeInst
extends TerminatorInst
implements OperandBundleUser<InvokeInst, type.ptr<Use>>,
CallOrInvokeInst,
Destructors.ClassWithDestructor {
    private AttributeSet AttributeList;
    private FunctionType FTy;

    private InvokeInst(InvokeInst II) {
        super(II.getType(), 5, (type.ptr<Use>)((type.ptr)OperandTraitsInvokeInst.op_end(User.$BEING_CREATED()).$sub(II.getNumOperands())), II.getNumOperands());
        this.$OperandBundleUser();
        this.AttributeList = new AttributeSet(II.AttributeList);
        this.FTy = II.FTy;
        this.setCallingConv(II.getCallingConv());
        std.copy(II.op_begin$Const(), II.op_end$Const(), this.op_begin());
        std.copy((type.iterator)II.bundle_op_info_begin$Const(), (type.iterator)II.bundle_op_info_end$Const(), (type.iterator)this.bundle_op_info_begin());
        this.SubclassOptionalData = Unsigned.$uchar2uchar_7bits((byte)Unsigned.$7bits_uchar2uchar((byte)II.SubclassOptionalData));
    }

    private void init(Value Func, BasicBlock IfNormal, BasicBlock IfException, ArrayRef<Value> Args, ArrayRef<OperandBundleDefT<Value>> Bundles, Twine NameStr) {
        this.init(IrRTTI.cast_FunctionType(IrRTTI.cast_PointerType(Func.getType()).getElementType()), Func, IfNormal, IfException, (ArrayRef<Value>)new ArrayRef(Args), (ArrayRef<OperandBundleDefT<Value>>)new ArrayRef(Bundles), NameStr);
    }

    private void init(FunctionType FTy, Value Fn, BasicBlock IfNormal, BasicBlock IfException, ArrayRef<Value> Args, ArrayRef<OperandBundleDefT<Value>> Bundles, Twine NameStr) {
        this.FTy = FTy;
        assert (this.getNumOperands() == 3 + Args.size() + OperandBundleUser.CountBundleInputs((ArrayRef<OperandBundleDefT<Value>>)new ArrayRef(Bundles))) : "NumOperands not set up?";
        this.Op(-3).$assign(Fn);
        this.Op(-2).$assign(IfNormal);
        this.Op(-1).$assign(IfException);
        assert (Args.size() == FTy.getNumParams() || FTy.isVarArg() && Unsigned.$greater_uint((int)Args.size(), (int)FTy.getNumParams())) : "Invoking a function with bad signature";
        int e = Args.size();
        for (int i = 0; i != e; ++i) {
            assert (Unsigned.$greatereq_uint((int)i, (int)FTy.getNumParams()) || FTy.getParamType(i) == ((Value)Args.$at(i)).getType()) : "Invoking a function with a bad signature!";
        }
        std.copy((type.iterator)Args.begin(), (type.iterator)Args.end(), this.op_begin(), (source, dest) -> ((Use)dest.$star()).$assign((Value)source.$star()));
        type.ptr It = (type.ptr)Native.$tryClone((NativeCloneable)this.populateBundleOperandInfos(new ArrayRef(Bundles), Args.size()));
        assert (Native.$eq_ptr((void.ptr)((type.ptr)It.$add(3)), this.op_end())) : "Should add up!";
        this.setName(NameStr);
    }

    private InvokeInst(IRJavaDifferentiators.JD.Value.P_BasicBlock.P_ArrayRef.Value.P_ArrayRef.OperandBundleDefT.P_UInt_Twine.C_Instruction.P _dparam, Value Func, BasicBlock IfNormal, BasicBlock IfException, ArrayRef<Value> Args, ArrayRef<OperandBundleDefT<Value>> Bundles, int Values2, Twine NameStr, Instruction InsertBefore) {
        this(IrRTTI.cast_FunctionType(IrRTTI.cast_PointerType(Func.getType()).getElementType()), Func, IfNormal, IfException, (ArrayRef<Value>)new ArrayRef(Args), (ArrayRef<OperandBundleDefT<Value>>)new ArrayRef(Bundles), Values2, NameStr, InsertBefore);
    }

    private InvokeInst(FunctionType Ty, Value Func, BasicBlock IfNormal, BasicBlock IfException, ArrayRef<Value> Args, ArrayRef<OperandBundleDefT<Value>> Bundles, int Values2, Twine NameStr, Instruction InsertBefore) {
        super(Ty.getReturnType(), 5, (type.ptr<Use>)((type.ptr)OperandTraitsInvokeInst.op_end(User.$BEING_CREATED()).$sub(Values2)), Values2, InsertBefore);
        this.$OperandBundleUser();
        this.AttributeList = new AttributeSet();
        this.init(Ty, Func, IfNormal, IfException, (ArrayRef<Value>)new ArrayRef(Args), (ArrayRef<OperandBundleDefT<Value>>)new ArrayRef(Bundles), NameStr);
    }

    private InvokeInst(IRJavaDifferentiators.JD.Value.P_BasicBlock.P_ArrayRef.Value.P_ArrayRef.OperandBundleDefT.P_UInt_Twine.C_BasicBlock.P _dparam, Value Func, BasicBlock IfNormal, BasicBlock IfException, ArrayRef<Value> Args, ArrayRef<OperandBundleDefT<Value>> Bundles, int Values2, Twine NameStr, BasicBlock InsertAtEnd) {
        super(IrRTTI.cast_FunctionType(IrRTTI.cast_PointerType(Func.getType()).getElementType()).getReturnType(), 5, (type.ptr<Use>)((type.ptr)OperandTraitsInvokeInst.op_end(User.$BEING_CREATED()).$sub(Values2)), Values2, InsertAtEnd);
        this.$OperandBundleUser();
        this.AttributeList = new AttributeSet();
        this.init(Func, IfNormal, IfException, (ArrayRef<Value>)new ArrayRef(Args), (ArrayRef<OperandBundleDefT<Value>>)new ArrayRef(Bundles), NameStr);
    }

    @Override
    public boolean hasDescriptor() {
        return this.HasDescriptor;
    }

    protected InvokeInst cloneImpl() {
        if (this.hasOperandBundles()) {
            int DescriptorBytes = this.getNumOperandBundles() * IrSizeofAndAlignment.$sizeof_BundleOpInfo();
            return (InvokeInst)User.$new_FixedUsesAndDesc(this.getNumOperands(), DescriptorBytes, New$Mem -> new InvokeInst(this));
        }
        return (InvokeInst)User.$new_FixedUses(this.getNumOperands(), New$Mem -> new InvokeInst(this));
    }

    public static InvokeInst Create1(Value Func, BasicBlock IfNormal, BasicBlock IfException, ArrayRef<Value> Args, Twine NameStr) {
        return InvokeInst.Create1(Func, IfNormal, IfException, Args, NameStr, null);
    }

    public static InvokeInst Create1(Value Func, BasicBlock IfNormal, BasicBlock IfException, ArrayRef<Value> Args, Twine NameStr, Instruction InsertBefore) {
        return InvokeInst.Create(IrRTTI.cast_FunctionType(IrRTTI.cast_PointerType(Func.getType()).getElementType()), Func, IfNormal, IfException, (ArrayRef<Value>)new ArrayRef(Args), (ArrayRef<OperandBundleDefT<Value>>)new ArrayRef(llvm.None, false), NameStr, InsertBefore);
    }

    public static InvokeInst Create2(Value Func, BasicBlock IfNormal, BasicBlock IfException, ArrayRef<Value> Args) {
        return InvokeInst.Create2(Func, IfNormal, IfException, Args, (ArrayRef<OperandBundleDefT<Value>>)new ArrayRef(llvm.None, false), new Twine(NativePointer.$EMPTY), null);
    }

    public static InvokeInst Create2(Value Func, BasicBlock IfNormal, BasicBlock IfException, ArrayRef<Value> Args, ArrayRef<OperandBundleDefT<Value>> Bundles) {
        return InvokeInst.Create2(Func, IfNormal, IfException, Args, Bundles, new Twine(NativePointer.$EMPTY), null);
    }

    public static InvokeInst Create2(Value Func, BasicBlock IfNormal, BasicBlock IfException, ArrayRef<Value> Args, ArrayRef<OperandBundleDefT<Value>> Bundles, Twine NameStr) {
        return InvokeInst.Create2(Func, IfNormal, IfException, Args, Bundles, NameStr, null);
    }

    public static InvokeInst Create2(Value Func, BasicBlock IfNormal, BasicBlock IfException, ArrayRef<Value> Args, ArrayRef<OperandBundleDefT<Value>> Bundles, Twine NameStr, Instruction InsertBefore) {
        return InvokeInst.Create(IrRTTI.cast_FunctionType(IrRTTI.cast_PointerType(Func.getType()).getElementType()), Func, IfNormal, IfException, (ArrayRef<Value>)new ArrayRef(Args), (ArrayRef<OperandBundleDefT<Value>>)new ArrayRef(Bundles), NameStr, InsertBefore);
    }

    public static InvokeInst Create(FunctionType Ty, Value Func, BasicBlock IfNormal, BasicBlock IfException, ArrayRef<Value> Args, Twine NameStr) {
        return InvokeInst.Create(Ty, Func, IfNormal, IfException, Args, NameStr, (Instruction)null);
    }

    public static InvokeInst Create(FunctionType Ty, Value Func, BasicBlock IfNormal, BasicBlock IfException, ArrayRef<Value> Args, Twine NameStr, Instruction InsertBefore) {
        int Values2 = Args.size() + 3;
        return (InvokeInst)User.$new_FixedUses(Values2, New$Mem -> new InvokeInst(Ty, Func, IfNormal, IfException, (ArrayRef<Value>)new ArrayRef(Args), (ArrayRef<OperandBundleDefT<Value>>)new ArrayRef(llvm.None, false), Values2, NameStr, InsertBefore));
    }

    public static InvokeInst Create(FunctionType Ty, Value Func, BasicBlock IfNormal, BasicBlock IfException, ArrayRef<Value> Args) {
        return InvokeInst.Create(Ty, Func, IfNormal, IfException, Args, (ArrayRef<OperandBundleDefT<Value>>)new ArrayRef(llvm.None, false), new Twine(NativePointer.$EMPTY), null);
    }

    public static InvokeInst Create(FunctionType Ty, Value Func, BasicBlock IfNormal, BasicBlock IfException, ArrayRef<Value> Args, ArrayRef<OperandBundleDefT<Value>> Bundles) {
        return InvokeInst.Create(Ty, Func, IfNormal, IfException, Args, Bundles, new Twine(NativePointer.$EMPTY), null);
    }

    public static InvokeInst Create(FunctionType Ty, Value Func, BasicBlock IfNormal, BasicBlock IfException, ArrayRef<Value> Args, ArrayRef<OperandBundleDefT<Value>> Bundles, Twine NameStr) {
        return InvokeInst.Create(Ty, Func, IfNormal, IfException, Args, Bundles, NameStr, null);
    }

    public static InvokeInst Create(FunctionType Ty, Value Func, BasicBlock IfNormal, BasicBlock IfException, ArrayRef<Value> Args, ArrayRef<OperandBundleDefT<Value>> Bundles, Twine NameStr, Instruction InsertBefore) {
        int Values2 = Args.size() + OperandBundleUser.CountBundleInputs((ArrayRef<OperandBundleDefT<Value>>)new ArrayRef(Bundles)) + 3;
        int DescriptorBytes = Bundles.size() * IrSizeofAndAlignment.$sizeof_BundleOpInfo();
        return (InvokeInst)User.$new_FixedUsesAndDesc(Values2, DescriptorBytes, New$Mem -> new InvokeInst(Ty, Func, IfNormal, IfException, (ArrayRef<Value>)new ArrayRef(Args), (ArrayRef<OperandBundleDefT<Value>>)new ArrayRef(Bundles), Values2, NameStr, InsertBefore));
    }

    public static InvokeInst Create3(Value Func, BasicBlock IfNormal, BasicBlock IfException, ArrayRef<Value> Args, Twine NameStr, BasicBlock InsertAtEnd) {
        int Values2 = Args.size() + 3;
        return (InvokeInst)User.$new_FixedUses(Values2, New$Mem -> new InvokeInst(IRJavaDifferentiators.JD.Value.P_BasicBlock.P_ArrayRef.Value.P_ArrayRef.OperandBundleDefT.P_UInt_Twine.C_BasicBlock.P.INSTANCE, Func, IfNormal, IfException, (ArrayRef<Value>)new ArrayRef(Args), (ArrayRef<OperandBundleDefT<Value>>)new ArrayRef(llvm.None, false), Values2, NameStr, InsertAtEnd));
    }

    public static InvokeInst Create4(Value Func, BasicBlock IfNormal, BasicBlock IfException, ArrayRef<Value> Args, ArrayRef<OperandBundleDefT<Value>> Bundles, Twine NameStr, BasicBlock InsertAtEnd) {
        int Values2 = Args.size() + OperandBundleUser.CountBundleInputs((ArrayRef<OperandBundleDefT<Value>>)new ArrayRef(Bundles)) + 3;
        int DescriptorBytes = Bundles.size() * IrSizeofAndAlignment.$sizeof_BundleOpInfo();
        return (InvokeInst)User.$new_FixedUsesAndDesc(Values2, DescriptorBytes, New$Mem -> new InvokeInst(IRJavaDifferentiators.JD.Value.P_BasicBlock.P_ArrayRef.Value.P_ArrayRef.OperandBundleDefT.P_UInt_Twine.C_BasicBlock.P.INSTANCE, Func, IfNormal, IfException, (ArrayRef<Value>)new ArrayRef(Args), (ArrayRef<OperandBundleDefT<Value>>)new ArrayRef(Bundles), Values2, NameStr, InsertAtEnd));
    }

    public static InvokeInst Create(InvokeInst II, ArrayRef<OperandBundleDefT<Value>> OpB) {
        return InvokeInst.Create(II, OpB, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InvokeInst Create(InvokeInst II, ArrayRef<OperandBundleDefT<Value>> OpB, Instruction InsertPt) {
        std.vector Args = null;
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            NativeCallback.Converter $C = U -> U.$Value$P();
            Args = new std.vector(II.arg_begin(), II.arg_end(), (Object)null, $C);
            InvokeInst NewII = InvokeInst.Create2(II.getCalledValue(), II.getNormalDest(), II.getUnwindDest(), (ArrayRef<Value>)new ArrayRef(Args, true), (ArrayRef<OperandBundleDefT<Value>>)new ArrayRef(OpB), new Twine(II.getName()), InsertPt);
            NewII.setCallingConv(II.getCallingConv());
            NewII.SubclassOptionalData = Unsigned.$uchar2uchar_7bits((byte)Unsigned.$7bits_uchar2uchar((byte)II.SubclassOptionalData));
            NewII.setAttributes(II.getAttributes());
            NewII.setDebugLoc((DebugLoc)$c$.track((Object)new DebugLoc(II.getDebugLoc())));
            $c$.clean();
            InvokeInst invokeInst = NewII;
            return invokeInst;
        }
        finally {
            if (Args != null) {
                Args.$destroy();
            }
            $c$.$destroy();
        }
    }

    @Override
    public Value getOperand(int i_nocapture) {
        assert (Unsigned.$less_uint((int)i_nocapture, (int)OperandTraitsInvokeInst.operands(this))) : "getOperand() out of range!";
        return IrRTTI.cast_or_null_Value(((Use)OperandTraitsInvokeInst.op_begin(this).$at(i_nocapture)).get());
    }

    @Override
    public void setOperand(int i_nocapture, Value Val_nocapture) {
        assert (Unsigned.$less_uint((int)i_nocapture, (int)OperandTraitsInvokeInst.operands(this))) : "setOperand() out of range!";
        ((Use)OperandTraitsInvokeInst.op_begin(this).$at(i_nocapture)).$assign(Val_nocapture);
    }

    @Override
    public type.ptr<Use> op_begin() {
        return OperandTraitsInvokeInst.op_begin(this);
    }

    @Override
    public type.ptr<Use> op_begin$Const() {
        return OperandTraitsInvokeInst.op_begin(this);
    }

    @Override
    public type.ptr<Use> op_end() {
        return OperandTraitsInvokeInst.op_end(this);
    }

    @Override
    public type.ptr<Use> op_end$Const() {
        return OperandTraitsInvokeInst.op_end(this);
    }

    @Override
    protected Use Op(int Idx_nocapture) {
        return this.OpFrom(Idx_nocapture, this);
    }

    @Override
    protected Use Op$Const(int Idx_nocapture) {
        return this.OpFrom(Idx_nocapture, this);
    }

    @Override
    public int getNumOperands() {
        return OperandTraitsInvokeInst.operands(this);
    }

    public FunctionType getFunctionType() {
        return this.FTy;
    }

    public void mutateFunctionType(FunctionType FTy) {
        this.mutateType(FTy.getReturnType());
        this.FTy = FTy;
    }

    public int getNumArgOperands() {
        return this.getNumOperands() - this.getNumTotalBundleOperands() - 3;
    }

    public Value getArgOperand(int i) {
        assert (Unsigned.$less_uint((int)i, (int)this.getNumArgOperands())) : "Out of bounds!";
        return this.getOperand(i);
    }

    public void setArgOperand(int i, Value v) {
        assert (Unsigned.$less_uint((int)i, (int)this.getNumArgOperands())) : "Out of bounds!";
        this.setOperand(i, v);
    }

    public type.ptr<Use> arg_begin() {
        return this.op_begin();
    }

    public type.ptr<Use> arg_end() {
        return (type.ptr)((type.ptr)this.op_end().$sub(this.getNumTotalBundleOperands())).$sub(3);
    }

    public iterator_range<Use> arg_operands() {
        return llvm.make_range(this.arg_begin(), this.arg_end());
    }

    public type.ptr<Use> arg_begin$Const() {
        return this.op_begin$Const();
    }

    public type.ptr<Use> arg_end$Const() {
        return (type.ptr)((type.ptr)this.op_end$Const().$sub(this.getNumTotalBundleOperands())).$sub(3);
    }

    public iterator_range<Use> arg_operands$Const() {
        return llvm.make_range(this.arg_begin$Const(), this.arg_end$Const());
    }

    public Use getArgOperandUse$Const(int i) {
        assert (Unsigned.$less_uint((int)i, (int)this.getNumArgOperands())) : "Out of bounds!";
        return this.getOperandUse$Const(i);
    }

    public Use getArgOperandUse(int i) {
        assert (Unsigned.$less_uint((int)i, (int)this.getNumArgOperands())) : "Out of bounds!";
        return this.getOperandUse(i);
    }

    public Value getReturnedArgOperand() {
        uint.ptr Index = NativePointer.create_uint$ptr();
        if (this.AttributeList.hasAttrSomewhere(Attribute.AttrKind.Returned, (uint.ptr)Native.$AddrOf((Object)Index)) && Index.$star() != 0) {
            return this.getArgOperand(Index.$star() - 1);
        }
        Function F = this.getCalledFunction();
        if (F != null && F.getAttributes().hasAttrSomewhere(Attribute.AttrKind.Returned, (uint.ptr)Native.$AddrOf((Object)Index)) && Index.$star() != 0) {
            return this.getArgOperand(Index.$star() - 1);
        }
        return null;
    }

    public int getCallingConv() {
        return this.getSubclassDataFromInstruction();
    }

    public void setCallingConv(int CC) {
        int ID2 = CC;
        assert ((ID2 & 0xFFFFFC00) == 0) : "Unsupported calling convention";
        this.setInstructionSubclassData_InvokeInst(Unsigned.$uint2ushort((int)ID2));
    }

    public AttributeSet getAttributes() {
        return this.AttributeList;
    }

    public void setAttributes(AttributeSet Attrs) {
        this.AttributeList.$assign(Attrs);
    }

    public void addAttribute(int i, Attribute.AttrKind Kind2) {
        AttributeSet PAL = new AttributeSet(this.getAttributes());
        PAL.$assignMove(PAL.addAttribute(this.getContext(), i, Kind2));
        this.setAttributes(PAL);
    }

    public void addAttribute(int i, Attribute Attr) {
        AttributeSet PAL = new AttributeSet(this.getAttributes());
        PAL.$assignMove(PAL.addAttribute(this.getContext(), new ArrayRefUInt(i), new Attribute(Attr)));
        this.setAttributes(PAL);
    }

    public void removeAttribute(int i, Attribute.AttrKind Kind2) {
        AttributeSet PAL = new AttributeSet(this.getAttributes());
        PAL.$assignMove(PAL.removeAttribute(this.getContext(), i, Kind2));
        this.setAttributes(PAL);
    }

    public void removeAttribute(int i, StringRef Kind2) {
        AttributeSet PAL = new AttributeSet(this.getAttributes());
        PAL.$assignMove(PAL.removeAttribute(this.getContext(), i, new StringRef(Kind2)));
        this.setAttributes(PAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(int i, Attribute Attr) {
        AttrBuilder B2 = null;
        try {
            AttributeSet PAL = new AttributeSet(this.getAttributes());
            B2 = new AttrBuilder(Attr);
            PAL.$assignMove(PAL.removeAttributes(this.getContext(), i, AttributeSet.get(this.getContext(), i, B2)));
            this.setAttributes(PAL);
        }
        finally {
            if (B2 != null) {
                B2.$destroy();
            }
        }
    }

    public void addDereferenceableAttr(int i, long Bytes) {
        AttributeSet PAL = new AttributeSet(this.getAttributes());
        PAL.$assignMove(PAL.addDereferenceableAttr(this.getContext(), i, Bytes));
        this.setAttributes(PAL);
    }

    public void addDereferenceableOrNullAttr(int i, long Bytes) {
        AttributeSet PAL = new AttributeSet(this.getAttributes());
        PAL.$assignMove(PAL.addDereferenceableOrNullAttr(this.getContext(), i, Bytes));
        this.setAttributes(PAL);
    }

    public boolean hasFnAttr(Attribute.AttrKind Kind2) {
        assert (Kind2 != Attribute.AttrKind.NoBuiltin) : "Use CallInst::isNoBuiltin() to check for Attribute::NoBuiltin";
        return this.hasFnAttrImpl(Kind2);
    }

    public boolean hasFnAttr(StringRef Kind2) {
        return this.hasFnAttrImpl(new StringRef(Kind2));
    }

    public boolean paramHasAttr(int i, Attribute.AttrKind Kind2) {
        assert (Unsigned.$less_uint((int)i, (int)(this.getNumArgOperands() + 1))) : "Param index out of bounds!";
        if (this.AttributeList.hasAttribute(i, Kind2)) {
            return true;
        }
        Function F = this.getCalledFunction();
        if (F != null) {
            return F.getAttributes().hasAttribute(i, Kind2);
        }
        return false;
    }

    public Attribute getAttribute(int i, Attribute.AttrKind Kind2) {
        return this.getAttributes().getAttribute(i, Kind2);
    }

    public Attribute getAttribute(int i, StringRef Kind2) {
        return this.getAttributes().getAttribute(i, new StringRef(Kind2));
    }

    public boolean dataOperandHasImpliedAttr(int i, Attribute.AttrKind Kind2) {
        assert (Unsigned.$less_uint((int)i, (int)(this.getNumOperands() - 2))) : "Data operand index out of bounds!";
        if (Unsigned.$less_uint((int)i, (int)(this.getNumArgOperands() + 1))) {
            return this.paramHasAttr(i, Kind2);
        }
        assert (this.hasOperandBundles() && Unsigned.$greatereq_uint((int)i, (int)(this.getBundleOperandsStartIndex() + 1))) : "Must be either an invoke argument or an operand bundle!";
        return this.bundleOperandHasAttr(i - 1, Kind2);
    }

    public int getParamAlignment(int i) {
        return this.AttributeList.getParamAlignment(i);
    }

    public long getDereferenceableBytes(int i) {
        return this.AttributeList.getDereferenceableBytes(i);
    }

    public long getDereferenceableOrNullBytes(int i) {
        return this.AttributeList.getDereferenceableOrNullBytes(i);
    }

    public boolean doesNotAlias(int n) {
        return this.AttributeList.hasAttribute(n, Attribute.AttrKind.NoAlias);
    }

    public boolean isNoBuiltin() {
        return this.hasFnAttrImpl(Attribute.AttrKind.NoBuiltin) && !this.hasFnAttrImpl(Attribute.AttrKind.Builtin);
    }

    public boolean isNoInline() {
        return this.hasFnAttr(Attribute.AttrKind.NoInline);
    }

    public void setIsNoInline() {
        this.addAttribute(AttributeSet.AttrIndex.FunctionIndex.getValue(), Attribute.AttrKind.NoInline);
    }

    public boolean doesNotAccessMemory() {
        return this.hasFnAttr(Attribute.AttrKind.ReadNone);
    }

    public void setDoesNotAccessMemory() {
        this.addAttribute(AttributeSet.AttrIndex.FunctionIndex.getValue(), Attribute.AttrKind.ReadNone);
    }

    public boolean onlyReadsMemory() {
        return this.doesNotAccessMemory() || this.hasFnAttr(Attribute.AttrKind.ReadOnly);
    }

    public void setOnlyReadsMemory() {
        this.addAttribute(AttributeSet.AttrIndex.FunctionIndex.getValue(), Attribute.AttrKind.ReadOnly);
    }

    public boolean doesNotReadMemory() {
        return this.doesNotAccessMemory() || this.hasFnAttr(Attribute.AttrKind.WriteOnly);
    }

    public void setDoesNotReadMemory() {
        this.addAttribute(AttributeSet.AttrIndex.FunctionIndex.getValue(), Attribute.AttrKind.WriteOnly);
    }

    public boolean onlyAccessesArgMemory() {
        return this.hasFnAttr(Attribute.AttrKind.ArgMemOnly);
    }

    public void setOnlyAccessesArgMemory() {
        this.addAttribute(AttributeSet.AttrIndex.FunctionIndex.getValue(), Attribute.AttrKind.ArgMemOnly);
    }

    public boolean doesNotReturn() {
        return this.hasFnAttr(Attribute.AttrKind.NoReturn);
    }

    public void setDoesNotReturn() {
        this.addAttribute(AttributeSet.AttrIndex.FunctionIndex.getValue(), Attribute.AttrKind.NoReturn);
    }

    public boolean doesNotThrow() {
        return this.hasFnAttr(Attribute.AttrKind.NoUnwind);
    }

    public void setDoesNotThrow() {
        this.addAttribute(AttributeSet.AttrIndex.FunctionIndex.getValue(), Attribute.AttrKind.NoUnwind);
    }

    public boolean cannotDuplicate() {
        return this.hasFnAttr(Attribute.AttrKind.NoDuplicate);
    }

    public void setCannotDuplicate() {
        this.addAttribute(AttributeSet.AttrIndex.FunctionIndex.getValue(), Attribute.AttrKind.NoDuplicate);
    }

    public boolean isConvergent() {
        return this.hasFnAttr(Attribute.AttrKind.Convergent);
    }

    public void setConvergent() {
        this.addAttribute(AttributeSet.AttrIndex.FunctionIndex.getValue(), Attribute.AttrKind.Convergent);
    }

    public void setNotConvergent() {
        this.removeAttribute(AttributeSet.AttrIndex.FunctionIndex.getValue(), Attribute.get(this.getContext(), Attribute.AttrKind.Convergent));
    }

    public boolean hasStructRetAttr() {
        if (this.getNumArgOperands() == 0) {
            return false;
        }
        return this.paramHasAttr(1, Attribute.AttrKind.StructRet);
    }

    public boolean hasByValArgument() {
        return this.AttributeList.hasAttrSomewhere(Attribute.AttrKind.ByVal);
    }

    public Function getCalledFunction() {
        return IrRTTI.dyn_cast_Function(this.Op$Const(-3));
    }

    public Value getCalledValue$Const() {
        return this.Op$Const(-3).$Value$P();
    }

    public Value getCalledValue() {
        return this.Op(-3).$Value$P();
    }

    public void setCalledFunction(Value Fn) {
        this.setCalledFunction(IrRTTI.cast_FunctionType(IrRTTI.cast_PointerType(Fn.getType()).getElementType()), Fn);
    }

    public void setCalledFunction(FunctionType FTy, Value Fn) {
        this.FTy = FTy;
        assert (FTy == IrRTTI.cast_FunctionType(IrRTTI.cast_PointerType(Fn.getType()).getElementType()));
        this.Op(-3).$assign(Fn);
    }

    public BasicBlock getNormalDest() {
        return IrRTTI.cast_BasicBlock(this.Op$Const(-2));
    }

    public BasicBlock getUnwindDest() {
        return IrRTTI.cast_BasicBlock(this.Op$Const(-1));
    }

    public void setNormalDest(BasicBlock B2) {
        this.Op(-2).$assign((Value)Casts.reinterpret_cast(Value.class, (Object)B2));
    }

    public void setUnwindDest(BasicBlock B2) {
        this.Op(-1).$assign((Value)Casts.reinterpret_cast(Value.class, (Object)B2));
    }

    public LandingPadInst getLandingPadInst() {
        return IrRTTI.cast_LandingPadInst(this.getUnwindDest().getFirstNonPHI());
    }

    @Override
    public BasicBlock getSuccessor(int i) {
        assert (Unsigned.$less_uint((int)i, (int)2)) : "Successor # out of range for invoke!";
        return i == 0 ? this.getNormalDest() : this.getUnwindDest();
    }

    @Override
    public void setSuccessor(int idx, BasicBlock NewSucc) {
        assert (Unsigned.$less_uint((int)idx, (int)2)) : "Successor # out of range for invoke!";
        ((Use)((type.ptr)this.Op$Addr(-2).$add(idx)).$star()).$assign((Value)Casts.reinterpret_cast(Value.class, (Object)NewSucc));
    }

    @Override
    public int getNumSuccessors() {
        return 2;
    }

    public static boolean classof(Instruction I) {
        return I.getOpcode() == 5;
    }

    public static boolean classof(Value V) {
        return IrRTTI.isa_Instruction(V) && InvokeInst.classof(IrRTTI.cast_Instruction(V));
    }

    @Override
    protected BasicBlock getSuccessorV(int idx) {
        return this.getSuccessor(idx);
    }

    @Override
    protected int getNumSuccessorsV() {
        return this.getNumSuccessors();
    }

    @Override
    protected void setSuccessorV(int idx, BasicBlock B2) {
        this.setSuccessor(idx, B2);
    }

    private boolean hasFnAttrImpl(Attribute.AttrKind A2) {
        if (this.AttributeList.hasAttribute(AttributeSet.AttrIndex.FunctionIndex.getValue(), A2)) {
            return true;
        }
        if (this.isFnAttrDisallowedByOpBundle(A2)) {
            return false;
        }
        Function F = this.getCalledFunction();
        if (F != null) {
            return F.getAttributes().hasAttribute(AttributeSet.AttrIndex.FunctionIndex.getValue(), A2);
        }
        return false;
    }

    private boolean hasFnAttrImpl(StringRef A2) {
        if (this.AttributeList.hasAttribute(AttributeSet.AttrIndex.FunctionIndex.getValue(), A2)) {
            return true;
        }
        if (this.isFnAttrDisallowedByOpBundle(A2)) {
            return false;
        }
        Function F = this.getCalledFunction();
        if (F != null) {
            return F.getAttributes().hasAttribute(AttributeSet.AttrIndex.FunctionIndex.getValue(), A2);
        }
        return false;
    }

    private void setInstructionSubclassData_InvokeInst(char D2) {
        super.setInstructionSubclassData(D2);
    }

    @Override
    public void $destroy() {
        super.$destroy();
        OperandBundleUser.super.$destroy$OperandBundleUser();
    }

    public void addAttribute(int i, StringRef Kind2, StringRef Value2) {
        AttributeSet PAL = new AttributeSet(this.getAttributes());
        PAL.$assignMove(PAL.addAttribute(this.getContext(), i, Kind2));
        this.setAttributes(PAL);
    }

    @Override
    public String toString() {
        return "AttributeList=" + this.AttributeList + ", FTy=" + this.FTy + super.toString();
    }
}

