/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.Native;
import org.clank.support.NativeCallback;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.clank.support.aliases.ulong;
import org.llvm.adt.SmallSetUInt;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.ArrayRefUInt;
import org.llvm.adt.aliases.DenseMap;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.adt.ilist_iterator;
import org.llvm.adt.ilist_node;
import org.llvm.adt.ilist_node_with_parent;
import org.llvm.ir.AAMDNodes;
import org.llvm.ir.BasicBlock;
import org.llvm.ir.CallInst;
import org.llvm.ir.CatchSwitchInst;
import org.llvm.ir.CleanupReturnInst;
import org.llvm.ir.ConstantInt;
import org.llvm.ir.DebugLoc;
import org.llvm.ir.FPMathOperator;
import org.llvm.ir.FastMathFlags;
import org.llvm.ir.Function;
import org.llvm.ir.GetElementPtrInst;
import org.llvm.ir.LLVMContext;
import org.llvm.ir.MDNode;
import org.llvm.ir.MDString;
import org.llvm.ir.Module$IR;
import org.llvm.ir.OverflowingBinaryOperator;
import org.llvm.ir.PHINode;
import org.llvm.ir.PossiblyExactOperator;
import org.llvm.ir.Type;
import org.llvm.ir.TypedTrackingMDRef;
import org.llvm.ir.Use;
import org.llvm.ir.User;
import org.llvm.ir.Value;
import org.llvm.ir.impl.InstructionStatics;
import org.llvm.ir.impl.MDAttachmentMap;
import org.llvm.ir.java.IChild;
import org.llvm.ir.java.IrRTTI;
import org.llvm.ir.mdconst.MdconstGlobals;
import org.llvm.support.AtomicOrdering;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;

public class Instruction
extends User
implements ilist_node_with_parent<Instruction, BasicBlock>,
IChild<BasicBlock>,
Destructors.ClassWithDestructor {
    private BasicBlock Parent;
    private DebugLoc DbgLoc;
    public static final int HasMetadataBit = 32768;
    private final ilist_node.ilist_node.Fields ilist_node$Flds;

    protected void $assign(Instruction $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    protected Instruction(Instruction $Prm0) {
        super($Prm0);
        throw new UnsupportedOperationException("Deleted");
    }

    @Override
    public void $destroy() {
        assert (this.Parent == null) : "Instruction still linked in the program!";
        if (this.hasMetadataHashEntry()) {
            this.clearMetadataHashEntries();
        }
        this.DbgLoc.$destroy();
        super.$destroy();
        super.$destroy$ilist_node_with_parent();
    }

    public final Instruction user_back$Instruction() {
        return IrRTTI.cast_Instruction((Value)this.user_begin().$star());
    }

    public final Instruction user_back$Instruction$Const() {
        return IrRTTI.cast_Instruction((Value)this.user_begin$Const().$star());
    }

    public BasicBlock getParent$Const() {
        return this.Parent;
    }

    @Override
    public BasicBlock getParent() {
        return this.Parent;
    }

    public Module$IR getModule$Const() {
        return this.getParent$Const().getModule$Const();
    }

    public Module$IR getModule() {
        return this.getParent().getModule();
    }

    public Function getFunction$Const() {
        return this.getParent$Const().getParent$Const();
    }

    public Function getFunction() {
        return this.getParent().getParent();
    }

    public void removeFromParent() {
        this.getParent().getInstList().remove_ilist_iterator$NodeTy$C(this.getIterator());
    }

    public ilist_iterator<Instruction> eraseFromParent() {
        return this.getParent().getInstList().erase(this.getIterator());
    }

    public void insertBefore(Instruction InsertPos) {
        InsertPos.getParent().getInstList().insert_ilist_iterator$NodeTy_T$P(InsertPos.getIterator(), (ilist_node)this);
    }

    public void insertAfter(Instruction InsertPos) {
        InsertPos.getParent().getInstList().insertAfter(InsertPos.getIterator(), (ilist_node)this);
    }

    public void moveBefore(Instruction MovePos) {
        MovePos.getParent().getInstList().splice(MovePos.getIterator(), this.getParent().getInstList(), this.getIterator());
    }

    public int getOpcode() {
        return this.getValueID() - Value.ValueTy.InstructionVal.getValue();
    }

    public char.ptr getOpcodeName() {
        return Instruction.getOpcodeName(this.getOpcode());
    }

    public boolean isTerminator() {
        return Instruction.isTerminator(this.getOpcode());
    }

    public boolean isBinaryOp() {
        return Instruction.isBinaryOp(this.getOpcode());
    }

    public boolean isShift() {
        return Instruction.isShift(this.getOpcode());
    }

    public boolean isCast() {
        return Instruction.isCast(this.getOpcode());
    }

    public boolean isFuncletPad() {
        return Instruction.isFuncletPad(this.getOpcode());
    }

    public static char.ptr getOpcodeName(int OpCode) {
        switch (OpCode) {
            case 1: {
                return NativePointer.$((String)"ret");
            }
            case 2: {
                return NativePointer.$((String)"br");
            }
            case 3: {
                return NativePointer.$switch;
            }
            case 4: {
                return NativePointer.$((String)"indirectbr");
            }
            case 5: {
                return NativePointer.$((String)"invoke");
            }
            case 6: {
                return NativePointer.$((String)"resume");
            }
            case 7: {
                return NativePointer.$((String)"unreachable");
            }
            case 8: {
                return NativePointer.$((String)"cleanupret");
            }
            case 9: {
                return NativePointer.$((String)"catchret");
            }
            case 50: {
                return NativePointer.$((String)"catchpad");
            }
            case 10: {
                return NativePointer.$((String)"catchswitch");
            }
            case 11: {
                return NativePointer.$((String)"add");
            }
            case 12: {
                return NativePointer.$((String)"fadd");
            }
            case 13: {
                return NativePointer.$((String)"sub");
            }
            case 14: {
                return NativePointer.$((String)"fsub");
            }
            case 15: {
                return NativePointer.$((String)"mul");
            }
            case 16: {
                return NativePointer.$((String)"fmul");
            }
            case 17: {
                return NativePointer.$((String)"udiv");
            }
            case 18: {
                return NativePointer.$((String)"sdiv");
            }
            case 19: {
                return NativePointer.$((String)"fdiv");
            }
            case 20: {
                return NativePointer.$((String)"urem");
            }
            case 21: {
                return NativePointer.$((String)"srem");
            }
            case 22: {
                return NativePointer.$((String)"frem");
            }
            case 26: {
                return NativePointer.$((String)"and");
            }
            case 27: {
                return NativePointer.$((String)"or");
            }
            case 28: {
                return NativePointer.$((String)"xor");
            }
            case 29: {
                return NativePointer.$((String)"alloca");
            }
            case 30: {
                return NativePointer.$((String)"load");
            }
            case 31: {
                return NativePointer.$((String)"store");
            }
            case 34: {
                return NativePointer.$((String)"cmpxchg");
            }
            case 35: {
                return NativePointer.$((String)"atomicrmw");
            }
            case 33: {
                return NativePointer.$((String)"fence");
            }
            case 32: {
                return NativePointer.$((String)"getelementptr");
            }
            case 36: {
                return NativePointer.$((String)"trunc");
            }
            case 37: {
                return NativePointer.$((String)"zext");
            }
            case 38: {
                return NativePointer.$((String)"sext");
            }
            case 43: {
                return NativePointer.$((String)"fptrunc");
            }
            case 44: {
                return NativePointer.$((String)"fpext");
            }
            case 39: {
                return NativePointer.$((String)"fptoui");
            }
            case 40: {
                return NativePointer.$((String)"fptosi");
            }
            case 41: {
                return NativePointer.$((String)"uitofp");
            }
            case 42: {
                return NativePointer.$((String)"sitofp");
            }
            case 46: {
                return NativePointer.$((String)"inttoptr");
            }
            case 45: {
                return NativePointer.$((String)"ptrtoint");
            }
            case 47: {
                return NativePointer.$((String)"bitcast");
            }
            case 48: {
                return NativePointer.$((String)"addrspacecast");
            }
            case 51: {
                return NativePointer.$((String)"icmp");
            }
            case 52: {
                return NativePointer.$((String)"fcmp");
            }
            case 53: {
                return NativePointer.$((String)"phi");
            }
            case 55: {
                return NativePointer.$((String)"select");
            }
            case 54: {
                return NativePointer.$((String)"call");
            }
            case 23: {
                return NativePointer.$((String)"shl");
            }
            case 24: {
                return NativePointer.$((String)"lshr");
            }
            case 25: {
                return NativePointer.$((String)"ashr");
            }
            case 58: {
                return NativePointer.$((String)"va_arg");
            }
            case 59: {
                return NativePointer.$((String)"extractelement");
            }
            case 60: {
                return NativePointer.$((String)"insertelement");
            }
            case 61: {
                return NativePointer.$((String)"shufflevector");
            }
            case 62: {
                return NativePointer.$((String)"extractvalue");
            }
            case 63: {
                return NativePointer.$((String)"insertvalue");
            }
            case 64: {
                return NativePointer.$((String)"landingpad");
            }
            case 49: {
                return NativePointer.$((String)"cleanuppad");
            }
        }
        return NativePointer.$((String)"<Invalid operator> ");
    }

    public static boolean isTerminator(int OpCode) {
        return Unsigned.$greatereq_uint_int((int)OpCode, (int)1) && Unsigned.$less_uint_int((int)OpCode, (int)11);
    }

    public static boolean isBinaryOp(int Opcode) {
        return Unsigned.$greatereq_uint_int((int)Opcode, (int)11) && Unsigned.$less_uint_int((int)Opcode, (int)29);
    }

    public static boolean isShift(int Opcode) {
        return Unsigned.$greatereq_uint_int((int)Opcode, (int)23) && Unsigned.$lesseq_uint_int((int)Opcode, (int)25);
    }

    public boolean isLogicalShift() {
        return this.getOpcode() == 23 || this.getOpcode() == 24;
    }

    public boolean isArithmeticShift() {
        return this.getOpcode() == 25;
    }

    public static boolean isCast(int OpCode) {
        return Unsigned.$greatereq_uint_int((int)OpCode, (int)36) && Unsigned.$less_uint_int((int)OpCode, (int)49);
    }

    public static boolean isFuncletPad(int OpCode) {
        return Unsigned.$greatereq_uint_int((int)OpCode, (int)49) && Unsigned.$less_uint_int((int)OpCode, (int)51);
    }

    public boolean hasMetadata() {
        return this.DbgLoc.$bool() || this.hasMetadataHashEntry();
    }

    public boolean hasMetadataOtherThanDebugLoc() {
        return this.hasMetadataHashEntry();
    }

    public MDNode getMetadata(int KindID) {
        if (!this.hasMetadata()) {
            return null;
        }
        return this.getMetadataImpl(KindID);
    }

    public MDNode getMetadata(StringRef Kind2) {
        if (!this.hasMetadata()) {
            return null;
        }
        return this.getMetadataImpl(new StringRef(Kind2));
    }

    public void getAllMetadata(SmallVectorImpl<std_pair.pairUIntPtr<MDNode>> MDs) {
        if (this.hasMetadata()) {
            this.getAllMetadataImpl(MDs);
        }
    }

    public void getAllMetadataOtherThanDebugLoc(SmallVectorImpl<std_pair.pairUIntPtr<MDNode>> MDs) {
        if (this.hasMetadataOtherThanDebugLoc()) {
            this.getAllMetadataOtherThanDebugLocImpl(MDs);
        }
    }

    public void getAAMetadata(AAMDNodes N) {
        this.getAAMetadata(N, false);
    }

    public void getAAMetadata(AAMDNodes N, boolean Merge) {
        N.TBAA = Merge ? MDNode.getMostGenericTBAA(N.TBAA, this.getMetadata(LLVMContext.Unnamed_enum.MD_tbaa.getValue())) : this.getMetadata(LLVMContext.Unnamed_enum.MD_tbaa.getValue());
        N.Scope = Merge ? MDNode.getMostGenericAliasScope(N.Scope, this.getMetadata(LLVMContext.Unnamed_enum.MD_alias_scope.getValue())) : this.getMetadata(LLVMContext.Unnamed_enum.MD_alias_scope.getValue());
        N.NoAlias = Merge ? MDNode.intersect(N.NoAlias, this.getMetadata(LLVMContext.Unnamed_enum.MD_noalias.getValue())) : this.getMetadata(LLVMContext.Unnamed_enum.MD_noalias.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMetadata(int KindID, MDNode Node2) {
        if (Node2 == null && !this.hasMetadata()) {
            return;
        }
        if (KindID == LLVMContext.Unnamed_enum.MD_dbg.getValue()) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                $c$.clean((Object)this.DbgLoc.$assignMove((DebugLoc)$c$.track((Object)new DebugLoc(Node2))));
                return;
            }
            finally {
                $c$.$destroy();
            }
        }
        if (Node2 != null) {
            MDAttachmentMap Info = (MDAttachmentMap)this.getContext().pImpl.InstructionMetadata.$at_T1$RR((Object)this);
            assert (!Info.empty() == this.hasMetadataHashEntry()) : "HasMetadata bit is wonked";
            if (Info.empty()) {
                this.setHasMetadataHashEntry(true);
            }
            Info.set(KindID, (MDNode)Native.$Deref((Object)Node2));
            return;
        }
        assert (this.hasMetadataHashEntry() == Unsigned.$greater_uint((int)this.getContext().pImpl.InstructionMetadata.count((Object)this), (int)0)) : "HasMetadata bit out of date!";
        if (!this.hasMetadataHashEntry()) {
            return;
        }
        MDAttachmentMap Info = (MDAttachmentMap)this.getContext().pImpl.InstructionMetadata.$at_T1$RR((Object)this);
        Info.erase(KindID);
        if (!Info.empty()) {
            return;
        }
        this.getContext().pImpl.InstructionMetadata.erase((Object)this);
        this.setHasMetadataHashEntry(false);
    }

    public void setMetadata(StringRef Kind2, MDNode Node2) {
        if (Node2 == null && !this.hasMetadata()) {
            return;
        }
        this.setMetadata(this.getContext().getMDKindID(new StringRef(Kind2)), Node2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropUnknownNonDebugMetadata(ArrayRefUInt KnownIDs) {
        SmallSetUInt KnownSet = null;
        try {
            KnownSet = new SmallSetUInt(5);
            KnownSet.insert$T(KnownIDs.begin(), KnownIDs.end());
            if (!this.hasMetadataHashEntry()) {
                return;
            }
            DenseMap<Instruction, MDAttachmentMap> InstructionMetadata = this.getContext().pImpl.InstructionMetadata;
            if (KnownSet.empty()) {
                InstructionMetadata.erase((Object)this);
                this.setHasMetadataHashEntry(false);
                return;
            }
            MDAttachmentMap Info = (MDAttachmentMap)InstructionMetadata.$at_T1$RR((Object)this);
            SmallSetUInt KnownSet$Final = KnownSet;
            Info.remove_if((NativeCallback.BoolPredicate<std_pair.pairUIntType<TypedTrackingMDRef<MDNode>>>)((NativeCallback.BoolPredicate)I -> KnownSet$Final.count(I.first) == 0));
            if (Info.empty()) {
                InstructionMetadata.erase((Object)this);
                this.setHasMetadataHashEntry(false);
            }
        }
        finally {
            if (KnownSet != null) {
                KnownSet.$destroy();
            }
        }
    }

    public void dropUnknownNonDebugMetadata() {
        this.dropUnknownNonDebugMetadata(new ArrayRefUInt(llvm.None));
    }

    public void dropUnknownNonDebugMetadata(int ID1) {
        this.dropUnknownNonDebugMetadata(llvm.makeArrayRef$UInt((int)ID1, (boolean)false));
    }

    public void dropUnknownNonDebugMetadata(int ID1, int ID2) {
        int[] IDs = new int[]{ID1, ID2};
        this.dropUnknownNonDebugMetadata(new ArrayRefUInt(IDs));
    }

    public void setAAMetadata(AAMDNodes N) {
        this.setMetadata(LLVMContext.Unnamed_enum.MD_tbaa.getValue(), N.TBAA);
        this.setMetadata(LLVMContext.Unnamed_enum.MD_alias_scope.getValue(), N.Scope);
        this.setMetadata(LLVMContext.Unnamed_enum.MD_noalias.getValue(), N.NoAlias);
    }

    public boolean extractProfMetadata(ulong.ref TrueVal, ulong.ref FalseVal) {
        assert (this.getOpcode() == 2 || this.getOpcode() == 55) : "Looking for branch weights on something besides branch or select";
        MDNode ProfileData = this.getMetadata(LLVMContext.Unnamed_enum.MD_prof.getValue());
        if (ProfileData == null || ProfileData.getNumOperands() != 3) {
            return false;
        }
        MDString ProfDataName = IrRTTI.dyn_cast_MDString(ProfileData.getOperand(0));
        if (ProfDataName == null || !ProfDataName.getString().equals("branch_weights")) {
            return false;
        }
        ConstantInt CITrue = MdconstGlobals.dyn_extract$ValidPointer(ConstantInt.class, ProfileData.getOperand(1));
        ConstantInt CIFalse = MdconstGlobals.dyn_extract$ValidPointer(ConstantInt.class, ProfileData.getOperand(2));
        if (CITrue == null || CIFalse == null) {
            return false;
        }
        TrueVal.$set(CITrue.getValue().getZExtValue());
        FalseVal.$set(CIFalse.getValue().getZExtValue());
        return true;
    }

    public boolean extractProfTotalWeight(ulong.ref TotalVal) {
        assert (this.getOpcode() == 2 || this.getOpcode() == 55 || this.getOpcode() == 54 || this.getOpcode() == 5) : "Looking for branch weights on something besides branch";
        TotalVal.$set(Unsigned.$int2ulong((int)0));
        MDNode ProfileData = this.getMetadata(LLVMContext.Unnamed_enum.MD_prof.getValue());
        if (ProfileData == null) {
            return false;
        }
        MDString ProfDataName = IrRTTI.dyn_cast_MDString(ProfileData.getOperand(0));
        if (ProfDataName == null || !ProfDataName.getString().equals("branch_weights")) {
            return false;
        }
        TotalVal.$set(Unsigned.$int2ulong((int)0));
        int i = 1;
        while (Unsigned.$less_uint((int)i, (int)ProfileData.getNumOperands())) {
            ConstantInt V = MdconstGlobals.dyn_extract$ValidPointer(ConstantInt.class, ProfileData.getOperand(i));
            if (V == null) {
                return false;
            }
            TotalVal.$set$addassign(V.getValue().getZExtValue());
            ++i;
        }
        return true;
    }

    public void setDebugLoc(DebugLoc Loc) {
        this.DbgLoc.$assignMove((DebugLoc)std.move((Object)Loc));
    }

    public DebugLoc getDebugLoc() {
        return this.DbgLoc;
    }

    public void setHasNoUnsignedWrap() {
        this.setHasNoUnsignedWrap(true);
    }

    public void setHasNoUnsignedWrap(boolean b) {
        IrRTTI.cast_OverflowingBinaryOperator(this).setHasNoUnsignedWrap(b);
    }

    public void setHasNoSignedWrap() {
        this.setHasNoSignedWrap(true);
    }

    public void setHasNoSignedWrap(boolean b) {
        IrRTTI.cast_OverflowingBinaryOperator(this).setHasNoSignedWrap(b);
    }

    public void setIsExact() {
        this.setIsExact(true);
    }

    public void setIsExact(boolean b) {
        IrRTTI.cast_PossiblyExactOperator(this).setIsExact(b);
    }

    public boolean hasNoUnsignedWrap() {
        return IrRTTI.cast_OverflowingBinaryOperator(this).hasNoUnsignedWrap();
    }

    public boolean hasNoSignedWrap() {
        return IrRTTI.cast_OverflowingBinaryOperator(this).hasNoSignedWrap();
    }

    public boolean isExact() {
        return IrRTTI.cast_PossiblyExactOperator(this).isExact();
    }

    public void setHasUnsafeAlgebra(boolean B2) {
        assert (IrRTTI.isa_FPMathOperator(this)) : "setting fast-math flag on invalid op";
        IrRTTI.cast_FPMathOperator(this).setHasUnsafeAlgebra(B2);
    }

    public void setHasNoNaNs(boolean B2) {
        assert (IrRTTI.isa_FPMathOperator(this)) : "setting fast-math flag on invalid op";
        IrRTTI.cast_FPMathOperator(this).setHasNoNaNs(B2);
    }

    public void setHasNoInfs(boolean B2) {
        assert (IrRTTI.isa_FPMathOperator(this)) : "setting fast-math flag on invalid op";
        IrRTTI.cast_FPMathOperator(this).setHasNoInfs(B2);
    }

    public void setHasNoSignedZeros(boolean B2) {
        assert (IrRTTI.isa_FPMathOperator(this)) : "setting fast-math flag on invalid op";
        IrRTTI.cast_FPMathOperator(this).setHasNoSignedZeros(B2);
    }

    public void setHasAllowReciprocal(boolean B2) {
        assert (IrRTTI.isa_FPMathOperator(this)) : "setting fast-math flag on invalid op";
        IrRTTI.cast_FPMathOperator(this).setHasAllowReciprocal(B2);
    }

    public void setFastMathFlags(FastMathFlags FMF) {
        assert (IrRTTI.isa_FPMathOperator(this)) : "setting fast-math flag on invalid op";
        IrRTTI.cast_FPMathOperator(this).setFastMathFlags(new FastMathFlags(FMF));
    }

    public void copyFastMathFlags(FastMathFlags FMF) {
        assert (IrRTTI.isa_FPMathOperator(this)) : "copying fast-math flag on invalid op";
        IrRTTI.cast_FPMathOperator(this).copyFastMathFlags(new FastMathFlags(FMF));
    }

    public boolean hasUnsafeAlgebra() {
        assert (IrRTTI.isa_FPMathOperator(this)) : "getting fast-math flag on invalid op";
        return IrRTTI.cast_FPMathOperator(this).hasUnsafeAlgebra();
    }

    public boolean hasNoNaNs() {
        assert (IrRTTI.isa_FPMathOperator(this)) : "getting fast-math flag on invalid op";
        return IrRTTI.cast_FPMathOperator(this).hasNoNaNs();
    }

    public boolean hasNoInfs() {
        assert (IrRTTI.isa_FPMathOperator(this)) : "getting fast-math flag on invalid op";
        return IrRTTI.cast_FPMathOperator(this).hasNoInfs();
    }

    public boolean hasNoSignedZeros() {
        assert (IrRTTI.isa_FPMathOperator(this)) : "getting fast-math flag on invalid op";
        return IrRTTI.cast_FPMathOperator(this).hasNoSignedZeros();
    }

    public boolean hasAllowReciprocal() {
        assert (IrRTTI.isa_FPMathOperator(this)) : "getting fast-math flag on invalid op";
        return IrRTTI.cast_FPMathOperator(this).hasAllowReciprocal();
    }

    public FastMathFlags getFastMathFlags() {
        assert (IrRTTI.isa_FPMathOperator(this)) : "getting fast-math flag on invalid op";
        return IrRTTI.cast_FPMathOperator(this).getFastMathFlags();
    }

    public void copyFastMathFlags(Instruction I) {
        this.copyFastMathFlags(I.getFastMathFlags());
    }

    public void copyIRFlags(Value V) {
        GetElementPtrInst DestGEP;
        GetElementPtrInst SrcGEP;
        FPMathOperator FP;
        PossiblyExactOperator PE;
        OverflowingBinaryOperator OB = IrRTTI.dyn_cast_OverflowingBinaryOperator(V);
        if (OB != null && IrRTTI.isa_OverflowingBinaryOperator(this)) {
            this.setHasNoSignedWrap(OB.hasNoSignedWrap());
            this.setHasNoUnsignedWrap(OB.hasNoUnsignedWrap());
        }
        if ((PE = IrRTTI.dyn_cast_PossiblyExactOperator(V)) != null && IrRTTI.isa_PossiblyExactOperator(this)) {
            this.setIsExact(PE.isExact());
        }
        if ((FP = IrRTTI.dyn_cast_FPMathOperator(V)) != null && IrRTTI.isa_FPMathOperator(this)) {
            this.copyFastMathFlags(FP.getFastMathFlags());
        }
        if ((SrcGEP = IrRTTI.dyn_cast_GetElementPtrInst(V)) != null && (DestGEP = IrRTTI.dyn_cast_GetElementPtrInst(this)) != null) {
            DestGEP.setIsInBounds((Unsigned.$bool2uint((boolean)SrcGEP.isInBounds()) | Unsigned.$bool2uint((boolean)DestGEP.isInBounds())) != 0);
        }
    }

    public void andIRFlags(Value V) {
        GetElementPtrInst DestGEP;
        GetElementPtrInst SrcGEP;
        FPMathOperator FP;
        PossiblyExactOperator PE;
        OverflowingBinaryOperator OB = IrRTTI.dyn_cast_OverflowingBinaryOperator(V);
        if (OB != null && IrRTTI.isa_OverflowingBinaryOperator(this)) {
            this.setHasNoSignedWrap((Unsigned.$bool2uint((boolean)this.hasNoSignedWrap()) & Unsigned.$bool2uint((boolean)OB.hasNoSignedWrap())) != 0);
            this.setHasNoUnsignedWrap((Unsigned.$bool2uint((boolean)this.hasNoUnsignedWrap()) & Unsigned.$bool2uint((boolean)OB.hasNoUnsignedWrap())) != 0);
        }
        if ((PE = IrRTTI.dyn_cast_PossiblyExactOperator(V)) != null && IrRTTI.isa_PossiblyExactOperator(this)) {
            this.setIsExact((Unsigned.$bool2uint((boolean)this.isExact()) & Unsigned.$bool2uint((boolean)PE.isExact())) != 0);
        }
        if ((FP = IrRTTI.dyn_cast_FPMathOperator(V)) != null && IrRTTI.isa_FPMathOperator(this)) {
            FastMathFlags FM = this.getFastMathFlags();
            FM.$andassign(FP.getFastMathFlags());
            this.copyFastMathFlags(new FastMathFlags(FM));
        }
        if ((SrcGEP = IrRTTI.dyn_cast_GetElementPtrInst(V)) != null && (DestGEP = IrRTTI.dyn_cast_GetElementPtrInst(this)) != null) {
            DestGEP.setIsInBounds((Unsigned.$bool2uint((boolean)SrcGEP.isInBounds()) & Unsigned.$bool2uint((boolean)DestGEP.isInBounds())) != 0);
        }
    }

    private boolean hasMetadataHashEntry() {
        return (Unsigned.$ushort2int((char)this.getSubclassDataFromValue_Instruction()) & 0x8000) != 0;
    }

    private MDNode getMetadataImpl(int KindID) {
        if (KindID == LLVMContext.Unnamed_enum.MD_dbg.getValue()) {
            return this.DbgLoc.getAsMDNode();
        }
        if (!this.hasMetadataHashEntry()) {
            return null;
        }
        MDAttachmentMap Info = (MDAttachmentMap)this.getContext().pImpl.InstructionMetadata.$at_T1$RR((Object)this);
        assert (!Info.empty()) : "bit out of sync with hash table";
        return Info.lookup(KindID);
    }

    private MDNode getMetadataImpl(StringRef Kind2) {
        return this.getMetadataImpl(this.getContext().getMDKindID(new StringRef(Kind2)));
    }

    private void getAllMetadataImpl(SmallVectorImpl<std_pair.pairUIntPtr<MDNode>> Result2) {
        Result2.clear();
        if (this.DbgLoc.$bool()) {
            Result2.push_back((Object)std.make_pair_uint_Ptr((int)LLVMContext.Unnamed_enum.MD_dbg.getValue(), (Object)this.DbgLoc.getAsMDNode()));
            if (!this.hasMetadataHashEntry()) {
                return;
            }
        }
        assert (this.hasMetadataHashEntry() && this.getContext().pImpl.InstructionMetadata.count((Object)this) != 0) : "Shouldn't have called this";
        MDAttachmentMap Info = (MDAttachmentMap)this.getContext().pImpl.InstructionMetadata.find((Object)this).$arrow().second;
        assert (!Info.empty()) : "Shouldn't have called this";
        Info.getAll(Result2);
    }

    private void getAllMetadataOtherThanDebugLocImpl(SmallVectorImpl<std_pair.pairUIntPtr<MDNode>> Result2) {
        Result2.clear();
        assert (this.hasMetadataHashEntry() && this.getContext().pImpl.InstructionMetadata.count((Object)this) != 0) : "Shouldn't have called this";
        MDAttachmentMap Info = (MDAttachmentMap)this.getContext().pImpl.InstructionMetadata.find((Object)this).$arrow().second;
        assert (!Info.empty()) : "Shouldn't have called this";
        Info.getAll(Result2);
    }

    private void clearMetadataHashEntries() {
        assert (this.hasMetadataHashEntry()) : "Caller should check";
        this.getContext().pImpl.InstructionMetadata.erase((Object)this);
        this.setHasMetadataHashEntry(false);
    }

    public boolean isAssociative() {
        int Opcode = this.getOpcode();
        if (Instruction.isAssociative(Opcode)) {
            return true;
        }
        switch (Opcode) {
            case 12: 
            case 16: {
                return IrRTTI.cast_FPMathOperator(this).hasUnsafeAlgebra();
            }
        }
        return false;
    }

    public static boolean isAssociative(int Opcode) {
        return Opcode == 26 || Opcode == 27 || Opcode == 28 || Opcode == 11 || Opcode == 15;
    }

    public boolean isCommutative() {
        return Instruction.isCommutative(this.getOpcode());
    }

    public static boolean isCommutative(int op) {
        switch (op) {
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 26: 
            case 27: 
            case 28: {
                return true;
            }
        }
        return false;
    }

    public boolean isIdempotent() {
        return Instruction.isIdempotent(this.getOpcode());
    }

    public static boolean isIdempotent(int Opcode) {
        return Opcode == 26 || Opcode == 27;
    }

    public boolean isNilpotent() {
        return Instruction.isNilpotent(this.getOpcode());
    }

    public static boolean isNilpotent(int Opcode) {
        return Opcode == 28;
    }

    public boolean mayWriteToMemory() {
        switch (this.getOpcode()) {
            default: {
                return false;
            }
            case 9: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 50: 
            case 58: {
                return true;
            }
            case 54: {
                return !IrRTTI.cast_CallInst(this).onlyReadsMemory();
            }
            case 5: {
                return !IrRTTI.cast_InvokeInst(this).onlyReadsMemory();
            }
            case 30: 
        }
        return !IrRTTI.cast_LoadInst(this).isUnordered();
    }

    public boolean mayReadFromMemory() {
        switch (this.getOpcode()) {
            default: {
                return false;
            }
            case 9: 
            case 30: 
            case 33: 
            case 34: 
            case 35: 
            case 50: 
            case 58: {
                return true;
            }
            case 54: {
                return !IrRTTI.cast_CallInst(this).doesNotAccessMemory();
            }
            case 5: {
                return !IrRTTI.cast_InvokeInst(this).doesNotAccessMemory();
            }
            case 31: 
        }
        return !IrRTTI.cast_StoreInst(this).isUnordered();
    }

    public boolean mayReadOrWriteMemory() {
        return this.mayReadFromMemory() || this.mayWriteToMemory();
    }

    public boolean isAtomic() {
        switch (this.getOpcode()) {
            default: {
                return false;
            }
            case 33: 
            case 34: 
            case 35: {
                return true;
            }
            case 30: {
                return IrRTTI.cast_LoadInst(this).getOrdering() != AtomicOrdering.NotAtomic;
            }
            case 31: 
        }
        return IrRTTI.cast_StoreInst(this).getOrdering() != AtomicOrdering.NotAtomic;
    }

    public boolean mayThrow() {
        CallInst CI = IrRTTI.dyn_cast_CallInst(this);
        if (CI != null) {
            return !CI.doesNotThrow();
        }
        CleanupReturnInst CRI = IrRTTI.dyn_cast_CleanupReturnInst(this);
        if (CRI != null) {
            return CRI.unwindsToCaller();
        }
        CatchSwitchInst CatchSwitch = IrRTTI.dyn_cast_CatchSwitchInst(this);
        if (CatchSwitch != null) {
            return CatchSwitch.unwindsToCaller();
        }
        return IrRTTI.isa_ResumeInst(this);
    }

    public boolean isFenceLike() {
        switch (this.getOpcode()) {
            default: {
                return false;
            }
            case 5: 
            case 9: 
            case 33: 
            case 50: 
            case 54: 
        }
        return true;
    }

    public boolean mayHaveSideEffects() {
        return this.mayWriteToMemory() || this.mayThrow();
    }

    public boolean isEHPad() {
        switch (this.getOpcode()) {
            case 10: 
            case 49: 
            case 50: 
            case 64: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Instruction clone() {
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            Instruction New2 = null;
            switch (this.getOpcode()) {
                default: {
                    throw new llvm_unreachable("Unhandled Opcode.");
                }
                case 1: {
                    New2 = IrRTTI.cast_ReturnInst(this).cloneImpl();
                    break;
                }
                case 2: {
                    New2 = IrRTTI.cast_BranchInst(this).cloneImpl();
                    break;
                }
                case 3: {
                    New2 = IrRTTI.cast_SwitchInst(this).cloneImpl();
                    break;
                }
                case 4: {
                    New2 = IrRTTI.cast_IndirectBrInst(this).cloneImpl();
                    break;
                }
                case 5: {
                    New2 = IrRTTI.cast_InvokeInst(this).cloneImpl();
                    break;
                }
                case 6: {
                    New2 = IrRTTI.cast_ResumeInst(this).cloneImpl();
                    break;
                }
                case 7: {
                    New2 = IrRTTI.cast_UnreachableInst(this).cloneImpl();
                    break;
                }
                case 8: {
                    New2 = IrRTTI.cast_CleanupReturnInst(this).cloneImpl();
                    break;
                }
                case 9: {
                    New2 = IrRTTI.cast_CatchReturnInst(this).cloneImpl();
                    break;
                }
                case 10: {
                    New2 = IrRTTI.cast_CatchSwitchInst(this).cloneImpl();
                    break;
                }
                case 11: {
                    New2 = IrRTTI.cast_BinaryOperator(this).cloneImpl();
                    break;
                }
                case 12: {
                    New2 = IrRTTI.cast_BinaryOperator(this).cloneImpl();
                    break;
                }
                case 13: {
                    New2 = IrRTTI.cast_BinaryOperator(this).cloneImpl();
                    break;
                }
                case 14: {
                    New2 = IrRTTI.cast_BinaryOperator(this).cloneImpl();
                    break;
                }
                case 15: {
                    New2 = IrRTTI.cast_BinaryOperator(this).cloneImpl();
                    break;
                }
                case 16: {
                    New2 = IrRTTI.cast_BinaryOperator(this).cloneImpl();
                    break;
                }
                case 17: {
                    New2 = IrRTTI.cast_BinaryOperator(this).cloneImpl();
                    break;
                }
                case 18: {
                    New2 = IrRTTI.cast_BinaryOperator(this).cloneImpl();
                    break;
                }
                case 19: {
                    New2 = IrRTTI.cast_BinaryOperator(this).cloneImpl();
                    break;
                }
                case 20: {
                    New2 = IrRTTI.cast_BinaryOperator(this).cloneImpl();
                    break;
                }
                case 21: {
                    New2 = IrRTTI.cast_BinaryOperator(this).cloneImpl();
                    break;
                }
                case 22: {
                    New2 = IrRTTI.cast_BinaryOperator(this).cloneImpl();
                    break;
                }
                case 23: {
                    New2 = IrRTTI.cast_BinaryOperator(this).cloneImpl();
                    break;
                }
                case 24: {
                    New2 = IrRTTI.cast_BinaryOperator(this).cloneImpl();
                    break;
                }
                case 25: {
                    New2 = IrRTTI.cast_BinaryOperator(this).cloneImpl();
                    break;
                }
                case 26: {
                    New2 = IrRTTI.cast_BinaryOperator(this).cloneImpl();
                    break;
                }
                case 27: {
                    New2 = IrRTTI.cast_BinaryOperator(this).cloneImpl();
                    break;
                }
                case 28: {
                    New2 = IrRTTI.cast_BinaryOperator(this).cloneImpl();
                    break;
                }
                case 29: {
                    New2 = IrRTTI.cast_AllocaInst(this).cloneImpl();
                    break;
                }
                case 30: {
                    New2 = IrRTTI.cast_LoadInst(this).cloneImpl();
                    break;
                }
                case 31: {
                    New2 = IrRTTI.cast_StoreInst(this).cloneImpl();
                    break;
                }
                case 32: {
                    New2 = IrRTTI.cast_GetElementPtrInst(this).cloneImpl();
                    break;
                }
                case 33: {
                    New2 = IrRTTI.cast_FenceInst(this).cloneImpl();
                    break;
                }
                case 34: {
                    New2 = IrRTTI.cast_AtomicCmpXchgInst(this).cloneImpl();
                    break;
                }
                case 35: {
                    New2 = IrRTTI.cast_AtomicRMWInst(this).cloneImpl();
                    break;
                }
                case 36: {
                    New2 = IrRTTI.cast_TruncInst(this).cloneImpl();
                    break;
                }
                case 37: {
                    New2 = IrRTTI.cast_ZExtInst(this).cloneImpl();
                    break;
                }
                case 38: {
                    New2 = IrRTTI.cast_SExtInst(this).cloneImpl();
                    break;
                }
                case 39: {
                    New2 = IrRTTI.cast_FPToUIInst(this).cloneImpl();
                    break;
                }
                case 40: {
                    New2 = IrRTTI.cast_FPToSIInst(this).cloneImpl();
                    break;
                }
                case 41: {
                    New2 = IrRTTI.cast_UIToFPInst(this).cloneImpl();
                    break;
                }
                case 42: {
                    New2 = IrRTTI.cast_SIToFPInst(this).cloneImpl();
                    break;
                }
                case 43: {
                    New2 = IrRTTI.cast_FPTruncInst(this).cloneImpl();
                    break;
                }
                case 44: {
                    New2 = IrRTTI.cast_FPExtInst(this).cloneImpl();
                    break;
                }
                case 45: {
                    New2 = IrRTTI.cast_PtrToIntInst(this).cloneImpl();
                    break;
                }
                case 46: {
                    New2 = IrRTTI.cast_IntToPtrInst(this).cloneImpl();
                    break;
                }
                case 47: {
                    New2 = IrRTTI.cast_BitCastInst(this).cloneImpl();
                    break;
                }
                case 48: {
                    New2 = IrRTTI.cast_AddrSpaceCastInst(this).cloneImpl();
                    break;
                }
                case 49: {
                    New2 = IrRTTI.cast_CleanupPadInst(this).cloneImpl();
                    break;
                }
                case 50: {
                    New2 = IrRTTI.cast_CatchPadInst(this).cloneImpl();
                    break;
                }
                case 51: {
                    New2 = IrRTTI.cast_ICmpInst(this).cloneImpl();
                    break;
                }
                case 52: {
                    New2 = IrRTTI.cast_FCmpInst(this).cloneImpl();
                    break;
                }
                case 53: {
                    New2 = IrRTTI.cast_PHINode(this).cloneImpl();
                    break;
                }
                case 54: {
                    New2 = IrRTTI.cast_CallInst(this).cloneImpl();
                    break;
                }
                case 55: {
                    New2 = IrRTTI.cast_SelectInst(this).cloneImpl();
                    break;
                }
                case 56: {
                    New2 = IrRTTI.cast_Instruction(this).cloneImpl();
                    break;
                }
                case 57: {
                    New2 = IrRTTI.cast_Instruction(this).cloneImpl();
                    break;
                }
                case 58: {
                    New2 = IrRTTI.cast_VAArgInst(this).cloneImpl();
                    break;
                }
                case 59: {
                    New2 = IrRTTI.cast_ExtractElementInst(this).cloneImpl();
                    break;
                }
                case 60: {
                    New2 = IrRTTI.cast_InsertElementInst(this).cloneImpl();
                    break;
                }
                case 61: {
                    New2 = IrRTTI.cast_ShuffleVectorInst(this).cloneImpl();
                    break;
                }
                case 62: {
                    New2 = IrRTTI.cast_ExtractValueInst(this).cloneImpl();
                    break;
                }
                case 63: {
                    New2 = IrRTTI.cast_InsertValueInst(this).cloneImpl();
                    break;
                }
                case 64: {
                    New2 = IrRTTI.cast_LandingPadInst(this).cloneImpl();
                }
            }
            New2.SubclassOptionalData = Unsigned.$uchar2uchar_7bits((byte)Unsigned.$7bits_uchar2uchar((byte)this.SubclassOptionalData));
            if (!this.hasMetadata()) {
                Instruction instruction = New2;
                return instruction;
            }
            SmallVector TheMDs = new SmallVector(4, (Object)new std_pair.pairUIntPtr());
            this.getAllMetadataOtherThanDebugLoc((SmallVectorImpl<std_pair.pairUIntPtr<MDNode>>)TheMDs);
            for (std_pair.pairUIntPtr MD : TheMDs) {
                New2.setMetadata(MD.first, (MDNode)MD.second);
            }
            New2.setDebugLoc((DebugLoc)$c$.track((Object)new DebugLoc(this.getDebugLoc())));
            $c$.clean();
            Instruction instruction = New2;
            return instruction;
        }
        finally {
            $c$.$destroy();
        }
    }

    public boolean isIdenticalTo(Instruction I) {
        return this.isIdenticalToWhenDefined(I) && Unsigned.$uchar2int((byte)Unsigned.$7bits_uchar2uchar((byte)this.SubclassOptionalData)) == Unsigned.$uchar2int((byte)Unsigned.$7bits_uchar2uchar((byte)I.SubclassOptionalData));
    }

    public boolean isIdenticalToWhenDefined(Instruction I) {
        if (this.getOpcode() != I.getOpcode() || this.getNumOperands() != I.getNumOperands() || this.getType() != I.getType()) {
            return false;
        }
        if (this.getNumOperands() == 0 && I.getNumOperands() == 0) {
            return InstructionStatics.haveSameSpecialState(this, I);
        }
        if (!std.equal(this.op_begin$Const(), this.op_end$Const(), I.op_begin$Const())) {
            return false;
        }
        PHINode thisPHI = IrRTTI.dyn_cast_PHINode(this);
        if (thisPHI != null) {
            PHINode otherPHI = IrRTTI.cast_PHINode(I);
            return std.equal(thisPHI.block_begin$Const(), thisPHI.block_end$Const(), otherPHI.block_begin$Const());
        }
        return InstructionStatics.haveSameSpecialState(this, I);
    }

    public boolean isSameOperationAs(Instruction I) {
        return this.isSameOperationAs(I, 0);
    }

    public boolean isSameOperationAs(Instruction I, int flags) {
        boolean UseScalarTypes;
        boolean IgnoreAlignment = (flags & 1) != 0;
        boolean bl = UseScalarTypes = (flags & 2) != 0;
        if (this.getOpcode() != I.getOpcode() || this.getNumOperands() != I.getNumOperands() || (UseScalarTypes ? this.getType().getScalarType() != I.getType().getScalarType() : this.getType() != I.getType())) {
            return false;
        }
        int e = this.getNumOperands();
        for (int i = 0; i != e; ++i) {
            if (!(UseScalarTypes ? this.getOperand(i).getType().getScalarType() != I.getOperand(i).getType().getScalarType() : this.getOperand(i).getType() != I.getOperand(i).getType())) continue;
            return false;
        }
        return InstructionStatics.haveSameSpecialState(this, I, IgnoreAlignment);
    }

    public boolean isUsedOutsideOfBlock(BasicBlock BB) {
        for (Use U : this.uses$Const()) {
            Instruction I = IrRTTI.cast_Instruction(U.getUser());
            PHINode PN = IrRTTI.dyn_cast_PHINode(I);
            if (!(PN == null ? I.getParent$Const() != BB : PN.getIncomingBlock(U) != BB)) continue;
            return true;
        }
        return false;
    }

    public static boolean classof(Value V) {
        return Unsigned.$greatereq_uint((int)V.getValueID(), (int)Value.ValueTy.InstructionVal.getValue());
    }

    private void setValueSubclassData_Instruction(char D2) {
        super.setValueSubclassData(D2);
    }

    private char getSubclassDataFromValue_Instruction() {
        return super.getSubclassDataFromValue();
    }

    private void setHasMetadataHashEntry(boolean V) {
        this.setValueSubclassData_Instruction(Unsigned.$int2ushort((int)(Unsigned.$ushort2int((char)this.getSubclassDataFromValue_Instruction()) & 0xFFFF7FFF | (V ? 32768 : 0))));
    }

    @Override
    public void setParent(BasicBlock P2) {
        this.Parent = P2;
    }

    protected void setInstructionSubclassData(char D2) {
        assert ((Unsigned.$ushort2int((char)D2) & 0x8000) == 0) : "Out of range value put into field";
        this.setValueSubclassData_Instruction(Unsigned.$int2ushort((int)(Unsigned.$ushort2int((char)this.getSubclassDataFromValue_Instruction()) & 0x8000 | Unsigned.$ushort2int((char)D2))));
    }

    protected int getSubclassDataFromInstruction() {
        return Unsigned.$ushort2int((char)this.getSubclassDataFromValue_Instruction()) & 0xFFFF7FFF;
    }

    protected Instruction(Type ty, int it, type.ptr<Use> Ops, int NumOps) {
        this(ty, it, Ops, NumOps, (Instruction)null);
    }

    protected Instruction(Type ty, int it, type.ptr<Use> Ops, int NumOps, Instruction InsertBefore) {
        super(ty, Value.ValueTy.InstructionVal.getValue() + it, Ops, NumOps);
        this.ilist_node$Flds = this.$ilist_node_with_parent();
        this.Parent = null;
        this.DbgLoc = new DebugLoc();
        if (InsertBefore != null) {
            BasicBlock BB = InsertBefore.getParent();
            assert (BB != null) : "Instruction to insert before is not in a basic block!";
            BB.getInstList().insert_ilist_iterator$NodeTy_T$P(InsertBefore.getIterator(), (ilist_node)this);
        }
    }

    protected Instruction(Type ty, int it, type.ptr<Use> Ops, int NumOps, BasicBlock InsertAtEnd) {
        super(ty, Value.ValueTy.InstructionVal.getValue() + it, Ops, NumOps);
        this.ilist_node$Flds = this.$ilist_node_with_parent();
        this.Parent = null;
        this.DbgLoc = new DebugLoc();
        assert (InsertAtEnd != null) : "Basic block to append to may not be NULL!";
        InsertAtEnd.getInstList().push_back((ilist_node)this);
    }

    private Instruction cloneImpl() {
        throw new llvm_unreachable("Subclass of Instruction failed to implement cloneImpl");
    }

    protected Instruction() {
        this.ilist_node$Flds = this.$ilist_node_with_parent();
    }

    public static Instruction $createSentinel() {
        return (Instruction)User.$new_FixedUses(0, New$Mem -> new Instruction());
    }

    public final ilist_node.ilist_node.Fields $ilist_node$Fields() {
        return this.ilist_node$Flds;
    }

    @Override
    public String toString() {
        return "Parent=" + this.Parent + ", DbgLoc=" + this.DbgLoc + super.toString();
    }

    public static final class OtherOps {
        public static final int OtherOpsBegin = 51;
        public static final int ICmp = 51;
        public static final int FCmp = 52;
        public static final int PHI = 53;
        public static final int Call = 54;
        public static final int Select = 55;
        public static final int UserOp1 = 56;
        public static final int UserOp2 = 57;
        public static final int VAArg = 58;
        public static final int ExtractElement = 59;
        public static final int InsertElement = 60;
        public static final int ShuffleVector = 61;
        public static final int ExtractValue = 62;
        public static final int InsertValue = 63;
        public static final int LandingPad = 64;
        public static final int OtherOpsEnd = 65;
    }

    public static final class FuncletPadOps {
        public static final int FuncletPadOpsBegin = 49;
        public static final int CleanupPad = 49;
        public static final int CatchPad = 50;
        public static final int FuncletPadOpsEnd = 51;
    }

    public static final class CastOps {
        public static final int CastOpsBegin = 36;
        public static final int Trunc = 36;
        public static final int ZExt = 37;
        public static final int SExt = 38;
        public static final int FPToUI = 39;
        public static final int FPToSI = 40;
        public static final int UIToFP = 41;
        public static final int SIToFP = 42;
        public static final int FPTrunc = 43;
        public static final int FPExt = 44;
        public static final int PtrToInt = 45;
        public static final int IntToPtr = 46;
        public static final int BitCast = 47;
        public static final int AddrSpaceCast = 48;
        public static final int CastOpsEnd = 49;
    }

    public static final class MemoryOps {
        public static final int MemoryOpsBegin = 29;
        public static final int Alloca = 29;
        public static final int Load = 30;
        public static final int Store = 31;
        public static final int GetElementPtr = 32;
        public static final int Fence = 33;
        public static final int AtomicCmpXchg = 34;
        public static final int AtomicRMW = 35;
        public static final int MemoryOpsEnd = 36;
    }

    public static final class BinaryOps {
        public static final int BinaryOpsBegin = 11;
        public static final int Add = 11;
        public static final int FAdd = 12;
        public static final int Sub = 13;
        public static final int FSub = 14;
        public static final int Mul = 15;
        public static final int FMul = 16;
        public static final int UDiv = 17;
        public static final int SDiv = 18;
        public static final int FDiv = 19;
        public static final int URem = 20;
        public static final int SRem = 21;
        public static final int FRem = 22;
        public static final int Shl = 23;
        public static final int LShr = 24;
        public static final int AShr = 25;
        public static final int And = 26;
        public static final int Or = 27;
        public static final int Xor = 28;
        public static final int BinaryOpsEnd = 29;
    }

    public static final class TermOps {
        public static final int TermOpsBegin = 1;
        public static final int Ret = 1;
        public static final int Br = 2;
        public static final int Switch = 3;
        public static final int IndirectBr = 4;
        public static final int Invoke = 5;
        public static final int Resume = 6;
        public static final int Unreachable = 7;
        public static final int CleanupRet = 8;
        public static final int CatchRet = 9;
        public static final int CatchSwitch = 10;
        public static final int TermOpsEnd = 11;
    }

    public static final class OperationEquivalenceFlags {
        public static final int CompareIgnoringAlignment = 1;
        public static final int CompareUsingScalarTypes = 2;
    }
}

