/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.llvm.adt.APInt;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.ilist_iterator;
import org.llvm.adt.ilist_node;
import org.llvm.adt.ilist_traits;
import org.llvm.ir.AssertingVH;
import org.llvm.ir.BasicBlock;
import org.llvm.ir.BitCastInst;
import org.llvm.ir.CallInst;
import org.llvm.ir.Constant;
import org.llvm.ir.ConstantDataArray;
import org.llvm.ir.ConstantInt;
import org.llvm.ir.DataLayout;
import org.llvm.ir.DebugLoc;
import org.llvm.ir.FastMathFlags;
import org.llvm.ir.Function;
import org.llvm.ir.GlobalValue;
import org.llvm.ir.GlobalVariable;
import org.llvm.ir.Instruction;
import org.llvm.ir.IntegerType;
import org.llvm.ir.InvokeInst;
import org.llvm.ir.LLVMContext;
import org.llvm.ir.MDNode;
import org.llvm.ir.Module$IR;
import org.llvm.ir.OperandBundleDefT;
import org.llvm.ir.PointerType;
import org.llvm.ir.StatepointFlags;
import org.llvm.ir.Type;
import org.llvm.ir.UnaryInstruction;
import org.llvm.ir.UndefValue;
import org.llvm.ir.Use;
import org.llvm.ir.Value;
import org.llvm.ir.VectorType;
import org.llvm.ir.impl.IRBuilderStatics;
import org.llvm.ir.impl.SymbolTableListTraits$Instruction;
import org.llvm.ir.intrinsic.IntrinsicGlobals;
import org.llvm.ir.java.IrRTTI;
import org.llvm.support.llvm;

public class IRBuilderBase
implements Destructors.ClassWithDestructor {
    private DebugLoc CurDbgLocation;
    protected BasicBlock BB;
    protected ilist_iterator<Instruction> InsertPt;
    protected final LLVMContext Context;
    protected MDNode DefaultFPMathTag;
    protected FastMathFlags FMF;
    protected ArrayRef<OperandBundleDefT<Value>> DefaultOperandBundles;

    public IRBuilderBase(LLVMContext context) {
        this(context, null, (ArrayRef<OperandBundleDefT<Value>>)new ArrayRef(llvm.None, false));
    }

    public IRBuilderBase(LLVMContext context, MDNode FPMathTag) {
        this(context, FPMathTag, (ArrayRef<OperandBundleDefT<Value>>)new ArrayRef(llvm.None, false));
    }

    public IRBuilderBase(LLVMContext context, MDNode FPMathTag, ArrayRef<OperandBundleDefT<Value>> OpBundles) {
        this.CurDbgLocation = new DebugLoc();
        this.InsertPt = new ilist_iterator((ilist_traits)new SymbolTableListTraits$Instruction());
        this.Context = context;
        this.DefaultFPMathTag = FPMathTag;
        this.FMF = new FastMathFlags();
        this.DefaultOperandBundles = new ArrayRef(OpBundles);
        this.ClearInsertionPoint();
    }

    public void ClearInsertionPoint() {
        this.BB = null;
        this.InsertPt.reset((ilist_node)((Instruction)null));
    }

    public BasicBlock GetInsertBlock() {
        return this.BB;
    }

    public ilist_iterator<Instruction> GetInsertPoint() {
        return new ilist_iterator(this.InsertPt);
    }

    public LLVMContext getContext() {
        return this.Context;
    }

    public void SetInsertPoint(BasicBlock TheBB) {
        this.BB = TheBB;
        this.InsertPt.$assignMove(this.BB.end());
    }

    public void SetInsertPoint(Instruction I) {
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            this.BB = I.getParent();
            this.InsertPt.$assignMove(I.getIterator());
            assert (this.InsertPt.$noteq(this.BB.end())) : "Can't read debug loc from end()";
            this.SetCurrentDebugLocation((DebugLoc)$c$.track((Object)new DebugLoc(I.getDebugLoc())));
            $c$.clean();
        }
        finally {
            $c$.$destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void SetInsertPoint(BasicBlock TheBB, ilist_iterator<Instruction> IP) {
        this.BB = TheBB;
        this.InsertPt.$assign(IP);
        if (IP.$noteq(TheBB.end())) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                this.SetCurrentDebugLocation((DebugLoc)$c$.track((Object)new DebugLoc(((Instruction)IP.$arrow()).getDebugLoc())));
                $c$.clean();
            }
            finally {
                $c$.$destroy();
            }
        }
    }

    public void SetCurrentDebugLocation(DebugLoc L) {
        this.CurDbgLocation.$assignMove((DebugLoc)std.move((Object)L));
    }

    public DebugLoc getCurrentDebugLocation() {
        return this.CurDbgLocation;
    }

    public void SetInstDebugLocation(Instruction I) {
        if (this.CurDbgLocation.$bool()) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                I.setDebugLoc((DebugLoc)$c$.track((Object)new DebugLoc(this.CurDbgLocation)));
                $c$.clean();
            }
            finally {
                $c$.$destroy();
            }
        }
    }

    public Type getCurrentFunctionReturnType() {
        assert (this.BB != null && this.BB.getParent() != null) : "No current function!";
        return this.BB.getParent().getReturnType();
    }

    public InsertPoint saveIP() {
        return new InsertPoint(this.GetInsertBlock(), this.GetInsertPoint());
    }

    public InsertPoint saveAndClearIP() {
        InsertPoint IP = new InsertPoint(this.GetInsertBlock(), this.GetInsertPoint());
        this.ClearInsertionPoint();
        return IP;
    }

    public void restoreIP(InsertPoint IP) {
        if (IP.isSet()) {
            this.SetInsertPoint(IP.getBlock(), IP.getPoint());
        } else {
            this.ClearInsertionPoint();
        }
    }

    public MDNode getDefaultFPMathTag() {
        return this.DefaultFPMathTag;
    }

    public FastMathFlags getFastMathFlags() {
        return new FastMathFlags(this.FMF);
    }

    public void clearFastMathFlags() {
        this.FMF.clear();
    }

    public void setDefaultFPMathTag(MDNode FPMathTag) {
        this.DefaultFPMathTag = FPMathTag;
    }

    public void setFastMathFlags(FastMathFlags NewFMF) {
        this.FMF.$assign(NewFMF);
    }

    public GlobalVariable CreateGlobalString(StringRef Str) {
        return this.CreateGlobalString(Str, new Twine(NativePointer.$EMPTY), 0);
    }

    public GlobalVariable CreateGlobalString(StringRef Str, Twine Name) {
        return this.CreateGlobalString(Str, Name, 0);
    }

    public GlobalVariable CreateGlobalString(StringRef Str, Twine Name, int AddressSpace) {
        Constant StrConstant = ConstantDataArray.getString(this.Context, new StringRef(Str));
        Module$IR M = (Module$IR)Native.$Deref((Object)this.BB.getParent().getParent());
        Object GV = GlobalVariable.$new_GlobalVariable(New$Mem -> new GlobalVariable(M, StrConstant.getType(), true, GlobalValue.LinkageTypes.PrivateLinkage, StrConstant, Name, null, GlobalValue.ThreadLocalMode.NotThreadLocal, AddressSpace));
        ((GlobalValue)GV).setUnnamedAddr(GlobalValue.UnnamedAddr.Global);
        return GV;
    }

    public ConstantInt getInt1(boolean V) {
        return ConstantInt.get(this.getInt1Ty(), (long)(V ? 1 : 0));
    }

    public ConstantInt getTrue() {
        return ConstantInt.getTrue(this.Context);
    }

    public ConstantInt getFalse() {
        return ConstantInt.getFalse(this.Context);
    }

    public ConstantInt getInt8(byte C2) {
        return ConstantInt.get(this.getInt8Ty(), Unsigned.$uchar2ulong((byte)C2));
    }

    public ConstantInt getInt16(char C2) {
        return ConstantInt.get(this.getInt16Ty(), Unsigned.$ushort2ulong((char)C2));
    }

    public ConstantInt getInt32(int C2) {
        return ConstantInt.get(this.getInt32Ty(), Unsigned.$uint2ulong((int)C2));
    }

    public ConstantInt getInt64(long C2) {
        return ConstantInt.get(this.getInt64Ty(), C2);
    }

    public ConstantInt getIntN(int N, long C2) {
        return ConstantInt.get(this.getIntNTy(N), C2);
    }

    public ConstantInt getInt(APInt AI) {
        return ConstantInt.get(this.Context, AI);
    }

    public IntegerType getInt1Ty() {
        return Type.getInt1Ty(this.Context);
    }

    public IntegerType getInt8Ty() {
        return Type.getInt8Ty(this.Context);
    }

    public IntegerType getInt16Ty() {
        return Type.getInt16Ty(this.Context);
    }

    public IntegerType getInt32Ty() {
        return Type.getInt32Ty(this.Context);
    }

    public IntegerType getInt64Ty() {
        return Type.getInt64Ty(this.Context);
    }

    public IntegerType getInt128Ty() {
        return Type.getInt128Ty(this.Context);
    }

    public IntegerType getIntNTy(int N) {
        return Type.getIntNTy(this.Context, N);
    }

    public Type getHalfTy() {
        return Type.getHalfTy(this.Context);
    }

    public Type getFloatTy() {
        return Type.getFloatTy(this.Context);
    }

    public Type getDoubleTy() {
        return Type.getDoubleTy(this.Context);
    }

    public Type getVoidTy() {
        return Type.getVoidTy(this.Context);
    }

    public PointerType getInt8PtrTy() {
        return this.getInt8PtrTy(0);
    }

    public PointerType getInt8PtrTy(int AddrSpace) {
        return Type.getInt8PtrTy(this.Context, AddrSpace);
    }

    public IntegerType getIntPtrTy(DataLayout DL) {
        return this.getIntPtrTy(DL, 0);
    }

    public IntegerType getIntPtrTy(DataLayout DL, int AddrSpace) {
        return DL.getIntPtrType(this.Context, AddrSpace);
    }

    public CallInst CreateMemSet(Value Ptr, Value Val, long Size, int Align) {
        return this.CreateMemSet(Ptr, Val, Size, Align, false, (MDNode)null, (MDNode)null, (MDNode)null);
    }

    public CallInst CreateMemSet(Value Ptr, Value Val, long Size, int Align, boolean isVolatile) {
        return this.CreateMemSet(Ptr, Val, Size, Align, isVolatile, (MDNode)null, (MDNode)null, (MDNode)null);
    }

    public CallInst CreateMemSet(Value Ptr, Value Val, long Size, int Align, boolean isVolatile, MDNode TBAATag) {
        return this.CreateMemSet(Ptr, Val, Size, Align, isVolatile, TBAATag, (MDNode)null, (MDNode)null);
    }

    public CallInst CreateMemSet(Value Ptr, Value Val, long Size, int Align, boolean isVolatile, MDNode TBAATag, MDNode ScopeTag) {
        return this.CreateMemSet(Ptr, Val, Size, Align, isVolatile, TBAATag, ScopeTag, (MDNode)null);
    }

    public CallInst CreateMemSet(Value Ptr, Value Val, long Size, int Align, boolean isVolatile, MDNode TBAATag, MDNode ScopeTag, MDNode NoAliasTag) {
        return this.CreateMemSet(Ptr, Val, this.getInt64(Size), Align, isVolatile, TBAATag, ScopeTag, NoAliasTag);
    }

    public CallInst CreateMemSet(Value Ptr, Value Val, Value Size, int Align) {
        return this.CreateMemSet(Ptr, Val, Size, Align, false, (MDNode)null, (MDNode)null, (MDNode)null);
    }

    public CallInst CreateMemSet(Value Ptr, Value Val, Value Size, int Align, boolean isVolatile) {
        return this.CreateMemSet(Ptr, Val, Size, Align, isVolatile, (MDNode)null, (MDNode)null, (MDNode)null);
    }

    public CallInst CreateMemSet(Value Ptr, Value Val, Value Size, int Align, boolean isVolatile, MDNode TBAATag) {
        return this.CreateMemSet(Ptr, Val, Size, Align, isVolatile, TBAATag, (MDNode)null, (MDNode)null);
    }

    public CallInst CreateMemSet(Value Ptr, Value Val, Value Size, int Align, boolean isVolatile, MDNode TBAATag, MDNode ScopeTag) {
        return this.CreateMemSet(Ptr, Val, Size, Align, isVolatile, TBAATag, ScopeTag, (MDNode)null);
    }

    public CallInst CreateMemSet(Value Ptr, Value Val, Value Size, int Align, boolean isVolatile, MDNode TBAATag, MDNode ScopeTag, MDNode NoAliasTag) {
        Ptr = this.getCastedInt8PtrValue(Ptr);
        Object[] Ops = new Value[]{Ptr, Val, Size, this.getInt32(Align), this.getInt1(isVolatile)};
        Object[] Tys = new Type[]{Ptr.getType(), Size.getType()};
        Object M = this.BB.getParent().getParent();
        Function TheFn = IntrinsicGlobals.getDeclaration((Module$IR)M, 86, (ArrayRef<Type>)new ArrayRef(Tys, true));
        CallInst CI = IRBuilderStatics.createCallHelper(TheFn, (ArrayRef<Value>)new ArrayRef(Ops, true), this);
        if (TBAATag != null) {
            CI.setMetadata(LLVMContext.Unnamed_enum.MD_tbaa.getValue(), TBAATag);
        }
        if (ScopeTag != null) {
            CI.setMetadata(LLVMContext.Unnamed_enum.MD_alias_scope.getValue(), ScopeTag);
        }
        if (NoAliasTag != null) {
            CI.setMetadata(LLVMContext.Unnamed_enum.MD_noalias.getValue(), NoAliasTag);
        }
        return CI;
    }

    public CallInst CreateMemCpy(Value Dst, Value Src, long Size, int Align) {
        return this.CreateMemCpy(Dst, Src, Size, Align, false, (MDNode)null, (MDNode)null, (MDNode)null, (MDNode)null);
    }

    public CallInst CreateMemCpy(Value Dst, Value Src, long Size, int Align, boolean isVolatile) {
        return this.CreateMemCpy(Dst, Src, Size, Align, isVolatile, (MDNode)null, (MDNode)null, (MDNode)null, (MDNode)null);
    }

    public CallInst CreateMemCpy(Value Dst, Value Src, long Size, int Align, boolean isVolatile, MDNode TBAATag) {
        return this.CreateMemCpy(Dst, Src, Size, Align, isVolatile, TBAATag, (MDNode)null, (MDNode)null, (MDNode)null);
    }

    public CallInst CreateMemCpy(Value Dst, Value Src, long Size, int Align, boolean isVolatile, MDNode TBAATag, MDNode TBAAStructTag) {
        return this.CreateMemCpy(Dst, Src, Size, Align, isVolatile, TBAATag, TBAAStructTag, (MDNode)null, (MDNode)null);
    }

    public CallInst CreateMemCpy(Value Dst, Value Src, long Size, int Align, boolean isVolatile, MDNode TBAATag, MDNode TBAAStructTag, MDNode ScopeTag) {
        return this.CreateMemCpy(Dst, Src, Size, Align, isVolatile, TBAATag, TBAAStructTag, ScopeTag, (MDNode)null);
    }

    public CallInst CreateMemCpy(Value Dst, Value Src, long Size, int Align, boolean isVolatile, MDNode TBAATag, MDNode TBAAStructTag, MDNode ScopeTag, MDNode NoAliasTag) {
        return this.CreateMemCpy(Dst, Src, this.getInt64(Size), Align, isVolatile, TBAATag, TBAAStructTag, ScopeTag, NoAliasTag);
    }

    public CallInst CreateMemCpy(Value Dst, Value Src, Value Size, int Align) {
        return this.CreateMemCpy(Dst, Src, Size, Align, false, (MDNode)null, (MDNode)null, (MDNode)null, (MDNode)null);
    }

    public CallInst CreateMemCpy(Value Dst, Value Src, Value Size, int Align, boolean isVolatile) {
        return this.CreateMemCpy(Dst, Src, Size, Align, isVolatile, (MDNode)null, (MDNode)null, (MDNode)null, (MDNode)null);
    }

    public CallInst CreateMemCpy(Value Dst, Value Src, Value Size, int Align, boolean isVolatile, MDNode TBAATag) {
        return this.CreateMemCpy(Dst, Src, Size, Align, isVolatile, TBAATag, (MDNode)null, (MDNode)null, (MDNode)null);
    }

    public CallInst CreateMemCpy(Value Dst, Value Src, Value Size, int Align, boolean isVolatile, MDNode TBAATag, MDNode TBAAStructTag) {
        return this.CreateMemCpy(Dst, Src, Size, Align, isVolatile, TBAATag, TBAAStructTag, (MDNode)null, (MDNode)null);
    }

    public CallInst CreateMemCpy(Value Dst, Value Src, Value Size, int Align, boolean isVolatile, MDNode TBAATag, MDNode TBAAStructTag, MDNode ScopeTag) {
        return this.CreateMemCpy(Dst, Src, Size, Align, isVolatile, TBAATag, TBAAStructTag, ScopeTag, (MDNode)null);
    }

    public CallInst CreateMemCpy(Value Dst, Value Src, Value Size, int Align, boolean isVolatile, MDNode TBAATag, MDNode TBAAStructTag, MDNode ScopeTag, MDNode NoAliasTag) {
        Dst = this.getCastedInt8PtrValue(Dst);
        Src = this.getCastedInt8PtrValue(Src);
        Object[] Ops = new Value[]{Dst, Src, Size, this.getInt32(Align), this.getInt1(isVolatile)};
        Object[] Tys = new Type[]{Dst.getType(), Src.getType(), Size.getType()};
        Object M = this.BB.getParent().getParent();
        Function TheFn = IntrinsicGlobals.getDeclaration((Module$IR)M, 84, (ArrayRef<Type>)new ArrayRef(Tys, true));
        CallInst CI = IRBuilderStatics.createCallHelper(TheFn, (ArrayRef<Value>)new ArrayRef(Ops, true), this);
        if (TBAATag != null) {
            CI.setMetadata(LLVMContext.Unnamed_enum.MD_tbaa.getValue(), TBAATag);
        }
        if (TBAAStructTag != null) {
            CI.setMetadata(LLVMContext.Unnamed_enum.MD_tbaa_struct.getValue(), TBAAStructTag);
        }
        if (ScopeTag != null) {
            CI.setMetadata(LLVMContext.Unnamed_enum.MD_alias_scope.getValue(), ScopeTag);
        }
        if (NoAliasTag != null) {
            CI.setMetadata(LLVMContext.Unnamed_enum.MD_noalias.getValue(), NoAliasTag);
        }
        return CI;
    }

    public CallInst CreateMemMove(Value Dst, Value Src, long Size, int Align) {
        return this.CreateMemMove(Dst, Src, Size, Align, false, (MDNode)null, (MDNode)null, (MDNode)null);
    }

    public CallInst CreateMemMove(Value Dst, Value Src, long Size, int Align, boolean isVolatile) {
        return this.CreateMemMove(Dst, Src, Size, Align, isVolatile, (MDNode)null, (MDNode)null, (MDNode)null);
    }

    public CallInst CreateMemMove(Value Dst, Value Src, long Size, int Align, boolean isVolatile, MDNode TBAATag) {
        return this.CreateMemMove(Dst, Src, Size, Align, isVolatile, TBAATag, (MDNode)null, (MDNode)null);
    }

    public CallInst CreateMemMove(Value Dst, Value Src, long Size, int Align, boolean isVolatile, MDNode TBAATag, MDNode ScopeTag) {
        return this.CreateMemMove(Dst, Src, Size, Align, isVolatile, TBAATag, ScopeTag, (MDNode)null);
    }

    public CallInst CreateMemMove(Value Dst, Value Src, long Size, int Align, boolean isVolatile, MDNode TBAATag, MDNode ScopeTag, MDNode NoAliasTag) {
        return this.CreateMemMove(Dst, Src, this.getInt64(Size), Align, isVolatile, TBAATag, ScopeTag, NoAliasTag);
    }

    public CallInst CreateMemMove(Value Dst, Value Src, Value Size, int Align) {
        return this.CreateMemMove(Dst, Src, Size, Align, false, (MDNode)null, (MDNode)null, (MDNode)null);
    }

    public CallInst CreateMemMove(Value Dst, Value Src, Value Size, int Align, boolean isVolatile) {
        return this.CreateMemMove(Dst, Src, Size, Align, isVolatile, (MDNode)null, (MDNode)null, (MDNode)null);
    }

    public CallInst CreateMemMove(Value Dst, Value Src, Value Size, int Align, boolean isVolatile, MDNode TBAATag) {
        return this.CreateMemMove(Dst, Src, Size, Align, isVolatile, TBAATag, (MDNode)null, (MDNode)null);
    }

    public CallInst CreateMemMove(Value Dst, Value Src, Value Size, int Align, boolean isVolatile, MDNode TBAATag, MDNode ScopeTag) {
        return this.CreateMemMove(Dst, Src, Size, Align, isVolatile, TBAATag, ScopeTag, (MDNode)null);
    }

    public CallInst CreateMemMove(Value Dst, Value Src, Value Size, int Align, boolean isVolatile, MDNode TBAATag, MDNode ScopeTag, MDNode NoAliasTag) {
        Dst = this.getCastedInt8PtrValue(Dst);
        Src = this.getCastedInt8PtrValue(Src);
        Object[] Ops = new Value[]{Dst, Src, Size, this.getInt32(Align), this.getInt1(isVolatile)};
        Object[] Tys = new Type[]{Dst.getType(), Src.getType(), Size.getType()};
        Object M = this.BB.getParent().getParent();
        Function TheFn = IntrinsicGlobals.getDeclaration((Module$IR)M, 85, (ArrayRef<Type>)new ArrayRef(Tys, true));
        CallInst CI = IRBuilderStatics.createCallHelper(TheFn, (ArrayRef<Value>)new ArrayRef(Ops, true), this);
        if (TBAATag != null) {
            CI.setMetadata(LLVMContext.Unnamed_enum.MD_tbaa.getValue(), TBAATag);
        }
        if (ScopeTag != null) {
            CI.setMetadata(LLVMContext.Unnamed_enum.MD_alias_scope.getValue(), ScopeTag);
        }
        if (NoAliasTag != null) {
            CI.setMetadata(LLVMContext.Unnamed_enum.MD_noalias.getValue(), NoAliasTag);
        }
        return CI;
    }

    public CallInst CreateLifetimeStart(Value Ptr) {
        return this.CreateLifetimeStart(Ptr, null);
    }

    public CallInst CreateLifetimeStart(Value Ptr, ConstantInt Size) {
        assert (IrRTTI.isa_PointerType(Ptr.getType())) : "lifetime.start only applies to pointers.";
        Ptr = this.getCastedInt8PtrValue(Ptr);
        if (Size == null) {
            Size = this.getInt64(Unsigned.$int2ulong((int)-1));
        } else assert (Size.getType() == this.getInt64Ty()) : "lifetime.start requires the size to be an i64";
        Object[] Ops = new Value[]{Size, Ptr};
        Object M = this.BB.getParent().getParent();
        Function TheFn = IntrinsicGlobals.getDeclaration((Module$IR)M, 70);
        return IRBuilderStatics.createCallHelper(TheFn, (ArrayRef<Value>)new ArrayRef(Ops, true), this);
    }

    public CallInst CreateLifetimeEnd(Value Ptr) {
        return this.CreateLifetimeEnd(Ptr, null);
    }

    public CallInst CreateLifetimeEnd(Value Ptr, ConstantInt Size) {
        assert (IrRTTI.isa_PointerType(Ptr.getType())) : "lifetime.end only applies to pointers.";
        Ptr = this.getCastedInt8PtrValue(Ptr);
        if (Size == null) {
            Size = this.getInt64(Unsigned.$int2ulong((int)-1));
        } else assert (Size.getType() == this.getInt64Ty()) : "lifetime.end requires the size to be an i64";
        Object[] Ops = new Value[]{Size, Ptr};
        Object M = this.BB.getParent().getParent();
        Function TheFn = IntrinsicGlobals.getDeclaration((Module$IR)M, 69);
        return IRBuilderStatics.createCallHelper(TheFn, (ArrayRef<Value>)new ArrayRef(Ops, true), this);
    }

    public CallInst CreateMaskedLoad(Value Ptr, int Align, Value Mask) {
        return this.CreateMaskedLoad(Ptr, Align, Mask, null, new Twine(NativePointer.$EMPTY));
    }

    public CallInst CreateMaskedLoad(Value Ptr, int Align, Value Mask, Value PassThru) {
        return this.CreateMaskedLoad(Ptr, Align, Mask, PassThru, new Twine(NativePointer.$EMPTY));
    }

    public CallInst CreateMaskedLoad(Value Ptr, int Align, Value Mask, Value PassThru, Twine Name) {
        PointerType PtrTy = IrRTTI.cast_PointerType(Ptr.getType());
        Type DataTy = PtrTy.getElementType();
        assert (DataTy.isVectorTy()) : "Ptr should point to a vector";
        if (PassThru == null) {
            PassThru = UndefValue.get(DataTy);
        }
        Object[] OverloadedTypes = new Type[]{DataTy, PtrTy};
        Object[] Ops = new Value[]{Ptr, this.getInt32(Align), Mask, PassThru};
        return this.CreateMaskedIntrinsic(80, (ArrayRef<Value>)new ArrayRef(Ops, true), (ArrayRef<Type>)new ArrayRef(OverloadedTypes, true), Name);
    }

    public CallInst CreateMaskedStore(Value Val, Value Ptr, int Align, Value Mask) {
        PointerType PtrTy = IrRTTI.cast_PointerType(Ptr.getType());
        Type DataTy = PtrTy.getElementType();
        assert (DataTy.isVectorTy()) : "Ptr should point to a vector";
        Object[] OverloadedTypes = new Type[]{DataTy, PtrTy};
        Object[] Ops = new Value[]{Val, Ptr, this.getInt32(Align), Mask};
        return this.CreateMaskedIntrinsic(82, (ArrayRef<Value>)new ArrayRef(Ops, true), (ArrayRef<Type>)new ArrayRef(OverloadedTypes, true));
    }

    public CallInst CreateMaskedGather(Value Ptrs, int Align) {
        return this.CreateMaskedGather(Ptrs, Align, null, null, new Twine(NativePointer.$EMPTY));
    }

    public CallInst CreateMaskedGather(Value Ptrs, int Align, Value Mask) {
        return this.CreateMaskedGather(Ptrs, Align, Mask, null, new Twine(NativePointer.$EMPTY));
    }

    public CallInst CreateMaskedGather(Value Ptrs, int Align, Value Mask, Value PassThru) {
        return this.CreateMaskedGather(Ptrs, Align, Mask, PassThru, new Twine(NativePointer.$EMPTY));
    }

    public CallInst CreateMaskedGather(Value Ptrs, int Align, Value Mask, Value PassThru, Twine Name) {
        VectorType PtrsTy = IrRTTI.cast_VectorType(Ptrs.getType());
        PointerType PtrTy = IrRTTI.cast_PointerType(PtrsTy.getElementType());
        int NumElts = PtrsTy.getVectorNumElements();
        VectorType DataTy = VectorType.get(PtrTy.getElementType(), NumElts);
        if (Mask == null) {
            Mask = Constant.getAllOnesValue(VectorType.get(Type.getInt1Ty(this.Context), NumElts));
        }
        Object[] Ops = new Value[]{Ptrs, this.getInt32(Align), Mask, UndefValue.get(DataTy)};
        return this.CreateMaskedIntrinsic(79, (ArrayRef<Value>)new ArrayRef(Ops, true), (ArrayRef<Type>)new ArrayRef((Object[])new Type[]{DataTy}, true), Name);
    }

    public CallInst CreateMaskedScatter(Value Data, Value Ptrs, int Align) {
        return this.CreateMaskedScatter(Data, Ptrs, Align, null);
    }

    public CallInst CreateMaskedScatter(Value Data, Value Ptrs, int Align, Value Mask) {
        VectorType PtrsTy = IrRTTI.cast_VectorType(Ptrs.getType());
        VectorType DataTy = IrRTTI.cast_VectorType(Data.getType());
        int NumElts = PtrsTy.getVectorNumElements();
        PointerType PtrTy = IrRTTI.cast_PointerType(PtrsTy.getElementType());
        assert (NumElts == DataTy.getVectorNumElements() && PtrTy.getElementType() == DataTy.getElementType()) : "Incompatible pointer and data types";
        if (Mask == null) {
            Mask = Constant.getAllOnesValue(VectorType.get(Type.getInt1Ty(this.Context), NumElts));
        }
        Object[] Ops = new Value[]{Data, Ptrs, this.getInt32(Align), Mask};
        return this.CreateMaskedIntrinsic(81, (ArrayRef<Value>)new ArrayRef(Ops, true), (ArrayRef<Type>)new ArrayRef((Object[])new Type[]{DataTy}, true));
    }

    public CallInst CreateAssumption(Value Cond) {
        assert (Cond.getType() == this.getInt1Ty()) : "an assumption condition must be of type i1";
        Object[] Ops = new Value[]{Cond};
        Object M = this.BB.getParent().getParent();
        Function FnAssume = IntrinsicGlobals.getDeclaration((Module$IR)M, 3);
        return IRBuilderStatics.createCallHelper(FnAssume, (ArrayRef<Value>)new ArrayRef(Ops, true), this);
    }

    public CallInst CreateGCStatepointCall_ulong_uint_Value$P_ArrayRef$Value$P_Twine$C(long ID2, int NumPatchBytes, Value ActualCallee, ArrayRef<Value> CallArgs, ArrayRef<Value> DeoptArgs, ArrayRef<Value> GCArgs) {
        return this.CreateGCStatepointCall_ulong_uint_Value$P_ArrayRef$Value$P_Twine$C(ID2, NumPatchBytes, ActualCallee, CallArgs, DeoptArgs, GCArgs, new Twine(NativePointer.$EMPTY));
    }

    public CallInst CreateGCStatepointCall_ulong_uint_Value$P_ArrayRef$Value$P_Twine$C(long ID2, int NumPatchBytes, Value ActualCallee, ArrayRef<Value> CallArgs, ArrayRef<Value> DeoptArgs, ArrayRef<Value> GCArgs, Twine Name) {
        return IRBuilderStatics.CreateGCStatepointCallCommon$Value(this, ID2, NumPatchBytes, ActualCallee, StatepointFlags.None.getValue(), (ArrayRef<Value>)new ArrayRef(CallArgs), (ArrayRef<Value>)new ArrayRef(llvm.None, true), (ArrayRef<Value>)new ArrayRef(DeoptArgs), (ArrayRef<Value>)new ArrayRef(GCArgs), Name);
    }

    public CallInst CreateGCStatepointCall(long ID2, int NumPatchBytes, Value ActualCallee, int Flags, ArrayRef<Use> CallArgs, ArrayRef<Use> TransitionArgs, ArrayRef<Use> DeoptArgs, ArrayRef<Value> GCArgs) {
        return this.CreateGCStatepointCall(ID2, NumPatchBytes, ActualCallee, Flags, CallArgs, TransitionArgs, DeoptArgs, GCArgs, new Twine(NativePointer.$EMPTY));
    }

    public CallInst CreateGCStatepointCall(long ID2, int NumPatchBytes, Value ActualCallee, int Flags, ArrayRef<Use> CallArgs, ArrayRef<Use> TransitionArgs, ArrayRef<Use> DeoptArgs, ArrayRef<Value> GCArgs, Twine Name) {
        return IRBuilderStatics.CreateGCStatepointCallCommon$Use(this, ID2, NumPatchBytes, ActualCallee, Flags, (ArrayRef<Use>)new ArrayRef(CallArgs), (ArrayRef<Use>)new ArrayRef(TransitionArgs), (ArrayRef<Use>)new ArrayRef(DeoptArgs), (ArrayRef<Value>)new ArrayRef(GCArgs), Name);
    }

    public CallInst CreateGCStatepointCall_ulong_uint_Value$P_ArrayRef$Use_ArrayRef$Value$P_Twine$C(long ID2, int NumPatchBytes, Value ActualCallee, ArrayRef<Use> CallArgs, ArrayRef<Value> DeoptArgs, ArrayRef<Value> GCArgs) {
        return this.CreateGCStatepointCall_ulong_uint_Value$P_ArrayRef$Use_ArrayRef$Value$P_Twine$C(ID2, NumPatchBytes, ActualCallee, CallArgs, DeoptArgs, GCArgs, new Twine(NativePointer.$EMPTY));
    }

    public CallInst CreateGCStatepointCall_ulong_uint_Value$P_ArrayRef$Use_ArrayRef$Value$P_Twine$C(long ID2, int NumPatchBytes, Value ActualCallee, ArrayRef<Use> CallArgs, ArrayRef<Value> DeoptArgs, ArrayRef<Value> GCArgs, Twine Name) {
        return IRBuilderStatics.CreateGCStatepointCallCommon$UseValue(this, ID2, NumPatchBytes, ActualCallee, StatepointFlags.None.getValue(), (ArrayRef<Use>)new ArrayRef(CallArgs), (ArrayRef<Value>)new ArrayRef(llvm.None, true), (ArrayRef<Value>)new ArrayRef(DeoptArgs), (ArrayRef<Value>)new ArrayRef(GCArgs), Name);
    }

    public InvokeInst CreateGCStatepointInvoke_ulong_uint_Value$P_BasicBlock$P_ArrayRef$Value$P_Twine$C(long ID2, int NumPatchBytes, Value ActualInvokee, BasicBlock NormalDest, BasicBlock UnwindDest, ArrayRef<Value> InvokeArgs, ArrayRef<Value> DeoptArgs, ArrayRef<Value> GCArgs) {
        return this.CreateGCStatepointInvoke_ulong_uint_Value$P_BasicBlock$P_ArrayRef$Value$P_Twine$C(ID2, NumPatchBytes, ActualInvokee, NormalDest, UnwindDest, InvokeArgs, DeoptArgs, GCArgs, new Twine(NativePointer.$EMPTY));
    }

    public InvokeInst CreateGCStatepointInvoke_ulong_uint_Value$P_BasicBlock$P_ArrayRef$Value$P_Twine$C(long ID2, int NumPatchBytes, Value ActualInvokee, BasicBlock NormalDest, BasicBlock UnwindDest, ArrayRef<Value> InvokeArgs, ArrayRef<Value> DeoptArgs, ArrayRef<Value> GCArgs, Twine Name) {
        return IRBuilderStatics.CreateGCStatepointInvokeCommon$Value(this, ID2, NumPatchBytes, ActualInvokee, NormalDest, UnwindDest, StatepointFlags.None.getValue(), (ArrayRef<Value>)new ArrayRef(InvokeArgs), (ArrayRef<Value>)new ArrayRef(llvm.None, true), (ArrayRef<Value>)new ArrayRef(DeoptArgs), (ArrayRef<Value>)new ArrayRef(GCArgs), Name);
    }

    public InvokeInst CreateGCStatepointInvoke(long ID2, int NumPatchBytes, Value ActualInvokee, BasicBlock NormalDest, BasicBlock UnwindDest, int Flags, ArrayRef<Use> InvokeArgs, ArrayRef<Use> TransitionArgs, ArrayRef<Use> DeoptArgs, ArrayRef<Value> GCArgs) {
        return this.CreateGCStatepointInvoke(ID2, NumPatchBytes, ActualInvokee, NormalDest, UnwindDest, Flags, InvokeArgs, TransitionArgs, DeoptArgs, GCArgs, new Twine(NativePointer.$EMPTY));
    }

    public InvokeInst CreateGCStatepointInvoke(long ID2, int NumPatchBytes, Value ActualInvokee, BasicBlock NormalDest, BasicBlock UnwindDest, int Flags, ArrayRef<Use> InvokeArgs, ArrayRef<Use> TransitionArgs, ArrayRef<Use> DeoptArgs, ArrayRef<Value> GCArgs, Twine Name) {
        return IRBuilderStatics.CreateGCStatepointInvokeCommon$Use(this, ID2, NumPatchBytes, ActualInvokee, NormalDest, UnwindDest, Flags, (ArrayRef<Use>)new ArrayRef(InvokeArgs), (ArrayRef<Use>)new ArrayRef(TransitionArgs), (ArrayRef<Use>)new ArrayRef(DeoptArgs), (ArrayRef<Value>)new ArrayRef(GCArgs), Name);
    }

    public InvokeInst CreateGCStatepointInvoke_ulong_uint_Value$P_BasicBlock$P_ArrayRef$Use_ArrayRef$Value$P_Twine$C(long ID2, int NumPatchBytes, Value ActualInvokee, BasicBlock NormalDest, BasicBlock UnwindDest, ArrayRef<Use> InvokeArgs, ArrayRef<Value> DeoptArgs, ArrayRef<Value> GCArgs) {
        return this.CreateGCStatepointInvoke_ulong_uint_Value$P_BasicBlock$P_ArrayRef$Use_ArrayRef$Value$P_Twine$C(ID2, NumPatchBytes, ActualInvokee, NormalDest, UnwindDest, InvokeArgs, DeoptArgs, GCArgs, new Twine(NativePointer.$EMPTY));
    }

    public InvokeInst CreateGCStatepointInvoke_ulong_uint_Value$P_BasicBlock$P_ArrayRef$Use_ArrayRef$Value$P_Twine$C(long ID2, int NumPatchBytes, Value ActualInvokee, BasicBlock NormalDest, BasicBlock UnwindDest, ArrayRef<Use> InvokeArgs, ArrayRef<Value> DeoptArgs, ArrayRef<Value> GCArgs, Twine Name) {
        return IRBuilderStatics.CreateGCStatepointInvokeCommon$UseValue(this, ID2, NumPatchBytes, ActualInvokee, NormalDest, UnwindDest, StatepointFlags.None.getValue(), (ArrayRef<Use>)new ArrayRef(InvokeArgs), (ArrayRef<Value>)new ArrayRef(llvm.None, true), (ArrayRef<Value>)new ArrayRef(DeoptArgs), (ArrayRef<Value>)new ArrayRef(GCArgs), Name);
    }

    public CallInst CreateGCResult(Instruction Statepoint2, Type ResultType) {
        return this.CreateGCResult(Statepoint2, ResultType, new Twine(NativePointer.$EMPTY));
    }

    public CallInst CreateGCResult(Instruction Statepoint2, Type ResultType, Twine Name) {
        int _ID = 47;
        Object M = this.BB.getParent().getParent();
        Object[] Types = new Type[]{ResultType};
        Function FnGCResult = IntrinsicGlobals.getDeclaration((Module$IR)M, _ID, (ArrayRef<Type>)new ArrayRef(Types, true));
        Object[] Args = new Value[]{Statepoint2};
        return IRBuilderStatics.createCallHelper(FnGCResult, (ArrayRef<Value>)new ArrayRef(Args, true), this, Name);
    }

    public CallInst CreateGCRelocate(Instruction Statepoint2, int BaseOffset, int DerivedOffset, Type ResultType) {
        return this.CreateGCRelocate(Statepoint2, BaseOffset, DerivedOffset, ResultType, new Twine(NativePointer.$EMPTY));
    }

    public CallInst CreateGCRelocate(Instruction Statepoint2, int BaseOffset, int DerivedOffset, Type ResultType, Twine Name) {
        Object M = this.BB.getParent().getParent();
        Object[] Types = new Type[]{ResultType};
        Function FnGCRelocate = IntrinsicGlobals.getDeclaration((Module$IR)M, 46, (ArrayRef<Type>)new ArrayRef(Types, true));
        Object[] Args = new Value[]{Statepoint2, this.getInt32(BaseOffset), this.getInt32(DerivedOffset)};
        return IRBuilderStatics.createCallHelper(FnGCRelocate, (ArrayRef<Value>)new ArrayRef(Args, true), this, Name);
    }

    private CallInst CreateMaskedIntrinsic(int Id, ArrayRef<Value> Ops, ArrayRef<Type> OverloadedTypes) {
        return this.CreateMaskedIntrinsic(Id, Ops, OverloadedTypes, new Twine(NativePointer.$EMPTY));
    }

    private CallInst CreateMaskedIntrinsic(int Id, ArrayRef<Value> Ops, ArrayRef<Type> OverloadedTypes, Twine Name) {
        Object M = this.BB.getParent().getParent();
        Function TheFn = IntrinsicGlobals.getDeclaration((Module$IR)M, Id, (ArrayRef<Type>)new ArrayRef(OverloadedTypes));
        return IRBuilderStatics.createCallHelper(TheFn, (ArrayRef<Value>)new ArrayRef(Ops), this, Name);
    }

    private Value getCastedInt8PtrValue(Value Ptr) {
        PointerType PT = IrRTTI.cast_PointerType(Ptr.getType());
        if (PT.getElementType().isIntegerTy(8)) {
            return Ptr;
        }
        PointerType $PTFinal = PT = this.getInt8PtrTy(PT.getAddressSpace());
        BitCastInst BCI = (BitCastInst)UnaryInstruction.$new_UnaryInstruction(New$Mem -> new BitCastInst(Ptr, $PTFinal, new Twine(NativePointer.$EMPTY)));
        this.BB.getInstList().insert_ilist_iterator$NodeTy_T$P(new ilist_iterator(this.InsertPt), (ilist_node)BCI);
        this.SetInstDebugLocation(BCI);
        return BCI;
    }

    public void $destroy() {
        this.CurDbgLocation.$destroy();
    }

    public IRBuilderBase(IRBuilderBase $Prm0) {
        this.CurDbgLocation = new DebugLoc($Prm0.CurDbgLocation);
        this.BB = $Prm0.BB;
        this.InsertPt = new ilist_iterator($Prm0.InsertPt);
        this.Context = $Prm0.Context;
        this.DefaultFPMathTag = $Prm0.DefaultFPMathTag;
        this.FMF = new FastMathFlags($Prm0.FMF);
        this.DefaultOperandBundles = new ArrayRef($Prm0.DefaultOperandBundles);
    }

    public String toString() {
        return "CurDbgLocation=" + this.CurDbgLocation + ", BB=" + this.BB + ", InsertPt=" + this.InsertPt + ", Context=[LLVMContext], DefaultFPMathTag=" + this.DefaultFPMathTag + ", FMF=" + this.FMF + ", DefaultOperandBundles=" + this.DefaultOperandBundles;
    }

    public static class FastMathFlagGuard
    implements Destructors.ClassWithDestructor {
        private final IRBuilderBase Builder;
        private FastMathFlags FMF;
        private MDNode FPMathTag;

        protected FastMathFlagGuard(FastMathFlagGuard $Prm0) {
            throw new UnsupportedOperationException("Deleted");
        }

        protected FastMathFlagGuard $assign(FastMathFlagGuard $Prm0) {
            throw new UnsupportedOperationException("Deleted");
        }

        public FastMathFlagGuard(IRBuilderBase B2) {
            this.Builder = B2;
            this.FMF = new FastMathFlags(B2.FMF);
            this.FPMathTag = B2.DefaultFPMathTag;
        }

        public void $destroy() {
            this.Builder.FMF.$assign(this.FMF);
            this.Builder.DefaultFPMathTag = this.FPMathTag;
        }

        public String toString() {
            return "Builder=" + this.Builder + ", FMF=" + this.FMF + ", FPMathTag=" + this.FPMathTag;
        }
    }

    public static class InsertPointGuard
    implements Destructors.ClassWithDestructor {
        private final IRBuilderBase Builder;
        private AssertingVH<BasicBlock> Block;
        private ilist_iterator<Instruction> Point;
        private DebugLoc DbgLoc;

        protected InsertPointGuard(InsertPointGuard $Prm0) {
            throw new UnsupportedOperationException("Deleted");
        }

        protected InsertPointGuard $assign(InsertPointGuard $Prm0) {
            throw new UnsupportedOperationException("Deleted");
        }

        public InsertPointGuard(IRBuilderBase B2) {
            this.Builder = B2;
            this.Block = new AssertingVH<BasicBlock>(B2.GetInsertBlock());
            this.Point = B2.GetInsertPoint();
            this.DbgLoc = new DebugLoc(B2.getCurrentDebugLocation());
        }

        public void $destroy() {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                this.Builder.restoreIP(new InsertPoint(this.Block.$T$P(), (ilist_iterator<Instruction>)new ilist_iterator(this.Point)));
                this.Builder.SetCurrentDebugLocation((DebugLoc)$c$.track((Object)new DebugLoc(this.DbgLoc)));
                $c$.clean();
            }
            finally {
                $c$.$destroy();
            }
            this.DbgLoc.$destroy();
            this.Block.$destroy();
        }

        public String toString() {
            return "Builder=" + this.Builder + ", Block=" + this.Block + ", Point=" + this.Point + ", DbgLoc=" + this.DbgLoc;
        }
    }

    public static class InsertPoint {
        private BasicBlock Block;
        private ilist_iterator<Instruction> Point;

        public InsertPoint() {
            this.Block = null;
            this.Point = new ilist_iterator((ilist_traits)new SymbolTableListTraits$Instruction());
        }

        public InsertPoint(BasicBlock InsertBlock, ilist_iterator<Instruction> InsertPoint2) {
            this.Block = InsertBlock;
            this.Point = new ilist_iterator(InsertPoint2);
        }

        public boolean isSet() {
            return this.Block != null;
        }

        public BasicBlock getBlock() {
            return this.Block;
        }

        public ilist_iterator<Instruction> getPoint() {
            return new ilist_iterator(this.Point);
        }

        public InsertPoint(InsertPoint $Prm0) {
            this.Block = $Prm0.Block;
            this.Point = new ilist_iterator($Prm0.Point);
        }

        public InsertPoint(JavaDifferentiators.JD.Move _dparam, InsertPoint $Prm0) {
            this.Block = $Prm0.Block;
            this.Point = new ilist_iterator(JavaDifferentiators.JD.Move.INSTANCE, $Prm0.Point);
        }

        public InsertPoint $assignMove(InsertPoint $Prm0) {
            this.Block = $Prm0.Block;
            this.Point.$assignMove($Prm0.Point);
            return this;
        }

        public String toString() {
            return "Block=" + this.Block + ", Point=" + this.Point;
        }
    }
}

