/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.llvm.adt.APInt;
import org.llvm.adt.Twine;
import org.llvm.ir.BasicBlock;
import org.llvm.ir.CmpInst;
import org.llvm.ir.ConstantRange;
import org.llvm.ir.Instruction;
import org.llvm.ir.Value;
import org.llvm.ir.java.IRJavaDifferentiators;
import org.llvm.ir.java.IrRTTI;
import org.llvm.support.llvm_unreachable;

public class ICmpInst
extends CmpInst
implements Destructors.ClassWithDestructor {
    @Override
    protected void anchor() {
    }

    private void AssertOK() {
        assert (this.getPredicate().getValue() >= CmpInst.Predicate.FIRST_ICMP_PREDICATE.getValue() && this.getPredicate().getValue() <= CmpInst.Predicate.LAST_ICMP_PREDICATE.getValue()) : "Invalid ICmp predicate value";
        assert (this.getOperand(0).getType() == this.getOperand(1).getType()) : "Both operands to ICmp instruction are not of the same type!";
        assert (this.getOperand(0).getType().isIntOrIntVectorTy() || this.getOperand(0).getType().isPtrOrPtrVectorTy()) : "Invalid operand types for ICmp instruction";
    }

    protected ICmpInst cloneImpl() {
        return (ICmpInst)CmpInst.$new_CmpInst(New$Mem -> new ICmpInst(this.getPredicate(), this.Op$Const(0).$Value$P(), this.Op$Const(1).$Value$P()));
    }

    public ICmpInst(Instruction InsertBefore, CmpInst.Predicate pred, Value LHS, Value RHS) {
        this(InsertBefore, pred, LHS, RHS, new Twine(NativePointer.$EMPTY));
    }

    public ICmpInst(Instruction InsertBefore, CmpInst.Predicate pred, Value LHS, Value RHS, Twine NameStr) {
        super(IRJavaDifferentiators.JD.Type.P_OtherOps_Predicate_Value.P_Twine.C_Instruction.P.INSTANCE, CmpInst.makeCmpResultType(LHS.getType()), 51, pred, LHS, RHS, NameStr, InsertBefore);
        this.AssertOK();
    }

    public ICmpInst(BasicBlock InsertAtEnd, CmpInst.Predicate pred, Value LHS, Value RHS) {
        this(InsertAtEnd, pred, LHS, RHS, new Twine(NativePointer.$EMPTY));
    }

    public ICmpInst(BasicBlock InsertAtEnd, CmpInst.Predicate pred, Value LHS, Value RHS, Twine NameStr) {
        super(IRJavaDifferentiators.JD.Type.P_OtherOps_Predicate_Value.P_Twine.C_BasicBlock.P.INSTANCE, CmpInst.makeCmpResultType(LHS.getType()), 51, pred, LHS, RHS, NameStr, (BasicBlock)Native.$AddrOf((Object)InsertAtEnd));
        this.AssertOK();
    }

    public ICmpInst(CmpInst.Predicate pred, Value LHS, Value RHS) {
        this(pred, LHS, RHS, new Twine(NativePointer.$EMPTY));
    }

    public ICmpInst(CmpInst.Predicate pred, Value LHS, Value RHS, Twine NameStr) {
        super(IRJavaDifferentiators.JD.Type.P_OtherOps_Predicate_Value.P_Twine.C_Instruction.P.INSTANCE, CmpInst.makeCmpResultType(LHS.getType()), 51, pred, LHS, RHS, NameStr);
        this.AssertOK();
    }

    @Override
    public CmpInst.Predicate getSignedPredicate() {
        return ICmpInst.getSignedPredicate(this.getPredicate());
    }

    public static CmpInst.Predicate getSignedPredicate(CmpInst.Predicate pred) {
        switch (pred) {
            default: {
                throw new llvm_unreachable("Unknown icmp predicate!");
            }
            case ICMP_EQ: 
            case ICMP_NE: 
            case ICMP_SGT: 
            case ICMP_SLT: 
            case ICMP_SGE: 
            case ICMP_SLE: {
                return pred;
            }
            case ICMP_UGT: {
                return CmpInst.Predicate.ICMP_SGT;
            }
            case ICMP_ULT: {
                return CmpInst.Predicate.ICMP_SLT;
            }
            case ICMP_UGE: {
                return CmpInst.Predicate.ICMP_SGE;
            }
            case ICMP_ULE: 
        }
        return CmpInst.Predicate.ICMP_SLE;
    }

    public CmpInst.Predicate getUnsignedPredicate() {
        return ICmpInst.getUnsignedPredicate(this.getPredicate());
    }

    public static CmpInst.Predicate getUnsignedPredicate(CmpInst.Predicate pred) {
        switch (pred) {
            default: {
                throw new llvm_unreachable("Unknown icmp predicate!");
            }
            case ICMP_EQ: 
            case ICMP_NE: 
            case ICMP_UGT: 
            case ICMP_ULT: 
            case ICMP_UGE: 
            case ICMP_ULE: {
                return pred;
            }
            case ICMP_SGT: {
                return CmpInst.Predicate.ICMP_UGT;
            }
            case ICMP_SLT: {
                return CmpInst.Predicate.ICMP_ULT;
            }
            case ICMP_SGE: {
                return CmpInst.Predicate.ICMP_UGE;
            }
            case ICMP_SLE: 
        }
        return CmpInst.Predicate.ICMP_ULE;
    }

    public static boolean isEquality(CmpInst.Predicate P2) {
        return P2 == CmpInst.Predicate.ICMP_EQ || P2 == CmpInst.Predicate.ICMP_NE;
    }

    @Override
    public boolean isEquality() {
        return ICmpInst.isEquality(this.getPredicate());
    }

    @Override
    public boolean isCommutative() {
        return this.isEquality();
    }

    public boolean isRelational() {
        return !this.isEquality();
    }

    public static boolean isRelational(CmpInst.Predicate P2) {
        return !ICmpInst.isEquality(P2);
    }

    public static ConstantRange makeConstantRange(CmpInst.Predicate pred, APInt C2) {
        APInt Lower = new APInt(C2);
        APInt Upper = new APInt(C2);
        int BitWidth = C2.getBitWidth();
        switch (pred) {
            default: {
                throw new llvm_unreachable("Invalid ICmp opcode to ConstantRange ctor!");
            }
            case ICMP_EQ: {
                Upper.$preInc();
                break;
            }
            case ICMP_NE: {
                Lower.$preInc();
                break;
            }
            case ICMP_ULT: {
                Lower.$assignMove(APInt.getMinValue((int)BitWidth));
                if (!Lower.$eq(Upper)) break;
                return new ConstantRange(BitWidth, false);
            }
            case ICMP_SLT: {
                Lower.$assignMove(APInt.getSignedMinValue((int)BitWidth));
                if (!Lower.$eq(Upper)) break;
                return new ConstantRange(BitWidth, false);
            }
            case ICMP_UGT: {
                Lower.$preInc();
                Upper.$assignMove(APInt.getMinValue((int)BitWidth));
                if (!Lower.$eq(Upper)) break;
                return new ConstantRange(BitWidth, false);
            }
            case ICMP_SGT: {
                Lower.$preInc();
                Upper.$assignMove(APInt.getSignedMinValue((int)BitWidth));
                if (!Lower.$eq(Upper)) break;
                return new ConstantRange(BitWidth, false);
            }
            case ICMP_ULE: {
                Lower.$assignMove(APInt.getMinValue((int)BitWidth));
                Upper.$preInc();
                if (!Lower.$eq(Upper)) break;
                return new ConstantRange(BitWidth, true);
            }
            case ICMP_SLE: {
                Lower.$assignMove(APInt.getSignedMinValue((int)BitWidth));
                Upper.$preInc();
                if (!Lower.$eq(Upper)) break;
                return new ConstantRange(BitWidth, true);
            }
            case ICMP_UGE: {
                Upper.$assignMove(APInt.getMinValue((int)BitWidth));
                if (!Lower.$eq(Upper)) break;
                return new ConstantRange(BitWidth, true);
            }
            case ICMP_SGE: {
                Upper.$assignMove(APInt.getSignedMinValue((int)BitWidth));
                if (!Lower.$eq(Upper)) break;
                return new ConstantRange(BitWidth, true);
            }
        }
        return new ConstantRange(new APInt(Lower), new APInt(Upper));
    }

    @Override
    public void swapOperands() {
        this.setPredicate(this.getSwappedPredicate());
        this.Op(0).swap(this.Op(1));
    }

    public static boolean classof(Instruction I) {
        return I.getOpcode() == 51;
    }

    public static boolean classof(Value V) {
        return IrRTTI.isa_Instruction(V) && ICmpInst.classof(IrRTTI.cast_Instruction(V));
    }

    @Override
    public void $destroy() {
        super.$destroy();
    }

    @Override
    public String toString() {
        return "" + super.toString();
    }
}

