/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.clank.java.std;
import org.clank.java.std_errors;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.type;
import org.llvm.adt.StringRef;
import org.llvm.adt.Triple;
import org.llvm.adt.Twine;
import org.llvm.ir.Comdat;
import org.llvm.ir.Constant;
import org.llvm.ir.Function;
import org.llvm.ir.GlobalAlias;
import org.llvm.ir.GlobalObject;
import org.llvm.ir.GlobalVariable;
import org.llvm.ir.Module$IR;
import org.llvm.ir.PointerType;
import org.llvm.ir.Type;
import org.llvm.ir.Use;
import org.llvm.ir.Value;
import org.llvm.ir.java.IrRTTI;
import org.llvm.support.AdtsupportLlvmGlobals;
import org.llvm.support.llvm_unreachable;

public abstract class GlobalValue
extends Constant
implements Destructors.ClassWithDestructor {
    protected Type ValueType;
    protected byte Linkage;
    protected byte Visibility;
    protected byte UnnamedAddrVal;
    protected byte DllStorageClass;
    protected byte ThreadLocal;
    protected static int GlobalValueSubClassDataBits = 19;
    private int SubClassData;
    protected int IntID;
    protected Module$IR Parent;

    protected GlobalValue(GlobalValue $Prm0) {
        super($Prm0);
        throw new UnsupportedOperationException("Deleted");
    }

    protected GlobalValue(Type Ty, Value.ValueTy VTy, type.ptr<Use> Ops, int NumOps, LinkageTypes Linkage, Twine Name, int AddressSpace) {
        super((Type)PointerType.get(Ty, AddressSpace), VTy, Ops, NumOps);
        this.ValueType = Ty;
        this.Linkage = Unsigned.$uint2uint_4bits((int)Linkage.getValue());
        this.Visibility = Unsigned.$uint2uint_2bits((int)VisibilityTypes.DefaultVisibility.getValue());
        this.UnnamedAddrVal = Unsigned.$uint2uint_2bits((int)UnnamedAddr.None.getValue());
        this.DllStorageClass = Unsigned.$uint2uint_2bits((int)DLLStorageClassTypes.DefaultStorageClass.getValue());
        this.ThreadLocal = Unsigned.$uint2uint_3bits((int)ThreadLocalMode.NotThreadLocal.getValue());
        this.IntID = 0;
        this.Parent = null;
        this.setName(Name);
    }

    void destroyConstantImpl() {
        throw new llvm_unreachable("You can't GV->destroyConstantImpl()!");
    }

    Value handleOperandChangeImpl(Value From, Value To) {
        throw new llvm_unreachable("Unsupported class for handleOperandChange()!");
    }

    private boolean mayBeDerefined() {
        switch (this.getLinkage()) {
            case WeakODRLinkage: 
            case LinkOnceODRLinkage: 
            case AvailableExternallyLinkage: {
                return true;
            }
            case WeakAnyLinkage: 
            case LinkOnceAnyLinkage: 
            case CommonLinkage: 
            case ExternalWeakLinkage: 
            case ExternalLinkage: 
            case AppendingLinkage: 
            case InternalLinkage: 
            case PrivateLinkage: {
                return this.isInterposable();
            }
        }
        throw new llvm_unreachable("Fully covered switch above!");
    }

    protected int getGlobalValueSubClassData() {
        return this.SubClassData;
    }

    protected void setGlobalValueSubClassData(int V) {
        assert (Unsigned.$less_uint((int)V, (int)(1 << GlobalValueSubClassDataBits))) : "It will not fit";
        this.SubClassData = V;
    }

    @Override
    public void $destroy() {
        this.removeDeadConstantUsers();
        super.$destroy();
    }

    public int getAlignment() {
        GlobalAlias GA = IrRTTI.dyn_cast_GlobalAlias(this);
        if (GA != null) {
            GlobalObject GO = GA.getBaseObject$Const();
            if (GO != null) {
                return GO.getAlignment();
            }
            return 0;
        }
        return IrRTTI.cast_GlobalObject(this).getAlignment();
    }

    public boolean hasGlobalUnnamedAddr() {
        return this.getUnnamedAddr() == UnnamedAddr.Global;
    }

    public boolean hasAtLeastLocalUnnamedAddr() {
        return this.getUnnamedAddr() != UnnamedAddr.None;
    }

    public UnnamedAddr getUnnamedAddr() {
        return UnnamedAddr.valueOf(Unsigned.$2bits_uint2uint((byte)this.UnnamedAddrVal));
    }

    public void setUnnamedAddr(UnnamedAddr Val) {
        this.UnnamedAddrVal = Unsigned.$uint2uint_2bits((int)Val.getValue());
    }

    public static UnnamedAddr getMinUnnamedAddr(UnnamedAddr A2, UnnamedAddr B2) {
        if (A2 == UnnamedAddr.None || B2 == UnnamedAddr.None) {
            return UnnamedAddr.None;
        }
        if (A2 == UnnamedAddr.Local || B2 == UnnamedAddr.Local) {
            return UnnamedAddr.Local;
        }
        return UnnamedAddr.Global;
    }

    public boolean hasComdat() {
        return this.getComdat$Const() != null;
    }

    public Comdat getComdat() {
        GlobalAlias GA = IrRTTI.dyn_cast_GlobalAlias(this);
        if (GA != null) {
            GlobalObject GO = GA.getBaseObject();
            if (GO != null) {
                return GO.getComdat();
            }
            return null;
        }
        if (IrRTTI.isa_GlobalIFunc(this)) {
            return null;
        }
        return IrRTTI.cast_GlobalObject(this).getComdat();
    }

    public Comdat getComdat$Const() {
        return this.getComdat();
    }

    public VisibilityTypes getVisibility() {
        return VisibilityTypes.valueOf(Unsigned.$2bits_uint2uint((byte)this.Visibility));
    }

    public boolean hasDefaultVisibility() {
        return Unsigned.$2bits_uint2uint((byte)this.Visibility) == VisibilityTypes.DefaultVisibility.getValue();
    }

    public boolean hasHiddenVisibility() {
        return Unsigned.$2bits_uint2uint((byte)this.Visibility) == VisibilityTypes.HiddenVisibility.getValue();
    }

    public boolean hasProtectedVisibility() {
        return Unsigned.$2bits_uint2uint((byte)this.Visibility) == VisibilityTypes.ProtectedVisibility.getValue();
    }

    public void setVisibility(VisibilityTypes V) {
        assert (!this.hasLocalLinkage() || V == VisibilityTypes.DefaultVisibility) : "local linkage requires default visibility";
        this.Visibility = Unsigned.$uint2uint_2bits((int)V.getValue());
    }

    public boolean isThreadLocal() {
        return this.getThreadLocalMode() != ThreadLocalMode.NotThreadLocal;
    }

    public void setThreadLocal(boolean Val) {
        this.setThreadLocalMode(Val ? ThreadLocalMode.GeneralDynamicTLSModel : ThreadLocalMode.NotThreadLocal);
    }

    public void setThreadLocalMode(ThreadLocalMode Val) {
        assert (Val == ThreadLocalMode.NotThreadLocal || this.getValueID() != Value.ValueTy.FunctionVal.getValue());
        this.ThreadLocal = Unsigned.$uint2uint_3bits((int)Val.getValue());
    }

    public ThreadLocalMode getThreadLocalMode() {
        return ThreadLocalMode.valueOf(Unsigned.$3bits_uint2uint((byte)this.ThreadLocal));
    }

    public DLLStorageClassTypes getDLLStorageClass() {
        return DLLStorageClassTypes.valueOf(Unsigned.$2bits_uint2uint((byte)this.DllStorageClass));
    }

    public boolean hasDLLImportStorageClass() {
        return Unsigned.$2bits_uint2uint((byte)this.DllStorageClass) == DLLStorageClassTypes.DLLImportStorageClass.getValue();
    }

    public boolean hasDLLExportStorageClass() {
        return Unsigned.$2bits_uint2uint((byte)this.DllStorageClass) == DLLStorageClassTypes.DLLExportStorageClass.getValue();
    }

    public void setDLLStorageClass(DLLStorageClassTypes C2) {
        this.DllStorageClass = Unsigned.$uint2uint_2bits((int)C2.getValue());
    }

    public boolean hasSection() {
        return !this.getSection().empty();
    }

    public StringRef getSection() {
        GlobalAlias GA = IrRTTI.dyn_cast_GlobalAlias(this);
        if (GA != null) {
            GlobalObject GO = GA.getBaseObject$Const();
            if (GO != null) {
                return GO.getSection();
            }
            return new StringRef(NativePointer.$EMPTY);
        }
        return IrRTTI.cast_GlobalObject(this).getSection();
    }

    @Override
    public PointerType getType() {
        return IrRTTI.cast_PointerType(super.getType());
    }

    public Type getValueType() {
        return this.ValueType;
    }

    public static LinkageTypes getLinkOnceLinkage(boolean ODR) {
        return ODR ? LinkageTypes.LinkOnceODRLinkage : LinkageTypes.LinkOnceAnyLinkage;
    }

    public static LinkageTypes getWeakLinkage(boolean ODR) {
        return ODR ? LinkageTypes.WeakODRLinkage : LinkageTypes.WeakAnyLinkage;
    }

    public static boolean isExternalLinkage(LinkageTypes Linkage) {
        return Linkage == LinkageTypes.ExternalLinkage;
    }

    public static boolean isAvailableExternallyLinkage(LinkageTypes Linkage) {
        return Linkage == LinkageTypes.AvailableExternallyLinkage;
    }

    public static boolean isLinkOnceODRLinkage(LinkageTypes Linkage) {
        return Linkage == LinkageTypes.LinkOnceODRLinkage;
    }

    public static boolean isLinkOnceLinkage(LinkageTypes Linkage) {
        return Linkage == LinkageTypes.LinkOnceAnyLinkage || Linkage == LinkageTypes.LinkOnceODRLinkage;
    }

    public static boolean isWeakAnyLinkage(LinkageTypes Linkage) {
        return Linkage == LinkageTypes.WeakAnyLinkage;
    }

    public static boolean isWeakODRLinkage(LinkageTypes Linkage) {
        return Linkage == LinkageTypes.WeakODRLinkage;
    }

    public static boolean isWeakLinkage(LinkageTypes Linkage) {
        return GlobalValue.isWeakAnyLinkage(Linkage) || GlobalValue.isWeakODRLinkage(Linkage);
    }

    public static boolean isAppendingLinkage(LinkageTypes Linkage) {
        return Linkage == LinkageTypes.AppendingLinkage;
    }

    public static boolean isInternalLinkage(LinkageTypes Linkage) {
        return Linkage == LinkageTypes.InternalLinkage;
    }

    public static boolean isPrivateLinkage(LinkageTypes Linkage) {
        return Linkage == LinkageTypes.PrivateLinkage;
    }

    public static boolean isLocalLinkage(LinkageTypes Linkage) {
        return GlobalValue.isInternalLinkage(Linkage) || GlobalValue.isPrivateLinkage(Linkage);
    }

    public static boolean isExternalWeakLinkage(LinkageTypes Linkage) {
        return Linkage == LinkageTypes.ExternalWeakLinkage;
    }

    public static boolean isCommonLinkage(LinkageTypes Linkage) {
        return Linkage == LinkageTypes.CommonLinkage;
    }

    public static boolean isValidDeclarationLinkage(LinkageTypes Linkage) {
        return GlobalValue.isExternalWeakLinkage(Linkage) || GlobalValue.isExternalLinkage(Linkage);
    }

    public static boolean isInterposableLinkage(LinkageTypes Linkage) {
        switch (Linkage) {
            case WeakAnyLinkage: 
            case LinkOnceAnyLinkage: 
            case CommonLinkage: 
            case ExternalWeakLinkage: {
                return true;
            }
            case WeakODRLinkage: 
            case LinkOnceODRLinkage: 
            case AvailableExternallyLinkage: 
            case ExternalLinkage: 
            case AppendingLinkage: 
            case InternalLinkage: 
            case PrivateLinkage: {
                return false;
            }
        }
        throw new llvm_unreachable("Fully covered switch above!");
    }

    public static boolean isDiscardableIfUnused(LinkageTypes Linkage) {
        return GlobalValue.isLinkOnceLinkage(Linkage) || GlobalValue.isLocalLinkage(Linkage) || GlobalValue.isAvailableExternallyLinkage(Linkage);
    }

    public static boolean isWeakForLinker(LinkageTypes Linkage) {
        return Linkage == LinkageTypes.WeakAnyLinkage || Linkage == LinkageTypes.WeakODRLinkage || Linkage == LinkageTypes.LinkOnceAnyLinkage || Linkage == LinkageTypes.LinkOnceODRLinkage || Linkage == LinkageTypes.CommonLinkage || Linkage == LinkageTypes.ExternalWeakLinkage;
    }

    public boolean isDefinitionExact() {
        return !this.mayBeDerefined();
    }

    public boolean hasExactDefinition() {
        return !this.isDeclaration() && this.isDefinitionExact();
    }

    public boolean isInterposable() {
        return GlobalValue.isInterposableLinkage(this.getLinkage());
    }

    public boolean hasExternalLinkage() {
        return GlobalValue.isExternalLinkage(this.getLinkage());
    }

    public boolean hasAvailableExternallyLinkage() {
        return GlobalValue.isAvailableExternallyLinkage(this.getLinkage());
    }

    public boolean hasLinkOnceLinkage() {
        return GlobalValue.isLinkOnceLinkage(this.getLinkage());
    }

    public boolean hasLinkOnceODRLinkage() {
        return GlobalValue.isLinkOnceODRLinkage(this.getLinkage());
    }

    public boolean hasWeakLinkage() {
        return GlobalValue.isWeakLinkage(this.getLinkage());
    }

    public boolean hasWeakAnyLinkage() {
        return GlobalValue.isWeakAnyLinkage(this.getLinkage());
    }

    public boolean hasWeakODRLinkage() {
        return GlobalValue.isWeakODRLinkage(this.getLinkage());
    }

    public boolean hasAppendingLinkage() {
        return GlobalValue.isAppendingLinkage(this.getLinkage());
    }

    public boolean hasInternalLinkage() {
        return GlobalValue.isInternalLinkage(this.getLinkage());
    }

    public boolean hasPrivateLinkage() {
        return GlobalValue.isPrivateLinkage(this.getLinkage());
    }

    public boolean hasLocalLinkage() {
        return GlobalValue.isLocalLinkage(this.getLinkage());
    }

    public boolean hasExternalWeakLinkage() {
        return GlobalValue.isExternalWeakLinkage(this.getLinkage());
    }

    public boolean hasCommonLinkage() {
        return GlobalValue.isCommonLinkage(this.getLinkage());
    }

    public boolean hasValidDeclarationLinkage() {
        return GlobalValue.isValidDeclarationLinkage(this.getLinkage());
    }

    public void setLinkage(LinkageTypes LT) {
        if (GlobalValue.isLocalLinkage(LT)) {
            this.Visibility = Unsigned.$uint2uint_2bits((int)VisibilityTypes.DefaultVisibility.getValue());
        }
        this.Linkage = Unsigned.$uint2uint_4bits((int)LT.getValue());
    }

    public LinkageTypes getLinkage() {
        return LinkageTypes.valueOf(Unsigned.$4bits_uint2uint((byte)this.Linkage));
    }

    public boolean isDiscardableIfUnused() {
        return GlobalValue.isDiscardableIfUnused(this.getLinkage());
    }

    public boolean isWeakForLinker() {
        return GlobalValue.isWeakForLinker(this.getLinkage());
    }

    public void copyAttributesFrom(GlobalValue Src) {
        this.setVisibility(Src.getVisibility());
        this.setUnnamedAddr(Src.getUnnamedAddr());
        this.setDLLStorageClass(Src.getDLLStorageClass());
    }

    public static StringRef getRealLinkageName(StringRef Name) {
        if (!Name.empty() && Name.$at(0) == 1) {
            return Name.substr(1);
        }
        return new StringRef(JavaDifferentiators.JD.Move.INSTANCE, Name);
    }

    public static std.string getGlobalIdentifier(StringRef Name, LinkageTypes Linkage, StringRef FileName) {
        if (Name.$at(0) == 1) {
            Name.$assignMove(Name.substr(1));
        }
        std.string NewName = Name.$string();
        if (GlobalValue.isLocalLinkage(Linkage)) {
            if (FileName.empty()) {
                NewName.$assign(NewName.insert_size_type$_CharT_T$C$P(0, NativePointer.$((String)"<unknown>:")));
            } else {
                NewName.$assign(NewName.insert(0, std.$add_string_T$C$P((std.string)FileName.str(), (String)":")));
            }
        }
        return NewName;
    }

    public std.string getGlobalIdentifier() {
        return GlobalValue.getGlobalIdentifier(this.getName(), this.getLinkage(), new StringRef(this.getParent$Const().getSourceFileName()));
    }

    public static long getGUID(StringRef GlobalName) {
        return AdtsupportLlvmGlobals.MD5Hash((StringRef)new StringRef(GlobalName));
    }

    public long getGUID() {
        return GlobalValue.getGUID(new StringRef(this.getGlobalIdentifier()));
    }

    public boolean isMaterializable() {
        Function F = IrRTTI.dyn_cast_Function(this);
        if (F != null) {
            return F.isMaterializable();
        }
        return false;
    }

    public std_errors.error_code materialize() {
        return this.getParent().materialize(this);
    }

    public boolean isDeclaration() {
        GlobalVariable GV = IrRTTI.dyn_cast_GlobalVariable(this);
        if (GV != null) {
            return GV.getNumOperands() == 0;
        }
        Function F = IrRTTI.dyn_cast_Function(this);
        if (F != null) {
            return F.empty() && !F.isMaterializable();
        }
        assert (IrRTTI.isa_GlobalIndirectSymbol(this));
        return false;
    }

    public boolean isDeclarationForLinker() {
        if (this.hasAvailableExternallyLinkage()) {
            return true;
        }
        return this.isDeclaration();
    }

    public boolean isStrongDefinitionForLinker() {
        return !this.isDeclarationForLinker() && !this.isWeakForLinker();
    }

    public boolean canIncreaseAlignment() {
        boolean isELF;
        if (!this.isStrongDefinitionForLinker()) {
            return false;
        }
        if (this.hasSection() && Unsigned.$greater_uint((int)this.getAlignment(), (int)0)) {
            return false;
        }
        boolean bl = isELF = this.Parent == null || new Triple(new Twine(this.Parent.getTargetTriple())).isOSBinFormatELF();
        return !isELF || !this.hasDefaultVisibility() || this.hasLocalLinkage();
    }

    public abstract void removeFromParent();

    public abstract void eraseFromParent();

    public Module$IR getParent() {
        return this.Parent;
    }

    public Module$IR getParent$Const() {
        return this.Parent;
    }

    public static boolean classof(Value V) {
        return V.getValueID() == Value.ValueTy.FunctionVal.getValue() || V.getValueID() == Value.ValueTy.GlobalVariableVal.getValue() || V.getValueID() == Value.ValueTy.GlobalAliasVal.getValue() || V.getValueID() == Value.ValueTy.GlobalIFuncVal.getValue();
    }

    protected GlobalValue() {
    }

    @Override
    public String toString() {
        if (this.$isSentinel()) {
            return "Sentinel " + this.getClass().getSimpleName();
        }
        return "ValueType=" + this.ValueType + ", Linkage=" + Unsigned.$uchar2uint((byte)this.Linkage) + ", Visibility=" + Unsigned.$uchar2uint((byte)this.Visibility) + ", UnnamedAddrVal=" + Unsigned.$uchar2uint((byte)this.UnnamedAddrVal) + ", DllStorageClass=" + Unsigned.$uchar2uint((byte)this.DllStorageClass) + ", ThreadLocal=" + Unsigned.$uchar2uint((byte)this.ThreadLocal) + ", SubClassData=" + this.SubClassData + ", IntID=" + this.IntID + ", Parent=" + this.Parent + super.toString();
    }

    public static final class UnnamedAddr
    extends Enum<UnnamedAddr>
    implements Native.NativeIntEnum {
        public static final /* enum */ UnnamedAddr None = new UnnamedAddr(0);
        public static final /* enum */ UnnamedAddr Local = new UnnamedAddr(None.getValue() + 1);
        public static final /* enum */ UnnamedAddr Global = new UnnamedAddr(Local.getValue() + 1);
        private final int value;
        private static final /* synthetic */ UnnamedAddr[] $VALUES;

        public static UnnamedAddr[] values() {
            return (UnnamedAddr[])$VALUES.clone();
        }

        public static UnnamedAddr valueOf(String name) {
            return Enum.valueOf(UnnamedAddr.class, name);
        }

        public static UnnamedAddr valueOf(int val) {
            UnnamedAddr out;
            UnnamedAddr unnamedAddr = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private UnnamedAddr(int val) {
            this.value = val;
        }

        public final int getValue() {
            return this.value;
        }

        static {
            $VALUES = new UnnamedAddr[]{None, Local, Global};
        }

        private static final class Values {
            private static final UnnamedAddr[] VALUES;
            private static final UnnamedAddr[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (UnnamedAddr kind : UnnamedAddr.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new UnnamedAddr[min < 0 ? 1 - min : 0];
                VALUES = new UnnamedAddr[max >= 0 ? 1 + max : 0];
                for (UnnamedAddr kind : UnnamedAddr.values()) {
                    if (kind.value < 0) {
                        if (_VALUES[-kind.value] != null) continue;
                        Values._VALUES[-((UnnamedAddr)kind).value] = kind;
                        continue;
                    }
                    if (VALUES[kind.value] != null) continue;
                    Values.VALUES[((UnnamedAddr)kind).value] = kind;
                }
            }
        }
    }

    public static final class ThreadLocalMode
    extends Enum<ThreadLocalMode>
    implements Native.NativeUIntEnum {
        public static final /* enum */ ThreadLocalMode NotThreadLocal = new ThreadLocalMode(0);
        public static final /* enum */ ThreadLocalMode GeneralDynamicTLSModel = new ThreadLocalMode(NotThreadLocal.getValue() + 1);
        public static final /* enum */ ThreadLocalMode LocalDynamicTLSModel = new ThreadLocalMode(GeneralDynamicTLSModel.getValue() + 1);
        public static final /* enum */ ThreadLocalMode InitialExecTLSModel = new ThreadLocalMode(LocalDynamicTLSModel.getValue() + 1);
        public static final /* enum */ ThreadLocalMode LocalExecTLSModel = new ThreadLocalMode(InitialExecTLSModel.getValue() + 1);
        private final int value;
        private static final /* synthetic */ ThreadLocalMode[] $VALUES;

        public static ThreadLocalMode[] values() {
            return (ThreadLocalMode[])$VALUES.clone();
        }

        public static ThreadLocalMode valueOf(String name) {
            return Enum.valueOf(ThreadLocalMode.class, name);
        }

        public static ThreadLocalMode valueOf(int val) {
            ThreadLocalMode out;
            ThreadLocalMode threadLocalMode = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private ThreadLocalMode(int val) {
            this.value = val;
        }

        public final int getValue() {
            return this.value;
        }

        static {
            $VALUES = new ThreadLocalMode[]{NotThreadLocal, GeneralDynamicTLSModel, LocalDynamicTLSModel, InitialExecTLSModel, LocalExecTLSModel};
        }

        private static final class Values {
            private static final ThreadLocalMode[] VALUES;
            private static final ThreadLocalMode[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (ThreadLocalMode kind : ThreadLocalMode.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new ThreadLocalMode[min < 0 ? 1 - min : 0];
                VALUES = new ThreadLocalMode[max >= 0 ? 1 + max : 0];
                for (ThreadLocalMode kind : ThreadLocalMode.values()) {
                    if (kind.value < 0) {
                        if (_VALUES[-kind.value] != null) continue;
                        Values._VALUES[-((ThreadLocalMode)kind).value] = kind;
                        continue;
                    }
                    if (VALUES[kind.value] != null) continue;
                    Values.VALUES[((ThreadLocalMode)kind).value] = kind;
                }
            }
        }
    }

    public static final class DLLStorageClassTypes
    extends Enum<DLLStorageClassTypes>
    implements Native.NativeUIntEnum {
        public static final /* enum */ DLLStorageClassTypes DefaultStorageClass = new DLLStorageClassTypes(0);
        public static final /* enum */ DLLStorageClassTypes DLLImportStorageClass = new DLLStorageClassTypes(1);
        public static final /* enum */ DLLStorageClassTypes DLLExportStorageClass = new DLLStorageClassTypes(2);
        private final int value;
        private static final /* synthetic */ DLLStorageClassTypes[] $VALUES;

        public static DLLStorageClassTypes[] values() {
            return (DLLStorageClassTypes[])$VALUES.clone();
        }

        public static DLLStorageClassTypes valueOf(String name) {
            return Enum.valueOf(DLLStorageClassTypes.class, name);
        }

        public static DLLStorageClassTypes valueOf(int val) {
            DLLStorageClassTypes out;
            DLLStorageClassTypes dLLStorageClassTypes = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private DLLStorageClassTypes(int val) {
            this.value = val;
        }

        public final int getValue() {
            return this.value;
        }

        static {
            $VALUES = new DLLStorageClassTypes[]{DefaultStorageClass, DLLImportStorageClass, DLLExportStorageClass};
        }

        private static final class Values {
            private static final DLLStorageClassTypes[] VALUES;
            private static final DLLStorageClassTypes[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (DLLStorageClassTypes kind : DLLStorageClassTypes.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new DLLStorageClassTypes[min < 0 ? 1 - min : 0];
                VALUES = new DLLStorageClassTypes[max >= 0 ? 1 + max : 0];
                for (DLLStorageClassTypes kind : DLLStorageClassTypes.values()) {
                    if (kind.value < 0) {
                        if (_VALUES[-kind.value] != null) continue;
                        Values._VALUES[-((DLLStorageClassTypes)kind).value] = kind;
                        continue;
                    }
                    if (VALUES[kind.value] != null) continue;
                    Values.VALUES[((DLLStorageClassTypes)kind).value] = kind;
                }
            }
        }
    }

    public static final class VisibilityTypes
    extends Enum<VisibilityTypes>
    implements Native.NativeUIntEnum {
        public static final /* enum */ VisibilityTypes DefaultVisibility = new VisibilityTypes(0);
        public static final /* enum */ VisibilityTypes HiddenVisibility = new VisibilityTypes(DefaultVisibility.getValue() + 1);
        public static final /* enum */ VisibilityTypes ProtectedVisibility = new VisibilityTypes(HiddenVisibility.getValue() + 1);
        private final int value;
        private static final /* synthetic */ VisibilityTypes[] $VALUES;

        public static VisibilityTypes[] values() {
            return (VisibilityTypes[])$VALUES.clone();
        }

        public static VisibilityTypes valueOf(String name) {
            return Enum.valueOf(VisibilityTypes.class, name);
        }

        public static VisibilityTypes valueOf(int val) {
            VisibilityTypes out;
            VisibilityTypes visibilityTypes = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private VisibilityTypes(int val) {
            this.value = val;
        }

        public final int getValue() {
            return this.value;
        }

        static {
            $VALUES = new VisibilityTypes[]{DefaultVisibility, HiddenVisibility, ProtectedVisibility};
        }

        private static final class Values {
            private static final VisibilityTypes[] VALUES;
            private static final VisibilityTypes[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (VisibilityTypes kind : VisibilityTypes.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new VisibilityTypes[min < 0 ? 1 - min : 0];
                VALUES = new VisibilityTypes[max >= 0 ? 1 + max : 0];
                for (VisibilityTypes kind : VisibilityTypes.values()) {
                    if (kind.value < 0) {
                        if (_VALUES[-kind.value] != null) continue;
                        Values._VALUES[-((VisibilityTypes)kind).value] = kind;
                        continue;
                    }
                    if (VALUES[kind.value] != null) continue;
                    Values.VALUES[((VisibilityTypes)kind).value] = kind;
                }
            }
        }
    }

    public static final class LinkageTypes
    extends Enum<LinkageTypes>
    implements Native.NativeUIntEnum {
        public static final /* enum */ LinkageTypes ExternalLinkage = new LinkageTypes(0);
        public static final /* enum */ LinkageTypes AvailableExternallyLinkage = new LinkageTypes(ExternalLinkage.getValue() + 1);
        public static final /* enum */ LinkageTypes LinkOnceAnyLinkage = new LinkageTypes(AvailableExternallyLinkage.getValue() + 1);
        public static final /* enum */ LinkageTypes LinkOnceODRLinkage = new LinkageTypes(LinkOnceAnyLinkage.getValue() + 1);
        public static final /* enum */ LinkageTypes WeakAnyLinkage = new LinkageTypes(LinkOnceODRLinkage.getValue() + 1);
        public static final /* enum */ LinkageTypes WeakODRLinkage = new LinkageTypes(WeakAnyLinkage.getValue() + 1);
        public static final /* enum */ LinkageTypes AppendingLinkage = new LinkageTypes(WeakODRLinkage.getValue() + 1);
        public static final /* enum */ LinkageTypes InternalLinkage = new LinkageTypes(AppendingLinkage.getValue() + 1);
        public static final /* enum */ LinkageTypes PrivateLinkage = new LinkageTypes(InternalLinkage.getValue() + 1);
        public static final /* enum */ LinkageTypes ExternalWeakLinkage = new LinkageTypes(PrivateLinkage.getValue() + 1);
        public static final /* enum */ LinkageTypes CommonLinkage = new LinkageTypes(ExternalWeakLinkage.getValue() + 1);
        private final int value;
        private static final /* synthetic */ LinkageTypes[] $VALUES;

        public static LinkageTypes[] values() {
            return (LinkageTypes[])$VALUES.clone();
        }

        public static LinkageTypes valueOf(String name) {
            return Enum.valueOf(LinkageTypes.class, name);
        }

        public static LinkageTypes valueOf(int val) {
            LinkageTypes out;
            LinkageTypes linkageTypes = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private LinkageTypes(int val) {
            this.value = val;
        }

        public final int getValue() {
            return this.value;
        }

        static {
            $VALUES = new LinkageTypes[]{ExternalLinkage, AvailableExternallyLinkage, LinkOnceAnyLinkage, LinkOnceODRLinkage, WeakAnyLinkage, WeakODRLinkage, AppendingLinkage, InternalLinkage, PrivateLinkage, ExternalWeakLinkage, CommonLinkage};
        }

        private static final class Values {
            private static final LinkageTypes[] VALUES;
            private static final LinkageTypes[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (LinkageTypes kind : LinkageTypes.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new LinkageTypes[min < 0 ? 1 - min : 0];
                VALUES = new LinkageTypes[max >= 0 ? 1 + max : 0];
                for (LinkageTypes kind : LinkageTypes.values()) {
                    if (kind.value < 0) {
                        if (_VALUES[-kind.value] != null) continue;
                        Values._VALUES[-((LinkageTypes)kind).value] = kind;
                        continue;
                    }
                    if (VALUES[kind.value] != null) continue;
                    Values.VALUES[((LinkageTypes)kind).value] = kind;
                }
            }
        }
    }
}

