/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.Unsigned;
import org.clank.support.aliases.type;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.ir.Comdat;
import org.llvm.ir.ConstantAsMetadata;
import org.llvm.ir.ConstantInt;
import org.llvm.ir.GlobalValue;
import org.llvm.ir.LLVMContext;
import org.llvm.ir.MDNode;
import org.llvm.ir.MDTuple;
import org.llvm.ir.Metadata;
import org.llvm.ir.Type;
import org.llvm.ir.Use;
import org.llvm.ir.Value;
import org.llvm.ir.impl.MDGlobalAttachmentMap;
import org.llvm.ir.java.IrRTTI;
import org.llvm.support.llvm;

public abstract class GlobalObject
extends GlobalValue
implements Destructors.ClassWithDestructor {
    protected std.string Section;
    protected Comdat ObjComdat;
    protected static int GlobalObjectSubClassDataBits = GlobalValueSubClassDataBits - Unnamed_enum.GlobalObjectBits.getValue();
    private static int AlignmentBits = Unnamed_enum.LastAlignmentBit.getValue() + 1;
    private static int AlignmentMask = (1 << AlignmentBits) - 1;
    private static int GlobalObjectMask = (1 << Unnamed_enum.GlobalObjectBits.getValue()) - 1;

    protected GlobalObject(GlobalObject $Prm0) {
        super($Prm0);
        throw new UnsupportedOperationException("Deleted");
    }

    protected GlobalObject(Type Ty, Value.ValueTy VTy, type.ptr<Use> Ops, int NumOps, GlobalValue.LinkageTypes Linkage, Twine Name) {
        this(Ty, VTy, Ops, NumOps, Linkage, Name, 0);
    }

    protected GlobalObject(Type Ty, Value.ValueTy VTy, type.ptr<Use> Ops, int NumOps, GlobalValue.LinkageTypes Linkage, Twine Name, int AddressSpace) {
        super(Ty, VTy, Ops, NumOps, Linkage, Name, AddressSpace);
        this.Section = new std.string();
        this.ObjComdat = null;
        this.setGlobalValueSubClassData(0);
    }

    @Override
    public int getAlignment() {
        int Data = this.getGlobalValueSubClassData();
        int AlignmentData = Data & AlignmentMask;
        return 1 << AlignmentData >>> 1;
    }

    public void setAlignment(int Align) {
        assert ((Align & Align - 1) == 0) : "Alignment is not a power of 2!";
        assert (Unsigned.$lesseq_uint((int)Align, (int)MaximumAlignment)) : "Alignment is greater than MaximumAlignment!";
        int AlignmentData = llvm.Log2_32((int)Align) + 1;
        int OldData = this.getGlobalValueSubClassData();
        this.setGlobalValueSubClassData(OldData & ~AlignmentMask | AlignmentData);
        assert (this.getAlignment() == Align) : "Alignment representation error!";
    }

    public int getGlobalObjectSubClassData() {
        int ValueData = this.getGlobalValueSubClassData();
        return ValueData >>> Unnamed_enum.GlobalObjectBits.getValue();
    }

    public void setGlobalObjectSubClassData(int Val) {
        int OldData = this.getGlobalValueSubClassData();
        this.setGlobalValueSubClassData(OldData & GlobalObjectMask | Val << Unnamed_enum.GlobalObjectBits.getValue());
        assert (this.getGlobalObjectSubClassData() == Val) : "representation error";
    }

    @Override
    public boolean hasSection() {
        return !this.getSection().empty();
    }

    @Override
    public StringRef getSection() {
        return new StringRef(this.Section);
    }

    public void setSection(StringRef S) {
        this.Section.$assignMove(S.$string());
        this.Section.c_str();
    }

    @Override
    public boolean hasComdat() {
        return this.getComdat$Const() != null;
    }

    @Override
    public Comdat getComdat$Const() {
        return this.ObjComdat;
    }

    @Override
    public Comdat getComdat() {
        return this.ObjComdat;
    }

    public void setComdat(Comdat C2) {
        this.ObjComdat = C2;
    }

    public boolean hasMetadata() {
        return this.hasMetadataHashEntry();
    }

    public MDNode getMetadata(int KindID) {
        SmallVector MDs = new SmallVector(1, (Object)null);
        this.getMetadata(KindID, (SmallVectorImpl<MDNode>)MDs);
        assert (Unsigned.$lesseq_uint((int)MDs.size(), (int)1)) : "Expected at most one metadata attachment";
        if (MDs.empty()) {
            return null;
        }
        return (MDNode)MDs.$at(0);
    }

    public MDNode getMetadata(StringRef Kind2) {
        return this.getMetadata(this.getContext().getMDKindID(new StringRef(Kind2)));
    }

    public void getMetadata(int KindID, SmallVectorImpl<MDNode> MDs) {
        if (this.hasMetadata()) {
            ((MDGlobalAttachmentMap)this.getContext().pImpl.GlobalObjectMetadata.$at_T1$RR((Object)this)).get(KindID, MDs);
        }
    }

    public void getMetadata(StringRef Kind2, SmallVectorImpl<MDNode> MDs) {
        if (this.hasMetadata()) {
            this.getMetadata(this.getContext().getMDKindID(new StringRef(Kind2)), MDs);
        }
    }

    public void setMetadata(int KindID, MDNode N) {
        this.eraseMetadata(KindID);
        if (N != null) {
            this.addMetadata(KindID, (MDNode)Native.$Deref((Object)N));
        }
    }

    public void setMetadata(StringRef Kind2, MDNode N) {
        this.setMetadata(this.getContext().getMDKindID(new StringRef(Kind2)), N);
    }

    public void addMetadata(int KindID, MDNode MD) {
        if (!this.hasMetadata()) {
            this.setHasMetadataHashEntry(true);
        }
        ((MDGlobalAttachmentMap)this.getContext().pImpl.GlobalObjectMetadata.$at_T1$RR((Object)this)).insert(KindID, MD);
    }

    public void addMetadata(StringRef Kind2, MDNode MD) {
        this.addMetadata(this.getContext().getMDKindID(new StringRef(Kind2)), MD);
    }

    public void getAllMetadata(SmallVectorImpl<std_pair.pairUIntPtr<MDNode>> MDs) {
        MDs.clear();
        if (!this.hasMetadata()) {
            return;
        }
        ((MDGlobalAttachmentMap)this.getContext().pImpl.GlobalObjectMetadata.$at_T1$RR((Object)this)).getAll(MDs);
    }

    public void eraseMetadata(int KindID) {
        if (!this.hasMetadata()) {
            return;
        }
        MDGlobalAttachmentMap Store = (MDGlobalAttachmentMap)this.getContext().pImpl.GlobalObjectMetadata.$at_T1$RR((Object)this);
        Store.erase(KindID);
        if (Store.empty()) {
            this.clearMetadata();
        }
    }

    public void copyMetadata(GlobalObject Other, int Offset) {
        SmallVector MDs = new SmallVector(8, (Object)new std_pair.pairUIntPtr());
        Other.getAllMetadata((SmallVectorImpl<std_pair.pairUIntPtr<MDNode>>)MDs);
        for (std_pair.pairUIntPtr MD : MDs) {
            MDNode MD$Second = (MDNode)MD.second;
            if (Offset != 0 && MD.first == LLVMContext.Unnamed_enum.MD_type.getValue()) {
                ConstantInt OffsetConst = IrRTTI.cast_ConstantInt(IrRTTI.cast_ConstantAsMetadata(MD$Second.getOperand(0)).getValue());
                Metadata TypeId = MD$Second.getOperand(1).$Metadata$P();
                ConstantAsMetadata NewOffsetMD = ConstantAsMetadata.get(ConstantInt.get((Type)OffsetConst.getType(), OffsetConst.getValue().$add(Unsigned.$uint2ulong((int)Offset))));
                this.addMetadata(LLVMContext.Unnamed_enum.MD_type.getValue(), (MDNode)Native.$Deref((Object)MDNode.get(this.getContext(), (ArrayRef<Metadata>)new ArrayRef((Object[])new Metadata[]{NewOffsetMD, TypeId}, true))));
                continue;
            }
            this.addMetadata(MD.first, (MDNode)Native.$Deref((Object)MD$Second));
        }
    }

    public void addTypeMetadata(int Offset, Metadata TypeID2) {
        this.addMetadata(LLVMContext.Unnamed_enum.MD_type.getValue(), (MDNode)Native.$Deref((Object)MDTuple.get(this.getContext(), (ArrayRef<Metadata>)new ArrayRef((Object[])new Metadata[]{ConstantAsMetadata.get(ConstantInt.get(Type.getInt64Ty(this.getContext()), Unsigned.$uint2ulong((int)Offset))), TypeID2}, true))));
    }

    @Override
    public void copyAttributesFrom(GlobalValue Src) {
        super.copyAttributesFrom(Src);
        GlobalObject GV = IrRTTI.dyn_cast_GlobalObject(Src);
        if (GV != null) {
            this.setAlignment(GV.getAlignment());
            this.setSection(GV.getSection());
        }
    }

    public static boolean classof(Value V) {
        return V.getValueID() == Value.ValueTy.FunctionVal.getValue() || V.getValueID() == Value.ValueTy.GlobalVariableVal.getValue();
    }

    public void clearMetadata() {
        if (!this.hasMetadata()) {
            return;
        }
        this.getContext().pImpl.GlobalObjectMetadata.erase((Object)this);
        this.setHasMetadataHashEntry(false);
    }

    private boolean hasMetadataHashEntry() {
        return (this.getGlobalValueSubClassData() & 1 << Unnamed_enum.HasMetadataHashEntryBit.getValue()) != 0;
    }

    private void setHasMetadataHashEntry(boolean HasEntry) {
        int Mask = 1 << Unnamed_enum.HasMetadataHashEntryBit.getValue();
        this.setGlobalValueSubClassData(~Mask & this.getGlobalValueSubClassData() | (HasEntry ? Mask : 0));
    }

    @Override
    public void $destroy() {
        this.Section.$destroy();
        super.$destroy();
    }

    protected GlobalObject() {
    }

    @Override
    public String toString() {
        return "Section=" + this.Section + ", ObjComdat=" + this.ObjComdat + super.toString();
    }

    protected static final class Unnamed_enum
    extends Enum<Unnamed_enum>
    implements Native.NativeUIntEnum {
        public static final /* enum */ Unnamed_enum LastAlignmentBit = new Unnamed_enum(4);
        public static final /* enum */ Unnamed_enum HasMetadataHashEntryBit = new Unnamed_enum(LastAlignmentBit.getValue() + 1);
        public static final /* enum */ Unnamed_enum GlobalObjectBits = new Unnamed_enum(HasMetadataHashEntryBit.getValue() + 1);
        private final int value;
        private static final /* synthetic */ Unnamed_enum[] $VALUES;

        public static Unnamed_enum[] values() {
            return (Unnamed_enum[])$VALUES.clone();
        }

        public static Unnamed_enum valueOf(String name) {
            return Enum.valueOf(Unnamed_enum.class, name);
        }

        public static Unnamed_enum valueOf(int val) {
            Unnamed_enum out;
            Unnamed_enum unnamed_enum = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private Unnamed_enum(int val) {
            this.value = val;
        }

        public final int getValue() {
            return this.value;
        }

        static {
            $VALUES = new Unnamed_enum[]{LastAlignmentBit, HasMetadataHashEntryBit, GlobalObjectBits};
        }

        private static final class Values {
            private static final Unnamed_enum[] VALUES;
            private static final Unnamed_enum[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (Unnamed_enum kind : Unnamed_enum.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new Unnamed_enum[min < 0 ? 1 - min : 0];
                VALUES = new Unnamed_enum[max >= 0 ? 1 + max : 0];
                for (Unnamed_enum kind : Unnamed_enum.values()) {
                    if (kind.value < 0) {
                        if (_VALUES[-kind.value] != null) continue;
                        Values._VALUES[-((Unnamed_enum)kind).value] = kind;
                        continue;
                    }
                    if (VALUES[kind.value] != null) continue;
                    Values.VALUES[((Unnamed_enum)kind).value] = kind;
                }
            }
        }
    }
}

