/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import java.util.Iterator;
import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.JavaIterator;
import org.clank.support.aliases.type;
import org.llvm.adt.ADTAliases;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.ArrayRefUInt;
import org.llvm.adt.aliases.StringMapEntry;
import org.llvm.adt.ilist_iterator;
import org.llvm.adt.ilist_node;
import org.llvm.adt.iterator_range;
import org.llvm.ir.Argument;
import org.llvm.ir.AssemblyAnnotationWriter;
import org.llvm.ir.Attribute;
import org.llvm.ir.AttributeSet;
import org.llvm.ir.BasicBlock;
import org.llvm.ir.Constant;
import org.llvm.ir.ConstantInt;
import org.llvm.ir.ConstantPointerNull;
import org.llvm.ir.DISubprogram;
import org.llvm.ir.FunctionType;
import org.llvm.ir.GlobalObject;
import org.llvm.ir.GlobalValue;
import org.llvm.ir.ImmutableCallSite;
import org.llvm.ir.InstIterator;
import org.llvm.ir.Instruction;
import org.llvm.ir.LLVMContext;
import org.llvm.ir.MDBuilder;
import org.llvm.ir.MDNode;
import org.llvm.ir.MDString;
import org.llvm.ir.Module$IR;
import org.llvm.ir.OperandTraitsFunction;
import org.llvm.ir.SymbolTableList;
import org.llvm.ir.Type;
import org.llvm.ir.Use;
import org.llvm.ir.User;
import org.llvm.ir.Value;
import org.llvm.ir.ValueSymbolTable;
import org.llvm.ir.impl.AssemblyWriter;
import org.llvm.ir.impl.FunctionStatics;
import org.llvm.ir.impl.SlotTracker;
import org.llvm.ir.impl.SymbolTableListTraits;
import org.llvm.ir.intrinsic.IntrinsicGlobals;
import org.llvm.ir.java.IChild;
import org.llvm.ir.java.IRMemberPointers;
import org.llvm.ir.java.IValueSymbolTableProvider;
import org.llvm.ir.java.IrRTTI;
import org.llvm.pass.IrLlvmGlobals;
import org.llvm.support.AdtsupportLlvmGlobals;
import org.llvm.support.formatted_raw_ostream;
import org.llvm.support.llvm;
import org.llvm.support.raw_ostream;

public class Function
extends GlobalObject
implements IChild<Module$IR>,
IValueSymbolTableProvider,
ilist_node<Function>,
Iterable<BasicBlock>,
Destructors.ClassWithDestructor {
    private final SymbolTableList<BasicBlock, Function> BasicBlocks;
    private final SymbolTableList<Argument, Function> ArgumentList;
    private ValueSymbolTable SymTab;
    private AttributeSet AttributeSets;
    public static final int IsMaterializableBit = 0;
    private final ilist_node.ilist_node.Fields ilist_node$Flds;

    @Override
    public void setParent(Module$IR parent) {
        this.Parent = parent;
    }

    public boolean hasLazyArguments() {
        return (Unsigned.$ushort2int((char)this.getSubclassDataFromValue()) & 1) != 0;
    }

    private void CheckLazyArguments() {
        if (this.hasLazyArguments()) {
            this.BuildLazyArguments();
        }
    }

    private void BuildLazyArguments() {
        FunctionType FT = this.getFunctionType();
        int e = FT.getNumParams();
        for (int i = 0; i != e; ++i) {
            assert (!FT.getParamType(i).isVoidTy()) : "Cannot have void typed arguments!";
            this.ArgumentList.push_back(new Argument(FT.getParamType(i)));
        }
        int SDC = Unsigned.$ushort2uint((char)this.getSubclassDataFromValue());
        this.setValueSubclassData_Function(Unsigned.$uint2ushort((int)(SDC &= 0xFFFFFFFE)));
    }

    protected Function(Function $Prm0) {
        super($Prm0);
        throw new UnsupportedOperationException("Deleted");
    }

    protected void $assign(Function $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    private Function(FunctionType Ty, GlobalValue.LinkageTypes Linkage) {
        this(Ty, Linkage, new Twine(NativePointer.$EMPTY), null);
    }

    private Function(FunctionType Ty, GlobalValue.LinkageTypes Linkage, Twine name) {
        this(Ty, Linkage, name, null);
    }

    private Function(FunctionType Ty, GlobalValue.LinkageTypes Linkage, Twine name, Module$IR ParentModule) {
        super(Ty, Value.ValueTy.FunctionVal, OperandTraitsFunction.op_begin(User.$BEING_CREATED()), 0, Linkage, name);
        this.ilist_node$Flds = this.$ilist_node();
        this.BasicBlocks = new SymbolTableListTraits.BasicBlock.SymbolTableList.BasicBlock(this);
        this.ArgumentList = new SymbolTableListTraits.Argument.SymbolTableList.Argument(this);
        this.AttributeSets = new AttributeSet();
        assert (FunctionType.isValidReturnType(this.getReturnType())) : "invalid return type";
        this.setGlobalObjectSubClassData(0);
        this.SymTab = new ValueSymbolTable();
        if (Ty.getNumParams() != 0) {
            this.setValueSubclassData_Function(Unsigned.$int2ushort((int)1));
        }
        if (ParentModule != null) {
            ParentModule.getFunctionList().push_back(this);
        }
        if (this.IntID != 0) {
            this.setAttributes(IntrinsicGlobals.getAttributes(this.getContext(), this.IntID));
        }
    }

    public static Function Create(FunctionType Ty, GlobalValue.LinkageTypes Linkage) {
        return Function.Create(Ty, Linkage, new Twine(NativePointer.$EMPTY), null);
    }

    public static Function Create(FunctionType Ty, GlobalValue.LinkageTypes Linkage, Twine N) {
        return Function.Create(Ty, Linkage, N, null);
    }

    public static Function Create(FunctionType Ty, GlobalValue.LinkageTypes Linkage, Twine N, Module$IR M) {
        return (Function)User.$new_HangOffUses(New$Mem -> new Function(Ty, Linkage, N, M));
    }

    @Override
    public void $destroy() {
        this.dropAllReferences();
        this.ArgumentList.clear();
        Destructors.$destroy((Destructors.ClassWithDestructor)this.SymTab);
        this.clearGC();
        this.ArgumentList.$destroy();
        this.BasicBlocks.$destroy();
        super.$destroy();
        super.$destroy$ilist_node();
    }

    @Override
    public Value getOperand(int i_nocapture) {
        assert (Unsigned.$less_uint((int)i_nocapture, (int)OperandTraitsFunction.operands(this))) : "getOperand() out of range!";
        return IrRTTI.cast_or_null_Value(((Use)OperandTraitsFunction.op_begin(this).$at(i_nocapture)).get());
    }

    @Override
    public void setOperand(int i_nocapture, Value Val_nocapture) {
        assert (Unsigned.$less_uint((int)i_nocapture, (int)OperandTraitsFunction.operands(this))) : "setOperand() out of range!";
        ((Use)OperandTraitsFunction.op_begin(this).$at(i_nocapture)).$assign(Val_nocapture);
    }

    @Override
    public type.ptr<Use> op_begin() {
        return OperandTraitsFunction.op_begin(this);
    }

    @Override
    public type.ptr<Use> op_begin$Const() {
        return OperandTraitsFunction.op_begin(this);
    }

    @Override
    public type.ptr<Use> op_end() {
        return OperandTraitsFunction.op_end(this);
    }

    @Override
    public type.ptr<Use> op_end$Const() {
        return OperandTraitsFunction.op_end(this);
    }

    @Override
    protected Use Op(int Idx_nocapture) {
        return this.OpFrom(Idx_nocapture, this);
    }

    @Override
    protected Use Op$Const(int Idx_nocapture) {
        return this.OpFrom(Idx_nocapture, this);
    }

    @Override
    public int getNumOperands() {
        return OperandTraitsFunction.operands(this);
    }

    public Type getReturnType() {
        return this.getFunctionType().getReturnType();
    }

    public FunctionType getFunctionType() {
        return IrRTTI.cast_FunctionType(this.getValueType());
    }

    @Override
    public LLVMContext getContext() {
        return this.getType().getContext();
    }

    public boolean isVarArg() {
        return this.getFunctionType().isVarArg();
    }

    @Override
    public boolean isMaterializable() {
        return (this.getGlobalObjectSubClassData() & 1) != 0;
    }

    public void setIsMaterializable(boolean V) {
        int Mask = 1;
        this.setGlobalObjectSubClassData(~Mask & this.getGlobalObjectSubClassData() | (V ? Mask : 0));
    }

    public int getIntrinsicID() {
        return this.IntID;
    }

    public boolean isIntrinsic() {
        return this.getName().startswith("llvm.");
    }

    public void recalculateIntrinsicID() {
        StringMapEntry<Value> ValName = super.getValueName();
        if (ValName == null || !this.isIntrinsic()) {
            this.IntID = 0;
            return;
        }
        this.IntID = FunctionStatics.lookupIntrinsicID(ValName);
    }

    public int getCallingConv() {
        return Unsigned.$ushort2int((char)this.getSubclassDataFromValue()) >> 4 & 0x3FF;
    }

    public void setCallingConv(int CC) {
        int ID2 = CC;
        assert ((ID2 & 0xFFFFFC00) == 0) : "Unsupported calling convention";
        this.setValueSubclassData_Function(Unsigned.$uint2ushort((int)(Unsigned.$ushort2int((char)this.getSubclassDataFromValue()) & 0xC00F | ID2 << 4)));
    }

    public AttributeSet getAttributes() {
        return new AttributeSet(this.AttributeSets);
    }

    public void setAttributes(AttributeSet Attrs) {
        this.AttributeSets.$assign(Attrs);
    }

    public void addFnAttr(Attribute.AttrKind N) {
        this.setAttributes(this.AttributeSets.addAttribute(this.getContext(), AttributeSet.AttrIndex.FunctionIndex.getValue(), N));
    }

    public void removeFnAttr(Attribute.AttrKind Kind2) {
        this.setAttributes(this.AttributeSets.removeAttribute(this.getContext(), AttributeSet.AttrIndex.FunctionIndex.getValue(), Kind2));
    }

    public void addFnAttr(StringRef Kind2) {
        this.setAttributes(this.AttributeSets.addAttribute(this.getContext(), AttributeSet.AttrIndex.FunctionIndex.getValue(), new StringRef(Kind2)));
    }

    public void addFnAttr(StringRef Kind2, StringRef Value2) {
        this.setAttributes(this.AttributeSets.addAttribute(this.getContext(), AttributeSet.AttrIndex.FunctionIndex.getValue(), new StringRef(Kind2), new StringRef(Value2)));
    }

    public void setEntryCount(long Count) {
        MDBuilder MDB = new MDBuilder(this.getContext());
        this.setMetadata(LLVMContext.Unnamed_enum.MD_prof.getValue(), MDB.createFunctionEntryCount(Count));
    }

    public ADTAliases.OptionalULong getEntryCount() {
        MDString MDS;
        MDNode MD = this.getMetadata(LLVMContext.Unnamed_enum.MD_prof.getValue());
        if (MD != null && MD.getOperand(0).$Metadata$P() != null && (MDS = IrRTTI.dyn_cast_MDString(MD.getOperand(0))) != null && MDS.getString().equals("function_entry_count")) {
            ConstantInt CI = (ConstantInt)mdconst.extract$ValidPointer(MD.getOperand(1));
            return new ADTAliases.OptionalULong(JavaDifferentiators.JD$T$RR.INSTANCE, CI.getValue().getZExtValue());
        }
        return new ADTAliases.OptionalULong(llvm.None);
    }

    public boolean hasFnAttribute(Attribute.AttrKind Kind2) {
        return this.AttributeSets.hasFnAttribute(Kind2);
    }

    public boolean hasFnAttribute(StringRef Kind2) {
        return this.AttributeSets.hasAttribute(AttributeSet.AttrIndex.FunctionIndex.getValue(), new StringRef(Kind2));
    }

    public Attribute getFnAttribute(Attribute.AttrKind Kind2) {
        return this.getAttribute(AttributeSet.AttrIndex.FunctionIndex.getValue(), Kind2);
    }

    public Attribute getFnAttribute(StringRef Kind2) {
        return this.getAttribute(AttributeSet.AttrIndex.FunctionIndex.getValue(), new StringRef(Kind2));
    }

    public int getFnStackAlignment() {
        if (!this.hasFnAttribute(Attribute.AttrKind.StackAlignment)) {
            return 0;
        }
        return this.AttributeSets.getStackAlignment(AttributeSet.AttrIndex.FunctionIndex.getValue());
    }

    public boolean hasGC() {
        return (Unsigned.$ushort2int((char)this.getSubclassDataFromValue()) & 0x4000) != 0;
    }

    public std.string getGC() {
        assert (this.hasGC()) : "Function has no collector";
        return this.getContext().getGC(this);
    }

    public void setGC(std.string Str) {
        this.setValueSubclassDataBit(14, !Str.empty());
        this.getContext().setGC(this, new std.string(JavaDifferentiators.JD.Move.INSTANCE, (std.string)std.move((Object)Str)));
    }

    public void clearGC() {
        if (!this.hasGC()) {
            return;
        }
        this.getContext().deleteGC(this);
        this.setValueSubclassDataBit(14, false);
    }

    public void addAttribute(int i, Attribute.AttrKind Kind2) {
        AttributeSet PAL = this.getAttributes();
        PAL.$assignMove(PAL.addAttribute(this.getContext(), i, Kind2));
        this.setAttributes(new AttributeSet(PAL));
    }

    public void addAttribute(int i, Attribute Attr) {
        AttributeSet PAL = this.getAttributes();
        PAL.$assignMove(PAL.addAttribute(this.getContext(), new ArrayRefUInt(i), new Attribute(Attr)));
        this.setAttributes(new AttributeSet(PAL));
    }

    public void addAttributes(int i, AttributeSet Attrs) {
        AttributeSet PAL = this.getAttributes();
        PAL.$assignMove(PAL.addAttributes(this.getContext(), i, new AttributeSet(Attrs)));
        this.setAttributes(new AttributeSet(PAL));
    }

    public void removeAttribute(int i, Attribute.AttrKind Kind2) {
        AttributeSet PAL = this.getAttributes();
        PAL.$assignMove(PAL.removeAttribute(this.getContext(), i, Kind2));
        this.setAttributes(new AttributeSet(PAL));
    }

    public void removeAttribute(int i, StringRef Kind2) {
        AttributeSet PAL = this.getAttributes();
        PAL.$assignMove(PAL.removeAttribute(this.getContext(), i, new StringRef(Kind2)));
        this.setAttributes(new AttributeSet(PAL));
    }

    public void removeAttributes(int i, AttributeSet Attrs) {
        AttributeSet PAL = this.getAttributes();
        PAL.$assignMove(PAL.removeAttributes(this.getContext(), i, new AttributeSet(Attrs)));
        this.setAttributes(new AttributeSet(PAL));
    }

    public boolean hasAttribute(int i, Attribute.AttrKind Kind2) {
        return this.getAttributes().hasAttribute(i, Kind2);
    }

    public Attribute getAttribute(int i, Attribute.AttrKind Kind2) {
        return this.AttributeSets.getAttribute(i, Kind2);
    }

    public Attribute getAttribute(int i, StringRef Kind2) {
        return this.AttributeSets.getAttribute(i, new StringRef(Kind2));
    }

    public void addDereferenceableAttr(int i, long Bytes) {
        AttributeSet PAL = this.getAttributes();
        PAL.$assignMove(PAL.addDereferenceableAttr(this.getContext(), i, Bytes));
        this.setAttributes(new AttributeSet(PAL));
    }

    public void addDereferenceableOrNullAttr(int i, long Bytes) {
        AttributeSet PAL = this.getAttributes();
        PAL.$assignMove(PAL.addDereferenceableOrNullAttr(this.getContext(), i, Bytes));
        this.setAttributes(new AttributeSet(PAL));
    }

    public int getParamAlignment(int i) {
        return this.AttributeSets.getParamAlignment(i);
    }

    public long getDereferenceableBytes(int i) {
        return this.AttributeSets.getDereferenceableBytes(i);
    }

    public long getDereferenceableOrNullBytes(int i) {
        return this.AttributeSets.getDereferenceableOrNullBytes(i);
    }

    public boolean doesNotAccessMemory() {
        return this.hasFnAttribute(Attribute.AttrKind.ReadNone);
    }

    public void setDoesNotAccessMemory() {
        this.addFnAttr(Attribute.AttrKind.ReadNone);
    }

    public boolean onlyReadsMemory() {
        return this.doesNotAccessMemory() || this.hasFnAttribute(Attribute.AttrKind.ReadOnly);
    }

    public void setOnlyReadsMemory() {
        this.addFnAttr(Attribute.AttrKind.ReadOnly);
    }

    public boolean doesNotReadMemory() {
        return this.doesNotAccessMemory() || this.hasFnAttribute(Attribute.AttrKind.WriteOnly);
    }

    public void setDoesNotReadMemory() {
        this.addFnAttr(Attribute.AttrKind.WriteOnly);
    }

    public boolean onlyAccessesArgMemory() {
        return this.hasFnAttribute(Attribute.AttrKind.ArgMemOnly);
    }

    public void setOnlyAccessesArgMemory() {
        this.addFnAttr(Attribute.AttrKind.ArgMemOnly);
    }

    public boolean onlyAccessesInaccessibleMemory() {
        return this.hasFnAttribute(Attribute.AttrKind.InaccessibleMemOnly);
    }

    public void setOnlyAccessesInaccessibleMemory() {
        this.addFnAttr(Attribute.AttrKind.InaccessibleMemOnly);
    }

    public boolean onlyAccessesInaccessibleMemOrArgMem() {
        return this.hasFnAttribute(Attribute.AttrKind.InaccessibleMemOrArgMemOnly);
    }

    public void setOnlyAccessesInaccessibleMemOrArgMem() {
        this.addFnAttr(Attribute.AttrKind.InaccessibleMemOrArgMemOnly);
    }

    public boolean doesNotReturn() {
        return this.hasFnAttribute(Attribute.AttrKind.NoReturn);
    }

    public void setDoesNotReturn() {
        this.addFnAttr(Attribute.AttrKind.NoReturn);
    }

    public boolean doesNotThrow() {
        return this.hasFnAttribute(Attribute.AttrKind.NoUnwind);
    }

    public void setDoesNotThrow() {
        this.addFnAttr(Attribute.AttrKind.NoUnwind);
    }

    public boolean cannotDuplicate() {
        return this.hasFnAttribute(Attribute.AttrKind.NoDuplicate);
    }

    public void setCannotDuplicate() {
        this.addFnAttr(Attribute.AttrKind.NoDuplicate);
    }

    public boolean isConvergent() {
        return this.hasFnAttribute(Attribute.AttrKind.Convergent);
    }

    public void setConvergent() {
        this.addFnAttr(Attribute.AttrKind.Convergent);
    }

    public void setNotConvergent() {
        this.removeFnAttr(Attribute.AttrKind.Convergent);
    }

    public boolean doesNotRecurse() {
        return this.hasFnAttribute(Attribute.AttrKind.NoRecurse);
    }

    public void setDoesNotRecurse() {
        this.addFnAttr(Attribute.AttrKind.NoRecurse);
    }

    public boolean hasUWTable() {
        return this.hasFnAttribute(Attribute.AttrKind.UWTable);
    }

    public void setHasUWTable() {
        this.addFnAttr(Attribute.AttrKind.UWTable);
    }

    public boolean needsUnwindTableEntry() {
        return this.hasUWTable() || !this.doesNotThrow();
    }

    public boolean hasStructRetAttr() {
        return this.AttributeSets.hasAttribute(1, Attribute.AttrKind.StructRet) || this.AttributeSets.hasAttribute(2, Attribute.AttrKind.StructRet);
    }

    public boolean doesNotAlias(int n) {
        return this.AttributeSets.hasAttribute(n, Attribute.AttrKind.NoAlias);
    }

    public void setDoesNotAlias(int n) {
        this.addAttribute(n, Attribute.AttrKind.NoAlias);
    }

    public boolean doesNotCapture(int n) {
        return this.AttributeSets.hasAttribute(n, Attribute.AttrKind.NoCapture);
    }

    public void setDoesNotCapture(int n) {
        this.addAttribute(n, Attribute.AttrKind.NoCapture);
    }

    public boolean doesNotAccessMemory(int n) {
        return this.AttributeSets.hasAttribute(n, Attribute.AttrKind.ReadNone);
    }

    public void setDoesNotAccessMemory(int n) {
        this.addAttribute(n, Attribute.AttrKind.ReadNone);
    }

    public boolean onlyReadsMemory(int n) {
        return this.doesNotAccessMemory(n) || this.AttributeSets.hasAttribute(n, Attribute.AttrKind.ReadOnly);
    }

    public void setOnlyReadsMemory(int n) {
        this.addAttribute(n, Attribute.AttrKind.ReadOnly);
    }

    public boolean optForMinSize() {
        return this.hasFnAttribute(Attribute.AttrKind.MinSize);
    }

    public boolean optForSize() {
        return this.hasFnAttribute(Attribute.AttrKind.OptimizeForSize) || this.optForMinSize();
    }

    @Override
    public void copyAttributesFrom(GlobalValue Src) {
        super.copyAttributesFrom(Src);
        Function SrcF = IrRTTI.dyn_cast_Function(Src);
        if (SrcF == null) {
            return;
        }
        this.setCallingConv(SrcF.getCallingConv());
        this.setAttributes(SrcF.getAttributes());
        if (SrcF.hasGC()) {
            this.setGC(new std.string(SrcF.getGC()));
        } else {
            this.clearGC();
        }
        if (SrcF.hasPersonalityFn()) {
            this.setPersonalityFn(SrcF.getPersonalityFn());
        }
        if (SrcF.hasPrefixData()) {
            this.setPrefixData(SrcF.getPrefixData());
        }
        if (SrcF.hasPrologueData()) {
            this.setPrologueData(SrcF.getPrologueData());
        }
    }

    public void deleteBody() {
        this.dropAllReferences();
        this.setLinkage(GlobalValue.LinkageTypes.ExternalLinkage);
    }

    @Override
    public void removeFromParent() {
        ((Module$IR)this.getParent()).getFunctionList().remove_ilist_iterator$NodeTy$C(this.getIterator());
    }

    @Override
    public void eraseFromParent() {
        ((Module$IR)this.getParent()).getFunctionList().erase(this.getIterator());
    }

    public void stealArgumentListFrom(Function Src) {
        assert (this.isDeclaration()) : "Expected no references to current arguments";
        if (!this.hasLazyArguments()) {
            assert (llvm.all_of(this.ArgumentList, A2 -> A2.use_empty())) : "Expected arguments to be unused in declaration";
            this.ArgumentList.clear();
            this.setValueSubclassData_Function(Unsigned.$int2ushort((int)(Unsigned.$ushort2int((char)this.getSubclassDataFromValue()) | 1)));
        }
        if (Src.hasLazyArguments()) {
            return;
        }
        this.ArgumentList.splice(this.ArgumentList.end(), Src.ArgumentList);
        this.setValueSubclassData_Function(Unsigned.$int2ushort((int)(Unsigned.$ushort2int((char)this.getSubclassDataFromValue()) & 0xFFFFFFFE)));
        Src.setValueSubclassData_Function(Unsigned.$int2ushort((int)(Unsigned.$ushort2int((char)Src.getSubclassDataFromValue()) | 1)));
    }

    public SymbolTableList<Argument, Function> getArgumentList$Const() {
        this.CheckLazyArguments();
        return this.ArgumentList;
    }

    public SymbolTableList<Argument, Function> getArgumentList() {
        this.CheckLazyArguments();
        return this.ArgumentList;
    }

    public static IRMemberPointers.Void2SymbolTableList<Argument, Function> getSublistAccess(Argument $Prm0) {
        return $this -> $this.ArgumentList;
    }

    public SymbolTableList<BasicBlock, Function> getBasicBlockList$Const() {
        return this.BasicBlocks;
    }

    public SymbolTableList<BasicBlock, Function> getBasicBlockList() {
        return this.BasicBlocks;
    }

    public static IRMemberPointers.Void2SymbolTableList<BasicBlock, Function> getSublistAccess(BasicBlock $Prm0) {
        return $this -> $this.BasicBlocks;
    }

    public BasicBlock getEntryBlock$Const() {
        return this.front$Const();
    }

    public BasicBlock getEntryBlock() {
        return this.front();
    }

    @Override
    public ValueSymbolTable getValueSymbolTable() {
        return (ValueSymbolTable)Native.$Deref((Object)this.SymTab);
    }

    public ValueSymbolTable getValueSymbolTable$Const() {
        return (ValueSymbolTable)Native.$Deref((Object)this.SymTab);
    }

    public ilist_iterator<BasicBlock> begin() {
        return this.BasicBlocks.begin();
    }

    public ilist_iterator<BasicBlock> begin$Const() {
        return this.BasicBlocks.begin$Const();
    }

    public ilist_iterator<BasicBlock> end() {
        return this.BasicBlocks.end();
    }

    public ilist_iterator<BasicBlock> end$Const() {
        return this.BasicBlocks.end$Const();
    }

    public int size() {
        return this.BasicBlocks.size();
    }

    public boolean empty() {
        return this.BasicBlocks.empty();
    }

    public BasicBlock front$Const() {
        return (BasicBlock)this.BasicBlocks.front$Const();
    }

    public BasicBlock front() {
        return (BasicBlock)this.BasicBlocks.front();
    }

    public BasicBlock back$Const() {
        return (BasicBlock)this.BasicBlocks.back$Const();
    }

    public BasicBlock back() {
        return (BasicBlock)this.BasicBlocks.back();
    }

    public ilist_iterator<Argument> arg_begin() {
        this.CheckLazyArguments();
        return this.ArgumentList.begin();
    }

    public ilist_iterator<Argument> arg_begin$Const() {
        this.CheckLazyArguments();
        return new ilist_iterator(this.ArgumentList.begin());
    }

    public ilist_iterator<Argument> arg_end() {
        this.CheckLazyArguments();
        return this.ArgumentList.end();
    }

    public ilist_iterator<Argument> arg_end$Const() {
        this.CheckLazyArguments();
        return new ilist_iterator(this.ArgumentList.end());
    }

    public iterator_range<Argument> args() {
        return llvm.make_range(this.arg_begin(), this.arg_end());
    }

    public iterator_range<Argument> args$Const() {
        return llvm.make_range(this.arg_begin$Const(), this.arg_end$Const());
    }

    public int arg_size() {
        return this.getFunctionType().getNumParams();
    }

    public boolean arg_empty() {
        return this.getFunctionType().getNumParams() == 0;
    }

    public boolean hasPersonalityFn() {
        return (Unsigned.$ushort2int((char)this.getSubclassDataFromValue()) & 8) != 0;
    }

    public Constant getPersonalityFn() {
        assert (this.hasPersonalityFn() && this.getNumOperands() != 0);
        return IrRTTI.cast_Constant(this.Op$Const(0));
    }

    public void setPersonalityFn(Constant Fn) {
        this.setHungoffOperand(0, Fn);
        this.setValueSubclassDataBit(3, Fn != (Constant)null);
    }

    public boolean hasPrefixData() {
        return (Unsigned.$ushort2int((char)this.getSubclassDataFromValue()) & 2) != 0;
    }

    public Constant getPrefixData() {
        assert (this.hasPrefixData() && this.getNumOperands() != 0);
        return IrRTTI.cast_Constant(this.Op(1));
    }

    public void setPrefixData(Constant PrefixData) {
        this.setHungoffOperand(1, PrefixData);
        this.setValueSubclassDataBit(1, PrefixData != (Constant)null);
    }

    public boolean hasPrologueData() {
        return (Unsigned.$ushort2int((char)this.getSubclassDataFromValue()) & 4) != 0;
    }

    public Constant getPrologueData() {
        assert (this.hasPrologueData() && this.getNumOperands() != 0);
        return IrRTTI.cast_Constant(this.Op$Const(2));
    }

    public void setPrologueData(Constant PrologueData) {
        this.setHungoffOperand(2, PrologueData);
        this.setValueSubclassDataBit(2, PrologueData != (Constant)null);
    }

    @Override
    public void print(raw_ostream ROS) {
        this.print(ROS, null, false, false);
    }

    public void print(raw_ostream ROS, AssemblyAnnotationWriter AAW) {
        this.print(ROS, AAW, false, false);
    }

    public void print(raw_ostream ROS, AssemblyAnnotationWriter AAW, boolean ShouldPreserveUseListOrder) {
        this.print(ROS, AAW, ShouldPreserveUseListOrder, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(raw_ostream ROS, AssemblyAnnotationWriter AAW, boolean ShouldPreserveUseListOrder, boolean IsForDebug) {
        SlotTracker SlotTable = null;
        formatted_raw_ostream OS = null;
        AssemblyWriter W = null;
        try {
            SlotTable = new SlotTracker(super.getParent$Const());
            OS = new formatted_raw_ostream(ROS);
            W = new AssemblyWriter(OS, SlotTable, super.getParent$Const(), AAW, IsForDebug, ShouldPreserveUseListOrder);
            W.printFunction(this);
        }
        finally {
            if (W != null) {
                W.$destroy();
            }
            if (OS != null) {
                OS.$destroy();
            }
            if (SlotTable != null) {
                SlotTable.$destroy();
            }
        }
    }

    public void viewCFG() {
        AdtsupportLlvmGlobals.ViewGraph((Object)this, (Twine)llvm.$add_char$ptr$C_StringRef$C((String)"cfg", (StringRef)this.getName()));
    }

    public void viewCFGOnly() {
        AdtsupportLlvmGlobals.ViewGraph((Object)this, (Twine)llvm.$add_char$ptr$C_StringRef$C((String)"cfg", (StringRef)this.getName()), (boolean)true);
    }

    public static boolean classof(Value V) {
        return V.getValueID() == Value.ValueTy.FunctionVal.getValue();
    }

    @Override
    public void dropAllReferences() {
        this.setIsMaterializable(false);
        for (BasicBlock BB : this) {
            BB.dropAllReferences();
        }
        while (!this.BasicBlocks.empty()) {
            ((BasicBlock)this.BasicBlocks.begin().$arrow()).eraseFromParent();
        }
        if (this.getNumOperands() != 0) {
            super.dropAllReferences();
            this.setNumHungOffUseOperands(0);
            this.setValueSubclassData_Function(Unsigned.$int2ushort((int)(Unsigned.$ushort2int((char)this.getSubclassDataFromValue()) & 0xFFFFFFF1)));
        }
        this.clearMetadata();
    }

    public boolean hasAddressTaken() {
        return this.hasAddressTaken((type.ptr<User>)((type.ptr)null));
    }

    public boolean hasAddressTaken(type.ptr<User> PutOffender) {
        for (Use U : this.uses$Const()) {
            User FU = U.getUser();
            if (IrRTTI.isa_BlockAddress(FU)) continue;
            if (!IrRTTI.isa_CallInst(FU) && !IrRTTI.isa_InvokeInst(FU)) {
                if (Native.$bool(PutOffender)) {
                    PutOffender.$set((Object)FU);
                }
                return true;
            }
            ImmutableCallSite CS = new ImmutableCallSite(IrRTTI.cast_Instruction(FU));
            if (CS.isCallee((Use)Native.$AddrOf((Object)U))) continue;
            if (Native.$bool(PutOffender)) {
                PutOffender.$set((Object)FU);
            }
            return true;
        }
        return false;
    }

    public boolean isDefTriviallyDead() {
        if (!(this.hasLinkOnceLinkage() || this.hasLocalLinkage() || this.hasAvailableExternallyLinkage())) {
            return false;
        }
        for (User U : this.users$Const()) {
            if (IrRTTI.isa_BlockAddress(U)) continue;
            return false;
        }
        return true;
    }

    public boolean callsFunctionThatReturnsTwice() {
        InstIterator<SymbolTableList<BasicBlock, Function>, ilist_iterator<BasicBlock>, ilist_iterator<Instruction>, Instruction> I = IrLlvmGlobals.inst_begin_Function$C$P(this);
        InstIterator<SymbolTableList<BasicBlock, Function>, ilist_iterator<BasicBlock>, ilist_iterator<Instruction>, Instruction> E = IrLlvmGlobals.inst_end_Function$C$P(this);
        while (I.$noteq(E)) {
            ImmutableCallSite CS = new ImmutableCallSite((Instruction)Native.$AddrOf((Object)I.$star()));
            if (CS.$bool() && CS.hasFnAttr(Attribute.AttrKind.ReturnsTwice)) {
                return true;
            }
            I.$preInc();
        }
        return false;
    }

    public void setSubprogram(DISubprogram SP) {
        this.setMetadata(LLVMContext.Unnamed_enum.MD_dbg.getValue(), (MDNode)SP);
    }

    public DISubprogram getSubprogram() {
        return IrRTTI.cast_or_null_DISubprogram(this.getMetadata(LLVMContext.Unnamed_enum.MD_dbg.getValue()));
    }

    private void allocHungoffUselist() {
        if (this.getNumOperands() != 0) {
            return;
        }
        this.allocHungoffUses(3, false);
        this.setNumHungOffUseOperands(3);
        ConstantPointerNull CPN = ConstantPointerNull.get(Type.getInt1PtrTy(this.getContext(), 0));
        this.Op(0).set(CPN);
        this.Op(1).set(CPN);
        this.Op(2).set(CPN);
    }

    private void setHungoffOperand(int Idx, Constant C2) {
        if (C2 != null) {
            this.allocHungoffUselist();
            this.Op(Idx).set(C2);
        } else if (this.getNumOperands() != 0) {
            this.Op(Idx).set(ConstantPointerNull.get(Type.getInt1PtrTy(this.getContext(), 0)));
        }
    }

    private void setValueSubclassData_Function(char D2) {
        super.setValueSubclassData(D2);
    }

    private void setValueSubclassDataBit(int Bit, boolean On) {
        assert (Unsigned.$less_uint((int)Bit, (int)16)) : "SubclassData contains only 16 bits";
        if (On) {
            this.setValueSubclassData_Function(Unsigned.$int2ushort((int)(Unsigned.$ushort2int((char)this.getSubclassDataFromValue()) | 1 << Bit)));
        } else {
            this.setValueSubclassData_Function(Unsigned.$int2ushort((int)(Unsigned.$ushort2int((char)this.getSubclassDataFromValue()) & ~(1 << Bit))));
        }
    }

    @Override
    public Iterator<BasicBlock> iterator() {
        return new JavaIterator(this.begin(), this.end());
    }

    private Function() {
        this.ilist_node$Flds = this.$ilist_node();
        this.BasicBlocks = null;
        this.ArgumentList = null;
    }

    public static Function CreateSentinel() {
        return (Function)User.$new_FixedUses(0, New$Mem -> new Function());
    }

    public final ilist_node.ilist_node.Fields $ilist_node$Fields() {
        return this.ilist_node$Flds;
    }

    @Override
    public String toString() {
        if (this.$isSentinel()) {
            return "Sentinel " + this.getClass().getSimpleName();
        }
        return "BasicBlocks=" + this.BasicBlocks + ", ArgumentList=" + this.ArgumentList + ", SymTab=" + this.SymTab + ", AttributeSets=" + this.AttributeSets + super.toString();
    }

    private static class mdconst {
        private mdconst() {
        }

        public static <X, Y> X extract$ValidPointer(Y MMD) {
            throw new UnsupportedOperationException("EmptyBody");
        }
    }
}

