/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.clank.support.Destructors;
import org.clank.support.Unsigned;
import org.llvm.ir.ConstantFP;
import org.llvm.ir.FastMathFlags;
import org.llvm.ir.Instruction;
import org.llvm.ir.LLVMContext;
import org.llvm.ir.MDNode;
import org.llvm.ir.Operator;
import org.llvm.ir.Value;
import org.llvm.ir.java.IrRTTI;
import org.llvm.ir.mdconst.MdconstGlobals;

public class FPMathOperator
extends Operator
implements Destructors.ClassWithDestructor {
    public void setHasUnsafeAlgebra(boolean B2) {
        this.SubclassOptionalData = Unsigned.$uchar2uchar_7bits((byte)Unsigned.$int2uchar((int)(Unsigned.$uchar2int((byte)Unsigned.$7bits_uchar2uchar((byte)this.SubclassOptionalData)) & 0xFFFFFFFE | Unsigned.$bool2uint((boolean)B2) * 1)));
        if (B2) {
            this.setHasNoNaNs(true);
            this.setHasNoInfs(true);
            this.setHasNoSignedZeros(true);
            this.setHasAllowReciprocal(true);
        }
    }

    public void setHasNoNaNs(boolean B2) {
        this.SubclassOptionalData = Unsigned.$uchar2uchar_7bits((byte)Unsigned.$int2uchar((int)(Unsigned.$uchar2int((byte)Unsigned.$7bits_uchar2uchar((byte)this.SubclassOptionalData)) & 0xFFFFFFFD | Unsigned.$bool2uint((boolean)B2) * 2)));
    }

    public void setHasNoInfs(boolean B2) {
        this.SubclassOptionalData = Unsigned.$uchar2uchar_7bits((byte)Unsigned.$int2uchar((int)(Unsigned.$uchar2int((byte)Unsigned.$7bits_uchar2uchar((byte)this.SubclassOptionalData)) & 0xFFFFFFFB | Unsigned.$bool2uint((boolean)B2) * 4)));
    }

    public void setHasNoSignedZeros(boolean B2) {
        this.SubclassOptionalData = Unsigned.$uchar2uchar_7bits((byte)Unsigned.$int2uchar((int)(Unsigned.$uchar2int((byte)Unsigned.$7bits_uchar2uchar((byte)this.SubclassOptionalData)) & 0xFFFFFFF7 | Unsigned.$bool2uint((boolean)B2) * 8)));
    }

    public void setHasAllowReciprocal(boolean B2) {
        this.SubclassOptionalData = Unsigned.$uchar2uchar_7bits((byte)Unsigned.$int2uchar((int)(Unsigned.$uchar2int((byte)Unsigned.$7bits_uchar2uchar((byte)this.SubclassOptionalData)) & 0xFFFFFFEF | Unsigned.$bool2uint((boolean)B2) * 16)));
    }

    public void setFastMathFlags(FastMathFlags FMF) {
        this.SubclassOptionalData = (byte)(this.SubclassOptionalData | Unsigned.$uint2uchar_7bits((int)FMF.Flags));
    }

    public void copyFastMathFlags(FastMathFlags FMF) {
        this.SubclassOptionalData = Unsigned.$uchar2uchar_7bits((byte)Unsigned.$uint2uchar((int)FMF.Flags));
    }

    public boolean hasUnsafeAlgebra() {
        return (Unsigned.$uchar2int((byte)Unsigned.$7bits_uchar2uchar((byte)this.SubclassOptionalData)) & 1) != 0;
    }

    public boolean hasNoNaNs() {
        return (Unsigned.$uchar2int((byte)Unsigned.$7bits_uchar2uchar((byte)this.SubclassOptionalData)) & 2) != 0;
    }

    public boolean hasNoInfs() {
        return (Unsigned.$uchar2int((byte)Unsigned.$7bits_uchar2uchar((byte)this.SubclassOptionalData)) & 4) != 0;
    }

    public boolean hasNoSignedZeros() {
        return (Unsigned.$uchar2int((byte)Unsigned.$7bits_uchar2uchar((byte)this.SubclassOptionalData)) & 8) != 0;
    }

    public boolean hasAllowReciprocal() {
        return (Unsigned.$uchar2int((byte)Unsigned.$7bits_uchar2uchar((byte)this.SubclassOptionalData)) & 0x10) != 0;
    }

    public FastMathFlags getFastMathFlags() {
        return new FastMathFlags(Unsigned.$uchar2uint((byte)Unsigned.$7bits_uchar2uchar((byte)this.SubclassOptionalData)));
    }

    public float getFPAccuracy() {
        MDNode MD = IrRTTI.cast_Instruction(this).getMetadata(LLVMContext.Unnamed_enum.MD_fpmath.getValue());
        if (MD == null) {
            return 0.0f;
        }
        ConstantFP Accuracy = MdconstGlobals.extract$ValidPointer(ConstantFP.class, MD.getOperand(0));
        return Accuracy.getValueAPF().convertToFloat();
    }

    public static boolean classof(Instruction I) {
        return I.getType().isFPOrFPVectorTy() || I.getOpcode() == 52;
    }

    public static boolean classof(Value V) {
        return IrRTTI.isa_Instruction(V) && FPMathOperator.classof(IrRTTI.cast_Instruction(V));
    }

    @Override
    public void $destroy() {
    }

    @Override
    public String toString() {
        return "" + super.toString();
    }
}

