/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.clank.support.Destructors;
import org.clank.support.aliases.type;
import org.llvm.adt.DenseMapInfo;
import org.llvm.adt.SmallPtrSet;
import org.llvm.adt.aliases.DenseMapInfo;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.iterator_range;
import org.llvm.ir.DICompileUnit;
import org.llvm.ir.DICompositeType;
import org.llvm.ir.DIDerivedType;
import org.llvm.ir.DIGlobalVariable;
import org.llvm.ir.DIImportedEntity;
import org.llvm.ir.DILexicalBlockBase;
import org.llvm.ir.DILocalVariable;
import org.llvm.ir.DILocation;
import org.llvm.ir.DIModule;
import org.llvm.ir.DINamespace;
import org.llvm.ir.DINode;
import org.llvm.ir.DIScope;
import org.llvm.ir.DISubprogram;
import org.llvm.ir.DISubroutineType;
import org.llvm.ir.DITemplateParameter;
import org.llvm.ir.DITemplateTypeParameter;
import org.llvm.ir.DITemplateValueParameter;
import org.llvm.ir.DIType;
import org.llvm.ir.DbgDeclareInst;
import org.llvm.ir.DbgValueInst;
import org.llvm.ir.Function;
import org.llvm.ir.MDNode;
import org.llvm.ir.Metadata;
import org.llvm.ir.Module$IR;
import org.llvm.ir.TypedDINodeRef;
import org.llvm.ir.java.IrRTTI;
import org.llvm.support.llvm;

public class DebugInfoFinder
implements Destructors.ClassWithDestructor {
    private SmallVector<DICompileUnit> CUs = new SmallVector(8, (Object)null);
    private SmallVector<DISubprogram> SPs = new SmallVector(8, (Object)null);
    private SmallVector<DIGlobalVariable> GVs = new SmallVector(8, (Object)null);
    private SmallVector<DIType> TYs = new SmallVector(8, (Object)null);
    private SmallVector<DIScope> Scopes = new SmallVector(8, (Object)null);
    private SmallPtrSet<MDNode> NodesSeen = new SmallPtrSet((DenseMapInfo)DenseMapInfo.LikePtr.$Info(), 32);

    public void processModule(Module$IR M) {
        for (DICompileUnit CU : M.debug_compile_units()) {
            this.addCompileUnit(CU);
            for (DIGlobalVariable DIG : CU.getGlobalVariables()) {
                if (!this.addGlobalVariable(DIG)) continue;
                this.processScope(DIG.getScope());
                this.processType(DIG.getType().resolve());
            }
            for (DICompositeType ET : CU.getEnumTypes()) {
                this.processType(ET);
            }
            for (DIScope RT : CU.getRetainedTypes()) {
                DIType T2 = IrRTTI.dyn_cast_DIType(RT);
                if (T2 != null) {
                    this.processType(T2);
                    continue;
                }
                this.processSubprogram(IrRTTI.cast_DISubprogram(RT));
            }
            for (DIImportedEntity Import : CU.getImportedEntities()) {
                DINode Entity = Import.getEntity().resolve();
                DIType T3 = IrRTTI.dyn_cast_DIType(Entity);
                if (T3 != null) {
                    this.processType(T3);
                    continue;
                }
                DISubprogram SP = IrRTTI.dyn_cast_DISubprogram(Entity);
                if (SP != null) {
                    this.processSubprogram(SP);
                    continue;
                }
                DINamespace NS = IrRTTI.dyn_cast_DINamespace(Entity);
                if (NS != null) {
                    this.processScope(NS.getScope());
                    continue;
                }
                DIModule M$1 = IrRTTI.dyn_cast_DIModule(Entity);
                if (M$1 == null) continue;
                this.processScope(M$1.getScope());
            }
        }
        for (Function F : M.functions$Const()) {
            DISubprogram SP = IrRTTI.cast_or_null_DISubprogram(F.getSubprogram());
            if (SP == null) continue;
            this.processSubprogram(SP);
        }
    }

    public void processDeclare(Module$IR M, DbgDeclareInst DDI) {
        MDNode N = IrRTTI.dyn_cast_MDNode(DDI.getVariable());
        if (N == null) {
            return;
        }
        DILocalVariable DV = IrRTTI.dyn_cast_DILocalVariable(N);
        if (DV == null) {
            return;
        }
        if (!this.NodesSeen.insert((Object)DV).second) {
            return;
        }
        this.processScope(DV.getScope());
        this.processType(DV.getType().resolve());
    }

    public void processValue(Module$IR M, DbgValueInst DVI) {
        MDNode N = IrRTTI.dyn_cast_MDNode(DVI.getVariable());
        if (N == null) {
            return;
        }
        DILocalVariable DV = IrRTTI.dyn_cast_DILocalVariable(N);
        if (DV == null) {
            return;
        }
        if (!this.NodesSeen.insert((Object)DV).second) {
            return;
        }
        this.processScope(DV.getScope());
        this.processType(DV.getType().resolve());
    }

    public void processLocation(Module$IR M, DILocation Loc) {
        if (Loc == null) {
            return;
        }
        this.processScope(Loc.getScope());
        this.processLocation(M, Loc.getInlinedAt());
    }

    public void reset() {
        this.CUs.clear();
        this.SPs.clear();
        this.GVs.clear();
        this.TYs.clear();
        this.Scopes.clear();
        this.NodesSeen.clear();
    }

    private void InitializeTypeMap(Module$IR M) {
        throw new UnsupportedOperationException("<<<DeclJavaPrinter::VisitFunctionDecl NULL BODY IN USED Translation Unit>>>");
    }

    private void processType(DIType DT) {
        if (!this.addType(DT)) {
            return;
        }
        this.processScope(DT.getScope().resolve());
        DISubroutineType ST = IrRTTI.dyn_cast_DISubroutineType(DT);
        if (ST != null) {
            for (TypedDINodeRef<DIType> typedDINodeRef : ST.getTypeArray()) {
                this.processType(typedDINodeRef.resolve());
            }
            return;
        }
        DICompositeType DCT = IrRTTI.dyn_cast_DICompositeType(DT);
        if (DCT != null) {
            this.processType(DCT.getBaseType().resolve());
            for (Metadata metadata : DCT.getElements()) {
                DIType T2 = IrRTTI.dyn_cast_DIType(metadata);
                if (T2 != null) {
                    this.processType(T2);
                    continue;
                }
                DISubprogram SP = IrRTTI.dyn_cast_DISubprogram(metadata);
                if (SP == null) continue;
                this.processSubprogram(SP);
            }
            return;
        }
        DIDerivedType DDT = IrRTTI.dyn_cast_DIDerivedType(DT);
        if (DDT != null) {
            this.processType(DDT.getBaseType().resolve());
        }
    }

    private void processSubprogram(DISubprogram SP) {
        if (!this.addSubprogram(SP)) {
            return;
        }
        this.processScope(SP.getScope().resolve());
        this.processType(SP.getType());
        for (DITemplateParameter Element : SP.getTemplateParams()) {
            DITemplateTypeParameter TType = IrRTTI.dyn_cast_DITemplateTypeParameter(Element);
            if (TType != null) {
                this.processType(TType.getType().resolve());
                continue;
            }
            DITemplateValueParameter TVal = IrRTTI.dyn_cast_DITemplateValueParameter(Element);
            if (TVal == null) continue;
            this.processType(TVal.getType().resolve());
        }
    }

    private void processScope(DIScope Scope) {
        if (Scope == null) {
            return;
        }
        DIType Ty = IrRTTI.dyn_cast_DIType(Scope);
        if (Ty != null) {
            this.processType(Ty);
            return;
        }
        DICompileUnit CU = IrRTTI.dyn_cast_DICompileUnit(Scope);
        if (CU != null) {
            this.addCompileUnit(CU);
            return;
        }
        DISubprogram SP = IrRTTI.dyn_cast_DISubprogram(Scope);
        if (SP != null) {
            this.processSubprogram(SP);
            return;
        }
        if (!this.addScope(Scope)) {
            return;
        }
        DILexicalBlockBase LB = IrRTTI.dyn_cast_DILexicalBlockBase(Scope);
        if (LB != null) {
            this.processScope(LB.getScope());
        } else {
            DINamespace NS = IrRTTI.dyn_cast_DINamespace(Scope);
            if (NS != null) {
                this.processScope(NS.getScope());
            } else {
                DIModule M = IrRTTI.dyn_cast_DIModule(Scope);
                if (M != null) {
                    this.processScope(M.getScope());
                }
            }
        }
    }

    private boolean addCompileUnit(DICompileUnit CU) {
        if (CU == null) {
            return false;
        }
        if (!this.NodesSeen.insert((Object)CU).second) {
            return false;
        }
        this.CUs.push_back((Object)CU);
        return true;
    }

    private boolean addGlobalVariable(DIGlobalVariable DIG) {
        if (DIG == null) {
            return false;
        }
        if (!this.NodesSeen.insert((Object)DIG).second) {
            return false;
        }
        this.GVs.push_back((Object)DIG);
        return true;
    }

    private boolean addSubprogram(DISubprogram SP) {
        if (SP == null) {
            return false;
        }
        if (!this.NodesSeen.insert((Object)SP).second) {
            return false;
        }
        this.SPs.push_back((Object)SP);
        return true;
    }

    private boolean addType(DIType DT) {
        if (DT == null) {
            return false;
        }
        if (!this.NodesSeen.insert((Object)DT).second) {
            return false;
        }
        this.TYs.push_back((Object)DT);
        return true;
    }

    private boolean addScope(DIScope Scope) {
        if (Scope == null) {
            return false;
        }
        if (Scope.getNumOperands() == 0) {
            return false;
        }
        if (!this.NodesSeen.insert((Object)Scope).second) {
            return false;
        }
        this.Scopes.push_back((Object)Scope);
        return true;
    }

    public iterator_range<DICompileUnit> compile_units() {
        return llvm.make_range((type.iterator)this.CUs.begin$Const(), (type.iterator)this.CUs.end$Const());
    }

    public iterator_range<DISubprogram> subprograms() {
        return llvm.make_range((type.iterator)this.SPs.begin$Const(), (type.iterator)this.SPs.end$Const());
    }

    public iterator_range<DIGlobalVariable> global_variables() {
        return llvm.make_range((type.iterator)this.GVs.begin$Const(), (type.iterator)this.GVs.end$Const());
    }

    public iterator_range<DIType> types() {
        return llvm.make_range((type.iterator)this.TYs.begin$Const(), (type.iterator)this.TYs.end$Const());
    }

    public iterator_range<DIScope> scopes() {
        return llvm.make_range((type.iterator)this.Scopes.begin$Const(), (type.iterator)this.Scopes.end$Const());
    }

    public int compile_unit_count() {
        return this.CUs.size();
    }

    public int global_variable_count() {
        return this.GVs.size();
    }

    public int subprogram_count() {
        return this.SPs.size();
    }

    public int type_count() {
        return this.TYs.size();
    }

    public int scope_count() {
        return this.Scopes.size();
    }

    public void $destroy() {
        this.NodesSeen.$destroy();
        this.Scopes.$destroy();
        this.TYs.$destroy();
        this.GVs.$destroy();
        this.SPs.$destroy();
        this.CUs.$destroy();
    }

    public String toString() {
        return "CUs=" + this.CUs + ", SPs=" + this.SPs + ", GVs=" + this.GVs + ", TYs=" + this.TYs + ", Scopes=" + this.Scopes + ", NodesSeen=" + this.NodesSeen;
    }
}

