/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.clank.java.std_ptr;
import org.clank.support.Destructors;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.uint;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.java.SmallVectorImplCommon;
import org.llvm.ir.DIFile;
import org.llvm.ir.DILexicalBlockFile;
import org.llvm.ir.DILocalScope;
import org.llvm.ir.LLVMContext;
import org.llvm.ir.MDNode;
import org.llvm.ir.Metadata;
import org.llvm.ir.impl.DebugInfoMetadataStatics;
import org.llvm.ir.impl.IrLlvmStatics;
import org.llvm.ir.impl.MDNodeKeyImplDILocation;
import org.llvm.ir.java.IrRTTI;
import org.llvm.support.llvm;

public class DILocation
extends MDNode
implements Destructors.ClassWithDestructor {
    private DILocation(LLVMContext C2, Metadata.StorageType Storage, int Line, int Column, ArrayRef<Metadata> MDs) {
        super(C2, Metadata.MetadataKind.DILocationKind.getValue(), Storage, (ArrayRef<Metadata>)new ArrayRef(MDs));
        assert (MDs.size() == 1 || MDs.size() == 2) : "Expected a scope and optional inlined-at";
        assert (Unsigned.$less_uint((int)Column, (int)65536)) : "Expected 16-bit column";
        this.SubclassData32 = Line;
        this.SubclassData16 = Unsigned.$uint2ushort((int)Column);
    }

    @Override
    public void $destroy() {
        this.dropAllReferences();
        super.$destroy();
    }

    private static DILocation getImpl(LLVMContext Context, int Line, int Column, Metadata Scope, Metadata InlinedAt, Metadata.StorageType Storage) {
        return DILocation.getImpl(Context, Line, Column, Scope, InlinedAt, Storage, true);
    }

    private static DILocation getImpl(LLVMContext Context, int Line, int Column, Metadata Scope, Metadata InlinedAt, Metadata.StorageType Storage, boolean ShouldCreate) {
        uint.ref Column$ref = NativePointer.create_uint$ref((int)Column);
        DebugInfoMetadataStatics.adjustColumn(Column$ref);
        Column = Column$ref.$deref();
        if (Storage == Metadata.StorageType.Uniqued) {
            DILocation N = IrLlvmStatics.getUniqued(Context.pImpl.DILocations, new MDNodeKeyImplDILocation(Line, Column, Scope, InlinedAt));
            if (N != null) {
                return N;
            }
            if (!ShouldCreate) {
                return null;
            }
        } else assert (ShouldCreate) : "Expected non-uniqued nodes to always be created";
        SmallVector Ops = new SmallVector(2, (Object)null);
        Ops.push_back((Object)Scope);
        if (InlinedAt != null) {
            Ops.push_back((Object)InlinedAt);
        }
        int Column$final = Column;
        return MDNode.storeImpl((DILocation)MDNode.$new(Ops.size(), New$Mem -> new DILocation(Context, Storage, Line, Column$final, (ArrayRef<Metadata>)new ArrayRef((SmallVectorImplCommon)Ops, true))), Storage, Context.pImpl.DILocations);
    }

    private static DILocation getImpl(LLVMContext Context, int Line, int Column, DILocalScope Scope, DILocation InlinedAt, Metadata.StorageType Storage) {
        return DILocation.getImpl(Context, Line, Column, Scope, InlinedAt, Storage, true);
    }

    private static DILocation getImpl(LLVMContext Context, int Line, int Column, DILocalScope Scope, DILocation InlinedAt, Metadata.StorageType Storage, boolean ShouldCreate) {
        return DILocation.getImpl(Context, Line, Column, (Metadata)Scope, (Metadata)InlinedAt, Storage, ShouldCreate);
    }

    std_ptr.unique_ptr_with_deleter<DILocation> cloneImpl() {
        return DILocation.getTemporary(this.getContext(), this.getLine(), this.getColumn(), this.getRawScope(), this.getRawInlinedAt());
    }

    @Override
    public void replaceOperandWith(int I, Metadata New2) {
        throw new UnsupportedOperationException("Deleted");
    }

    public static DILocation get(LLVMContext Context, int Line, int Column, Metadata Scope) {
        return DILocation.get(Context, Line, Column, Scope, (Metadata)null);
    }

    public static DILocation get(LLVMContext Context, int Line, int Column, Metadata Scope, Metadata InlinedAt) {
        return DILocation.getImpl(Context, Line, Column, Scope, InlinedAt, Metadata.StorageType.Uniqued);
    }

    public static DILocation getIfExists(LLVMContext Context, int Line, int Column, Metadata Scope) {
        return DILocation.getIfExists(Context, Line, Column, Scope, (Metadata)null);
    }

    public static DILocation getIfExists(LLVMContext Context, int Line, int Column, Metadata Scope, Metadata InlinedAt) {
        return DILocation.getImpl(Context, Line, Column, Scope, InlinedAt, Metadata.StorageType.Uniqued, false);
    }

    public static DILocation getDistinct(LLVMContext Context, int Line, int Column, Metadata Scope) {
        return DILocation.getDistinct(Context, Line, Column, Scope, (Metadata)null);
    }

    public static DILocation getDistinct(LLVMContext Context, int Line, int Column, Metadata Scope, Metadata InlinedAt) {
        return DILocation.getImpl(Context, Line, Column, Scope, InlinedAt, Metadata.StorageType.Distinct);
    }

    public static std_ptr.unique_ptr_with_deleter<DILocation> getTemporary(LLVMContext Context, int Line, int Column, Metadata Scope) {
        return DILocation.getTemporary(Context, Line, Column, Scope, (Metadata)null);
    }

    public static std_ptr.unique_ptr_with_deleter<DILocation> getTemporary(LLVMContext Context, int Line, int Column, Metadata Scope, Metadata InlinedAt) {
        return new std_ptr.unique_ptr_with_deleter((Object)DILocation.getImpl(Context, Line, Column, Scope, InlinedAt, Metadata.StorageType.Temporary));
    }

    public static DILocation get(LLVMContext Context, int Line, int Column, DILocalScope Scope) {
        return DILocation.get(Context, Line, Column, Scope, null);
    }

    public static DILocation get(LLVMContext Context, int Line, int Column, DILocalScope Scope, DILocation InlinedAt) {
        return DILocation.getImpl(Context, Line, Column, Scope, InlinedAt, Metadata.StorageType.Uniqued);
    }

    public static DILocation getIfExists(LLVMContext Context, int Line, int Column, DILocalScope Scope) {
        return DILocation.getIfExists(Context, Line, Column, Scope, null);
    }

    public static DILocation getIfExists(LLVMContext Context, int Line, int Column, DILocalScope Scope, DILocation InlinedAt) {
        return DILocation.getImpl(Context, Line, Column, Scope, InlinedAt, Metadata.StorageType.Uniqued, false);
    }

    public static DILocation getDistinct(LLVMContext Context, int Line, int Column, DILocalScope Scope) {
        return DILocation.getDistinct(Context, Line, Column, Scope, null);
    }

    public static DILocation getDistinct(LLVMContext Context, int Line, int Column, DILocalScope Scope, DILocation InlinedAt) {
        return DILocation.getImpl(Context, Line, Column, Scope, InlinedAt, Metadata.StorageType.Distinct);
    }

    public static std_ptr.unique_ptr_with_deleter<DILocation> getTemporary(LLVMContext Context, int Line, int Column, DILocalScope Scope) {
        return DILocation.getTemporary(Context, Line, Column, Scope, null);
    }

    public static std_ptr.unique_ptr_with_deleter<DILocation> getTemporary(LLVMContext Context, int Line, int Column, DILocalScope Scope, DILocation InlinedAt) {
        return new std_ptr.unique_ptr_with_deleter((Object)DILocation.getImpl(Context, Line, Column, Scope, InlinedAt, Metadata.StorageType.Temporary));
    }

    public std_ptr.unique_ptr_with_deleter<DILocation> clone() {
        return this.cloneImpl();
    }

    public int getLine() {
        return this.SubclassData32;
    }

    public int getColumn() {
        return Unsigned.$ushort2uint((char)this.SubclassData16);
    }

    public DILocalScope getScope() {
        return IrRTTI.cast_DILocalScope(this.getRawScope());
    }

    public DILocation getInlinedAt() {
        return IrRTTI.cast_or_null_DILocation(this.getRawInlinedAt());
    }

    public DIFile getFile() {
        return this.getScope().getFile();
    }

    public StringRef getFilename() {
        return this.getScope().getFilename();
    }

    public StringRef getDirectory() {
        return this.getScope().getDirectory();
    }

    public DILocalScope getInlinedAtScope() {
        DILocation IA = this.getInlinedAt();
        if (IA != null) {
            return IA.getInlinedAtScope();
        }
        return this.getScope();
    }

    public boolean canDiscriminate(DILocation RHS) {
        return llvm.$noteq_StringRef((StringRef)this.getFilename(), (StringRef)RHS.getFilename()) || this.getLine() != RHS.getLine();
    }

    public int getDiscriminator() {
        DILexicalBlockFile F = IrRTTI.dyn_cast_DILexicalBlockFile(this.getScope());
        if (F != null) {
            return F.getDiscriminator();
        }
        return 0;
    }

    public Metadata getRawScope() {
        return this.getOperand(0).$Metadata$P();
    }

    public Metadata getRawInlinedAt() {
        if (this.getNumOperands() == 2) {
            return this.getOperand(1).$Metadata$P();
        }
        return null;
    }

    public static boolean classof(Metadata MD) {
        return MD.getMetadataID() == Metadata.MetadataKind.DILocationKind.getValue();
    }

    @Override
    public String toString() {
        return "" + super.toString();
    }
}

