/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.clank.java.std_ptr;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.llvm.adt.Optional;
import org.llvm.adt.StringRef;
import org.llvm.adt.StringSwitch;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.ir.DICompositeType;
import org.llvm.ir.DIFile;
import org.llvm.ir.DIGlobalVariable;
import org.llvm.ir.DIImportedEntity;
import org.llvm.ir.DIMacroNode;
import org.llvm.ir.DINode;
import org.llvm.ir.DIScope;
import org.llvm.ir.DIType;
import org.llvm.ir.LLVMContext;
import org.llvm.ir.MDNode;
import org.llvm.ir.MDString;
import org.llvm.ir.MDTupleTypedArrayWrapper;
import org.llvm.ir.Metadata;
import org.llvm.ir.impl.DebugInfoMetadataStatics;
import org.llvm.ir.java.IrRTTI;
import org.llvm.support.llvm;

public class DICompileUnit
extends DIScope
implements Destructors.ClassWithDestructor {
    private int SourceLanguage;
    private boolean IsOptimized;
    private int RuntimeVersion;
    private int EmissionKind;
    private long DWOId;

    public static Optional<DebugEmissionKind> getEmissionKind(StringRef Str) {
        return (Optional)new StringSwitch(Str).Case(8, "NoDebug", (Object)new Optional(JavaDifferentiators.JD$T$RR.INSTANCE, (Object)DebugEmissionKind.NoDebug)).Case(10, "FullDebug", (Object)new Optional(JavaDifferentiators.JD$T$RR.INSTANCE, (Object)DebugEmissionKind.FullDebug)).Case(15, "LineTablesOnly", (Object)new Optional(JavaDifferentiators.JD$T$RR.INSTANCE, (Object)DebugEmissionKind.LineTablesOnly)).Default((Object)new Optional(llvm.None));
    }

    public static char.ptr EmissionKindString(DebugEmissionKind EK) {
        switch (EK) {
            case NoDebug: {
                return NativePointer.$((String)"NoDebug");
            }
            case FullDebug: {
                return NativePointer.$((String)"FullDebug");
            }
            case LineTablesOnly: {
                return NativePointer.$((String)"LineTablesOnly");
            }
        }
        return null;
    }

    private DICompileUnit(LLVMContext C2, Metadata.StorageType Storage, int SourceLanguage, boolean IsOptimized, int RuntimeVersion, int EmissionKind, long DWOId, ArrayRef<Metadata> Ops) {
        super(C2, Metadata.MetadataKind.DICompileUnitKind.getValue(), Storage, Unsigned.$ushort2uint((char)'\u0011'), (ArrayRef<Metadata>)new ArrayRef(Ops));
        this.SourceLanguage = SourceLanguage;
        this.IsOptimized = IsOptimized;
        this.RuntimeVersion = RuntimeVersion;
        this.EmissionKind = EmissionKind;
        this.DWOId = DWOId;
        assert (Storage != Metadata.StorageType.Uniqued);
    }

    @Override
    public void $destroy() {
        super.$destroy();
    }

    private static DICompileUnit getImpl(LLVMContext Context, int SourceLanguage, DIFile File, StringRef Producer, boolean IsOptimized, StringRef Flags, int RuntimeVersion, StringRef SplitDebugFilename, int EmissionKind, MDTupleTypedArrayWrapper<DICompositeType> EnumTypes, MDTupleTypedArrayWrapper<DIScope> RetainedTypes, MDTupleTypedArrayWrapper<DIGlobalVariable> GlobalVariables, MDTupleTypedArrayWrapper<DIImportedEntity> ImportedEntities, MDTupleTypedArrayWrapper<DIMacroNode> Macros, long DWOId, Metadata.StorageType Storage) {
        return DICompileUnit.getImpl(Context, SourceLanguage, File, Producer, IsOptimized, Flags, RuntimeVersion, SplitDebugFilename, EmissionKind, EnumTypes, RetainedTypes, GlobalVariables, ImportedEntities, Macros, DWOId, Storage, true);
    }

    private static DICompileUnit getImpl(LLVMContext Context, int SourceLanguage, DIFile File, StringRef Producer, boolean IsOptimized, StringRef Flags, int RuntimeVersion, StringRef SplitDebugFilename, int EmissionKind, MDTupleTypedArrayWrapper<DICompositeType> EnumTypes, MDTupleTypedArrayWrapper<DIScope> RetainedTypes, MDTupleTypedArrayWrapper<DIGlobalVariable> GlobalVariables, MDTupleTypedArrayWrapper<DIImportedEntity> ImportedEntities, MDTupleTypedArrayWrapper<DIMacroNode> Macros, long DWOId, Metadata.StorageType Storage, boolean ShouldCreate) {
        return DICompileUnit.getImpl(Context, SourceLanguage, (Metadata)File, DINode.getCanonicalMDString(Context, new StringRef(Producer)), IsOptimized, DINode.getCanonicalMDString(Context, new StringRef(Flags)), RuntimeVersion, DINode.getCanonicalMDString(Context, new StringRef(SplitDebugFilename)), EmissionKind, EnumTypes.get(), RetainedTypes.get(), GlobalVariables.get(), ImportedEntities.get(), Macros.get(), DWOId, Storage, ShouldCreate);
    }

    private static DICompileUnit getImpl(LLVMContext Context, int SourceLanguage, Metadata File, MDString Producer, boolean IsOptimized, MDString Flags, int RuntimeVersion, MDString SplitDebugFilename, int EmissionKind, Metadata EnumTypes, Metadata RetainedTypes, Metadata GlobalVariables, Metadata ImportedEntities, Metadata Macros, long DWOId, Metadata.StorageType Storage) {
        return DICompileUnit.getImpl(Context, SourceLanguage, File, Producer, IsOptimized, Flags, RuntimeVersion, SplitDebugFilename, EmissionKind, EnumTypes, RetainedTypes, GlobalVariables, ImportedEntities, Macros, DWOId, Storage, true);
    }

    private static DICompileUnit getImpl(LLVMContext Context, int SourceLanguage, Metadata File, MDString Producer, boolean IsOptimized, MDString Flags, int RuntimeVersion, MDString SplitDebugFilename, int EmissionKind, Metadata EnumTypes, Metadata RetainedTypes, Metadata GlobalVariables, Metadata ImportedEntities, Metadata Macros, long DWOId, Metadata.StorageType Storage, boolean ShouldCreate) {
        assert (Storage != Metadata.StorageType.Uniqued) : "Cannot unique DICompileUnit";
        assert (DebugInfoMetadataStatics.isCanonical(Producer)) : "Expected canonical MDString";
        assert (DebugInfoMetadataStatics.isCanonical(Flags)) : "Expected canonical MDString";
        assert (DebugInfoMetadataStatics.isCanonical(SplitDebugFilename)) : "Expected canonical MDString";
        Object[] Ops = new Metadata[]{File, Producer, Flags, SplitDebugFilename, EnumTypes, RetainedTypes, GlobalVariables, ImportedEntities, Macros};
        return DICompileUnit.storeImpl((DICompileUnit)MDNode.$new(llvm.array_lengthof((Object[])Ops), arg_0 -> DICompileUnit.lambda$getImpl$0(Context, Storage, SourceLanguage, IsOptimized, RuntimeVersion, EmissionKind, DWOId, (Metadata[])Ops, arg_0)), Storage);
    }

    std_ptr.unique_ptr_with_deleter<DICompileUnit> cloneImpl() {
        return DICompileUnit.getTemporary(this.getContext(), this.getSourceLanguage(), this.getFile(), this.getProducer(), this.isOptimized(), this.getFlags(), this.getRuntimeVersion(), this.getSplitDebugFilename(), this.getEmissionKind(), this.getEnumTypes(), this.getRetainedTypes(), this.getGlobalVariables(), this.getImportedEntities(), this.getMacros(), this.DWOId);
    }

    protected static void get() {
        throw new UnsupportedOperationException("Deleted");
    }

    protected static void getIfExists() {
        throw new UnsupportedOperationException("Deleted");
    }

    public static DICompileUnit getDistinct(LLVMContext Context, int SourceLanguage, DIFile File, StringRef Producer, boolean IsOptimized, StringRef Flags, int RuntimeVersion, StringRef SplitDebugFilename, DebugEmissionKind EmissionKind, MDTupleTypedArrayWrapper<DICompositeType> EnumTypes, MDTupleTypedArrayWrapper<DIScope> RetainedTypes, MDTupleTypedArrayWrapper<DIGlobalVariable> GlobalVariables, MDTupleTypedArrayWrapper<DIImportedEntity> ImportedEntities, MDTupleTypedArrayWrapper<DIMacroNode> Macros, long DWOId) {
        return DICompileUnit.getImpl(Context, SourceLanguage, File, new StringRef(Producer), IsOptimized, new StringRef(Flags), RuntimeVersion, new StringRef(SplitDebugFilename), EmissionKind.getValue(), new MDTupleTypedArrayWrapper<DICompositeType>(EnumTypes), new MDTupleTypedArrayWrapper<DIScope>(RetainedTypes), new MDTupleTypedArrayWrapper<DIGlobalVariable>(GlobalVariables), new MDTupleTypedArrayWrapper<DIImportedEntity>(ImportedEntities), new MDTupleTypedArrayWrapper<DIMacroNode>(Macros), DWOId, Metadata.StorageType.Distinct);
    }

    public static std_ptr.unique_ptr_with_deleter<DICompileUnit> getTemporary(LLVMContext Context, int SourceLanguage, DIFile File, StringRef Producer, boolean IsOptimized, StringRef Flags, int RuntimeVersion, StringRef SplitDebugFilename, DebugEmissionKind EmissionKind, MDTupleTypedArrayWrapper<DICompositeType> EnumTypes, MDTupleTypedArrayWrapper<DIScope> RetainedTypes, MDTupleTypedArrayWrapper<DIGlobalVariable> GlobalVariables, MDTupleTypedArrayWrapper<DIImportedEntity> ImportedEntities, MDTupleTypedArrayWrapper<DIMacroNode> Macros, long DWOId) {
        return new std_ptr.unique_ptr_with_deleter((Object)DICompileUnit.getImpl(Context, SourceLanguage, File, new StringRef(Producer), IsOptimized, new StringRef(Flags), RuntimeVersion, new StringRef(SplitDebugFilename), EmissionKind.getValue(), new MDTupleTypedArrayWrapper<DICompositeType>(EnumTypes), new MDTupleTypedArrayWrapper<DIScope>(RetainedTypes), new MDTupleTypedArrayWrapper<DIGlobalVariable>(GlobalVariables), new MDTupleTypedArrayWrapper<DIImportedEntity>(ImportedEntities), new MDTupleTypedArrayWrapper<DIMacroNode>(Macros), DWOId, Metadata.StorageType.Temporary));
    }

    public static DICompileUnit getDistinct(LLVMContext Context, int SourceLanguage, Metadata File, MDString Producer, boolean IsOptimized, MDString Flags, int RuntimeVersion, MDString SplitDebugFilename, int EmissionKind, Metadata EnumTypes, Metadata RetainedTypes, Metadata GlobalVariables, Metadata ImportedEntities, Metadata Macros, long DWOId) {
        return DICompileUnit.getImpl(Context, SourceLanguage, File, Producer, IsOptimized, Flags, RuntimeVersion, SplitDebugFilename, EmissionKind, EnumTypes, RetainedTypes, GlobalVariables, ImportedEntities, Macros, DWOId, Metadata.StorageType.Distinct);
    }

    public static std_ptr.unique_ptr_with_deleter<DICompileUnit> getTemporary(LLVMContext Context, int SourceLanguage, Metadata File, MDString Producer, boolean IsOptimized, MDString Flags, int RuntimeVersion, MDString SplitDebugFilename, int EmissionKind, Metadata EnumTypes, Metadata RetainedTypes, Metadata GlobalVariables, Metadata ImportedEntities, Metadata Macros, long DWOId) {
        return new std_ptr.unique_ptr_with_deleter((Object)DICompileUnit.getImpl(Context, SourceLanguage, File, Producer, IsOptimized, Flags, RuntimeVersion, SplitDebugFilename, EmissionKind, EnumTypes, RetainedTypes, GlobalVariables, ImportedEntities, Macros, DWOId, Metadata.StorageType.Temporary));
    }

    public std_ptr.unique_ptr_with_deleter<DICompileUnit> clone() {
        return this.cloneImpl();
    }

    public int getSourceLanguage() {
        return this.SourceLanguage;
    }

    public boolean isOptimized() {
        return this.IsOptimized;
    }

    public int getRuntimeVersion() {
        return this.RuntimeVersion;
    }

    public DebugEmissionKind getEmissionKind() {
        return DebugEmissionKind.valueOf(this.EmissionKind);
    }

    public StringRef getProducer() {
        return this.getStringOperand(1);
    }

    public StringRef getFlags() {
        return this.getStringOperand(2);
    }

    public StringRef getSplitDebugFilename() {
        return this.getStringOperand(3);
    }

    public MDTupleTypedArrayWrapper<DICompositeType> getEnumTypes() {
        return new MDTupleTypedArrayWrapper<DICompositeType>(DICompositeType.class, IrRTTI.cast_or_null_MDTuple(this.getRawEnumTypes()));
    }

    public MDTupleTypedArrayWrapper<DIScope> getRetainedTypes() {
        return new MDTupleTypedArrayWrapper<DIScope>(DIScope.class, IrRTTI.cast_or_null_MDTuple(this.getRawRetainedTypes()));
    }

    public MDTupleTypedArrayWrapper<DIGlobalVariable> getGlobalVariables() {
        return new MDTupleTypedArrayWrapper<DIGlobalVariable>(DIGlobalVariable.class, IrRTTI.cast_or_null_MDTuple(this.getRawGlobalVariables()));
    }

    public MDTupleTypedArrayWrapper<DIImportedEntity> getImportedEntities() {
        return new MDTupleTypedArrayWrapper<DIImportedEntity>(DIImportedEntity.class, IrRTTI.cast_or_null_MDTuple(this.getRawImportedEntities()));
    }

    public MDTupleTypedArrayWrapper<DIMacroNode> getMacros() {
        return new MDTupleTypedArrayWrapper<DIMacroNode>(DIMacroNode.class, IrRTTI.cast_or_null_MDTuple(this.getRawMacros()));
    }

    public long getDWOId() {
        return this.DWOId;
    }

    public void setDWOId(long DwoId) {
        this.DWOId = DwoId;
    }

    public MDString getRawProducer() {
        return this.getOperandAs(MDString.class, 1);
    }

    public MDString getRawFlags() {
        return this.getOperandAs(MDString.class, 2);
    }

    public MDString getRawSplitDebugFilename() {
        return this.getOperandAs(MDString.class, 3);
    }

    public Metadata getRawEnumTypes() {
        return this.getOperand(4).$Metadata$P();
    }

    public Metadata getRawRetainedTypes() {
        return this.getOperand(5).$Metadata$P();
    }

    public Metadata getRawGlobalVariables() {
        return this.getOperand(6).$Metadata$P();
    }

    public Metadata getRawImportedEntities() {
        return this.getOperand(7).$Metadata$P();
    }

    public Metadata getRawMacros() {
        return this.getOperand(8).$Metadata$P();
    }

    public void replaceEnumTypes(MDTupleTypedArrayWrapper<DICompositeType> N) {
        this.replaceOperandWith(4, N.get());
    }

    public void replaceRetainedTypes(MDTupleTypedArrayWrapper<DIType> N) {
        this.replaceOperandWith(5, N.get());
    }

    public void replaceGlobalVariables(MDTupleTypedArrayWrapper<DIGlobalVariable> N) {
        this.replaceOperandWith(6, N.get());
    }

    public void replaceImportedEntities(MDTupleTypedArrayWrapper<DIImportedEntity> N) {
        this.replaceOperandWith(7, N.get());
    }

    public void replaceMacros(MDTupleTypedArrayWrapper<DIMacroNode> N) {
        this.replaceOperandWith(8, N.get());
    }

    public static boolean classof(Metadata MD) {
        return MD.getMetadataID() == Metadata.MetadataKind.DICompileUnitKind.getValue();
    }

    @Override
    public String toString() {
        return "SourceLanguage=" + this.SourceLanguage + ", IsOptimized=" + this.IsOptimized + ", RuntimeVersion=" + this.RuntimeVersion + ", EmissionKind=" + this.EmissionKind + ", DWOId=" + this.DWOId + super.toString();
    }

    private static /* synthetic */ DICompileUnit lambda$getImpl$0(LLVMContext Context, Metadata.StorageType Storage, int SourceLanguage, boolean IsOptimized, int RuntimeVersion, int EmissionKind, long DWOId, Metadata[] Ops, type.ptr New$Mem) {
        return new DICompileUnit(Context, Storage, SourceLanguage, IsOptimized, RuntimeVersion, EmissionKind, DWOId, (ArrayRef<Metadata>)new ArrayRef((Object[])Ops, true));
    }

    public static final class DebugEmissionKind
    extends Enum<DebugEmissionKind>
    implements Native.NativeUIntEnum {
        public static final /* enum */ DebugEmissionKind NoDebug = new DebugEmissionKind(0);
        public static final /* enum */ DebugEmissionKind FullDebug = new DebugEmissionKind(NoDebug.getValue() + 1);
        public static final /* enum */ DebugEmissionKind LineTablesOnly = new DebugEmissionKind(FullDebug.getValue() + 1);
        public static final /* enum */ DebugEmissionKind LastEmissionKind = new DebugEmissionKind(DebugEmissionKind.LineTablesOnly.value);
        private final int value;
        private static final /* synthetic */ DebugEmissionKind[] $VALUES;

        public static DebugEmissionKind[] values() {
            return (DebugEmissionKind[])$VALUES.clone();
        }

        public static DebugEmissionKind valueOf(String name) {
            return Enum.valueOf(DebugEmissionKind.class, name);
        }

        public static DebugEmissionKind valueOf(int val) {
            DebugEmissionKind out;
            DebugEmissionKind debugEmissionKind = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private DebugEmissionKind(int val) {
            this.value = val;
        }

        public final int getValue() {
            return this.value;
        }

        static {
            $VALUES = new DebugEmissionKind[]{NoDebug, FullDebug, LineTablesOnly, LastEmissionKind};
        }

        private static final class Values {
            private static final DebugEmissionKind[] VALUES;
            private static final DebugEmissionKind[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (DebugEmissionKind kind : DebugEmissionKind.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new DebugEmissionKind[min < 0 ? 1 - min : 0];
                VALUES = new DebugEmissionKind[max >= 0 ? 1 + max : 0];
                for (DebugEmissionKind kind : DebugEmissionKind.values()) {
                    if (kind.value < 0) {
                        if (_VALUES[-kind.value] != null) continue;
                        Values._VALUES[-((DebugEmissionKind)kind).value] = kind;
                        continue;
                    }
                    if (VALUES[kind.value] != null) continue;
                    Values.VALUES[((DebugEmissionKind)kind).value] = kind;
                }
            }
        }
    }
}

