/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Unsigned;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.java.SmallVectorImplCommon;
import org.llvm.ir.Constant;
import org.llvm.ir.ConstantAggregate;
import org.llvm.ir.ConstantAggregateZero;
import org.llvm.ir.ConstantDataSequential;
import org.llvm.ir.ConstantDataVector;
import org.llvm.ir.UndefValue;
import org.llvm.ir.Value;
import org.llvm.ir.VectorType;
import org.llvm.ir.impl.ConstantAggrKeyType;
import org.llvm.ir.impl.ConstantsStatics;
import org.llvm.ir.java.IrRTTI;

public final class ConstantVector
extends ConstantAggregate
implements Destructors.ClassWithDestructor {
    void destroyConstantImpl() {
        this.getType().getContext().pImpl.VectorConstants.remove(this);
    }

    Value handleOperandChangeImpl(Value From, Value To) {
        assert (IrRTTI.isa_Constant(To)) : "Cannot make Constant refer to non-constant!";
        Constant ToC = IrRTTI.cast_Constant(To);
        SmallVector Values2 = new SmallVector(8, (Object)null);
        Values2.reserve(this.getNumOperands());
        int NumUpdated = 0;
        int OperandNo = 0;
        int e = this.getNumOperands();
        for (int i = 0; i != e; ++i) {
            Constant Val = this.getOperand(i);
            if (Val == From) {
                OperandNo = i;
                ++NumUpdated;
                Val = ToC;
            }
            Values2.push_back((Object)Val);
        }
        Constant C2 = ConstantVector.getImpl((ArrayRef<Constant>)new ArrayRef((SmallVectorImplCommon)Values2, true));
        if (C2 != null) {
            return C2;
        }
        return this.getContext().pImpl.VectorConstants.replaceOperandsInPlace((ArrayRef<Constant>)new ArrayRef((SmallVectorImplCommon)Values2, true), this, From, ToC, NumUpdated, OperandNo);
    }

    public ConstantVector(VectorType T2, ArrayRef<Constant> V) {
        super(T2, Value.ValueTy.ConstantVectorVal, (ArrayRef<Constant>)new ArrayRef(V));
        assert (V.size() == T2.getNumElements()) : "Invalid initializer for constant vector";
    }

    public static Constant get(ArrayRef<Constant> V) {
        Constant C2 = ConstantVector.getImpl((ArrayRef<Constant>)new ArrayRef(V));
        if (C2 != null) {
            return C2;
        }
        VectorType Ty = VectorType.get(((Constant)V.front()).getType(), V.size());
        return Ty.getContext().pImpl.VectorConstants.getOrCreate(Ty, new ConstantAggrKeyType<ConstantVector, VectorType>((ArrayRef<Constant>)new ArrayRef(V)));
    }

    private static Constant getImpl(ArrayRef<Constant> V) {
        assert (!V.empty()) : "Vectors can't be empty";
        VectorType T2 = VectorType.get(((Constant)V.front()).getType(), V.size());
        Constant C2 = (Constant)V.$at(0);
        boolean isZero = C2.isNullValue();
        boolean isUndef = IrRTTI.isa_UndefValue(C2);
        if (isZero || isUndef) {
            int e = V.size();
            for (int i = 1; i != e; ++i) {
                if (V.$at(i) == C2) continue;
                isUndef = false;
                isZero = false;
                break;
            }
        }
        if (isZero) {
            return ConstantAggregateZero.get(T2);
        }
        if (isUndef) {
            return UndefValue.get(T2);
        }
        if (ConstantDataSequential.isElementTypeCompatible(C2.getType())) {
            return ConstantsStatics.getSequenceIfElementsMatch(C2, (ArrayRef<Constant>)new ArrayRef(V));
        }
        return null;
    }

    public static Constant getSplat(int NumElts, Constant V) {
        if ((IrRTTI.isa_ConstantFP(V) || IrRTTI.isa_ConstantInt(V)) && ConstantDataSequential.isElementTypeCompatible(V.getType())) {
            return ConstantDataVector.getSplat(NumElts, V);
        }
        SmallVector Elts = new SmallVector(JavaDifferentiators.JD$UInt_T$C$R.INSTANCE, 32, NumElts, (Object)V, (Object)null);
        return ConstantVector.get((ArrayRef<Constant>)new ArrayRef((SmallVectorImplCommon)Elts, true));
    }

    @Override
    public VectorType getType() {
        return IrRTTI.cast_VectorType(super.getType());
    }

    @Override
    public Constant getSplatValue() {
        Constant Elt = this.getOperand(0);
        int I = 1;
        int E = this.getNumOperands();
        while (Unsigned.$less_uint((int)I, (int)E)) {
            if (this.getOperand(I) != Elt) {
                return null;
            }
            ++I;
        }
        return Elt;
    }

    public static boolean classof(Value V) {
        return V.getValueID() == Value.ValueTy.ConstantVectorVal.getValue();
    }

    @Override
    public void $destroy() {
        super.$destroy();
    }

    @Override
    public String toString() {
        return "" + super.toString();
    }
}

