/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.type;
import org.llvm.adt.APFloat;
import org.llvm.adt.StringRef;
import org.llvm.ir.Constant;
import org.llvm.ir.ConstantData;
import org.llvm.ir.ConstantVector;
import org.llvm.ir.LLVMContext;
import org.llvm.ir.Type;
import org.llvm.ir.Value;
import org.llvm.ir.VectorType;
import org.llvm.ir.impl.ConstantsStatics;
import org.llvm.ir.impl.LLVMContextImpl;
import org.llvm.ir.java.IrRTTI;
import org.llvm.support.fltSemantics;
import org.llvm.support.llvm_unreachable;

public final class ConstantFP
extends ConstantData
implements Destructors.ClassWithDestructor {
    private APFloat Val;

    @Override
    protected void anchor() {
    }

    protected ConstantFP(ConstantFP $Prm0) {
        super($Prm0);
        throw new UnsupportedOperationException("Deleted");
    }

    void destroyConstantImpl() {
        throw new llvm_unreachable("You can't ConstantInt->destroyConstantImpl()!");
    }

    private ConstantFP(Type Ty, APFloat V) {
        super(Ty, Value.ValueTy.ConstantFPVal);
        this.Val = new APFloat(V);
        assert (Native.$AddrOf((Object)V.getSemantics()) == ConstantsStatics.TypeToFloatSemantics(Ty)) : "FP type Mismatch";
    }

    public static Constant getZeroValueForNegation(Type Ty) {
        if (Ty.isFPOrFPVectorTy()) {
            return ConstantFP.getNegativeZero(Ty);
        }
        return Constant.getNullValue(Ty);
    }

    public static Constant get(Type Ty, double V) {
        LLVMContext Context = Ty.getContext();
        APFloat FV = new APFloat(V);
        bool.ptr ignored = NativePointer.create_bool$ptr();
        FV.convert((fltSemantics)Native.$Deref((Object)ConstantsStatics.TypeToFloatSemantics(Ty.getScalarType())), APFloat.roundingMode.rmNearestTiesToEven, (bool.ptr)Native.$AddrOf((Object)ignored));
        ConstantFP C2 = ConstantFP.get(Context, FV);
        VectorType VTy = IrRTTI.dyn_cast_VectorType(Ty);
        if (VTy != null) {
            return ConstantVector.getSplat(VTy.getNumElements(), C2);
        }
        return C2;
    }

    public static Constant get(Type Ty, StringRef Str) {
        LLVMContext Context = Ty.getContext();
        APFloat FV = new APFloat((fltSemantics)Native.$Deref((Object)ConstantsStatics.TypeToFloatSemantics(Ty.getScalarType())), new StringRef(Str));
        ConstantFP C2 = ConstantFP.get(Context, FV);
        VectorType VTy = IrRTTI.dyn_cast_VectorType(Ty);
        if (VTy != null) {
            return ConstantVector.getSplat(VTy.getNumElements(), C2);
        }
        return C2;
    }

    public static ConstantFP get(LLVMContext Context, APFloat V) {
        LLVMContextImpl pImpl = Context.pImpl;
        type.ref Slot = pImpl.FPConstants.ref$at((Object)V);
        if (Slot.$deref() == null) {
            Type Ty;
            if (Native.$AddrOf((Object)V.getSemantics()) == Native.$AddrOf((Object)APFloat.IEEEhalf)) {
                Ty = Type.getHalfTy(Context);
            } else if (Native.$AddrOf((Object)V.getSemantics()) == Native.$AddrOf((Object)APFloat.IEEEsingle)) {
                Ty = Type.getFloatTy(Context);
            } else if (Native.$AddrOf((Object)V.getSemantics()) == Native.$AddrOf((Object)APFloat.IEEEdouble)) {
                Ty = Type.getDoubleTy(Context);
            } else if (Native.$AddrOf((Object)V.getSemantics()) == Native.$AddrOf((Object)APFloat.x87DoubleExtended)) {
                Ty = Type.getX86_FP80Ty(Context);
            } else if (Native.$AddrOf((Object)V.getSemantics()) == Native.$AddrOf((Object)APFloat.IEEEquad)) {
                Ty = Type.getFP128Ty(Context);
            } else {
                assert (Native.$AddrOf((Object)V.getSemantics()) == Native.$AddrOf((Object)APFloat.PPCDoubleDouble)) : "Unknown FP format";
                Ty = Type.getPPC_FP128Ty(Context);
            }
            Slot.$set((Object)((ConstantFP)ConstantData.$new_ConstantData(New$Mem -> new ConstantFP(Ty, V))));
        }
        return (ConstantFP)Slot.$deref();
    }

    public static Constant getNaN(Type Ty) {
        return ConstantFP.getNaN(Ty, false, 0);
    }

    public static Constant getNaN(Type Ty, boolean Negative) {
        return ConstantFP.getNaN(Ty, Negative, 0);
    }

    public static Constant getNaN(Type Ty, boolean Negative, int Type2) {
        fltSemantics Semantics = (fltSemantics)Native.$Deref((Object)ConstantsStatics.TypeToFloatSemantics(Ty.getScalarType()));
        APFloat NaN = APFloat.getNaN((fltSemantics)Semantics, (boolean)Negative, (int)Type2);
        ConstantFP C2 = ConstantFP.get(Ty.getContext(), NaN);
        VectorType VTy = IrRTTI.dyn_cast_VectorType(Ty);
        if (VTy != null) {
            return ConstantVector.getSplat(VTy.getNumElements(), C2);
        }
        return C2;
    }

    public static Constant getNegativeZero(Type Ty) {
        fltSemantics Semantics = (fltSemantics)Native.$Deref((Object)ConstantsStatics.TypeToFloatSemantics(Ty.getScalarType()));
        APFloat NegZero = APFloat.getZero((fltSemantics)Semantics, (boolean)true);
        ConstantFP C2 = ConstantFP.get(Ty.getContext(), NegZero);
        VectorType VTy = IrRTTI.dyn_cast_VectorType(Ty);
        if (VTy != null) {
            return ConstantVector.getSplat(VTy.getNumElements(), C2);
        }
        return C2;
    }

    public static Constant getInfinity(Type Ty) {
        return ConstantFP.getInfinity(Ty, false);
    }

    public static Constant getInfinity(Type Ty, boolean Negative) {
        fltSemantics Semantics = (fltSemantics)Native.$Deref((Object)ConstantsStatics.TypeToFloatSemantics(Ty.getScalarType()));
        ConstantFP C2 = ConstantFP.get(Ty.getContext(), APFloat.getInf((fltSemantics)Semantics, (boolean)Negative));
        VectorType VTy = IrRTTI.dyn_cast_VectorType(Ty);
        if (VTy != null) {
            return ConstantVector.getSplat(VTy.getNumElements(), C2);
        }
        return C2;
    }

    public static boolean isValueValidForType(Type Ty, APFloat Val) {
        APFloat Val2 = new APFloat(Val);
        bool.ptr losesInfo = NativePointer.create_bool$ptr();
        switch (Ty.getTypeID()) {
            default: {
                return false;
            }
            case HalfTyID: {
                if (Native.$AddrOf((Object)Val2.getSemantics()) == Native.$AddrOf((Object)APFloat.IEEEhalf)) {
                    return true;
                }
                Val2.convert(APFloat.IEEEhalf, APFloat.roundingMode.rmNearestTiesToEven, (bool.ptr)Native.$AddrOf((Object)losesInfo));
                return !losesInfo.$star();
            }
            case FloatTyID: {
                if (Native.$AddrOf((Object)Val2.getSemantics()) == Native.$AddrOf((Object)APFloat.IEEEsingle)) {
                    return true;
                }
                Val2.convert(APFloat.IEEEsingle, APFloat.roundingMode.rmNearestTiesToEven, (bool.ptr)Native.$AddrOf((Object)losesInfo));
                return !losesInfo.$star();
            }
            case DoubleTyID: {
                if (Native.$AddrOf((Object)Val2.getSemantics()) == Native.$AddrOf((Object)APFloat.IEEEhalf) || Native.$AddrOf((Object)Val2.getSemantics()) == Native.$AddrOf((Object)APFloat.IEEEsingle) || Native.$AddrOf((Object)Val2.getSemantics()) == Native.$AddrOf((Object)APFloat.IEEEdouble)) {
                    return true;
                }
                Val2.convert(APFloat.IEEEdouble, APFloat.roundingMode.rmNearestTiesToEven, (bool.ptr)Native.$AddrOf((Object)losesInfo));
                return !losesInfo.$star();
            }
            case X86_FP80TyID: {
                return Native.$AddrOf((Object)Val2.getSemantics()) == Native.$AddrOf((Object)APFloat.IEEEhalf) || Native.$AddrOf((Object)Val2.getSemantics()) == Native.$AddrOf((Object)APFloat.IEEEsingle) || Native.$AddrOf((Object)Val2.getSemantics()) == Native.$AddrOf((Object)APFloat.IEEEdouble) || Native.$AddrOf((Object)Val2.getSemantics()) == Native.$AddrOf((Object)APFloat.x87DoubleExtended);
            }
            case FP128TyID: {
                return Native.$AddrOf((Object)Val2.getSemantics()) == Native.$AddrOf((Object)APFloat.IEEEhalf) || Native.$AddrOf((Object)Val2.getSemantics()) == Native.$AddrOf((Object)APFloat.IEEEsingle) || Native.$AddrOf((Object)Val2.getSemantics()) == Native.$AddrOf((Object)APFloat.IEEEdouble) || Native.$AddrOf((Object)Val2.getSemantics()) == Native.$AddrOf((Object)APFloat.IEEEquad);
            }
            case PPC_FP128TyID: 
        }
        return Native.$AddrOf((Object)Val2.getSemantics()) == Native.$AddrOf((Object)APFloat.IEEEhalf) || Native.$AddrOf((Object)Val2.getSemantics()) == Native.$AddrOf((Object)APFloat.IEEEsingle) || Native.$AddrOf((Object)Val2.getSemantics()) == Native.$AddrOf((Object)APFloat.IEEEdouble) || Native.$AddrOf((Object)Val2.getSemantics()) == Native.$AddrOf((Object)APFloat.PPCDoubleDouble);
    }

    public APFloat getValueAPF() {
        return this.Val;
    }

    public boolean isZero() {
        return this.Val.isZero();
    }

    public boolean isNegative() {
        return this.Val.isNegative();
    }

    public boolean isInfinity() {
        return this.Val.isInfinity();
    }

    public boolean isNaN() {
        return this.Val.isNaN();
    }

    public boolean isExactlyValue(APFloat V) {
        return this.Val.bitwiseIsEqual(V);
    }

    public boolean isExactlyValue(double V) {
        bool.ptr ignored = NativePointer.create_bool$ptr();
        APFloat FV = new APFloat(V);
        FV.convert(this.Val.getSemantics(), APFloat.roundingMode.rmNearestTiesToEven, (bool.ptr)Native.$AddrOf((Object)ignored));
        return this.isExactlyValue(FV);
    }

    public static boolean classof(Value V) {
        return V.getValueID() == Value.ValueTy.ConstantFPVal.getValue();
    }

    @Override
    public void $destroy() {
        this.Val.$destroy();
        super.$destroy();
    }

    @Override
    public String toString() {
        return "Val=" + this.Val + super.toString();
    }
}

