/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import java.util.Iterator;
import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.ArrayRefUInt;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImplUInt;
import org.llvm.adt.java.SmallVectorImplCommon;
import org.llvm.ir.ArrayType;
import org.llvm.ir.BinaryOperator;
import org.llvm.ir.CastInst;
import org.llvm.ir.CmpInst;
import org.llvm.ir.Constant;
import org.llvm.ir.ConstantFP;
import org.llvm.ir.ConstantInt;
import org.llvm.ir.ConstantVector;
import org.llvm.ir.ExtractElementInst;
import org.llvm.ir.ExtractValueInst;
import org.llvm.ir.GEPOperator;
import org.llvm.ir.GetElementPtrInst;
import org.llvm.ir.InsertElementInst;
import org.llvm.ir.InsertValueInst;
import org.llvm.ir.Instruction;
import org.llvm.ir.OperandTraitsConstantExpr;
import org.llvm.ir.PointerType;
import org.llvm.ir.SelectInst;
import org.llvm.ir.SequentialType;
import org.llvm.ir.ShuffleVectorInst;
import org.llvm.ir.StructType;
import org.llvm.ir.Type;
import org.llvm.ir.Use;
import org.llvm.ir.Value;
import org.llvm.ir.VectorType;
import org.llvm.ir.generic_gep_type_iterator;
import org.llvm.ir.impl.ConstantExprKeyType;
import org.llvm.ir.impl.ConstantFoldLlvmStatics;
import org.llvm.ir.impl.ConstantsStatics;
import org.llvm.ir.impl.ExtractValueConstantExpr;
import org.llvm.ir.impl.LLVMContextImpl;
import org.llvm.ir.java.IrRTTI;
import org.llvm.pass.IrLlvmGlobals;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;

public class ConstantExpr
extends Constant
implements Destructors.ClassWithDestructor {
    void destroyConstantImpl() {
        this.getType().getContext().pImpl.ExprConstants.remove(this);
    }

    Value handleOperandChangeImpl(Value From, Value ToV) {
        assert (IrRTTI.isa_Constant(ToV)) : "Cannot make Constant refer to non-constant!";
        Constant To = IrRTTI.cast_Constant(ToV);
        SmallVector NewOps = new SmallVector(8, (Object)null);
        int NumUpdated = 0;
        int OperandNo = 0;
        int e = this.getNumOperands();
        for (int i = 0; i != e; ++i) {
            Constant Op = this.getOperand_Constant(i);
            if (Op == From) {
                OperandNo = i;
                ++NumUpdated;
                Op = To;
            }
            NewOps.push_back((Object)Op);
        }
        assert (NumUpdated != 0) : "I didn't contain From!";
        Constant C2 = this.getWithOperands((ArrayRef<Constant>)new ArrayRef((SmallVectorImplCommon)NewOps, true), this.getType(), true);
        if (C2 != null) {
            return C2;
        }
        return this.getContext().pImpl.ExprConstants.replaceOperandsInPlace((ArrayRef<Constant>)new ArrayRef((SmallVectorImplCommon)NewOps, true), this, From, To, NumUpdated, OperandNo);
    }

    protected ConstantExpr(Type ty, int Opcode, type.ptr<Use> Ops, int NumOps) {
        super(ty, Value.ValueTy.ConstantExprVal, Ops, NumOps);
        this.setValueSubclassData(Unsigned.$uint2ushort((int)Opcode));
    }

    public static Constant getAlignOf(Type Ty) {
        StructType AligningTy = StructType.get(Type.getInt1Ty(Ty.getContext()), Ty, null);
        Constant NullPtr = Constant.getNullValue(AligningTy.getPointerTo(0));
        ConstantInt Zero = ConstantInt.get(Type.getInt64Ty(Ty.getContext()), Unsigned.$int2ulong((int)0));
        ConstantInt One = ConstantInt.get(Type.getInt32Ty(Ty.getContext()), Unsigned.$int2ulong((int)1));
        Object[] Indices = new Constant[]{Zero, One};
        Constant GEP = ConstantExpr.getGetElementPtr_Type$P_Constant$P_ArrayRef$Constant$P_bool_Type$P(AligningTy, NullPtr, (ArrayRef<Constant>)new ArrayRef(Indices, true));
        return ConstantExpr.getPtrToInt(GEP, Type.getInt64Ty(Ty.getContext()));
    }

    public static Constant getSizeOf(Type Ty) {
        ConstantInt GEPIdx = ConstantInt.get(Type.getInt32Ty(Ty.getContext()), Unsigned.$int2ulong((int)1));
        Constant GEP = ConstantExpr.getGetElementPtr(Ty, Constant.getNullValue(PointerType.getUnqual(Ty)), GEPIdx);
        return ConstantExpr.getPtrToInt(GEP, Type.getInt64Ty(Ty.getContext()));
    }

    public static Constant getOffsetOf(StructType STy, int FieldNo) {
        return ConstantExpr.getOffsetOf((Type)STy, ConstantInt.get(Type.getInt32Ty(STy.getContext()), Unsigned.$uint2ulong((int)FieldNo)));
    }

    public static Constant getOffsetOf(Type Ty, Constant FieldNo) {
        Object[] GEPIdx = new Constant[]{ConstantInt.get(Type.getInt64Ty(Ty.getContext()), Unsigned.$int2ulong((int)0)), FieldNo};
        Constant GEP = ConstantExpr.getGetElementPtr_Type$P_Constant$P_ArrayRef$Constant$P_bool_Type$P(Ty, Constant.getNullValue(PointerType.getUnqual(Ty)), (ArrayRef<Constant>)new ArrayRef(GEPIdx, true));
        return ConstantExpr.getPtrToInt(GEP, Type.getInt64Ty(Ty.getContext()));
    }

    public static Constant getNeg(Constant C2) {
        return ConstantExpr.getNeg(C2, false, false);
    }

    public static Constant getNeg(Constant C2, boolean HasNUW) {
        return ConstantExpr.getNeg(C2, HasNUW, false);
    }

    public static Constant getNeg(Constant C2, boolean HasNUW, boolean HasNSW) {
        assert (C2.getType().isIntOrIntVectorTy()) : "Cannot NEG a nonintegral value!";
        return ConstantExpr.getSub(ConstantFP.getZeroValueForNegation(C2.getType()), C2, HasNUW, HasNSW);
    }

    public static Constant getFNeg(Constant C2) {
        assert (C2.getType().isFPOrFPVectorTy()) : "Cannot FNEG a non-floating-point value!";
        return ConstantExpr.getFSub(ConstantFP.getZeroValueForNegation(C2.getType()), C2);
    }

    public static Constant getNot(Constant C2) {
        assert (C2.getType().isIntOrIntVectorTy()) : "Cannot NOT a nonintegral value!";
        return ConstantExpr.get(28, C2, Constant.getAllOnesValue(C2.getType()));
    }

    public static Constant getAdd(Constant C1, Constant C2) {
        return ConstantExpr.getAdd(C1, C2, false, false);
    }

    public static Constant getAdd(Constant C1, Constant C2, boolean HasNUW) {
        return ConstantExpr.getAdd(C1, C2, HasNUW, false);
    }

    public static Constant getAdd(Constant C1, Constant C2, boolean HasNUW, boolean HasNSW) {
        int Flags = (HasNUW ? 1 : 0) | (HasNSW ? 2 : 0);
        return ConstantExpr.get(11, C1, C2, Flags);
    }

    public static Constant getFAdd(Constant C1, Constant C2) {
        return ConstantExpr.get(12, C1, C2);
    }

    public static Constant getSub(Constant C1, Constant C2) {
        return ConstantExpr.getSub(C1, C2, false, false);
    }

    public static Constant getSub(Constant C1, Constant C2, boolean HasNUW) {
        return ConstantExpr.getSub(C1, C2, HasNUW, false);
    }

    public static Constant getSub(Constant C1, Constant C2, boolean HasNUW, boolean HasNSW) {
        int Flags = (HasNUW ? 1 : 0) | (HasNSW ? 2 : 0);
        return ConstantExpr.get(13, C1, C2, Flags);
    }

    public static Constant getFSub(Constant C1, Constant C2) {
        return ConstantExpr.get(14, C1, C2);
    }

    public static Constant getMul(Constant C1, Constant C2) {
        return ConstantExpr.getMul(C1, C2, false, false);
    }

    public static Constant getMul(Constant C1, Constant C2, boolean HasNUW) {
        return ConstantExpr.getMul(C1, C2, HasNUW, false);
    }

    public static Constant getMul(Constant C1, Constant C2, boolean HasNUW, boolean HasNSW) {
        int Flags = (HasNUW ? 1 : 0) | (HasNSW ? 2 : 0);
        return ConstantExpr.get(15, C1, C2, Flags);
    }

    public static Constant getFMul(Constant C1, Constant C2) {
        return ConstantExpr.get(16, C1, C2);
    }

    public static Constant getUDiv(Constant C1, Constant C2) {
        return ConstantExpr.getUDiv(C1, C2, false);
    }

    public static Constant getUDiv(Constant C1, Constant C2, boolean isExact) {
        return ConstantExpr.get(17, C1, C2, isExact ? 1 : 0);
    }

    public static Constant getSDiv(Constant C1, Constant C2) {
        return ConstantExpr.getSDiv(C1, C2, false);
    }

    public static Constant getSDiv(Constant C1, Constant C2, boolean isExact) {
        return ConstantExpr.get(18, C1, C2, isExact ? 1 : 0);
    }

    public static Constant getFDiv(Constant C1, Constant C2) {
        return ConstantExpr.get(19, C1, C2);
    }

    public static Constant getURem(Constant C1, Constant C2) {
        return ConstantExpr.get(20, C1, C2);
    }

    public static Constant getSRem(Constant C1, Constant C2) {
        return ConstantExpr.get(21, C1, C2);
    }

    public static Constant getFRem(Constant C1, Constant C2) {
        return ConstantExpr.get(22, C1, C2);
    }

    public static Constant getAnd(Constant C1, Constant C2) {
        return ConstantExpr.get(26, C1, C2);
    }

    public static Constant getOr(Constant C1, Constant C2) {
        return ConstantExpr.get(27, C1, C2);
    }

    public static Constant getXor(Constant C1, Constant C2) {
        return ConstantExpr.get(28, C1, C2);
    }

    public static Constant getShl(Constant C1, Constant C2) {
        return ConstantExpr.getShl(C1, C2, false, false);
    }

    public static Constant getShl(Constant C1, Constant C2, boolean HasNUW) {
        return ConstantExpr.getShl(C1, C2, HasNUW, false);
    }

    public static Constant getShl(Constant C1, Constant C2, boolean HasNUW, boolean HasNSW) {
        int Flags = (HasNUW ? 1 : 0) | (HasNSW ? 2 : 0);
        return ConstantExpr.get(23, C1, C2, Flags);
    }

    public static Constant getLShr(Constant C1, Constant C2) {
        return ConstantExpr.getLShr(C1, C2, false);
    }

    public static Constant getLShr(Constant C1, Constant C2, boolean isExact) {
        return ConstantExpr.get(24, C1, C2, isExact ? 1 : 0);
    }

    public static Constant getAShr(Constant C1, Constant C2) {
        return ConstantExpr.getAShr(C1, C2, false);
    }

    public static Constant getAShr(Constant C1, Constant C2, boolean isExact) {
        return ConstantExpr.get(25, C1, C2, isExact ? 1 : 0);
    }

    public static Constant getTrunc(Constant C2, Type Ty) {
        return ConstantExpr.getTrunc(C2, Ty, false);
    }

    public static Constant getTrunc(Constant C2, Type Ty, boolean OnlyIfReduced) {
        boolean toVec;
        boolean fromVec = C2.getType().getTypeID() == Type.TypeID.VectorTyID;
        boolean bl = toVec = Ty.getTypeID() == Type.TypeID.VectorTyID;
        assert (fromVec == toVec) : "Cannot convert from scalar to/from vector";
        assert (C2.getType().isIntOrIntVectorTy()) : "Trunc operand must be integer";
        assert (Ty.isIntOrIntVectorTy()) : "Trunc produces only integral";
        assert (Unsigned.$greater_uint((int)C2.getType().getScalarSizeInBits(), (int)Ty.getScalarSizeInBits())) : "SrcTy must be larger than DestTy for Trunc!";
        return ConstantsStatics.getFoldedCast(36, C2, Ty, OnlyIfReduced);
    }

    public static Constant getSExt(Constant C2, Type Ty) {
        return ConstantExpr.getSExt(C2, Ty, false);
    }

    public static Constant getSExt(Constant C2, Type Ty, boolean OnlyIfReduced) {
        boolean toVec;
        boolean fromVec = C2.getType().getTypeID() == Type.TypeID.VectorTyID;
        boolean bl = toVec = Ty.getTypeID() == Type.TypeID.VectorTyID;
        assert (fromVec == toVec) : "Cannot convert from scalar to/from vector";
        assert (C2.getType().isIntOrIntVectorTy()) : "SExt operand must be integral";
        assert (Ty.isIntOrIntVectorTy()) : "SExt produces only integer";
        assert (Unsigned.$less_uint((int)C2.getType().getScalarSizeInBits(), (int)Ty.getScalarSizeInBits())) : "SrcTy must be smaller than DestTy for SExt!";
        return ConstantsStatics.getFoldedCast(38, C2, Ty, OnlyIfReduced);
    }

    public static Constant getZExt(Constant C2, Type Ty) {
        return ConstantExpr.getZExt(C2, Ty, false);
    }

    public static Constant getZExt(Constant C2, Type Ty, boolean OnlyIfReduced) {
        boolean toVec;
        boolean fromVec = C2.getType().getTypeID() == Type.TypeID.VectorTyID;
        boolean bl = toVec = Ty.getTypeID() == Type.TypeID.VectorTyID;
        assert (fromVec == toVec) : "Cannot convert from scalar to/from vector";
        assert (C2.getType().isIntOrIntVectorTy()) : "ZEXt operand must be integral";
        assert (Ty.isIntOrIntVectorTy()) : "ZExt produces only integer";
        assert (Unsigned.$less_uint((int)C2.getType().getScalarSizeInBits(), (int)Ty.getScalarSizeInBits())) : "SrcTy must be smaller than DestTy for ZExt!";
        return ConstantsStatics.getFoldedCast(37, C2, Ty, OnlyIfReduced);
    }

    public static Constant getFPTrunc(Constant C2, Type Ty) {
        return ConstantExpr.getFPTrunc(C2, Ty, false);
    }

    public static Constant getFPTrunc(Constant C2, Type Ty, boolean OnlyIfReduced) {
        boolean toVec;
        boolean fromVec = C2.getType().getTypeID() == Type.TypeID.VectorTyID;
        boolean bl = toVec = Ty.getTypeID() == Type.TypeID.VectorTyID;
        assert (fromVec == toVec) : "Cannot convert from scalar to/from vector";
        assert (C2.getType().isFPOrFPVectorTy() && Ty.isFPOrFPVectorTy() && Unsigned.$greater_uint((int)C2.getType().getScalarSizeInBits(), (int)Ty.getScalarSizeInBits())) : "This is an illegal floating point truncation!";
        return ConstantsStatics.getFoldedCast(43, C2, Ty, OnlyIfReduced);
    }

    public static Constant getFPExtend(Constant C2, Type Ty) {
        return ConstantExpr.getFPExtend(C2, Ty, false);
    }

    public static Constant getFPExtend(Constant C2, Type Ty, boolean OnlyIfReduced) {
        boolean toVec;
        boolean fromVec = C2.getType().getTypeID() == Type.TypeID.VectorTyID;
        boolean bl = toVec = Ty.getTypeID() == Type.TypeID.VectorTyID;
        assert (fromVec == toVec) : "Cannot convert from scalar to/from vector";
        assert (C2.getType().isFPOrFPVectorTy() && Ty.isFPOrFPVectorTy() && Unsigned.$less_uint((int)C2.getType().getScalarSizeInBits(), (int)Ty.getScalarSizeInBits())) : "This is an illegal floating point extension!";
        return ConstantsStatics.getFoldedCast(44, C2, Ty, OnlyIfReduced);
    }

    public static Constant getUIToFP(Constant C2, Type Ty) {
        return ConstantExpr.getUIToFP(C2, Ty, false);
    }

    public static Constant getUIToFP(Constant C2, Type Ty, boolean OnlyIfReduced) {
        boolean toVec;
        boolean fromVec = C2.getType().getTypeID() == Type.TypeID.VectorTyID;
        boolean bl = toVec = Ty.getTypeID() == Type.TypeID.VectorTyID;
        assert (fromVec == toVec) : "Cannot convert from scalar to/from vector";
        assert (C2.getType().isIntOrIntVectorTy() && Ty.isFPOrFPVectorTy()) : "This is an illegal uint to floating point cast!";
        return ConstantsStatics.getFoldedCast(41, C2, Ty, OnlyIfReduced);
    }

    public static Constant getSIToFP(Constant C2, Type Ty) {
        return ConstantExpr.getSIToFP(C2, Ty, false);
    }

    public static Constant getSIToFP(Constant C2, Type Ty, boolean OnlyIfReduced) {
        boolean toVec;
        boolean fromVec = C2.getType().getTypeID() == Type.TypeID.VectorTyID;
        boolean bl = toVec = Ty.getTypeID() == Type.TypeID.VectorTyID;
        assert (fromVec == toVec) : "Cannot convert from scalar to/from vector";
        assert (C2.getType().isIntOrIntVectorTy() && Ty.isFPOrFPVectorTy()) : "This is an illegal sint to floating point cast!";
        return ConstantsStatics.getFoldedCast(42, C2, Ty, OnlyIfReduced);
    }

    public static Constant getFPToUI(Constant C2, Type Ty) {
        return ConstantExpr.getFPToUI(C2, Ty, false);
    }

    public static Constant getFPToUI(Constant C2, Type Ty, boolean OnlyIfReduced) {
        boolean toVec;
        boolean fromVec = C2.getType().getTypeID() == Type.TypeID.VectorTyID;
        boolean bl = toVec = Ty.getTypeID() == Type.TypeID.VectorTyID;
        assert (fromVec == toVec) : "Cannot convert from scalar to/from vector";
        assert (C2.getType().isFPOrFPVectorTy() && Ty.isIntOrIntVectorTy()) : "This is an illegal floating point to uint cast!";
        return ConstantsStatics.getFoldedCast(39, C2, Ty, OnlyIfReduced);
    }

    public static Constant getFPToSI(Constant C2, Type Ty) {
        return ConstantExpr.getFPToSI(C2, Ty, false);
    }

    public static Constant getFPToSI(Constant C2, Type Ty, boolean OnlyIfReduced) {
        boolean toVec;
        boolean fromVec = C2.getType().getTypeID() == Type.TypeID.VectorTyID;
        boolean bl = toVec = Ty.getTypeID() == Type.TypeID.VectorTyID;
        assert (fromVec == toVec) : "Cannot convert from scalar to/from vector";
        assert (C2.getType().isFPOrFPVectorTy() && Ty.isIntOrIntVectorTy()) : "This is an illegal floating point to sint cast!";
        return ConstantsStatics.getFoldedCast(40, C2, Ty, OnlyIfReduced);
    }

    public static Constant getPtrToInt(Constant C2, Type DstTy) {
        return ConstantExpr.getPtrToInt(C2, DstTy, false);
    }

    public static Constant getPtrToInt(Constant C2, Type DstTy, boolean OnlyIfReduced) {
        assert (C2.getType().getScalarType().isPointerTy()) : "PtrToInt source must be pointer or pointer vector";
        assert (DstTy.getScalarType().isIntegerTy()) : "PtrToInt destination must be integer or integer vector";
        assert (IrRTTI.isa_VectorType(C2.getType()) == IrRTTI.isa_VectorType(DstTy));
        if (IrRTTI.isa_VectorType(C2.getType())) assert (C2.getType().getVectorNumElements() == DstTy.getVectorNumElements()) : "Invalid cast between a different number of vector elements";
        return ConstantsStatics.getFoldedCast(45, C2, DstTy, OnlyIfReduced);
    }

    public static Constant getIntToPtr(Constant C2, Type DstTy) {
        return ConstantExpr.getIntToPtr(C2, DstTy, false);
    }

    public static Constant getIntToPtr(Constant C2, Type DstTy, boolean OnlyIfReduced) {
        assert (C2.getType().getScalarType().isIntegerTy()) : "IntToPtr source must be integer or integer vector";
        assert (DstTy.getScalarType().isPointerTy()) : "IntToPtr destination must be a pointer or pointer vector";
        assert (IrRTTI.isa_VectorType(C2.getType()) == IrRTTI.isa_VectorType(DstTy));
        if (IrRTTI.isa_VectorType(C2.getType())) assert (C2.getType().getVectorNumElements() == DstTy.getVectorNumElements()) : "Invalid cast between a different number of vector elements";
        return ConstantsStatics.getFoldedCast(46, C2, DstTy, OnlyIfReduced);
    }

    public static Constant getBitCast(Constant C2, Type DstTy) {
        return ConstantExpr.getBitCast(C2, DstTy, false);
    }

    public static Constant getBitCast(Constant C2, Type DstTy, boolean OnlyIfReduced) {
        assert (CastInst.castIsValid(47, C2, DstTy)) : "Invalid constantexpr bitcast!";
        if (C2.getType() == DstTy) {
            return C2;
        }
        return ConstantsStatics.getFoldedCast(47, C2, DstTy, OnlyIfReduced);
    }

    public static Constant getAddrSpaceCast(Constant C2, Type DstTy) {
        return ConstantExpr.getAddrSpaceCast(C2, DstTy, false);
    }

    public static Constant getAddrSpaceCast(Constant C2, Type DstTy, boolean OnlyIfReduced) {
        assert (CastInst.castIsValid(48, C2, DstTy)) : "Invalid constantexpr addrspacecast!";
        PointerType SrcScalarTy = IrRTTI.cast_PointerType(C2.getType().getScalarType());
        PointerType DstScalarTy = IrRTTI.cast_PointerType(DstTy.getScalarType());
        Type DstElemTy = DstScalarTy.getElementType();
        if (SrcScalarTy.getElementType() != DstElemTy) {
            SequentialType MidTy = PointerType.get(DstElemTy, SrcScalarTy.getAddressSpace());
            VectorType VT = IrRTTI.dyn_cast_VectorType(DstTy);
            if (VT != null) {
                MidTy = VectorType.get(MidTy, VT.getNumElements());
            }
            C2 = ConstantExpr.getBitCast(C2, MidTy);
        }
        return ConstantsStatics.getFoldedCast(48, C2, DstTy, OnlyIfReduced);
    }

    public static Constant getNSWNeg(Constant C2) {
        return ConstantExpr.getNeg(C2, false, true);
    }

    public static Constant getNUWNeg(Constant C2) {
        return ConstantExpr.getNeg(C2, true, false);
    }

    public static Constant getNSWAdd(Constant C1, Constant C2) {
        return ConstantExpr.getAdd(C1, C2, false, true);
    }

    public static Constant getNUWAdd(Constant C1, Constant C2) {
        return ConstantExpr.getAdd(C1, C2, true, false);
    }

    public static Constant getNSWSub(Constant C1, Constant C2) {
        return ConstantExpr.getSub(C1, C2, false, true);
    }

    public static Constant getNUWSub(Constant C1, Constant C2) {
        return ConstantExpr.getSub(C1, C2, true, false);
    }

    public static Constant getNSWMul(Constant C1, Constant C2) {
        return ConstantExpr.getMul(C1, C2, false, true);
    }

    public static Constant getNUWMul(Constant C1, Constant C2) {
        return ConstantExpr.getMul(C1, C2, true, false);
    }

    public static Constant getNSWShl(Constant C1, Constant C2) {
        return ConstantExpr.getShl(C1, C2, false, true);
    }

    public static Constant getNUWShl(Constant C1, Constant C2) {
        return ConstantExpr.getShl(C1, C2, true, false);
    }

    public static Constant getExactSDiv(Constant C1, Constant C2) {
        return ConstantExpr.getSDiv(C1, C2, true);
    }

    public static Constant getExactUDiv(Constant C1, Constant C2) {
        return ConstantExpr.getUDiv(C1, C2, true);
    }

    public static Constant getExactAShr(Constant C1, Constant C2) {
        return ConstantExpr.getAShr(C1, C2, true);
    }

    public static Constant getExactLShr(Constant C1, Constant C2) {
        return ConstantExpr.getLShr(C1, C2, true);
    }

    public static Constant getBinOpIdentity(int Opcode, Type Ty) {
        switch (Opcode) {
            default: {
                return null;
            }
            case 11: 
            case 27: 
            case 28: {
                return Constant.getNullValue(Ty);
            }
            case 15: {
                return ConstantInt.get(Ty, Unsigned.$int2ulong((int)1));
            }
            case 26: 
        }
        return Constant.getAllOnesValue(Ty);
    }

    public static Constant getBinOpAbsorber(int Opcode, Type Ty) {
        switch (Opcode) {
            default: {
                return null;
            }
            case 27: {
                return Constant.getAllOnesValue(Ty);
            }
            case 15: 
            case 26: 
        }
        return Constant.getNullValue(Ty);
    }

    public Constant getOperand_Constant(int i_nocapture) {
        assert (Unsigned.$less_uint((int)i_nocapture, (int)OperandTraitsConstantExpr.operands(this))) : "getOperand() out of range!";
        return IrRTTI.cast_or_null_Constant(((Use)OperandTraitsConstantExpr.op_begin(this).$at(i_nocapture)).get());
    }

    public void setOperand(int i_nocapture, Constant Val_nocapture) {
        assert (Unsigned.$less_uint((int)i_nocapture, (int)OperandTraitsConstantExpr.operands(this))) : "setOperand() out of range!";
        ((Use)OperandTraitsConstantExpr.op_begin(this).$at(i_nocapture)).$assign(Val_nocapture);
    }

    @Override
    public type.ptr<Use> op_begin() {
        return OperandTraitsConstantExpr.op_begin(this);
    }

    @Override
    public type.ptr<Use> op_begin$Const() {
        return OperandTraitsConstantExpr.op_begin(this);
    }

    @Override
    public type.ptr<Use> op_end() {
        return OperandTraitsConstantExpr.op_end(this);
    }

    @Override
    public type.ptr<Use> op_end$Const() {
        return OperandTraitsConstantExpr.op_end(this);
    }

    @Override
    protected Use Op(int Idx_nocapture) {
        return this.OpFrom(Idx_nocapture, this);
    }

    @Override
    protected Use Op$Const(int Idx_nocapture) {
        return this.OpFrom(Idx_nocapture, this);
    }

    @Override
    public int getNumOperands() {
        return OperandTraitsConstantExpr.operands(this);
    }

    public static Constant getCast(int oc, Constant C2, Type Ty) {
        return ConstantExpr.getCast(oc, C2, Ty, false);
    }

    public static Constant getCast(int oc, Constant C2, Type Ty, boolean OnlyIfReduced) {
        int opc = oc;
        assert (Instruction.isCast(opc)) : "opcode out of range";
        assert (C2 != null && Ty != null) : "Null arguments to getCast";
        assert (CastInst.castIsValid(opc, C2, Ty)) : "Invalid constantexpr cast!";
        switch (opc) {
            default: {
                throw new llvm_unreachable("Invalid cast opcode");
            }
            case 36: {
                return ConstantExpr.getTrunc(C2, Ty, OnlyIfReduced);
            }
            case 37: {
                return ConstantExpr.getZExt(C2, Ty, OnlyIfReduced);
            }
            case 38: {
                return ConstantExpr.getSExt(C2, Ty, OnlyIfReduced);
            }
            case 43: {
                return ConstantExpr.getFPTrunc(C2, Ty, OnlyIfReduced);
            }
            case 44: {
                return ConstantExpr.getFPExtend(C2, Ty, OnlyIfReduced);
            }
            case 41: {
                return ConstantExpr.getUIToFP(C2, Ty, OnlyIfReduced);
            }
            case 42: {
                return ConstantExpr.getSIToFP(C2, Ty, OnlyIfReduced);
            }
            case 39: {
                return ConstantExpr.getFPToUI(C2, Ty, OnlyIfReduced);
            }
            case 40: {
                return ConstantExpr.getFPToSI(C2, Ty, OnlyIfReduced);
            }
            case 45: {
                return ConstantExpr.getPtrToInt(C2, Ty, OnlyIfReduced);
            }
            case 46: {
                return ConstantExpr.getIntToPtr(C2, Ty, OnlyIfReduced);
            }
            case 47: {
                return ConstantExpr.getBitCast(C2, Ty, OnlyIfReduced);
            }
            case 48: 
        }
        return ConstantExpr.getAddrSpaceCast(C2, Ty, OnlyIfReduced);
    }

    public static Constant getZExtOrBitCast(Constant C2, Type Ty) {
        if (C2.getType().getScalarSizeInBits() == Ty.getScalarSizeInBits()) {
            return ConstantExpr.getBitCast(C2, Ty);
        }
        return ConstantExpr.getZExt(C2, Ty);
    }

    public static Constant getSExtOrBitCast(Constant C2, Type Ty) {
        if (C2.getType().getScalarSizeInBits() == Ty.getScalarSizeInBits()) {
            return ConstantExpr.getBitCast(C2, Ty);
        }
        return ConstantExpr.getSExt(C2, Ty);
    }

    public static Constant getTruncOrBitCast(Constant C2, Type Ty) {
        if (C2.getType().getScalarSizeInBits() == Ty.getScalarSizeInBits()) {
            return ConstantExpr.getBitCast(C2, Ty);
        }
        return ConstantExpr.getTrunc(C2, Ty);
    }

    public static Constant getPointerCast(Constant S, Type Ty) {
        assert (S.getType().isPtrOrPtrVectorTy()) : "Invalid cast";
        assert (Ty.isIntOrIntVectorTy() || Ty.isPtrOrPtrVectorTy()) : "Invalid cast";
        if (Ty.isIntOrIntVectorTy()) {
            return ConstantExpr.getPtrToInt(S, Ty);
        }
        int SrcAS = S.getType().getPointerAddressSpace();
        if (Ty.isPtrOrPtrVectorTy() && SrcAS != Ty.getPointerAddressSpace()) {
            return ConstantExpr.getAddrSpaceCast(S, Ty);
        }
        return ConstantExpr.getBitCast(S, Ty);
    }

    public static Constant getPointerBitCastOrAddrSpaceCast(Constant S, Type Ty) {
        assert (S.getType().isPtrOrPtrVectorTy()) : "Invalid cast";
        assert (Ty.isPtrOrPtrVectorTy()) : "Invalid cast";
        if (S.getType().getPointerAddressSpace() != Ty.getPointerAddressSpace()) {
            return ConstantExpr.getAddrSpaceCast(S, Ty);
        }
        return ConstantExpr.getBitCast(S, Ty);
    }

    public static Constant getIntegerCast(Constant C2, Type Ty, boolean isSigned) {
        int DstBits;
        assert (C2.getType().isIntOrIntVectorTy() && Ty.isIntOrIntVectorTy()) : "Invalid cast";
        int SrcBits = C2.getType().getScalarSizeInBits();
        int opcode = SrcBits == (DstBits = Ty.getScalarSizeInBits()) ? 47 : (Unsigned.$greater_uint((int)SrcBits, (int)DstBits) ? 36 : (isSigned ? 38 : 37));
        return ConstantExpr.getCast(opcode, C2, Ty);
    }

    public static Constant getFPCast(Constant C2, Type Ty) {
        int DstBits;
        assert (C2.getType().isFPOrFPVectorTy() && Ty.isFPOrFPVectorTy()) : "Invalid cast";
        int SrcBits = C2.getType().getScalarSizeInBits();
        if (SrcBits == (DstBits = Ty.getScalarSizeInBits())) {
            return C2;
        }
        int opcode = Unsigned.$greater_uint((int)SrcBits, (int)DstBits) ? 43 : 44;
        return ConstantExpr.getCast(opcode, C2, Ty);
    }

    public boolean isCast() {
        return Instruction.isCast(this.getOpcode());
    }

    public boolean isCompare() {
        return this.getOpcode() == 51 || this.getOpcode() == 52;
    }

    public boolean hasIndices() {
        return this.getOpcode() == 62 || this.getOpcode() == 63;
    }

    public boolean isGEPWithNoNotionalOverIndexing() {
        if (this.getOpcode() != 32) {
            return false;
        }
        generic_gep_type_iterator GEPI = IrLlvmGlobals.gep_type_begin_User$C$P(this);
        generic_gep_type_iterator E = IrLlvmGlobals.gep_type_end_User$C$P(this);
        type.ptr OI = (type.ptr)Native.$tryClone((NativeCloneable)((type.ptr)std.next(this.op_begin$Const())));
        GEPI.$preInc();
        OI.$preInc();
        while (GEPI.$noteq(E)) {
            ConstantInt CI = IrRTTI.dyn_cast_ConstantInt((Use)OI.$star());
            if (CI == null) {
                return false;
            }
            ArrayType ATy = IrRTTI.dyn_cast_ArrayType(GEPI.$star());
            if (ATy != null && (Unsigned.$greater_uint((int)CI.getValue().getActiveBits(), (int)64) || Unsigned.$greatereq_ulong((long)CI.getZExtValue(), (long)ATy.getNumElements()))) {
                return false;
            }
            GEPI.$preInc();
            OI.$preInc();
        }
        return true;
    }

    public static Constant getSelect(Constant C2, Constant V1, Constant V2) {
        return ConstantExpr.getSelect(C2, V1, V2, null);
    }

    public static Constant getSelect(Constant C2, Constant V1, Constant V2, Type OnlyIfReducedTy) {
        assert (!Native.$bool((Native.Native$Bool)SelectInst.areInvalidOperands(C2, V1, V2))) : "Invalid select operands";
        Constant SC = ConstantFoldLlvmStatics.ConstantFoldSelectInstruction(C2, V1, V2);
        if (SC != null) {
            return SC;
        }
        if (OnlyIfReducedTy == V1.getType()) {
            return null;
        }
        Object[] ArgVec = new Constant[]{C2, V1, V2};
        ConstantExprKeyType Key = new ConstantExprKeyType(55, (ArrayRef<Constant>)new ArrayRef(ArgVec, true));
        LLVMContextImpl pImpl = C2.getContext().pImpl;
        return pImpl.ExprConstants.getOrCreate(V1.getType(), new ConstantExprKeyType(Key));
    }

    public static Constant get(int Opcode, Constant C1, Constant C2) {
        return ConstantExpr.get(Opcode, C1, C2, 0, null);
    }

    public static Constant get(int Opcode, Constant C1, Constant C2, int Flags) {
        return ConstantExpr.get(Opcode, C1, C2, Flags, null);
    }

    public static Constant get(int Opcode, Constant C1, Constant C2, int Flags, Type OnlyIfReducedTy) {
        assert (Unsigned.$greatereq_uint_int((int)Opcode, (int)11) && Unsigned.$less_uint_int((int)Opcode, (int)29)) : "Invalid opcode in binary constant expression";
        assert (C1.getType() == C2.getType()) : "Operand types in binary constant expression should match";
        switch (Opcode) {
            case 11: 
            case 13: 
            case 15: {
                assert (C1.getType() == C2.getType()) : "Op types should be identical!";
                assert (C1.getType().isIntOrIntVectorTy()) : "Tried to create an integer operation on a non-integer type!";
                break;
            }
            case 12: 
            case 14: 
            case 16: {
                assert (C1.getType() == C2.getType()) : "Op types should be identical!";
                assert (C1.getType().isFPOrFPVectorTy()) : "Tried to create a floating-point operation on a non-floating-point type!";
                break;
            }
            case 17: 
            case 18: {
                assert (C1.getType() == C2.getType()) : "Op types should be identical!";
                assert (C1.getType().isIntOrIntVectorTy()) : "Tried to create an arithmetic operation on a non-arithmetic type!";
                break;
            }
            case 19: {
                assert (C1.getType() == C2.getType()) : "Op types should be identical!";
                assert (C1.getType().isFPOrFPVectorTy()) : "Tried to create an arithmetic operation on a non-arithmetic type!";
                break;
            }
            case 20: 
            case 21: {
                assert (C1.getType() == C2.getType()) : "Op types should be identical!";
                assert (C1.getType().isIntOrIntVectorTy()) : "Tried to create an arithmetic operation on a non-arithmetic type!";
                break;
            }
            case 22: {
                assert (C1.getType() == C2.getType()) : "Op types should be identical!";
                assert (C1.getType().isFPOrFPVectorTy()) : "Tried to create an arithmetic operation on a non-arithmetic type!";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                assert (C1.getType() == C2.getType()) : "Op types should be identical!";
                assert (C1.getType().isIntOrIntVectorTy()) : "Tried to create a logical operation on a non-integral type!";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                assert (C1.getType() == C2.getType()) : "Op types should be identical!";
                assert (C1.getType().isIntOrIntVectorTy()) : "Tried to create a shift operation on a non-integer type!";
                break;
            }
        }
        Constant FC = ConstantFoldLlvmStatics.ConstantFoldBinaryInstruction(Opcode, C1, C2);
        if (FC != null) {
            return FC;
        }
        if (OnlyIfReducedTy == C1.getType()) {
            return null;
        }
        Object[] ArgVec = new Constant[]{C1, C2};
        ConstantExprKeyType Key = new ConstantExprKeyType(Opcode, (ArrayRef<Constant>)new ArrayRef(ArgVec, true), Unsigned.$int2ushort((int)0), Unsigned.$uint2ushort((int)Flags));
        LLVMContextImpl pImpl = C1.getContext().pImpl;
        return pImpl.ExprConstants.getOrCreate(C1.getType(), new ConstantExprKeyType(Key));
    }

    public static Constant getCompare(char Predicate2, Constant C1, Constant C2) {
        return ConstantExpr.getCompare(Predicate2, C1, C2, false);
    }

    public static Constant getCompare(char Predicate2, Constant C1, Constant C2, boolean OnlyIfReduced) {
        assert (C1.getType() == C2.getType()) : "Op types should be identical!";
        switch (CmpInst.Predicate.valueOf(Unsigned.$ushort2int((char)Predicate2))) {
            default: {
                throw new llvm_unreachable("Invalid CmpInst predicate");
            }
            case FCMP_FALSE: 
            case FCMP_OEQ: 
            case FCMP_OGT: 
            case FCMP_OGE: 
            case FCMP_OLT: 
            case FCMP_OLE: 
            case FCMP_ONE: 
            case FCMP_ORD: 
            case FCMP_UNO: 
            case FCMP_UEQ: 
            case FCMP_UGT: 
            case FCMP_UGE: 
            case FCMP_ULT: 
            case FCMP_ULE: 
            case FCMP_UNE: 
            case FCMP_TRUE: {
                return ConstantExpr.getFCmp(Predicate2, C1, C2, OnlyIfReduced);
            }
            case ICMP_EQ: 
            case ICMP_NE: 
            case ICMP_UGT: 
            case ICMP_UGE: 
            case ICMP_ULT: 
            case ICMP_ULE: 
            case ICMP_SGT: 
            case ICMP_SGE: 
            case ICMP_SLT: 
            case ICMP_SLE: 
        }
        return ConstantExpr.getICmp(Predicate2, C1, C2, OnlyIfReduced);
    }

    public static Constant getICmp(char pred, Constant LHS, Constant RHS) {
        return ConstantExpr.getICmp(pred, LHS, RHS, false);
    }

    public static Constant getICmp(char pred, Constant LHS, Constant RHS, boolean OnlyIfReduced) {
        assert (LHS.getType() == RHS.getType());
        assert (Unsigned.$ushort2int((char)pred) >= CmpInst.Predicate.FIRST_ICMP_PREDICATE.getValue() && Unsigned.$ushort2int((char)pred) <= CmpInst.Predicate.LAST_ICMP_PREDICATE.getValue()) : "Invalid ICmp Predicate";
        Constant FC = ConstantFoldLlvmStatics.ConstantFoldCompareInstruction(pred, LHS, RHS);
        if (FC != null) {
            return FC;
        }
        if (OnlyIfReduced) {
            return null;
        }
        Object[] ArgVec = new Constant[]{LHS, RHS};
        ConstantExprKeyType Key = new ConstantExprKeyType(51, (ArrayRef<Constant>)new ArrayRef(ArgVec, true), pred);
        Type ResultTy = Type.getInt1Ty(LHS.getContext());
        VectorType VT = IrRTTI.dyn_cast_VectorType(LHS.getType());
        if (VT != null) {
            ResultTy = VectorType.get(ResultTy, VT.getNumElements());
        }
        LLVMContextImpl pImpl = LHS.getType().getContext().pImpl;
        return pImpl.ExprConstants.getOrCreate(ResultTy, new ConstantExprKeyType(Key));
    }

    public static Constant getFCmp(char pred, Constant LHS, Constant RHS) {
        return ConstantExpr.getFCmp(pred, LHS, RHS, false);
    }

    public static Constant getFCmp(char pred, Constant LHS, Constant RHS, boolean OnlyIfReduced) {
        assert (LHS.getType() == RHS.getType());
        assert (Unsigned.$ushort2int((char)pred) <= CmpInst.Predicate.LAST_FCMP_PREDICATE.getValue()) : "Invalid FCmp Predicate";
        Constant FC = ConstantFoldLlvmStatics.ConstantFoldCompareInstruction(pred, LHS, RHS);
        if (FC != null) {
            return FC;
        }
        if (OnlyIfReduced) {
            return null;
        }
        Object[] ArgVec = new Constant[]{LHS, RHS};
        ConstantExprKeyType Key = new ConstantExprKeyType(52, (ArrayRef<Constant>)new ArrayRef(ArgVec, true), pred);
        Type ResultTy = Type.getInt1Ty(LHS.getContext());
        VectorType VT = IrRTTI.dyn_cast_VectorType(LHS.getType());
        if (VT != null) {
            ResultTy = VectorType.get(ResultTy, VT.getNumElements());
        }
        LLVMContextImpl pImpl = LHS.getType().getContext().pImpl;
        return pImpl.ExprConstants.getOrCreate(ResultTy, new ConstantExprKeyType(Key));
    }

    public static Constant getGetElementPtr_Type$P_Constant$P_ArrayRef$Constant$P_bool_Type$P(Type Ty, Constant C2, ArrayRef<Constant> IdxList) {
        return ConstantExpr.getGetElementPtr_Type$P_Constant$P_ArrayRef$Constant$P_bool_Type$P(Ty, C2, IdxList, false, null);
    }

    public static Constant getGetElementPtr_Type$P_Constant$P_ArrayRef$Constant$P_bool_Type$P(Type Ty, Constant C2, ArrayRef<Constant> IdxList, boolean InBounds) {
        return ConstantExpr.getGetElementPtr_Type$P_Constant$P_ArrayRef$Constant$P_bool_Type$P(Ty, C2, IdxList, InBounds, null);
    }

    public static Constant getGetElementPtr_Type$P_Constant$P_ArrayRef$Constant$P_bool_Type$P(Type Ty, Constant C2, ArrayRef<Constant> IdxList, boolean InBounds, Type OnlyIfReducedTy) {
        return ConstantExpr.getGetElementPtr_Type$P_Constant$P_ArrayRef$Value$P_bool_Type$P(Ty, C2, (ArrayRef<Value>)llvm.makeArrayRef((type.ptr)IdxList.data(), (int)IdxList.size(), (boolean)true), InBounds, OnlyIfReducedTy);
    }

    public static Constant getGetElementPtr(Type Ty, Constant C2, Constant Idx) {
        return ConstantExpr.getGetElementPtr(Ty, C2, Idx, false, null);
    }

    public static Constant getGetElementPtr(Type Ty, Constant C2, Constant Idx, boolean InBounds) {
        return ConstantExpr.getGetElementPtr(Ty, C2, Idx, InBounds, null);
    }

    public static Constant getGetElementPtr(Type Ty, Constant C2, Constant Idx, boolean InBounds, Type OnlyIfReducedTy) {
        return ConstantExpr.getGetElementPtr_Type$P_Constant$P_ArrayRef$Value$P_bool_Type$P(Ty, C2, (ArrayRef<Value>)new ArrayRef((Object)IrRTTI.cast_Value(Idx), true), InBounds, OnlyIfReducedTy);
    }

    public static Constant getGetElementPtr_Type$P_Constant$P_ArrayRef$Value$P_bool_Type$P(Type Ty, Constant C2, ArrayRef<Value> Idxs) {
        return ConstantExpr.getGetElementPtr_Type$P_Constant$P_ArrayRef$Value$P_bool_Type$P(Ty, C2, Idxs, false, null);
    }

    public static Constant getGetElementPtr_Type$P_Constant$P_ArrayRef$Value$P_bool_Type$P(Type Ty, Constant C2, ArrayRef<Value> Idxs, boolean InBounds) {
        return ConstantExpr.getGetElementPtr_Type$P_Constant$P_ArrayRef$Value$P_bool_Type$P(Ty, C2, Idxs, InBounds, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Constant getGetElementPtr_Type$P_Constant$P_ArrayRef$Value$P_bool_Type$P(Type Ty, Constant C2, ArrayRef<Value> Idxs, boolean InBounds, Type OnlyIfReducedTy) {
        std.vector ArgVec = null;
        try {
            if (Ty == null) {
                Ty = IrRTTI.cast_PointerType(C2.getType().getScalarType()).getElementType();
            } else assert (Ty == IrRTTI.cast_PointerType(C2.getType().getScalarType()).getContainedType(0));
            Constant FC = ConstantFoldLlvmStatics.ConstantFoldGetElementPtr_Type$P_Constant$P_bool_ArrayRef$Value$P(Ty, C2, InBounds, (ArrayRef<Value>)new ArrayRef(Idxs));
            if (FC != null) {
                Constant constant = FC;
                return constant;
            }
            Type DestTy = GetElementPtrInst.getIndexedType_Type$P_ArrayRef$Value$P(Ty, (ArrayRef<Value>)new ArrayRef(Idxs));
            assert (DestTy != null) : "GEP indices invalid!";
            int AS = C2.getType().getPointerAddressSpace();
            SequentialType ReqTy = DestTy.getPointerTo(AS);
            int NumVecElts = 0;
            if (C2.getType().isVectorTy()) {
                NumVecElts = C2.getType().getVectorNumElements();
            } else {
                for (Value Idx : Idxs) {
                    if (!Idx.getType().isVectorTy()) continue;
                    NumVecElts = Idx.getType().getVectorNumElements();
                }
            }
            if (NumVecElts != 0) {
                ReqTy = VectorType.get(ReqTy, NumVecElts);
            }
            if (OnlyIfReducedTy == ReqTy) {
                Iterator iterator2 = null;
                return iterator2;
            }
            ArgVec = new std.vector((Object)null);
            ArgVec.reserve(1 + Idxs.size());
            ArgVec.push_back_T$C$R((Object)C2);
            int e = Idxs.size();
            for (int i = 0; i != e; ++i) {
                assert (!((Value)Idxs.$at(i)).getType().isVectorTy() || ((Value)Idxs.$at(i)).getType().getVectorNumElements() == NumVecElts) : "getelementptr index type missmatch";
                Constant Idx = IrRTTI.cast_Constant((Value)Idxs.$at(i));
                if (NumVecElts != 0 && !((Value)Idxs.$at(i)).getType().isVectorTy()) {
                    Idx = ConstantVector.getSplat(NumVecElts, Idx);
                }
                ArgVec.push_back_T$C$R((Object)Idx);
            }
            ConstantExprKeyType Key = new ConstantExprKeyType(32, (ArrayRef<Constant>)new ArrayRef(ArgVec, true), Unsigned.$int2ushort((int)0), Unsigned.$int2ushort((int)(InBounds ? 1 : 0)), new ArrayRefUInt(llvm.None), Ty);
            LLVMContextImpl pImpl = C2.getContext().pImpl;
            ConstantExpr constantExpr = pImpl.ExprConstants.getOrCreate(ReqTy, new ConstantExprKeyType(Key));
            return constantExpr;
        }
        finally {
            if (ArgVec != null) {
                ArgVec.$destroy();
            }
        }
    }

    public static Constant getInBoundsGetElementPtr_Type$P_Constant$P_ArrayRef$Constant$P(Type Ty, Constant C2, ArrayRef<Constant> IdxList) {
        return ConstantExpr.getGetElementPtr_Type$P_Constant$P_ArrayRef$Constant$P_bool_Type$P(Ty, C2, (ArrayRef<Constant>)new ArrayRef(IdxList), true);
    }

    public static Constant getInBoundsGetElementPtr(Type Ty, Constant C2, Constant Idx) {
        return ConstantExpr.getGetElementPtr(Ty, C2, Idx, true);
    }

    public static Constant getInBoundsGetElementPtr_Type$P_Constant$P_ArrayRef$Value$P(Type Ty, Constant C2, ArrayRef<Value> IdxList) {
        return ConstantExpr.getGetElementPtr_Type$P_Constant$P_ArrayRef$Value$P_bool_Type$P(Ty, C2, (ArrayRef<Value>)new ArrayRef(IdxList), true);
    }

    public static Constant getExtractElement(Constant Val, Constant Idx) {
        return ConstantExpr.getExtractElement(Val, Idx, null);
    }

    public static Constant getExtractElement(Constant Val, Constant Idx, Type OnlyIfReducedTy) {
        assert (Val.getType().isVectorTy()) : "Tried to create extractelement operation on non-vector type!";
        assert (Idx.getType().isIntegerTy()) : "Extractelement index must be an integer type!";
        Constant FC = ConstantFoldLlvmStatics.ConstantFoldExtractElementInstruction(Val, Idx);
        if (FC != null) {
            return FC;
        }
        Type ReqTy = Val.getType().getVectorElementType();
        if (OnlyIfReducedTy == ReqTy) {
            return null;
        }
        Object[] ArgVec = new Constant[]{Val, Idx};
        ConstantExprKeyType Key = new ConstantExprKeyType(59, (ArrayRef<Constant>)new ArrayRef(ArgVec, true));
        LLVMContextImpl pImpl = Val.getContext().pImpl;
        return pImpl.ExprConstants.getOrCreate(ReqTy, new ConstantExprKeyType(Key));
    }

    public static Constant getInsertElement(Constant Val, Constant Elt, Constant Idx) {
        return ConstantExpr.getInsertElement(Val, Elt, Idx, null);
    }

    public static Constant getInsertElement(Constant Val, Constant Elt, Constant Idx, Type OnlyIfReducedTy) {
        assert (Val.getType().isVectorTy()) : "Tried to create insertelement operation on non-vector type!";
        assert (Elt.getType() == Val.getType().getVectorElementType()) : "Insertelement types must match!";
        assert (Idx.getType().isIntegerTy()) : "Insertelement index must be i32 type!";
        Constant FC = ConstantFoldLlvmStatics.ConstantFoldInsertElementInstruction(Val, Elt, Idx);
        if (FC != null) {
            return FC;
        }
        if (OnlyIfReducedTy == Val.getType()) {
            return null;
        }
        Object[] ArgVec = new Constant[]{Val, Elt, Idx};
        ConstantExprKeyType Key = new ConstantExprKeyType(60, (ArrayRef<Constant>)new ArrayRef(ArgVec, true));
        LLVMContextImpl pImpl = Val.getContext().pImpl;
        return pImpl.ExprConstants.getOrCreate(Val.getType(), new ConstantExprKeyType(Key));
    }

    public static Constant getShuffleVector(Constant V1, Constant V2, Constant Mask) {
        return ConstantExpr.getShuffleVector(V1, V2, Mask, null);
    }

    public static Constant getShuffleVector(Constant V1, Constant V2, Constant Mask, Type OnlyIfReducedTy) {
        assert (ShuffleVectorInst.isValidOperands(V1, V2, Mask)) : "Invalid shuffle vector constant expr operands!";
        Constant FC = ConstantFoldLlvmStatics.ConstantFoldShuffleVectorInstruction(V1, V2, Mask);
        if (FC != null) {
            return FC;
        }
        int NElts = Mask.getType().getVectorNumElements();
        Type EltTy = V1.getType().getVectorElementType();
        VectorType ShufTy = VectorType.get(EltTy, NElts);
        if (OnlyIfReducedTy == ShufTy) {
            return null;
        }
        Object[] ArgVec = new Constant[]{V1, V2, Mask};
        ConstantExprKeyType Key = new ConstantExprKeyType(61, (ArrayRef<Constant>)new ArrayRef(ArgVec, true));
        LLVMContextImpl pImpl = ShufTy.getContext().pImpl;
        return pImpl.ExprConstants.getOrCreate(ShufTy, new ConstantExprKeyType(Key));
    }

    public static Constant getExtractValue(Constant Agg, ArrayRefUInt Idxs) {
        return ConstantExpr.getExtractValue(Agg, Idxs, null);
    }

    public static Constant getExtractValue(Constant Agg, ArrayRefUInt Idxs, Type OnlyIfReducedTy) {
        assert (Agg.getType().isFirstClassType()) : "Tried to create extractelement operation on non-first-class type!";
        Type ReqTy = ExtractValueInst.getIndexedType(Agg.getType(), new ArrayRefUInt(Idxs));
        assert (ReqTy != null) : "extractvalue indices invalid!";
        assert (Agg.getType().isFirstClassType()) : "Non-first-class type for constant extractvalue expression";
        Constant FC = ConstantFoldLlvmStatics.ConstantFoldExtractValueInstruction(Agg, new ArrayRefUInt(Idxs));
        if (FC != null) {
            return FC;
        }
        if (OnlyIfReducedTy == ReqTy) {
            return null;
        }
        Object[] ArgVec = new Constant[]{Agg};
        ConstantExprKeyType Key = new ConstantExprKeyType(62, (ArrayRef<Constant>)new ArrayRef(ArgVec, true), Unsigned.$int2ushort((int)0), Unsigned.$int2ushort((int)0), new ArrayRefUInt(Idxs));
        LLVMContextImpl pImpl = Agg.getContext().pImpl;
        return pImpl.ExprConstants.getOrCreate(ReqTy, new ConstantExprKeyType(Key));
    }

    public static Constant getInsertValue(Constant Agg, Constant Val, ArrayRefUInt Idxs) {
        return ConstantExpr.getInsertValue(Agg, Val, Idxs, null);
    }

    public static Constant getInsertValue(Constant Agg, Constant Val, ArrayRefUInt Idxs, Type OnlyIfReducedTy) {
        assert (Agg.getType().isFirstClassType()) : "Non-first-class type for constant insertvalue expression";
        assert (ExtractValueInst.getIndexedType(Agg.getType(), new ArrayRefUInt(Idxs)) == Val.getType()) : "insertvalue indices invalid!";
        Type ReqTy = Val.getType();
        Constant FC = ConstantFoldLlvmStatics.ConstantFoldInsertValueInstruction(Agg, Val, new ArrayRefUInt(Idxs));
        if (FC != null) {
            return FC;
        }
        if (OnlyIfReducedTy == ReqTy) {
            return null;
        }
        Object[] ArgVec = new Constant[]{Agg, Val};
        ConstantExprKeyType Key = new ConstantExprKeyType(63, (ArrayRef<Constant>)new ArrayRef(ArgVec, true), Unsigned.$int2ushort((int)0), Unsigned.$int2ushort((int)0), new ArrayRefUInt(Idxs));
        LLVMContextImpl pImpl = Agg.getContext().pImpl;
        return pImpl.ExprConstants.getOrCreate(ReqTy, new ConstantExprKeyType(Key));
    }

    public int getOpcode() {
        return Unsigned.$ushort2uint((char)this.getSubclassDataFromValue());
    }

    public int getPredicate() {
        return Unsigned.$ushort2uint((char)IrRTTI.cast_CompareConstantExpr((ConstantExpr)this).predicate);
    }

    public ArrayRefUInt getIndices() {
        ExtractValueConstantExpr EVCE = IrRTTI.dyn_cast_ExtractValueConstantExpr(this);
        if (EVCE != null) {
            return new ArrayRefUInt((SmallVectorImplUInt)EVCE.Indices);
        }
        return new ArrayRefUInt((SmallVectorImplUInt)IrRTTI.cast_InsertValueConstantExpr((ConstantExpr)this).Indices);
    }

    public char.ptr getOpcodeName() {
        return Instruction.getOpcodeName(this.getOpcode());
    }

    public Constant getWithOperandReplaced(int OpNo, Constant Op) {
        assert (Op.getType() == this.getOperand_Constant(OpNo).getType()) : "Replacing operand with value of different type!";
        if (this.getOperand_Constant(OpNo) == Op) {
            return this;
        }
        SmallVector NewOps = new SmallVector(8, (Object)null);
        int e = this.getNumOperands();
        for (int i = 0; i != e; ++i) {
            NewOps.push_back((Object)(i == OpNo ? Op : this.getOperand_Constant(i)));
        }
        return this.getWithOperands((ArrayRef<Constant>)new ArrayRef((SmallVectorImplCommon)NewOps, true));
    }

    public Constant getWithOperands(ArrayRef<Constant> Ops) {
        return this.getWithOperands((ArrayRef<Constant>)new ArrayRef(Ops), this.getType());
    }

    public Constant getWithOperands(ArrayRef<Constant> Ops, Type Ty) {
        return this.getWithOperands(Ops, Ty, false, null);
    }

    public Constant getWithOperands(ArrayRef<Constant> Ops, Type Ty, boolean OnlyIfReduced) {
        return this.getWithOperands(Ops, Ty, OnlyIfReduced, null);
    }

    public Constant getWithOperands(ArrayRef<Constant> Ops, Type Ty, boolean OnlyIfReduced, Type SrcTy) {
        assert (Ops.size() == this.getNumOperands()) : "Operand count mismatch!";
        if (Ty == this.getType() && std.equal((type.iterator)Ops.begin(), (type.iterator)Ops.end(), this.op_begin$Const())) {
            return this;
        }
        Type OnlyIfReducedTy = OnlyIfReduced ? Ty : null;
        switch (this.getOpcode()) {
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                return ConstantExpr.getCast(this.getOpcode(), (Constant)Ops.$at(0), Ty, OnlyIfReduced);
            }
            case 55: {
                return ConstantExpr.getSelect((Constant)Ops.$at(0), (Constant)Ops.$at(1), (Constant)Ops.$at(2), OnlyIfReducedTy);
            }
            case 60: {
                return ConstantExpr.getInsertElement((Constant)Ops.$at(0), (Constant)Ops.$at(1), (Constant)Ops.$at(2), OnlyIfReducedTy);
            }
            case 59: {
                return ConstantExpr.getExtractElement((Constant)Ops.$at(0), (Constant)Ops.$at(1), OnlyIfReducedTy);
            }
            case 63: {
                return ConstantExpr.getInsertValue((Constant)Ops.$at(0), (Constant)Ops.$at(1), this.getIndices(), OnlyIfReducedTy);
            }
            case 62: {
                return ConstantExpr.getExtractValue((Constant)Ops.$at(0), this.getIndices(), OnlyIfReducedTy);
            }
            case 61: {
                return ConstantExpr.getShuffleVector((Constant)Ops.$at(0), (Constant)Ops.$at(1), (Constant)Ops.$at(2), OnlyIfReducedTy);
            }
            case 32: {
                GEPOperator GEPO = IrRTTI.cast_GEPOperator(this);
                assert (SrcTy != null || ((Constant)Ops.$at(0)).getType() == this.getOperand_Constant(0).getType());
                return ConstantExpr.getGetElementPtr_Type$P_Constant$P_ArrayRef$Constant$P_bool_Type$P(SrcTy != null ? SrcTy : GEPO.getSourceElementType(), (Constant)Ops.$at(0), (ArrayRef<Constant>)Ops.slice(1), GEPO.isInBounds(), OnlyIfReducedTy);
            }
            case 51: 
            case 52: {
                return ConstantExpr.getCompare(Unsigned.$uint2ushort((int)this.getPredicate()), (Constant)Ops.$at(0), (Constant)Ops.$at(1), OnlyIfReducedTy != null);
            }
        }
        assert (this.getNumOperands() == 2) : "Must be binary operator?";
        return ConstantExpr.get(this.getOpcode(), (Constant)Ops.$at(0), (Constant)Ops.$at(1), Unsigned.$uchar2uint((byte)Unsigned.$7bits_uchar2uchar((byte)this.SubclassOptionalData)), OnlyIfReducedTy);
    }

    public Instruction getAsInstruction() {
        SmallVector ValueOperands = new SmallVector(JavaDifferentiators.JD$T.INSTANCE, 4, this.op_begin(), this.op_end(), (Object)null, a -> a.$Value$P());
        ArrayRef Ops = new ArrayRef((SmallVectorImplCommon)ValueOperands, true);
        switch (this.getOpcode()) {
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                return CastInst.Create(this.getOpcode(), (Value)Ops.$at(0), this.getType());
            }
            case 55: {
                return SelectInst.Create((Value)Ops.$at(0), (Value)Ops.$at(1), (Value)Ops.$at(2));
            }
            case 60: {
                return InsertElementInst.Create((Value)Ops.$at(0), (Value)Ops.$at(1), (Value)Ops.$at(2));
            }
            case 59: {
                return ExtractElementInst.Create((Value)Ops.$at(0), (Value)Ops.$at(1));
            }
            case 63: {
                return InsertValueInst.Create_Value$P_ArrayRefUInt_Twine$C_Instruction$P((Value)Ops.$at(0), (Value)Ops.$at(1), this.getIndices());
            }
            case 62: {
                return ExtractValueInst.Create_Value1((Value)Ops.$at(0), this.getIndices());
            }
            case 61: {
                return ShuffleVectorInst.$new_ShuffleVectorInst(New$Mem -> new ShuffleVectorInst((Value)Ops.$at(0), (Value)Ops.$at(1), (Value)Ops.$at(2)));
            }
            case 32: {
                GEPOperator GO = IrRTTI.cast_GEPOperator(this);
                if (GO.isInBounds()) {
                    return GetElementPtrInst.CreateInBounds2(GO.getSourceElementType(), (Value)Ops.$at(0), (ArrayRef<Value>)Ops.slice(1));
                }
                return GetElementPtrInst.Create1(GO.getSourceElementType(), (Value)Ops.$at(0), (ArrayRef<Value>)Ops.slice(1));
            }
            case 51: 
            case 52: {
                return CmpInst.Create(this.getOpcode(), CmpInst.Predicate.valueOf(this.getPredicate()), (Value)Ops.$at(0), (Value)Ops.$at(1));
            }
        }
        assert (this.getNumOperands() == 2) : "Must be binary operator?";
        BinaryOperator BO = BinaryOperator.Create(this.getOpcode(), (Value)Ops.$at(0), (Value)Ops.$at(1));
        if (IrRTTI.isa_OverflowingBinaryOperator(BO)) {
            BO.setHasNoUnsignedWrap((Unsigned.$uchar2int((byte)Unsigned.$7bits_uchar2uchar((byte)this.SubclassOptionalData)) & 1) != 0);
            BO.setHasNoSignedWrap((Unsigned.$uchar2int((byte)Unsigned.$7bits_uchar2uchar((byte)this.SubclassOptionalData)) & 2) != 0);
        }
        if (IrRTTI.isa_PossiblyExactOperator(BO)) {
            BO.setIsExact((Unsigned.$uchar2int((byte)Unsigned.$7bits_uchar2uchar((byte)this.SubclassOptionalData)) & 1) != 0);
        }
        return BO;
    }

    public static boolean classof(Value V) {
        return V.getValueID() == Value.ValueTy.ConstantExprVal.getValue();
    }

    @Override
    protected void setValueSubclassData(char D2) {
        super.setValueSubclassData(D2);
    }

    @Override
    public void $destroy() {
        super.$destroy();
    }

    public static Constant getCompare(int Predicate2, Constant C1, Constant C2) {
        return ConstantExpr.getCompare(Predicate2, C1, C2, false);
    }

    public static Constant getCompare(int Predicate2, Constant C1, Constant C2, boolean OnlyIfReduced) {
        return ConstantExpr.getCompare(Unsigned.$uint2ushort((int)Predicate2), C1, C2, OnlyIfReduced);
    }

    @Override
    public String toString() {
        return "" + super.toString();
    }
}

