/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativeMoveable;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.StringMapEntry;
import org.llvm.ir.impl.AsmWriterStatics;
import org.llvm.ir.impl.PrefixType;
import org.llvm.ir.java.delete;
import org.llvm.support.llvm;
import org.llvm.support.raw_ostream;

public class Comdat
implements NativeCloneable<Comdat>,
NativeMoveable<Comdat> {
    StringMapEntry<Comdat> Name;
    SelectionKind SK;

    Comdat(JavaDifferentiators.JD.Move _dparam, Comdat C2) {
        this.Name = C2.Name;
        this.SK = C2.SK;
    }

    public SelectionKind getSelectionKind() {
        return this.SK;
    }

    public void setSelectionKind(SelectionKind Val) {
        this.SK = Val;
    }

    public StringRef getName() {
        return this.Name.first();
    }

    public void print(raw_ostream ROS) {
        this.print(ROS, false);
    }

    public void print(raw_ostream ROS, boolean $Prm1) {
        AsmWriterStatics.PrintLLVMName(ROS, this.getName(), PrefixType.ComdatPrefix);
        ROS.$out(" = comdat ");
        switch (this.getSelectionKind()) {
            case Any: {
                ROS.$out("any");
                break;
            }
            case ExactMatch: {
                ROS.$out("exactmatch");
                break;
            }
            case Largest: {
                ROS.$out("largest");
                break;
            }
            case NoDuplicates: {
                ROS.$out("noduplicates");
                break;
            }
            case SameSize: {
                ROS.$out("samesize");
            }
        }
        ROS.$out_char((byte)10);
    }

    public void dump() {
        this.print(llvm.dbgs(), true);
    }

    Comdat() {
        this.Name = null;
        this.SK = SelectionKind.Any;
    }

    private delete Comdat(Comdat $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    public Comdat clone() {
        assert (this.Name == null);
        assert (this.SK == SelectionKind.Any);
        return new Comdat();
    }

    public Comdat move() {
        return new Comdat(JavaDifferentiators.JD.Move.INSTANCE, this);
    }

    public String toString() {
        return "Name=" + this.Name + ", SK=" + (Object)((Object)this.SK);
    }

    public static final class SelectionKind
    extends Enum<SelectionKind>
    implements Native.NativeUIntEnum {
        public static final /* enum */ SelectionKind Any = new SelectionKind(0);
        public static final /* enum */ SelectionKind ExactMatch = new SelectionKind(Any.getValue() + 1);
        public static final /* enum */ SelectionKind Largest = new SelectionKind(ExactMatch.getValue() + 1);
        public static final /* enum */ SelectionKind NoDuplicates = new SelectionKind(Largest.getValue() + 1);
        public static final /* enum */ SelectionKind SameSize = new SelectionKind(NoDuplicates.getValue() + 1);
        private final int value;
        private static final /* synthetic */ SelectionKind[] $VALUES;

        public static SelectionKind[] values() {
            return (SelectionKind[])$VALUES.clone();
        }

        public static SelectionKind valueOf(String name) {
            return Enum.valueOf(SelectionKind.class, name);
        }

        public static SelectionKind valueOf(int val) {
            SelectionKind out;
            SelectionKind selectionKind = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private SelectionKind(int val) {
            this.value = val;
        }

        public final int getValue() {
            return this.value;
        }

        static {
            $VALUES = new SelectionKind[]{Any, ExactMatch, Largest, NoDuplicates, SameSize};
        }

        private static final class Values {
            private static final SelectionKind[] VALUES;
            private static final SelectionKind[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (SelectionKind kind : SelectionKind.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new SelectionKind[min < 0 ? 1 - min : 0];
                VALUES = new SelectionKind[max >= 0 ? 1 + max : 0];
                for (SelectionKind kind : SelectionKind.values()) {
                    if (kind.value < 0) {
                        if (_VALUES[-kind.value] != null) continue;
                        Values._VALUES[-((SelectionKind)kind).value] = kind;
                        continue;
                    }
                    if (VALUES[kind.value] != null) continue;
                    Values.VALUES[((SelectionKind)kind).value] = kind;
                }
            }
        }
    }
}

