/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.clank.support.Destructors;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.llvm.adt.Twine;
import org.llvm.ir.AddrSpaceCastInst;
import org.llvm.ir.BasicBlock;
import org.llvm.ir.BitCastInst;
import org.llvm.ir.CastInst$isEliminableCastPair$$;
import org.llvm.ir.DataLayout;
import org.llvm.ir.FPExtInst;
import org.llvm.ir.FPToSIInst;
import org.llvm.ir.FPToUIInst;
import org.llvm.ir.FPTruncInst;
import org.llvm.ir.Instruction;
import org.llvm.ir.IntToPtrInst;
import org.llvm.ir.IntegerType;
import org.llvm.ir.PointerType;
import org.llvm.ir.PtrToIntInst;
import org.llvm.ir.SExtInst;
import org.llvm.ir.SIToFPInst;
import org.llvm.ir.TruncInst;
import org.llvm.ir.Type;
import org.llvm.ir.UIToFPInst;
import org.llvm.ir.UnaryInstruction;
import org.llvm.ir.Value;
import org.llvm.ir.VectorType;
import org.llvm.ir.ZExtInst;
import org.llvm.ir.java.IrRTTI;
import org.llvm.support.llvm_unreachable;

public class CastInst
extends UnaryInstruction
implements Destructors.ClassWithDestructor {
    @Override
    protected void anchor() {
    }

    protected CastInst(Type Ty, int iType, Value S) {
        this(Ty, iType, S, new Twine(NativePointer.$EMPTY), (Instruction)null);
    }

    protected CastInst(Type Ty, int iType, Value S, Twine NameStr) {
        this(Ty, iType, S, NameStr, (Instruction)null);
    }

    protected CastInst(Type Ty, int iType, Value S, Twine NameStr, Instruction InsertBefore) {
        super(Ty, iType, S, InsertBefore);
        this.setName(NameStr);
    }

    protected CastInst(Type Ty, int iType, Value S, Twine NameStr, BasicBlock InsertAtEnd) {
        super(Ty, iType, S, InsertAtEnd);
        this.setName(NameStr);
    }

    public static CastInst Create(int op, Value S, Type Ty) {
        return CastInst.Create(op, S, Ty, new Twine(NativePointer.$EMPTY), (Instruction)null);
    }

    public static CastInst Create(int op, Value S, Type Ty, Twine Name) {
        return CastInst.Create(op, S, Ty, Name, (Instruction)null);
    }

    public static CastInst Create(int op, Value S, Type Ty, Twine Name, Instruction InsertBefore) {
        assert (CastInst.castIsValid(op, S, Ty)) : "Invalid cast!";
        switch (op) {
            case 36: {
                return (CastInst)UnaryInstruction.$new_UnaryInstruction(New$Mem -> new TruncInst(S, Ty, Name, InsertBefore));
            }
            case 37: {
                return (CastInst)UnaryInstruction.$new_UnaryInstruction(New$Mem -> new ZExtInst(S, Ty, Name, InsertBefore));
            }
            case 38: {
                return (CastInst)UnaryInstruction.$new_UnaryInstruction(New$Mem -> new SExtInst(S, Ty, Name, InsertBefore));
            }
            case 43: {
                return (CastInst)UnaryInstruction.$new_UnaryInstruction(New$Mem -> new FPTruncInst(S, Ty, Name, InsertBefore));
            }
            case 44: {
                return (CastInst)UnaryInstruction.$new_UnaryInstruction(New$Mem -> new FPExtInst(S, Ty, Name, InsertBefore));
            }
            case 41: {
                return (CastInst)UnaryInstruction.$new_UnaryInstruction(New$Mem -> new UIToFPInst(S, Ty, Name, InsertBefore));
            }
            case 42: {
                return (CastInst)UnaryInstruction.$new_UnaryInstruction(New$Mem -> new SIToFPInst(S, Ty, Name, InsertBefore));
            }
            case 39: {
                return (CastInst)UnaryInstruction.$new_UnaryInstruction(New$Mem -> new FPToUIInst(S, Ty, Name, InsertBefore));
            }
            case 40: {
                return (CastInst)UnaryInstruction.$new_UnaryInstruction(New$Mem -> new FPToSIInst(S, Ty, Name, InsertBefore));
            }
            case 45: {
                return (CastInst)UnaryInstruction.$new_UnaryInstruction(New$Mem -> new PtrToIntInst(S, Ty, Name, InsertBefore));
            }
            case 46: {
                return (CastInst)UnaryInstruction.$new_UnaryInstruction(New$Mem -> new IntToPtrInst(S, Ty, Name, InsertBefore));
            }
            case 47: {
                return (CastInst)UnaryInstruction.$new_UnaryInstruction(New$Mem -> new BitCastInst(S, Ty, Name, InsertBefore));
            }
            case 48: {
                return (CastInst)UnaryInstruction.$new_UnaryInstruction(New$Mem -> new AddrSpaceCastInst(S, Ty, Name, InsertBefore));
            }
        }
        throw new llvm_unreachable("Invalid opcode provided");
    }

    public static CastInst Create(int op, Value S, Type Ty, Twine Name, BasicBlock InsertAtEnd) {
        assert (CastInst.castIsValid(op, S, Ty)) : "Invalid cast!";
        switch (op) {
            case 36: {
                return (CastInst)UnaryInstruction.$new_UnaryInstruction(New$Mem -> new TruncInst(S, Ty, Name, InsertAtEnd));
            }
            case 37: {
                return (CastInst)UnaryInstruction.$new_UnaryInstruction(New$Mem -> new ZExtInst(S, Ty, Name, InsertAtEnd));
            }
            case 38: {
                return (CastInst)UnaryInstruction.$new_UnaryInstruction(New$Mem -> new SExtInst(S, Ty, Name, InsertAtEnd));
            }
            case 43: {
                return (CastInst)UnaryInstruction.$new_UnaryInstruction(New$Mem -> new FPTruncInst(S, Ty, Name, InsertAtEnd));
            }
            case 44: {
                return (CastInst)UnaryInstruction.$new_UnaryInstruction(New$Mem -> new FPExtInst(S, Ty, Name, InsertAtEnd));
            }
            case 41: {
                return (CastInst)UnaryInstruction.$new_UnaryInstruction(New$Mem -> new UIToFPInst(S, Ty, Name, InsertAtEnd));
            }
            case 42: {
                return (CastInst)UnaryInstruction.$new_UnaryInstruction(New$Mem -> new SIToFPInst(S, Ty, Name, InsertAtEnd));
            }
            case 39: {
                return (CastInst)UnaryInstruction.$new_UnaryInstruction(New$Mem -> new FPToUIInst(S, Ty, Name, InsertAtEnd));
            }
            case 40: {
                return (CastInst)UnaryInstruction.$new_UnaryInstruction(New$Mem -> new FPToSIInst(S, Ty, Name, InsertAtEnd));
            }
            case 45: {
                return (CastInst)UnaryInstruction.$new_UnaryInstruction(New$Mem -> new PtrToIntInst(S, Ty, Name, InsertAtEnd));
            }
            case 46: {
                return (CastInst)UnaryInstruction.$new_UnaryInstruction(New$Mem -> new IntToPtrInst(S, Ty, Name, InsertAtEnd));
            }
            case 47: {
                return (CastInst)UnaryInstruction.$new_UnaryInstruction(New$Mem -> new BitCastInst(S, Ty, Name, InsertAtEnd));
            }
            case 48: {
                return (CastInst)UnaryInstruction.$new_UnaryInstruction(New$Mem -> new AddrSpaceCastInst(S, Ty, Name, InsertAtEnd));
            }
        }
        throw new llvm_unreachable("Invalid opcode provided");
    }

    public static CastInst CreateZExtOrBitCast(Value S, Type Ty) {
        return CastInst.CreateZExtOrBitCast(S, Ty, new Twine(NativePointer.$EMPTY), (Instruction)null);
    }

    public static CastInst CreateZExtOrBitCast(Value S, Type Ty, Twine Name) {
        return CastInst.CreateZExtOrBitCast(S, Ty, Name, (Instruction)null);
    }

    public static CastInst CreateZExtOrBitCast(Value S, Type Ty, Twine Name, Instruction InsertBefore) {
        if (S.getType().getScalarSizeInBits() == Ty.getScalarSizeInBits()) {
            return CastInst.Create(47, S, Ty, Name, InsertBefore);
        }
        return CastInst.Create(37, S, Ty, Name, InsertBefore);
    }

    public static CastInst CreateZExtOrBitCast(Value S, Type Ty, Twine Name, BasicBlock InsertAtEnd) {
        if (S.getType().getScalarSizeInBits() == Ty.getScalarSizeInBits()) {
            return CastInst.Create(47, S, Ty, Name, InsertAtEnd);
        }
        return CastInst.Create(37, S, Ty, Name, InsertAtEnd);
    }

    public static CastInst CreateSExtOrBitCast(Value S, Type Ty) {
        return CastInst.CreateSExtOrBitCast(S, Ty, new Twine(NativePointer.$EMPTY), (Instruction)null);
    }

    public static CastInst CreateSExtOrBitCast(Value S, Type Ty, Twine Name) {
        return CastInst.CreateSExtOrBitCast(S, Ty, Name, (Instruction)null);
    }

    public static CastInst CreateSExtOrBitCast(Value S, Type Ty, Twine Name, Instruction InsertBefore) {
        if (S.getType().getScalarSizeInBits() == Ty.getScalarSizeInBits()) {
            return CastInst.Create(47, S, Ty, Name, InsertBefore);
        }
        return CastInst.Create(38, S, Ty, Name, InsertBefore);
    }

    public static CastInst CreateSExtOrBitCast(Value S, Type Ty, Twine Name, BasicBlock InsertAtEnd) {
        if (S.getType().getScalarSizeInBits() == Ty.getScalarSizeInBits()) {
            return CastInst.Create(47, S, Ty, Name, InsertAtEnd);
        }
        return CastInst.Create(38, S, Ty, Name, InsertAtEnd);
    }

    public static CastInst CreatePointerCast(Value S, Type Ty, Twine Name, BasicBlock InsertAtEnd) {
        assert (S.getType().isPtrOrPtrVectorTy()) : "Invalid cast";
        assert (Ty.isIntOrIntVectorTy() || Ty.isPtrOrPtrVectorTy()) : "Invalid cast";
        assert (Ty.isVectorTy() == S.getType().isVectorTy()) : "Invalid cast";
        assert (!Ty.isVectorTy() || Ty.getVectorNumElements() == S.getType().getVectorNumElements()) : "Invalid cast";
        if (Ty.isIntOrIntVectorTy()) {
            return CastInst.Create(45, S, Ty, Name, InsertAtEnd);
        }
        return CastInst.CreatePointerBitCastOrAddrSpaceCast(S, Ty, Name, InsertAtEnd);
    }

    public static CastInst CreatePointerCast(Value S, Type Ty) {
        return CastInst.CreatePointerCast(S, Ty, new Twine(NativePointer.$EMPTY), (Instruction)null);
    }

    public static CastInst CreatePointerCast(Value S, Type Ty, Twine Name) {
        return CastInst.CreatePointerCast(S, Ty, Name, (Instruction)null);
    }

    public static CastInst CreatePointerCast(Value S, Type Ty, Twine Name, Instruction InsertBefore) {
        assert (S.getType().isPtrOrPtrVectorTy()) : "Invalid cast";
        assert (Ty.isIntOrIntVectorTy() || Ty.isPtrOrPtrVectorTy()) : "Invalid cast";
        assert (Ty.isVectorTy() == S.getType().isVectorTy()) : "Invalid cast";
        assert (!Ty.isVectorTy() || Ty.getVectorNumElements() == S.getType().getVectorNumElements()) : "Invalid cast";
        if (Ty.isIntOrIntVectorTy()) {
            return CastInst.Create(45, S, Ty, Name, InsertBefore);
        }
        return CastInst.CreatePointerBitCastOrAddrSpaceCast(S, Ty, Name, InsertBefore);
    }

    public static CastInst CreatePointerBitCastOrAddrSpaceCast(Value S, Type Ty, Twine Name, BasicBlock InsertAtEnd) {
        assert (S.getType().isPtrOrPtrVectorTy()) : "Invalid cast";
        assert (Ty.isPtrOrPtrVectorTy()) : "Invalid cast";
        if (S.getType().getPointerAddressSpace() != Ty.getPointerAddressSpace()) {
            return CastInst.Create(48, S, Ty, Name, InsertAtEnd);
        }
        return CastInst.Create(47, S, Ty, Name, InsertAtEnd);
    }

    public static CastInst CreatePointerBitCastOrAddrSpaceCast(Value S, Type Ty) {
        return CastInst.CreatePointerBitCastOrAddrSpaceCast(S, Ty, new Twine(NativePointer.$EMPTY), (Instruction)null);
    }

    public static CastInst CreatePointerBitCastOrAddrSpaceCast(Value S, Type Ty, Twine Name) {
        return CastInst.CreatePointerBitCastOrAddrSpaceCast(S, Ty, Name, (Instruction)null);
    }

    public static CastInst CreatePointerBitCastOrAddrSpaceCast(Value S, Type Ty, Twine Name, Instruction InsertBefore) {
        assert (S.getType().isPtrOrPtrVectorTy()) : "Invalid cast";
        assert (Ty.isPtrOrPtrVectorTy()) : "Invalid cast";
        if (S.getType().getPointerAddressSpace() != Ty.getPointerAddressSpace()) {
            return CastInst.Create(48, S, Ty, Name, InsertBefore);
        }
        return CastInst.Create(47, S, Ty, Name, InsertBefore);
    }

    public static CastInst CreateBitOrPointerCast(Value S, Type Ty) {
        return CastInst.CreateBitOrPointerCast(S, Ty, new Twine(NativePointer.$EMPTY), null);
    }

    public static CastInst CreateBitOrPointerCast(Value S, Type Ty, Twine Name) {
        return CastInst.CreateBitOrPointerCast(S, Ty, Name, null);
    }

    public static CastInst CreateBitOrPointerCast(Value S, Type Ty, Twine Name, Instruction InsertBefore) {
        if (S.getType().isPointerTy() && Ty.isIntegerTy()) {
            return CastInst.Create(45, S, Ty, Name, InsertBefore);
        }
        if (S.getType().isIntegerTy() && Ty.isPointerTy()) {
            return CastInst.Create(46, S, Ty, Name, InsertBefore);
        }
        return CastInst.Create(47, S, Ty, Name, InsertBefore);
    }

    public static CastInst CreateIntegerCast(Value C2, Type Ty, boolean isSigned) {
        return CastInst.CreateIntegerCast(C2, Ty, isSigned, new Twine(NativePointer.$EMPTY), (Instruction)null);
    }

    public static CastInst CreateIntegerCast(Value C2, Type Ty, boolean isSigned, Twine Name) {
        return CastInst.CreateIntegerCast(C2, Ty, isSigned, Name, (Instruction)null);
    }

    public static CastInst CreateIntegerCast(Value C2, Type Ty, boolean isSigned, Twine Name, Instruction InsertBefore) {
        int DstBits;
        assert (C2.getType().isIntOrIntVectorTy() && Ty.isIntOrIntVectorTy()) : "Invalid integer cast";
        int SrcBits = C2.getType().getScalarSizeInBits();
        int opcode = SrcBits == (DstBits = Ty.getScalarSizeInBits()) ? 47 : (Unsigned.$greater_uint((int)SrcBits, (int)DstBits) ? 36 : (isSigned ? 38 : 37));
        return CastInst.Create(opcode, C2, Ty, Name, InsertBefore);
    }

    public static CastInst CreateIntegerCast(Value C2, Type Ty, boolean isSigned, Twine Name, BasicBlock InsertAtEnd) {
        int DstBits;
        assert (C2.getType().isIntOrIntVectorTy() && Ty.isIntOrIntVectorTy()) : "Invalid cast";
        int SrcBits = C2.getType().getScalarSizeInBits();
        int opcode = SrcBits == (DstBits = Ty.getScalarSizeInBits()) ? 47 : (Unsigned.$greater_uint((int)SrcBits, (int)DstBits) ? 36 : (isSigned ? 38 : 37));
        return CastInst.Create(opcode, C2, Ty, Name, InsertAtEnd);
    }

    public static CastInst CreateFPCast(Value C2, Type Ty) {
        return CastInst.CreateFPCast(C2, Ty, new Twine(NativePointer.$EMPTY), (Instruction)null);
    }

    public static CastInst CreateFPCast(Value C2, Type Ty, Twine Name) {
        return CastInst.CreateFPCast(C2, Ty, Name, (Instruction)null);
    }

    public static CastInst CreateFPCast(Value C2, Type Ty, Twine Name, Instruction InsertBefore) {
        int DstBits;
        assert (C2.getType().isFPOrFPVectorTy() && Ty.isFPOrFPVectorTy()) : "Invalid cast";
        int SrcBits = C2.getType().getScalarSizeInBits();
        int opcode = SrcBits == (DstBits = Ty.getScalarSizeInBits()) ? 47 : (Unsigned.$greater_uint((int)SrcBits, (int)DstBits) ? 43 : 44);
        return CastInst.Create(opcode, C2, Ty, Name, InsertBefore);
    }

    public static CastInst CreateFPCast(Value C2, Type Ty, Twine Name, BasicBlock InsertAtEnd) {
        int DstBits;
        assert (C2.getType().isFPOrFPVectorTy() && Ty.isFPOrFPVectorTy()) : "Invalid cast";
        int SrcBits = C2.getType().getScalarSizeInBits();
        int opcode = SrcBits == (DstBits = Ty.getScalarSizeInBits()) ? 47 : (Unsigned.$greater_uint((int)SrcBits, (int)DstBits) ? 43 : 44);
        return CastInst.Create(opcode, C2, Ty, Name, InsertAtEnd);
    }

    public static CastInst CreateTruncOrBitCast(Value S, Type Ty) {
        return CastInst.CreateTruncOrBitCast(S, Ty, new Twine(NativePointer.$EMPTY), (Instruction)null);
    }

    public static CastInst CreateTruncOrBitCast(Value S, Type Ty, Twine Name) {
        return CastInst.CreateTruncOrBitCast(S, Ty, Name, (Instruction)null);
    }

    public static CastInst CreateTruncOrBitCast(Value S, Type Ty, Twine Name, Instruction InsertBefore) {
        if (S.getType().getScalarSizeInBits() == Ty.getScalarSizeInBits()) {
            return CastInst.Create(47, S, Ty, Name, InsertBefore);
        }
        return CastInst.Create(36, S, Ty, Name, InsertBefore);
    }

    public static CastInst CreateTruncOrBitCast(Value S, Type Ty, Twine Name, BasicBlock InsertAtEnd) {
        if (S.getType().getScalarSizeInBits() == Ty.getScalarSizeInBits()) {
            return CastInst.Create(47, S, Ty, Name, InsertAtEnd);
        }
        return CastInst.Create(36, S, Ty, Name, InsertAtEnd);
    }

    public static boolean isCastable(Type SrcTy, Type DestTy) {
        VectorType DestVecTy;
        if (!SrcTy.isFirstClassType() || !DestTy.isFirstClassType()) {
            return false;
        }
        if (SrcTy == DestTy) {
            return true;
        }
        VectorType SrcVecTy = IrRTTI.dyn_cast_VectorType(SrcTy);
        if (SrcVecTy != null && (DestVecTy = IrRTTI.dyn_cast_VectorType(DestTy)) != null && SrcVecTy.getNumElements() == DestVecTy.getNumElements()) {
            SrcTy = SrcVecTy.getElementType();
            DestTy = DestVecTy.getElementType();
        }
        int SrcBits = SrcTy.getPrimitiveSizeInBits();
        int DestBits = DestTy.getPrimitiveSizeInBits();
        if (DestTy.isIntegerTy()) {
            if (SrcTy.isIntegerTy()) {
                return true;
            }
            if (SrcTy.isFloatingPointTy()) {
                return true;
            }
            if (SrcTy.isVectorTy()) {
                return DestBits == SrcBits;
            }
            return SrcTy.isPointerTy();
        }
        if (DestTy.isFloatingPointTy()) {
            if (SrcTy.isIntegerTy()) {
                return true;
            }
            if (SrcTy.isFloatingPointTy()) {
                return true;
            }
            if (SrcTy.isVectorTy()) {
                return DestBits == SrcBits;
            }
            return false;
        }
        if (DestTy.isVectorTy()) {
            return DestBits == SrcBits;
        }
        if (DestTy.isPointerTy()) {
            if (SrcTy.isPointerTy()) {
                return true;
            }
            return SrcTy.isIntegerTy();
        }
        if (DestTy.isX86_MMXTy()) {
            if (SrcTy.isVectorTy()) {
                return DestBits == SrcBits;
            }
            return false;
        }
        return false;
    }

    public static boolean isBitCastable(Type SrcTy, Type DestTy) {
        PointerType SrcPtrTy;
        PointerType DestPtrTy;
        VectorType DestVecTy;
        if (!SrcTy.isFirstClassType() || !DestTy.isFirstClassType()) {
            return false;
        }
        if (SrcTy == DestTy) {
            return true;
        }
        VectorType SrcVecTy = IrRTTI.dyn_cast_VectorType(SrcTy);
        if (SrcVecTy != null && (DestVecTy = IrRTTI.dyn_cast_VectorType(DestTy)) != null && SrcVecTy.getNumElements() == DestVecTy.getNumElements()) {
            SrcTy = SrcVecTy.getElementType();
            DestTy = DestVecTy.getElementType();
        }
        if ((DestPtrTy = IrRTTI.dyn_cast_PointerType(DestTy)) != null && (SrcPtrTy = IrRTTI.dyn_cast_PointerType(SrcTy)) != null) {
            return SrcPtrTy.getAddressSpace() == DestPtrTy.getAddressSpace();
        }
        int SrcBits = SrcTy.getPrimitiveSizeInBits();
        int DestBits = DestTy.getPrimitiveSizeInBits();
        if (SrcBits == 0 || DestBits == 0) {
            return false;
        }
        if (SrcBits != DestBits) {
            return false;
        }
        return !DestTy.isX86_MMXTy() && !SrcTy.isX86_MMXTy();
    }

    public static boolean isBitOrNoopPointerCastable(Type SrcTy, Type DestTy, DataLayout DL) {
        IntegerType IntTy;
        PointerType PtrTy = IrRTTI.dyn_cast_PointerType(SrcTy);
        if (PtrTy != null && (IntTy = IrRTTI.dyn_cast_IntegerType(DestTy)) != null) {
            return IntTy.getBitWidth() == DL.getPointerTypeSizeInBits(PtrTy);
        }
        PtrTy = IrRTTI.dyn_cast_PointerType(DestTy);
        if (PtrTy != null && (IntTy = IrRTTI.dyn_cast_IntegerType(SrcTy)) != null) {
            return IntTy.getBitWidth() == DL.getPointerTypeSizeInBits(PtrTy);
        }
        return CastInst.isBitCastable(SrcTy, DestTy);
    }

    public static int getCastOpcode(Value Src, boolean SrcIsSigned, Type DestTy, boolean DestIsSigned) {
        VectorType DestVecTy;
        Type SrcTy = Src.getType();
        assert (SrcTy.isFirstClassType() && DestTy.isFirstClassType()) : "Only first class types are castable!";
        if (SrcTy == DestTy) {
            return 47;
        }
        VectorType SrcVecTy = IrRTTI.dyn_cast_VectorType(SrcTy);
        if (SrcVecTy != null && (DestVecTy = IrRTTI.dyn_cast_VectorType(DestTy)) != null && SrcVecTy.getNumElements() == DestVecTy.getNumElements()) {
            SrcTy = SrcVecTy.getElementType();
            DestTy = DestVecTy.getElementType();
        }
        int SrcBits = SrcTy.getPrimitiveSizeInBits();
        int DestBits = DestTy.getPrimitiveSizeInBits();
        if (DestTy.isIntegerTy()) {
            if (SrcTy.isIntegerTy()) {
                if (Unsigned.$less_uint((int)DestBits, (int)SrcBits)) {
                    return 36;
                }
                if (Unsigned.$greater_uint((int)DestBits, (int)SrcBits)) {
                    if (SrcIsSigned) {
                        return 38;
                    }
                    return 37;
                }
                return 47;
            }
            if (SrcTy.isFloatingPointTy()) {
                if (DestIsSigned) {
                    return 40;
                }
                return 39;
            }
            if (SrcTy.isVectorTy()) {
                assert (DestBits == SrcBits) : "Casting vector to integer of different width";
                return 47;
            }
            assert (SrcTy.isPointerTy()) : "Casting from a value that is not first-class type";
            return 45;
        }
        if (DestTy.isFloatingPointTy()) {
            if (SrcTy.isIntegerTy()) {
                if (SrcIsSigned) {
                    return 42;
                }
                return 41;
            }
            if (SrcTy.isFloatingPointTy()) {
                if (Unsigned.$less_uint((int)DestBits, (int)SrcBits)) {
                    return 43;
                }
                if (Unsigned.$greater_uint((int)DestBits, (int)SrcBits)) {
                    return 44;
                }
                return 47;
            }
            if (SrcTy.isVectorTy()) {
                assert (DestBits == SrcBits) : "Casting vector to floating point of different width";
                return 47;
            }
            throw new llvm_unreachable("Casting pointer or non-first class to float");
        }
        if (DestTy.isVectorTy()) {
            assert (DestBits == SrcBits) : "Illegal cast to vector (wrong type or size)";
            return 47;
        }
        if (DestTy.isPointerTy()) {
            if (SrcTy.isPointerTy()) {
                if (DestTy.getPointerAddressSpace() != SrcTy.getPointerAddressSpace()) {
                    return 48;
                }
                return 47;
            }
            if (SrcTy.isIntegerTy()) {
                return 46;
            }
            throw new llvm_unreachable("Casting pointer to other than pointer or int");
        }
        if (DestTy.isX86_MMXTy()) {
            if (SrcTy.isVectorTy()) {
                assert (DestBits == SrcBits) : "Casting vector of wrong width to X86_MMX";
                return 47;
            }
            throw new llvm_unreachable("Illegal cast to X86_MMX");
        }
        throw new llvm_unreachable("Casting to type that is not first-class");
    }

    public boolean isIntegerCast() {
        switch (this.getOpcode()) {
            default: {
                return false;
            }
            case 36: 
            case 37: 
            case 38: {
                return true;
            }
            case 47: 
        }
        return this.getOperand(0).getType().isIntegerTy() && this.getType().isIntegerTy();
    }

    public boolean isLosslessCast() {
        Type DstTy;
        if (this.getOpcode() != 47) {
            return false;
        }
        Type SrcTy = this.getOperand(0).getType();
        if (SrcTy == (DstTy = this.getType())) {
            return true;
        }
        if (SrcTy.isPointerTy()) {
            return DstTy.isPointerTy();
        }
        return false;
    }

    public static boolean isNoopCast(int Opcode, Type SrcTy, Type DestTy, Type IntPtrTy) {
        switch (Opcode) {
            default: {
                throw new llvm_unreachable("Invalid CastOp");
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 48: {
                return false;
            }
            case 47: {
                return true;
            }
            case 45: {
                return IntPtrTy.getScalarSizeInBits() == DestTy.getScalarSizeInBits();
            }
            case 46: 
        }
        return IntPtrTy.getScalarSizeInBits() == SrcTy.getScalarSizeInBits();
    }

    public boolean isNoopCast(Type IntPtrTy) {
        return CastInst.isNoopCast(this.getOpcode(), this.getOperand(0).getType(), this.getType(), IntPtrTy);
    }

    public boolean isNoopCast(DataLayout DL) {
        Type PtrOpTy = null;
        if (this.getOpcode() == 45) {
            PtrOpTy = this.getOperand(0).getType();
        } else if (this.getOpcode() == 46) {
            PtrOpTy = this.getType();
        }
        Type IntPtrTy = PtrOpTy != null ? DL.getIntPtrType(PtrOpTy) : DL.getIntPtrType(this.getContext(), 0);
        return CastInst.isNoopCast(this.getOpcode(), this.getOperand(0).getType(), this.getType(), IntPtrTy);
    }

    public static int isEliminableCastPair(int firstOp, int secondOp, Type SrcTy, Type MidTy, Type DstTy, Type SrcIntPtrTy, Type MidIntPtrTy, Type DstIntPtrTy) {
        boolean AreBothBitcasts;
        int numCastOps = 13;
        byte[][] CastResults = CastInst$isEliminableCastPair$$.CastResults;
        boolean IsFirstBitcast = firstOp == 47;
        boolean IsSecondBitcast = secondOp == 47;
        boolean bl = AreBothBitcasts = IsFirstBitcast && IsSecondBitcast;
        if ((IsFirstBitcast && IrRTTI.isa_VectorType(SrcTy) != IrRTTI.isa_VectorType(MidTy) || IsSecondBitcast && IrRTTI.isa_VectorType(MidTy) != IrRTTI.isa_VectorType(DstTy)) && !AreBothBitcasts) {
            return 0;
        }
        int ElimCase = Unsigned.$uchar2int((byte)CastResults[firstOp - 36][secondOp - 36]);
        switch (ElimCase) {
            case 0: {
                return 0;
            }
            case 1: {
                return firstOp;
            }
            case 2: {
                return secondOp;
            }
            case 3: {
                if (!SrcTy.isVectorTy() && DstTy.isIntegerTy()) {
                    return firstOp;
                }
                return 0;
            }
            case 4: {
                if (DstTy.isFloatingPointTy()) {
                    return firstOp;
                }
                return 0;
            }
            case 5: {
                if (SrcTy.isIntegerTy()) {
                    return secondOp;
                }
                return 0;
            }
            case 6: {
                if (SrcTy.isFloatingPointTy()) {
                    return secondOp;
                }
                return 0;
            }
            case 7: {
                if (SrcTy.getPointerAddressSpace() != DstTy.getPointerAddressSpace()) {
                    return 0;
                }
                int MidSize = MidTy.getScalarSizeInBits();
                if (MidSize == 64) {
                    return 47;
                }
                if (SrcIntPtrTy == null || DstIntPtrTy != SrcIntPtrTy) {
                    return 0;
                }
                int PtrSize = SrcIntPtrTy.getScalarSizeInBits();
                if (Unsigned.$greatereq_uint((int)MidSize, (int)PtrSize)) {
                    return 47;
                }
                return 0;
            }
            case 8: {
                int SrcSize = SrcTy.getScalarSizeInBits();
                int DstSize = DstTy.getScalarSizeInBits();
                if (SrcSize == DstSize) {
                    return 47;
                }
                if (Unsigned.$less_uint((int)SrcSize, (int)DstSize)) {
                    return firstOp;
                }
                return secondOp;
            }
            case 9: {
                return 37;
            }
            case 10: {
                if (SrcTy == DstTy) {
                    return 47;
                }
                return 0;
            }
            case 11: {
                if (MidIntPtrTy == null) {
                    return 0;
                }
                int PtrSize = MidIntPtrTy.getScalarSizeInBits();
                int SrcSize = SrcTy.getScalarSizeInBits();
                int DstSize = DstTy.getScalarSizeInBits();
                if (Unsigned.$lesseq_uint((int)SrcSize, (int)PtrSize) && SrcSize == DstSize) {
                    return 47;
                }
                return 0;
            }
            case 12: {
                if (SrcTy.getPointerAddressSpace() != DstTy.getPointerAddressSpace()) {
                    return 48;
                }
                return 47;
            }
            case 13: {
                assert (SrcTy.isPtrOrPtrVectorTy() && MidTy.isPtrOrPtrVectorTy() && DstTy.isPtrOrPtrVectorTy() && SrcTy.getPointerAddressSpace() != MidTy.getPointerAddressSpace() && MidTy.getPointerAddressSpace() == DstTy.getPointerAddressSpace()) : "Illegal addrspacecast, bitcast sequence!";
                return firstOp;
            }
            case 14: {
                if (SrcTy.getPointerElementType() == DstTy.getPointerElementType()) {
                    return 48;
                }
                return 0;
            }
            case 15: {
                assert (SrcTy.isIntOrIntVectorTy() && MidTy.isPtrOrPtrVectorTy() && DstTy.isPtrOrPtrVectorTy() && MidTy.getPointerAddressSpace() == DstTy.getPointerAddressSpace()) : "Illegal inttoptr, bitcast sequence!";
                return firstOp;
            }
            case 16: {
                assert (SrcTy.isPtrOrPtrVectorTy() && MidTy.isPtrOrPtrVectorTy() && DstTy.isIntOrIntVectorTy() && SrcTy.getPointerAddressSpace() == MidTy.getPointerAddressSpace()) : "Illegal bitcast, ptrtoint sequence!";
                return secondOp;
            }
            case 17: {
                return 41;
            }
            case 99: {
                throw new llvm_unreachable("Invalid Cast Combination");
            }
        }
        throw new llvm_unreachable("Error in CastResults table!!!");
    }

    @Override
    public int getOpcode() {
        return super.getOpcode();
    }

    public Type getSrcTy() {
        return this.getOperand(0).getType();
    }

    public Type getDestTy() {
        return this.getType();
    }

    public static boolean castIsValid(int op, Value S, Type DstTy) {
        Type SrcTy = S.getType();
        if (!SrcTy.isFirstClassType() || !DstTy.isFirstClassType() || SrcTy.isAggregateType() || DstTy.isAggregateType()) {
            return false;
        }
        int SrcBitSize = SrcTy.getScalarSizeInBits();
        int DstBitSize = DstTy.getScalarSizeInBits();
        int SrcLength = SrcTy.isVectorTy() ? IrRTTI.cast_VectorType(SrcTy).getNumElements() : 0;
        int DstLength = DstTy.isVectorTy() ? IrRTTI.cast_VectorType(DstTy).getNumElements() : 0;
        switch (op) {
            default: {
                return false;
            }
            case 36: {
                return SrcTy.isIntOrIntVectorTy() && DstTy.isIntOrIntVectorTy() && SrcLength == DstLength && Unsigned.$greater_uint((int)SrcBitSize, (int)DstBitSize);
            }
            case 37: {
                return SrcTy.isIntOrIntVectorTy() && DstTy.isIntOrIntVectorTy() && SrcLength == DstLength && Unsigned.$less_uint((int)SrcBitSize, (int)DstBitSize);
            }
            case 38: {
                return SrcTy.isIntOrIntVectorTy() && DstTy.isIntOrIntVectorTy() && SrcLength == DstLength && Unsigned.$less_uint((int)SrcBitSize, (int)DstBitSize);
            }
            case 43: {
                return SrcTy.isFPOrFPVectorTy() && DstTy.isFPOrFPVectorTy() && SrcLength == DstLength && Unsigned.$greater_uint((int)SrcBitSize, (int)DstBitSize);
            }
            case 44: {
                return SrcTy.isFPOrFPVectorTy() && DstTy.isFPOrFPVectorTy() && SrcLength == DstLength && Unsigned.$less_uint((int)SrcBitSize, (int)DstBitSize);
            }
            case 41: 
            case 42: {
                return SrcTy.isIntOrIntVectorTy() && DstTy.isFPOrFPVectorTy() && SrcLength == DstLength;
            }
            case 39: 
            case 40: {
                return SrcTy.isFPOrFPVectorTy() && DstTy.isIntOrIntVectorTy() && SrcLength == DstLength;
            }
            case 45: {
                if (IrRTTI.isa_VectorType(SrcTy) != IrRTTI.isa_VectorType(DstTy)) {
                    return false;
                }
                VectorType VT = IrRTTI.dyn_cast_VectorType(SrcTy);
                if (VT != null && VT.getNumElements() != IrRTTI.cast_VectorType(DstTy).getNumElements()) {
                    return false;
                }
                return SrcTy.getScalarType().isPointerTy() && DstTy.getScalarType().isIntegerTy();
            }
            case 46: {
                if (IrRTTI.isa_VectorType(SrcTy) != IrRTTI.isa_VectorType(DstTy)) {
                    return false;
                }
                VectorType VT = IrRTTI.dyn_cast_VectorType(SrcTy);
                if (VT != null && VT.getNumElements() != IrRTTI.cast_VectorType(DstTy).getNumElements()) {
                    return false;
                }
                return SrcTy.getScalarType().isIntegerTy() && DstTy.getScalarType().isPointerTy();
            }
            case 47: {
                PointerType SrcPtrTy = IrRTTI.dyn_cast_PointerType(SrcTy.getScalarType());
                PointerType DstPtrTy = IrRTTI.dyn_cast_PointerType(DstTy.getScalarType());
                if (SrcPtrTy == null != (DstPtrTy == null)) {
                    return false;
                }
                if (SrcPtrTy == null) {
                    return SrcTy.getPrimitiveSizeInBits() == DstTy.getPrimitiveSizeInBits();
                }
                if (SrcPtrTy.getAddressSpace() != DstPtrTy.getAddressSpace()) {
                    return false;
                }
                VectorType SrcVecTy = IrRTTI.dyn_cast_VectorType(SrcTy);
                if (SrcVecTy != null) {
                    VectorType DstVecTy = IrRTTI.dyn_cast_VectorType(DstTy);
                    if (DstVecTy != null) {
                        return SrcVecTy.getNumElements() == DstVecTy.getNumElements();
                    }
                    return false;
                }
                return true;
            }
            case 48: 
        }
        PointerType SrcPtrTy = IrRTTI.dyn_cast_PointerType(SrcTy.getScalarType());
        if (SrcPtrTy == null) {
            return false;
        }
        PointerType DstPtrTy = IrRTTI.dyn_cast_PointerType(DstTy.getScalarType());
        if (DstPtrTy == null) {
            return false;
        }
        if (SrcPtrTy.getAddressSpace() == DstPtrTy.getAddressSpace()) {
            return false;
        }
        VectorType SrcVecTy = IrRTTI.dyn_cast_VectorType(SrcTy);
        if (SrcVecTy != null) {
            VectorType DstVecTy = IrRTTI.dyn_cast_VectorType(DstTy);
            if (DstVecTy != null) {
                return SrcVecTy.getNumElements() == DstVecTy.getNumElements();
            }
            return false;
        }
        return true;
    }

    public static boolean classof(Instruction I) {
        return I.isCast();
    }

    public static boolean classof(Value V) {
        return IrRTTI.isa_Instruction(V) && CastInst.classof(IrRTTI.cast_Instruction(V));
    }

    @Override
    public void $destroy() {
        super.$destroy();
    }

    @Override
    public String toString() {
        return "" + super.toString();
    }
}

