/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.clank.java.std;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.aliases.type;
import org.llvm.adt.ADTAliases;
import org.llvm.adt.Optional;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.adt.iterator_range;
import org.llvm.ir.Attribute;
import org.llvm.ir.AttributeSet;
import org.llvm.ir.BasicBlock;
import org.llvm.ir.CallInst;
import org.llvm.ir.FunctionType;
import org.llvm.ir.Instruction;
import org.llvm.ir.OperandBundleDefT;
import org.llvm.ir.OperandBundleUse;
import org.llvm.ir.Type;
import org.llvm.ir.Use;
import org.llvm.ir.User;
import org.llvm.ir.Value;
import org.llvm.ir.java.IrRTTI;
import org.llvm.support.llvm;

public class CallSiteBase<FunTy extends ValTy, BBTy extends BasicBlock, ValTy extends Value, UserTy, UseTy extends Use, InstrTy extends Instruction, CallTy extends CallInst, InvokeTy, IterTy extends type.iterator<IterTy, UseTy>>
implements Native.Native$Bool {
    protected ADTAliases.PointerBoolPair<InstrTy> I;

    protected CallSiteBase() {
        this.I = new ADTAliases.PointerBoolPair(null, false);
    }

    protected CallSiteBase(JavaDifferentiators.JD$T6$P _dparam, CallTy CI) {
        this.I = new ADTAliases.PointerBoolPair(CI, true);
        assert (Native.$bool(CI));
    }

    protected CallSiteBase(JavaDifferentiators.JD$T7$P _dparam, InvokeTy II) {
        this.I = new ADTAliases.PointerBoolPair((Object)((Instruction)II), false);
        assert (Native.$bool(II));
    }

    protected CallSiteBase(JavaDifferentiators.JD$T2$P _dparam, ValTy II) {
        this(JavaDifferentiators.JD.Move.INSTANCE, CallSiteBase.get(II));
    }

    private static <FunTy extends ValTy, BBTy extends BasicBlock, ValTy extends Value, UserTy, UseTy extends Use, InstrTy extends Instruction, CallTy extends CallInst, InvokeTy, IterTy extends type.iterator<IterTy, UseTy>> CallSiteBase<FunTy, BBTy, ValTy, UserTy, UseTy, InstrTy, CallTy, InvokeTy, IterTy> get(ValTy V) {
        Instruction II;
        Instruction instruction = II = V instanceof Instruction ? (Instruction)V : null;
        if (II != null) {
            if (Native.$eq((int)II.getOpcode(), (int)54)) {
                return new CallSiteBase<FunTy, BBTy, ValTy, UserTy, UseTy, InstrTy, CallInst, InvokeTy, IterTy>(JavaDifferentiators.JD$T6$P.INSTANCE, (CallInst)II);
            }
            if (Native.$eq((int)II.getOpcode(), (int)5)) {
                return new CallSiteBase<FunTy, BBTy, ValTy, UserTy, UseTy, InstrTy, CallTy, Instruction, IterTy>(JavaDifferentiators.JD$T7$P.INSTANCE, II);
            }
        }
        return new CallSiteBase<FunTy, BBTy, ValTy, UserTy, UseTy, InstrTy, CallTy, InvokeTy, IterTy>();
    }

    public boolean isCall() {
        return this.I.getInt();
    }

    public boolean isInvoke() {
        return Native.$bool(this.getInstruction()) && Native.$not((boolean)this.I.getInt());
    }

    public InstrTy getInstruction() {
        return (InstrTy)((Instruction)this.I.getPointer());
    }

    public InstrTy $arrow() {
        return (InstrTy)((Instruction)this.I.getPointer());
    }

    public boolean $bool() {
        return this.I.getPointer() != null;
    }

    public BBTy getParent() {
        return (BBTy)((Instruction)this.getInstruction()).getParent();
    }

    public ValTy getCalledValue() {
        assert (Native.$bool(this.getInstruction())) : "Not a call or invoke instruction!";
        return (ValTy)((Use)Native.$Deref(this.getCallee())).$Value$P();
    }

    public FunTy getCalledFunction() {
        return (FunTy)this.getCalledValue();
    }

    public void setCalledFunction(Value V) {
        assert (Native.$bool(this.getInstruction())) : "Not a call or invoke instruction!";
        ((Use)this.getCallee().$star()).$assign(V);
    }

    public boolean isCallee(Value.user_iterator_impl<User> UI) {
        return this.isCallee((Use)Native.$AddrOf((Object)UI.getUse()));
    }

    public boolean isCallee(type.ptr<Use> U) {
        return Native.$eq(this.getCallee(), U);
    }

    public boolean isArgOperand(Value.user_iterator_impl<User> UI) {
        return this.isArgOperand((type.iterator)Native.$AddrOf(UI.getUsePtr()));
    }

    public boolean isArgOperand(type.iterator<?, Use> U) {
        assert (Native.$bool((boolean)Native.$eq(this.getInstruction(), (Object)((Use)U.$star()).getUser())));
        return Native.$bool((boolean)Native.$lesseq(this.arg_begin(), U)) && Native.$bool((boolean)Native.$less(U, this.arg_end()));
    }

    public boolean isBundleOperand(Value.user_iterator_impl<User> UI) {
        return this.isBundleOperand((type.ptr<Use>)((type.ptr)Native.$AddrOf(UI.getUsePtr())));
    }

    public boolean isBundleOperand(type.ptr<Use> U) {
        assert (Native.$bool((boolean)Native.$eq(this.getInstruction(), (Object)((Use)U.$star()).getUser())));
        if (Native.$not((boolean)this.hasOperandBundles())) {
            return false;
        }
        int OperandNo = U.$sub(((User)this.$arrow()).op_begin());
        return Native.$bool((boolean)Native.$lesseq((int)this.getBundleOperandsStartIndex(), (int)OperandNo)) && Native.$bool((boolean)Native.$less((int)OperandNo, (int)this.getBundleOperandsEndIndex()));
    }

    public boolean isBundleOperand(Value.use_iterator_impl<Use> U) {
        assert (Native.$bool((boolean)Native.$eq(this.getInstruction(), (Object)((Use)U.$star()).getUser())));
        if (Native.$not((boolean)this.hasOperandBundles())) {
            return false;
        }
        int OperandNo = U.$sub(((User)this.$arrow()).op_begin());
        return Native.$bool((boolean)Native.$lesseq((int)this.getBundleOperandsStartIndex(), (int)OperandNo)) && Native.$bool((boolean)Native.$less((int)OperandNo, (int)this.getBundleOperandsEndIndex()));
    }

    public boolean isDataOperand(Value.user_iterator_impl<User> UI) {
        return this.isDataOperand((type.iterator)Native.$AddrOf(UI.getUsePtr()));
    }

    public boolean isDataOperand(type.iterator<?, Use> U) {
        return Native.$bool((boolean)Native.$lesseq(this.data_operands_begin(), U)) && Native.$bool((boolean)Native.$less(U, this.data_operands_end()));
    }

    public ValTy getArgument(int ArgNo) {
        assert (Native.$bool((boolean)Native.$less((Object)Native.$add(this.arg_begin(), (int)ArgNo), this.arg_end()))) : "Argument # out of range!";
        Use $Deref = (Use)Native.$Deref((type.iterator)Native.$add(this.arg_begin(), (int)ArgNo));
        return (ValTy)((Use)Native.$Deref((type.iterator)Native.$add(this.arg_begin(), (int)ArgNo))).$Value$P();
    }

    public void setArgument(int ArgNo, Value newVal) {
        assert (Native.$bool(this.getInstruction())) : "Not a call or invoke instruction!";
        assert (Native.$bool((boolean)Native.$less((Object)Native.$add(this.arg_begin(), (int)ArgNo), this.arg_end()))) : "Argument # out of range!";
        ((User)this.getInstruction()).setOperand(ArgNo, newVal);
    }

    public int getArgumentNo(Value.user_iterator_impl<User> I) {
        return this.getArgumentNo((type.iterator)Native.$AddrOf(I.getUsePtr()));
    }

    public int getArgumentNo(type.iterator<?, Use> U) {
        assert (Native.$bool(this.getInstruction())) : "Not a call or invoke instruction!";
        assert (Native.$bool((boolean)this.isArgOperand(U))) : "Argument # out of range!";
        return std.distance(this.arg_begin(), U);
    }

    public iterator_range<UseTy> args() {
        return llvm.make_range(this.arg_begin(), this.arg_end());
    }

    public boolean arg_empty() {
        return Native.$eq(this.arg_end(), this.arg_begin());
    }

    public int arg_size() {
        return this.arg_end().$sub(this.arg_begin());
    }

    public int getDataOperandNo(Value.user_iterator_impl<User> UI) {
        return this.getDataOperandNo((type.ptr<Use>)((type.ptr)Native.$AddrOf(UI.getUsePtr())));
    }

    public int getDataOperandNo(type.ptr<Use> U) {
        assert (Native.$bool(this.getInstruction())) : "Not a call or invoke instruction!";
        assert (Native.$bool((boolean)this.isDataOperand((type.iterator<?, Use>)U))) : "Data operand # out of range!";
        return std.distance(this.data_operands_begin(), U);
    }

    public IterTy data_operands_begin() {
        assert (Native.$bool(this.getInstruction())) : "Not a call or invoke instruction!";
        return (IterTy)((User)this.$arrow()).op_begin();
    }

    public IterTy data_operands_end() {
        assert (Native.$bool(this.getInstruction())) : "Not a call or invoke instruction!";
        return (IterTy)((type.iterator)((User)this.$arrow()).op_end().$sub(this.isCall() ? 1 : 3));
    }

    public iterator_range<UseTy> data_ops() {
        return llvm.make_range(this.data_operands_begin(), this.data_operands_end());
    }

    public boolean data_operands_empty() {
        return Native.$eq(this.data_operands_end(), this.data_operands_begin());
    }

    public int data_operands_size() {
        return std.distance(this.data_operands_begin(), this.data_operands_end());
    }

    public Type getType() {
        return this.getType();
    }

    public FunTy getCaller() {
        return (FunTy)((BasicBlock)this.getParent()).getParent();
    }

    public boolean isMustTailCall() {
        return Native.$bool((boolean)this.isCall()) && Native.$bool((boolean)IrRTTI.cast_CallInst(this.getInstruction()).isMustTailCall());
    }

    public boolean isTailCall() {
        return Native.$bool((boolean)this.isCall()) && Native.$bool((boolean)IrRTTI.cast_CallInst(this.getInstruction()).isTailCall());
    }

    public int getNumArgOperands() {
        InstrTy II = this.getInstruction();
        return this.isCall() ? IrRTTI.cast_CallInst(II).getNumArgOperands() : IrRTTI.cast_InvokeInst(II).getNumArgOperands();
    }

    public ValTy getArgOperand(int i) {
        InstrTy II = this.getInstruction();
        return (ValTy)(this.isCall() ? IrRTTI.cast_CallInst(II).getArgOperand(i) : IrRTTI.cast_InvokeInst(II).getArgOperand(i));
    }

    public ValTy getReturnedArgOperand() {
        InstrTy II = this.getInstruction();
        return (ValTy)(this.isCall() ? IrRTTI.cast_CallInst(II).getReturnedArgOperand() : IrRTTI.cast_InvokeInst(II).getReturnedArgOperand());
    }

    public boolean isInlineAsm() {
        if (this.isCall()) {
            return IrRTTI.cast_CallInst(this.getInstruction()).isInlineAsm();
        }
        return false;
    }

    public int getCallingConv() {
        InstrTy II = this.getInstruction();
        return this.isCall() ? IrRTTI.cast_CallInst(II).getCallingConv() : IrRTTI.cast_InvokeInst(II).getCallingConv();
    }

    public void setCallingConv(int CC) {
        InstrTy II = this.getInstruction();
        if (this.isCall()) {
            IrRTTI.cast_CallInst(II).setCallingConv(CC);
        } else {
            IrRTTI.cast_InvokeInst(II).setCallingConv(CC);
        }
    }

    public FunctionType getFunctionType() {
        InstrTy II = this.getInstruction();
        return this.isCall() ? IrRTTI.cast_CallInst(II).getFunctionType() : IrRTTI.cast_InvokeInst(II).getFunctionType();
    }

    public void mutateFunctionType(FunctionType Ty) {
        InstrTy II = this.getInstruction();
        if (this.isCall()) {
            IrRTTI.cast_CallInst(II).mutateFunctionType(Ty);
        } else {
            IrRTTI.cast_InvokeInst(II).mutateFunctionType(Ty);
        }
    }

    public AttributeSet getAttributes() {
        InstrTy II = this.getInstruction();
        return this.isCall() ? IrRTTI.cast_CallInst(II).getAttributes() : IrRTTI.cast_InvokeInst(II).getAttributes();
    }

    public void setAttributes(AttributeSet PAL) {
        InstrTy II = this.getInstruction();
        if (this.isCall()) {
            IrRTTI.cast_CallInst(II).setAttributes(PAL);
        } else {
            IrRTTI.cast_InvokeInst(II).setAttributes(PAL);
        }
    }

    public void addAttribute(int i, Attribute.AttrKind Kind2) {
        InstrTy II = this.getInstruction();
        if (this.isCall()) {
            IrRTTI.cast_CallInst(II).addAttribute(i, Kind2);
        } else {
            IrRTTI.cast_InvokeInst(II).addAttribute(i, Kind2);
        }
    }

    public void addAttribute(int i, StringRef Kind2, StringRef Value2) {
        InstrTy II = this.getInstruction();
        if (this.isCall()) {
            IrRTTI.cast_CallInst(II).addAttribute(i, Kind2, Value2);
        } else {
            IrRTTI.cast_InvokeInst(II).addAttribute(i, Kind2, Value2);
        }
    }

    public void addAttribute(int i, Attribute Attr) {
        InstrTy II = this.getInstruction();
        if (this.isCall()) {
            IrRTTI.cast_CallInst(II).addAttribute(i, Attr);
        } else {
            IrRTTI.cast_InvokeInst(II).addAttribute(i, Attr);
        }
    }

    public void removeAttribute(int i, Attribute.AttrKind Kind2) {
        InstrTy II = this.getInstruction();
        if (this.isCall()) {
            IrRTTI.cast_CallInst(II).removeAttribute(i, Kind2);
        } else {
            IrRTTI.cast_InvokeInst(II).removeAttribute(i, Kind2);
        }
    }

    public void removeAttribute(int i, StringRef Kind2) {
        InstrTy II = this.getInstruction();
        if (this.isCall()) {
            IrRTTI.cast_CallInst(II).removeAttribute(i, Kind2);
        } else {
            IrRTTI.cast_InvokeInst(II).removeAttribute(i, Kind2);
        }
    }

    public void removeAttribute(int i, Attribute Attr) {
        InstrTy II = this.getInstruction();
        if (this.isCall()) {
            IrRTTI.cast_CallInst(II).removeAttribute(i, Attr);
        } else {
            IrRTTI.cast_InvokeInst(II).removeAttribute(i, Attr);
        }
    }

    public boolean hasFnAttr(Attribute.AttrKind Kind2) {
        InstrTy II = this.getInstruction();
        return this.isCall() ? IrRTTI.cast_CallInst(II).hasFnAttr(Kind2) : IrRTTI.cast_InvokeInst(II).hasFnAttr(Kind2);
    }

    public boolean hasFnAttr(StringRef Kind2) {
        InstrTy II = this.getInstruction();
        return this.isCall() ? IrRTTI.cast_CallInst(II).hasFnAttr(Kind2) : IrRTTI.cast_InvokeInst(II).hasFnAttr(Kind2);
    }

    public boolean paramHasAttr(int i, Attribute.AttrKind Kind2) {
        InstrTy II = this.getInstruction();
        return this.isCall() ? IrRTTI.cast_CallInst(II).paramHasAttr(i, Kind2) : IrRTTI.cast_InvokeInst(II).paramHasAttr(i, Kind2);
    }

    public Attribute getAttribute(int i, Attribute.AttrKind Kind2) {
        InstrTy II = this.getInstruction();
        return this.isCall() ? IrRTTI.cast_CallInst(II).getAttribute(i, Kind2) : IrRTTI.cast_InvokeInst(II).getAttribute(i, Kind2);
    }

    public Attribute getAttribute(int i, StringRef Kind2) {
        InstrTy II = this.getInstruction();
        return this.isCall() ? IrRTTI.cast_CallInst(II).getAttribute(i, Kind2) : IrRTTI.cast_InvokeInst(II).getAttribute(i, Kind2);
    }

    public boolean dataOperandHasImpliedAttr(int i, Attribute.AttrKind Kind2) {
        InstrTy II = this.getInstruction();
        return this.isCall() ? IrRTTI.cast_CallInst(II).dataOperandHasImpliedAttr(i, Kind2) : IrRTTI.cast_InvokeInst(II).dataOperandHasImpliedAttr(i, Kind2);
    }

    public char getParamAlignment(char i) {
        InstrTy II = this.getInstruction();
        return (char)(this.isCall() ? IrRTTI.cast_CallInst(II).getParamAlignment(i) : IrRTTI.cast_InvokeInst(II).getParamAlignment(i));
    }

    public long getDereferenceableBytes(char i) {
        InstrTy II = this.getInstruction();
        return this.isCall() ? IrRTTI.cast_CallInst(II).getDereferenceableBytes(i) : IrRTTI.cast_InvokeInst(II).getDereferenceableBytes(i);
    }

    public long getDereferenceableOrNullBytes(char i) {
        InstrTy II = this.getInstruction();
        return this.isCall() ? IrRTTI.cast_CallInst(II).getDereferenceableOrNullBytes(i) : IrRTTI.cast_InvokeInst(II).getDereferenceableOrNullBytes(i);
    }

    public boolean doesNotAlias(int n) {
        InstrTy II = this.getInstruction();
        return this.isCall() ? IrRTTI.cast_CallInst(II).doesNotAlias(n) : IrRTTI.cast_InvokeInst(II).doesNotAlias(n);
    }

    public boolean isNoBuiltin() {
        InstrTy II = this.getInstruction();
        return this.isCall() ? IrRTTI.cast_CallInst(II).isNoBuiltin() : IrRTTI.cast_InvokeInst(II).isNoBuiltin();
    }

    public boolean isNoInline() {
        InstrTy II = this.getInstruction();
        return this.isCall() ? IrRTTI.cast_CallInst(II).isNoInline() : IrRTTI.cast_InvokeInst(II).isNoInline();
    }

    public void setIsNoInline() {
        this.setIsNoInline(true);
    }

    public void setIsNoInline(boolean Value2) {
        InstrTy II = this.getInstruction();
        if (this.isCall()) {
            IrRTTI.cast_CallInst(II).setIsNoInline();
        } else {
            IrRTTI.cast_InvokeInst(II).setIsNoInline();
        }
    }

    public boolean doesNotAccessMemory() {
        InstrTy II = this.getInstruction();
        return this.isCall() ? IrRTTI.cast_CallInst(II).doesNotAccessMemory() : IrRTTI.cast_InvokeInst(II).doesNotAccessMemory();
    }

    public void setDoesNotAccessMemory() {
        InstrTy II = this.getInstruction();
        if (this.isCall()) {
            IrRTTI.cast_CallInst(II).setDoesNotAccessMemory();
        } else {
            IrRTTI.cast_InvokeInst(II).setDoesNotAccessMemory();
        }
    }

    public boolean onlyReadsMemory() {
        InstrTy II = this.getInstruction();
        return this.isCall() ? IrRTTI.cast_CallInst(II).onlyReadsMemory() : IrRTTI.cast_InvokeInst(II).onlyReadsMemory();
    }

    public void setOnlyReadsMemory() {
        InstrTy II = this.getInstruction();
        if (this.isCall()) {
            IrRTTI.cast_CallInst(II).setOnlyReadsMemory();
        } else {
            IrRTTI.cast_InvokeInst(II).setOnlyReadsMemory();
        }
    }

    public boolean doesNotReadMemory() {
        InstrTy II = this.getInstruction();
        return this.isCall() ? IrRTTI.cast_CallInst(II).doesNotReadMemory() : IrRTTI.cast_InvokeInst(II).doesNotReadMemory();
    }

    public void setDoesNotReadMemory() {
        InstrTy II = this.getInstruction();
        if (this.isCall()) {
            IrRTTI.cast_CallInst(II).setDoesNotReadMemory();
        } else {
            IrRTTI.cast_InvokeInst(II).setDoesNotReadMemory();
        }
    }

    public boolean onlyAccessesArgMemory() {
        InstrTy II = this.getInstruction();
        return this.isCall() ? IrRTTI.cast_CallInst(II).onlyAccessesArgMemory() : IrRTTI.cast_InvokeInst(II).onlyAccessesArgMemory();
    }

    public void setOnlyAccessesArgMemory() {
        InstrTy II = this.getInstruction();
        if (this.isCall()) {
            IrRTTI.cast_CallInst(II).setOnlyAccessesArgMemory();
        } else {
            IrRTTI.cast_InvokeInst(II).setOnlyAccessesArgMemory();
        }
    }

    public boolean doesNotReturn() {
        InstrTy II = this.getInstruction();
        return this.isCall() ? IrRTTI.cast_CallInst(II).doesNotReturn() : IrRTTI.cast_InvokeInst(II).doesNotReturn();
    }

    public void setDoesNotReturn() {
        InstrTy II = this.getInstruction();
        if (this.isCall()) {
            IrRTTI.cast_CallInst(II).setDoesNotReturn();
        } else {
            IrRTTI.cast_InvokeInst(II).setDoesNotReturn();
        }
    }

    public boolean doesNotThrow() {
        InstrTy II = this.getInstruction();
        return this.isCall() ? IrRTTI.cast_CallInst(II).doesNotThrow() : IrRTTI.cast_InvokeInst(II).doesNotThrow();
    }

    public void setDoesNotThrow() {
        InstrTy II = this.getInstruction();
        if (this.isCall()) {
            IrRTTI.cast_CallInst(II).setDoesNotThrow();
        } else {
            IrRTTI.cast_InvokeInst(II).setDoesNotThrow();
        }
    }

    public boolean cannotDuplicate() {
        InstrTy II = this.getInstruction();
        return this.isCall() ? IrRTTI.cast_CallInst(II).cannotDuplicate() : IrRTTI.cast_InvokeInst(II).cannotDuplicate();
    }

    public void setCannotDuplicate() {
        InstrTy II = this.getInstruction();
        if (this.isCall()) {
            IrRTTI.cast_CallInst(II).setCannotDuplicate();
        } else {
            IrRTTI.cast_InvokeInst(II).setCannotDuplicate();
        }
    }

    public boolean isConvergent() {
        InstrTy II = this.getInstruction();
        return this.isCall() ? IrRTTI.cast_CallInst(II).isConvergent() : IrRTTI.cast_InvokeInst(II).isConvergent();
    }

    public void setConvergent() {
        InstrTy II = this.getInstruction();
        if (this.isCall()) {
            IrRTTI.cast_CallInst(II).setConvergent();
        } else {
            IrRTTI.cast_InvokeInst(II).setConvergent();
        }
    }

    public void setNotConvergent() {
        InstrTy II = this.getInstruction();
        if (this.isCall()) {
            IrRTTI.cast_CallInst(II).setNotConvergent();
        } else {
            IrRTTI.cast_InvokeInst(II).setNotConvergent();
        }
    }

    public int getNumOperandBundles() {
        InstrTy II = this.getInstruction();
        return this.isCall() ? IrRTTI.cast_CallInst(II).getNumOperandBundles() : IrRTTI.cast_InvokeInst(II).getNumOperandBundles();
    }

    public boolean hasOperandBundles() {
        InstrTy II = this.getInstruction();
        return this.isCall() ? IrRTTI.cast_CallInst(II).hasOperandBundles() : IrRTTI.cast_InvokeInst(II).hasOperandBundles();
    }

    public int getBundleOperandsStartIndex() {
        InstrTy II = this.getInstruction();
        return this.isCall() ? IrRTTI.cast_CallInst(II).getBundleOperandsStartIndex() : IrRTTI.cast_InvokeInst(II).getBundleOperandsStartIndex();
    }

    public int getBundleOperandsEndIndex() {
        InstrTy II = this.getInstruction();
        return this.isCall() ? IrRTTI.cast_CallInst(II).getBundleOperandsEndIndex() : IrRTTI.cast_InvokeInst(II).getBundleOperandsEndIndex();
    }

    public int getNumTotalBundleOperands() {
        InstrTy II = this.getInstruction();
        return this.isCall() ? IrRTTI.cast_CallInst(II).getNumTotalBundleOperands() : IrRTTI.cast_InvokeInst(II).getNumTotalBundleOperands();
    }

    public OperandBundleUse getOperandBundleAt(int Index) {
        InstrTy II = this.getInstruction();
        return this.isCall() ? IrRTTI.cast_CallInst(II).getOperandBundleAt(Index) : IrRTTI.cast_InvokeInst(II).getOperandBundleAt(Index);
    }

    public Optional<OperandBundleUse> getOperandBundle(StringRef Name) {
        InstrTy II = this.getInstruction();
        return this.isCall() ? IrRTTI.cast_CallInst(II).getOperandBundle(Name) : IrRTTI.cast_InvokeInst(II).getOperandBundle(Name);
    }

    public Optional<OperandBundleUse> getOperandBundle(int ID2) {
        InstrTy II = this.getInstruction();
        return this.isCall() ? IrRTTI.cast_CallInst(II).getOperandBundle(ID2) : IrRTTI.cast_InvokeInst(II).getOperandBundle(ID2);
    }

    public int countOperandBundlesOfType(int ID2) {
        InstrTy II = this.getInstruction();
        return this.isCall() ? IrRTTI.cast_CallInst(II).countOperandBundlesOfType(ID2) : IrRTTI.cast_InvokeInst(II).countOperandBundlesOfType(ID2);
    }

    public IterTy arg_begin() {
        InstrTy II = this.getInstruction();
        return (IterTy)(this.isCall() ? IrRTTI.cast_CallInst(II).arg_begin() : IrRTTI.cast_InvokeInst(II).arg_begin());
    }

    public IterTy arg_end() {
        InstrTy II = this.getInstruction();
        return (IterTy)(this.isCall() ? IrRTTI.cast_CallInst(II).arg_end() : IrRTTI.cast_InvokeInst(II).arg_end());
    }

    public void getOperandBundlesAsDefs(SmallVectorImpl<OperandBundleDefT<Value>> Defs) {
        InstrTy II = this.getInstruction();
        if (this.isCall()) {
            IrRTTI.cast_CallInst(II).getOperandBundlesAsDefs(Defs);
        } else {
            IrRTTI.cast_InvokeInst(II).getOperandBundlesAsDefs(Defs);
        }
    }

    public boolean doesNotCapture(int OpNo) {
        return this.dataOperandHasImpliedAttr(OpNo + 1, Attribute.AttrKind.NoCapture);
    }

    public boolean isByValArgument(int ArgNo) {
        return this.paramHasAttr(ArgNo + 1, Attribute.AttrKind.ByVal);
    }

    public boolean isInAllocaArgument(int ArgNo) {
        return this.paramHasAttr(ArgNo + 1, Attribute.AttrKind.InAlloca);
    }

    public boolean isByValOrInAllocaArgument(int ArgNo) {
        return Native.$bool((boolean)this.paramHasAttr(ArgNo + 1, Attribute.AttrKind.ByVal)) || Native.$bool((boolean)this.paramHasAttr(ArgNo + 1, Attribute.AttrKind.InAlloca));
    }

    public boolean hasInAllocaArgument() {
        return this.paramHasAttr(this.arg_size(), Attribute.AttrKind.InAlloca);
    }

    public boolean doesNotAccessMemory(int OpNo) {
        return this.dataOperandHasImpliedAttr(OpNo + 1, Attribute.AttrKind.ReadNone);
    }

    public boolean onlyReadsMemory(int OpNo) {
        return Native.$bool((boolean)this.dataOperandHasImpliedAttr(OpNo + 1, Attribute.AttrKind.ReadOnly)) || Native.$bool((boolean)this.dataOperandHasImpliedAttr(OpNo + 1, Attribute.AttrKind.ReadNone));
    }

    public boolean isReturnNonNull() {
        if (this.paramHasAttr(0, Attribute.AttrKind.NonNull)) {
            return true;
        }
        return Native.$bool((boolean)Native.$greater((long)this.getDereferenceableBytes('\u0000'), (long)0L)) && Native.$bool((boolean)Native.$eq((int)this.getType().getPointerAddressSpace(), (int)0));
    }

    public boolean hasArgument(Value Arg) {
        IterTy AI = this.arg_begin();
        IterTy E = this.arg_end();
        while (Native.$noteq(AI, E)) {
            if (Native.$eq((Object)((Use)AI.$arrow()).get(), (Object)Arg)) {
                return true;
            }
            AI.$preInc();
        }
        return false;
    }

    private IterTy getCallee() {
        if (this.isCall()) {
            return (IterTy)((type.iterator)IrRTTI.cast_CallInst(this.getInstruction()).op_end().$sub(1));
        }
        return (IterTy)((type.iterator)IrRTTI.cast_InvokeInst(this.getInstruction()).op_end().$sub(3));
    }

    public CallSiteBase(CallSiteBase<FunTy, BBTy, ValTy, UserTy, UseTy, InstrTy, CallTy, InvokeTy, IterTy> BB) {
        this.I = new ADTAliases.PointerBoolPair(BB.I);
    }

    public CallSiteBase(JavaDifferentiators.JD.Move $prm, CallSiteBase<FunTy, BBTy, ValTy, UserTy, UseTy, InstrTy, CallTy, InvokeTy, IterTy> BB) {
        this.I = BB.I;
        BB.I = null;
    }

    public boolean isCallee(Use U) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    CallSiteBase $assign(CallSiteBase $Prm0) {
        this.I = $Prm0.I.clone();
        return this;
    }

    CallSiteBase $assignMove(CallSiteBase $Prm0) {
        this.I = $Prm0.I;
        $Prm0.I = null;
        return this;
    }

    public String toString() {
        return "I=" + this.I;
    }
}

