/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.clank.support.Destructors;
import org.clank.support.Unsigned;
import org.clank.support.aliases.type;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.ir.BasicBlock;
import org.llvm.ir.Instruction;
import org.llvm.ir.LLVMContext;
import org.llvm.ir.MDNode;
import org.llvm.ir.Metadata;
import org.llvm.ir.OperandTraitsBranchInst;
import org.llvm.ir.TerminatorInst;
import org.llvm.ir.Type;
import org.llvm.ir.Use;
import org.llvm.ir.User;
import org.llvm.ir.Value;
import org.llvm.ir.java.IrRTTI;

public class BranchInst
extends TerminatorInst
implements Destructors.ClassWithDestructor {
    private BranchInst(BranchInst BI) {
        super(Type.getVoidTy(BI.getContext()), 2, (type.ptr<Use>)((type.ptr)OperandTraitsBranchInst.op_end(User.$BEING_CREATED()).$sub(BI.getNumOperands())), BI.getNumOperands());
        this.Op(-1).$assign(BI.Op$Const(-1));
        if (BI.getNumOperands() != 1) {
            assert (BI.getNumOperands() == 3) : "BR can have 1 or 3 operands!";
            this.Op(-3).$assign(BI.Op$Const(-3));
            this.Op(-2).$assign(BI.Op$Const(-2));
        }
        this.SubclassOptionalData = Unsigned.$uchar2uchar_7bits((byte)Unsigned.$7bits_uchar2uchar((byte)BI.SubclassOptionalData));
    }

    private void AssertOK() {
        if (this.isConditional()) assert (this.getCondition().getType().isIntegerTy(1)) : "May only branch on boolean predicates!";
    }

    private BranchInst(BasicBlock IfTrue) {
        this(IfTrue, (Instruction)null);
    }

    private BranchInst(BasicBlock IfTrue, Instruction InsertBefore) {
        super(Type.getVoidTy(IfTrue.getContext()), 2, (type.ptr<Use>)((type.ptr)OperandTraitsBranchInst.op_end(User.$BEING_CREATED()).$sub(1)), 1, InsertBefore);
        assert (IfTrue != null) : "Branch destination may not be null!";
        this.Op(-1).$assign(IfTrue);
    }

    private BranchInst(BasicBlock IfTrue, BasicBlock IfFalse, Value Cond) {
        this(IfTrue, IfFalse, Cond, (Instruction)null);
    }

    private BranchInst(BasicBlock IfTrue, BasicBlock IfFalse, Value Cond, Instruction InsertBefore) {
        super(Type.getVoidTy(IfTrue.getContext()), 2, (type.ptr<Use>)((type.ptr)OperandTraitsBranchInst.op_end(User.$BEING_CREATED()).$sub(3)), 3, InsertBefore);
        this.Op(-1).$assign(IfTrue);
        this.Op(-2).$assign(IfFalse);
        this.Op(-3).$assign(Cond);
        this.AssertOK();
    }

    private BranchInst(BasicBlock IfTrue, BasicBlock InsertAtEnd) {
        super(Type.getVoidTy(IfTrue.getContext()), 2, (type.ptr<Use>)((type.ptr)OperandTraitsBranchInst.op_end(User.$BEING_CREATED()).$sub(1)), 1, InsertAtEnd);
        assert (IfTrue != null) : "Branch destination may not be null!";
        this.Op(-1).$assign(IfTrue);
    }

    private BranchInst(BasicBlock IfTrue, BasicBlock IfFalse, Value Cond, BasicBlock InsertAtEnd) {
        super(Type.getVoidTy(IfTrue.getContext()), 2, (type.ptr<Use>)((type.ptr)OperandTraitsBranchInst.op_end(User.$BEING_CREATED()).$sub(3)), 3, InsertAtEnd);
        this.Op(-1).$assign(IfTrue);
        this.Op(-2).$assign(IfFalse);
        this.Op(-3).$assign(Cond);
        this.AssertOK();
    }

    protected BranchInst cloneImpl() {
        return (BranchInst)User.$new_FixedUses(this.getNumOperands(), New$Mem -> new BranchInst(this));
    }

    public static BranchInst Create(BasicBlock IfTrue) {
        return BranchInst.Create(IfTrue, (Instruction)null);
    }

    public static BranchInst Create(BasicBlock IfTrue, Instruction InsertBefore) {
        return (BranchInst)User.$new_FixedUses(1, New$Mem -> new BranchInst(IfTrue, InsertBefore));
    }

    public static BranchInst Create(BasicBlock IfTrue, BasicBlock IfFalse, Value Cond) {
        return BranchInst.Create(IfTrue, IfFalse, Cond, (Instruction)null);
    }

    public static BranchInst Create(BasicBlock IfTrue, BasicBlock IfFalse, Value Cond, Instruction InsertBefore) {
        return (BranchInst)User.$new_FixedUses(3, New$Mem -> new BranchInst(IfTrue, IfFalse, Cond, InsertBefore));
    }

    public static BranchInst Create(BasicBlock IfTrue, BasicBlock InsertAtEnd) {
        return (BranchInst)User.$new_FixedUses(1, New$Mem -> new BranchInst(IfTrue, InsertAtEnd));
    }

    public static BranchInst Create(BasicBlock IfTrue, BasicBlock IfFalse, Value Cond, BasicBlock InsertAtEnd) {
        return (BranchInst)User.$new_FixedUses(3, New$Mem -> new BranchInst(IfTrue, IfFalse, Cond, InsertAtEnd));
    }

    @Override
    public Value getOperand(int i_nocapture) {
        assert (Unsigned.$less_uint((int)i_nocapture, (int)OperandTraitsBranchInst.operands(this))) : "getOperand() out of range!";
        return IrRTTI.cast_or_null_Value(((Use)OperandTraitsBranchInst.op_begin(this).$at(i_nocapture)).get());
    }

    @Override
    public void setOperand(int i_nocapture, Value Val_nocapture) {
        assert (Unsigned.$less_uint((int)i_nocapture, (int)OperandTraitsBranchInst.operands(this))) : "setOperand() out of range!";
        ((Use)OperandTraitsBranchInst.op_begin(this).$at(i_nocapture)).$assign(Val_nocapture);
    }

    @Override
    public type.ptr<Use> op_begin() {
        return OperandTraitsBranchInst.op_begin(this);
    }

    @Override
    public type.ptr<Use> op_begin$Const() {
        return OperandTraitsBranchInst.op_begin(this);
    }

    @Override
    public type.ptr<Use> op_end() {
        return OperandTraitsBranchInst.op_end(this);
    }

    @Override
    public type.ptr<Use> op_end$Const() {
        return OperandTraitsBranchInst.op_end(this);
    }

    @Override
    protected Use Op(int Idx_nocapture) {
        return this.OpFrom(Idx_nocapture, this);
    }

    @Override
    protected Use Op$Const(int Idx_nocapture) {
        return this.OpFrom(Idx_nocapture, this);
    }

    @Override
    public int getNumOperands() {
        return OperandTraitsBranchInst.operands(this);
    }

    public boolean isUnconditional() {
        return this.getNumOperands() == 1;
    }

    public boolean isConditional() {
        return this.getNumOperands() == 3;
    }

    public Value getCondition() {
        assert (this.isConditional()) : "Cannot get condition of an uncond branch!";
        return this.Op$Const(-3).$Value$P();
    }

    public void setCondition(Value V) {
        assert (this.isConditional()) : "Cannot set condition of unconditional branch!";
        this.Op(-3).$assign(V);
    }

    @Override
    public int getNumSuccessors() {
        return 1 + (this.isConditional() ? 1 : 0);
    }

    @Override
    public BasicBlock getSuccessor(int i) {
        assert (Unsigned.$less_uint((int)i, (int)this.getNumSuccessors())) : "Successor # out of range for Branch!";
        return IrRTTI.cast_or_null_BasicBlock(((Use)((type.ptr)this.OpFrom$Addr(-1, this).$sub(i)).$star()).get());
    }

    @Override
    public void setSuccessor(int idx, BasicBlock NewSucc) {
        assert (Unsigned.$less_uint((int)idx, (int)this.getNumSuccessors())) : "Successor # out of range for Branch!";
        ((Use)((type.ptr)this.OpFrom$Addr(-1, this).$sub(idx)).$star()).$assign(NewSucc);
    }

    public void swapSuccessors() {
        assert (this.isConditional()) : "Cannot swap successors of an unconditional branch";
        this.Op(-1).swap(this.Op(-2));
        MDNode ProfileData = this.getMetadata(LLVMContext.Unnamed_enum.MD_prof.getValue());
        if (ProfileData == null || ProfileData.getNumOperands() != 3) {
            return;
        }
        Object[] Ops = new Metadata[]{ProfileData.getOperand(0).$Metadata$P(), ProfileData.getOperand(2).$Metadata$P(), ProfileData.getOperand(1).$Metadata$P()};
        this.setMetadata(LLVMContext.Unnamed_enum.MD_prof.getValue(), (MDNode)MDNode.get(ProfileData.getContext(), (ArrayRef<Metadata>)new ArrayRef(Ops, 3, true)));
    }

    public static boolean classof(Instruction I) {
        return I.getOpcode() == 2;
    }

    public static boolean classof(Value V) {
        return IrRTTI.isa_Instruction(V) && BranchInst.classof(IrRTTI.cast_Instruction(V));
    }

    @Override
    protected BasicBlock getSuccessorV(int idx) {
        return this.getSuccessor(idx);
    }

    @Override
    protected int getNumSuccessorsV() {
        return this.getNumSuccessors();
    }

    @Override
    protected void setSuccessorV(int idx, BasicBlock B2) {
        this.setSuccessor(idx, B2);
    }

    @Override
    public void $destroy() {
        super.$destroy();
    }

    @Override
    public String toString() {
        return "" + super.toString();
    }
}

