/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.clank.support.Destructors;
import org.clank.support.NativeCallback;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.type;
import org.llvm.adt.Twine;
import org.llvm.adt.ilist_node;
import org.llvm.ir.BasicBlock;
import org.llvm.ir.Constant;
import org.llvm.ir.ConstantFP;
import org.llvm.ir.Instruction;
import org.llvm.ir.OperandTraitsBinaryOperator;
import org.llvm.ir.Type;
import org.llvm.ir.Use;
import org.llvm.ir.User;
import org.llvm.ir.Value;
import org.llvm.ir.impl.InstructionsStatics;
import org.llvm.ir.java.IrRTTI;

public class BinaryOperator
extends Instruction
implements Destructors.ClassWithDestructor {
    protected static Object $new_BinaryOperator(int $Prm0, int $Prm1) {
        throw new UnsupportedOperationException("Deleted");
    }

    protected void init(int iType) {
        Value LHS = this.getOperand(0);
        Value RHS = this.getOperand(1);
        assert (LHS.getType() == RHS.getType()) : "Binary operator operand types must match!";
        switch (iType) {
            case 11: 
            case 13: 
            case 15: {
                assert (this.getType() == LHS.getType()) : "Arithmetic operation should return same type as operands!";
                assert (this.getType().isIntOrIntVectorTy()) : "Tried to create an integer operation on a non-integer type!";
                break;
            }
            case 12: 
            case 14: 
            case 16: {
                assert (this.getType() == LHS.getType()) : "Arithmetic operation should return same type as operands!";
                assert (this.getType().isFPOrFPVectorTy()) : "Tried to create a floating-point operation on a non-floating-point type!";
                break;
            }
            case 17: 
            case 18: {
                assert (this.getType() == LHS.getType()) : "Arithmetic operation should return same type as operands!";
                assert (this.getType().isIntegerTy() || this.getType().isVectorTy() && IrRTTI.cast_VectorType(this.getType()).getElementType().isIntegerTy()) : "Incorrect operand type (not integer) for S/UDIV";
                break;
            }
            case 19: {
                assert (this.getType() == LHS.getType()) : "Arithmetic operation should return same type as operands!";
                assert (this.getType().isFPOrFPVectorTy()) : "Incorrect operand type (not floating point) for FDIV";
                break;
            }
            case 20: 
            case 21: {
                assert (this.getType() == LHS.getType()) : "Arithmetic operation should return same type as operands!";
                assert (this.getType().isIntegerTy() || this.getType().isVectorTy() && IrRTTI.cast_VectorType(this.getType()).getElementType().isIntegerTy()) : "Incorrect operand type (not integer) for S/UREM";
                break;
            }
            case 22: {
                assert (this.getType() == LHS.getType()) : "Arithmetic operation should return same type as operands!";
                assert (this.getType().isFPOrFPVectorTy()) : "Incorrect operand type (not floating point) for FREM";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                assert (this.getType() == LHS.getType()) : "Shift operation should return same type as operands!";
                assert (this.getType().isIntegerTy() || this.getType().isVectorTy() && IrRTTI.cast_VectorType(this.getType()).getElementType().isIntegerTy()) : "Tried to create a shift operation on a non-integral type!";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                assert (this.getType() == LHS.getType()) : "Logical operation should return same type as operands!";
                assert (this.getType().isIntegerTy() || this.getType().isVectorTy() && IrRTTI.cast_VectorType(this.getType()).getElementType().isIntegerTy()) : "Tried to create a logical operation on a non-integral type!";
                break;
            }
        }
    }

    protected BinaryOperator(int iType, Value S1, Value S2, Type Ty, Twine Name, Instruction InsertBefore) {
        super(Ty, iType, OperandTraitsBinaryOperator.op_begin(User.$BEING_CREATED()), OperandTraitsBinaryOperator.operands$FixedNumOperandTraits(User.$BEING_CREATED()), InsertBefore);
        this.Op(0).$assign(S1);
        this.Op(1).$assign(S2);
        this.init(iType);
        this.setName(Name);
    }

    protected BinaryOperator(int iType, Value S1, Value S2, Type Ty, Twine Name, BasicBlock InsertAtEnd) {
        super(Ty, iType, OperandTraitsBinaryOperator.op_begin(User.$BEING_CREATED()), OperandTraitsBinaryOperator.operands$FixedNumOperandTraits(User.$BEING_CREATED()), InsertAtEnd);
        this.Op(0).$assign(S1);
        this.Op(1).$assign(S2);
        this.init(iType);
        this.setName(Name);
    }

    protected BinaryOperator cloneImpl() {
        return BinaryOperator.Create(this.getOpcode(), this.Op$Const(0).$Value$P(), this.Op$Const(1).$Value$P());
    }

    public static BinaryOperator $new_BinaryOperator(NativeCallback.New.ConstructorCallback<BinaryOperator> $Ctor) {
        return User.$new_FixedUses(2, $Ctor);
    }

    @Override
    public Value getOperand(int i_nocapture) {
        assert (Unsigned.$less_uint((int)i_nocapture, (int)OperandTraitsBinaryOperator.operands$FixedNumOperandTraits(this))) : "getOperand() out of range!";
        return IrRTTI.cast_or_null_Value(((Use)OperandTraitsBinaryOperator.op_begin(this).$at(i_nocapture)).get());
    }

    @Override
    public void setOperand(int i_nocapture, Value Val_nocapture) {
        assert (Unsigned.$less_uint((int)i_nocapture, (int)OperandTraitsBinaryOperator.operands$FixedNumOperandTraits(this))) : "setOperand() out of range!";
        ((Use)OperandTraitsBinaryOperator.op_begin(this).$at(i_nocapture)).$assign(Val_nocapture);
    }

    @Override
    public type.ptr<Use> op_begin() {
        return OperandTraitsBinaryOperator.op_begin(this);
    }

    @Override
    public type.ptr<Use> op_begin$Const() {
        return OperandTraitsBinaryOperator.op_begin(this);
    }

    @Override
    public type.ptr<Use> op_end() {
        return OperandTraitsBinaryOperator.op_end(this);
    }

    @Override
    public type.ptr<Use> op_end$Const() {
        return OperandTraitsBinaryOperator.op_end(this);
    }

    @Override
    protected Use Op(int Idx_nocapture) {
        return this.OpFrom(Idx_nocapture, this);
    }

    @Override
    protected Use Op$Const(int Idx_nocapture) {
        return this.OpFrom(Idx_nocapture, this);
    }

    @Override
    public int getNumOperands() {
        return OperandTraitsBinaryOperator.operands$FixedNumOperandTraits(this);
    }

    public static BinaryOperator Create(int Op, Value S1, Value S2) {
        return BinaryOperator.Create(Op, S1, S2, new Twine(), (Instruction)null);
    }

    public static BinaryOperator Create(int Op, Value S1, Value S2, Twine Name) {
        return BinaryOperator.Create(Op, S1, S2, Name, (Instruction)null);
    }

    public static BinaryOperator Create(int Op, Value S1, Value S2, Twine Name, Instruction InsertBefore) {
        assert (S1.getType() == S2.getType()) : "Cannot create binary operator with two operands of differing type!";
        return BinaryOperator.$new_BinaryOperator((NativeCallback.New.ConstructorCallback<BinaryOperator>)((NativeCallback.New.ConstructorCallback)New$Mem -> new BinaryOperator(Op, S1, S2, S1.getType(), Name, InsertBefore)));
    }

    public static BinaryOperator Create(int Op, Value S1, Value S2, Twine Name, BasicBlock InsertAtEnd) {
        BinaryOperator Res = BinaryOperator.Create(Op, S1, S2, Name);
        InsertAtEnd.getInstList().push_back((ilist_node)Res);
        return Res;
    }

    public static BinaryOperator CreateAdd(Value V1, Value V2) {
        return BinaryOperator.CreateAdd(V1, V2, new Twine(NativePointer.$EMPTY));
    }

    public static BinaryOperator CreateAdd(Value V1, Value V2, Twine Name) {
        return BinaryOperator.Create(11, V1, V2, Name);
    }

    public static BinaryOperator CreateFAdd(Value V1, Value V2) {
        return BinaryOperator.CreateFAdd(V1, V2, new Twine(NativePointer.$EMPTY));
    }

    public static BinaryOperator CreateFAdd(Value V1, Value V2, Twine Name) {
        return BinaryOperator.Create(12, V1, V2, Name);
    }

    public static BinaryOperator CreateSub(Value V1, Value V2) {
        return BinaryOperator.CreateSub(V1, V2, new Twine(NativePointer.$EMPTY));
    }

    public static BinaryOperator CreateSub(Value V1, Value V2, Twine Name) {
        return BinaryOperator.Create(13, V1, V2, Name);
    }

    public static BinaryOperator CreateFSub(Value V1, Value V2) {
        return BinaryOperator.CreateFSub(V1, V2, new Twine(NativePointer.$EMPTY));
    }

    public static BinaryOperator CreateFSub(Value V1, Value V2, Twine Name) {
        return BinaryOperator.Create(14, V1, V2, Name);
    }

    public static BinaryOperator CreateMul(Value V1, Value V2) {
        return BinaryOperator.CreateMul(V1, V2, new Twine(NativePointer.$EMPTY));
    }

    public static BinaryOperator CreateMul(Value V1, Value V2, Twine Name) {
        return BinaryOperator.Create(15, V1, V2, Name);
    }

    public static BinaryOperator CreateFMul(Value V1, Value V2) {
        return BinaryOperator.CreateFMul(V1, V2, new Twine(NativePointer.$EMPTY));
    }

    public static BinaryOperator CreateFMul(Value V1, Value V2, Twine Name) {
        return BinaryOperator.Create(16, V1, V2, Name);
    }

    public static BinaryOperator CreateUDiv(Value V1, Value V2) {
        return BinaryOperator.CreateUDiv(V1, V2, new Twine(NativePointer.$EMPTY));
    }

    public static BinaryOperator CreateUDiv(Value V1, Value V2, Twine Name) {
        return BinaryOperator.Create(17, V1, V2, Name);
    }

    public static BinaryOperator CreateSDiv(Value V1, Value V2) {
        return BinaryOperator.CreateSDiv(V1, V2, new Twine(NativePointer.$EMPTY));
    }

    public static BinaryOperator CreateSDiv(Value V1, Value V2, Twine Name) {
        return BinaryOperator.Create(18, V1, V2, Name);
    }

    public static BinaryOperator CreateFDiv(Value V1, Value V2) {
        return BinaryOperator.CreateFDiv(V1, V2, new Twine(NativePointer.$EMPTY));
    }

    public static BinaryOperator CreateFDiv(Value V1, Value V2, Twine Name) {
        return BinaryOperator.Create(19, V1, V2, Name);
    }

    public static BinaryOperator CreateURem(Value V1, Value V2) {
        return BinaryOperator.CreateURem(V1, V2, new Twine(NativePointer.$EMPTY));
    }

    public static BinaryOperator CreateURem(Value V1, Value V2, Twine Name) {
        return BinaryOperator.Create(20, V1, V2, Name);
    }

    public static BinaryOperator CreateSRem(Value V1, Value V2) {
        return BinaryOperator.CreateSRem(V1, V2, new Twine(NativePointer.$EMPTY));
    }

    public static BinaryOperator CreateSRem(Value V1, Value V2, Twine Name) {
        return BinaryOperator.Create(21, V1, V2, Name);
    }

    public static BinaryOperator CreateFRem(Value V1, Value V2) {
        return BinaryOperator.CreateFRem(V1, V2, new Twine(NativePointer.$EMPTY));
    }

    public static BinaryOperator CreateFRem(Value V1, Value V2, Twine Name) {
        return BinaryOperator.Create(22, V1, V2, Name);
    }

    public static BinaryOperator CreateShl(Value V1, Value V2) {
        return BinaryOperator.CreateShl(V1, V2, new Twine(NativePointer.$EMPTY));
    }

    public static BinaryOperator CreateShl(Value V1, Value V2, Twine Name) {
        return BinaryOperator.Create(23, V1, V2, Name);
    }

    public static BinaryOperator CreateLShr(Value V1, Value V2) {
        return BinaryOperator.CreateLShr(V1, V2, new Twine(NativePointer.$EMPTY));
    }

    public static BinaryOperator CreateLShr(Value V1, Value V2, Twine Name) {
        return BinaryOperator.Create(24, V1, V2, Name);
    }

    public static BinaryOperator CreateAShr(Value V1, Value V2) {
        return BinaryOperator.CreateAShr(V1, V2, new Twine(NativePointer.$EMPTY));
    }

    public static BinaryOperator CreateAShr(Value V1, Value V2, Twine Name) {
        return BinaryOperator.Create(25, V1, V2, Name);
    }

    public static BinaryOperator CreateAnd(Value V1, Value V2) {
        return BinaryOperator.CreateAnd(V1, V2, new Twine(NativePointer.$EMPTY));
    }

    public static BinaryOperator CreateAnd(Value V1, Value V2, Twine Name) {
        return BinaryOperator.Create(26, V1, V2, Name);
    }

    public static BinaryOperator CreateOr(Value V1, Value V2) {
        return BinaryOperator.CreateOr(V1, V2, new Twine(NativePointer.$EMPTY));
    }

    public static BinaryOperator CreateOr(Value V1, Value V2, Twine Name) {
        return BinaryOperator.Create(27, V1, V2, Name);
    }

    public static BinaryOperator CreateXor(Value V1, Value V2) {
        return BinaryOperator.CreateXor(V1, V2, new Twine(NativePointer.$EMPTY));
    }

    public static BinaryOperator CreateXor(Value V1, Value V2, Twine Name) {
        return BinaryOperator.Create(28, V1, V2, Name);
    }

    public static BinaryOperator CreateAdd(Value V1, Value V2, Twine Name, BasicBlock BB) {
        return BinaryOperator.Create(11, V1, V2, Name, BB);
    }

    public static BinaryOperator CreateFAdd(Value V1, Value V2, Twine Name, BasicBlock BB) {
        return BinaryOperator.Create(12, V1, V2, Name, BB);
    }

    public static BinaryOperator CreateSub(Value V1, Value V2, Twine Name, BasicBlock BB) {
        return BinaryOperator.Create(13, V1, V2, Name, BB);
    }

    public static BinaryOperator CreateFSub(Value V1, Value V2, Twine Name, BasicBlock BB) {
        return BinaryOperator.Create(14, V1, V2, Name, BB);
    }

    public static BinaryOperator CreateMul(Value V1, Value V2, Twine Name, BasicBlock BB) {
        return BinaryOperator.Create(15, V1, V2, Name, BB);
    }

    public static BinaryOperator CreateFMul(Value V1, Value V2, Twine Name, BasicBlock BB) {
        return BinaryOperator.Create(16, V1, V2, Name, BB);
    }

    public static BinaryOperator CreateUDiv(Value V1, Value V2, Twine Name, BasicBlock BB) {
        return BinaryOperator.Create(17, V1, V2, Name, BB);
    }

    public static BinaryOperator CreateSDiv(Value V1, Value V2, Twine Name, BasicBlock BB) {
        return BinaryOperator.Create(18, V1, V2, Name, BB);
    }

    public static BinaryOperator CreateFDiv(Value V1, Value V2, Twine Name, BasicBlock BB) {
        return BinaryOperator.Create(19, V1, V2, Name, BB);
    }

    public static BinaryOperator CreateURem(Value V1, Value V2, Twine Name, BasicBlock BB) {
        return BinaryOperator.Create(20, V1, V2, Name, BB);
    }

    public static BinaryOperator CreateSRem(Value V1, Value V2, Twine Name, BasicBlock BB) {
        return BinaryOperator.Create(21, V1, V2, Name, BB);
    }

    public static BinaryOperator CreateFRem(Value V1, Value V2, Twine Name, BasicBlock BB) {
        return BinaryOperator.Create(22, V1, V2, Name, BB);
    }

    public static BinaryOperator CreateShl(Value V1, Value V2, Twine Name, BasicBlock BB) {
        return BinaryOperator.Create(23, V1, V2, Name, BB);
    }

    public static BinaryOperator CreateLShr(Value V1, Value V2, Twine Name, BasicBlock BB) {
        return BinaryOperator.Create(24, V1, V2, Name, BB);
    }

    public static BinaryOperator CreateAShr(Value V1, Value V2, Twine Name, BasicBlock BB) {
        return BinaryOperator.Create(25, V1, V2, Name, BB);
    }

    public static BinaryOperator CreateAnd(Value V1, Value V2, Twine Name, BasicBlock BB) {
        return BinaryOperator.Create(26, V1, V2, Name, BB);
    }

    public static BinaryOperator CreateOr(Value V1, Value V2, Twine Name, BasicBlock BB) {
        return BinaryOperator.Create(27, V1, V2, Name, BB);
    }

    public static BinaryOperator CreateXor(Value V1, Value V2, Twine Name, BasicBlock BB) {
        return BinaryOperator.Create(28, V1, V2, Name, BB);
    }

    public static BinaryOperator CreateAdd(Value V1, Value V2, Twine Name, Instruction I) {
        return BinaryOperator.Create(11, V1, V2, Name, I);
    }

    public static BinaryOperator CreateFAdd(Value V1, Value V2, Twine Name, Instruction I) {
        return BinaryOperator.Create(12, V1, V2, Name, I);
    }

    public static BinaryOperator CreateSub(Value V1, Value V2, Twine Name, Instruction I) {
        return BinaryOperator.Create(13, V1, V2, Name, I);
    }

    public static BinaryOperator CreateFSub(Value V1, Value V2, Twine Name, Instruction I) {
        return BinaryOperator.Create(14, V1, V2, Name, I);
    }

    public static BinaryOperator CreateMul(Value V1, Value V2, Twine Name, Instruction I) {
        return BinaryOperator.Create(15, V1, V2, Name, I);
    }

    public static BinaryOperator CreateFMul(Value V1, Value V2, Twine Name, Instruction I) {
        return BinaryOperator.Create(16, V1, V2, Name, I);
    }

    public static BinaryOperator CreateUDiv(Value V1, Value V2, Twine Name, Instruction I) {
        return BinaryOperator.Create(17, V1, V2, Name, I);
    }

    public static BinaryOperator CreateSDiv(Value V1, Value V2, Twine Name, Instruction I) {
        return BinaryOperator.Create(18, V1, V2, Name, I);
    }

    public static BinaryOperator CreateFDiv(Value V1, Value V2, Twine Name, Instruction I) {
        return BinaryOperator.Create(19, V1, V2, Name, I);
    }

    public static BinaryOperator CreateURem(Value V1, Value V2, Twine Name, Instruction I) {
        return BinaryOperator.Create(20, V1, V2, Name, I);
    }

    public static BinaryOperator CreateSRem(Value V1, Value V2, Twine Name, Instruction I) {
        return BinaryOperator.Create(21, V1, V2, Name, I);
    }

    public static BinaryOperator CreateFRem(Value V1, Value V2, Twine Name, Instruction I) {
        return BinaryOperator.Create(22, V1, V2, Name, I);
    }

    public static BinaryOperator CreateShl(Value V1, Value V2, Twine Name, Instruction I) {
        return BinaryOperator.Create(23, V1, V2, Name, I);
    }

    public static BinaryOperator CreateLShr(Value V1, Value V2, Twine Name, Instruction I) {
        return BinaryOperator.Create(24, V1, V2, Name, I);
    }

    public static BinaryOperator CreateAShr(Value V1, Value V2, Twine Name, Instruction I) {
        return BinaryOperator.Create(25, V1, V2, Name, I);
    }

    public static BinaryOperator CreateAnd(Value V1, Value V2, Twine Name, Instruction I) {
        return BinaryOperator.Create(26, V1, V2, Name, I);
    }

    public static BinaryOperator CreateOr(Value V1, Value V2, Twine Name, Instruction I) {
        return BinaryOperator.Create(27, V1, V2, Name, I);
    }

    public static BinaryOperator CreateXor(Value V1, Value V2, Twine Name, Instruction I) {
        return BinaryOperator.Create(28, V1, V2, Name, I);
    }

    public static BinaryOperator CreateWithCopiedFlags(int Opc, Value V1, Value V2, BinaryOperator CopyBO) {
        return BinaryOperator.CreateWithCopiedFlags(Opc, V1, V2, CopyBO, new Twine(NativePointer.$EMPTY));
    }

    public static BinaryOperator CreateWithCopiedFlags(int Opc, Value V1, Value V2, BinaryOperator CopyBO, Twine Name) {
        BinaryOperator BO = BinaryOperator.Create(Opc, V1, V2, Name);
        BO.copyIRFlags(CopyBO);
        return BO;
    }

    public static BinaryOperator CreateNSW(int Opc, Value V1, Value V2) {
        return BinaryOperator.CreateNSW(Opc, V1, V2, new Twine(NativePointer.$EMPTY));
    }

    public static BinaryOperator CreateNSW(int Opc, Value V1, Value V2, Twine Name) {
        BinaryOperator BO = BinaryOperator.Create(Opc, V1, V2, Name);
        BO.setHasNoSignedWrap(true);
        return BO;
    }

    public static BinaryOperator CreateNSW(int Opc, Value V1, Value V2, Twine Name, BasicBlock BB) {
        BinaryOperator BO = BinaryOperator.Create(Opc, V1, V2, Name, BB);
        BO.setHasNoSignedWrap(true);
        return BO;
    }

    public static BinaryOperator CreateNSW(int Opc, Value V1, Value V2, Twine Name, Instruction I) {
        BinaryOperator BO = BinaryOperator.Create(Opc, V1, V2, Name, I);
        BO.setHasNoSignedWrap(true);
        return BO;
    }

    public static BinaryOperator CreateNUW(int Opc, Value V1, Value V2) {
        return BinaryOperator.CreateNUW(Opc, V1, V2, new Twine(NativePointer.$EMPTY));
    }

    public static BinaryOperator CreateNUW(int Opc, Value V1, Value V2, Twine Name) {
        BinaryOperator BO = BinaryOperator.Create(Opc, V1, V2, Name);
        BO.setHasNoUnsignedWrap(true);
        return BO;
    }

    public static BinaryOperator CreateNUW(int Opc, Value V1, Value V2, Twine Name, BasicBlock BB) {
        BinaryOperator BO = BinaryOperator.Create(Opc, V1, V2, Name, BB);
        BO.setHasNoUnsignedWrap(true);
        return BO;
    }

    public static BinaryOperator CreateNUW(int Opc, Value V1, Value V2, Twine Name, Instruction I) {
        BinaryOperator BO = BinaryOperator.Create(Opc, V1, V2, Name, I);
        BO.setHasNoUnsignedWrap(true);
        return BO;
    }

    public static BinaryOperator CreateExact(int Opc, Value V1, Value V2) {
        return BinaryOperator.CreateExact(Opc, V1, V2, new Twine(NativePointer.$EMPTY));
    }

    public static BinaryOperator CreateExact(int Opc, Value V1, Value V2, Twine Name) {
        BinaryOperator BO = BinaryOperator.Create(Opc, V1, V2, Name);
        BO.setIsExact(true);
        return BO;
    }

    public static BinaryOperator CreateExact(int Opc, Value V1, Value V2, Twine Name, BasicBlock BB) {
        BinaryOperator BO = BinaryOperator.Create(Opc, V1, V2, Name, BB);
        BO.setIsExact(true);
        return BO;
    }

    public static BinaryOperator CreateExact(int Opc, Value V1, Value V2, Twine Name, Instruction I) {
        BinaryOperator BO = BinaryOperator.Create(Opc, V1, V2, Name, I);
        BO.setIsExact(true);
        return BO;
    }

    public static BinaryOperator CreateNSWAdd(Value V1, Value V2) {
        return BinaryOperator.CreateNSWAdd(V1, V2, new Twine(NativePointer.$EMPTY));
    }

    public static BinaryOperator CreateNSWAdd(Value V1, Value V2, Twine Name) {
        return BinaryOperator.CreateNSW(11, V1, V2, Name);
    }

    public static BinaryOperator CreateNSWAdd(Value V1, Value V2, Twine Name, BasicBlock BB) {
        return BinaryOperator.CreateNSW(11, V1, V2, Name, BB);
    }

    public static BinaryOperator CreateNSWAdd(Value V1, Value V2, Twine Name, Instruction I) {
        return BinaryOperator.CreateNSW(11, V1, V2, Name, I);
    }

    public static BinaryOperator CreateNUWAdd(Value V1, Value V2) {
        return BinaryOperator.CreateNUWAdd(V1, V2, new Twine(NativePointer.$EMPTY));
    }

    public static BinaryOperator CreateNUWAdd(Value V1, Value V2, Twine Name) {
        return BinaryOperator.CreateNUW(11, V1, V2, Name);
    }

    public static BinaryOperator CreateNUWAdd(Value V1, Value V2, Twine Name, BasicBlock BB) {
        return BinaryOperator.CreateNUW(11, V1, V2, Name, BB);
    }

    public static BinaryOperator CreateNUWAdd(Value V1, Value V2, Twine Name, Instruction I) {
        return BinaryOperator.CreateNUW(11, V1, V2, Name, I);
    }

    public static BinaryOperator CreateNSWSub(Value V1, Value V2) {
        return BinaryOperator.CreateNSWSub(V1, V2, new Twine(NativePointer.$EMPTY));
    }

    public static BinaryOperator CreateNSWSub(Value V1, Value V2, Twine Name) {
        return BinaryOperator.CreateNSW(13, V1, V2, Name);
    }

    public static BinaryOperator CreateNSWSub(Value V1, Value V2, Twine Name, BasicBlock BB) {
        return BinaryOperator.CreateNSW(13, V1, V2, Name, BB);
    }

    public static BinaryOperator CreateNSWSub(Value V1, Value V2, Twine Name, Instruction I) {
        return BinaryOperator.CreateNSW(13, V1, V2, Name, I);
    }

    public static BinaryOperator CreateNUWSub(Value V1, Value V2) {
        return BinaryOperator.CreateNUWSub(V1, V2, new Twine(NativePointer.$EMPTY));
    }

    public static BinaryOperator CreateNUWSub(Value V1, Value V2, Twine Name) {
        return BinaryOperator.CreateNUW(13, V1, V2, Name);
    }

    public static BinaryOperator CreateNUWSub(Value V1, Value V2, Twine Name, BasicBlock BB) {
        return BinaryOperator.CreateNUW(13, V1, V2, Name, BB);
    }

    public static BinaryOperator CreateNUWSub(Value V1, Value V2, Twine Name, Instruction I) {
        return BinaryOperator.CreateNUW(13, V1, V2, Name, I);
    }

    public static BinaryOperator CreateNSWMul(Value V1, Value V2) {
        return BinaryOperator.CreateNSWMul(V1, V2, new Twine(NativePointer.$EMPTY));
    }

    public static BinaryOperator CreateNSWMul(Value V1, Value V2, Twine Name) {
        return BinaryOperator.CreateNSW(15, V1, V2, Name);
    }

    public static BinaryOperator CreateNSWMul(Value V1, Value V2, Twine Name, BasicBlock BB) {
        return BinaryOperator.CreateNSW(15, V1, V2, Name, BB);
    }

    public static BinaryOperator CreateNSWMul(Value V1, Value V2, Twine Name, Instruction I) {
        return BinaryOperator.CreateNSW(15, V1, V2, Name, I);
    }

    public static BinaryOperator CreateNUWMul(Value V1, Value V2) {
        return BinaryOperator.CreateNUWMul(V1, V2, new Twine(NativePointer.$EMPTY));
    }

    public static BinaryOperator CreateNUWMul(Value V1, Value V2, Twine Name) {
        return BinaryOperator.CreateNUW(15, V1, V2, Name);
    }

    public static BinaryOperator CreateNUWMul(Value V1, Value V2, Twine Name, BasicBlock BB) {
        return BinaryOperator.CreateNUW(15, V1, V2, Name, BB);
    }

    public static BinaryOperator CreateNUWMul(Value V1, Value V2, Twine Name, Instruction I) {
        return BinaryOperator.CreateNUW(15, V1, V2, Name, I);
    }

    public static BinaryOperator CreateNSWShl(Value V1, Value V2) {
        return BinaryOperator.CreateNSWShl(V1, V2, new Twine(NativePointer.$EMPTY));
    }

    public static BinaryOperator CreateNSWShl(Value V1, Value V2, Twine Name) {
        return BinaryOperator.CreateNSW(23, V1, V2, Name);
    }

    public static BinaryOperator CreateNSWShl(Value V1, Value V2, Twine Name, BasicBlock BB) {
        return BinaryOperator.CreateNSW(23, V1, V2, Name, BB);
    }

    public static BinaryOperator CreateNSWShl(Value V1, Value V2, Twine Name, Instruction I) {
        return BinaryOperator.CreateNSW(23, V1, V2, Name, I);
    }

    public static BinaryOperator CreateNUWShl(Value V1, Value V2) {
        return BinaryOperator.CreateNUWShl(V1, V2, new Twine(NativePointer.$EMPTY));
    }

    public static BinaryOperator CreateNUWShl(Value V1, Value V2, Twine Name) {
        return BinaryOperator.CreateNUW(23, V1, V2, Name);
    }

    public static BinaryOperator CreateNUWShl(Value V1, Value V2, Twine Name, BasicBlock BB) {
        return BinaryOperator.CreateNUW(23, V1, V2, Name, BB);
    }

    public static BinaryOperator CreateNUWShl(Value V1, Value V2, Twine Name, Instruction I) {
        return BinaryOperator.CreateNUW(23, V1, V2, Name, I);
    }

    public static BinaryOperator CreateExactSDiv(Value V1, Value V2) {
        return BinaryOperator.CreateExactSDiv(V1, V2, new Twine(NativePointer.$EMPTY));
    }

    public static BinaryOperator CreateExactSDiv(Value V1, Value V2, Twine Name) {
        return BinaryOperator.CreateExact(18, V1, V2, Name);
    }

    public static BinaryOperator CreateExactSDiv(Value V1, Value V2, Twine Name, BasicBlock BB) {
        return BinaryOperator.CreateExact(18, V1, V2, Name, BB);
    }

    public static BinaryOperator CreateExactSDiv(Value V1, Value V2, Twine Name, Instruction I) {
        return BinaryOperator.CreateExact(18, V1, V2, Name, I);
    }

    public static BinaryOperator CreateExactUDiv(Value V1, Value V2) {
        return BinaryOperator.CreateExactUDiv(V1, V2, new Twine(NativePointer.$EMPTY));
    }

    public static BinaryOperator CreateExactUDiv(Value V1, Value V2, Twine Name) {
        return BinaryOperator.CreateExact(17, V1, V2, Name);
    }

    public static BinaryOperator CreateExactUDiv(Value V1, Value V2, Twine Name, BasicBlock BB) {
        return BinaryOperator.CreateExact(17, V1, V2, Name, BB);
    }

    public static BinaryOperator CreateExactUDiv(Value V1, Value V2, Twine Name, Instruction I) {
        return BinaryOperator.CreateExact(17, V1, V2, Name, I);
    }

    public static BinaryOperator CreateExactAShr(Value V1, Value V2) {
        return BinaryOperator.CreateExactAShr(V1, V2, new Twine(NativePointer.$EMPTY));
    }

    public static BinaryOperator CreateExactAShr(Value V1, Value V2, Twine Name) {
        return BinaryOperator.CreateExact(25, V1, V2, Name);
    }

    public static BinaryOperator CreateExactAShr(Value V1, Value V2, Twine Name, BasicBlock BB) {
        return BinaryOperator.CreateExact(25, V1, V2, Name, BB);
    }

    public static BinaryOperator CreateExactAShr(Value V1, Value V2, Twine Name, Instruction I) {
        return BinaryOperator.CreateExact(25, V1, V2, Name, I);
    }

    public static BinaryOperator CreateExactLShr(Value V1, Value V2) {
        return BinaryOperator.CreateExactLShr(V1, V2, new Twine(NativePointer.$EMPTY));
    }

    public static BinaryOperator CreateExactLShr(Value V1, Value V2, Twine Name) {
        return BinaryOperator.CreateExact(24, V1, V2, Name);
    }

    public static BinaryOperator CreateExactLShr(Value V1, Value V2, Twine Name, BasicBlock BB) {
        return BinaryOperator.CreateExact(24, V1, V2, Name, BB);
    }

    public static BinaryOperator CreateExactLShr(Value V1, Value V2, Twine Name, Instruction I) {
        return BinaryOperator.CreateExact(24, V1, V2, Name, I);
    }

    public static BinaryOperator CreateNeg(Value Op) {
        return BinaryOperator.CreateNeg(Op, new Twine(NativePointer.$EMPTY), (Instruction)null);
    }

    public static BinaryOperator CreateNeg(Value Op, Twine Name) {
        return BinaryOperator.CreateNeg(Op, Name, (Instruction)null);
    }

    public static BinaryOperator CreateNeg(Value Op, Twine Name, Instruction InsertBefore) {
        Constant zero = ConstantFP.getZeroValueForNegation(Op.getType());
        return BinaryOperator.$new_BinaryOperator((NativeCallback.New.ConstructorCallback<BinaryOperator>)((NativeCallback.New.ConstructorCallback)New$Mem -> new BinaryOperator(13, zero, Op, Op.getType(), Name, InsertBefore)));
    }

    public static BinaryOperator CreateNeg(Value Op, Twine Name, BasicBlock InsertAtEnd) {
        Constant zero = ConstantFP.getZeroValueForNegation(Op.getType());
        return BinaryOperator.$new_BinaryOperator((NativeCallback.New.ConstructorCallback<BinaryOperator>)((NativeCallback.New.ConstructorCallback)New$Mem -> new BinaryOperator(13, zero, Op, Op.getType(), Name, InsertAtEnd)));
    }

    public static BinaryOperator CreateNSWNeg(Value Op) {
        return BinaryOperator.CreateNSWNeg(Op, new Twine(NativePointer.$EMPTY), (Instruction)null);
    }

    public static BinaryOperator CreateNSWNeg(Value Op, Twine Name) {
        return BinaryOperator.CreateNSWNeg(Op, Name, (Instruction)null);
    }

    public static BinaryOperator CreateNSWNeg(Value Op, Twine Name, Instruction InsertBefore) {
        Constant zero = ConstantFP.getZeroValueForNegation(Op.getType());
        return BinaryOperator.CreateNSWSub((Value)zero, Op, Name, InsertBefore);
    }

    public static BinaryOperator CreateNSWNeg(Value Op, Twine Name, BasicBlock InsertAtEnd) {
        Constant zero = ConstantFP.getZeroValueForNegation(Op.getType());
        return BinaryOperator.CreateNSWSub((Value)zero, Op, Name, InsertAtEnd);
    }

    public static BinaryOperator CreateNUWNeg(Value Op) {
        return BinaryOperator.CreateNUWNeg(Op, new Twine(NativePointer.$EMPTY), (Instruction)null);
    }

    public static BinaryOperator CreateNUWNeg(Value Op, Twine Name) {
        return BinaryOperator.CreateNUWNeg(Op, Name, (Instruction)null);
    }

    public static BinaryOperator CreateNUWNeg(Value Op, Twine Name, Instruction InsertBefore) {
        Constant zero = ConstantFP.getZeroValueForNegation(Op.getType());
        return BinaryOperator.CreateNUWSub((Value)zero, Op, Name, InsertBefore);
    }

    public static BinaryOperator CreateNUWNeg(Value Op, Twine Name, BasicBlock InsertAtEnd) {
        Constant zero = ConstantFP.getZeroValueForNegation(Op.getType());
        return BinaryOperator.CreateNUWSub((Value)zero, Op, Name, InsertAtEnd);
    }

    public static BinaryOperator CreateFNeg(Value Op) {
        return BinaryOperator.CreateFNeg(Op, new Twine(NativePointer.$EMPTY), (Instruction)null);
    }

    public static BinaryOperator CreateFNeg(Value Op, Twine Name) {
        return BinaryOperator.CreateFNeg(Op, Name, (Instruction)null);
    }

    public static BinaryOperator CreateFNeg(Value Op, Twine Name, Instruction InsertBefore) {
        Constant zero = ConstantFP.getZeroValueForNegation(Op.getType());
        return BinaryOperator.$new_BinaryOperator((NativeCallback.New.ConstructorCallback<BinaryOperator>)((NativeCallback.New.ConstructorCallback)New$Mem -> new BinaryOperator(14, zero, Op, Op.getType(), Name, InsertBefore)));
    }

    public static BinaryOperator CreateFNeg(Value Op, Twine Name, BasicBlock InsertAtEnd) {
        Constant zero = ConstantFP.getZeroValueForNegation(Op.getType());
        return BinaryOperator.$new_BinaryOperator((NativeCallback.New.ConstructorCallback<BinaryOperator>)((NativeCallback.New.ConstructorCallback)New$Mem -> new BinaryOperator(14, zero, Op, Op.getType(), Name, InsertAtEnd)));
    }

    public static BinaryOperator CreateNot(Value Op) {
        return BinaryOperator.CreateNot(Op, new Twine(NativePointer.$EMPTY), (Instruction)null);
    }

    public static BinaryOperator CreateNot(Value Op, Twine Name) {
        return BinaryOperator.CreateNot(Op, Name, (Instruction)null);
    }

    public static BinaryOperator CreateNot(Value Op, Twine Name, Instruction InsertBefore) {
        Constant C2 = Constant.getAllOnesValue(Op.getType());
        return BinaryOperator.$new_BinaryOperator((NativeCallback.New.ConstructorCallback<BinaryOperator>)((NativeCallback.New.ConstructorCallback)New$Mem -> new BinaryOperator(28, Op, (Value)C2, Op.getType(), Name, InsertBefore)));
    }

    public static BinaryOperator CreateNot(Value Op, Twine Name, BasicBlock InsertAtEnd) {
        Constant AllOnes = Constant.getAllOnesValue(Op.getType());
        return BinaryOperator.$new_BinaryOperator((NativeCallback.New.ConstructorCallback<BinaryOperator>)((NativeCallback.New.ConstructorCallback)New$Mem -> new BinaryOperator(28, Op, (Value)AllOnes, Op.getType(), Name, InsertAtEnd)));
    }

    public static boolean isNeg(Value V) {
        Constant C2;
        BinaryOperator Bop = IrRTTI.dyn_cast_BinaryOperator(V);
        if (Bop != null && Bop.getOpcode() == 13 && (C2 = IrRTTI.dyn_cast_Constant(Bop.getOperand(0))) != null) {
            return C2.isNegativeZeroValue();
        }
        return false;
    }

    public static boolean isFNeg(Value V) {
        return BinaryOperator.isFNeg(V, false);
    }

    public static boolean isFNeg(Value V, boolean IgnoreZeroSign) {
        Constant C2;
        BinaryOperator Bop = IrRTTI.dyn_cast_BinaryOperator(V);
        if (Bop != null && Bop.getOpcode() == 14 && (C2 = IrRTTI.dyn_cast_Constant(Bop.getOperand(0))) != null) {
            if (!IgnoreZeroSign) {
                IgnoreZeroSign = IrRTTI.cast_Instruction(V).hasNoSignedZeros();
            }
            return !IgnoreZeroSign ? C2.isNegativeZeroValue() : C2.isZeroValue();
        }
        return false;
    }

    public static boolean isNot(Value V) {
        BinaryOperator Bop = IrRTTI.dyn_cast_BinaryOperator(V);
        if (Bop != null) {
            return Bop.getOpcode() == 28 && (InstructionsStatics.isConstantAllOnes(Bop.getOperand(1)) || InstructionsStatics.isConstantAllOnes(Bop.getOperand(0)));
        }
        return false;
    }

    public static Value getNegArgument_Value$C$P(Value BinOp2) {
        return BinaryOperator.getNegArgument_Value$P(BinOp2);
    }

    public static Value getNegArgument_Value$P(Value BinOp2) {
        return IrRTTI.cast_BinaryOperator(BinOp2).getOperand(1);
    }

    public static Value getFNegArgument_Value$C$P(Value BinOp2) {
        return BinaryOperator.getFNegArgument_Value$P(BinOp2);
    }

    public static Value getFNegArgument_Value$P(Value BinOp2) {
        return IrRTTI.cast_BinaryOperator(BinOp2).getOperand(1);
    }

    public static Value getNotArgument_Value$C$P(Value BinOp2) {
        return BinaryOperator.getNotArgument_Value$P(BinOp2);
    }

    public static Value getNotArgument_Value$P(Value BinOp2) {
        assert (BinaryOperator.isNot(BinOp2)) : "getNotArgument on non-'not' instruction!";
        BinaryOperator BO = IrRTTI.cast_BinaryOperator(BinOp2);
        Value Op0 = BO.getOperand(0);
        Value Op1 = BO.getOperand(1);
        if (InstructionsStatics.isConstantAllOnes(Op0)) {
            return Op1;
        }
        assert (InstructionsStatics.isConstantAllOnes(Op1));
        return Op0;
    }

    @Override
    public int getOpcode() {
        return super.getOpcode();
    }

    public boolean swapOperands() {
        if (!this.isCommutative()) {
            return true;
        }
        this.Op(0).swap(this.Op(1));
        return false;
    }

    public static boolean classof(Instruction I) {
        return I.isBinaryOp();
    }

    public static boolean classof(Value V) {
        return IrRTTI.isa_Instruction(V) && BinaryOperator.classof(IrRTTI.cast_Instruction(V));
    }

    @Override
    public void $destroy() {
        super.$destroy();
    }

    @Override
    public String toString() {
        return "" + super.toString();
    }
}

