/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.clank.java.std;
import org.clank.java.std_map;
import org.clank.java.std_pair;
import org.clank.java.stdimpl.aliases.StdMapTypeType;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.Unsigned;
import org.clank.support.aliases.type;
import org.clank.support.void;
import org.llvm.adt.ADTAliases;
import org.llvm.adt.StringRef;
import org.llvm.adt.iterator_range;
import org.llvm.ir.Attribute;
import org.llvm.ir.AttributeSet;
import org.llvm.ir.impl.AttributeImpl;
import org.llvm.ir.impl.AttributeSetImpl;
import org.llvm.ir.impl.AttributesStatics;
import org.llvm.support.llvm;

public class AttrBuilder
implements Destructors.ClassWithDestructor,
Native.NativeComparable<AttrBuilder> {
    private std.bitset Attrs;
    private std_map.mapTypeType<std.string, std.string> TargetDepAttrs;
    private long Alignment;
    private long StackAlignment;
    private long DerefBytes;
    private long DerefOrNullBytes;
    private long AllocSizeArgs;

    public AttrBuilder() {
        this.Attrs = new std.bitset(Attribute.AttrKind.EndAttrKinds.getValue());
        this.TargetDepAttrs = new std_map.mapTypeType((Object)std.string.EMPTY);
        this.Alignment = Unsigned.$int2ulong((int)0);
        this.StackAlignment = Unsigned.$int2ulong((int)0);
        this.DerefBytes = Unsigned.$int2ulong((int)0);
        this.DerefOrNullBytes = Unsigned.$int2ulong((int)0);
        this.AllocSizeArgs = Unsigned.$int2ulong((int)0);
    }

    public AttrBuilder(long Val) {
        this.Attrs = new std.bitset(Attribute.AttrKind.EndAttrKinds.getValue());
        this.TargetDepAttrs = new std_map.mapTypeType((Object)std.string.EMPTY);
        this.Alignment = Unsigned.$int2ulong((int)0);
        this.StackAlignment = Unsigned.$int2ulong((int)0);
        this.DerefBytes = Unsigned.$int2ulong((int)0);
        this.DerefOrNullBytes = Unsigned.$int2ulong((int)0);
        this.AllocSizeArgs = Unsigned.$int2ulong((int)0);
        this.addRawValue(Val);
    }

    public AttrBuilder(Attribute A2) {
        this.Attrs = new std.bitset(Attribute.AttrKind.EndAttrKinds.getValue());
        this.TargetDepAttrs = new std_map.mapTypeType((Object)std.string.EMPTY);
        this.Alignment = Unsigned.$int2ulong((int)0);
        this.StackAlignment = Unsigned.$int2ulong((int)0);
        this.DerefBytes = Unsigned.$int2ulong((int)0);
        this.DerefOrNullBytes = Unsigned.$int2ulong((int)0);
        this.AllocSizeArgs = Unsigned.$int2ulong((int)0);
        this.addAttribute(new Attribute(A2));
    }

    public AttrBuilder(AttributeSet AS, int Index) {
        this.Attrs = new std.bitset(Attribute.AttrKind.EndAttrKinds.getValue());
        this.TargetDepAttrs = new std_map.mapTypeType((Object)std.string.EMPTY);
        this.Alignment = Unsigned.$int2ulong((int)0);
        this.StackAlignment = Unsigned.$int2ulong((int)0);
        this.DerefBytes = Unsigned.$int2ulong((int)0);
        this.DerefOrNullBytes = Unsigned.$int2ulong((int)0);
        this.AllocSizeArgs = Unsigned.$int2ulong((int)0);
        AttributeSetImpl pImpl = AS.pImpl;
        if (pImpl == null) {
            return;
        }
        int E = pImpl.getNumSlots();
        for (int I = 0; I != E; ++I) {
            if (pImpl.getSlotIndex(I) != Index) continue;
            type.ptr II = (type.ptr)Native.$tryClone(pImpl.begin(I));
            type.ptr IE = (type.ptr)Native.$tryClone(pImpl.end(I));
            while (Native.$noteq_ptr((void.ptr)II, (void.ptr)IE)) {
                this.addAttribute(new Attribute((Attribute)II.$star()));
                II.$preInc();
            }
            break;
        }
    }

    public void clear() {
        this.Attrs.reset();
        this.TargetDepAttrs.clear();
        this.DerefBytes = this.DerefOrNullBytes = Unsigned.$int2ulong((int)0);
        this.StackAlignment = this.DerefOrNullBytes;
        this.Alignment = this.DerefOrNullBytes;
        this.AllocSizeArgs = Unsigned.$int2ulong((int)0);
    }

    public AttrBuilder addAttribute(Attribute.AttrKind Val) {
        assert (Unsigned.$less_uint((int)Val.getValue(), (int)Attribute.AttrKind.EndAttrKinds.getValue())) : "Attribute out of range!";
        assert (Val != Attribute.AttrKind.Alignment && Val != Attribute.AttrKind.StackAlignment && Val != Attribute.AttrKind.Dereferenceable && Val != Attribute.AttrKind.AllocSize) : "Adding integer attribute without adding a value!";
        this.Attrs.set(Val.getValue(), true);
        return this;
    }

    public AttrBuilder addAttribute(Attribute Attr) {
        if (Attr.isStringAttribute()) {
            this.addAttribute(Attr.getKindAsString(), Attr.getValueAsString());
            return this;
        }
        Attribute.AttrKind Kind2 = Attr.getKindAsEnum();
        this.Attrs.set(Kind2.getValue(), true);
        if (Kind2 == Attribute.AttrKind.Alignment) {
            this.Alignment = Unsigned.$uint2ulong((int)Attr.getAlignment());
        } else if (Kind2 == Attribute.AttrKind.StackAlignment) {
            this.StackAlignment = Unsigned.$uint2ulong((int)Attr.getStackAlignment());
        } else if (Kind2 == Attribute.AttrKind.Dereferenceable) {
            this.DerefBytes = Attr.getDereferenceableBytes();
        } else if (Kind2 == Attribute.AttrKind.DereferenceableOrNull) {
            this.DerefOrNullBytes = Attr.getDereferenceableOrNullBytes();
        } else if (Kind2 == Attribute.AttrKind.AllocSize) {
            this.AllocSizeArgs = Attr.getValueAsInt();
        }
        return this;
    }

    public AttrBuilder addAttribute(StringRef A2) {
        return this.addAttribute(A2, new StringRef());
    }

    public AttrBuilder addAttribute(StringRef A2, StringRef V) {
        ((std.string)this.TargetDepAttrs.$at_T$RR((Object)A2.$string())).$assignMove(V.$string());
        return this;
    }

    public AttrBuilder removeAttribute(Attribute.AttrKind Val) {
        assert (Unsigned.$less_uint((int)Val.getValue(), (int)Attribute.AttrKind.EndAttrKinds.getValue())) : "Attribute out of range!";
        this.Attrs.set(Val.getValue(), false);
        if (Val == Attribute.AttrKind.Alignment) {
            this.Alignment = Unsigned.$int2ulong((int)0);
        } else if (Val == Attribute.AttrKind.StackAlignment) {
            this.StackAlignment = Unsigned.$int2ulong((int)0);
        } else if (Val == Attribute.AttrKind.Dereferenceable) {
            this.DerefBytes = Unsigned.$int2ulong((int)0);
        } else if (Val == Attribute.AttrKind.DereferenceableOrNull) {
            this.DerefOrNullBytes = Unsigned.$int2ulong((int)0);
        } else if (Val == Attribute.AttrKind.AllocSize) {
            this.AllocSizeArgs = Unsigned.$int2ulong((int)0);
        }
        return this;
    }

    public AttrBuilder removeAttributes(AttributeSet A2, long Index) {
        int Slot = -1;
        int E = A2.getNumSlots();
        for (int I = 0; I != E; ++I) {
            if (Unsigned.$uint2ullong((int)A2.getSlotIndex(I)) != Index) continue;
            Slot = I;
            break;
        }
        assert (Slot != -1) : "Couldn't find index in AttributeSet!";
        type.ptr I = (type.ptr)Native.$tryClone(A2.begin(Slot));
        type.ptr E2 = (type.ptr)Native.$tryClone(A2.end(Slot));
        while (Native.$noteq_ptr((void.ptr)I, (void.ptr)E2)) {
            Attribute Attr = new Attribute((Attribute)I.$star());
            if (Attr.isEnumAttribute() || Attr.isIntAttribute()) {
                this.removeAttribute(Attr.getKindAsEnum());
            } else {
                assert (Attr.isStringAttribute()) : "Invalid attribute type!";
                this.removeAttribute(Attr.getKindAsString());
            }
            I.$preInc();
        }
        return this;
    }

    public AttrBuilder removeAttribute(StringRef A2) {
        StdMapTypeType.iterator I = this.TargetDepAttrs.find((Object)A2.$string());
        if (I.$noteq((Object)this.TargetDepAttrs.end())) {
            this.TargetDepAttrs.erase(new StdMapTypeType.iterator(I));
        }
        return this;
    }

    public AttrBuilder merge(AttrBuilder B2) {
        if (this.Alignment == 0L) {
            this.Alignment = B2.Alignment;
        }
        if (this.StackAlignment == 0L) {
            this.StackAlignment = B2.StackAlignment;
        }
        if (this.DerefBytes == 0L) {
            this.DerefBytes = B2.DerefBytes;
        }
        if (this.DerefOrNullBytes == 0L) {
            this.DerefOrNullBytes = B2.DerefOrNullBytes;
        }
        if (this.AllocSizeArgs == 0L) {
            this.AllocSizeArgs = B2.AllocSizeArgs;
        }
        this.Attrs.$orassign(B2.Attrs);
        for (std_pair.pair I : B2.td_attrs$Const()) {
            ((std.string)this.TargetDepAttrs.$at_T$C$R((Object)((std.string)I.first))).$assign((std.string)I.second);
        }
        return this;
    }

    public AttrBuilder remove(AttrBuilder B2) {
        if (B2.Alignment != 0L) {
            this.Alignment = Unsigned.$int2ulong((int)0);
        }
        if (B2.StackAlignment != 0L) {
            this.StackAlignment = Unsigned.$int2ulong((int)0);
        }
        if (B2.DerefBytes != 0L) {
            this.DerefBytes = Unsigned.$int2ulong((int)0);
        }
        if (B2.DerefOrNullBytes != 0L) {
            this.DerefOrNullBytes = Unsigned.$int2ulong((int)0);
        }
        if (B2.AllocSizeArgs != 0L) {
            this.AllocSizeArgs = Unsigned.$int2ulong((int)0);
        }
        this.Attrs.$andassign(B2.Attrs.$bitnot());
        for (std_pair.pair I : B2.td_attrs$Const()) {
            this.TargetDepAttrs.erase((Object)((std.string)I.first));
        }
        return this;
    }

    public boolean overlaps(AttrBuilder B2) {
        if (std.bitset.$bitand_bitset$_Nb$C((std.bitset)this.Attrs, (std.bitset)B2.Attrs).any()) {
            return true;
        }
        for (std_pair.pair I : this.td_attrs$Const()) {
            if (!B2.contains(new StringRef((std.string)I.first))) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Attribute.AttrKind A2) {
        assert (Unsigned.$less_uint((int)A2.getValue(), (int)Attribute.AttrKind.EndAttrKinds.getValue())) : "Attribute out of range!";
        return this.Attrs.$at$Const(A2.getValue());
    }

    public boolean contains(StringRef A2) {
        return this.TargetDepAttrs.find$Const((Object)A2.$string()).$noteq((Object)this.TargetDepAttrs.end$Const());
    }

    public boolean hasAttributes() {
        return !this.Attrs.none() || !this.TargetDepAttrs.empty();
    }

    public boolean hasAttributes(AttributeSet A2, long Index) {
        int Slot = -1;
        int E = A2.getNumSlots();
        for (int I = 0; I != E; ++I) {
            if (Unsigned.$uint2ullong((int)A2.getSlotIndex(I)) != Index) continue;
            Slot = I;
            break;
        }
        assert (Slot != -1) : "Couldn't find the index!";
        type.ptr I = (type.ptr)Native.$tryClone(A2.begin(Slot));
        type.ptr E2 = (type.ptr)Native.$tryClone(A2.end(Slot));
        while (Native.$noteq_ptr((void.ptr)I, (void.ptr)E2)) {
            Attribute Attr = new Attribute((Attribute)I.$star());
            if (Attr.isEnumAttribute() || Attr.isIntAttribute()) {
                if (this.Attrs.$at$Const(((Attribute)I.$star()).getKindAsEnum().getValue())) {
                    return true;
                }
            } else {
                assert (Attr.isStringAttribute()) : "Invalid attribute kind!";
                return this.TargetDepAttrs.find$Const((Object)Attr.getKindAsString().$string()).$noteq((Object)this.TargetDepAttrs.end$Const());
            }
            I.$preInc();
        }
        return false;
    }

    public boolean hasAlignmentAttr() {
        return this.Alignment != Unsigned.$int2ullong((int)0);
    }

    public long getAlignment() {
        return this.Alignment;
    }

    public long getStackAlignment() {
        return this.StackAlignment;
    }

    public long getDereferenceableBytes() {
        return this.DerefBytes;
    }

    public long getDereferenceableOrNullBytes() {
        return this.DerefOrNullBytes;
    }

    public std_pair.pairUIntType<ADTAliases.OptionalUInt> getAllocSizeArgs() {
        return AttributesStatics.unpackAllocSizeArgs(this.AllocSizeArgs);
    }

    public AttrBuilder addAlignmentAttr(int Align) {
        if (Align == 0) {
            return this;
        }
        assert (llvm.isPowerOf2_32((int)Align)) : "Alignment must be a power of two.";
        assert (Unsigned.$lesseq_uint((int)Align, (int)0x40000000)) : "Alignment too large.";
        this.Attrs.set(Attribute.AttrKind.Alignment.getValue(), true);
        this.Alignment = Unsigned.$uint2ulong((int)Align);
        return this;
    }

    public AttrBuilder addStackAlignmentAttr(int Align) {
        if (Align == 0) {
            return this;
        }
        assert (llvm.isPowerOf2_32((int)Align)) : "Alignment must be a power of two.";
        assert (Unsigned.$lesseq_uint((int)Align, (int)256)) : "Alignment too large.";
        this.Attrs.set(Attribute.AttrKind.StackAlignment.getValue(), true);
        this.StackAlignment = Unsigned.$uint2ulong((int)Align);
        return this;
    }

    public AttrBuilder addDereferenceableAttr(long Bytes) {
        if (Bytes == Unsigned.$int2ullong((int)0)) {
            return this;
        }
        this.Attrs.set(Attribute.AttrKind.Dereferenceable.getValue(), true);
        this.DerefBytes = Bytes;
        return this;
    }

    public AttrBuilder addDereferenceableOrNullAttr(long Bytes) {
        if (Bytes == Unsigned.$int2ullong((int)0)) {
            return this;
        }
        this.Attrs.set(Attribute.AttrKind.DereferenceableOrNull.getValue(), true);
        this.DerefOrNullBytes = Bytes;
        return this;
    }

    public AttrBuilder addAllocSizeAttr(int ElemSize, ADTAliases.OptionalUInt NumElems) {
        return this.addAllocSizeAttrFromRawRepr(AttributesStatics.packAllocSizeArgs(ElemSize, NumElems));
    }

    public AttrBuilder addAllocSizeAttrFromRawRepr(long RawArgs) {
        assert (RawArgs != 0L) : "Invalid allocsize arguments -- given allocsize(0, 0)";
        this.Attrs.set(Attribute.AttrKind.AllocSize.getValue(), true);
        this.AllocSizeArgs = RawArgs;
        return this;
    }

    public boolean empty() {
        return this.Attrs.none();
    }

    public StdMapTypeType.iterator<std.string, std.string> td_begin() {
        return this.TargetDepAttrs.begin();
    }

    public StdMapTypeType.iterator<std.string, std.string> td_end() {
        return this.TargetDepAttrs.end();
    }

    public StdMapTypeType.iterator<std.string, std.string> td_begin$Const() {
        return this.TargetDepAttrs.begin$Const();
    }

    public StdMapTypeType.iterator<std.string, std.string> td_end$Const() {
        return this.TargetDepAttrs.end$Const();
    }

    public iterator_range<std_pair.pairTypeType<std.string, std.string>> td_attrs() {
        return new iterator_range(this.td_begin(), this.td_end());
    }

    public iterator_range<std_pair.pairTypeType<std.string, std.string>> td_attrs$Const() {
        return new iterator_range(this.td_begin(), this.td_end());
    }

    public boolean td_empty() {
        return this.TargetDepAttrs.empty();
    }

    public boolean $eq(AttrBuilder B2) {
        if (this.Attrs.$noteq(B2.Attrs)) {
            return false;
        }
        StdMapTypeType.iterator I = new StdMapTypeType.iterator(this.TargetDepAttrs.begin());
        StdMapTypeType.iterator E = new StdMapTypeType.iterator(this.TargetDepAttrs.end());
        while (I.$noteq((Object)E)) {
            if (B2.TargetDepAttrs.find$Const((Object)((std.string)I.$arrow().first)).$eq((Object)B2.TargetDepAttrs.end$Const())) {
                return false;
            }
            I.$preInc();
        }
        return this.Alignment == B2.Alignment && this.StackAlignment == B2.StackAlignment && this.DerefBytes == B2.DerefBytes;
    }

    public boolean $noteq(AttrBuilder B2) {
        return !this.$eq(B2);
    }

    public AttrBuilder addRawValue(long Val) {
        if (Val == 0L) {
            return this;
        }
        Attribute.AttrKind I = Attribute.AttrKind.None;
        while (I != Attribute.AttrKind.EndAttrKinds) {
            long A2;
            if (I != Attribute.AttrKind.Dereferenceable && I != Attribute.AttrKind.DereferenceableOrNull && I != Attribute.AttrKind.ArgMemOnly && I != Attribute.AttrKind.AllocSize && (A2 = Val & AttributeImpl.getAttrMask(I)) != 0L) {
                this.Attrs.set(I.getValue(), true);
                if (I == Attribute.AttrKind.Alignment) {
                    this.Alignment = 1L << (int)((A2 >>> 16) - Unsigned.$int2ullong((int)1));
                } else if (I == Attribute.AttrKind.StackAlignment) {
                    this.StackAlignment = 1L << (int)((A2 >>> 26) - Unsigned.$int2ullong((int)1));
                }
            }
            I = Attribute.AttrKind.valueOf(I.getValue() + 1);
        }
        return this;
    }

    public AttrBuilder(JavaDifferentiators.JD.Move _dparam, AttrBuilder $Prm0) {
        this.Attrs = new std.bitset(JavaDifferentiators.JD.Move.INSTANCE, $Prm0.Attrs);
        this.TargetDepAttrs = new std_map.mapTypeType(JavaDifferentiators.JD.Move.INSTANCE, $Prm0.TargetDepAttrs);
        this.Alignment = $Prm0.Alignment;
        this.StackAlignment = $Prm0.StackAlignment;
        this.DerefBytes = $Prm0.DerefBytes;
        this.DerefOrNullBytes = $Prm0.DerefOrNullBytes;
        this.AllocSizeArgs = $Prm0.AllocSizeArgs;
    }

    public void $destroy() {
        this.TargetDepAttrs.$destroy();
    }

    public String toString() {
        return "Attrs=" + this.Attrs + ", TargetDepAttrs=" + this.TargetDepAttrs + ", Alignment=" + this.Alignment + ", StackAlignment=" + this.StackAlignment + ", DerefBytes=" + this.DerefBytes + ", DerefOrNullBytes=" + this.DerefOrNullBytes + ", AllocSizeArgs=" + this.AllocSizeArgs;
    }
}

