/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.clank.support.Destructors;
import org.clank.support.Unsigned;
import org.clank.support.literal_constants;
import org.llvm.adt.Twine;
import org.llvm.ir.BasicBlock;
import org.llvm.ir.ConstantInt;
import org.llvm.ir.Instruction;
import org.llvm.ir.PointerType;
import org.llvm.ir.Type;
import org.llvm.ir.UnaryInstruction;
import org.llvm.ir.Value;
import org.llvm.ir.impl.InstructionsStatics;
import org.llvm.ir.java.IrRTTI;
import org.llvm.support.llvm;

public class AllocaInst
extends UnaryInstruction
implements Destructors.ClassWithDestructor {
    private Type AllocatedType;

    protected AllocaInst cloneImpl() {
        AllocaInst Result2 = (AllocaInst)UnaryInstruction.$new_UnaryInstruction(New$Mem -> new AllocaInst(this.getAllocatedType(), this.getOperand(0), this.getAlignment()));
        Result2.setUsedWithInAlloca(this.isUsedWithInAlloca());
        Result2.setSwiftError(this.isSwiftError());
        return Result2;
    }

    public AllocaInst(Type Ty) {
        this(Ty, (Value)null, new Twine(literal_constants.$EMPTY), (Instruction)null);
    }

    public AllocaInst(Type Ty, Value ArraySize) {
        this(Ty, ArraySize, new Twine(literal_constants.$EMPTY), (Instruction)null);
    }

    public AllocaInst(Type Ty, Value ArraySize, Twine Name) {
        this(Ty, ArraySize, Name, (Instruction)null);
    }

    public AllocaInst(Type Ty, Value ArraySize, Twine Name, Instruction InsertBefore) {
        this(Ty, ArraySize, 0, Name, InsertBefore);
    }

    public AllocaInst(Type Ty, Value ArraySize, Twine Name, BasicBlock InsertAtEnd) {
        this(Ty, ArraySize, 0, Name, InsertAtEnd);
    }

    public AllocaInst(Type Ty, Twine Name) {
        this(Ty, Name, (Instruction)null);
    }

    public AllocaInst(Type Ty, Twine Name, Instruction InsertBefore) {
        this(Ty, (Value)null, Name, InsertBefore);
    }

    public AllocaInst(Type Ty, Twine Name, BasicBlock InsertAtEnd) {
        this(Ty, (Value)null, Name, InsertAtEnd);
    }

    public AllocaInst(Type Ty, Value ArraySize, int Align) {
        this(Ty, ArraySize, Align, new Twine(literal_constants.$EMPTY), (Instruction)null);
    }

    public AllocaInst(Type Ty, Value ArraySize, int Align, Twine Name) {
        this(Ty, ArraySize, Align, Name, (Instruction)null);
    }

    public AllocaInst(Type Ty, Value ArraySize, int Align, Twine Name, Instruction InsertBefore) {
        super((Type)PointerType.getUnqual(Ty), 29, InstructionsStatics.getAISize(Ty.getContext(), ArraySize), InsertBefore);
        this.AllocatedType = Ty;
        this.setAlignment(Align);
        assert (!Ty.isVoidTy()) : "Cannot allocate void!";
        this.setName(Name);
    }

    public AllocaInst(Type Ty, Value ArraySize, int Align, Twine Name, BasicBlock InsertAtEnd) {
        super((Type)PointerType.getUnqual(Ty), 29, InstructionsStatics.getAISize(Ty.getContext(), ArraySize), InsertAtEnd);
        this.AllocatedType = Ty;
        this.setAlignment(Align);
        assert (!Ty.isVoidTy()) : "Cannot allocate void!";
        this.setName(Name);
    }

    @Override
    public void $destroy() {
        super.$destroy();
    }

    public boolean isArrayAllocation() {
        ConstantInt CI = IrRTTI.dyn_cast_ConstantInt(this.getOperand(0));
        if (CI != null) {
            return !CI.isOne();
        }
        return true;
    }

    public Value getArraySize$Const() {
        return this.getOperand(0);
    }

    public Value getArraySize() {
        return this.getOperand(0);
    }

    @Override
    public PointerType getType() {
        return IrRTTI.cast_PointerType(super.getType());
    }

    public Type getAllocatedType() {
        return this.AllocatedType;
    }

    public void setAllocatedType(Type Ty) {
        this.AllocatedType = Ty;
    }

    public int getAlignment() {
        return 1 << (this.getSubclassDataFromInstruction() & 0x1F) >>> 1;
    }

    public void setAlignment(int Align) {
        assert ((Align & Align - 1) == 0) : "Alignment is not a power of 2!";
        assert (Unsigned.$lesseq_uint((int)Align, (int)MaximumAlignment)) : "Alignment is greater than MaximumAlignment!";
        this.setInstructionSubclassData_AllocaInst(Unsigned.$uint2ushort((int)(this.getSubclassDataFromInstruction() & 0xFFFFFFE0 | llvm.Log2_32((int)Align) + 1)));
        assert (this.getAlignment() == Align) : "Alignment representation error!";
    }

    public boolean isStaticAlloca() {
        if (!IrRTTI.isa_ConstantInt(this.getArraySize$Const())) {
            return false;
        }
        BasicBlock Parent = this.getParent$Const();
        return Parent == Parent.getParent$Const().front$Const() && !this.isUsedWithInAlloca();
    }

    public boolean isUsedWithInAlloca() {
        return (this.getSubclassDataFromInstruction() & 0x20) != 0;
    }

    public void setUsedWithInAlloca(boolean V) {
        this.setInstructionSubclassData_AllocaInst(Unsigned.$uint2ushort((int)(this.getSubclassDataFromInstruction() & 0xFFFFFFDF | (V ? 32 : 0))));
    }

    public boolean isSwiftError() {
        return (this.getSubclassDataFromInstruction() & 0x40) != 0;
    }

    public void setSwiftError(boolean V) {
        this.setInstructionSubclassData_AllocaInst(Unsigned.$uint2ushort((int)(this.getSubclassDataFromInstruction() & 0xFFFFFFBF | (V ? 64 : 0))));
    }

    public static boolean classof(Instruction I) {
        return I.getOpcode() == 29;
    }

    public static boolean classof(Value V) {
        return IrRTTI.isa_Instruction(V) && AllocaInst.classof(IrRTTI.cast_Instruction(V));
    }

    private void setInstructionSubclassData_AllocaInst(char D2) {
        super.setInstructionSubclassData(D2);
    }

    @Override
    public String toString() {
        return "AllocatedType=" + this.AllocatedType + super.toString();
    }
}

