/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.lexer.java;

import fleet.com.intellij.lexer.StringLiteralLexer;
import fleet.com.intellij.openapi.util.text.StringUtil;
import fleet.com.intellij.psi.StringEscapesTokenTypes;
import fleet.com.intellij.psi.impl.source.BasicElementTypes;
import fleet.com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

class JavaStringLiteralLexer
extends StringLiteralLexer {
    JavaStringLiteralLexer(char quoteChar, IElementType originalLiteralToken) {
        super(quoteChar, originalLiteralToken);
    }

    JavaStringLiteralLexer(char quoteChar, IElementType originalLiteralToken, boolean canEscapeEolOrFramingSpaces, String additionalValidEscapes) {
        super(quoteChar, originalLiteralToken, canEscapeEolOrFramingSpaces, additionalValidEscapes);
    }

    public IElementType getTokenType() {
        char c;
        IElementType tokenType = super.getTokenType();
        if (tokenType == StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN && this.myBuffer.length() > this.myStart + 1 && (c = this.myBuffer.charAt(this.myStart + 1)) == '{' && BasicElementTypes.BASIC_STRING_TEMPLATE_FRAGMENTS.contains(this.myOriginalLiteralToken)) {
            return this.myOriginalLiteralToken;
        }
        return tokenType;
    }

    @NotNull
    protected IElementType getUnicodeEscapeSequenceType() {
        int start;
        for (start = this.myStart + 2; start < this.myEnd && this.myBuffer.charAt(start) == 'u'; ++start) {
        }
        if (start + 3 >= this.myEnd) {
            return StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
        }
        if (!(StringUtil.isHexDigit((char)this.myBuffer.charAt(start)) && StringUtil.isHexDigit((char)this.myBuffer.charAt(start + 1)) && StringUtil.isHexDigit((char)this.myBuffer.charAt(start + 2)) && StringUtil.isHexDigit((char)this.myBuffer.charAt(start + 3)))) {
            return StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
        }
        return StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
    }

    protected int locateUnicodeEscapeSequence(int start, int i) {
        while (++i < this.myBufferEnd && this.myBuffer.charAt(i) == 'u') {
        }
        int end = this.parseUnicodeDigits(i);
        if (end != i + 4) {
            return end;
        }
        int code = Integer.parseInt(this.myBuffer.subSequence(i, end).toString(), 16);
        i = end;
        if (code != 92 || i >= this.myBufferEnd) {
            return i;
        }
        char c = this.myBuffer.charAt(i);
        if (StringUtil.isOctalDigit((char)c)) {
            if (i + 2 < this.myBufferEnd && StringUtil.isOctalDigit((char)this.myBuffer.charAt(i + 1)) && StringUtil.isOctalDigit((char)this.myBuffer.charAt(i + 2))) {
                return i + 3;
            }
        } else if (c == '\\' && i + 1 < this.myBufferEnd && this.myBuffer.charAt(i + 1) == 'u') {
            i += 2;
            while (i < this.myBufferEnd && this.myBuffer.charAt(i) == 'u') {
                ++i;
            }
            return this.parseUnicodeDigits(i);
        }
        return i + 1;
    }

    private int parseUnicodeDigits(int i) {
        int end = i + 4;
        while (i < end) {
            if (i == this.myBufferEnd) {
                return i;
            }
            if (!StringUtil.isHexDigit((char)this.myBuffer.charAt(i))) {
                return i;
            }
            ++i;
        }
        return end;
    }
}

