/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.lang.java.parser;

import fleet.com.intellij.core.java.JavaPsiBundle;
import fleet.com.intellij.lang.PsiBuilder;
import fleet.com.intellij.lang.PsiBuilderUtil;
import fleet.com.intellij.lang.java.parser.BasicJavaParser;
import fleet.com.intellij.lang.java.parser.BasicJavaParserUtil;
import fleet.com.intellij.pom.java.JavaFeature;
import fleet.com.intellij.psi.impl.source.AbstractBasicJavaElementTypeFactory;
import fleet.com.intellij.psi.impl.source.BasicElementTypes;
import fleet.com.intellij.psi.java.JavaTokenType;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.intellij.psi.tree.TokenSet;
import fleet.com.intellij.util.BitUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicReferenceParser {
    public static final int EAT_LAST_DOT = 1;
    public static final int ELLIPSIS = 2;
    public static final int WILDCARD = 4;
    public static final int DIAMONDS = 8;
    public static final int DISJUNCTIONS = 16;
    public static final int CONJUNCTIONS = 32;
    public static final int INCOMPLETE_ANNO = 64;
    public static final int VAR_TYPE = 128;
    private static final TokenSet WILDCARD_KEYWORD_SET = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.EXTENDS_KEYWORD, JavaTokenType.SUPER_KEYWORD});
    private final BasicJavaParser myParser;
    private final AbstractBasicJavaElementTypeFactory.JavaElementTypeContainer myJavaElementTypeContainer;

    public BasicReferenceParser(@NotNull BasicJavaParser javaParser) {
        this.myParser = javaParser;
        this.myJavaElementTypeContainer = javaParser.getJavaElementTypeFactory().getContainer();
    }

    @Nullable
    public PsiBuilder.Marker parseType(PsiBuilder builder, int flags) {
        TypeInfo typeInfo = this.parseTypeInfo(builder, flags);
        return typeInfo != null ? typeInfo.marker : null;
    }

    @Nullable
    public TypeInfo parseTypeInfo(PsiBuilder builder, int flags) {
        TypeInfo typeInfo = this.parseTypeInfo(builder, flags, false);
        if (typeInfo != null) {
            IElementType operator;
            assert (!BitUtil.isSet((int)flags, (int)16) || !BitUtil.isSet((int)flags, (int)32)) : "don't set both flags simultaneously";
            Object object = BitUtil.isSet((int)flags, (int)16) ? JavaTokenType.OR : (operator = BitUtil.isSet((int)flags, (int)32) ? JavaTokenType.AND : null);
            if (operator != null && builder.getTokenType() == operator) {
                typeInfo.marker = typeInfo.marker.precede();
                while (builder.getTokenType() == operator) {
                    builder.advanceLexer();
                    IElementType tokenType = builder.getTokenType();
                    if (tokenType != JavaTokenType.IDENTIFIER && tokenType != JavaTokenType.AT) {
                        BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.identifier", new Object[0]));
                    }
                    this.parseTypeInfo(builder, flags, false);
                }
                typeInfo.marker.done(this.myJavaElementTypeContainer.TYPE);
            }
        }
        return typeInfo;
    }

    @Nullable
    private TypeInfo parseTypeInfo(PsiBuilder builder, int flags, boolean badWildcard) {
        if (builder.getTokenType() == null) {
            return null;
        }
        TypeInfo typeInfo = new TypeInfo();
        PsiBuilder.Marker type = builder.mark();
        PsiBuilder.Marker anno = this.myParser.getDeclarationParser().parseAnnotations(builder);
        IElementType tokenType = builder.getTokenType();
        if (tokenType == JavaTokenType.IDENTIFIER && BitUtil.isSet((int)flags, (int)128) && builder.lookAhead(1) != JavaTokenType.DOT && builder.lookAhead(1) != JavaTokenType.COLON && "var".equals(builder.getTokenText()) && JavaFeature.LVTI.isSufficient(BasicJavaParserUtil.getLanguageLevel(builder))) {
            tokenType = JavaTokenType.VAR_KEYWORD;
            builder.remapCurrentToken(tokenType);
        } else if (tokenType == JavaTokenType.VAR_KEYWORD && !BitUtil.isSet((int)flags, (int)128)) {
            tokenType = JavaTokenType.IDENTIFIER;
            builder.remapCurrentToken(tokenType);
        }
        if (PsiBuilderUtil.expect((PsiBuilder)builder, (TokenSet)BasicElementTypes.BASIC_PRIMITIVE_TYPE_BIT_SET)) {
            typeInfo.isPrimitive = true;
        } else {
            if ((BitUtil.isSet((int)flags, (int)4) || badWildcard) && tokenType == JavaTokenType.QUEST) {
                builder.advanceLexer();
                this.completeWildcardType(builder, BitUtil.isSet((int)flags, (int)4), type);
                typeInfo.marker = type;
                return typeInfo;
            }
            if (tokenType == JavaTokenType.IDENTIFIER) {
                this.parseJavaCodeReference(builder, BitUtil.isSet((int)flags, (int)1), true, false, false, false, BitUtil.isSet((int)flags, (int)8), typeInfo);
            } else {
                if (tokenType == JavaTokenType.VAR_KEYWORD) {
                    builder.advanceLexer();
                    type.done(this.myJavaElementTypeContainer.TYPE);
                    typeInfo.marker = type;
                    return typeInfo;
                }
                if (BitUtil.isSet((int)flags, (int)8) && tokenType == JavaTokenType.GT) {
                    if (anno == null) {
                        BasicJavaParserUtil.emptyElement(builder, this.myJavaElementTypeContainer.DIAMOND_TYPE);
                    } else {
                        BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.identifier", new Object[0]));
                        typeInfo.hasErrors = true;
                    }
                    type.done(this.myJavaElementTypeContainer.TYPE);
                    typeInfo.marker = type;
                    return typeInfo;
                }
                type.drop();
                if (anno != null && BitUtil.isSet((int)flags, (int)64)) {
                    BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.type", new Object[0]));
                    typeInfo.marker = anno;
                    typeInfo.hasErrors = true;
                    return typeInfo;
                }
                return null;
            }
        }
        type.done(this.myJavaElementTypeContainer.TYPE);
        while (true) {
            this.myParser.getDeclarationParser().parseAnnotations(builder);
            PsiBuilder.Marker bracket = builder.mark();
            if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.LBRACKET)) {
                bracket.drop();
                break;
            }
            if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.RBRACKET)) {
                bracket.rollbackTo();
                break;
            }
            bracket.drop();
            typeInfo.isArray = true;
        }
        if (BitUtil.isSet((int)flags, (int)2) && builder.getTokenType() == JavaTokenType.ELLIPSIS) {
            builder.advanceLexer();
            typeInfo.isVarArg = true;
        }
        if (typeInfo.isVarArg || typeInfo.isArray) {
            type = type.precede();
            type.done(this.myJavaElementTypeContainer.TYPE);
        }
        typeInfo.marker = type;
        return typeInfo;
    }

    private void completeWildcardType(PsiBuilder builder, boolean wildcard, PsiBuilder.Marker type) {
        if (PsiBuilderUtil.expect((PsiBuilder)builder, (TokenSet)WILDCARD_KEYWORD_SET) && this.parseTypeInfo(builder, 1) == null) {
            BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.type", new Object[0]));
        }
        if (wildcard) {
            type.done(this.myJavaElementTypeContainer.TYPE);
        } else {
            type.error(JavaPsiBundle.message("error.message.wildcard.not.expected", new Object[0]));
        }
    }

    @Nullable
    public PsiBuilder.Marker parseJavaCodeReference(PsiBuilder builder, boolean eatLastDot, boolean parameterList, boolean isNew, boolean diamonds) {
        return this.parseJavaCodeReference(builder, eatLastDot, parameterList, false, false, isNew, diamonds, new TypeInfo());
    }

    public boolean parseImportCodeReference(PsiBuilder builder, boolean isStatic) {
        TypeInfo typeInfo = new TypeInfo();
        this.parseJavaCodeReference(builder, true, false, true, isStatic, false, false, typeInfo);
        return !typeInfo.hasErrors;
    }

    @Nullable
    private PsiBuilder.Marker parseJavaCodeReference(PsiBuilder builder, boolean eatLastDot, boolean parameterList, boolean isImport, boolean isStaticImport, boolean isNew, boolean diamonds, TypeInfo typeInfo) {
        PsiBuilder.Marker refElement = builder.mark();
        this.myParser.getDeclarationParser().parseAnnotations(builder);
        if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.IDENTIFIER)) {
            refElement.rollbackTo();
            if (isImport) {
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.identifier", new Object[0]));
            }
            typeInfo.hasErrors = true;
            return null;
        }
        if (parameterList) {
            typeInfo.isParameterized = this.parseReferenceParameterList(builder, true, diamonds);
        } else if (!isStaticImport) {
            BasicJavaParserUtil.emptyElement(builder, this.myJavaElementTypeContainer.REFERENCE_PARAMETER_LIST);
        }
        while (builder.getTokenType() == JavaTokenType.DOT) {
            refElement.done(this.myJavaElementTypeContainer.JAVA_CODE_REFERENCE);
            if (isNew && !diamonds && typeInfo.isParameterized) {
                return refElement;
            }
            PsiBuilder.Marker dotPos = builder.mark();
            builder.advanceLexer();
            this.myParser.getDeclarationParser().parseAnnotations(builder);
            if (isImport && PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.ASTERISK)) {
                dotPos.drop();
                return refElement;
            }
            if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.IDENTIFIER)) {
                if (!eatLastDot) {
                    dotPos.rollbackTo();
                    return refElement;
                }
                typeInfo.hasErrors = true;
                if (isImport) {
                    BasicJavaParserUtil.error(builder, JavaPsiBundle.message("import.statement.identifier.or.asterisk.expected.", new Object[0]));
                } else {
                    BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.identifier", new Object[0]));
                }
                dotPos.drop();
                return refElement;
            }
            dotPos.drop();
            refElement = refElement.precede();
            if (parameterList) {
                typeInfo.isParameterized = this.parseReferenceParameterList(builder, true, diamonds);
                continue;
            }
            BasicJavaParserUtil.emptyElement(builder, this.myJavaElementTypeContainer.REFERENCE_PARAMETER_LIST);
        }
        if (isStaticImport) {
            refElement.done(this.myJavaElementTypeContainer.IMPORT_STATIC_REFERENCE);
        } else {
            refElement.done(this.myJavaElementTypeContainer.JAVA_CODE_REFERENCE);
        }
        return refElement;
    }

    public boolean parseReferenceParameterList(PsiBuilder builder, boolean wildcard, boolean diamonds) {
        PsiBuilder.Marker list = builder.mark();
        if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.LT)) {
            list.done(this.myJavaElementTypeContainer.REFERENCE_PARAMETER_LIST);
            return false;
        }
        int flags = BitUtil.set((int)BitUtil.set((int)1, (int)4, (boolean)wildcard), (int)8, (boolean)diamonds);
        boolean isOk = true;
        while (true) {
            if (this.parseTypeInfo(builder, flags, true) == null) {
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.identifier", new Object[0]));
            } else {
                IElementType tokenType = builder.getTokenType();
                if (WILDCARD_KEYWORD_SET.contains(tokenType)) {
                    this.parseReferenceList(builder, tokenType, null, JavaTokenType.AND);
                }
            }
            if (PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.GT)) break;
            if (!BasicJavaParserUtil.expectOrError(builder, JavaTokenType.COMMA, "expected.gt.or.comma")) {
                isOk = false;
                break;
            }
            flags = BitUtil.set((int)flags, (int)8, (boolean)false);
        }
        list.done(this.myJavaElementTypeContainer.REFERENCE_PARAMETER_LIST);
        return isOk;
    }

    @NotNull
    public PsiBuilder.Marker parseTypeParameters(PsiBuilder builder) {
        PsiBuilder.Marker list = builder.mark();
        if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.LT)) {
            list.done(this.myJavaElementTypeContainer.TYPE_PARAMETER_LIST);
            return list;
        }
        do {
            PsiBuilder.Marker param;
            if ((param = this.parseTypeParameter(builder)) != null) continue;
            BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.type.parameter", new Object[0]));
        } while (PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.COMMA));
        if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.GT)) {
            if (builder.getTokenType() == JavaTokenType.IDENTIFIER) {
                if (builder.lookAhead(1) == JavaTokenType.GT) {
                    PsiBuilder.Marker errorElement = builder.mark();
                    builder.advanceLexer();
                    errorElement.error(JavaPsiBundle.message("unexpected.identifier", new Object[0]));
                    builder.advanceLexer();
                } else {
                    BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.gt", new Object[0]));
                }
            } else {
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.gt", new Object[0]));
            }
        }
        list.done(this.myJavaElementTypeContainer.TYPE_PARAMETER_LIST);
        return list;
    }

    @Nullable
    public PsiBuilder.Marker parseTypeParameter(PsiBuilder builder) {
        PsiBuilder.Marker param = builder.mark();
        this.myParser.getDeclarationParser().parseAnnotations(builder);
        boolean wild = PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.QUEST);
        if (!wild && !PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.IDENTIFIER)) {
            param.rollbackTo();
            return null;
        }
        this.parseReferenceList(builder, JavaTokenType.EXTENDS_KEYWORD, this.myJavaElementTypeContainer.EXTENDS_BOUND_LIST, JavaTokenType.AND);
        if (!wild) {
            param.done(this.myJavaElementTypeContainer.TYPE_PARAMETER);
        } else {
            param.error(JavaPsiBundle.message("error.message.wildcard.not.expected", new Object[0]));
        }
        return param;
    }

    public boolean parseReferenceList(PsiBuilder builder, IElementType start, @Nullable IElementType type, IElementType delimiter) {
        PsiBuilder.Marker element = builder.mark();
        boolean endsWithError = false;
        if (PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)start)) {
            do {
                endsWithError = false;
                PsiBuilder.Marker classReference = this.parseJavaCodeReference(builder, false, true, false, false);
                if (classReference != null) continue;
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.identifier", new Object[0]));
                endsWithError = true;
            } while (PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)delimiter));
        }
        if (type != null) {
            element.done(type);
        } else {
            element.error(JavaPsiBundle.message("bound.not.expected", new Object[0]));
        }
        return endsWithError;
    }

    public static class TypeInfo {
        public boolean isPrimitive;
        public boolean isParameterized;
        public boolean isArray;
        public boolean isVarArg;
        public boolean hasErrors;
        public PsiBuilder.Marker marker;
    }
}

