/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.lang.java.parser;

import fleet.com.intellij.core.java.JavaPsiBundle;
import fleet.com.intellij.lang.PsiBuilder;
import fleet.com.intellij.lang.PsiBuilderUtil;
import fleet.com.intellij.lang.WhitespacesAndCommentsBinder;
import fleet.com.intellij.lang.impl.PsiBuilderAdapter;
import fleet.com.intellij.openapi.util.Key;
import fleet.com.intellij.openapi.util.NlsContexts;
import fleet.com.intellij.openapi.util.Pair;
import fleet.com.intellij.openapi.util.text.StringUtil;
import fleet.com.intellij.pom.java.LanguageLevel;
import fleet.com.intellij.psi.impl.source.BasicJavaDocElementType;
import fleet.com.intellij.psi.impl.source.BasicJavaElementType;
import fleet.com.intellij.psi.impl.source.WhiteSpaceAndCommentSetHolder;
import fleet.com.intellij.psi.java.JavaTokenType;
import fleet.com.intellij.psi.java.impl.source.tree.ElementType;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.intellij.psi.tree.TokenSet;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public final class BasicJavaParserUtil {
    public static final TokenSet WS_COMMENTS = TokenSet.orSet((TokenSet[])new TokenSet[]{ElementType.JAVA_COMMENT_BIT_SET, TokenSet.WHITE_SPACE});
    private static final Key<LanguageLevel> LANG_LEVEL_KEY = Key.create((String)"JavaParserUtil.LanguageLevel");
    private static final Key<Boolean> DEEP_PARSE_BLOCKS_IN_STATEMENTS = Key.create((String)"JavaParserUtil.ParserExtender");
    private static final Key<Boolean> DEEP_PARSE_BLOCKS = Key.create((String)"JavaParserUtil.ParserExtender.All");
    private static final TokenSet PRECEDING_COMMENT_SET = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{BasicJavaElementType.BASIC_MODULE}), ElementType.FULL_MEMBER_BIT_SET});
    private static final TokenSet TRAILING_COMMENT_SET = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{BasicJavaElementType.BASIC_PACKAGE_STATEMENT}), ElementType.IMPORT_STATEMENT_BASE_BIT_SET, ElementType.FULL_MEMBER_BIT_SET, ElementType.JAVA_STATEMENT_BIT_SET});
    public static final WhitespacesAndCommentsBinder PRECEDING_COMMENT_BINDER = new PrecedingWhitespacesAndCommentsBinder(false);
    public static final WhitespacesAndCommentsBinder SPECIAL_PRECEDING_COMMENT_BINDER = new PrecedingWhitespacesAndCommentsBinder(true);
    public static final WhitespacesAndCommentsBinder TRAILING_COMMENT_BINDER = new TrailingWhitespacesAndCommentsBinder();

    private BasicJavaParserUtil() {
    }

    public static void setLanguageLevel(PsiBuilder builder, LanguageLevel level) {
        builder.putUserData(LANG_LEVEL_KEY, (Object)level);
    }

    @NotNull
    public static LanguageLevel getLanguageLevel(PsiBuilder builder) {
        LanguageLevel level = (LanguageLevel)((Object)builder.getUserData(LANG_LEVEL_KEY));
        assert (level != null) : builder;
        return level;
    }

    public static void setParseStatementCodeBlocksDeep(PsiBuilder builder, boolean deep) {
        builder.putUserData(DEEP_PARSE_BLOCKS_IN_STATEMENTS, (Object)deep);
    }

    public static boolean isParseStatementCodeBlocksDeep(PsiBuilder builder) {
        return Boolean.TRUE.equals(builder.getUserData(DEEP_PARSE_BLOCKS_IN_STATEMENTS));
    }

    public static void done(PsiBuilder.Marker marker, IElementType type, WhiteSpaceAndCommentSetHolder commentSetHolder) {
        marker.done(type);
        WhitespacesAndCommentsBinder left = commentSetHolder.getPrecedingCommentSet().contains(type) ? commentSetHolder.getPrecedingCommentBinder() : null;
        WhitespacesAndCommentsBinder right = commentSetHolder.getTrailingCommentSet().contains(type) ? commentSetHolder.getTrailingCommentBinder() : null;
        marker.setCustomEdgeTokenBinders(left, right);
    }

    public static void done(PsiBuilder.Marker marker, IElementType type) {
        marker.done(type);
        WhitespacesAndCommentsBinder left = PRECEDING_COMMENT_SET.contains(type) ? PRECEDING_COMMENT_BINDER : null;
        WhitespacesAndCommentsBinder right = TRAILING_COMMENT_SET.contains(type) ? TRAILING_COMMENT_BINDER : null;
        marker.setCustomEdgeTokenBinders(left, right);
    }

    @Nullable
    public static IElementType exprType(@Nullable PsiBuilder.Marker marker) {
        return marker != null ? marker.getTokenType() : null;
    }

    public static void error(PsiBuilder builder, @NotNull @NlsContexts.ParsingError String message) {
        builder.mark().error(message);
    }

    public static void error(PsiBuilder builder, @NotNull @NlsContexts.ParsingError String message, @Nullable PsiBuilder.Marker before) {
        if (before == null) {
            BasicJavaParserUtil.error(builder, message);
        } else {
            before.precede().errorBefore(message, before);
        }
    }

    public static boolean expectOrError(PsiBuilder builder, TokenSet expected, @PropertyKey(resourceBundle="messages.JavaPsiBundle") @PropertyKey(resourceBundle="messages.JavaPsiBundle") String key) {
        if (!PsiBuilderUtil.expect((PsiBuilder)builder, (TokenSet)expected)) {
            BasicJavaParserUtil.error(builder, JavaPsiBundle.message(key, new Object[0]));
            return false;
        }
        return true;
    }

    public static boolean expectOrError(PsiBuilder builder, IElementType expected, @PropertyKey(resourceBundle="messages.JavaPsiBundle") @PropertyKey(resourceBundle="messages.JavaPsiBundle") String key) {
        if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)expected)) {
            BasicJavaParserUtil.error(builder, JavaPsiBundle.message(key, new Object[0]));
            return false;
        }
        return true;
    }

    public static void emptyElement(PsiBuilder builder, IElementType type) {
        builder.mark().done(type);
    }

    public static void emptyElement(PsiBuilder.Marker before, IElementType type) {
        before.precede().doneBefore(type, before);
    }

    public static void semicolon(PsiBuilder builder) {
        BasicJavaParserUtil.expectOrError(builder, JavaTokenType.SEMICOLON, "expected.semicolon");
    }

    public static PsiBuilder braceMatchingBuilder(PsiBuilder builder) {
        PsiBuilder.Marker pos = builder.mark();
        int braceCount = 1;
        while (!builder.eof()) {
            IElementType tokenType = builder.getTokenType();
            if (tokenType == JavaTokenType.LBRACE) {
                ++braceCount;
            } else if (tokenType == JavaTokenType.RBRACE) {
                --braceCount;
            }
            if (braceCount == 0) break;
            builder.advanceLexer();
        }
        int stopAt = builder.getCurrentOffset();
        pos.rollbackTo();
        return BasicJavaParserUtil.stoppingBuilder(builder, stopAt);
    }

    public static PsiBuilder stoppingBuilder(PsiBuilder builder, final int stopAt) {
        return new PsiBuilderAdapter(builder){

            public IElementType getTokenType() {
                return this.getCurrentOffset() < stopAt ? super.getTokenType() : null;
            }

            public boolean eof() {
                return this.getCurrentOffset() >= stopAt || super.eof();
            }
        };
    }

    public static PsiBuilder stoppingBuilder(final PsiBuilder builder, final Predicate<? super Pair<IElementType, String>> condition) {
        return new PsiBuilderAdapter(builder){

            public IElementType getTokenType() {
                Pair input = Pair.create((Object)builder.getTokenType(), (Object)builder.getTokenText());
                return condition.test(input) ? null : super.getTokenType();
            }

            public boolean eof() {
                Pair input = Pair.create((Object)builder.getTokenType(), (Object)builder.getTokenText());
                return condition.test(input) || super.eof();
            }
        };
    }

    private static class PrecedingWhitespacesAndCommentsBinder
    implements WhitespacesAndCommentsBinder {
        private final boolean myAfterEmptyImport;

        PrecedingWhitespacesAndCommentsBinder(boolean afterImport) {
            this.myAfterEmptyImport = afterImport;
        }

        public int getEdgePosition(List<? extends IElementType> tokens, boolean atStreamEdge, WhitespacesAndCommentsBinder.TokenTextGetter getter) {
            if (tokens.size() == 0) {
                return 0;
            }
            for (int idx = tokens.size() - 1; idx >= 0; --idx) {
                if (tokens.get(idx) != BasicJavaDocElementType.DOC_COMMENT) continue;
                return idx;
            }
            int result = tokens.size();
            for (int idx = tokens.size() - 1; idx >= 0; --idx) {
                IElementType tokenType = tokens.get(idx);
                if (TokenSet.WHITE_SPACE.contains(tokenType)) {
                    if (StringUtil.getLineBreakCount((CharSequence)getter.get(idx)) <= 1) continue;
                    break;
                }
                if (!ElementType.JAVA_PLAIN_COMMENT_BIT_SET.contains(tokenType)) break;
                if (!atStreamEdge && (idx != 0 || !this.myAfterEmptyImport) && (idx <= 0 || !TokenSet.WHITE_SPACE.contains(tokens.get(idx - 1)) || !StringUtil.containsLineBreak((CharSequence)getter.get(idx - 1)))) continue;
                result = idx;
            }
            return result;
        }
    }

    private static class TrailingWhitespacesAndCommentsBinder
    implements WhitespacesAndCommentsBinder {
        private TrailingWhitespacesAndCommentsBinder() {
        }

        public int getEdgePosition(List<? extends IElementType> tokens, boolean atStreamEdge, WhitespacesAndCommentsBinder.TokenTextGetter getter) {
            if (tokens.size() == 0) {
                return 0;
            }
            int result = 0;
            for (int idx = 0; idx < tokens.size(); ++idx) {
                IElementType tokenType = tokens.get(idx);
                if (TokenSet.WHITE_SPACE.contains(tokenType)) {
                    if (!StringUtil.containsLineBreak((CharSequence)getter.get(idx))) continue;
                    break;
                }
                if (!ElementType.JAVA_PLAIN_COMMENT_BIT_SET.contains(tokenType)) break;
                result = idx + 1;
            }
            return result;
        }
    }
}

