/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.lang.java.parser;

import fleet.com.intellij.core.java.JavaPsiBundle;
import fleet.com.intellij.lang.PsiBuilder;
import fleet.com.intellij.lang.PsiBuilderUtil;
import fleet.com.intellij.lang.java.parser.BasicJavaParser;
import fleet.com.intellij.lang.java.parser.BasicJavaParserUtil;
import fleet.com.intellij.lang.java.parser.BasicReferenceParser;
import fleet.com.intellij.openapi.util.Pair;
import fleet.com.intellij.pom.java.JavaFeature;
import fleet.com.intellij.pom.java.LanguageLevel;
import fleet.com.intellij.psi.impl.source.AbstractBasicJavaElementTypeFactory;
import fleet.com.intellij.psi.impl.source.BasicElementTypes;
import fleet.com.intellij.psi.impl.source.WhiteSpaceAndCommentSetHolder;
import fleet.com.intellij.psi.java.JavaTokenType;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.intellij.psi.tree.ILazyParseableElementType;
import fleet.com.intellij.psi.tree.TokenSet;
import fleet.com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

@ApiStatus.Experimental
public class BasicDeclarationParser {
    private static final TokenSet BEFORE_LBRACE_ELEMENTS_SET = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.IDENTIFIER, JavaTokenType.COMMA, JavaTokenType.EXTENDS_KEYWORD, JavaTokenType.IMPLEMENTS_KEYWORD, JavaTokenType.LPARENTH});
    private static final TokenSet APPEND_TO_METHOD_SET = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.IDENTIFIER, JavaTokenType.COMMA, JavaTokenType.THROWS_KEYWORD});
    private static final TokenSet PARAM_LIST_STOPPERS = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.RPARENTH, JavaTokenType.LBRACE, JavaTokenType.ARROW});
    private static final TokenSet METHOD_PARAM_LIST_STOPPERS = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.RPARENTH, JavaTokenType.LBRACE, JavaTokenType.ARROW, JavaTokenType.SEMICOLON});
    private final TokenSet TYPE_START;
    private final TokenSet RESOURCE_EXPRESSIONS;
    private static final String WHITESPACES = "\n\r \t";
    private static final String LINE_ENDS = "\n\r";
    private final BasicJavaParser myParser;
    private final AbstractBasicJavaElementTypeFactory.JavaElementTypeContainer myJavaElementTypeContainer;
    private final WhiteSpaceAndCommentSetHolder myWhiteSpaceAndCommentSetHolder = WhiteSpaceAndCommentSetHolder.INSTANCE;

    public BasicDeclarationParser(@NotNull BasicJavaParser javaParser) {
        this.myParser = javaParser;
        this.myJavaElementTypeContainer = javaParser.getJavaElementTypeFactory().getContainer();
        this.TYPE_START = TokenSet.orSet((TokenSet[])new TokenSet[]{BasicElementTypes.BASIC_PRIMITIVE_TYPE_BIT_SET, TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.IDENTIFIER, JavaTokenType.AT, JavaTokenType.VAR_KEYWORD})});
        this.RESOURCE_EXPRESSIONS = TokenSet.create((IElementType[])new IElementType[]{this.myJavaElementTypeContainer.REFERENCE_EXPRESSION, this.myJavaElementTypeContainer.THIS_EXPRESSION, this.myJavaElementTypeContainer.METHOD_CALL_EXPRESSION, this.myJavaElementTypeContainer.NEW_EXPRESSION});
    }

    public void parseClassBodyWithBraces(PsiBuilder builder, boolean isAnnotation, boolean isEnum) {
        assert (builder.getTokenType() == JavaTokenType.LBRACE) : builder.getTokenType();
        builder.advanceLexer();
        PsiBuilder builderWrapper = BasicJavaParserUtil.braceMatchingBuilder(builder);
        if (isEnum) {
            this.parseEnumConstants(builderWrapper);
        }
        this.parseClassBodyDeclarations(builderWrapper, isAnnotation);
        BasicJavaParserUtil.expectOrError(builder, JavaTokenType.RBRACE, "expected.rbrace");
    }

    @Nullable
    private PsiBuilder.Marker parseClassFromKeyword(PsiBuilder builder, PsiBuilder.Marker declaration, boolean isAnnotation, BaseContext context) {
        boolean isEnum;
        IElementType keywordTokenType = builder.getTokenType();
        boolean isRecord = BasicDeclarationParser.isRecordToken(builder, keywordTokenType);
        if (isRecord) {
            if (builder.lookAhead(1) != JavaTokenType.IDENTIFIER) {
                declaration.drop();
                return null;
            }
            IElementType afterIdent = builder.lookAhead(2);
            if (context == BaseContext.CODE_BLOCK && afterIdent != JavaTokenType.LPARENTH && afterIdent != JavaTokenType.LT) {
                PsiBuilderUtil.advance((PsiBuilder)builder, (int)2);
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.lt.or.lparen", new Object[0]));
                declaration.drop();
                return null;
            }
            builder.remapCurrentToken(JavaTokenType.RECORD_KEYWORD);
            keywordTokenType = JavaTokenType.RECORD_KEYWORD;
        }
        assert (BasicElementTypes.BASIC_CLASS_KEYWORD_BIT_SET.contains(keywordTokenType)) : keywordTokenType;
        builder.advanceLexer();
        boolean bl = isEnum = keywordTokenType == JavaTokenType.ENUM_KEYWORD;
        if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.IDENTIFIER)) {
            BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.identifier", new Object[0]));
            declaration.drop();
            return null;
        }
        BasicReferenceParser refParser = this.myParser.getReferenceParser();
        refParser.parseTypeParameters(builder);
        if (builder.getTokenType() == JavaTokenType.LPARENTH) {
            this.parseElementList(builder, ListType.RECORD_COMPONENTS);
        }
        refParser.parseReferenceList(builder, JavaTokenType.EXTENDS_KEYWORD, this.myJavaElementTypeContainer.EXTENDS_LIST, JavaTokenType.COMMA);
        refParser.parseReferenceList(builder, JavaTokenType.IMPLEMENTS_KEYWORD, this.myJavaElementTypeContainer.IMPLEMENTS_LIST, JavaTokenType.COMMA);
        if (builder.getTokenType() == JavaTokenType.IDENTIFIER && "permits".equals(builder.getTokenText())) {
            builder.remapCurrentToken(JavaTokenType.PERMITS_KEYWORD);
        }
        if (builder.getTokenType() == JavaTokenType.PERMITS_KEYWORD) {
            refParser.parseReferenceList(builder, JavaTokenType.PERMITS_KEYWORD, this.myJavaElementTypeContainer.PERMITS_LIST, JavaTokenType.COMMA);
        }
        if (builder.getTokenType() != JavaTokenType.LBRACE) {
            PsiBuilder.Marker error = builder.mark();
            while (BEFORE_LBRACE_ELEMENTS_SET.contains(builder.getTokenType())) {
                builder.advanceLexer();
            }
            error.error(JavaPsiBundle.message("expected.lbrace", new Object[0]));
        }
        if (builder.getTokenType() == JavaTokenType.LBRACE) {
            this.parseClassBodyWithBraces(builder, isAnnotation, isEnum);
        }
        BasicJavaParserUtil.done(declaration, this.myJavaElementTypeContainer.CLASS, this.myWhiteSpaceAndCommentSetHolder);
        return declaration;
    }

    private void parseEnumConstants(PsiBuilder builder) {
        boolean first = true;
        while (builder.getTokenType() != null) {
            IElementType next;
            if (PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.SEMICOLON)) {
                return;
            }
            if (builder.getTokenType() == JavaTokenType.PRIVATE_KEYWORD || builder.getTokenType() == JavaTokenType.PROTECTED_KEYWORD) {
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.semicolon", new Object[0]));
                return;
            }
            PsiBuilder.Marker enumConstant = this.parseEnumConstant(builder);
            if (enumConstant == null && builder.getTokenType() == JavaTokenType.COMMA && first && (next = builder.lookAhead(1)) != JavaTokenType.SEMICOLON && next != JavaTokenType.RBRACE) {
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.identifier", new Object[0]));
            }
            first = false;
            int commaCount = 0;
            while (builder.getTokenType() == JavaTokenType.COMMA) {
                if (commaCount > 0) {
                    BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.identifier", new Object[0]));
                }
                builder.advanceLexer();
                ++commaCount;
            }
            if (commaCount != 0 || builder.getTokenType() == null || builder.getTokenType() == JavaTokenType.SEMICOLON) continue;
            BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.comma.or.semicolon", new Object[0]));
            return;
        }
    }

    @Nullable
    public PsiBuilder.Marker parseEnumConstant(PsiBuilder builder) {
        PsiBuilder.Marker constant = builder.mark();
        this.parseModifierList(builder);
        if (PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.IDENTIFIER)) {
            if (builder.getTokenType() == JavaTokenType.LPARENTH) {
                this.myParser.getExpressionParser().parseArgumentList(builder);
            } else {
                BasicJavaParserUtil.emptyElement(builder, this.myJavaElementTypeContainer.EXPRESSION_LIST);
            }
            if (builder.getTokenType() == JavaTokenType.LBRACE) {
                PsiBuilder.Marker constantInit = builder.mark();
                this.parseClassBodyWithBraces(builder, false, false);
                BasicJavaParserUtil.done(constantInit, this.myJavaElementTypeContainer.ENUM_CONSTANT_INITIALIZER, this.myWhiteSpaceAndCommentSetHolder);
            }
            BasicJavaParserUtil.done(constant, this.myJavaElementTypeContainer.ENUM_CONSTANT, this.myWhiteSpaceAndCommentSetHolder);
            return constant;
        }
        constant.rollbackTo();
        return null;
    }

    public void parseClassBodyDeclarations(PsiBuilder builder, boolean isAnnotation) {
        IElementType tokenType;
        BaseContext context = isAnnotation ? BaseContext.ANNOTATION_INTERFACE : BaseContext.CLASS;
        PsiBuilder.Marker invalidElements = null;
        while ((tokenType = builder.getTokenType()) != null && tokenType != JavaTokenType.RBRACE) {
            PsiBuilder.Marker ref;
            if (tokenType == JavaTokenType.SEMICOLON) {
                if (invalidElements != null) {
                    invalidElements.error(JavaPsiBundle.message("unexpected.token", new Object[0]));
                    invalidElements = null;
                }
                builder.advanceLexer();
                continue;
            }
            PsiBuilder.Marker declaration = this.parse(builder, context);
            if (declaration != null) {
                if (invalidElements == null) continue;
                invalidElements.errorBefore(JavaPsiBundle.message("unexpected.token", new Object[0]), declaration);
                invalidElements = null;
                continue;
            }
            if (invalidElements == null) {
                invalidElements = builder.mark();
            }
            if ((ref = this.myParser.getReferenceParser().parseJavaCodeReference(builder, true, true, false, false)) != null) continue;
            builder.advanceLexer();
        }
        if (invalidElements != null) {
            invalidElements.error(JavaPsiBundle.message("unexpected.token", new Object[0]));
        }
    }

    @Nullable
    public PsiBuilder.Marker parse(@NotNull PsiBuilder builder, BaseContext context) {
        IElementType tokenType = builder.getTokenType();
        if (tokenType == null) {
            return null;
        }
        if (tokenType == JavaTokenType.LBRACE) {
            if (context == BaseContext.FILE || context == BaseContext.CODE_BLOCK) {
                return null;
            }
        } else if (!(BasicDeclarationParser.isRecordToken(builder, tokenType) || BasicDeclarationParser.isSealedToken(builder, tokenType) || BasicDeclarationParser.isNonSealedToken(builder, tokenType) || this.TYPE_START.contains(tokenType) && tokenType != JavaTokenType.AT)) {
            if (tokenType instanceof ILazyParseableElementType) {
                builder.advanceLexer();
                return null;
            }
            if (!(BasicElementTypes.BASIC_MODIFIER_BIT_SET.contains(tokenType) || BasicElementTypes.BASIC_CLASS_KEYWORD_BIT_SET.contains(tokenType) || tokenType == JavaTokenType.AT || context != BaseContext.CODE_BLOCK && tokenType == JavaTokenType.LT)) {
                return null;
            }
        }
        PsiBuilder.Marker declaration = builder.mark();
        int declarationStart = builder.getCurrentOffset();
        Pair<PsiBuilder.Marker, Boolean> modListInfo = this.parseModifierList(builder);
        PsiBuilder.Marker modList = (PsiBuilder.Marker)modListInfo.first;
        if (PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.AT)) {
            if (builder.getTokenType() == JavaTokenType.INTERFACE_KEYWORD) {
                PsiBuilder.Marker result = this.parseClassFromKeyword(builder, declaration, true, context);
                return result != null ? result : modList;
            }
            declaration.rollbackTo();
            return null;
        }
        if (BasicElementTypes.BASIC_CLASS_KEYWORD_BIT_SET.contains(builder.getTokenType()) || BasicDeclarationParser.isRecordToken(builder, builder.getTokenType())) {
            PsiBuilder.Marker result = this.parseClassFromKeyword(builder, declaration, false, context);
            return result != null ? result : modList;
        }
        PsiBuilder.Marker typeParams = null;
        if (builder.getTokenType() == JavaTokenType.LT && context != BaseContext.CODE_BLOCK) {
            typeParams = this.myParser.getReferenceParser().parseTypeParameters(builder);
        }
        if (builder.getTokenType() == JavaTokenType.LBRACE) {
            if (context == BaseContext.CODE_BLOCK) {
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.identifier.or.type", new Object[0]), null);
                declaration.drop();
                return modList;
            }
            PsiBuilder.Marker codeBlock = this.myParser.getStatementParser().parseCodeBlock(builder);
            assert (codeBlock != null) : builder.getOriginalText();
            if (typeParams != null) {
                PsiBuilder.Marker error = typeParams.precede();
                error.errorBefore(JavaPsiBundle.message("unexpected.token", new Object[0]), codeBlock);
            }
            BasicJavaParserUtil.done(declaration, this.myJavaElementTypeContainer.CLASS_INITIALIZER, this.myWhiteSpaceAndCommentSetHolder);
            return declaration;
        }
        BasicReferenceParser.TypeInfo type = null;
        if (this.TYPE_START.contains(builder.getTokenType())) {
            PsiBuilder.Marker pos = builder.mark();
            int flags = 5;
            if (context == BaseContext.CODE_BLOCK) {
                flags |= 0x80;
            }
            if ((type = this.myParser.getReferenceParser().parseTypeInfo(builder, flags)) == null) {
                pos.rollbackTo();
            } else {
                if (builder.getTokenType() == JavaTokenType.LPARENTH || builder.getTokenType() == JavaTokenType.LBRACE) {
                    if (context == BaseContext.CODE_BLOCK) {
                        declaration.rollbackTo();
                        return null;
                    }
                    pos.rollbackTo();
                    if (typeParams == null) {
                        BasicJavaParserUtil.emptyElement(builder, this.myJavaElementTypeContainer.TYPE_PARAMETER_LIST);
                    }
                    this.parseAnnotations(builder);
                    if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.IDENTIFIER)) {
                        PsiBuilder.Marker primitive = builder.mark();
                        builder.advanceLexer();
                        primitive.error(JavaPsiBundle.message("expected.identifier", new Object[0]));
                    }
                    if (builder.getTokenType() == JavaTokenType.LPARENTH) {
                        return this.parseMethodFromLeftParenth(builder, declaration, false, true);
                    }
                    if (builder.getTokenType() == JavaTokenType.LBRACE) {
                        BasicJavaParserUtil.emptyElement(builder, this.myJavaElementTypeContainer.THROWS_LIST);
                        return this.parseMethodBody(builder, declaration, false);
                    }
                    declaration.rollbackTo();
                    return null;
                }
                pos.drop();
            }
        }
        if (type == null) {
            PsiBuilder.Marker error = typeParams != null ? typeParams.precede() : builder.mark();
            error.error(JavaPsiBundle.message("expected.identifier.or.type", new Object[0]));
            declaration.drop();
            return modList;
        }
        if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.IDENTIFIER)) {
            if (context != BaseContext.CODE_BLOCK || Boolean.FALSE.equals(modListInfo.second) || type.isPrimitive && builder.getTokenType() != JavaTokenType.DOT) {
                if (typeParams != null) {
                    typeParams.precede().errorBefore(JavaPsiBundle.message("unexpected.token", new Object[0]), type.marker);
                }
                builder.error(JavaPsiBundle.message("expected.identifier", new Object[0]));
                declaration.drop();
                return modList;
            }
            declaration.rollbackTo();
            return null;
        }
        if (builder.getTokenType() == JavaTokenType.LPARENTH && (context == BaseContext.CLASS || context == BaseContext.ANNOTATION_INTERFACE || context == BaseContext.FILE)) {
            if (typeParams == null) {
                BasicJavaParserUtil.emptyElement(type.marker, this.myJavaElementTypeContainer.TYPE_PARAMETER_LIST);
            }
            return this.parseMethodFromLeftParenth(builder, declaration, context == BaseContext.ANNOTATION_INTERFACE, false);
        }
        if (typeParams != null) {
            typeParams.precede().errorBefore(JavaPsiBundle.message("unexpected.token", new Object[0]), type.marker);
        }
        return this.parseFieldOrLocalVariable(builder, declaration, declarationStart, context);
    }

    static boolean isRecordToken(PsiBuilder builder, IElementType tokenType) {
        if (tokenType == JavaTokenType.IDENTIFIER && "record".equals(builder.getTokenText()) && builder.lookAhead(1) == JavaTokenType.IDENTIFIER) {
            LanguageLevel level = BasicJavaParserUtil.getLanguageLevel(builder);
            return JavaFeature.RECORDS.isSufficient(level);
        }
        return false;
    }

    private static boolean isSealedToken(PsiBuilder builder, IElementType tokenType) {
        return JavaFeature.SEALED_CLASSES.isSufficient(BasicJavaParserUtil.getLanguageLevel(builder)) && tokenType == JavaTokenType.IDENTIFIER && "sealed".equals(builder.getTokenText());
    }

    static boolean isNonSealedToken(PsiBuilder builder, IElementType tokenType) {
        if (!JavaFeature.SEALED_CLASSES.isSufficient(BasicJavaParserUtil.getLanguageLevel(builder)) || tokenType != JavaTokenType.IDENTIFIER || !"non".equals(builder.getTokenText()) || builder.lookAhead(1) != JavaTokenType.MINUS || builder.lookAhead(2) != JavaTokenType.IDENTIFIER) {
            return false;
        }
        PsiBuilder.Marker maybeNonSealed = builder.mark();
        PsiBuilderUtil.advance((PsiBuilder)builder, (int)2);
        boolean isNonSealed = "sealed".equals(builder.getTokenText());
        maybeNonSealed.rollbackTo();
        return isNonSealed;
    }

    @NotNull
    public Pair<PsiBuilder.Marker, Boolean> parseModifierList(PsiBuilder builder) {
        return this.parseModifierList(builder, BasicElementTypes.BASIC_MODIFIER_BIT_SET);
    }

    @NotNull
    public Pair<PsiBuilder.Marker, Boolean> parseModifierList(PsiBuilder builder, TokenSet modifiers) {
        IElementType tokenType;
        PsiBuilder.Marker modList = builder.mark();
        boolean isEmpty = true;
        while ((tokenType = builder.getTokenType()) != null) {
            if (BasicDeclarationParser.isSealedToken(builder, tokenType)) {
                builder.remapCurrentToken(JavaTokenType.SEALED_KEYWORD);
                tokenType = JavaTokenType.SEALED_KEYWORD;
            }
            if (BasicDeclarationParser.isNonSealedToken(builder, tokenType)) {
                PsiBuilder.Marker nonSealed = builder.mark();
                PsiBuilderUtil.advance((PsiBuilder)builder, (int)3);
                nonSealed.collapse(JavaTokenType.NON_SEALED_KEYWORD);
                isEmpty = false;
                continue;
            }
            if (modifiers.contains(tokenType)) {
                builder.advanceLexer();
                isEmpty = false;
                continue;
            }
            if (tokenType != JavaTokenType.AT || BasicElementTypes.BASIC_KEYWORD_BIT_SET.contains(builder.lookAhead(1))) break;
            this.parseAnnotation(builder);
            isEmpty = false;
        }
        BasicJavaParserUtil.done(modList, this.myJavaElementTypeContainer.MODIFIER_LIST, this.myWhiteSpaceAndCommentSetHolder);
        return Pair.create((Object)modList, (Object)isEmpty);
    }

    private PsiBuilder.Marker parseMethodFromLeftParenth(PsiBuilder builder, PsiBuilder.Marker declaration, boolean anno, boolean constructor) {
        this.parseParameterList(builder);
        this.eatBrackets(builder, constructor ? "expected.lbrace" : null);
        this.myParser.getReferenceParser().parseReferenceList(builder, JavaTokenType.THROWS_KEYWORD, this.myJavaElementTypeContainer.THROWS_LIST, JavaTokenType.COMMA);
        if (anno && PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.DEFAULT_KEYWORD) && this.parseAnnotationValue(builder) == null) {
            BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.value", new Object[0]));
        }
        return this.parseMethodBody(builder, declaration, anno);
    }

    @NotNull
    private PsiBuilder.Marker parseMethodBody(PsiBuilder builder, PsiBuilder.Marker declaration, boolean anno) {
        IElementType tokenType = builder.getTokenType();
        if (tokenType != JavaTokenType.SEMICOLON && tokenType != JavaTokenType.LBRACE) {
            PsiBuilder.Marker error = builder.mark();
            CharSequence text = builder.getOriginalText();
            block0: do {
                for (int i = builder.getCurrentOffset() - 1; i >= 0; --i) {
                    char ch = text.charAt(i);
                    if (ch == '\n') break block0;
                    if (ch != ' ' && ch != '\t') continue block0;
                }
            } while (PsiBuilderUtil.expect((PsiBuilder)builder, (TokenSet)APPEND_TO_METHOD_SET));
            error.error(JavaPsiBundle.message("expected.lbrace.or.semicolon", new Object[0]));
        }
        if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.SEMICOLON) && builder.getTokenType() == JavaTokenType.LBRACE) {
            this.myParser.getStatementParser().parseCodeBlock(builder);
        }
        BasicJavaParserUtil.done(declaration, anno ? this.myJavaElementTypeContainer.ANNOTATION_METHOD : this.myJavaElementTypeContainer.METHOD, this.myWhiteSpaceAndCommentSetHolder);
        return declaration;
    }

    public void parseParameterList(PsiBuilder builder) {
        this.parseElementList(builder, ListType.METHOD);
    }

    public void parseResourceList(PsiBuilder builder) {
        this.parseElementList(builder, ListType.RESOURCE);
    }

    public void parseLambdaParameterList(PsiBuilder builder, boolean typed) {
        this.parseElementList(builder, typed ? ListType.LAMBDA_TYPED : ListType.LAMBDA_UNTYPED);
    }

    private void parseElementList(PsiBuilder builder, ListType type) {
        boolean lambda = type == ListType.LAMBDA_TYPED || type == ListType.LAMBDA_UNTYPED;
        boolean resources = type == ListType.RESOURCE;
        PsiBuilder.Marker elementList = builder.mark();
        boolean leftParenth = PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.LPARENTH);
        assert (lambda || leftParenth) : builder.getTokenType();
        IElementType delimiter = resources ? JavaTokenType.SEMICOLON : JavaTokenType.COMMA;
        String noDelimiterMsg = resources ? "expected.semicolon" : "expected.comma";
        String noElementMsg = resources ? "expected.resource" : "expected.parameter";
        PsiBuilder.Marker invalidElements = null;
        String errorMessage = null;
        boolean delimiterExpected = false;
        boolean noElements = true;
        while (true) {
            PsiBuilder.Marker ref;
            IElementType tokenType;
            if ((tokenType = builder.getTokenType()) == null || type.getStopperTypes().contains(tokenType)) {
                boolean noLastElement;
                boolean bl = noLastElement = !delimiterExpected && (!noElements && !resources || noElements && resources);
                if (noLastElement) {
                    String key = lambda ? "expected.parameter" : "expected.identifier.or.type";
                    BasicJavaParserUtil.error(builder, JavaPsiBundle.message(key, new Object[0]));
                }
                if (tokenType == JavaTokenType.RPARENTH) {
                    if (invalidElements != null) {
                        invalidElements.error(errorMessage);
                        invalidElements = null;
                    }
                    builder.advanceLexer();
                    break;
                }
                if (noLastElement && !resources) break;
                if (invalidElements != null) {
                    invalidElements.error(errorMessage);
                }
                invalidElements = null;
                if (!leftParenth) break;
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.rparen", new Object[0]));
                break;
            }
            if (delimiterExpected) {
                if (builder.getTokenType() == delimiter) {
                    delimiterExpected = false;
                    if (invalidElements != null) {
                        invalidElements.error(errorMessage);
                        invalidElements = null;
                    }
                    builder.advanceLexer();
                    continue;
                }
            } else {
                PsiBuilder.Marker listElement;
                PsiBuilder.Marker marker = type == ListType.RECORD_COMPONENTS ? this.parseParameterOrRecordComponent(builder, true, false, false, false) : (resources ? this.parseResource(builder) : (lambda ? this.parseLambdaParameter(builder, type == ListType.LAMBDA_TYPED) : (listElement = this.parseParameter(builder, true, false, false))));
                if (listElement != null) {
                    delimiterExpected = true;
                    if (invalidElements != null) {
                        invalidElements.errorBefore(errorMessage, listElement);
                        invalidElements = null;
                    }
                    noElements = false;
                    continue;
                }
            }
            if (invalidElements == null) {
                if (builder.getTokenType() == delimiter) {
                    BasicJavaParserUtil.error(builder, JavaPsiBundle.message(noElementMsg, new Object[0]));
                    builder.advanceLexer();
                    if (!noElements || !resources) continue;
                    noElements = false;
                    continue;
                }
                invalidElements = builder.mark();
                errorMessage = JavaPsiBundle.message(delimiterExpected ? noDelimiterMsg : noElementMsg, new Object[0]);
            }
            if ((ref = this.myParser.getReferenceParser().parseJavaCodeReference(builder, true, true, false, false)) != null || builder.getTokenType() == null) continue;
            builder.advanceLexer();
        }
        if (invalidElements != null) {
            invalidElements.error(errorMessage);
        }
        BasicJavaParserUtil.done(elementList, type.getNodeType(this.myJavaElementTypeContainer), this.myWhiteSpaceAndCommentSetHolder);
    }

    @Nullable
    public PsiBuilder.Marker parseParameter(PsiBuilder builder, boolean ellipsis, boolean disjunctiveType, boolean varType) {
        return this.parseParameterOrRecordComponent(builder, ellipsis, disjunctiveType, varType, true);
    }

    @Nullable
    public PsiBuilder.Marker parseParameterOrRecordComponent(PsiBuilder builder, boolean ellipsis, boolean disjunctiveType, boolean varType, boolean isParameter) {
        int typeFlags = 0;
        if (ellipsis) {
            typeFlags |= 2;
        }
        if (disjunctiveType) {
            typeFlags |= 0x10;
        }
        if (varType) {
            typeFlags |= 0x80;
        }
        return this.parseListElement(builder, true, typeFlags, isParameter ? this.myJavaElementTypeContainer.PARAMETER : this.myJavaElementTypeContainer.RECORD_COMPONENT);
    }

    @Nullable
    public PsiBuilder.Marker parseResource(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        PsiBuilder.Marker expr = this.myParser.getExpressionParser().parse(builder);
        if (expr != null && this.RESOURCE_EXPRESSIONS.contains(BasicJavaParserUtil.exprType(expr)) && builder.getTokenType() != JavaTokenType.IDENTIFIER) {
            marker.done(this.myJavaElementTypeContainer.RESOURCE_EXPRESSION);
            return marker;
        }
        marker.rollbackTo();
        return this.parseListElement(builder, true, 128, this.myJavaElementTypeContainer.RESOURCE_VARIABLE);
    }

    @Nullable
    public PsiBuilder.Marker parseLambdaParameter(PsiBuilder builder, boolean typed) {
        int flags = 2;
        if (JavaFeature.VAR_LAMBDA_PARAMETER.isSufficient(BasicJavaParserUtil.getLanguageLevel(builder))) {
            flags |= 0x80;
        }
        return this.parseListElement(builder, typed, flags, this.myJavaElementTypeContainer.PARAMETER);
    }

    @Nullable
    private PsiBuilder.Marker parseListElement(PsiBuilder builder, boolean typed, int typeFlags, IElementType type) {
        IElementType tokenType;
        PsiBuilder.Marker param = builder.mark();
        Pair<PsiBuilder.Marker, Boolean> modListInfo = this.parseModifierList(builder);
        if (typed) {
            int flags = 5 | typeFlags;
            BasicReferenceParser.TypeInfo typeInfo = this.myParser.getReferenceParser().parseTypeInfo(builder, flags);
            if (typeInfo == null) {
                if (Boolean.TRUE.equals(modListInfo.second)) {
                    param.rollbackTo();
                    return null;
                }
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.type", new Object[0]));
                BasicJavaParserUtil.emptyElement(builder, this.myJavaElementTypeContainer.TYPE);
            }
        }
        if (typed && ((tokenType = builder.getTokenType()) == JavaTokenType.THIS_KEYWORD || tokenType == JavaTokenType.IDENTIFIER && builder.lookAhead(1) == JavaTokenType.DOT)) {
            PsiBuilder.Marker mark = builder.mark();
            PsiBuilder.Marker expr = this.myParser.getExpressionParser().parse(builder);
            if (expr != null && BasicJavaParserUtil.exprType(expr) == this.myJavaElementTypeContainer.THIS_EXPRESSION) {
                mark.drop();
                BasicJavaParserUtil.done(param, this.myJavaElementTypeContainer.RECEIVER_PARAMETER, this.myWhiteSpaceAndCommentSetHolder);
                return param;
            }
            mark.rollbackTo();
        }
        if (PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.IDENTIFIER)) {
            if (type == this.myJavaElementTypeContainer.PARAMETER || type == this.myJavaElementTypeContainer.RECORD_COMPONENT) {
                this.eatBrackets(builder, null);
                BasicJavaParserUtil.done(param, type, this.myWhiteSpaceAndCommentSetHolder);
                return param;
            }
        } else {
            BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.identifier", new Object[0]));
            param.drop();
            return (PsiBuilder.Marker)modListInfo.first;
        }
        if (BasicJavaParserUtil.expectOrError(builder, JavaTokenType.EQ, "expected.eq") && this.myParser.getExpressionParser().parse(builder) == null) {
            BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.expression", new Object[0]));
        }
        BasicJavaParserUtil.done(param, this.myJavaElementTypeContainer.RESOURCE_VARIABLE, this.myWhiteSpaceAndCommentSetHolder);
        return param;
    }

    @Nullable
    private PsiBuilder.Marker parseFieldOrLocalVariable(PsiBuilder builder, PsiBuilder.Marker declaration, int declarationStart, BaseContext context) {
        boolean shouldRollback;
        IElementType varType;
        if (context == BaseContext.CLASS || context == BaseContext.ANNOTATION_INTERFACE || context == BaseContext.FILE) {
            varType = this.myJavaElementTypeContainer.FIELD;
        } else if (context == BaseContext.CODE_BLOCK) {
            varType = this.myJavaElementTypeContainer.LOCAL_VARIABLE;
        } else {
            declaration.drop();
            assert (false) : "Unexpected context: " + context;
            return null;
        }
        PsiBuilder.Marker variable = declaration;
        boolean unclosed = false;
        boolean eatSemicolon = true;
        boolean openMarker = true;
        while (true) {
            shouldRollback = true;
            if (!this.eatBrackets(builder, null)) {
                unclosed = true;
            }
            if (PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.EQ)) {
                PsiBuilder.Marker expr = this.myParser.getExpressionParser().parse(builder);
                if (expr != null) {
                    shouldRollback = false;
                } else {
                    BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.expression", new Object[0]));
                    unclosed = true;
                    break;
                }
            }
            if (builder.getTokenType() != JavaTokenType.COMMA) break;
            BasicJavaParserUtil.done(variable, varType, this.myWhiteSpaceAndCommentSetHolder);
            builder.advanceLexer();
            if (builder.getTokenType() != JavaTokenType.IDENTIFIER) {
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.identifier", new Object[0]));
                unclosed = true;
                eatSemicolon = false;
                openMarker = false;
                break;
            }
            variable = builder.mark();
            builder.advanceLexer();
        }
        if (builder.getTokenType() == JavaTokenType.SEMICOLON && eatSemicolon) {
            builder.advanceLexer();
        } else {
            if (!builder.eof() && shouldRollback) {
                CharSequence text = builder.getOriginalText();
                int spaceEnd = builder.getCurrentOffset();
                int spaceStart = CharArrayUtil.shiftBackward((CharSequence)text, (int)(spaceEnd - 1), (String)WHITESPACES);
                int lineStart = CharArrayUtil.shiftBackwardUntil((CharSequence)text, (int)spaceEnd, (String)LINE_ENDS);
                if (declarationStart < lineStart && lineStart < spaceStart) {
                    int newBufferEnd = CharArrayUtil.shiftForward((CharSequence)text, (int)lineStart, (String)WHITESPACES);
                    declaration.rollbackTo();
                    return this.parse(BasicJavaParserUtil.stoppingBuilder(builder, newBufferEnd), context);
                }
            }
            if (!unclosed) {
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.semicolon", new Object[0]));
            }
        }
        if (openMarker) {
            BasicJavaParserUtil.done(variable, varType, this.myWhiteSpaceAndCommentSetHolder);
        }
        return declaration;
    }

    private boolean eatBrackets(PsiBuilder builder, @Nullable @PropertyKey(resourceBundle="messages.JavaPsiBundle") @Nullable @PropertyKey(resourceBundle="messages.JavaPsiBundle") String errorKey) {
        boolean paired;
        IElementType tokenType = builder.getTokenType();
        if (tokenType != JavaTokenType.LBRACKET && tokenType != JavaTokenType.AT) {
            return true;
        }
        PsiBuilder.Marker marker = builder.mark();
        int count = 0;
        while (true) {
            this.parseAnnotations(builder);
            if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.LBRACKET)) break;
            ++count;
            if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.RBRACKET)) break;
            ++count;
        }
        if (count == 0) {
            marker.rollbackTo();
            return true;
        }
        if (errorKey != null) {
            marker.error(JavaPsiBundle.message(errorKey, new Object[0]));
        } else {
            marker.drop();
        }
        boolean bl = paired = count % 2 == 0;
        if (!paired) {
            BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.rbracket", new Object[0]));
        }
        return paired;
    }

    @Nullable
    public PsiBuilder.Marker parseAnnotations(PsiBuilder builder) {
        PsiBuilder.Marker firstAnno = null;
        while (builder.getTokenType() == JavaTokenType.AT) {
            PsiBuilder.Marker anno = this.parseAnnotation(builder);
            if (firstAnno != null) continue;
            firstAnno = anno;
        }
        return firstAnno;
    }

    @NotNull
    public PsiBuilder.Marker parseAnnotation(PsiBuilder builder) {
        assert (builder.getTokenType() == JavaTokenType.AT) : builder.getTokenType();
        PsiBuilder.Marker anno = builder.mark();
        builder.advanceLexer();
        PsiBuilder.Marker classRef = null;
        if (builder.getTokenType() == JavaTokenType.IDENTIFIER) {
            classRef = this.myParser.getReferenceParser().parseJavaCodeReference(builder, true, false, false, false);
        }
        if (classRef == null) {
            BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.class.reference", new Object[0]));
        }
        this.parseAnnotationParameterList(builder);
        BasicJavaParserUtil.done(anno, this.myJavaElementTypeContainer.ANNOTATION, this.myWhiteSpaceAndCommentSetHolder);
        return anno;
    }

    private void parseAnnotationParameterList(PsiBuilder builder) {
        PsiBuilder.Marker list = builder.mark();
        if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.LPARENTH) || PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.RPARENTH)) {
            BasicJavaParserUtil.done(list, this.myJavaElementTypeContainer.ANNOTATION_PARAMETER_LIST, this.myWhiteSpaceAndCommentSetHolder);
            return;
        }
        if (builder.getTokenType() == null) {
            BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.parameter.or.rparen", new Object[0]));
            BasicJavaParserUtil.done(list, this.myJavaElementTypeContainer.ANNOTATION_PARAMETER_LIST, this.myWhiteSpaceAndCommentSetHolder);
            return;
        }
        PsiBuilder.Marker elementMarker = this.parseAnnotationElement(builder);
        while (true) {
            IElementType tokenType;
            if ((tokenType = builder.getTokenType()) == null) {
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message(elementMarker == null ? "expected.parameter.or.rparen" : "expected.comma.or.rparen", new Object[0]));
                break;
            }
            if (PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.RPARENTH)) break;
            if (tokenType == JavaTokenType.COMMA) {
                builder.advanceLexer();
                elementMarker = this.parseAnnotationElement(builder);
                if (elementMarker != null) continue;
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("annotation.name.is.missing", new Object[0]));
                tokenType = builder.getTokenType();
                if (tokenType == JavaTokenType.COMMA || tokenType == JavaTokenType.RPARENTH) continue;
                break;
            }
            BasicJavaParserUtil.error(builder, JavaPsiBundle.message(elementMarker == null ? "expected.parameter.or.rparen" : "expected.comma.or.rparen", new Object[0]));
            tokenType = builder.lookAhead(1);
            if (tokenType != JavaTokenType.COMMA && tokenType != JavaTokenType.RPARENTH) break;
            builder.advanceLexer();
        }
        BasicJavaParserUtil.done(list, this.myJavaElementTypeContainer.ANNOTATION_PARAMETER_LIST, this.myWhiteSpaceAndCommentSetHolder);
    }

    private PsiBuilder.Marker parseAnnotationElement(PsiBuilder builder) {
        PsiBuilder.Marker pair = builder.mark();
        PsiBuilder.Marker valueMarker = this.parseAnnotationValue(builder);
        if (valueMarker == null && builder.getTokenType() != JavaTokenType.EQ) {
            pair.drop();
            return null;
        }
        if (builder.getTokenType() != JavaTokenType.EQ) {
            BasicJavaParserUtil.done(pair, this.myJavaElementTypeContainer.NAME_VALUE_PAIR, this.myWhiteSpaceAndCommentSetHolder);
            return pair;
        }
        pair.rollbackTo();
        pair = builder.mark();
        BasicJavaParserUtil.expectOrError(builder, JavaTokenType.IDENTIFIER, "expected.identifier");
        PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.EQ);
        valueMarker = this.parseAnnotationValue(builder);
        if (valueMarker == null) {
            BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.value", new Object[0]));
        }
        BasicJavaParserUtil.done(pair, this.myJavaElementTypeContainer.NAME_VALUE_PAIR, this.myWhiteSpaceAndCommentSetHolder);
        return pair;
    }

    @Nullable
    public PsiBuilder.Marker parseAnnotationValue(PsiBuilder builder) {
        IElementType tokenType = builder.getTokenType();
        if (tokenType == JavaTokenType.AT) {
            return this.parseAnnotation(builder);
        }
        if (tokenType == JavaTokenType.LBRACE) {
            return this.myParser.getExpressionParser().parseArrayInitializer(builder, this.myJavaElementTypeContainer.ANNOTATION_ARRAY_INITIALIZER, this::parseAnnotationValue, "expected.value");
        }
        return this.myParser.getExpressionParser().parseConditional(builder);
    }

    public static enum BaseContext {
        FILE,
        CLASS,
        CODE_BLOCK,
        ANNOTATION_INTERFACE;

    }

    private static enum ListType {
        METHOD,
        RESOURCE,
        LAMBDA_TYPED,
        LAMBDA_UNTYPED,
        RECORD_COMPONENTS;


        IElementType getNodeType(AbstractBasicJavaElementTypeFactory.JavaElementTypeContainer javaElementTypeContainer) {
            if (this == RESOURCE) {
                return javaElementTypeContainer.RESOURCE_LIST;
            }
            if (this == RECORD_COMPONENTS) {
                return javaElementTypeContainer.RECORD_HEADER;
            }
            return javaElementTypeContainer.PARAMETER_LIST;
        }

        TokenSet getStopperTypes() {
            if (this == METHOD) {
                return METHOD_PARAM_LIST_STOPPERS;
            }
            return PARAM_LIST_STOPPERS;
        }
    }
}

