/*
 * Decompiled with CFR 0.152.
 */
package fleet.workspace.lsp;

import fleet.util.StringKt;
import fleet.workspace.lsp.MarkupRenderer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.eclipse.lsp4j.MarkupContent;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.flavours.MarkdownFlavourDescriptor;
import org.intellij.markdown.flavours.commonmark.CommonMarkFlavourDescriptor;
import org.intellij.markdown.html.HtmlGenerator;
import org.intellij.markdown.parser.MarkdownParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u000e\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lfleet/workspace/lsp/MarkupRenderer;", "", "()V", "flavour", "Lorg/intellij/markdown/flavours/commonmark/CommonMarkFlavourDescriptor;", "style", "", "tagRegex", "Lkotlin/text/Regex;", "getTagRegex", "()Lkotlin/text/Regex;", "tagRegex$delegate", "Lkotlin/Lazy;", "render", "content", "Lorg/eclipse/lsp4j/MarkupContent;", "renderHtml", "renderMarkdown", "markdown", "includeStyle", "", "fleet.lsp"})
public final class MarkupRenderer {
    @NotNull
    public static final MarkupRenderer INSTANCE = new MarkupRenderer();
    @NotNull
    private static final CommonMarkFlavourDescriptor flavour = new CommonMarkFlavourDescriptor(false, false, 3, null);
    @NotNull
    private static final String style = "h1 {\n  font-size: 1.2em;\n}";
    @NotNull
    private static final Lazy tagRegex$delegate = LazyKt.lazy((Function0)tagRegex.2.INSTANCE);

    private MarkupRenderer() {
    }

    private final Regex getTagRegex() {
        Lazy lazy = tagRegex$delegate;
        return (Regex)lazy.getValue();
    }

    @NotNull
    public final String render(@Nullable MarkupContent content) {
        String string;
        String string2;
        MarkupContent markupContent = content;
        String string3 = string2 = markupContent != null ? markupContent.getKind() : null;
        if (string2 == null) {
            string = "";
        } else if (Intrinsics.areEqual((Object)string2, (Object)"markdown")) {
            String string4 = content.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getValue(...)");
            string = this.renderMarkdown(string4, false);
        } else {
            string = content.getValue();
        }
        CharSequence charSequence = string;
        Intrinsics.checkNotNull((Object)charSequence);
        charSequence = charSequence;
        string2 = this.getTagRegex();
        String string5 = "";
        return StringKt.unescapeHtml((String)string2.replace(charSequence, string5));
    }

    @NotNull
    public final String renderHtml(@NotNull MarkupContent content) {
        String string;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        if (Intrinsics.areEqual((Object)content.getKind(), (Object)"markdown")) {
            String string2 = content.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getValue(...)");
            string = this.renderMarkdown(string2, true);
        } else {
            String string3 = content.getValue();
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getValue(...)");
        }
        return string;
    }

    private final String renderMarkdown(String markdown, boolean includeStyle) {
        ASTNode parsedTree = new MarkdownParser((MarkdownFlavourDescriptor)flavour).buildMarkdownTreeFromString(markdown);
        String body = HtmlGenerator.generateHtml$default((HtmlGenerator)new HtmlGenerator(markdown, parsedTree, (MarkdownFlavourDescriptor)flavour, false, 8, null), null, (int)1, null);
        return includeStyle ? "<html><style>" + style + "</style>" + body + "</html>" : "<html>" + body + "</html>";
    }
}

