package noria.ui.examples

import androidx.compose.foundation.layout.Row
import androidx.compose.runtime.remember
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.text.SpanStyle
import androidx.compose.ui.text.buildAnnotatedString
import androidx.compose.ui.text.withStyle
import fleet.compose.theme.components.*
import fleet.compose.theme.components.gallery.Gallery
import fleet.compose.theme.components.gallery.gallery
import fleet.compose.theme.text.*

internal fun trimmedTextExamples(): Gallery {
  return gallery("TrimmedText", NoriaExamples.sourceCodeForFile("TrimmedText.kt")) {
    example("TextWithVisiblieRegion") {
      UiText(text = buildAnnotatedString {
        append("Some text with an [")
        withAlwaysVisible {
          withStyle(SpanStyle(Color.Green)) {
            append("ellipsis")
          }
        }
        append("] in the end and underscored")
      }, trim = Trim.CenterVisibleRegion)
    }

    example("TextWithVisiblieRegion At The End") {
      UiText(text = buildAnnotatedString {
        append("Some text with an [")
        withAlwaysVisible {
          withStyle(SpanStyle(Color.Green)) {
            append("ellipsis")
          }
        }
      }, trim = Trim.CenterVisibleRegion)
    }

    example("TextWithVisiblieRegion BaseLine") {
      val text = buildAnnotatedString {
        append("Some text with an [")
        withAlwaysVisible {
          withStyle(SpanStyle(Color.Green)) {
            append("ellipsis")
          }
        }
      }
      Row {
        UiText(text)
        UiText(text, trim = Trim.CenterVisibleRegion)
      }
    }

    example("TextWithVisiblieRegion Very Long Text") {
      val text = remember {
        buildAnnotatedString {
          repeat(1000) {
            append("before!")
          }
          append("Some text with an [")
          withAlwaysVisible {
            withStyle(SpanStyle(Color.Green)) {
              append("ellipsis")
            }
          }
          append("] in the end and underscored")
          repeat(1000) {
            append("after!")
          }
        }
      }
      UiText(text, trim = Trim.CenterVisibleRegion)
    }

    example("Ellipsis At The Start") {
      UiText("Some reasonably long Text with ellipsis at the start should be here",
             paragraphStyle = NoriaParagraphStyle(alignment = NoriaTextAlignment.RIGHT,
                                                  ellipsis = "…",
                                                  maxLinesCount = 1))
    }

    example("Trimmed Text With Middle Ellipsis") {
      UiText(buildAnnotatedString { append("Some reasonably long Text with ellipsis at the start should be here") }, trim = Trim.Middle)
    }

    example("Trimmed Text With Start Ellipsis") {
      UiText(buildAnnotatedString { append("Some reasonably long Text with ellipsis at the start should be here") },
             trim = Trim.Start)
    }
  }
}
