package noria.ui.examples

import androidx.compose.foundation.border
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.size
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.unit.dp
import fleet.compose.theme.components.Thickness
import fleet.compose.theme.components.UiText
import fleet.compose.theme.components.buildStringWithMatcher
import fleet.compose.theme.components.gallery.Gallery
import fleet.compose.theme.components.gallery.gallery
import fleet.compose.theme.components.itemCellColors
import noria.ui.components.list.SpeedSearchOptions
import noria.ui.components.tree.*
import fleet.compose.theme.text.NoriaParagraphStyle
import noria.ui.withModifier

internal fun treeViewGallery(): Gallery {
  return gallery("Tree View", NoriaExamples.sourceCodeForFile("Tree.kt")) {
    example("Tree") {
      fun emitNode(key: Int): TreeItem<Int> {
        return TreeItem(
          key = key,
          item = key,
          expandable = true,
          children = {
            (1..5).map { i -> emitNode(i) }
          }
        ) { path, opts ->
          TreeItemDecoration(
            treePath = path,
            opts = opts,
            cellColors = { itemCellColors(it) },
            modifier = defaultTreeItemDecorationModifier(),
            rightContent = {
              UiText("X")
            }
          ) { _, _, colors ->
            UiText(key.toString(), colors.text, modifier = Modifier.border(Thickness.Regular, Color.Red))
          }
        }
      }

      withModifier(Modifier.size(width = 500.dp, height = 500.dp)) {
        treeView(treeModel(emitNode(0), options = TreeViewOptions(multiSelectionEnabled = true, toggleOnClick = true)))
      }
    }

    example("Tree without Automatic Cursor Selection") {
      fun emitNode(key: Int): TreeItem<Int> {
        return TreeItem(
          key = key,
          item = key,
          expandable = true,
          children = {
            (1..5).map { i -> emitNode(i) }
          }
        ) { path, opts ->
          TreeItemDecoration(
            treePath = path,
            opts = opts,
            cellColors = { itemCellColors(opts).copy(border = Color.Red) },
            modifier = defaultTreeItemDecorationModifier(),
            rightContent = {
              UiText("X")
            }
          ) { _, _, _ ->
            UiText(key.toString(), modifier = Modifier.border(Thickness.Regular, Color.Red))
          }
        }
      }

      withModifier(Modifier.size(width = 500.dp, height = 500.dp)) {
        treeView(treeModel(emitNode(0), TreeViewOptions(updateSelectionWithCursor = false)))
      }
    }

    /**
     * to allow that provide height key to items
     */

    /**
     * to allow that provide height key to items
     */

    /**
     * to allow that provide height key to items
     */

    /**
     * to allow that provide height key to items
     */
    example("Tree with Items of Different Height") {
      fun emitNode(key: Int): TreeItem<Int> {
        val even = key % 2 == 0
        return TreeItem(
          key = key,
          item = key,
          heightKey = even,
          expandable = true,
          children = {
            (1..5).map { i -> emitNode(i) }
          }
        ) { path, opts ->
          TreeItemDecoration(
            treePath = path,
            opts = opts,
            cellColors = { itemCellColors(it) },
            modifier = defaultTreeItemDecorationModifier(),
            rightContent = {
              UiText("X")
            }
          ) { _, _, _ ->
            val height = if (even) {
              40.dp
            }
            else {
              20.dp
            }
            UiText(key.toString(), modifier = Modifier
              .border(Thickness.Regular, Color.Red)
              .height(height = height)
            )
          }
        }
      }

      withModifier(Modifier.size(width = 500.dp, height = 500.dp)) {
        treeView(treeModel(emitNode(0)))
      }
    }
    example("Tree with SpeedSearch") {
      fun emitNode(key: Int): TreeItem<Int> {
        return TreeItem(
          key = key,
          item = key,
          expandable = true,
          textToMatch = key.toString(),
          children = {
            (1..5).map { i -> emitNode(i) }
          }
        ) { path, opts ->
          TreeItemDecoration(
            treePath = path,
            opts = opts,
            cellColors = { itemCellColors(it) },
            modifier = defaultTreeItemDecorationModifier(),
            rightContent = {
              UiText("X")
            }
          ) { _, _, _ ->
            UiText(buildStringWithMatcher(key.toString(), matcher = opts.matcher,),
                   paragraphStyle = NoriaParagraphStyle.multiline,
                   modifier = Modifier
                     .border(Thickness.Regular, Color.Red))
          }
        }
      }

      withModifier(Modifier.size(width = 500.dp, height = 500.dp)) {
        treeView(treeModel(emitNode(0), options = TreeViewOptions(speedSearchOptions = SpeedSearchOptions.Default())))
      }
    }
  }
}
