package noria.ui.examples

import fleet.compose.theme.components.gallery.Gallery

object NoriaExamples {
  fun noriaExamples(): List<Gallery> = listOf(
    composeIntrinsicsExamples(),
    composeTextExamples(),
    composeAlignmentLinesExamples(),
    composePointerInputModifiersExamples(),
    composeModifiersExamples(),
    composeLayoutExamples(),
    composeLazyLayoutExamples(),
    composeBlendModesGallery(),
    composeRuntimeExamples(),
    composeImageExamples(),
    rainbowList(),
    colorSparks(),
    enhance(),
    tableViewExamples(),
    notebookExample(),
    layoutExamples(),
    textExamples(),
    typographyExamples(),
    bannersExamples(),
    buttonExamples(),
    linksExamples(),
    toastExamples(),
    toolbarExamples(),
    checkboxExamples(),
    comboBoxExamples(),
    textInputExamples(),
    reactivityExamples(),
    componentsExamples(),
    popupExamples(),
    contextMenuTestExamples(),
    animationExamples(),
    progressExamples(),
    segmentedControlExamples(),
    shadowExamples(),
    borderExamples(),
    alertsExamples(),
    listViewGallery(),
    listLazyApproximationExamples(),
    listIncrementalScrollExamples(),
    treeViewGallery(),
    editorViewGallery(),
    splitExamples(),
    lazyConstraint(),
    lottieExample(),
    tooltipExamples(),
    scrollPreserverExamples(),
    nestedScrollingExamples(),
    focusTraversalExamples(),
    renderPerformanceExamples(),
    shaderExample(),
    htmlExample(),
    windowManagerExamples(),
    trimmedTextExamples()
  ).sortedBy { it.name }

  internal fun sourceCodeForFile(fileName: String): () -> String? {
    return {
      NoriaExamples::class.java.module.getResourceAsStream("/noria/ui/examples/$fileName")?.readAllBytes()?.decodeToString()
    }
  }
}